/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libmt_client.h>
#include "gui.h"
#include "defs.h"
#include "player.h"
#include "gui_sort_card.h"
#include "config_utils.h"


static GtkWidget *win;
static GtkWidget *entry;




static void
display_error (GError * error)
{
  GtkWidget *wid;

  wid = gtk_message_dialog_new (GTK_WINDOW (gui_mainwin),
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_ERROR,
				GTK_BUTTONS_CLOSE,
				_("Error when saving %s :\n\n%s"),
				config->config_file_name, error->message);
  gtk_dialog_run (GTK_DIALOG (wid));
  gtk_widget_destroy (wid);
}








static void
store_filename (GtkFileSelection *file_selector, gpointer user_data)
{
  GError *error;

  if (!config->config_file_name)
    g_free (config->config_file_name);

  config->config_file_name =
    g_strdup (gtk_file_selection_get_filename (GTK_FILE_SELECTION (user_data)));

  if (config_write (&error))
    {
      display_error (error);
    }
}


void gui_save_config  (void) {

   GtkWidget *file_selector;

   /* Create the selector */
   
   file_selector = gtk_file_selection_new ("Please select a file for editing.");

  if ((config->config_file_name) &&
      (!strcmp (config->config_file_name, CONFIGFILENAME)))
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (file_selector),
				     "./mt_gtk_client.xml");
  else
    gtk_file_selection_set_filename (GTK_FILE_SELECTION (file_selector),
				     config->config_file_name);
   
   g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->ok_button),
                     "clicked",
                     G_CALLBACK (store_filename),
                     (gpointer) file_selector);
   			   
   /* Ensure that the dialog box is destroyed when the user clicks a button. */
   
   g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->ok_button),
                             "clicked",
                             G_CALLBACK (gtk_widget_destroy),
                             (gpointer) file_selector);

   g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->cancel_button),
                             "clicked",
                             G_CALLBACK (gtk_widget_destroy),
                             (gpointer) file_selector); 
   
   /* Display that dialog */
   
   gtk_widget_show (file_selector);
}






/* Background Color options */
void
gui_set_bg_color (void)
{
  GtkColorSelectionDialog *wid;
  GdkColor color;
  gint i;

  wid =
    GTK_COLOR_SELECTION_DIALOG (gtk_color_selection_dialog_new
				("Background Color"));

  gdk_color_parse (config->gui_layout_bg_color->str, &color);
  gtk_color_selection_set_current_color (GTK_COLOR_SELECTION (wid->colorsel),
					 &color);

  gtk_dialog_run (GTK_DIALOG (wid));

  gtk_color_selection_get_current_color (GTK_COLOR_SELECTION (wid->colorsel),
					 &color);
  g_string_printf (config->gui_layout_bg_color, "#%X%X%X", color.red,
		   color.green, color.blue);

  gdk_color_parse (config->gui_layout_bg_color->str, &color);

  gtk_widget_modify_bg (GTK_WIDGET (gui_layout), GTK_STATE_NORMAL, &color);

  for (i = 0; i < NUMBER_OF_CARD + 1; i++)
    {

      gtk_widget_modify_bg (GTK_WIDGET (gui_card_img[i]), GTK_STATE_NORMAL,
			    &color);
    }

  gtk_widget_destroy (GTK_WIDGET (wid));
}




/* Geometry options */
static void
valide_line_geometry (GtkButton * button, gpointer data)
{
  g_string_printf (config->gui_geometry, "%s",
		   gtk_entry_get_text (GTK_ENTRY (entry)));

  if (gtk_window_parse_geometry
      (GTK_WINDOW (gui_mainwin), config->gui_geometry->str))
    gtk_widget_destroy (win);
}



void
gui_set_geometry (void)
{
  GtkWidget *frame;
  GtkWidget *vglob;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *wid;
  GtkAccelGroup *accel_group;
  GString *st;

  /* Top window */
  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (win), "Maitretarot GTK+ Client");

  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (win), accel_group);

  /* Global verticale box */
  vglob = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (win), vglob);
  gtk_container_set_border_width (GTK_CONTAINER (vglob), 5);

  /* Program line */
  frame = gtk_frame_new (_("Geometry"));
  gtk_box_pack_start (GTK_BOX (vglob), frame, FALSE, FALSE, 5);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  entry = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (entry), config->gui_geometry->str);
  gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 5);

  st = g_string_new ("");
  g_string_printf (st, _("Actual geometry : %s"),
		   config->gui_info_geometry->str);
  wid = gtk_label_new (st->str);
  gtk_box_pack_start (GTK_BOX (vbox), wid, FALSE, FALSE, 5);
  g_string_free (st, TRUE);

  /* Validate buttons */
  hbox = gtk_hbox_new (TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vglob), hbox, FALSE, FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

  wid = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (wid, "clicked", G_CALLBACK (valide_line_geometry), NULL);

  gtk_widget_add_accelerator (wid, "clicked", accel_group,
			      GDK_Return, 0, GTK_ACCEL_VISIBLE);

  wid = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (wid, "clicked", G_CALLBACK (gtk_widget_destroy),
			    win);

  gtk_widget_add_accelerator (wid, "clicked", accel_group,
			      GDK_Escape, 0, GTK_ACCEL_VISIBLE);


  gtk_widget_show_all (win);
}
