/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <mt_client.h>
#include "player.h"
#include "defs.h"
#include "gui.h"




void
player_client_redraw_frame_name (libmt_client_player_t * player, gint width, gint height)
{
  GtkRequisition req;
  gint i, posx, posy;

  /* frame for displaying names */
  for (i = 0; i < player->nb_player; i++)
    {
      gtk_widget_size_request (GTK_WIDGET (player_frame[i]), &req);

      switch (i)
	{
	case 0:
	  posx = width / 2 - req.width / 2;
	  posy = height - gui_card_height - 5 - req.height - 5;
	  break;
	case 1:
	  posx = 5;
	  posy = height / 2 - req.height / 2 - gui_card_height / 2;
	  break;
	case 2:
	  posx = width / 2 - req.width / 2;
	  posy = 5;
	  break;
	case 3:
	  posx = width - req.width - 5;
	  posy = height / 2 - req.height / 2 - gui_card_height / 2;
	  break;
	default:
	  posx = 200;
	  posy = 20 + 30 * i;
	  break;
	}

      gtk_layout_move (GTK_LAYOUT (gui_layout), player_frame[i], posx, posy);
    }
}


void
player_client_redraw_base (GtkWidget * win, GdkEventConfigure * evt,
			   gpointer data)
{
  gint width, height;
  gfloat px;
  gint i, ic, nb_c;
  libmt_client_player_t *player = data;


  gui_layout_get_size (evt, &width, &height);

  /* display cards */
  gui_sort_card (player->card, player->nb_hand_card);

  for (i = 0, nb_c = 0; i < player->nb_hand_card; i++)
    {
      if (player->card[i] != -1)
	nb_c += 1;
    }

  px = (gfloat) (width - gui_card_width * 2) / (player->nb_hand_card - 1);

  for (i = 0, ic = 0; i < player->nb_hand_card; i++)
    if (player->card[i] != -1)
      {
	gtk_layout_move (GTK_LAYOUT (gui_layout),
			 gui_card_img[player->card[i]],
			 (width - gui_card_width - px * (nb_c - 1)) / 2 +
			 px * ic, height - gui_card_height - 5);
	ic += 1;
      }

  player_client_redraw_frame_name (player, width, height);

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}






static gint
get_taker_place (libmt_client_player_t * player)
{
  gint i;
  gint bid = 0;
  gint place = -1;

  for (i = 0; i < player->nb_player; i++)
    {
      if (LIBMT_BID_CMP (player->bid[i], bid) > 0)
	{
	  bid = player->bid[i];
	  place = i;
	}
    }

  return place;
}


static void
update_bids_draw (libmt_client_player_t * player)
{
  gint i, pl;
  gint taker_place;
  GdkEventConfigure evt;
  GdkColor color;

  taker_place = get_taker_place (player);

  for (i = 0, pl = player->place; i < player->nb_player; i++)
    {
      gtk_label_set_text (GTK_LABEL (player_label_bid[i]),
			  str_bid[player->bid[pl] + 1]);

      if (pl == taker_place)
	gdk_color_parse (config->gui_taker_bid_color->str, &color);
      else
	gdk_color_parse (config->gui_other_bid_color->str, &color);
      
      gtk_widget_modify_fg (player_label_bid[i], GTK_STATE_NORMAL, &color);

      pl += 1;
      if (pl >= player->nb_player)
	pl = 0;
    }

  gtk_window_get_size (GTK_WINDOW (gui_mainwin), &evt.width, &evt.height);
  player_client_redraw_base (gui_mainwin, &evt, player);
}




void
player_client_redraw_card_played (GtkWidget * win, GdkEventConfigure * evt,
				  gpointer data)
{
  gint width, height;
  libmt_client_player_t *player = data;
  gint i, pl;
  gint posx, posy;

  gui_layout_get_size (evt, &width, &height);

  player_client_redraw_base (win, evt, player);

  for (i = 0, pl = player->place; i < player->nb_player; i++)
    {
      if (player->card_turn[pl] != -1)
	{
	  switch (i)
	    {
	    case 0:
	      posx = (width - gui_card_width) / 2;
	      posy = (height - gui_card_height) / 2 + 5;
	      break;
	    case 1:
	      posx = (width - 3 * gui_card_width) / 2 - 5;
	      posy = height / 2 - gui_card_height;
	      break;
	    case 2:
	      posx = (width - gui_card_width) / 2;
	      posy = (height - 3 * gui_card_height) / 2 - 5;
	      break;
	    case 3:
	      posx = (width + gui_card_width) / 2 + 5;
	      posy = height / 2 - gui_card_height;
	      break;
	    default:
	      posx = 10 * i;
	      posy = 50;
	      break;
	    }
	  gtk_layout_move (GTK_LAYOUT (gui_layout),
			   gui_card_img[player->card_turn[pl]], posx, posy);
	}
      pl += 1;
      if (pl >= player->nb_player)
	pl = 0;
    }

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}



static void
redraw_start_playing (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  player_client_redraw_card_played (win, evt, data);

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}



gint
player_client_draw (libmt_client_player_t * player)
{
  switch (player->draw_state)
    {
    case LIBMT_CLIENT_DRAW_OTHER_BID:
      gdk_threads_enter ();
      gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
			  _("Please wait, an other player makes its bid."));
      update_bids_draw (player);
      gdk_threads_leave ();
      g_printerr (_("An other player makes its bid\n"));
      break;

    case LIBMT_CLIENT_DRAW_GET_BID:
      gdk_threads_enter ();
      gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
			  _("Please wait, an other player makes its bid."));
      update_bids_draw (player);
      gdk_threads_leave ();
      g_printerr (_("An other player makes its bid\n"));
      break;

    case LIBMT_CLIENT_DRAW_MAKE_CHIEN:
      gdk_threads_enter ();
      update_bids_draw (player);

      gdk_threads_leave ();
      g_printerr (_("Ready to make chien\n"));
      break;

    case LIBMT_CLIENT_DRAW_GET_CHIEN:
      gdk_threads_enter ();
      gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
			  _("Please wait, an other player makes its chien."));
      gdk_threads_leave ();
      player_client_wait_see_chien (player);
      break;

    case LIBMT_CLIENT_DRAW_START_PLAYING:
      gdk_threads_enter ();
      gui_set_redraw_func (redraw_start_playing, player);
      gui_do_redraw ();
      gdk_threads_leave ();
      g_printerr (_("Start to play!\n"));
      break;

    case LIBMT_CLIENT_DRAW_OTHER_PLAY:
      gdk_threads_enter ();
      gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
			  _("Please wait, an other player play a card."));
      gui_set_redraw_func (player_client_redraw_card_played, player);
      gui_do_redraw ();
      gdk_threads_leave ();
      g_printerr (_("An other player play a card\n"));
      break;

    case LIBMT_CLIENT_DRAW_PAUSE_END_TURN:
      player_client_wait_end_of_turn (player);
      g_printerr (_("End of turn\n"));
      break;

    case LIBMT_CLIENT_DRAW_PAUSE_END_GAME:
      player_client_wait_end_of_turn (player);
      player_client_wait_see_chien (player);
      gdk_threads_enter ();
      gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0, _("End of game"));
      gdk_threads_leave ();
      g_printerr (_("End of game\n"));
      break;

    case LIBMT_CLIENT_DRAW_NONE_TAKE:
      player_client_wait_see_chien (player);
      gdk_threads_enter ();
      gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
			  _("Nobody has taken."));
      gdk_threads_leave ();
      g_printerr (_("Nobody has take. Press space to continue\n"));
      break;
    }

  return (0);
}
