/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <mt_client.h>
#include "defs.h"
#include "gui.h"
#include "player.h"
#include "config_utils.h"


gchar *str_bid[6] = { N_("Inconnue"),
  N_("Passe"), N_("Prise"), N_("Garde"),
  N_("Garde Sans"), N_("Garde Contre")
};


GtkWidget *player_frame[MAX_PLAYER] = { NULL };
GtkWidget *player_label_bid[MAX_PLAYER];
GtkWidget *player_label_score[MAX_PLAYER];



gint
player_client_init (libmt_client_player_t * player)
{
  player->nick[0] = g_string_new (config->gui_player_name->str);

  g_printerr (player->nick[0]->str);

  gdk_threads_enter ();
  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _("Please, wait that all clients has joined the game"));

  gdk_threads_leave ();

  return (0);
}




gint
player_client_game_init (libmt_client_player_t * player)
{
  gint i, pl;
  GtkWidget *wid, *wid2;
  GString *st;

  st = g_string_new ("");

  gui_sort_card (player->card, player->nb_hand_card);

  gdk_threads_enter ();

  /* Hide cards */
  for (i = 0; i < NUMBER_OF_CARD + 1; i++)
    gtk_layout_move (GTK_LAYOUT (gui_layout),
  		     gui_card_img[i], X_HIDE, Y_HIDE);

  /* frame for displaying names */
  for (i = 0, pl = player->place; i < player->nb_player; i++)
    {
      if (player_frame[i] != NULL)
	gtk_widget_destroy (player_frame[i]);

      player_frame[i] = gtk_event_box_new ();

      wid = gtk_frame_new (NULL);
      gtk_container_add (GTK_CONTAINER (player_frame[i]), wid);
      gtk_container_set_border_width (GTK_CONTAINER (wid), 2);

      /* nick */
      if (i % 2 != 0)
	wid2 = gtk_vbox_new (FALSE, 2);
      else
	wid2 = gtk_hbox_new (FALSE, 2);
      gtk_container_add (GTK_CONTAINER (wid), wid2);
      gtk_container_set_border_width (GTK_CONTAINER (wid2), 2);

      wid = gtk_label_new (player->nick[pl]->str);
      gtk_label_set_justify (GTK_LABEL (wid), GTK_JUSTIFY_CENTER);
      gtk_box_pack_start (GTK_BOX (wid2), wid, FALSE, FALSE, 5);

      /* bid */
      if (i % 2 != 0)
	wid = gtk_hseparator_new ();
      else
	wid = gtk_vseparator_new ();
      gtk_box_pack_start (GTK_BOX (wid2), wid, FALSE, FALSE, 0);


      player_label_bid[i] = gtk_label_new (_(str_bid[player->bid[pl] + 1]));
      gtk_label_set_justify (GTK_LABEL (player_label_bid[i]),
			     GTK_JUSTIFY_CENTER);
      gtk_box_pack_start (GTK_BOX (wid2), player_label_bid[i], FALSE, FALSE,
			  5);

      /* score */
      if (i % 2 != 0)
	wid = gtk_hseparator_new ();
      else
	wid = gtk_vseparator_new ();
      gtk_box_pack_start (GTK_BOX (wid2), wid, FALSE, FALSE, 0);

      g_string_printf (st, "%d", player->score[pl]);
      player_label_score[pl] = gtk_label_new (st->str);
      gtk_label_set_justify (GTK_LABEL (player_label_score[pl]),
			     GTK_JUSTIFY_CENTER);
      gtk_box_pack_start (GTK_BOX (wid2), player_label_score[pl], FALSE,
			  FALSE, 5);

      gtk_layout_put (GTK_LAYOUT (gui_layout), player_frame[i], 10, 10);

      pl += 1;
      if (pl >= player->nb_player)
	pl = 0;
    }

  gtk_widget_show_all (gui_mainwin);

  gui_set_redraw_func (player_client_redraw_base, player);
  gui_do_redraw ();

  gdk_threads_leave ();

  g_string_free (st, TRUE);

  return (0);
}



gint
player_client_remove_card (libmt_client_player_t * player)
{
  gint i;

  for (i = 0; i < player->nb_hand_card; i++)
    if (player->card_play == player->card[i])
      player->card[i] = -1;

  return (0);
}


static void
quit_lost_connec (GtkDialog *dialog,gint arg1, gpointer user_data)
{
  gtk_main_quit ();
}



gint
player_client_lost_connection (libmt_client_player_t * player)
{
  GtkWidget * wid;

  g_printerr ("Someone have quit the game\n");

  gdk_threads_enter ();
  wid = gtk_message_dialog_new (GTK_WINDOW (gui_mainwin),
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_INFO,
				GTK_BUTTONS_CLOSE,
				"%s\n",
				_("Connection closed"));

  g_signal_connect (GTK_OBJECT (wid), "response",
		    G_CALLBACK (quit_lost_connec),
		    GTK_OBJECT (wid));


  gtk_widget_show_all (wid);
  gdk_threads_leave ();

  return 0;
}

gint
player_client_normal_close (libmt_client_player_t * player)
{
  g_printerr ("In normal_close\n");

  return 0;
}
