/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <mt_client.h>
#include "gui.h"
#include "defs.h"
#include "player.h"
#include "gui_program.h"
#include "config_utils.h"

#define _(a) a

static GtkWidget *win;
static GtkWidget *entry_name;
static GtkWidget *entry_host;
static GtkWidget *entry_port;



gint
gui_start_program ()
{
  GError *error = NULL;
  gint i;

  for (i = 0; i < 4; i++)
    g_print ("command[%d] = %s\n", i, config->gui_command[i]->str);

  error = NULL;
  g_spawn_command_line_async
    (config->gui_command[0]->str, &error);
  if (error)
    return -1;

  sleep (config->gui_command_server_delay);

  error = NULL;
  g_spawn_command_line_async
    (config->gui_command[1]->str, &error);
  if (error)
    return -1;

  error = NULL;
  g_spawn_command_line_async
    (config->gui_command[2]->str, &error);
  if (error)
    return -1;

  error = NULL;
  g_spawn_command_line_async
    (config->gui_command[3]->str, &error);
  if (error)
    return -1;

  gui_start_game ();

  return 0;
}



/* Connect to other game */
static void
response_connect (GtkDialog *dialog, gint resp, gpointer user_data)
{
  if (resp == GTK_RESPONSE_ACCEPT)
    {
      g_string_printf (config->gui_player_name, "%s",
		       gtk_entry_get_text (GTK_ENTRY (entry_name)));

      g_string_printf (config->gui_host_name, "%s",
		       gtk_entry_get_text (GTK_ENTRY (entry_host)));

      config->gui_port =
	gtk_spin_button_get_value (GTK_SPIN_BUTTON (entry_port));

      gui_start_game ();
    }

  gtk_widget_destroy (win);
}





void
gui_connect_to_other_game ()
{
  GtkWidget * gbox;
  GtkWidget * frame;

  /* Top window */
  win = gtk_dialog_new_with_buttons ("Maitretarot GTK+ Client",
				     GTK_WINDOW (gui_mainwin),
				     GTK_DIALOG_DESTROY_WITH_PARENT,
				     GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
				     GTK_STOCK_QUIT, GTK_RESPONSE_NONE,
				     NULL);

  /* main frame */
  gbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(win)->vbox), gbox);
  gtk_container_set_border_width (GTK_CONTAINER (gbox), 5);

  /* Name frame */
  frame = gtk_frame_new (_("Name"));
  gtk_box_pack_start (GTK_BOX (gbox), frame, FALSE, FALSE, 5);

  entry_name = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (entry_name),
 		      config->gui_player_name->str);
  gtk_container_add (GTK_CONTAINER (frame), entry_name);
  gtk_entry_set_width_chars (GTK_ENTRY (entry_name), 20);

  /* Host frame */
  frame = gtk_frame_new (_("Host"));
  gtk_box_pack_start (GTK_BOX (gbox), frame, FALSE, FALSE, 5);

  entry_host = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (entry_host),
 		      config->gui_host_name->str);
  gtk_container_add (GTK_CONTAINER (frame), entry_host);
  gtk_entry_set_width_chars (GTK_ENTRY (entry_host), 20);

  /* Port frame */
  frame = gtk_frame_new (_("Port"));
  gtk_box_pack_start (GTK_BOX (gbox), frame, FALSE, FALSE, 5);

  entry_port = gtk_spin_button_new_with_range (0, 0xFFFF, 1);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (entry_port),
			     config->gui_port);
  gtk_container_add (GTK_CONTAINER (frame), entry_port);


  g_signal_connect (GTK_OBJECT (win), 
		    "response", 
		    G_CALLBACK (response_connect),
		    NULL);


  gtk_widget_show_all (win);
}
