/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <libmt_client.h>
#include "player.h"
#include "defs.h"
#include "gui.h"


static gint done;

static GtkWidget *frame_button;

typedef struct
{
  libmt_client_player_t *player;
  gint bid;
}
player_data_t;


static gchar *str_bid_mnemonic[6] = { N_("Inconnue"),
  N_("Pass_e"), N_("P_rise"), N_("Gar_de"),
  N_("Garde Sa_ns"), N_("Garde C_ontre")
};



static void
bid_valide (GtkButton * button, gpointer data)
{
  player_data_t *player_data = data;

  done = 1;

  printf ("done = %d\n", done);
  player_data->player->bid[player_data->player->place] = player_data->bid;
}



static void
bid_redraw (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  gint width, height;
  GtkRequisition req;

  gui_layout_get_size (evt, &width, &height);

/*   g_print ("geom redraw layout=%dx%d\n", width, height); */

  player_client_redraw_base (win, evt, data);

  gtk_widget_size_request (GTK_WIDGET (frame_button), &req);
  gtk_layout_move (GTK_LAYOUT (gui_layout), frame_button,
		   width / 2 - req.width / 2,
		   height / 2 - gui_card_height / 2 - req.height / 2);

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}



gint
player_client_make_bid (libmt_client_player_t * player)
{
  gint width, height;
  GtkRequisition req;
  gint i;
  GtkWidget *wid;
  player_data_t player_data[5];

  gdk_threads_enter ();

  gtk_layout_get_size (GTK_LAYOUT (gui_layout), &width, &height);

  /* status bar */
  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _("Please, make your bid."));

  /* buttons to choose bid */
  frame_button = gtk_vbutton_box_new ();
  gtk_widget_size_request (GTK_WIDGET (frame_button), &req);
  gtk_layout_put (GTK_LAYOUT (gui_layout), frame_button,
		  width / 2 - req.width / 2,
		  height / 2 - gui_card_height / 2 - req.height / 2);
  gtk_box_set_spacing (GTK_BOX (frame_button), 5);

  player_data[0].bid = LIBMT_BID_PASSE;
  player_data[1].bid = LIBMT_BID_PRISE;
  player_data[2].bid = LIBMT_BID_GARDE;
  player_data[3].bid = LIBMT_BID_SANS;
  player_data[4].bid = LIBMT_BID_CONTRE;

  for (i = 0; i < 5; i++)
    {
      player_data[i].player = player;

      wid = gtk_button_new_with_mnemonic (_(str_bid_mnemonic[i + 1]));
      g_signal_connect (G_OBJECT (wid), "clicked", G_CALLBACK (bid_valide),
			&player_data[i]);
      gtk_box_pack_start (GTK_BOX (frame_button), wid, TRUE, TRUE, 5);
    }

  gtk_widget_show_all (gui_mainwin);

  gui_set_redraw_func (bid_redraw, player);
  gui_do_redraw ();

  gdk_threads_leave ();

  done = 0;

  while (done == 0)
    {
      /* put chat part here! */
      usleep (100);
    }

  gdk_threads_enter ();

  gtk_container_remove (GTK_CONTAINER (gui_layout), frame_button);

  gdk_threads_leave ();

  return (0);
}
