/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MT_GTK_CLIENT_PLAYER_H
#define MT_GTK_CLIENT_PLAYER_H


#include <gtk/gtk.h>
#include <libmt_client.h>
#include "defs.h"


extern gchar *str_bid[6];

extern GtkWidget *player_frame[MAX_PLAYER];
extern GtkWidget *player_label_bid[MAX_PLAYER];
extern GtkWidget *player_label_score[MAX_PLAYER];


extern gint player_client_init (libmt_client_player_t * player);
extern gint player_client_game_init (libmt_client_player_t * player);
extern gint player_client_make_bid (libmt_client_player_t * player);
extern gint player_client_make_chien (libmt_client_player_t * player);
extern gint player_client_not_make_chien (libmt_client_player_t * player);
extern gint player_client_choose_card (libmt_client_player_t * player);
extern gint player_client_remove_card (libmt_client_player_t * player);
extern gint player_client_draw (libmt_client_player_t * player);
extern gint player_client_ack_replay (libmt_client_player_t * player);
extern gint player_client_lost_connection (libmt_client_player_t * player);
extern gint player_client_normal_close (libmt_client_player_t * player);


extern void player_client_redraw_base (GtkWidget * win,
				       GdkEventConfigure * evt,
				       gpointer data);
extern void player_client_redraw_frame_name (libmt_client_player_t * player,
					     gint width, gint height);
extern void player_client_redraw_card_played (GtkWidget * win,
					      GdkEventConfigure * evt,
					      gpointer data);

extern void player_client_wait_see_chien (libmt_client_player_t * player);
extern void player_client_wait_end_of_turn (libmt_client_player_t * player);


#endif /* MT_GTK_CLIENT_PLAYER_H */
