/*  MaitreTarot.
 *  (C) 2002 Guillaume Weexsteen <gui.mail@wanadoo.fr>
 *  Modified by Yves Mettier <ymettier@libertysurf.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MAITRETAROT_GAME_H
#define MAITRETAROT_GAME_H

#include <signal.h>
#include <glib.h>
#include <maitretarot.h>
#include "defs.h"

player_t *player_new (gint place, gint sock);
game_t *game_new (gint port);
void init_hand (game_t * game);
gint dill_cards (game_t * game);
gint bills (game_t * game);
gint send_chien (game_t * game, gboolean after_bills);
gint manage_chien (game_t * game);
gint play_game (game_t * game);
void compute_scores (game_t * game);
void compute_scores_when_no_game_was_played (game_t * game);
int send_scores (game_t * game);
gint ask_players_if_the_want_to_play_again (game_t * game);
void dump_game (int sig, siginfo_t * siginfo, void *val);
#endif /* MAITRETAROT_JEU_H */
