/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-hotmail-mailbox.h"

#include "mn-hotmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-hotmail-mailbox.gob"

#include <unistd.h>
#include <glib/gi18n.h>
#include "mn-conf.h"
#include "mn-webmail-mailbox-private.h"
#include "mn-stock.h"
#include "mn-util.h"

typedef struct
{
  const char	*code;
  const char	*folder;
} InboxMapping;

/* this list is not exhaustive */
static const InboxMapping inbox_mappings_array[] = {
  { "da",	"Indbakke"		},
  { "de",	"Posteingang"		},
  { "es",	"Band. entrada"		},
  { "fi",	"Saapuneet"		},
  { "fr",	"Boîte de réception"	},
  { "it",	"Posta in arrivo"	},
  { "nl",	"Postvak IN"		},
  { "no",	"Innboks"		},
  { "pl",	"Skrzynka odbiorcza"	},
  { "pt_BR",	"Caixa de Entrada"	},
  { "pt_PT",	"A Receber"		},
  { "sv",	"Inkorgen"		},
};

static GHashTable *inbox_mappings;

#line 59 "mn-hotmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_HOTMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_HOTMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_HOTMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_HOTMAIL_MAILBOX
#define SELF_CLASS(x) MN_HOTMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_HOTMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNHotmailMailbox Self;
typedef MNHotmailMailboxClass SelfClass;

/* here are local prototypes */
#line 59 "src/mn-hotmail-mailbox.gob"
static void mn_hotmail_mailbox_class_init (MNHotmailMailboxClass * class);
#line 76 "mn-hotmail-mailbox.c"
#line 71 "src/mn-hotmail-mailbox.gob"
static void mn_hotmail_mailbox_init_inbox_mappings (void);
#line 79 "mn-hotmail-mailbox.c"
#line 86 "src/mn-hotmail-mailbox.gob"
static void mn_hotmail_mailbox_init (MNHotmailMailbox * self);
#line 82 "mn-hotmail-mailbox.c"
#line 92 "src/mn-hotmail-mailbox.gob"
static void mn_hotmail_mailbox_parse_language (const char * code, char ** language, char ** country);
#line 85 "mn-hotmail-mailbox.c"
#line 123 "src/mn-hotmail-mailbox.gob"
static const char * mn_hotmail_mailbox_get_localized_folder (const char * folder);
#line 88 "mn-hotmail-mailbox.c"
#line 165 "src/mn-hotmail-mailbox.gob"
static char * mn_hotmail_mailbox_encode_with_character_references (const char * str);
#line 91 "mn-hotmail-mailbox.c"
#line 185 "src/mn-hotmail-mailbox.gob"
static char * mn_hotmail_mailbox_create_config_file (MNHotmailMailbox * self, const char * spool_file, gboolean getlive_pre_1_40, GError ** err);
#line 94 "mn-hotmail-mailbox.c"
#line 277 "src/mn-hotmail-mailbox.gob"
static char * ___8_mn_hotmail_mailbox_get_error_message (MNWebmailMailbox * mailbox, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure);
#line 97 "mn-hotmail-mailbox.c"
#line 291 "src/mn-hotmail-mailbox.gob"
static gboolean mn_hotmail_mailbox_run_getlive (MNHotmailMailbox * self, const char * config_file, GError ** err);
#line 100 "mn-hotmail-mailbox.c"
#line 304 "src/mn-hotmail-mailbox.gob"
static gboolean mn_hotmail_mailbox_get_getlive_cvs_revision (int * major, int * minor);
#line 103 "mn-hotmail-mailbox.c"
#line 359 "src/mn-hotmail-mailbox.gob"
static gboolean ___b_mn_hotmail_mailbox_webmail_check (MNWebmailMailbox * mailbox, GError ** err);
#line 106 "mn-hotmail-mailbox.c"

/* pointer to the class of our parent */
static MNWebmailMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_init_inbox_mappings mn_hotmail_mailbox_init_inbox_mappings
#define self_parse_language mn_hotmail_mailbox_parse_language
#define self_get_localized_folder mn_hotmail_mailbox_get_localized_folder
#define self_encode_with_character_references mn_hotmail_mailbox_encode_with_character_references
#define self_create_config_file mn_hotmail_mailbox_create_config_file
#define self_run_getlive mn_hotmail_mailbox_run_getlive
#define self_get_getlive_cvs_revision mn_hotmail_mailbox_get_getlive_cvs_revision
GType
mn_hotmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNHotmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_hotmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNHotmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_hotmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_WEBMAIL_MAILBOX, "MNHotmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNHotmailMailbox *)g_object_new(mn_hotmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNHotmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNHotmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNHotmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNHotmailMailbox *)g_object_new_valist (mn_hotmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}

#line 59 "src/mn-hotmail-mailbox.gob"
static void 
mn_hotmail_mailbox_class_init (MNHotmailMailboxClass * class G_GNUC_UNUSED)
{
#line 165 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::class_init"
	MNWebmailMailboxClass *mn_webmail_mailbox_class = (MNWebmailMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_WEBMAIL_MAILBOX);

#line 277 "src/mn-hotmail-mailbox.gob"
	mn_webmail_mailbox_class->get_error_message = ___8_mn_hotmail_mailbox_get_error_message;
#line 359 "src/mn-hotmail-mailbox.gob"
	mn_webmail_mailbox_class->webmail_check = ___b_mn_hotmail_mailbox_webmail_check;
#line 175 "mn-hotmail-mailbox.c"
 {
#line 60 "src/mn-hotmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "hotmail";

    /* 5 minutes is a good default */
    MN_MAILBOX_CLASS(class)->default_check_delay = 60 * 5;

    MN_WEBMAIL_MAILBOX_CLASS(class)->default_domain = "hotmail.com";

    self_init_inbox_mappings();
  
#line 188 "mn-hotmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 86 "src/mn-hotmail-mailbox.gob"
static void 
mn_hotmail_mailbox_init (MNHotmailMailbox * self G_GNUC_UNUSED)
{
#line 196 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::init"
 {
#line 87 "src/mn-hotmail-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "Windows Live Hotmail");
    mn_mailbox_set_stock_id(MN_MAILBOX(self), MN_STOCK_HOTMAIL);
  
#line 204 "mn-hotmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__


#line 71 "src/mn-hotmail-mailbox.gob"
static void 
mn_hotmail_mailbox_init_inbox_mappings (void)
{
#line 214 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::init_inbox_mappings"
{
#line 73 "src/mn-hotmail-mailbox.gob"
	
    int i;

    inbox_mappings = g_hash_table_new(g_str_hash, g_str_equal);

    for (i = 0; i < G_N_ELEMENTS(inbox_mappings_array); i++)
      {
	const InboxMapping *mapping = &inbox_mappings_array[i];

	g_hash_table_insert(inbox_mappings, (gpointer) mapping->code, (gpointer) mapping->folder);
      }
  }}
#line 230 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__


#line 92 "src/mn-hotmail-mailbox.gob"
static void 
mn_hotmail_mailbox_parse_language (const char * code, char ** language, char ** country)
{
#line 238 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::parse_language"
#line 92 "src/mn-hotmail-mailbox.gob"
	g_return_if_fail (code != NULL);
#line 242 "mn-hotmail-mailbox.c"
{
#line 96 "src/mn-hotmail-mailbox.gob"
	
    char *stripped = NULL;
    char *sep;

    /* strip the charset if any */
    sep = strchr(code, '.');
    if (sep)
      {
	stripped = g_strndup(code, sep - code);
	code = stripped;
      }

    sep = strchr(code, '_');
    if (sep)
      {
	*language = g_strndup(code, sep - code);
	*country = g_strdup(sep + 1);
      }
    else
      {
	*language = g_strdup(code);
	*country = NULL;
      }

    g_free(stripped);
  }}
#line 271 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 123 "src/mn-hotmail-mailbox.gob"
static const char * 
mn_hotmail_mailbox_get_localized_folder (const char * folder)
{
#line 278 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::get_localized_folder"
#line 123 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (folder != NULL, (const char * )0);
#line 282 "mn-hotmail-mailbox.c"
{
#line 125 "src/mn-hotmail-mailbox.gob"
	
    if (! strcmp(folder, "Inbox"))
      {
	int i;
	const char* const *language_codes;

	language_codes = g_get_language_names();

	for (i = 0; language_codes[i]; i++)
	  {
	    const char *code = language_codes[i];
	    char *language;
	    char *country;
	    const char *mapping = NULL;

	    self_parse_language(code, &language, &country);

	    if (country)
	      {
		char *full;

		full = g_strdup_printf("%s_%s", language, country);
		mapping = g_hash_table_lookup(inbox_mappings, full);
		g_free(full);
	      }

	    if (! mapping)
	      mapping = g_hash_table_lookup(inbox_mappings, language);

	    g_free(language);
	    g_free(country);

	    if (mapping)
	      return mapping;
	  }
      }

    return folder;
  }}
#line 324 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 165 "src/mn-hotmail-mailbox.gob"
static char * 
mn_hotmail_mailbox_encode_with_character_references (const char * str)
{
#line 331 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::encode_with_character_references"
#line 165 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 335 "mn-hotmail-mailbox.c"
{
#line 167 "src/mn-hotmail-mailbox.gob"
	
    GString *encoded;
    const char *p;

    encoded = g_string_new(NULL);
    for (p = str; *p; p = g_utf8_next_char(p))
      {
	gunichar c = g_utf8_get_char(p);

	if (c < 128 && (g_ascii_isalnum(c) || g_ascii_isspace(c)))
	  g_string_append_c(encoded, c);
	else
	  g_string_append_printf(encoded, "&#%i;", (int) c);
      }

    return g_string_free(encoded, FALSE);
  }}
#line 355 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 185 "src/mn-hotmail-mailbox.gob"
static char * 
mn_hotmail_mailbox_create_config_file (MNHotmailMailbox * self, const char * spool_file, gboolean getlive_pre_1_40, GError ** err)
{
#line 362 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::create_config_file"
#line 185 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 185 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_HOTMAIL_MAILBOX (self), (char * )0);
#line 185 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (spool_file != NULL, (char * )0);
#line 370 "mn-hotmail-mailbox.c"
{
#line 190 "src/mn-hotmail-mailbox.gob"
	
    char *username;
    char *domain;
    const char *localized_folder;
    char *folder;
    GString *contents;
    char *filename;
    const char *charset;

    mn_webmail_mailbox_parse_username(MN_WEBMAIL_MAILBOX(self), &username, &domain);

    contents = g_string_new(NULL);

    localized_folder = self_get_localized_folder(MN_WEBMAIL_MAILBOX(self)->folder);

    if (getlive_pre_1_40)
      folder = self_encode_with_character_references(localized_folder);
    else
      folder = g_strdup(localized_folder);

    g_string_append_printf(contents,
			   "UserName = %s\n"
			   "Domain = %s\n"
			   "Password = %s\n"
			   "FetchOnlyUnread = Yes\n"
			   "Folder = %s\n"
			   "Processor = cat >> '%s'\n"
			   "MarkRead = No\n",
			   username,
			   domain,
			   MN_AUTHENTICATED_MAILBOX(self)->runtime_password,
			   folder,
			   spool_file);

    g_free(username);
    g_free(domain);
    g_free(folder);

    if (mn_conf_get_bool(MN_CONF_SYSTEM_HTTP_PROXY_USE_HTTP_PROXY))
      {
	char *host;

	host = mn_conf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_HOST);
	if (host && *host)
	  {
	    g_string_append_printf(contents, "Proxy = %s:%i\n", host, mn_conf_get_int(MN_CONF_SYSTEM_HTTP_PROXY_PORT));

	    if (mn_conf_get_bool(MN_CONF_SYSTEM_HTTP_PROXY_USE_AUTHENTICATION))
	      {
		char *user;
		char *password;

		user = mn_conf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_USER);
		password = mn_conf_get_string(MN_CONF_SYSTEM_HTTP_PROXY_AUTHENTICATION_PASSWORD);

		if (user && *user && password && *password)
		  g_string_append_printf(contents, "ProxyAuth = %s:%s\n", user, password);

		g_free(user);
		g_free(password);
	      }
	  }
	g_free(host);
      }

    mn_webmail_mailbox_print_config(MN_WEBMAIL_MAILBOX(self), contents->str);

    /*
     * As of this commit:
     *
     *   http://getlive.cvs.sourceforge.net/getlive/GetLive/GetLive.pl?r1=1.39&r2=1.40
     *
     * GetLive expects the config file to be encoded in the charset of
     * the user's locale.
     */
    if (getlive_pre_1_40)
      charset = "UTF-8";
    else
      g_get_charset(&charset);

    filename = mn_webmail_mailbox_write_temporary_file(contents->str, charset, err);

    g_string_free(contents, TRUE);

    return filename;
  }}
#line 459 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 277 "src/mn-hotmail-mailbox.gob"
static char * 
___8_mn_hotmail_mailbox_get_error_message (MNWebmailMailbox * mailbox G_GNUC_UNUSED, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure)
#line 465 "mn-hotmail-mailbox.c"
#define PARENT_HANDLER(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->get_error_message)(___mailbox,___helper_stdout,___helper_stderr,___is_auth_failure): \
		((char * )0))
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::get_error_message"
{
#line 282 "src/mn-hotmail-mailbox.gob"
	
    if (helper_stderr && mn_ascii_strcasestr(helper_stderr, "error logging in"))
      {
	*is_auth_failure = TRUE;
	return g_strdup(_("authentication failed"));
      }
    return NULL;
  }}
#line 482 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 291 "src/mn-hotmail-mailbox.gob"
static gboolean 
mn_hotmail_mailbox_run_getlive (MNHotmailMailbox * self, const char * config_file, GError ** err)
{
#line 490 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::run_getlive"
#line 291 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 291 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_HOTMAIL_MAILBOX (self), (gboolean )0);
#line 291 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (config_file != NULL, (gboolean )0);
#line 498 "mn-hotmail-mailbox.c"
{
#line 293 "src/mn-hotmail-mailbox.gob"
	
    char *command;
    gboolean status;

    command = g_strdup_printf("GetLive --config-file %s", config_file);
    status = mn_webmail_mailbox_run_helper(MN_WEBMAIL_MAILBOX(self), "GetLive", command, err);
    g_free(command);

    return status;
  }}
#line 511 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 304 "src/mn-hotmail-mailbox.gob"
static gboolean 
mn_hotmail_mailbox_get_getlive_cvs_revision (int * major, int * minor)
{
#line 518 "mn-hotmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::get_getlive_cvs_revision"
#line 304 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (major != NULL, (gboolean )0);
#line 304 "src/mn-hotmail-mailbox.gob"
	g_return_val_if_fail (minor != NULL, (gboolean )0);
#line 524 "mn-hotmail-mailbox.c"
{
#line 306 "src/mn-hotmail-mailbox.gob"
	
    char *getlive_stderr;
    char **lines;
    int i;

    if (! g_spawn_command_line_sync("GetLive --version", NULL, &getlive_stderr, NULL, NULL))
      return FALSE;

    lines = g_strsplit(getlive_stderr, "\n", 0);
    g_free(getlive_stderr);

    for (i = 0; lines[i]; i++)
      {
	char *str;

	str = mn_strstr_span(lines[i], "GetLive $Revision: ");
	if (str)
	  {
	    char *end;

	    end = strchr(str, ' ');
	    if (end)
	      {
		char *rev;
		char **versions;

		rev = g_strndup(str, end - str);
		versions = g_strsplit(rev, ".", 0);
		g_free(rev);

		if (g_strv_length(versions) >= 2
		    && mn_str_isnumeric(versions[0])
		    && mn_str_isnumeric(versions[1]))
		  {
		    *major = atoi(versions[0]);
		    *minor = atoi(versions[1]);

		    g_strfreev(versions);
		    g_strfreev(lines);

		    return TRUE;
		  }

		g_strfreev(versions);
	      }
	  }
      }

    g_strfreev(lines);

    return FALSE;
  }}
#line 579 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 359 "src/mn-hotmail-mailbox.gob"
static gboolean 
___b_mn_hotmail_mailbox_webmail_check (MNWebmailMailbox * mailbox G_GNUC_UNUSED, GError ** err)
#line 585 "mn-hotmail-mailbox.c"
#define PARENT_HANDLER(___mailbox,___err) \
	((MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)? \
		(* MN_WEBMAIL_MAILBOX_CLASS(parent_class)->webmail_check)(___mailbox,___err): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Hotmail:Mailbox::webmail_check"
{
#line 361 "src/mn-hotmail-mailbox.gob"
	
    Self *self = SELF(mailbox);
    int getlive_major;
    int getlive_minor;
    gboolean getlive_pre_1_40;
    char *spool_file;
    char *config_file = NULL;
    gboolean status = FALSE;

    /* see https://sourceforge.net/tracker/?func=detail&atid=948290&aid=1881842&group_id=194154 */
    getlive_pre_1_40 = ! self_get_getlive_cvs_revision(&getlive_major, &getlive_minor)
      || getlive_major < 1
      || (getlive_major == 1 && getlive_minor < 40);

    /*
     * We create an empty spool file beforehand to make sure it is not
     * world-readable.
     */
    spool_file = mn_webmail_mailbox_create_spool_file(err);
    if (! spool_file)
      return FALSE;

    config_file = self_create_config_file(self, spool_file, getlive_pre_1_40, err);
    if (! config_file)
      goto end;

    if (! self_run_getlive(self, config_file, err))
      goto end;

    if (! mn_webmail_mailbox_read_spool_file(mailbox, spool_file, err))
      goto end;

    status = TRUE;

  end:
    unlink(spool_file);
    g_free(spool_file);

    if (config_file)
      {
	unlink(config_file);
	g_free(config_file);
      }

    return status;
  }}
#line 640 "mn-hotmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
