/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-imap-mailbox.h"

#include "mn-imap-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 44 "mn-imap-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-pi-mailbox-private.h"
#include "mn-util.h"
#include "mn-message-mime.h"

#define HAS_CURRENT_TAG(response, priv)	(! strcmp((response)->tag, (priv)->tag))
#define IS(response, token)		(! g_ascii_strcasecmp((response)->response, (token)))
#define IS_OK(response)			IS(response, "OK")
#define IS_NO(response)			IS(response, "NO")
#define IS_BAD(response)		IS(response, "BAD")
#define IS_BYE(response)		IS(response, "BYE")

#define REMOVED(self)			(g_atomic_int_get(&(self)->_priv->removed))

enum
{
  STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
  STATE_CAPABILITY,
#if WITH_SSL
  STATE_STARTTLS,
#endif
#if WITH_SASL
  STATE_AUTHENTICATE,
#endif
  STATE_LOGIN,
  STATE_EXAMINE,
  STATE_SEARCH_UNSEEN,
  STATE_SEARCH_RECENT,
  STATE_FETCH,
  STATE_IDLE,
  STATE_LOGOUT
};

typedef enum
{
  IDLE_STATE_PRE_IDLE,
  IDLE_STATE_IDLE,
  IDLE_STATE_POST_IDLE
} IdleState;

struct _MNClientSessionPrivate
{
  MN_PI_MAILBOX_SESSION_PRIVATE;
  MNIMAPMailbox			*self;

  const char			*server_software;
  gboolean			server_software_supports_idle;

  int				numeric_tag;
  char				tag[5];

  char				**capabilities;
  GSList			*auth_mechanisms;
  gboolean			authenticated;

  gboolean			search_received;

  GHashTable			*unseen_numbers;
  GHashTable			*recent_numbers;
  GHashTable			*received_numbers;

  GSList			*messages;

#if WITH_SSL
  gboolean			starttls_completed;
#endif
#if WITH_SASL
  GSList			*sasl_remaining_mechanisms;
  const char			*sasl_mechanism;
#endif

  IdleState			idle_state;
  unsigned int			idle_inactivity_timeout_id;
  gboolean			idle_inactivity;
  gboolean			could_idle;	/* could idle at least once */
};

struct _MNClientSessionResponse
{
  char		*continuation;
  char		*tag;
  char		*response;
  char		*code;
  char		*arguments;
};

typedef struct
{
  MNClientSessionPrivate	*priv;
  gboolean			error;
} CheckReceivedInfo;

int mn_imap_mailbox_default_ports[MN_PI_MAILBOX_N_CONNECTION_TYPES] = { 143, 143, 993 };

/* variable taken from Evolution (camel-utf8.c) */
static char *utf7_alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+,";

#line 132 "mn-imap-mailbox.c"
static const GEnumValue _mn_imap_mailbox_use_idle_values[] = {
	{ MN_IMAP_MAILBOX_USE_IDLE_NEVER, (char *)"MN_IMAP_MAILBOX_USE_IDLE_NEVER", (char *)"never" },
	{ MN_IMAP_MAILBOX_USE_IDLE_AUTODETECT, (char *)"MN_IMAP_MAILBOX_USE_IDLE_AUTODETECT", (char *)"autodetect" },
	{ MN_IMAP_MAILBOX_USE_IDLE_ALWAYS, (char *)"MN_IMAP_MAILBOX_USE_IDLE_ALWAYS", (char *)"always" },
	{ 0, NULL, NULL }
};

GType
mn_imap_mailbox_use_idle_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNIMAPMailboxUseIDLE", _mn_imap_mailbox_use_idle_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_IMAP_MAILBOX(x)
#define SELF_CONST(x) MN_IMAP_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_IMAP_MAILBOX(x)
#define TYPE_SELF MN_TYPE_IMAP_MAILBOX
#define SELF_CLASS(x) MN_IMAP_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_IMAP_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNIMAPMailbox Self;
typedef MNIMAPMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_imap_mailbox_class_init (MNIMAPMailboxClass * class) G_GNUC_UNUSED;
static void mn_imap_mailbox_init (MNIMAPMailbox * self) G_GNUC_UNUSED;
static void ___3_mn_imap_mailbox_seal (MNMailbox * mailbox) G_GNUC_UNUSED;
static MNMailbox * ___4_mn_imap_mailbox_parse_uri (MNMailbox * dummy, const char * uri) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_split_uri_location (const char * location, int maxlen, char * hostport, char * path, gboolean * has_path) G_GNUC_UNUSED;
static void ___6_mn_imap_mailbox_removed (MNMailbox * mailbox) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_search_unseen_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_search_unseen_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_search_recent_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_search_recent_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_build_fetch_set_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_check_received_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void ___1e_mn_imap_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_default_handler (MNClientSessionResponse * response, MNClientSessionPrivate * priv, int error_code_when_bye) G_GNUC_UNUSED;
static void mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_idle_inactivity_timeout_cb (gpointer data) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_handle_capability_code (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_login) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_detect_imapd (MNClientSession * session, MNClientSessionResponse * greeting_response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_enter_search (MNClientSession * session, MNClientSessionPrivate * priv, const char * what, GHashTable ** numbers) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_handle_search (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv, GHashTable * numbers) G_GNUC_UNUSED;
static char * mn_imap_mailbox_quote (const char * str) G_GNUC_UNUSED;
static char * mn_imap_mailbox_utf8_to_imap_utf7 (const char * str) G_GNUC_UNUSED;
static void mn_imap_mailbox_imap_utf7_closeb64 (GString * out, guint32 v, guint32 i) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MAILBOX,
	PROP_USE_IDLE_EXTENSION
};

/* pointer to the class of our parent */
static MNPIMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_split_uri_location mn_imap_mailbox_split_uri_location
#define self_handle_greeting_cb mn_imap_mailbox_handle_greeting_cb
#define self_enter_capability_cb mn_imap_mailbox_enter_capability_cb
#define self_handle_capability_cb mn_imap_mailbox_handle_capability_cb
#define self_enter_starttls_cb mn_imap_mailbox_enter_starttls_cb
#define self_handle_starttls_cb mn_imap_mailbox_handle_starttls_cb
#define self_enter_authenticate_cb mn_imap_mailbox_enter_authenticate_cb
#define self_handle_authenticate_cb mn_imap_mailbox_handle_authenticate_cb
#define self_enter_login_cb mn_imap_mailbox_enter_login_cb
#define self_handle_login_cb mn_imap_mailbox_handle_login_cb
#define self_enter_examine_cb mn_imap_mailbox_enter_examine_cb
#define self_handle_examine_cb mn_imap_mailbox_handle_examine_cb
#define self_enter_search_unseen_cb mn_imap_mailbox_enter_search_unseen_cb
#define self_handle_search_unseen_cb mn_imap_mailbox_handle_search_unseen_cb
#define self_enter_search_recent_cb mn_imap_mailbox_enter_search_recent_cb
#define self_handle_search_recent_cb mn_imap_mailbox_handle_search_recent_cb
#define self_enter_fetch_cb mn_imap_mailbox_enter_fetch_cb
#define self_build_fetch_set_cb mn_imap_mailbox_build_fetch_set_cb
#define self_handle_fetch_cb mn_imap_mailbox_handle_fetch_cb
#define self_check_received_cb mn_imap_mailbox_check_received_cb
#define self_enter_idle_cb mn_imap_mailbox_enter_idle_cb
#define self_handle_idle_cb mn_imap_mailbox_handle_idle_cb
#define self_enter_logout_cb mn_imap_mailbox_enter_logout_cb
#define self_handle_logout_cb mn_imap_mailbox_handle_logout_cb
#define self_response_new_cb mn_imap_mailbox_response_new_cb
#define self_response_free_cb mn_imap_mailbox_response_free_cb
#define self_default_handler mn_imap_mailbox_default_handler
#define self_pre_read_cb mn_imap_mailbox_pre_read_cb
#define self_post_read_cb mn_imap_mailbox_post_read_cb
#define self_idle_inactivity_timeout_cb mn_imap_mailbox_idle_inactivity_timeout_cb
#define self_session_write mn_imap_mailbox_session_write
#define self_handle_capability_code mn_imap_mailbox_handle_capability_code
#define self_session_parse_capabilities mn_imap_mailbox_session_parse_capabilities
#define self_session_has_capability mn_imap_mailbox_session_has_capability
#define self_session_after_capability mn_imap_mailbox_session_after_capability
#define self_session_authenticate mn_imap_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_imap_mailbox_session_authenticate_fallback
#define self_session_detect_imapd mn_imap_mailbox_session_detect_imapd
#define self_session_enter_search mn_imap_mailbox_session_enter_search
#define self_session_handle_search mn_imap_mailbox_session_handle_search
#define self_quote mn_imap_mailbox_quote
#define self_utf8_to_imap_utf7 mn_imap_mailbox_utf8_to_imap_utf7
#define self_imap_utf7_closeb64 mn_imap_mailbox_imap_utf7_closeb64
#define self_build_name mn_imap_mailbox_build_name
GType
mn_imap_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNIMAPMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_imap_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNIMAPMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_imap_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_PI_MAILBOX, "MNIMAPMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNIMAPMailbox *)g_object_new(mn_imap_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNIMAPMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNIMAPMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNIMAPMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNIMAPMailbox *)g_object_new_valist (mn_imap_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::finalize"
	MNIMAPMailbox *self G_GNUC_UNUSED = MN_IMAP_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 164 "mn-imap-mailbox.gob"
	if(self->_priv->mutex) { g_mutex_free ((gpointer) self->_priv->mutex); self->_priv->mutex = NULL; }
#line 322 "mn-imap-mailbox.c"
#line 168 "mn-imap-mailbox.gob"
	if(self->mailbox) { g_free ((gpointer) self->mailbox); self->mailbox = NULL; }
#line 325 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__

#line 183 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_class_init (MNIMAPMailboxClass * class G_GNUC_UNUSED)
#line 332 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNIMAPMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_PI_MAILBOX);

#line 194 "mn-imap-mailbox.gob"
	mn_mailbox_class->seal = ___3_mn_imap_mailbox_seal;
#line 214 "mn-imap-mailbox.gob"
	mn_mailbox_class->parse_uri = ___4_mn_imap_mailbox_parse_uri;
#line 315 "mn-imap-mailbox.gob"
	mn_mailbox_class->removed = ___6_mn_imap_mailbox_removed;
#line 1009 "mn-imap-mailbox.gob"
	mn_authenticated_mailbox_class->authenticated_check = ___1e_mn_imap_mailbox_authenticated_check;
#line 351 "mn-imap-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("mailbox" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 "INBOX" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_IGNORE_CASE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_PERMANENT | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_MAILBOX,
		param_spec);
	param_spec = g_param_spec_enum
		("use_idle_extension" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_IMAP_MAILBOX_USE_IDLE /* enum_type */,
		 MN_IMAP_MAILBOX_USE_IDLE_AUTODETECT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_USE_IDLE_EXTENSION,
		param_spec);
    }
 {
#line 184 "mn-imap-mailbox.gob"

    MN_MAILBOX_CLASS(class)->type = "imap";
    MN_PI_MAILBOX_CLASS(class)->default_ports = mn_imap_mailbox_default_ports;
  
#line 384 "mn-imap-mailbox.c"
 }
}
#undef __GOB_FUNCTION__
#line 189 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_init (MNIMAPMailbox * self G_GNUC_UNUSED)
#line 391 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_IMAP_MAILBOX,MNIMAPMailboxPrivate);
#line 164 "mn-imap-mailbox.gob"
	self->_priv->mutex = g_mutex_new();
#line 397 "mn-imap-mailbox.c"
 {
#line 190 "mn-imap-mailbox.gob"

    mn_mailbox_set_format(MN_MAILBOX(self), "IMAP");
  
#line 403 "mn-imap-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::set_property"
{
	MNIMAPMailbox *self G_GNUC_UNUSED;

	self = MN_IMAP_MAILBOX (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 169 "mn-imap-mailbox.gob"
{ char *old = self->mailbox; self->mailbox = g_value_dup_string (VAL); g_free (old); }
#line 424 "mn-imap-mailbox.c"
		}
		break;
	case PROP_USE_IDLE_EXTENSION:
		{
#line 177 "mn-imap-mailbox.gob"
self->use_idle_extension = g_value_get_enum (VAL);
#line 431 "mn-imap-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::get_property"
{
	MNIMAPMailbox *self G_GNUC_UNUSED;

	self = MN_IMAP_MAILBOX (object);

	switch (property_id) {
	case PROP_MAILBOX:
		{
#line 169 "mn-imap-mailbox.gob"
g_value_set_string (VAL, self->mailbox);
#line 462 "mn-imap-mailbox.c"
		}
		break;
	case PROP_USE_IDLE_EXTENSION:
		{
#line 177 "mn-imap-mailbox.gob"
g_value_set_enum (VAL, self->use_idle_extension);
#line 469 "mn-imap-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 194 "mn-imap-mailbox.gob"
static void 
___3_mn_imap_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 489 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::seal"
{
#line 196 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (! mailbox->runtime_name)
      mailbox->runtime_name = self_build_name(MN_AUTHENTICATED_MAILBOX(mailbox)->username,
					      MN_PI_MAILBOX(mailbox)->hostname,
					      self->mailbox);
  }}
#line 507 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 214 "mn-imap-mailbox.gob"
static MNMailbox * 
___4_mn_imap_mailbox_parse_uri (MNMailbox * dummy G_GNUC_UNUSED, const char * uri)
#line 514 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->parse_uri)? \
		(* MN_MAILBOX_CLASS(parent_class)->parse_uri)(___dummy,___uri): \
		((MNMailbox * )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::parse_uri"
{
#line 216 "mn-imap-mailbox.gob"
	
    int len;
    int buflen;
    char *username = NULL;
    char *authmech = NULL;
    char *hostname;
    char *path = NULL;
    int port;
    MNMailbox *mailbox;

    len = strlen(uri);
    buflen = len + 1;

    {
      char scheme_buf[buflen];
      char auth_buf[buflen];
      char location_buf[buflen];
      char hostport_buf[buflen];
      char path_buf[buflen];
      char username_buf[buflen];
      char authmech_buf[buflen];
      char hostname_buf[buflen];
      gboolean has_auth;
      gboolean has_path;
      gboolean has_username = FALSE;
      gboolean has_authmech = FALSE;

      if (! mn_pi_mailbox_split_uri(uri, len, scheme_buf, auth_buf, location_buf, &has_auth))
	return NULL;

      if (strcmp(scheme_buf, "imap"))
	return NULL;

      if (! self_split_uri_location(location_buf, len, hostport_buf, path_buf, &has_path))
	return NULL;

      if (has_auth)
	{
	  if (! mn_pi_mailbox_split_uri_auth(auth_buf, len, username_buf, authmech_buf, &has_username, &has_authmech))
	    return NULL;

	  if (has_authmech && ! strcmp(authmech_buf, "*"))
	    has_authmech = FALSE;
	}

      mn_pi_mailbox_split_uri_hostport(hostport_buf, len, hostname_buf, &port);

      if (has_username)
	username = gnome_vfs_unescape_string(username_buf, NULL);
      if (has_authmech)
	authmech = gnome_vfs_unescape_string(authmech_buf, NULL);
      hostname = gnome_vfs_unescape_string(hostname_buf, NULL);
      if (has_path)
	path = gnome_vfs_unescape_string(path_buf, NULL);
    }

    mailbox = mn_mailbox_new("imap",
			     "username", username,
			     "authmech", authmech,
			     "hostname", hostname,
			     "port", port,
			     "mailbox", path,
			     NULL);

    g_free(username);
    g_free(authmech);
    g_free(hostname);
    g_free(path);

    return mailbox;
  }}
#line 594 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 288 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_split_uri_location (const char * location, int maxlen, char * hostport, char * path, gboolean * has_path)
#line 601 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::split_uri_location"
#line 288 "mn-imap-mailbox.gob"
	g_return_val_if_fail (location != NULL, (gboolean )0);
#line 288 "mn-imap-mailbox.gob"
	g_return_val_if_fail (hostport != NULL, (gboolean )0);
#line 288 "mn-imap-mailbox.gob"
	g_return_val_if_fail (path != NULL, (gboolean )0);
#line 288 "mn-imap-mailbox.gob"
	g_return_val_if_fail (has_path != NULL, (gboolean )0);
#line 612 "mn-imap-mailbox.c"
{
#line 294 "mn-imap-mailbox.gob"
	
    char *pat;
    int n;

    pat = g_strdup_printf("%%%i[^/]/%%%is", maxlen, maxlen);
    n = sscanf(location, pat, hostport, path);
    g_free(pat);

    g_return_val_if_fail(n >= 1, FALSE);

    *has_path = n == 2;
    if (*has_path)
      {
	/* we only handle enc_mailbox (see the RFC 2192 ABNF) */
	if (strspn(path, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$-_.+!*'(),%&=~:@/") != strlen(path))
	  return FALSE;		/* more than enc_mailbox, unhandled */
      }

    return TRUE;
  }}
#line 635 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 315 "mn-imap-mailbox.gob"
static void 
___6_mn_imap_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 641 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::removed"
{
#line 317 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);

    g_atomic_int_inc(&selfp->removed);

    g_mutex_lock(selfp->mutex);
    if (selfp->idle_session)
      {
	mn_client_session_write(selfp->idle_session->session, "DONE");
	selfp->idle_session->idle_state = IDLE_STATE_POST_IDLE;
      }
    g_mutex_unlock(selfp->mutex);

    PARENT_HANDLER(mailbox);
  }}
#line 664 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 333 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 671 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_greeting_cb"
{
#line 337 "mn-imap-mailbox.gob"
	
    priv->session = session;

    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (! response->tag && IS_OK(response))
      {
	self_session_detect_imapd(session, response, priv);
	return self_handle_capability_code(priv, response)
	  ? self_session_after_capability(priv)
	  : STATE_CAPABILITY;
      }
    else if (! response->tag && IS(response, "PREAUTH"))
      {
	priv->authenticated = TRUE;
	self_session_detect_imapd(session, response, priv);
	return self_handle_capability_code(priv, response)
	  ? self_session_after_capability(priv)
	  : STATE_CAPABILITY;
      }
    else if (! response->tag && IS_BYE(response))
      return mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
    else
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
  }}
#line 701 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 363 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 707 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_capability_cb"
{
#line 366 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "CAPABILITY");
  }}
#line 715 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 370 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 721 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_cb"
{
#line 374 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		return priv->capabilities
		  ? self_session_after_capability(priv)
		  : mn_client_session_set_error(session, MN_CLIENT_SESSION_ERROR_OTHER, _("server did not send capabilities"));
	      }
	    else if (IS_BAD(response))
	      {
		mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
		return STATE_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "CAPABILITY"))
      {
	self_session_parse_capabilities(priv, response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
  }}
#line 756 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 405 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 762 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_starttls_cb"
{
#line 408 "mn-imap-mailbox.gob"
	
#if WITH_SSL
    return self_session_write(priv, "STARTTLS");
#else
    g_assert_not_reached();
    return 0;
#endif /* WITH_SSL */
  }}
#line 775 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 417 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 781 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_starttls_cb"
{
#line 421 "mn-imap-mailbox.gob"
	
#if WITH_SSL
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->starttls_completed = TRUE;
		return mn_client_session_enable_ssl(session)
		  ? STATE_CAPABILITY
		  : MN_CLIENT_SESSION_RESULT_DISCONNECT;
	      }
	    else if (IS_BAD(response))
	      {
		mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
		return STATE_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
#else
    g_assert_not_reached();
    return 0;
#endif /* WITH_SSL */
  }}
#line 817 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 453 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 823 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_authenticate_cb"
{
#line 456 "mn-imap-mailbox.gob"
	
#if WITH_SASL
    priv->sasl_mechanism = NULL;

    if (mn_client_session_sasl_authentication_start(priv->session,
						    "imap",
						    priv->sasl_remaining_mechanisms,
						    priv->pi_mailbox->authmech,
						    &priv->sasl_mechanism,
						    NULL,	/* [1] */
						    NULL))	/* [1] */
      {
	g_assert(priv->sasl_mechanism != NULL);
	return self_session_write(priv, "AUTHENTICATE %s", priv->sasl_mechanism);
      }
    else
      return priv->pi_mailbox->auth_cancelled
	? STATE_LOGOUT
	: self_session_authenticate_fallback(priv, FALSE);

    /*
     * [1] RFC 3501 6.2.2 specifies that the IMAP protocol does not
     * support the initial client response feature of SASL.
     */
#else
    g_assert_not_reached();
    return 0;
#endif /* WITH_SASL */
  }}
#line 857 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 486 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 863 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_authenticate_cb"
{
#line 490 "mn-imap-mailbox.gob"
	
#if WITH_SASL
    if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (mn_client_session_sasl_authentication_done(session))
		  {
		    priv->authenticated = TRUE;

		    /*
		     * RFC 3501 2.2.2:
		     *
		     * A server MAY include a CAPABILITY response code
		     * in the tagged OK response of a successful
		     * AUTHENTICATE command in order to send
		     * capabilities automatically.  It is unnecessary
		     * for a client to send a separate CAPABILITY
		     * command if it recognizes these automatic
		     * capabilities.  This should only be done if a
		     * security layer was not negotiated by the
		     * AUTHENTICATE command, because the tagged OK
		     * response as part of an AUTHENTICATE command is
		     * not protected by encryption/integrity checking.
		     * [SASL] requires the client to re-issue a
		     * CAPABILITY command in this case.
		     */
		    return self_handle_capability_code(priv, response) && mn_client_session_sasl_get_ssf(session)
		      ? STATE_EXAMINE
		      : STATE_CAPABILITY;
		  }
		else
		  return MN_CLIENT_SESSION_RESULT_DISCONNECT;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      {
		return priv->pi_mailbox->auth_cancelled
		  ? STATE_LOGOUT
		  : self_session_authenticate_fallback(priv, FALSE);
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (response->continuation)
      return mn_client_session_sasl_authentication_step(session, response->continuation);

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
#else
    g_assert_not_reached();
    return 0;
#endif /* WITH_SASL */
  }}
#line 923 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 546 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 929 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_login_cb"
{
#line 549 "mn-imap-mailbox.gob"
	
    if (self_session_has_capability(priv, "LOGINDISABLED"))
      {
	mn_client_session_notice(session, _("server advertised LOGINDISABLED, not using LOGIN authentication"));
	mn_client_session_set_error(session, MN_CLIENT_SESSION_ERROR_OTHER, _("unable to login"));
	return STATE_LOGOUT;
      }
    else
      {
	char *quoted_username;
	char *quoted_password;
	int result;

	if (! mn_pi_mailbox_fill_credentials(priv->pi_mailbox, TRUE, TRUE))
	  return STATE_LOGOUT;

	quoted_username = self_quote(priv->pi_mailbox->runtime_username);
	quoted_password = self_quote(priv->pi_mailbox->runtime_password);
	result = self_session_write(priv, "LOGIN %s %s", quoted_username, quoted_password);
	g_free(quoted_username);
	g_free(quoted_password);

	return result;
      }
  }}
#line 959 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 575 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 965 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_login_cb"
{
#line 579 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->authenticated = TRUE;
		return self_handle_capability_code(priv, response)
		  ? STATE_EXAMINE
		  : STATE_CAPABILITY;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return self_session_authenticate_fallback(priv, TRUE);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
  }}
#line 993 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 603 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 999 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_examine_cb"
{
#line 606 "mn-imap-mailbox.gob"
	
    char *utf7_mailbox;
    char *quoted_mailbox;
    int result;

    utf7_mailbox = self_utf8_to_imap_utf7(priv->self->mailbox);
    quoted_mailbox = self_quote(utf7_mailbox);
    g_free(utf7_mailbox);

    result = self_session_write(priv, "EXAMINE %s", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
  }}
#line 1018 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 621 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1024 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_examine_cb"
{
#line 625 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      return STATE_SEARCH_UNSEEN;
	    else if (IS_NO(response) || IS_BAD(response))
	      {
		mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
		return STATE_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
  }}
#line 1050 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 647 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_search_unseen_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1056 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_search_unseen_cb"
{
#line 650 "mn-imap-mailbox.gob"
	
    return self_session_enter_search(session, priv, "UNSEEN", &priv->unseen_numbers);
  }}
#line 1064 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 654 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_search_unseen_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1070 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_search_unseen_cb"
{
#line 658 "mn-imap-mailbox.gob"
	
    int result = self_session_handle_search(session, response, priv, priv->unseen_numbers);

    if (result == 0)
      {
	/* finished successfully */
	if (g_hash_table_size(priv->unseen_numbers) > 0)
	  result = STATE_SEARCH_RECENT;
	else
	  {
	    GDK_THREADS_ENTER();
	    mn_mailbox_set_messages(priv->mailbox, NULL);
	    gdk_flush();
	    GDK_THREADS_LEAVE();

	    result = STATE_IDLE;
	  }
      }

    return result;
  }}
#line 1096 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 680 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_search_recent_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1102 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_search_recent_cb"
{
#line 683 "mn-imap-mailbox.gob"
	
    return self_session_enter_search(session, priv, "RECENT", &priv->recent_numbers);
  }}
#line 1110 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 687 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_search_recent_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1116 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_search_recent_cb"
{
#line 691 "mn-imap-mailbox.gob"
	
    int result = self_session_handle_search(session, response, priv, priv->recent_numbers);

    if (result == 0)
      /* finished successfully */
      result = STATE_FETCH;

    return result;
  }}
#line 1130 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 701 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1136 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_fetch_cb"
{
#line 703 "mn-imap-mailbox.gob"
	
    GString *string;
    int result;

    g_assert(priv->unseen_numbers != NULL);
    g_assert(g_hash_table_size(priv->unseen_numbers) > 0);

    if (priv->received_numbers)
      g_hash_table_destroy(priv->received_numbers);
    priv->received_numbers = g_hash_table_new(g_direct_hash, g_direct_equal);

    mn_g_object_slist_clear(&priv->messages);

    string = g_string_new(NULL);
    g_hash_table_foreach(priv->unseen_numbers, self_build_fetch_set_cb, string);

    result = self_session_write(priv, "FETCH %s BODY.PEEK[HEADER]", string->str);
    g_string_free(string, TRUE);

    return result;
  }}
#line 1162 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 725 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_build_fetch_set_cb (gpointer key, gpointer value, gpointer user_data)
#line 1168 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::build_fetch_set_cb"
{
#line 727 "mn-imap-mailbox.gob"
	
    GString *string = user_data;

    if (*string->str)
      g_string_append_c(string, ',');
    g_string_append_printf(string, "%i", GPOINTER_TO_INT(key));
  }}
#line 1180 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 735 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1186 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_fetch_cb"
{
#line 739 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		CheckReceivedInfo info = { priv, FALSE };

		g_hash_table_foreach(priv->unseen_numbers, self_check_received_cb, &info);
		if (info.error)
		  /* compliance error */
		  return mn_client_session_set_error(session, MN_CLIENT_SESSION_ERROR_OTHER, _("server did not send all the messages we requested"));

		GDK_THREADS_ENTER();

		mn_mailbox_set_messages(priv->mailbox, priv->messages);

		/*
		 * In authenticated_check(), we do not hold the GDK
		 * lock while unreffing the message list. We have just
		 * exposed the list to other threads through our
		 * mn_mailbox_set_messages() call, so unref it here,
		 * while we hold the GDK lock.
		 */
		mn_g_object_slist_clear(&priv->messages);

		gdk_flush();
		GDK_THREADS_LEAVE();

		return STATE_IDLE;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      {
		mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
		return STATE_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (mn_str_isnumeric(response->response)
	     && response->arguments
	     && (mn_ascii_str_case_has_prefix(response->arguments, "FETCH (BODY[HEADER]")
		 || mn_ascii_str_case_has_prefix(response->arguments, "FETCH (BODY[HEADER "))) /* [1] */
      {
	/*
	 * [1] Non-compliant response (see RFC 3501 BNF), sent by Binc
	 * IMAP and maybe others. We are tolerant.
	 */

	int n = atoi(response->response);

	if (g_hash_table_lookup(priv->unseen_numbers, GINT_TO_POINTER(n)))
	  {
	    char *p;
	    int len;
	    MNMessageFlags flags = 0;

	    if (g_hash_table_lookup(priv->recent_numbers, GINT_TO_POINTER(n)))
	      flags |= MN_MESSAGE_NEW;

	    g_hash_table_insert(priv->received_numbers, GINT_TO_POINTER(n), GINT_TO_POINTER(TRUE));

	    /* we assume the header string will be in literal form */

	    p = strrchr(response->arguments, '{');
	    if (p && sscanf(p, "{%d}", &len) == 1 && len >= 0)
	      {
		gconstpointer buf;

		buf = mn_client_session_read(session, len);
		if (! buf)
		  return MN_CLIENT_SESSION_RESULT_DISCONNECT;

		priv->messages = g_slist_prepend(priv->messages, mn_message_new_from_buffer(priv->mailbox, buf, len, flags, FALSE));

		/* read end of line (after literal) */
		if (! mn_client_session_read_line(session))
		  return MN_CLIENT_SESSION_RESULT_DISCONNECT;
	      }
	    else
	      priv->messages = g_slist_prepend(priv->messages, mn_message_new_from_error(priv->mailbox, _("unable to fetch message"), flags));

	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
  }}
#line 1283 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 832 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_check_received_cb (gpointer key, gpointer value, gpointer user_data)
#line 1289 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::check_received_cb"
{
#line 834 "mn-imap-mailbox.gob"
	
    CheckReceivedInfo *info = user_data;

    if (! info->error && ! g_hash_table_lookup(info->priv->received_numbers, key))
      info->error = TRUE;
  }}
#line 1300 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 841 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1306 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_idle_cb"
{
#line 844 "mn-imap-mailbox.gob"
	
    if (! REMOVED(priv->self))
      {
	if (priv->self->use_idle_extension == MN_IMAP_MAILBOX_USE_IDLE_NEVER)
	  mn_client_session_notice(session, _("\"Use the IDLE extension\" set to \"never\" in the mailbox properties, logging out"));
	else
	  {
	    if (self_session_has_capability(priv, "IDLE"))
	      {
		switch (priv->self->use_idle_extension)
		  {
		  case MN_IMAP_MAILBOX_USE_IDLE_AUTODETECT:
		    if (priv->server_software_supports_idle)
		      goto idle;
		    else
		      mn_client_session_notice(session, _("the remote server runs %s, not using the IDLE extension"), priv->server_software);
		    break;

		  case MN_IMAP_MAILBOX_USE_IDLE_ALWAYS:
		    if (! priv->server_software_supports_idle)
		      mn_client_session_warning(session, _("the remote server runs %s, the IDLE extension might not function properly"), priv->server_software);
		    goto idle;
		    break;

		  default:
		    g_assert_not_reached();
		  }
	      }
	    else
	      mn_client_session_notice(session, _("the remote server does not support the IDLE extension, logging out"));
	  }
      }

    return STATE_LOGOUT;

  idle:
    priv->idle_state = IDLE_STATE_PRE_IDLE;
    return self_session_write(priv, "IDLE");
  }}
#line 1350 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 884 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1356 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_idle_cb"
{
#line 888 "mn-imap-mailbox.gob"
	
    switch (priv->idle_state)
      {
      case IDLE_STATE_PRE_IDLE:
	if (response->tag)
	  {
	    if (HAS_CURRENT_TAG(response, priv))
	      {
		if (IS_NO(response) || IS_BAD(response))
		  /*
		   * The server advertised IDLE but does not actually
		   * support it.
		   *
		   * Although strictly speaking this can be considered a
		   * compliance fault, we'll be tolerant and just logout
		   * without setting an error.
		   */
		  return STATE_LOGOUT;
		else
		  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	      }
	  }
	else if (response->continuation)
	  {
	    /* we're now in the idle loop */
	    priv->idle_state = IDLE_STATE_IDLE;
	    priv->idle_inactivity = FALSE;
	    priv->could_idle = TRUE;

	    GDK_THREADS_ENTER();
	    mn_mailbox_set_poll(priv->mailbox, FALSE);
	    gdk_flush();
	    GDK_THREADS_LEAVE();

	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
	break;

      case IDLE_STATE_IDLE:
	if (response->continuation || response->tag)
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;

	if (IS_BYE(response))
	  {
	    priv->idle_state = IDLE_STATE_POST_IDLE;
	    return MN_CLIENT_SESSION_RESULT_DISCONNECT; /* we'll reconnect */
	  }
	else if (response->arguments
		 && mn_str_isnumeric(response->response)
		 && (! g_ascii_strcasecmp(response->arguments, "EXISTS")
		     || ! g_ascii_strcasecmp(response->arguments, "RECENT")
		     || ! g_ascii_strcasecmp(response->arguments, "EXPUNGE")
		     || mn_ascii_str_case_has_prefix(response->arguments, "FETCH ")))
	  {
	    priv->idle_state = IDLE_STATE_POST_IDLE;
	    return mn_client_session_write(session, "DONE"); /* wake up */
	  }
	break;

      case IDLE_STATE_POST_IDLE:
	if (response->tag)
	  {
	    if (HAS_CURRENT_TAG(response, priv))
	      {
		if (IS_OK(response))
		  {
		    if (REMOVED(priv->self))
		      return STATE_LOGOUT;
		    else if (priv->idle_inactivity)
		      return STATE_IDLE; /* anti-inactivity, re-enter */
		    else
		      return STATE_SEARCH_UNSEEN;
		  }
		else if (IS_NO(response) || IS_BAD(response))
		  {
		    mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
		    return STATE_LOGOUT;
		  }
		else
		  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	      }
	  }
	else if (response->continuation)
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	break;

      default:
	g_assert_not_reached();
	break;
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
  }}
#line 1454 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 982 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1460 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_logout_cb"
{
#line 985 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "LOGOUT");
  }}
#line 1468 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 989 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1474 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_logout_cb"
{
#line 993 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag && HAS_CURRENT_TAG(response, priv))
      {
	if (IS_OK(response))
	  return MN_CLIENT_SESSION_RESULT_DISCONNECT;
	else if (IS_BAD(response))
	  return mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    else
      return MN_CLIENT_SESSION_RESULT_CONTINUE;
  }}
#line 1494 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1009 "mn-imap-mailbox.gob"
static void 
___1e_mn_imap_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 1500 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::authenticated_check"
{
#line 1011 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);
    static const MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,				self_handle_greeting_cb },
      { STATE_CAPABILITY,	self_enter_capability_cb,	self_handle_capability_cb },
#if WITH_SSL
      { STATE_STARTTLS,		self_enter_starttls_cb,		self_handle_starttls_cb },
#endif
#if WITH_SASL
      { STATE_AUTHENTICATE,	self_enter_authenticate_cb,	self_handle_authenticate_cb },
#endif
      { STATE_LOGIN,		self_enter_login_cb,		self_handle_login_cb },
      { STATE_EXAMINE,		self_enter_examine_cb,		self_handle_examine_cb },
      { STATE_SEARCH_UNSEEN,	self_enter_search_unseen_cb,	self_handle_search_unseen_cb },
      { STATE_SEARCH_RECENT,	self_enter_search_recent_cb,	self_handle_search_recent_cb },
      { STATE_FETCH,		self_enter_fetch_cb,		self_handle_fetch_cb },
      { STATE_IDLE,		self_enter_idle_cb,		self_handle_idle_cb },
      { STATE_LOGOUT,		self_enter_logout_cb,		self_handle_logout_cb },

      MN_CLIENT_SESSION_STATES_END
    };
    static const MNClientSessionCallbacks callbacks = {
      mn_pi_mailbox_notice_cb,
      mn_pi_mailbox_warning_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_pre_read_cb,
      self_post_read_cb,
#if WITH_SASL
      mn_pi_mailbox_sasl_get_credentials_cb,
#endif
    };
    MNClientSessionPrivate priv;
    gboolean status;
    GError *err = NULL;
    gboolean again;

    PARENT_HANDLER(mailbox);

    /* check if the parent handler has disabled the mailbox */
    if (! mn_mailbox_get_poll(MN_MAILBOX(self)))
      return;

    do
      {
	g_clear_error(&err);
	again = FALSE;

	memset(&priv, 0, sizeof(priv));
	mn_pi_mailbox_session_private_init(MN_PI_MAILBOX(self), &priv);
	priv.self = self;
	priv.server_software_supports_idle = TRUE; /* assume it does */

	status = mn_client_session_run(states,
				       &callbacks,
#if WITH_SSL
				       priv.pi_mailbox->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_SSL,
#endif
				       priv.pi_mailbox->hostname,
				       priv.pi_mailbox->runtime_port,
				       &priv,
				       &err);

	g_strfreev(priv.capabilities);
	eel_g_slist_free_deep(priv.auth_mechanisms);

	if (priv.unseen_numbers)
	  g_hash_table_destroy(priv.unseen_numbers);
	if (priv.recent_numbers)
	  g_hash_table_destroy(priv.recent_numbers);
	if (priv.received_numbers)
	  g_hash_table_destroy(priv.received_numbers);

	mn_g_object_slist_free(priv.messages);

#if WITH_SASL
	g_slist_free(priv.sasl_remaining_mechanisms);
#endif

	if (priv.could_idle && ! REMOVED(self))
	  {
	    if (status)
	      again = TRUE;
	    /* some servers abruptly disconnect for inactivity */
	    else if (g_error_matches(err, MN_CLIENT_SESSION_ERROR, MN_CLIENT_SESSION_ERROR_CONNECTION_LOST))
	      {
		/* g_log() escapes unsafe and non UTF-8 characters, so this is safe */
		mn_mailbox_notice(priv.mailbox, "%s", err->message);
		again = TRUE;
	      }
	  }
      }
    while (again);

    GDK_THREADS_ENTER();

    mn_mailbox_set_poll(MN_MAILBOX(self), TRUE);
    if (! status)
      {
	char *escaped;

	escaped = mn_utf8_escape(err->message);
	g_error_free(err);

	mn_mailbox_set_error(MN_MAILBOX(self), "%s", escaped);
	g_free(escaped);
      }

    gdk_flush();
    GDK_THREADS_LEAVE();
  }}
#line 1619 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 1123 "mn-imap-mailbox.gob"
static MNClientSessionResponse * 
mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1626 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_new_cb"
{
#line 1127 "mn-imap-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    /*
     * About character set handling:
     *
     * RFC 3501 section 1.2 specifies that "characters are 7-bit
     * US-ASCII unless otherwise specified", and the ABNF formal
     * syntax found in section 9 confirms it. However, we follow the
     * RFC 793 robustness principle ("be liberal in what you accept")
     * and do not require responses to be valid 7-bit US-ASCII.
     *
     * Safety:
     *   - we ensure that GTK+ will only receive UTF-8 data by
     *     escaping error messages in authenticated_check()
     *   - responses ending up in mn_mailbox_notice() need not be
     *     valid UTF-8, since g_log() escapes unsafe and non UTF-8
     *     characters
     *   - messages do not go through this function; they are handled
     *     in handle_fetch_cb() and passed to our mn-message-mime
     *     implementation, which handles character set conversions
     */

    if (! strcmp(input, "+"))
      {
	response = g_new0(MNClientSessionResponse, 1);
	response->continuation = g_strdup("");
      }
    else if (g_str_has_prefix(input, "+ "))
      {
	response = g_new0(MNClientSessionResponse, 1);
	response->continuation = g_strdup(input + 2);
      }
    else
      {
	char **tokens;

	tokens = g_strsplit(input, " ", 3);
	if (tokens[0] && tokens[1])
	  {
	    if (tokens[2] && tokens[2][0] == '[')
	      {
		char *code_start;
		char *code_end;

		code_start = tokens[2] + 1;
		code_end = strchr(code_start, ']');
		if (code_end)
		  {
		    response = g_new0(MNClientSessionResponse, 1);
		    response->code = g_strndup(code_start, code_end - code_start);
		    response->arguments = code_end[1] ? g_strdup(code_end + 2) : NULL;
		  }
	      }
	    else
	      {
		response = g_new0(MNClientSessionResponse, 1);
		response->arguments = g_strdup(tokens[2]);
	      }

	    if (response)
	      {
		response->tag = ! strcmp(tokens[0], "*") ? NULL : g_strdup(tokens[0]);
		response->response = g_strdup(tokens[1]);
	      }
	  }
	g_strfreev(tokens);
      }

    return response;
  }}
#line 1702 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1199 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1708 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_free_cb"
{
#line 1203 "mn-imap-mailbox.gob"
	
    g_free(response->continuation);
    g_free(response->tag);
    g_free(response->response);
    g_free(response->code);
    g_free(response->arguments);
    g_free(response);
  }}
#line 1721 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1212 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_default_handler (MNClientSessionResponse * response, MNClientSessionPrivate * priv, int error_code_when_bye)
#line 1727 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::default_handler"
#line 1212 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 1212 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1734 "mn-imap-mailbox.c"
{
#line 1216 "mn-imap-mailbox.gob"
	
    if (! response->tag && IS_BYE(response))
      return mn_client_session_set_error_from_response(priv->session, error_code_when_bye, response->arguments);
    else
      return MN_CLIENT_SESSION_RESULT_CONTINUE;
  }}
#line 1743 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1223 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1749 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::pre_read_cb"
{
#line 1226 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLE)
      {
	Self *self = priv->self;

	g_mutex_lock(selfp->mutex);

	selfp->idle_session = priv;

	/* cycle IDLE in 29 minutes, as advised by RFC 2177 */

	g_assert(priv->idle_inactivity_timeout_id == 0);
	priv->idle_inactivity_timeout_id = g_timeout_add(60 * 29 * 1000, self_idle_inactivity_timeout_cb, self);

	g_mutex_unlock(selfp->mutex);
      }
  }}
#line 1771 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1244 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1777 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::post_read_cb"
{
#line 1247 "mn-imap-mailbox.gob"
	
    Self *self = priv->self;

    g_mutex_lock(selfp->mutex);
    if (priv->idle_state >= IDLE_STATE_IDLE)
      {
	selfp->idle_session = NULL;
	mn_source_clear(&priv->idle_inactivity_timeout_id);
      }
    g_mutex_unlock(selfp->mutex);
  }}
#line 1793 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1259 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_idle_inactivity_timeout_cb (gpointer data)
#line 1799 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::idle_inactivity_timeout_cb"
{
#line 1261 "mn-imap-mailbox.gob"
	
    Self *self = data;

    g_mutex_lock(selfp->mutex);
    if (selfp->idle_session)
      {
	mn_client_session_write(selfp->idle_session->session, "DONE");
	selfp->idle_session->idle_state = IDLE_STATE_POST_IDLE;
	selfp->idle_session->idle_inactivity = TRUE;
      }
    selfp->idle_session->idle_inactivity_timeout_id = 0;
    g_mutex_unlock(selfp->mutex);

    return FALSE;
  }}
#line 1819 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1277 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...)
#line 1825 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_write"
#line 1277 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1277 "mn-imap-mailbox.gob"
	g_return_val_if_fail (format != NULL, (int )0);
#line 1832 "mn-imap-mailbox.c"
{
#line 1281 "mn-imap-mailbox.gob"
	
    va_list args;
    char *command;
    int result;

    va_start(args, format);
    command = g_strdup_vprintf(format, args);
    va_end(args);

    if (priv->numeric_tag == 1000)
      priv->numeric_tag = 0;
    sprintf(priv->tag, "a%03i", priv->numeric_tag++);

    result = mn_client_session_write(priv->session, "%s %s", priv->tag, command);
    g_free(command);

    return result;
  }}
#line 1853 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1300 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_handle_capability_code (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1859 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_code"
#line 1300 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (gboolean )0);
#line 1300 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (gboolean )0);
#line 1866 "mn-imap-mailbox.c"
{
#line 1303 "mn-imap-mailbox.gob"
	
    if (response->code)
      {
	if (! g_ascii_strcasecmp(response->code, "CAPABILITY"))
	  {
	    self_session_parse_capabilities(priv, NULL);
	    return TRUE;
	  }
	else if (mn_ascii_str_case_has_prefix(response->code, "CAPABILITY "))
	  {
	    self_session_parse_capabilities(priv, response->code + 11);
	    return TRUE;
	  }
      }

    return FALSE;
  }}
#line 1886 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1321 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities)
#line 1892 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_parse_capabilities"
#line 1321 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1897 "mn-imap-mailbox.c"
{
#line 1324 "mn-imap-mailbox.gob"
	
    g_strfreev(priv->capabilities);
    priv->capabilities = NULL;

    mn_g_slist_clear_deep(&priv->auth_mechanisms);

#if WITH_SASL
    mn_g_slist_clear(&priv->sasl_remaining_mechanisms);
#endif

    if (capabilities)
      {
	int i;

	priv->capabilities = g_strsplit(capabilities, " ", 0);

	for (i = 0; priv->capabilities[i]; i++)
	  if (g_str_has_prefix(priv->capabilities[i], "AUTH="))
	    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(priv->capabilities[i] + 5));
      }
    else
      priv->capabilities = g_new0(char *, 1);
  }}
#line 1923 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1348 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability)
#line 1929 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_has_capability"
#line 1348 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (gboolean )0);
#line 1348 "mn-imap-mailbox.gob"
	g_return_val_if_fail (capability != NULL, (gboolean )0);
#line 1936 "mn-imap-mailbox.c"
{
#line 1351 "mn-imap-mailbox.gob"
	
    int i;

    g_return_val_if_fail(priv->capabilities != NULL, FALSE);

    for (i = 0; priv->capabilities[i]; i++)
      if (! g_ascii_strcasecmp(priv->capabilities[i], capability))
	return TRUE;

    return FALSE;
  }}
#line 1950 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1363 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv)
#line 1956 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_after_capability"
#line 1363 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1961 "mn-imap-mailbox.c"
{
#line 1365 "mn-imap-mailbox.gob"
	
    if (priv->authenticated)
      return STATE_EXAMINE;
    else
      {
#if WITH_SSL
	if (priv->pi_mailbox->connection_type == MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL
	    && ! priv->starttls_completed)
	  {
	    if (self_session_has_capability(priv, "STARTTLS"))
	      return STATE_STARTTLS;
	    else
	      {
		mn_client_session_set_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("server does not support in-band SSL/TLS"));
		return STATE_LOGOUT;
	      }
	  }
#endif /* WITH_SSL */
	return self_session_authenticate(priv);
      }
  }}
#line 1985 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1387 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1991 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate"
#line 1387 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1996 "mn-imap-mailbox.c"
{
#line 1389 "mn-imap-mailbox.gob"
	
#if WITH_SASL
    g_slist_free(priv->sasl_remaining_mechanisms);
    priv->sasl_remaining_mechanisms = g_slist_copy(priv->auth_mechanisms);
#endif /* WITH_SASL */

    if (priv->pi_mailbox->authmech)
      {
	if (*priv->pi_mailbox->authmech != '+')
	  {
#if WITH_SASL
	    return STATE_AUTHENTICATE;
#else
	    mn_client_session_set_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
	    return STATE_LOGOUT;
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->pi_mailbox->authmech, "+LOGIN"))
	      return STATE_LOGIN;
	    else
	      {
		mn_client_session_set_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("unknown authentication mechanism \"%s\""), priv->pi_mailbox->authmech);
		return STATE_LOGOUT;
	      }
	  }
      }
    else
      {
#if WITH_SASL
	if (priv->sasl_remaining_mechanisms)
	  return STATE_AUTHENTICATE;
#endif /* WITH_SASL */
	return STATE_LOGIN;
      }
  }}
#line 2036 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1427 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_login)
#line 2042 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate_fallback"
#line 1427 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 2047 "mn-imap-mailbox.c"
{
#line 1430 "mn-imap-mailbox.gob"
	
    if (! priv->pi_mailbox->authmech)
      {
#if WITH_SASL
	if (priv->sasl_mechanism)
	  {
	    GSList *elem;

	    elem = mn_g_str_slist_find(priv->sasl_remaining_mechanisms, priv->sasl_mechanism);
	    if (elem)
	      {
		priv->sasl_remaining_mechanisms = g_slist_delete_link(priv->sasl_remaining_mechanisms, elem);
		if (priv->sasl_remaining_mechanisms)
		  {
		    mn_client_session_notice(priv->session, _("disabling mechanism \"%s\" and retrying SASL authentication"), priv->sasl_mechanism);
		    return STATE_AUTHENTICATE;
		  }
	      }
	  }

	/* SASL is not needed anymore, save some memory */
	mn_client_session_sasl_dispose(priv->session);
#endif /* WITH_SASL */

	if (! tried_login)
	  {
	    mn_client_session_notice(priv->session, _("falling back to IMAP LOGIN authentication"));
	    return STATE_LOGIN;
	  }
      }

    if (priv->pi_mailbox->auth_prompted)
      {
	mn_pi_mailbox_auth_failed(priv->pi_mailbox);
	return self_session_authenticate(priv);
      }
    else
      {
	mn_client_session_set_error(priv->session, MN_CLIENT_SESSION_ERROR_OTHER, _("authentication failed"));
	return STATE_LOGOUT;
      }
  }}
#line 2092 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1473 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_detect_imapd (MNClientSession * session, MNClientSessionResponse * greeting_response, MNClientSessionPrivate * priv)
#line 2098 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_detect_imapd"
#line 1473 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1473 "mn-imap-mailbox.gob"
	g_return_if_fail (greeting_response != NULL);
#line 1473 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 2107 "mn-imap-mailbox.c"
{
#line 1477 "mn-imap-mailbox.gob"
	
    if (greeting_response->arguments)
      {
	char *str;

	/*
	 * Try to detect UW imapd by looking for " IMAP4rev1 YEAR."
	 */

	if ((str = mn_strstr_span(greeting_response->arguments, " IMAP4rev1 "))
	    && strspn(str, "0123456789") == 4
	    && str[4] == '.')
	  {
	    priv->server_software = "UW imapd";
	    priv->server_software_supports_idle = FALSE;
	    return;
	  }
      }
  }}
#line 2129 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1497 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_enter_search (MNClientSession * session, MNClientSessionPrivate * priv, const char * what, GHashTable ** numbers)
#line 2135 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_enter_search"
#line 1497 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 1497 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1497 "mn-imap-mailbox.gob"
	g_return_val_if_fail (what != NULL, (int )0);
#line 1497 "mn-imap-mailbox.gob"
	g_return_val_if_fail (numbers != NULL, (int )0);
#line 2146 "mn-imap-mailbox.c"
{
#line 1502 "mn-imap-mailbox.gob"
	
    priv->search_received = FALSE;

    if (*numbers)
      g_hash_table_destroy(*numbers);
    *numbers = g_hash_table_new(g_direct_hash, g_direct_equal);

    return self_session_write(priv, "SEARCH %s", what);
  }}
#line 2158 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1512 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_handle_search (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv, GHashTable * numbers)
#line 2164 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_handle_search"
#line 1512 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 1512 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 1512 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1512 "mn-imap-mailbox.gob"
	g_return_val_if_fail (numbers != NULL, (int )0);
#line 2175 "mn-imap-mailbox.c"
{
#line 1517 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->search_received)
		  return 0;	/* success; caller must switch state itself */
		else		/* compliance error */
		  return mn_client_session_set_error(session, MN_CLIENT_SESSION_ERROR_OTHER, _("server did not send search results"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      {
		mn_client_session_set_error_from_response(session, MN_CLIENT_SESSION_ERROR_OTHER, response->arguments);
		return STATE_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "SEARCH"))
      {
	if (response->arguments)
	  {
	    char **strings;
	    int i;

	    strings = g_strsplit(response->arguments, " ", 0);

	    for (i = 0; strings[i]; i++)
	      if (mn_str_isnumeric(strings[i]))
		{
		  int n = atoi(strings[i]);
		  g_hash_table_insert(numbers, GINT_TO_POINTER(n), GINT_TO_POINTER(TRUE));
		}

	    g_strfreev(strings);
	  }

	priv->search_received = TRUE;
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }

    return self_default_handler(response, priv, MN_CLIENT_SESSION_ERROR_OTHER);
  }}
#line 2226 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_imap_mailbox_quote:
 * @str: the string to quote
 *
 * Quotes a string using RFC 3501 BNF rules.
 *
 * Return value: the quoted string.
 **/
#line 1574 "mn-imap-mailbox.gob"
static char * 
mn_imap_mailbox_quote (const char * str)
#line 2240 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::quote"
#line 1574 "mn-imap-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 2245 "mn-imap-mailbox.c"
{
#line 1576 "mn-imap-mailbox.gob"
	
    GString *quoted;
    int i;

    quoted = g_string_new("\"");
    for (i = 0; str[i]; i++)
      if (str[i] == '"' || str[i] == '\\') /* quoted-specials in BNF */
	g_string_append_printf(quoted, "\\%c", str[i]);
      else
	g_string_append_c(quoted, str[i]);
    g_string_append_c(quoted, '"');

    return g_string_free(quoted, FALSE);
  }}
#line 2262 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_imap_mailbox_utf8_to_imap_utf7:
 * @str: the UTF-8 string to convert to modified UTF-7
 *
 * Converts a string from UTF-8 to modified UTF-7 as defined by RFC 3501.
 *
 * Return value: the string converted to modified UTF-7.
 **/
#line 1599 "mn-imap-mailbox.gob"
static char * 
mn_imap_mailbox_utf8_to_imap_utf7 (const char * str)
#line 2276 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::utf8_to_imap_utf7"
#line 1599 "mn-imap-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 2281 "mn-imap-mailbox.c"
{
#line 1601 "mn-imap-mailbox.gob"
	
    gunichar c;
    guint32 x, v = 0;
    int state = 0;
    GString *out;
    int i = 0;

    /*
     * Taken from the Ximian Evolution sources (camel-utf8.c) and
     * edited for style.
     */

    out = g_string_new(NULL);

    while ((c = g_utf8_get_char(str)))
      {
	if (c >= 0x20 && c <= 0x7e)
	  {
	    if (state == 1)
	      {
		self_imap_utf7_closeb64(out, v, i);
		state = 0;
		i = 0;
	      }
	    if (c == '&')
	      g_string_append(out, "&-");
	    else
	      g_string_append_c(out, c);
	  }
	else
	  {
	    if (state == 0)
	      {
		g_string_append_c(out, '&');
		state = 1;
	      }

	    v = (v << 16) | c;
	    i += 16;

	    while (i >= 6)
	      {
		x = (v >> (i - 6)) & 0x3f;
		g_string_append_c(out, utf7_alphabet[x]);
		i -= 6;
	      }
	  }

	str = g_utf8_next_char(str);
      }

    if (state == 1)
      self_imap_utf7_closeb64(out, v, i);

    return g_string_free(out, FALSE);
  }}
#line 2340 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1658 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_imap_utf7_closeb64 (GString * out, guint32 v, guint32 i)
#line 2346 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::imap_utf7_closeb64"
#line 1658 "mn-imap-mailbox.gob"
	g_return_if_fail (out != NULL);
#line 2351 "mn-imap-mailbox.c"
{
#line 1660 "mn-imap-mailbox.gob"
	
    /*
     * Taken from the Ximian Evolution sources (camel-utf8.c) and
     * edited for style.
     */

    if (i > 0)
      {
	guint32 x;

	x = (v << (6 - i)) & 0x3f;
	g_string_append_c(out, utf7_alphabet[x]);
      }

    g_string_append_c(out, '-');
  }}
#line 2370 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1677 "mn-imap-mailbox.gob"
char * 
mn_imap_mailbox_build_name (const char * username, const char * server, const char * mailbox)
#line 2376 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::build_name"
#line 1677 "mn-imap-mailbox.gob"
	g_return_val_if_fail (server != NULL, (char * )0);
#line 2381 "mn-imap-mailbox.c"
{
#line 1681 "mn-imap-mailbox.gob"
	
    GString *name;

    name = g_string_new(NULL);

    if (username)
      g_string_append_printf(name, "%s@", username);

    g_string_append(name, server);

    if (mailbox && mn_utf8_strcasecmp(mailbox, "INBOX"))
      g_string_append_printf(name, "/%s", mailbox);

    return g_string_free(name, FALSE);
  }}
#line 2399 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
