/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-text-table.h"

#include "mn-text-table-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 38 "mn-text-table.gob"

#include "mn-util.h"

#define HORIZONTAL_SPACING	12
#define VERTICAL_SPACING	0

#define COLUMN_SIZE(self, column) \
  g_array_index((self)->_priv->column_sizes, int, (column))

struct _MNTextTableCell
{
  PangoLayout	*layout;	/* NULL for a blank cell */
  gboolean	dirty;
  int		width;
  int		height;
};

#line 44 "mn-text-table.c"
/* self casting macros */
#define SELF(x) MN_TEXT_TABLE(x)
#define SELF_CONST(x) MN_TEXT_TABLE_CONST(x)
#define IS_SELF(x) MN_IS_TEXT_TABLE(x)
#define TYPE_SELF MN_TYPE_TEXT_TABLE
#define SELF_CLASS(x) MN_TEXT_TABLE_CLASS(x)

#define SELF_GET_CLASS(x) MN_TEXT_TABLE_GET_CLASS(x)

/* self typedefs */
typedef MNTextTable Self;
typedef MNTextTableClass SelfClass;

/* here are local prototypes */
static void mn_text_table_class_init (MNTextTableClass * c) G_GNUC_UNUSED;
static void mn_text_table_init (MNTextTable * self) G_GNUC_UNUSED;
static void mn_text_table_row_free (Row * row) G_GNUC_UNUSED;
static void mn_text_table_cell_free (MNTextTableCell * cell) G_GNUC_UNUSED;
static gboolean ___4_mn_text_table_expose_event (GtkWidget * widget, GdkEventExpose * event) G_GNUC_UNUSED;
static void ___5_mn_text_table_size_request (GtkWidget * widget, GtkRequisition * requisition) G_GNUC_UNUSED;
static void mn_text_table_set_dirty (MNTextTable * self) G_GNUC_UNUSED;
static void mn_text_table_context_changed (MNTextTable * self) G_GNUC_UNUSED;
static void mn_text_table_relayout (MNTextTable * self) G_GNUC_UNUSED;
static void mn_text_table_redraw (MNTextTable * self) G_GNUC_UNUSED;
static void ___real_mn_text_table_clear (MNTextTable * self);
static void mn_text_table_append_cell_real (MNTextTable * self, MNTextTableCell * cell) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkDrawingAreaClass *parent_class = NULL;

/* Short form macros */
#define self_row_free mn_text_table_row_free
#define self_cell_free mn_text_table_cell_free
#define self_set_dirty mn_text_table_set_dirty
#define self_context_changed mn_text_table_context_changed
#define self_relayout mn_text_table_relayout
#define self_redraw mn_text_table_redraw
#define self_clear mn_text_table_clear
#define self_append_text_cell mn_text_table_append_text_cell
#define self_append_text_cell_from_markup mn_text_table_append_text_cell_from_markup
#define self_append_text_cell_from_layout mn_text_table_append_text_cell_from_layout
#define self_append_blank_cell mn_text_table_append_blank_cell
#define self_append_cell_real mn_text_table_append_cell_real
#define self_cell_set_text mn_text_table_cell_set_text
#define self_line_break mn_text_table_line_break
GType
mn_text_table_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNTextTableClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_text_table_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNTextTable),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_text_table_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_DRAWING_AREA, "MNTextTable", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNTextTable *)g_object_new(mn_text_table_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNTextTable * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNTextTable *
GET_NEW_VARG (const char *first, ...)
{
	MNTextTable *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNTextTable *)g_object_new_valist (mn_text_table_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Text:Table::finalize"
	MNTextTable *self G_GNUC_UNUSED = MN_TEXT_TABLE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#define rows (self->_priv->rows)
#define VAR rows
	{
#line 80 "mn-text-table.gob"
	 mn_g_queue_free_deep_custom(VAR, (GFunc) self_row_free, NULL); }
#line 146 "mn-text-table.c"
	memset(&rows, 0, sizeof(rows));
#undef VAR
#undef rows
#define column_sizes (self->_priv->column_sizes)
#define VAR column_sizes
	{
#line 83 "mn-text-table.gob"
	 g_array_free(VAR, TRUE); }
#line 155 "mn-text-table.c"
	memset(&column_sizes, 0, sizeof(column_sizes));
#undef VAR
#undef column_sizes
}
#undef __GOB_FUNCTION__

static void 
mn_text_table_class_init (MNTextTableClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Text:Table::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	g_type_class_add_private(c,sizeof(MNTextTablePrivate));

	parent_class = g_type_class_ref (GTK_TYPE_DRAWING_AREA);

#line 117 "mn-text-table.gob"
	gtk_widget_class->expose_event = ___4_mn_text_table_expose_event;
#line 128 "mn-text-table.gob"
	gtk_widget_class->size_request = ___5_mn_text_table_size_request;
#line 271 "mn-text-table.gob"
	c->clear = ___real_mn_text_table_clear;
#line 179 "mn-text-table.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 91 "mn-text-table.gob"
static void 
mn_text_table_init (MNTextTable * self G_GNUC_UNUSED)
#line 186 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_TEXT_TABLE,MNTextTablePrivate);
#line 79 "mn-text-table.gob"
	self->_priv->rows = g_queue_new();
#line 192 "mn-text-table.c"
#line 82 "mn-text-table.gob"
	self->_priv->column_sizes = g_array_new(FALSE, TRUE, sizeof(int));
#line 195 "mn-text-table.c"
#line 83 "mn-text-table.gob"
	self->_priv->dirty = TRUE;
#line 198 "mn-text-table.c"
 {
#line 92 "mn-text-table.gob"

    /* allow consumers to receive button-press-event */
    gtk_widget_add_events(GTK_WIDGET(self), GDK_BUTTON_PRESS_MASK);

    g_object_connect(self,
		     "swapped-signal::style-set", self_context_changed, self,
		     "swapped-signal::direction-changed", self_context_changed, self,
		     NULL);
  
#line 210 "mn-text-table.c"
 }
}
#undef __GOB_FUNCTION__



#line 102 "mn-text-table.gob"
static void 
mn_text_table_row_free (Row * row)
#line 220 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::row_free"
#line 102 "mn-text-table.gob"
	g_return_if_fail (row != NULL);
#line 225 "mn-text-table.c"
{
#line 104 "mn-text-table.gob"
	
    mn_g_queue_free_deep_custom(row->cells, (GFunc) self_cell_free, NULL);
    g_free(row);
  }}
#line 232 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 109 "mn-text-table.gob"
static void 
mn_text_table_cell_free (MNTextTableCell * cell)
#line 238 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::cell_free"
#line 109 "mn-text-table.gob"
	g_return_if_fail (cell != NULL);
#line 243 "mn-text-table.c"
{
#line 111 "mn-text-table.gob"
	
    if (cell->layout)
      g_object_unref(cell->layout);
    g_free(cell);
  }}
#line 251 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 117 "mn-text-table.gob"
static gboolean 
___4_mn_text_table_expose_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventExpose * event)
#line 257 "mn-text-table.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->expose_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->expose_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Text:Table::expose_event"
{
#line 119 "mn-text-table.gob"
	
    Self *self = SELF(widget);

    self_relayout(self);
    self_redraw(self);

    return FALSE;		/* propagate event */
  }}
#line 274 "mn-text-table.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 128 "mn-text-table.gob"
static void 
___5_mn_text_table_size_request (GtkWidget * widget G_GNUC_UNUSED, GtkRequisition * requisition)
#line 281 "mn-text-table.c"
#define PARENT_HANDLER(___widget,___requisition) \
	{ if(GTK_WIDGET_CLASS(parent_class)->size_request) \
		(* GTK_WIDGET_CLASS(parent_class)->size_request)(___widget,___requisition); }
{
#define __GOB_FUNCTION__ "MN:Text:Table::size_request"
{
#line 130 "mn-text-table.gob"
	
    Self *self = SELF(widget);

    self_relayout(self);

    requisition->width = selfp->width;
    requisition->height = selfp->height;
  }}
#line 297 "mn-text-table.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 139 "mn-text-table.gob"
static void 
mn_text_table_set_dirty (MNTextTable * self)
#line 304 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::set_dirty"
#line 139 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 139 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 311 "mn-text-table.c"
{
#line 141 "mn-text-table.gob"
	
    if (! selfp->dirty)
      {
	selfp->dirty = TRUE;
	gtk_widget_queue_resize(GTK_WIDGET(self));
      }
  }}
#line 321 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 149 "mn-text-table.gob"
static void 
mn_text_table_context_changed (MNTextTable * self)
#line 327 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::context_changed"
#line 149 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 149 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 334 "mn-text-table.c"
{
#line 151 "mn-text-table.gob"
	
    GList *la;

    MN_QUEUE_FOREACH(la, selfp->rows)
      {
	Row *row = la->data;
	GList *lb;

	MN_QUEUE_FOREACH(lb, row->cells)
	  {
	    MNTextTableCell *cell = lb->data;

	    if (cell->layout)
	      {
		pango_layout_context_changed(cell->layout);
		cell->dirty = TRUE;
	      }
	  }
      }

    self_set_dirty(self);
  }}
#line 359 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 174 "mn-text-table.gob"
static void 
mn_text_table_relayout (MNTextTable * self)
#line 365 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::relayout"
#line 174 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 174 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 372 "mn-text-table.c"
{
#line 176 "mn-text-table.gob"
	
    int i;
    GList *la;

    if (! selfp->dirty)
      return;

    selfp->width = 0;
    selfp->height = 0;

    for (i = 0; i < selfp->column_sizes->len; i++)
      COLUMN_SIZE(self, i) = 0;

    MN_QUEUE_FOREACH(la, selfp->rows)
      {
	Row *row = la->data;
	int column = 0;
	GList *lb;

	row->height = 0;

	MN_QUEUE_FOREACH(lb, row->cells)
	  {
	    MNTextTableCell *cell = lb->data;
	    int n_columns = column + 1;

	    if (cell->dirty)
	      {
		g_assert(cell->layout != NULL);

		pango_layout_get_pixel_size(cell->layout, &cell->width, &cell->height);
		cell->dirty = FALSE;
	      }

	    if (n_columns > selfp->column_sizes->len)
	      g_array_set_size(selfp->column_sizes, n_columns);

	    if (cell->width > COLUMN_SIZE(self, column))
	      COLUMN_SIZE(self, column) = cell->width;
	    if (cell->height > row->height)
	      row->height = cell->height;

	    column++;
	  }

	selfp->height += row->height;
      }

    for (i = 0; i < selfp->column_sizes->len; i++)
      selfp->width += COLUMN_SIZE(self, i);

    if (selfp->column_sizes->len > 1)
      selfp->width += HORIZONTAL_SPACING * (selfp->column_sizes->len - 1);
    if (selfp->rows->length > 1)
      selfp->height += VERTICAL_SPACING * (selfp->rows->length - 1);

    selfp->dirty = FALSE;
  }}
#line 433 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 235 "mn-text-table.gob"
static void 
mn_text_table_redraw (MNTextTable * self)
#line 439 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::redraw"
#line 235 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 235 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 446 "mn-text-table.c"
{
#line 237 "mn-text-table.gob"
	
    GtkWidget *widget = GTK_WIDGET(self);
    GList *la;
    int y = 0;

    g_return_if_fail(selfp->dirty == FALSE);

    MN_QUEUE_FOREACH(la, selfp->rows)
      {
	Row *row = la->data;
	GList *lb;
	int x = 0;
	int column = 0;

	MN_QUEUE_FOREACH(lb, row->cells)
	  {
	    MNTextTableCell *cell = lb->data;

	    if (cell->layout)
	      gdk_draw_layout(widget->window, widget->style->text_gc[GTK_WIDGET_STATE(widget)], x, y + row->height - cell->height, cell->layout);

	    x += COLUMN_SIZE(self, column);
	    if (lb->next)
	      x += HORIZONTAL_SPACING;

	    column++;
	  }

	y += row->height;
	if (la->next)
	  y += VERTICAL_SPACING;
      }
  }}
#line 482 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 271 "mn-text-table.gob"
void 
mn_text_table_clear (MNTextTable * self)
#line 488 "mn-text-table.c"
{
	MNTextTableClass *klass;
#line 271 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 271 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 495 "mn-text-table.c"
	klass = MN_TEXT_TABLE_GET_CLASS(self);

	if(klass->clear)
		(*klass->clear)(self);
}
#line 271 "mn-text-table.gob"
static void 
___real_mn_text_table_clear (MNTextTable * self G_GNUC_UNUSED)
#line 504 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::clear"
{
#line 273 "mn-text-table.gob"
	
    Row *row;

    while ((row = g_queue_pop_head(selfp->rows)))
      self_row_free(row);

    g_array_set_size(selfp->column_sizes, 0);

    selfp->row = NULL;

    self_set_dirty(self);
  }}
#line 521 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 286 "mn-text-table.gob"
MNTextTableCell * 
mn_text_table_append_text_cell (MNTextTable * self, const char * text)
#line 527 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::append_text_cell"
#line 286 "mn-text-table.gob"
	g_return_val_if_fail (self != NULL, (MNTextTableCell * )0);
#line 286 "mn-text-table.gob"
	g_return_val_if_fail (MN_IS_TEXT_TABLE (self), (MNTextTableCell * )0);
#line 534 "mn-text-table.c"
{
#line 288 "mn-text-table.gob"
	
    return self_append_text_cell_from_layout(self, gtk_widget_create_pango_layout(GTK_WIDGET(self), text));
  }}
#line 540 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 292 "mn-text-table.gob"
MNTextTableCell * 
mn_text_table_append_text_cell_from_markup (MNTextTable * self, const char * markup)
#line 546 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::append_text_cell_from_markup"
#line 292 "mn-text-table.gob"
	g_return_val_if_fail (self != NULL, (MNTextTableCell * )0);
#line 292 "mn-text-table.gob"
	g_return_val_if_fail (MN_IS_TEXT_TABLE (self), (MNTextTableCell * )0);
#line 292 "mn-text-table.gob"
	g_return_val_if_fail (markup != NULL, (MNTextTableCell * )0);
#line 555 "mn-text-table.c"
{
#line 294 "mn-text-table.gob"
	
    PangoLayout *layout;

    layout = gtk_widget_create_pango_layout(GTK_WIDGET(self), NULL);
    pango_layout_set_markup(layout, markup, -1);

    return self_append_text_cell_from_layout(self, layout);
  }}
#line 566 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 303 "mn-text-table.gob"
MNTextTableCell * 
mn_text_table_append_text_cell_from_layout (MNTextTable * self, PangoLayout * layout)
#line 572 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::append_text_cell_from_layout"
#line 303 "mn-text-table.gob"
	g_return_val_if_fail (self != NULL, (MNTextTableCell * )0);
#line 303 "mn-text-table.gob"
	g_return_val_if_fail (MN_IS_TEXT_TABLE (self), (MNTextTableCell * )0);
#line 303 "mn-text-table.gob"
	g_return_val_if_fail (layout != NULL, (MNTextTableCell * )0);
#line 581 "mn-text-table.c"
{
#line 305 "mn-text-table.gob"
	
    MNTextTableCell *cell;

    cell = g_new(MNTextTableCell, 1);
    cell->layout = layout;
    cell->dirty = TRUE;

    self_append_cell_real(self, cell);

    return cell;
  }}
#line 595 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 317 "mn-text-table.gob"
MNTextTableCell * 
mn_text_table_append_blank_cell (MNTextTable * self, int width, int height)
#line 601 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::append_blank_cell"
#line 317 "mn-text-table.gob"
	g_return_val_if_fail (self != NULL, (MNTextTableCell * )0);
#line 317 "mn-text-table.gob"
	g_return_val_if_fail (MN_IS_TEXT_TABLE (self), (MNTextTableCell * )0);
#line 608 "mn-text-table.c"
{
#line 319 "mn-text-table.gob"
	
    MNTextTableCell *cell;

    cell = g_new(MNTextTableCell, 1);
    cell->layout = NULL;
    cell->dirty = FALSE;
    cell->width = width;
    cell->height = height;

    self_append_cell_real(self, cell);

    return cell;
  }}
#line 624 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 333 "mn-text-table.gob"
static void 
mn_text_table_append_cell_real (MNTextTable * self, MNTextTableCell * cell)
#line 630 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::append_cell_real"
#line 333 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 333 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 637 "mn-text-table.c"
{
#line 335 "mn-text-table.gob"
	
    if (! selfp->row)
      {
	selfp->row = g_new(Row, 1);
	selfp->row->cells = g_queue_new();

	g_queue_push_tail(selfp->rows, selfp->row);
      }

    g_queue_push_tail(selfp->row->cells, cell);

    self_set_dirty(self);
  }}
#line 653 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 349 "mn-text-table.gob"
void 
mn_text_table_cell_set_text (MNTextTable * self, MNTextTableCell * cell, const char * text)
#line 659 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::cell_set_text"
#line 349 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 349 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 349 "mn-text-table.gob"
	g_return_if_fail (cell != NULL);
#line 349 "mn-text-table.gob"
	g_return_if_fail (text != NULL);
#line 670 "mn-text-table.c"
{
#line 353 "mn-text-table.gob"
	
    const char *current_text;

    g_return_if_fail(cell->layout != NULL);

    current_text = pango_layout_get_text(cell->layout);
    if (! current_text || strcmp(current_text, text))
      {
	pango_layout_set_text(cell->layout, text, -1);
	cell->dirty = TRUE;
	self_set_dirty(self);
      }
  }}
#line 686 "mn-text-table.c"
#undef __GOB_FUNCTION__

#line 367 "mn-text-table.gob"
void 
mn_text_table_line_break (MNTextTable * self)
#line 692 "mn-text-table.c"
{
#define __GOB_FUNCTION__ "MN:Text:Table::line_break"
#line 367 "mn-text-table.gob"
	g_return_if_fail (self != NULL);
#line 367 "mn-text-table.gob"
	g_return_if_fail (MN_IS_TEXT_TABLE (self));
#line 699 "mn-text-table.c"
{
#line 369 "mn-text-table.gob"
	
    selfp->row = NULL;
  }}
#line 705 "mn-text-table.c"
#undef __GOB_FUNCTION__
