/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox.h"

#include "mn-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 53 "mn-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include <libgnomevfs/gnome-vfs.h>
#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
#include "mn-system-vfs-mailbox.h"
#include "mn-custom-vfs-mailbox.h"
#endif
#if WITH_POP3
#include "mn-pop3-mailbox.h"
#endif
#if WITH_IMAP
#include "mn-imap-mailbox.h"
#endif
#if WITH_GMAIL
#include "mn-gmail-mailbox.h"
#endif
#if WITH_EVOLUTION
#include "mn-evolution-mailbox.h"
#endif
#include "mn-util.h"
#include "mn-message.h"
#include "mn-conf.h"

struct _MNMailboxConfiguration
{
  GType		type;
  unsigned int	n_parameters;
  GParameter	*parameters;
};

GType mn_mailbox_types[MN_MAILBOX_MAX_TYPES + 1];

typedef struct
{
  GHashTable	*other;
  gboolean	changed;
} CompareMessagesInfo;

#line 67 "mn-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX(x)
#define SELF_CONST(x) MN_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MAILBOX
#define SELF_CLASS(x) MN_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNMailbox Self;
typedef MNMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_mailbox_class_init (MNMailboxClass * c) G_GNUC_UNUSED;
static void ___real_mn_mailbox_added (MNMailbox * self);
static void ___real_mn_mailbox_removed (MNMailbox * self);
static void mn_mailbox_update_check_timeout (MNMailbox * self) G_GNUC_UNUSED;
static void mn_mailbox_filter_messages (MNMailbox * self) G_GNUC_UNUSED;
static gboolean mn_mailbox_clean_messages_marked_as_read_cb (const char * id, MNMessage * message, GHashTable * messages) G_GNUC_UNUSED;
static gboolean mn_mailbox_compare_messages (GHashTable * messages1, GHashTable * messages2) G_GNUC_UNUSED;
static void mn_mailbox_compare_messages_cb (const char * id, MNMessage * message, CompareMessagesInfo * info) G_GNUC_UNUSED;
static void mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new) G_GNUC_UNUSED;
static void mn_mailbox_init (MNMailbox * self) G_GNUC_UNUSED;
static void ___15_mn_mailbox_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_mailbox_notify_display_seen_messages_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static MNMailbox * mn_mailbox_parse_obsolete_uri (const char * uri) G_GNUC_UNUSED;
static gboolean mn_mailbox_check_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean mn_mailbox_validate (MNMailbox * self, GError ** err) G_GNUC_UNUSED;
static void ___real_mn_mailbox_seal (MNMailbox * self);
static MNMailbox * mn_mailbox_parse_uri (MNMailbox * self, const char * uri) G_GNUC_UNUSED;
static void ___real_mn_mailbox_check (MNMailbox * self);

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__added(object,func,data)	mn_mailbox_connect__added((object),(func),(data))
#define self_connect_after__added(object,func,data)	mn_mailbox_connect_after__added((object),(func),(data))
#define self_connect_data__added(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__added((object),(func),(data),(destroy_data),(flags))
#define self_connect__removed(object,func,data)	mn_mailbox_connect__removed((object),(func),(data))
#define self_connect_after__removed(object,func,data)	mn_mailbox_connect_after__removed((object),(func),(data))
#define self_connect_data__removed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailbox_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailbox_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailbox *, gboolean , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailbox *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	ADDED_SIGNAL,
	REMOVED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_NAME,
	PROP_OPEN_COMMAND,
	PROP_MARK_AS_READ_COMMAND,
	PROP_MARK_AS_SPAM_COMMAND,
	PROP_STOCK_ID,
	PROP_FORMAT,
	PROP_CHECK_DELAY,
	PROP_POLL,
	PROP_MESSAGES,
	PROP_ERROR
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_added mn_mailbox_added
#define self_removed mn_mailbox_removed
#define self_get_stock_id mn_mailbox_get_stock_id
#define self_set_stock_id mn_mailbox_set_stock_id
#define self_get_format mn_mailbox_get_format
#define self_set_format mn_mailbox_set_format
#define self_get_poll mn_mailbox_get_poll
#define self_set_poll mn_mailbox_set_poll
#define self_update_check_timeout mn_mailbox_update_check_timeout
#define self_get_messages mn_mailbox_get_messages
#define self_set_messages mn_mailbox_set_messages
#define self_filter_messages mn_mailbox_filter_messages
#define self_clean_messages_marked_as_read_cb mn_mailbox_clean_messages_marked_as_read_cb
#define self_compare_messages mn_mailbox_compare_messages
#define self_compare_messages_cb mn_mailbox_compare_messages_cb
#define self_messages_changed mn_mailbox_messages_changed
#define self_set_error mn_mailbox_set_error
#define self_init_types mn_mailbox_init_types
#define self_get_type_from_name mn_mailbox_get_type_from_name
#define self_notify_display_seen_messages_cb mn_mailbox_notify_display_seen_messages_cb
#define self_new mn_mailbox_new
#define self_new_from_xml_node mn_mailbox_new_from_xml_node
#define self_xml_node_new mn_mailbox_xml_node_new
#define self_new_from_uri mn_mailbox_new_from_uri
#define self_new_from_configuration mn_mailbox_new_from_configuration
#define self_get_configuration mn_mailbox_get_configuration
#define self_configuration_free mn_mailbox_configuration_free
#define self_new_from_obsolete_uri mn_mailbox_new_from_obsolete_uri
#define self_parse_obsolete_uri mn_mailbox_parse_obsolete_uri
#define self_check_timeout_cb mn_mailbox_check_timeout_cb
#define self_validate mn_mailbox_validate
#define self_seal mn_mailbox_seal
#define self_parse_uri mn_mailbox_parse_uri
#define self_check mn_mailbox_check
#define self_notice mn_mailbox_notice
#define self_warning mn_mailbox_warning
#define self_mark_as_read mn_mailbox_mark_as_read
#define self_get_command mn_mailbox_get_command
#define self_has_command mn_mailbox_has_command
GType
mn_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailbox *)g_object_new(mn_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailbox *)g_object_new_valist (mn_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 450 "mn-mailbox.gob"
	___15_mn_mailbox_finalize(obj_self);
#line 265 "mn-mailbox.c"
#line 130 "mn-mailbox.gob"
	if(self->runtime_name) { g_free ((gpointer) self->runtime_name); self->runtime_name = NULL; }
#line 268 "mn-mailbox.c"
#line 132 "mn-mailbox.gob"
	if(self->name) { g_free ((gpointer) self->name); self->name = NULL; }
#line 271 "mn-mailbox.c"
#line 135 "mn-mailbox.gob"
	if(self->open_command) { g_free ((gpointer) self->open_command); self->open_command = NULL; }
#line 274 "mn-mailbox.c"
#line 138 "mn-mailbox.gob"
	if(self->mark_as_read_command) { g_free ((gpointer) self->mark_as_read_command); self->mark_as_read_command = NULL; }
#line 277 "mn-mailbox.c"
#line 141 "mn-mailbox.gob"
	if(self->mark_as_spam_command) { g_free ((gpointer) self->mark_as_spam_command); self->mark_as_spam_command = NULL; }
#line 280 "mn-mailbox.c"
#line 144 "mn-mailbox.gob"
	if(self->stock_id) { g_free ((gpointer) self->stock_id); self->stock_id = NULL; }
#line 283 "mn-mailbox.c"
#line 147 "mn-mailbox.gob"
	if(self->format) { g_free ((gpointer) self->format); self->format = NULL; }
#line 286 "mn-mailbox.c"
#line 192 "mn-mailbox.gob"
	if(self->_priv->unfiltered_messages) { mn_g_object_slist_free ((gpointer) self->_priv->unfiltered_messages); self->_priv->unfiltered_messages = NULL; }
#line 289 "mn-mailbox.c"
#line 194 "mn-mailbox.gob"
	if(self->_priv->messages_marked_as_read) { g_hash_table_destroy ((gpointer) self->_priv->messages_marked_as_read); self->_priv->messages_marked_as_read = NULL; }
#line 292 "mn-mailbox.c"
#line 197 "mn-mailbox.gob"
	if(self->messages) { mn_g_object_slist_free ((gpointer) self->messages); self->messages = NULL; }
#line 295 "mn-mailbox.c"
#line 216 "mn-mailbox.gob"
	if(self->_priv->messages_hash_table) { g_hash_table_destroy ((gpointer) self->_priv->messages_hash_table); self->_priv->messages_hash_table = NULL; }
#line 298 "mn-mailbox.c"
#line 362 "mn-mailbox.gob"
	if(self->error) { g_free ((gpointer) self->error); self->error = NULL; }
#line 301 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_class_init (MNMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxPrivate));
#line 53 "mn-mailbox.gob"
	c->default_check_delay = -1;
#line 314 "mn-mailbox.c"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[ADDED_SIGNAL] =
		g_signal_new ("added",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, added),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[REMOVED_SIGNAL] =
		g_signal_new ("removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxClass, messages_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailbox.gob line 359: Type mismatch of \"messages_changed\" signal signature");
	}

#line 108 "mn-mailbox.gob"
	c->added = ___real_mn_mailbox_added;
#line 124 "mn-mailbox.gob"
	c->removed = ___real_mn_mailbox_removed;
#line 351 "mn-mailbox.c"
	c->messages_changed = NULL;
#line 450 "mn-mailbox.gob"
	g_object_class->finalize = ___finalize;
#line 916 "mn-mailbox.gob"
	c->seal = ___real_mn_mailbox_seal;
#line 357 "mn-mailbox.c"
	c->parse_uri = NULL;
#line 933 "mn-mailbox.gob"
	c->check = ___real_mn_mailbox_check;
#line 361 "mn-mailbox.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("open_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_OPEN_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("mark_as_read_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_MARK_AS_READ_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("mark_as_spam_command" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT));
	g_object_class_install_property (g_object_class,
		PROP_MARK_AS_SPAM_COMMAND,
		param_spec);
	param_spec = g_param_spec_string
		("stock_id" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STOCK_ID,
		param_spec);
	param_spec = g_param_spec_string
		("format" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_FORMAT,
		param_spec);
	param_spec = g_param_spec_int
		("check_delay" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 -1 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_PERMANENT | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_CHECK_DELAY,
		param_spec);
	param_spec = g_param_spec_boolean
		("poll" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_POLL,
		param_spec);
	param_spec = g_param_spec_pointer
		("messages" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGES,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 445 "mn-mailbox.gob"
static void 
mn_mailbox_init (MNMailbox * self G_GNUC_UNUSED)
#line 464 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_MAILBOX,MNMailboxPrivate);
#line 126 "mn-mailbox.gob"
	self->_priv->poll = TRUE;
#line 470 "mn-mailbox.c"
#line 194 "mn-mailbox.gob"
	self->_priv->messages_marked_as_read = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_object_unref);
#line 473 "mn-mailbox.c"
 {
#line 446 "mn-mailbox.gob"

    mn_g_object_gconf_notification_add_gdk_locked(self, MN_CONF_DISPLAY_SEEN_MAIL, self_notify_display_seen_messages_cb, self);
  
#line 479 "mn-mailbox.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::set_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 133 "mn-mailbox.gob"
{ char *old = self->name; self->name = g_value_dup_string (VAL); g_free (old); }
#line 500 "mn-mailbox.c"
		}
		break;
	case PROP_OPEN_COMMAND:
		{
#line 136 "mn-mailbox.gob"
{ char *old = self->open_command; self->open_command = g_value_dup_string (VAL); g_free (old); }
#line 507 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_READ_COMMAND:
		{
#line 139 "mn-mailbox.gob"
{ char *old = self->mark_as_read_command; self->mark_as_read_command = g_value_dup_string (VAL); g_free (old); }
#line 514 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_SPAM_COMMAND:
		{
#line 142 "mn-mailbox.gob"
{ char *old = self->mark_as_spam_command; self->mark_as_spam_command = g_value_dup_string (VAL); g_free (old); }
#line 521 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 145 "mn-mailbox.gob"
{ char *old = self->stock_id; self->stock_id = g_value_dup_string (VAL); g_free (old); }
#line 528 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 148 "mn-mailbox.gob"
{ char *old = self->format; self->format = g_value_dup_string (VAL); g_free (old); }
#line 535 "mn-mailbox.c"
		}
		break;
	case PROP_CHECK_DELAY:
		{
#line 155 "mn-mailbox.gob"
self->check_delay = g_value_get_int (VAL);
#line 542 "mn-mailbox.c"
		}
		break;
	case PROP_POLL:
		{
#line 162 "mn-mailbox.gob"

      gboolean new_poll = g_value_get_boolean(VAL);

      /*
       * We do nothing unless the property has changed, because we do
       * not want to reset an already existing check timeout.
       */
      if (new_poll != selfp->poll)
	{
	  selfp->poll = new_poll;
	  if (selfp->added)
	    self_update_check_timeout(self);
	}
    
#line 562 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 205 "mn-mailbox.gob"

      mn_g_object_slist_free(selfp->unfiltered_messages);
      selfp->unfiltered_messages = mn_g_object_slist_copy(g_value_get_pointer(VAL));

      self_filter_messages(self);
    
#line 574 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 365 "mn-mailbox.gob"

      g_free(self->error);
      self->error = g_value_dup_string(VAL);

      /* if an error is set, we unset messages */
      if (self->error)
	self_set_messages(self, NULL);
    
#line 588 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::get_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 133 "mn-mailbox.gob"
g_value_set_string (VAL, self->name);
#line 619 "mn-mailbox.c"
		}
		break;
	case PROP_OPEN_COMMAND:
		{
#line 136 "mn-mailbox.gob"
g_value_set_string (VAL, self->open_command);
#line 626 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_READ_COMMAND:
		{
#line 139 "mn-mailbox.gob"
g_value_set_string (VAL, self->mark_as_read_command);
#line 633 "mn-mailbox.c"
		}
		break;
	case PROP_MARK_AS_SPAM_COMMAND:
		{
#line 142 "mn-mailbox.gob"
g_value_set_string (VAL, self->mark_as_spam_command);
#line 640 "mn-mailbox.c"
		}
		break;
	case PROP_STOCK_ID:
		{
#line 145 "mn-mailbox.gob"
g_value_set_string (VAL, self->stock_id);
#line 647 "mn-mailbox.c"
		}
		break;
	case PROP_FORMAT:
		{
#line 148 "mn-mailbox.gob"
g_value_set_string (VAL, self->format);
#line 654 "mn-mailbox.c"
		}
		break;
	case PROP_CHECK_DELAY:
		{
#line 155 "mn-mailbox.gob"
g_value_set_int (VAL, self->check_delay);
#line 661 "mn-mailbox.c"
		}
		break;
	case PROP_POLL:
		{
#line 177 "mn-mailbox.gob"

      g_value_set_boolean(VAL, selfp->poll);
    
#line 670 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 212 "mn-mailbox.gob"

      g_value_set_pointer(VAL, self->messages);
    
#line 679 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 374 "mn-mailbox.gob"

      g_value_set_string(VAL, self->error);
    
#line 688 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


/**
 * mn_mailbox_added:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is removed from the
 * mailboxes list.
 **/
#line 108 "mn-mailbox.gob"
void 
mn_mailbox_added (MNMailbox * self)
#line 714 "mn-mailbox.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 108 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 108 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 726 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ADDED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 108 "mn-mailbox.gob"
static void 
___real_mn_mailbox_added (MNMailbox * self G_GNUC_UNUSED)
#line 742 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::added"
{
#line 110 "mn-mailbox.gob"
	
    selfp->added = TRUE;

    self_update_check_timeout(self);
    self_check(self);
  }}
#line 753 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_removed:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is removed from the
 * mailboxes list.
 **/
#line 124 "mn-mailbox.gob"
void 
mn_mailbox_removed (MNMailbox * self)
#line 766 "mn-mailbox.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 124 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 124 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 778 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 124 "mn-mailbox.gob"
static void 
___real_mn_mailbox_removed (MNMailbox * self G_GNUC_UNUSED)
#line 794 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::removed"
{
#line 126 "mn-mailbox.gob"
	
    mn_locked_g_source_clear(&selfp->check_timeout_source);
  }}
#line 802 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 145 "mn-mailbox.gob"
gchar * 
mn_mailbox_get_stock_id (MNMailbox * self)
#line 808 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_stock_id"
{
#line 145 "mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "stock_id", &val, NULL); return val;
}}
#line 815 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 145 "mn-mailbox.gob"
void 
mn_mailbox_set_stock_id (MNMailbox * self, gchar * val)
#line 821 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_stock_id"
{
#line 145 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "stock_id", val, NULL);
}}
#line 828 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 148 "mn-mailbox.gob"
gchar * 
mn_mailbox_get_format (MNMailbox * self)
#line 834 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_format"
{
#line 148 "mn-mailbox.gob"
		gchar* val; g_object_get (G_OBJECT (self), "format", &val, NULL); return val;
}}
#line 841 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 148 "mn-mailbox.gob"
void 
mn_mailbox_set_format (MNMailbox * self, gchar * val)
#line 847 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_format"
{
#line 148 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "format", val, NULL);
}}
#line 854 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 177 "mn-mailbox.gob"
gboolean 
mn_mailbox_get_poll (MNMailbox * self)
#line 860 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_poll"
{
#line 160 "mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "poll", &val, NULL); return val;
}}
#line 867 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 162 "mn-mailbox.gob"
void 
mn_mailbox_set_poll (MNMailbox * self, gboolean val)
#line 873 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_poll"
{
#line 160 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "poll", val, NULL);
}}
#line 880 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 181 "mn-mailbox.gob"
static void 
mn_mailbox_update_check_timeout (MNMailbox * self)
#line 886 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::update_check_timeout"
#line 181 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 181 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 893 "mn-mailbox.c"
{
#line 183 "mn-mailbox.gob"
	
    g_assert(selfp->added == TRUE);

    mn_locked_g_source_clear(&selfp->check_timeout_source);
    if (selfp->poll && self->runtime_check_delay > 0)
      selfp->check_timeout_source = mn_g_timeout_add_gdk_locked(self->runtime_check_delay * 1000, self_check_timeout_cb, self);
  }}
#line 903 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 212 "mn-mailbox.gob"
const GSList * 
mn_mailbox_get_messages (MNMailbox * self)
#line 909 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_messages"
{
#line 203 "mn-mailbox.gob"
		const GSList* val; g_object_get (G_OBJECT (self), "messages", &val, NULL); return val;
}}
#line 916 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 205 "mn-mailbox.gob"
void 
mn_mailbox_set_messages (MNMailbox * self, const GSList * val)
#line 922 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_messages"
{
#line 203 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "messages", val, NULL);
}}
#line 929 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_filter_messages:
 * @self: the mailbox to act upon
 *
 * Filter @self->unfiltered_messages with the "seen mail" filter and
 * @selfp->messages_marked_as_read, and store the resulting list in
 * @self->messages. Additionally, if @self->messages has changed,
 * emit the "messages-changed" signal.
 **/
#line 227 "mn-mailbox.gob"
static void 
mn_mailbox_filter_messages (MNMailbox * self)
#line 944 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::filter_messages"
#line 227 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 227 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 951 "mn-mailbox.c"
{
#line 229 "mn-mailbox.gob"
	
    gboolean display_seen_mail;
    GSList *messages = NULL;
    GHashTable *all_messages_hash_table;
    GHashTable *messages_hash_table;
    GSList *l;
    gboolean changed = FALSE;
    gboolean has_new = FALSE;

    /* filter messages */

    self->n_messages = 0;
    self->timestamp = 0;

    all_messages_hash_table = g_hash_table_new(g_str_hash, g_str_equal);
    messages_hash_table = g_hash_table_new(g_str_hash, g_str_equal);
    display_seen_mail = eel_gconf_get_boolean(MN_CONF_DISPLAY_SEEN_MAIL);

    MN_LIST_FOREACH(l, selfp->unfiltered_messages)
      {
	MNMessage *message = l->data;

	g_hash_table_replace(all_messages_hash_table, message->id, message);

	if ((display_seen_mail
	     || message->error
	     || (message->flags & MN_MESSAGE_NEW) != 0)
	    && ! g_hash_table_lookup(selfp->messages_marked_as_read, message->id))
	  {
	    self->n_messages++;
	    if (message->sent_time > self->timestamp)
	      self->timestamp = message->sent_time;

	    messages = g_slist_prepend(messages, g_object_ref(message));
	    g_hash_table_replace(messages_hash_table, message->id, message);
	  }
      }

    /* remove stale messages from messages_marked_as_read */
    g_hash_table_foreach_remove(selfp->messages_marked_as_read, (GHRFunc) self_clean_messages_marked_as_read_cb, all_messages_hash_table);
    g_hash_table_destroy(all_messages_hash_table);

    if (! messages)
      {
	g_hash_table_destroy(messages_hash_table);
	messages_hash_table = NULL;
      }

    /* detect changes */

    if (self_compare_messages(selfp->messages_hash_table, messages_hash_table))
      changed = TRUE;
    if (self_compare_messages(messages_hash_table, selfp->messages_hash_table))
      changed = has_new = TRUE;

    if (self->messages)
      {
	mn_g_object_slist_free(self->messages);
	g_hash_table_destroy(selfp->messages_hash_table);
      }

    self->messages = messages;
    selfp->messages_hash_table = messages_hash_table;

    if (changed)
      self_messages_changed(self, has_new);
  }}
#line 1021 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 297 "mn-mailbox.gob"
static gboolean 
mn_mailbox_clean_messages_marked_as_read_cb (const char * id, MNMessage * message, GHashTable * messages)
#line 1027 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::clean_messages_marked_as_read_cb"
{
#line 301 "mn-mailbox.gob"
	
    return g_hash_table_lookup(messages, id) == NULL;
  }}
#line 1035 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_compare_messages:
 * @messages1: a %GHashTable containing %MNMessage objects
 * @messages2: another %GHashTable containing %MNMessage objects
 *
 * Compares @messages1 and @messages2.
 *
 * Return value: %TRUE if @messages1 contains messages not present
 * in @messages2, %FALSE otherwise.
 **/
#line 315 "mn-mailbox.gob"
static gboolean 
mn_mailbox_compare_messages (GHashTable * messages1, GHashTable * messages2)
#line 1051 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::compare_messages"
{
#line 317 "mn-mailbox.gob"
	
    if (messages1)
      {
	if (messages2)
	  {
	    CompareMessagesInfo info;

	    info.other = messages2;
	    info.changed = FALSE;
	    g_hash_table_foreach(messages1, (GHFunc) self_compare_messages_cb, &info);

	    return info.changed;
	  }
	else
	  return TRUE;
      }
    else
      return FALSE;
  }}
#line 1075 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 337 "mn-mailbox.gob"
static void 
mn_mailbox_compare_messages_cb (const char * id, MNMessage * message, CompareMessagesInfo * info)
#line 1081 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::compare_messages_cb"
{
#line 341 "mn-mailbox.gob"
	
    if (! info->changed && ! g_hash_table_lookup(info->other, id))
      info->changed = TRUE;
  }}
#line 1090 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 359 "mn-mailbox.gob"
static void 
mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new)
#line 1096 "mn-mailbox.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 359 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 359 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1108 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 378 "mn-mailbox.gob"
void 
mn_mailbox_set_error (MNMailbox * self, const char * format, ...)
#line 1130 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_error"
#line 378 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 378 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1137 "mn-mailbox.c"
{
#line 380 "mn-mailbox.gob"
	
    va_list args;
    char *error = NULL;

    if (format)
      {
	va_start(args, format);
	error = g_strdup_vprintf(format, args);
	va_end(args);
      }

    g_object_set(G_OBJECT(self), MN_MAILBOX_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 1154 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 395 "mn-mailbox.gob"
void 
mn_mailbox_init_types (void)
#line 1160 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::init_types"
{
#line 397 "mn-mailbox.gob"
	
    int i = 0;

#if WITH_MBOX || WITH_MOZILLA || WITH_MH || WITH_MAILDIR || WITH_SYLPHEED
    /*
     * MNSystemVFSMailbox must be registered before
     * MNCustomVFSMailbox, because the latter's parse_uri() method
     * will accept any URI.
     */
    mn_mailbox_types[i++] = MN_TYPE_SYSTEM_VFS_MAILBOX;
    mn_mailbox_types[i++] = MN_TYPE_CUSTOM_VFS_MAILBOX;
#endif
#if WITH_POP3
    mn_mailbox_types[i++] = MN_TYPE_POP3_MAILBOX;
#endif
#if WITH_IMAP
    mn_mailbox_types[i++] = MN_TYPE_IMAP_MAILBOX;
#endif
#if WITH_GMAIL
    mn_mailbox_types[i++] = MN_TYPE_GMAIL_MAILBOX;
#endif
#if WITH_EVOLUTION
    mn_mailbox_types[i++] = MN_TYPE_EVOLUTION_MAILBOX;
#endif
    mn_mailbox_types[i] = 0;
  }}
#line 1191 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 424 "mn-mailbox.gob"
GType 
mn_mailbox_get_type_from_name (const char * type)
#line 1197 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_type_from_name"
{
#line 426 "mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	SelfClass *class;
	gboolean found;

	class = g_type_class_ref(mn_mailbox_types[i]);
	found = ! strcmp(class->type, type);
	g_type_class_unref(class);

	if (found)
	  return mn_mailbox_types[i];
      }

    return 0;
  }}
#line 1220 "mn-mailbox.c"
#undef __GOB_FUNCTION__


#line 450 "mn-mailbox.gob"
static void 
___15_mn_mailbox_finalize (GObject * object G_GNUC_UNUSED)
#line 1227 "mn-mailbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
{
#line 452 "mn-mailbox.gob"
	
    Self *self = SELF(object);

    /*
     * Even though we clear the source in removed(), it might have
     * been reinstalled afterwards (by a mn_mailbox_set_poll() call
     * from a check thread, etc).
     */
    if (selfp->check_timeout_source)
      mn_locked_g_source_remove(selfp->check_timeout_source);

    PARENT_HANDLER(object);
  }}
#line 1248 "mn-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 466 "mn-mailbox.gob"
static void 
mn_mailbox_notify_display_seen_messages_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 1255 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::notify_display_seen_messages_cb"
{
#line 471 "mn-mailbox.gob"
	
    Self *self = user_data;

    self_filter_messages(self);
  }}
#line 1265 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 477 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new (const char * type, const char * first, ...)
#line 1271 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new"
#line 477 "mn-mailbox.gob"
	g_return_val_if_fail (type != NULL, (MNMailbox * )0);
#line 1276 "mn-mailbox.c"
{
#line 479 "mn-mailbox.gob"
	
    va_list args;
    GType type_id;
    GObject *object;

    type_id = self_get_type_from_name(type);
    if (! type_id)
      return NULL;

    va_start(args, first);
    object = g_object_new_valist(type_id, first, args);
    va_end(args);

    return SELF(object);
  }}
#line 1294 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 495 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_xml_node (xmlNode * node, GError ** err)
#line 1300 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_xml_node"
#line 495 "mn-mailbox.gob"
	g_return_val_if_fail (node != NULL, (MNMailbox * )0);
#line 1305 "mn-mailbox.c"
{
#line 497 "mn-mailbox.gob"
	
    char *type;
    Self *self = NULL;

    type = xmlGetProp(node, "type");
    if (! type)
      {
	g_set_error(err, 0, 0, _("\"type\" attribute missing"));
	return NULL;
      }

    self = self_new(type, NULL);
    if (! self)
      {
	g_set_error(err, 0, 0, _("unknown mailbox type \"%s\""), type);
	goto end;
      }

    mn_xml_import_properties(G_OBJECT(self), node);

    if (! self_validate(self, err))
      {
	g_object_unref(self);
	self = NULL;
      }

  end:
    g_free(type);
    return self;
  }}
#line 1338 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 528 "mn-mailbox.gob"
xmlNode * 
mn_mailbox_xml_node_new (MNMailbox * self)
#line 1344 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::xml_node_new"
#line 528 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (xmlNode * )0);
#line 528 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (xmlNode * )0);
#line 1351 "mn-mailbox.c"
{
#line 530 "mn-mailbox.gob"
	
    xmlNode *node;

    node = xmlNewNode(NULL, "mailbox");
    xmlSetProp(node, "type", SELF_GET_CLASS(self)->type);
    mn_xml_export_properties(G_OBJECT(self), node);

    return node;
  }}
#line 1363 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 540 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_uri (const char * uri)
#line 1369 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_uri"
#line 540 "mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1374 "mn-mailbox.c"
{
#line 542 "mn-mailbox.gob"
	
    int i;

    for (i = 0; mn_mailbox_types[i]; i++)
      {
	MNMailboxClass *class;
	MNMailbox *mailbox;

	class = g_type_class_ref(mn_mailbox_types[i]);
	mailbox = class->parse_uri ? class->parse_uri(NULL, uri) : NULL;
	g_type_class_unref(class);

	if (mailbox)
	  return mailbox;
      }

    return NULL;
  }}
#line 1395 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 561 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_configuration (MNMailboxConfiguration * config)
#line 1401 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_configuration"
#line 561 "mn-mailbox.gob"
	g_return_val_if_fail (config != NULL, (MNMailbox * )0);
#line 1406 "mn-mailbox.c"
{
#line 563 "mn-mailbox.gob"
	
    return g_object_newv(config->type, config->n_parameters, config->parameters);
  }}
#line 1412 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 567 "mn-mailbox.gob"
MNMailboxConfiguration * 
mn_mailbox_get_configuration (MNMailbox * self)
#line 1418 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_configuration"
#line 567 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxConfiguration * )0);
#line 567 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailboxConfiguration * )0);
#line 1425 "mn-mailbox.c"
{
#line 569 "mn-mailbox.gob"
	
    GObject *object = G_OBJECT(self);
    GArray *parameters;
    GParamSpec **properties;
    unsigned int n_properties;
    int i;
    MNMailboxConfiguration *config;

    parameters = g_array_new(FALSE, FALSE, sizeof(GParameter));

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_PERMANENT) != 0)
	{
	  GParameter parameter = { NULL, { 0, } };

	  parameter.name = g_param_spec_get_name(properties[i]);

	  g_value_init(&parameter.value, G_PARAM_SPEC_VALUE_TYPE(properties[i]));
	  g_object_get_property(object, parameter.name, &parameter.value);

	  g_array_append_val(parameters, parameter);
	}
    g_free(properties);

    config = g_new0(MNMailboxConfiguration, 1);
    config->type = G_OBJECT_TYPE(self);
    config->n_parameters = parameters->len;
    config->parameters = (GParameter *) g_array_free(parameters, FALSE);

    return config;
  }}
#line 1460 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 602 "mn-mailbox.gob"
void 
mn_mailbox_configuration_free (MNMailboxConfiguration * config)
#line 1466 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::configuration_free"
#line 602 "mn-mailbox.gob"
	g_return_if_fail (config != NULL);
#line 1471 "mn-mailbox.c"
{
#line 604 "mn-mailbox.gob"
	
    int i;

    for (i = 0; i < config->n_parameters; i++)
      g_value_unset(&config->parameters[i].value);

    g_free(config->parameters);
    g_free(config);
  }}
#line 1483 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 614 "mn-mailbox.gob"
MNMailbox * 
mn_mailbox_new_from_obsolete_uri (const char * uri)
#line 1489 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_from_obsolete_uri"
#line 614 "mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1494 "mn-mailbox.c"
{
#line 616 "mn-mailbox.gob"
	
    char *real_uri;
    char *scheme;
    gboolean obsolete = FALSE;
    Self *self = NULL;

    real_uri = g_str_has_prefix(uri, "pop3:") /* also handle very old pop3 locators */
      ? g_strconcat("pop://", uri + 5, NULL)
      : g_strdup(uri);

    scheme = gnome_vfs_get_uri_scheme(real_uri);
    if (scheme)
      {
	if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops")
	    || ! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps")
	    || ! strcmp(scheme, "gmail"))
	  obsolete = TRUE;
	g_free(scheme);
      }

    self = obsolete ? self_parse_obsolete_uri(real_uri) : self_new_from_uri(real_uri);
    g_free(real_uri);

    if (self && ! self_validate(self, NULL))
      {
	g_object_unref(self);
	self = NULL;
      }

    return self;
  }}
#line 1528 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 648 "mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_obsolete_uri (const char * uri)
#line 1534 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::parse_obsolete_uri"
#line 648 "mn-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (MNMailbox * )0);
#line 1539 "mn-mailbox.c"
{
#line 650 "mn-mailbox.gob"
	
    int len;
    int buflen;
    char *scheme;
    char *username;
    char *password;
    char *authmech;
    char *hostname;
    int port;
    char *path;
    char **queries;
    Self *self = NULL;

    len = strlen(uri);
    buflen = len + 1;

    {
      char *pat;
      char scheme_buf[buflen];
      char auth_buf[buflen];
      char location_buf[buflen];
      char username_buf[buflen];
      char password_buf[buflen];
      char authmech_buf[buflen];
      char hostname_buf[buflen];
      int _port;
      char path_buf[buflen];
      char queries_buf[buflen];
      gboolean has_location = FALSE;
      gboolean has_password = FALSE;
      gboolean has_authmech = FALSE;
      gboolean has_port = FALSE;
      gboolean has_path = FALSE;
      gboolean has_queries = FALSE;
      int n;

      /* split URI in 3 parts: scheme, auth and location */

      pat = g_strdup_printf("%%%i[^:]://%%%i[^@]@%%%is", len, len, len);
      n = sscanf(uri, pat, scheme_buf, auth_buf, location_buf);
      g_free(pat);

      if (n >= 2)
	{
	  if (n == 3)
	    has_location = TRUE;
	}
      else
	return NULL;		/* unparsable */

      /* split auth part in 3 subparts: username, password and authmech */

      /*
       * For backward compatibility with previous versions of Mail
       * Notification, we also support ;auth= (in lowercase).
       */

      pat = g_strdup_printf("%%%i[^:]:%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len, len);
      n = sscanf(auth_buf, pat, username_buf, password_buf, authmech_buf);
      g_free(pat);

      if (n >= 2)
	{
	  has_password = TRUE;
	  if (n == 3)
	    has_authmech = TRUE;
	}
      else
	{
	  pat = g_strdup_printf("%%%i[^;];%%*1[aA]%%*1[uU]%%*1[tT]%%*1[hH]=%%%is", len, len);
	  n = sscanf(auth_buf, pat, username_buf, authmech_buf);
	  g_free(pat);

	  if (n >= 1)
	    {
	      if (n == 2)
		has_authmech = TRUE;
	    }
	  else
	    return NULL;	/* unparsable */
	}

      if (has_location)
	{
	  char hostport_buf[buflen];

	  /* split location part in 3 subparts: hostport, path and queries */

	  pat = g_strdup_printf("%%%i[^/]/%%%i[^?]?%%%is", len, len, len);
	  n = sscanf(location_buf, pat, hostport_buf, path_buf, queries_buf);
	  g_free(pat);

	  if (n >= 2)
	    {
	      has_path = TRUE;
	      if (n == 3)
		has_queries = TRUE;
	    }
	  else
	    {
	      pat = g_strdup_printf("%%%i[^?]?%%%is", len, len);
	      n = sscanf(location_buf, pat, hostport_buf, queries_buf);
	      g_free(pat);

	      if (n == 2)
		has_queries = TRUE;
	    }

	  /* split hostport in 2 subparts: host and port */

	  pat = g_strdup_printf("[%%%i[^]]]:%%u", len);
	  n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	  g_free(pat);

	  if (n < 1)
	    {
	      pat = g_strdup_printf("%%%i[^:]:%%u", len);
	      n = sscanf(hostport_buf, pat, hostname_buf, &_port);
	      g_free(pat);
	    }

	  if (n == 2)
	    has_port = TRUE;
	}

      scheme = gnome_vfs_unescape_string(scheme_buf, NULL);
      username = gnome_vfs_unescape_string(username_buf, NULL);
      password = has_password ? gnome_vfs_unescape_string(password_buf, NULL) : NULL;
      authmech = has_authmech ? gnome_vfs_unescape_string(authmech_buf, NULL) : NULL;
      hostname = has_location ? gnome_vfs_unescape_string(hostname_buf, NULL) : NULL;
      port = has_port ? _port : 0;
      path = has_path ? gnome_vfs_unescape_string(path_buf, NULL) : NULL;
      if (has_queries)
	{
	  int i;

	  queries = g_strsplit(queries_buf, "&", 0);
	  for (i = 0; queries[i]; i++)
	    {
	      char *unescaped;

	      unescaped = gnome_vfs_unescape_string(queries[i], NULL);

	      g_free(queries[i]);
	      queries[i] = unescaped;
	    }
	}
      else
	queries = NULL;
    }

    if (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops"))
      {
#if WITH_POP3
	MNPIMailboxConnectionType connection_type;

	if (queries && eel_g_strv_find(queries, "STLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "pops")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("pop3",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			NULL);
#endif
      }
    else if (! strcmp(scheme, "imap") || ! strcmp(scheme, "imaps"))
      {
#if WITH_IMAP
	MNPIMailboxConnectionType connection_type;

	if (queries && eel_g_strv_find(queries, "STARTTLS") != -1)
	  connection_type = MN_PI_MAILBOX_CONNECTION_TYPE_INBAND_SSL;
	else
	  connection_type = ! strcmp(scheme, "imaps")
	    ? MN_PI_MAILBOX_CONNECTION_TYPE_SSL
	    : MN_PI_MAILBOX_CONNECTION_TYPE_NORMAL;

	self = self_new("imap",
			"connection-type", connection_type,
			"username", username,
			"password", password,
			"authmech", authmech,
			"hostname", hostname,
			"port", port,
			"mailbox", path,
			NULL);

	if (queries && eel_g_strv_find(queries, "noidle") != -1)
	  g_object_set(G_OBJECT(self), MN_IMAP_MAILBOX_PROP_USE_IDLE_EXTENSION(MN_IMAP_MAILBOX_USE_IDLE_NEVER), NULL);
#endif
      }
    else if (! strcmp(scheme, "gmail"))
      {
#if WITH_GMAIL
	self = self_new("gmail",
			"username", username,
			"password", password,
			NULL);
#endif
      }

    g_free(scheme);
    g_free(username);
    g_free(password);
    g_free(authmech);
    g_free(hostname);
    g_free(path);
    g_strfreev(queries);

    return self;
  }}
#line 1761 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 870 "mn-mailbox.gob"
static gboolean 
mn_mailbox_check_timeout_cb (gpointer data)
#line 1767 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::check_timeout_cb"
{
#line 872 "mn-mailbox.gob"
	
    Self *self = data;

    self_check(self);

    return TRUE;		/* continue */
  }}
#line 1779 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 880 "mn-mailbox.gob"
static gboolean 
mn_mailbox_validate (MNMailbox * self, GError ** err)
#line 1785 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::validate"
#line 880 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 880 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1792 "mn-mailbox.c"
{
#line 882 "mn-mailbox.gob"
	
    GParamSpec **properties;
    unsigned int n_properties;
    int i;

    properties = g_object_class_list_properties(G_OBJECT_GET_CLASS(self), &n_properties);
    for (i = 0; i < n_properties; i++)
      if ((properties[i]->flags & MN_MAILBOX_PARAM_REQUIRED) != 0)
	{
	  GValue value = { 0, };
	  const char *str;
	  gboolean is_empty;

	  g_assert(G_IS_PARAM_SPEC_STRING(properties[i]));

	  g_value_init(&value, G_TYPE_STRING);
	  g_object_get_property(G_OBJECT(self), g_param_spec_get_name(properties[i]), &value);

	  str = g_value_get_string(&value);
	  is_empty = ! str || ! *str;

	  g_value_unset(&value);

	  if (is_empty)
	    {
	      g_set_error(err, 0, 0, _("property \"%s\" has no value"), g_param_spec_get_name(properties[i]));
	      return FALSE;
	    }
	}
    g_free(properties);

    return TRUE;
  }}
#line 1828 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 916 "mn-mailbox.gob"
void 
mn_mailbox_seal (MNMailbox * self)
#line 1834 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 916 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 916 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1841 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->seal)
		(*klass->seal)(self);
}
#line 916 "mn-mailbox.gob"
static void 
___real_mn_mailbox_seal (MNMailbox * self G_GNUC_UNUSED)
#line 1850 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::seal"
{
#line 918 "mn-mailbox.gob"
	
    if (self->name)
      {
	g_free(self->runtime_name);
	self->runtime_name = g_strdup(self->name);
      }

    self->runtime_check_delay = self->check_delay != -1
      ? self->check_delay
      : SELF_GET_CLASS(self)->default_check_delay;
  }}
#line 1866 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 930 "mn-mailbox.gob"
static MNMailbox * 
mn_mailbox_parse_uri (MNMailbox * self, const char * uri)
#line 1872 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 930 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (MNMailbox * )0);
#line 930 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (MNMailbox * )0);
#line 1879 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->parse_uri)
		return (*klass->parse_uri)(self,uri);
	else
		return (MNMailbox * )(0);
}

#line 933 "mn-mailbox.gob"
void 
mn_mailbox_check (MNMailbox * self)
#line 1891 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 933 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 933 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1898 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->check)
		(*klass->check)(self);
}
#line 933 "mn-mailbox.gob"
static void 
___real_mn_mailbox_check (MNMailbox * self G_GNUC_UNUSED)
#line 1907 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::check"
{
#line 935 "mn-mailbox.gob"
	
    g_assert(selfp->added == TRUE);
  }}
#line 1915 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 939 "mn-mailbox.gob"
void 
mn_mailbox_notice (MNMailbox * self, const char * format, ...)
#line 1921 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::notice"
#line 939 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 939 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 939 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 1930 "mn-mailbox.c"
{
#line 941 "mn-mailbox.gob"
	
    va_list args;
    char *message;

    va_start(args, format);
    message = g_strdup_vprintf(format, args);
    va_end(args);

    mn_info("%s: %s", self->runtime_name, message);
    g_free(message);
  }}
#line 1944 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 953 "mn-mailbox.gob"
void 
mn_mailbox_warning (MNMailbox * self, const char * format, ...)
#line 1950 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::warning"
#line 953 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 953 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 953 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 1959 "mn-mailbox.c"
{
#line 955 "mn-mailbox.gob"
	
    va_list args;
    char *message;

    va_start(args, format);
    message = g_strdup_vprintf(format, args);
    va_end(args);

    g_warning("%s: %s", self->runtime_name, message);
    g_free(message);
  }}
#line 1973 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 973 "mn-mailbox.gob"
void 
mn_mailbox_mark_as_read (gpointer _message)
#line 1979 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::mark_as_read"
{
#line 975 "mn-mailbox.gob"
	
    MNMessage *message;
    Self *self;

    message = MN_MESSAGE(_message);
    g_return_if_fail(message != NULL);

    self = message->mailbox;
    g_assert(self != NULL);

    g_hash_table_replace(selfp->messages_marked_as_read, message->id, g_object_ref(message));

    self_filter_messages(self);
  }}
#line 1998 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 990 "mn-mailbox.gob"
char * 
mn_mailbox_get_command (MNMailbox * self, const char * id)
#line 2004 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_command"
#line 990 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 990 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (char * )0);
#line 990 "mn-mailbox.gob"
	g_return_val_if_fail (id != NULL, (char * )0);
#line 2013 "mn-mailbox.c"
{
#line 992 "mn-mailbox.gob"
	
    char *prop;
    char *command;

    prop = g_strconcat(id, "-command", NULL);
    g_object_get(self, prop, &command, NULL);
    g_free(prop);

    if (command && ! *command)
      {
	g_free(command);
	return NULL;
      }

    return command;
  }}
#line 2032 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 1009 "mn-mailbox.gob"
gboolean 
mn_mailbox_has_command (MNMailbox * self, const char * id)
#line 2038 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::has_command"
#line 1009 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 1009 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1009 "mn-mailbox.gob"
	g_return_val_if_fail (id != NULL, (gboolean )0);
#line 2047 "mn-mailbox.c"
{
#line 1011 "mn-mailbox.gob"
	
    char *command;
    gboolean has;

    command = self_get_command(self, id);
    has = command != NULL;
    g_free(command);

    return has;
  }}
#line 2060 "mn-mailbox.c"
#undef __GOB_FUNCTION__
