/* Generated by GOB (v2.0.11) on Thu Nov  4 11:55:05 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include "mn-imap-mailbox.h"

#include "mn-imap-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 36 "mn-imap-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <glib/gi18n.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#ifdef WITH_MIME
#include "mn-message-mime.h"
#endif

#define HAS_CURRENT_TAG(response, priv)	(! strcmp((response)->tag, (priv)->tag))
#define IS(response, token)		(! strcmp((response)->response, (token)))
#define IS_OK(response)			IS(response, "OK")
#define IS_NO(response)			IS(response, "NO")
#define IS_BAD(response)		IS(response, "BAD")
#define IS_BYE(response)		IS(response, "BYE")

#define REMOVED(self)			(g_atomic_int_get(&(self)->_priv->removed))

  enum
  {
    STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
    STATE_CAPABILITY,
#ifdef WITH_SSL
    STATE_STARTTLS,
#endif
#ifdef WITH_SASL
    STATE_AUTHENTICATE,
#endif
    STATE_LOGIN,
    STATE_EXAMINE,
    STATE_SEARCH,
#ifdef WITH_MIME
    STATE_FETCH,
#else /* WITH_MIME */
    STATE_STATUS,
#endif
    STATE_IDLE,
    STATE_LOGOUT
  };
  
  enum
  {
    RESULT_ERROR_LOGOUT		= -1, /* server reported an error, logout normally */
    RESULT_ERROR_END		= -2, /* server reported an error, close the connection */
    RESULT_DEFAULT_HANDLER	= -3  /* invoke the default response handler */
  };

  typedef enum
  {
    IDLE_STATE_NORMAL,
    IDLE_STATE_IDLING,
    IDLE_STATE_WAS_IDLING
  } IdleState;

  struct _MNClientSessionPrivate
  {
    MNMailbox		*mailbox;
    MNIMAPMailbox	*self;
    MNClientSession	*session;

    int			numeric_tag;
    char		tag[5];

    char		**capabilities;
    GSList		*auth_mechanisms;
    gboolean		authentication_failed;

    gboolean		search_received;
    GSList		*fetch_numbers;
    char		*fetch_set;

#ifdef WITH_MIME
    GSList		*received_numbers;
    GSList		*messages;
#else /* WITH_MIME */
    gboolean		status_received;
#endif

#ifdef WITH_SSL
    gboolean		starttls_completed;
#endif
#ifdef WITH_SASL
    const char		*sasl_mechanism;
#endif

    IdleState		idle_state;
    gboolean		could_idle;	/* could idle at least once */
  };
  
  struct _MNClientSessionResponse
  {
    char		*continuation;
    char		*tag;
    char		*response;
    char		*code;
    char		*arguments;
  };

#line 130 "mn-imap-mailbox.c"
/* self casting macros */
#define SELF(x) MN_IMAP_MAILBOX(x)
#define SELF_CONST(x) MN_IMAP_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_IMAP_MAILBOX(x)
#define TYPE_SELF MN_TYPE_IMAP_MAILBOX
#define SELF_CLASS(x) MN_IMAP_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_IMAP_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNIMAPMailbox Self;
typedef MNIMAPMailboxClass SelfClass;

/* here are local prototypes */
static void mn_imap_mailbox_init (MNIMAPMailbox * o) G_GNUC_UNUSED;
static void mn_imap_mailbox_class_init (MNIMAPMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_imap_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_imap_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static void ___4_mn_imap_mailbox_removed (MNMailbox * mailbox) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_search_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_search_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_status_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_status_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNAuthenticatedMailboxResult ___1a_mn_imap_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox, GError ** err) G_GNUC_UNUSED;
static void mn_imap_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...) G_GNUC_UNUSED;
static void mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities) G_GNUC_UNUSED;
static gboolean mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_imap_mailbox_session_check_mail (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static char * mn_imap_mailbox_quote (const char * str) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_imap_mailbox_handle_greeting_cb
#define self_enter_capability_cb mn_imap_mailbox_enter_capability_cb
#define self_handle_capability_cb mn_imap_mailbox_handle_capability_cb
#define self_enter_starttls_cb mn_imap_mailbox_enter_starttls_cb
#define self_handle_starttls_cb mn_imap_mailbox_handle_starttls_cb
#define self_enter_authenticate_cb mn_imap_mailbox_enter_authenticate_cb
#define self_handle_authenticate_cb mn_imap_mailbox_handle_authenticate_cb
#define self_enter_login_cb mn_imap_mailbox_enter_login_cb
#define self_handle_login_cb mn_imap_mailbox_handle_login_cb
#define self_enter_examine_cb mn_imap_mailbox_enter_examine_cb
#define self_handle_examine_cb mn_imap_mailbox_handle_examine_cb
#define self_enter_search_cb mn_imap_mailbox_enter_search_cb
#define self_handle_search_cb mn_imap_mailbox_handle_search_cb
#define self_enter_fetch_cb mn_imap_mailbox_enter_fetch_cb
#define self_handle_fetch_cb mn_imap_mailbox_handle_fetch_cb
#define self_enter_idle_cb mn_imap_mailbox_enter_idle_cb
#define self_handle_idle_cb mn_imap_mailbox_handle_idle_cb
#define self_enter_status_cb mn_imap_mailbox_enter_status_cb
#define self_handle_status_cb mn_imap_mailbox_handle_status_cb
#define self_enter_logout_cb mn_imap_mailbox_enter_logout_cb
#define self_handle_logout_cb mn_imap_mailbox_handle_logout_cb
#define self_notice_cb mn_imap_mailbox_notice_cb
#define self_response_new_cb mn_imap_mailbox_response_new_cb
#define self_response_free_cb mn_imap_mailbox_response_free_cb
#define self_custom_handler_cb mn_imap_mailbox_custom_handler_cb
#define self_pre_read_cb mn_imap_mailbox_pre_read_cb
#define self_post_read_cb mn_imap_mailbox_post_read_cb
#define self_session_set_error_from_arguments mn_imap_mailbox_session_set_error_from_arguments
#define self_session_write mn_imap_mailbox_session_write
#define self_session_parse_capabilities mn_imap_mailbox_session_parse_capabilities
#define self_session_has_capability mn_imap_mailbox_session_has_capability
#define self_session_after_capability mn_imap_mailbox_session_after_capability
#define self_session_authenticate mn_imap_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_imap_mailbox_session_authenticate_fallback
#define self_session_check_mail mn_imap_mailbox_session_check_mail
#define self_quote mn_imap_mailbox_quote
GType
mn_imap_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNIMAPMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_imap_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNIMAPMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_imap_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNIMAPMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNIMAPMailbox *)g_object_new(mn_imap_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNIMAPMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNIMAPMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNIMAPMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNIMAPMailbox *)g_object_new_valist (mn_imap_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::finalize"
	MNIMAPMailbox *self G_GNUC_UNUSED = MN_IMAP_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 146 "mn-imap-mailbox.gob"
	if(self->_priv->idle_session_mutex) { g_mutex_free ((gpointer) self->_priv->idle_session_mutex); self->_priv->idle_session_mutex = NULL; }
#line 281 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_imap_mailbox_init (MNIMAPMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNIMAPMailboxPrivate);
#line 146 "mn-imap-mailbox.gob"
	o->_priv->idle_session_mutex = g_mutex_new();
#line 292 "mn-imap-mailbox.c"
}
#undef __GOB_FUNCTION__
#line 148 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_class_init (MNIMAPMailboxClass * class G_GNUC_UNUSED)
#line 298 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	g_type_class_add_private(class,sizeof(MNIMAPMailboxPrivate));

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 153 "mn-imap-mailbox.gob"
	g_object_class->constructor = ___2_mn_imap_mailbox_constructor;
#line 170 "mn-imap-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_imap_mailbox_impl_is;
#line 176 "mn-imap-mailbox.gob"
	mn_mailbox_class->removed = ___4_mn_imap_mailbox_removed;
#line 823 "mn-imap-mailbox.gob"
	mn_authenticated_mailbox_class->impl_authenticated_check = ___1a_mn_imap_mailbox_impl_authenticated_check;
#line 317 "mn-imap-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 149 "mn-imap-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "IMAP";
  
#line 324 "mn-imap-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 153 "mn-imap-mailbox.gob"
static GObject * 
___2_mn_imap_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 334 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::constructor"
{
#line 155 "mn-imap-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);

#ifndef WITH_SSL
    if (MN_URI_IS_SSL(mailbox->uri) || MN_URI_IS_INBAND_SSL(mailbox->uri))
      mn_mailbox_set_init_error(mailbox, _("SSL/TLS support has not been compiled in"));
#endif /* WITH_SSL */

    return object;
  }}
#line 357 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 170 "mn-imap-mailbox.gob"
static gboolean 
___3_mn_imap_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 364 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::impl_is"
#line 170 "mn-imap-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 170 "mn-imap-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 375 "mn-imap-mailbox.c"
{
#line 172 "mn-imap-mailbox.gob"
	
    return MN_URI_IS_IMAP(uri);
  }}
#line 381 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 176 "mn-imap-mailbox.gob"
static void 
___4_mn_imap_mailbox_removed (MNMailbox * mailbox G_GNUC_UNUSED)
#line 388 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->removed) \
		(* MN_MAILBOX_CLASS(parent_class)->removed)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::removed"
#line 176 "mn-imap-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 176 "mn-imap-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 398 "mn-imap-mailbox.c"
{
#line 178 "mn-imap-mailbox.gob"
	
    Self *self = SELF(mailbox);

    g_atomic_int_inc(&selfp->removed);

    g_mutex_lock(selfp->idle_session_mutex);
    if (selfp->idle_session)
      {
	mn_client_session_write(selfp->idle_session->session, "DONE");
	selfp->idle_session->idle_state = IDLE_STATE_WAS_IDLING;
      }
    g_mutex_unlock(selfp->idle_session_mutex);

    PARENT_HANDLER(mailbox);
  }}
#line 416 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 194 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 423 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_greeting_cb"
#line 194 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 194 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 194 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 432 "mn-imap-mailbox.c"
{
#line 198 "mn-imap-mailbox.gob"
	
    priv->session = session;

    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (! response->tag && IS_OK(response))
      {
	if (response->code)
	  {
	    if (! strcmp(response->code, "CAPABILITY"))
	      self_session_parse_capabilities(priv, NULL);
	    else if (g_str_has_prefix(response->code, "CAPABILITY "))
	      self_session_parse_capabilities(priv, response->code + 11);
	  }
	
	return priv->capabilities
	  ? self_session_after_capability(priv)
	  : STATE_CAPABILITY;
      }
    else if (! response->tag && IS(response, "PREAUTH"))
      return self_session_check_mail(priv);
    else if (! response->tag && IS_BYE(response))
      return RESULT_ERROR_END;
    else
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
  }}
#line 461 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 225 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_capability_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 467 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_capability_cb"
#line 225 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 225 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 474 "mn-imap-mailbox.c"
{
#line 228 "mn-imap-mailbox.gob"
	
    g_strfreev(priv->capabilities);
    priv->capabilities = NULL;

    eel_g_slist_free_deep(priv->auth_mechanisms);
    priv->auth_mechanisms = NULL;

    return self_session_write(priv, "CAPABILITY");
  }}
#line 486 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 238 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_capability_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 492 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_capability_cb"
#line 238 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 238 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 238 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 501 "mn-imap-mailbox.c"
{
#line 242 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		return priv->capabilities
		  ? self_session_after_capability(priv)
		  : mn_client_session_error(session, _("server did not send capabilities"));
	      }
	    else if (IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "CAPABILITY"))
      {
	self_session_parse_capabilities(priv, response->arguments);
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }
    
    return RESULT_DEFAULT_HANDLER;
  }}
#line 531 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 270 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_starttls_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 537 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_starttls_cb"
#line 270 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 270 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 544 "mn-imap-mailbox.c"
{
#line 273 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    return self_session_write(priv, "STARTTLS");
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 554 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 281 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_starttls_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 560 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_starttls_cb"
#line 281 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 281 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 281 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 569 "mn-imap-mailbox.c"
{
#line 285 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		priv->starttls_completed = TRUE;
		return mn_client_session_enable_ssl(session)
		  ? STATE_CAPABILITY
		  : RESULT_ERROR_END;
	      }
	    else if (IS_BAD(response))
	      return self_session_authenticate(priv);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return RESULT_DEFAULT_HANDLER;
#else
    g_return_val_if_reached(0);
#endif /* WITH_SSL */
  }}
#line 599 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 313 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_authenticate_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 605 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_authenticate_cb"
#line 313 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 313 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 612 "mn-imap-mailbox.c"
{
#line 316 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    /*
     * RFC 3501 6.2.2 specifies that the IMAP protocol does not
     * support the "initial response" feature of SASL, so we set the
     * initial_response argument to FALSE.
     */
    if (mn_client_session_sasl_authentication_start(priv->session,
						    "imap",
						    priv->auth_mechanisms,
						    priv->mailbox->uri->authmech,
						    &priv->sasl_mechanism,
						    FALSE))
      return self_session_write(priv, "AUTHENTICATE %s", priv->sasl_mechanism);
    else
      return self_session_authenticate_fallback(priv);
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 635 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 337 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_authenticate_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 641 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_authenticate_cb"
#line 337 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 337 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 337 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 650 "mn-imap-mailbox.c"
{
#line 341 "mn-imap-mailbox.gob"
	
#ifdef WITH_SASL
    if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		return mn_client_session_sasl_authentication_done(session)
		  ? self_session_check_mail(priv)
		  : MN_CLIENT_SESSION_RESULT_END;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return self_session_authenticate_fallback(priv);
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (response->continuation)
      return mn_client_session_sasl_authentication_step(session, response->continuation);
    
    return RESULT_DEFAULT_HANDLER;
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 679 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 368 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_login_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 685 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_login_cb"
#line 368 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 368 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 692 "mn-imap-mailbox.c"
{
#line 371 "mn-imap-mailbox.gob"
	
    if (self_session_has_capability(priv, "LOGINDISABLED"))
      {
	mn_client_session_notice(session, _("server advertised LOGINDISABLED, not using LOGIN authentication"));
	mn_client_session_error(session, _("unable to login"));
	return STATE_LOGOUT;
      }
    else
      {
	char *quoted_username;
	char *quoted_password;
	int result;

	quoted_username = self_quote(priv->mailbox->uri->username);
	quoted_password = self_quote(MN_AUTHENTICATED_MAILBOX(priv->self)->password);
	result = self_session_write(priv, "LOGIN %s %s", quoted_username, quoted_password);
	g_free(quoted_username);
	g_free(quoted_password);

	return result;
      }
  }}
#line 717 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 394 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_login_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 723 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_login_cb"
#line 394 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 394 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 394 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 732 "mn-imap-mailbox.c"
{
#line 398 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      return self_session_check_mail(priv);
	    else if (IS_NO(response) || IS_BAD(response))
	      {
		priv->authentication_failed = TRUE;
		return RESULT_ERROR_LOGOUT;
	      }
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    
    return RESULT_DEFAULT_HANDLER;
  }}
#line 756 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 420 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_examine_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 762 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_examine_cb"
#line 420 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 420 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 769 "mn-imap-mailbox.c"
{
#line 423 "mn-imap-mailbox.gob"
	
    char *quoted_mailbox;
    int result;

    quoted_mailbox = self_quote(priv->mailbox->uri->path);
    result = self_session_write(priv, "EXAMINE %s", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
  }}
#line 782 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 434 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_examine_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 788 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_examine_cb"
#line 434 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 434 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 434 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 797 "mn-imap-mailbox.c"
{
#line 438 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      return STATE_SEARCH;
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 818 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 457 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_search_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 824 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_search_cb"
#line 457 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 457 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 831 "mn-imap-mailbox.c"
{
#line 460 "mn-imap-mailbox.gob"
	
    priv->search_received = FALSE;

    g_slist_free(priv->fetch_numbers);
    priv->fetch_numbers = NULL;

    g_free(priv->fetch_set);
    priv->fetch_set = NULL;
    
    return self_session_write(priv, "SEARCH UNSEEN");
  }}
#line 845 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 472 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_search_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 851 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_search_cb"
#line 472 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 472 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 472 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 860 "mn-imap-mailbox.c"
{
#line 476 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->search_received)
		  {
		    if (priv->fetch_set)
		      {
#ifdef WITH_MIME
			return STATE_FETCH;
#else
			GDK_THREADS_ENTER();
			mn_mailbox_set_has_new(priv->mailbox, TRUE);
			gdk_flush();
			GDK_THREADS_LEAVE();

			return STATE_IDLE;
#endif /* WITH_MIME */
		      }
		    else
		      {
			GDK_THREADS_ENTER();
			mn_mailbox_set_has_new(priv->mailbox, FALSE);
#ifdef WITH_MIME
			mn_mailbox_set_messages(priv->mailbox, NULL);
#endif
			gdk_flush();
			GDK_THREADS_LEAVE();

			return self_session_has_capability(priv, "IDLE")
			  ? STATE_IDLE
			  : STATE_LOGOUT;
		      }
		  }
		else		/* compliance error */
		  return mn_client_session_error(session, _("server did not send search results"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "SEARCH"))
      {
	if (response->arguments)
	  {
	    char **numbers;
	    GString *string;
	    int i;

	    numbers = g_strsplit(response->arguments, " ", 0);
	    string = g_string_new(NULL);

	    for (i = 0; numbers[i]; i++)
	      if (mn_str_isnumeric(numbers[i]))
		{
		  int n = atoi(numbers[i]);

		  if (*string->str)
		    g_string_append_c(string, ',');
		  g_string_append(string, numbers[i]);

		  priv->fetch_numbers = g_slist_append(priv->fetch_numbers, GINT_TO_POINTER(n));
		}

	    g_strfreev(numbers);
	    priv->fetch_set = g_string_free(string, FALSE);
	  }

	priv->search_received = TRUE;
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 944 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 558 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_fetch_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 950 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_fetch_cb"
#line 558 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 558 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 957 "mn-imap-mailbox.c"
{
#line 561 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    g_return_val_if_fail(priv->fetch_set != NULL, 0);

    g_slist_free(priv->received_numbers);
    priv->received_numbers = NULL;

    mn_g_object_slist_free(priv->messages);
    priv->messages = NULL;

    return self_session_write(priv, "FETCH %s BODY[HEADER]", priv->fetch_set);
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 975 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 577 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_fetch_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 981 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_fetch_cb"
#line 577 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 577 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 577 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 990 "mn-imap-mailbox.c"
{
#line 581 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		GSList *l;

		MN_LIST_FOREACH(l, priv->fetch_numbers)
		  if (! g_slist_find(priv->received_numbers, l->data))
		    /* compliance error */
		    return mn_client_session_error(session, _("server did not send all the messages we requested"));
		    
		GDK_THREADS_ENTER();
		mn_mailbox_set_has_new(priv->mailbox, priv->messages != NULL);
		mn_mailbox_set_messages(priv->mailbox, priv->messages);
		gdk_flush();
		GDK_THREADS_LEAVE();
		
		return self_session_has_capability(priv, "IDLE")
		  ? STATE_IDLE
		  : STATE_LOGOUT;
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (mn_str_isnumeric(response->response)
	     && response->arguments
	     && g_str_has_prefix(response->arguments, "FETCH (BODY[HEADER]"))
      {
	int n = atoi(response->response);

	if (g_slist_find(priv->fetch_numbers, GINT_TO_POINTER(n)))
	  {
	    char *p;
	    int len;

	    priv->received_numbers = g_slist_append(priv->received_numbers, GINT_TO_POINTER(n));

	    /* we assume the header string will be in literal form */

	    p = strrchr(response->arguments, '{');
	    if (p && sscanf(p, "{%d}", &len) == 1 && len >= 0)
	      {
		gconstpointer buf;
		
		buf = mn_client_session_read(session, len);
		if (! buf)
		  return MN_CLIENT_SESSION_RESULT_END;
		
		priv->messages = g_slist_append(priv->messages, mn_message_new_from_buffer(priv->mailbox->uri, buf, len));
		
		/* read end of line (after literal) */
		if (! mn_client_session_read_line(session))
		  return MN_CLIENT_SESSION_RESULT_END;
	      }
	    else
	      priv->messages = g_slist_append(priv->messages, mn_message_new_from_error(priv->mailbox->uri, _("unable to fetch message")));

	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
      }
	
    return RESULT_DEFAULT_HANDLER;
#else /* WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1068 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 657 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_idle_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1074 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_idle_cb"
#line 657 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 657 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1081 "mn-imap-mailbox.c"
{
#line 660 "mn-imap-mailbox.gob"
	
    priv->idle_state = IDLE_STATE_NORMAL;
    return REMOVED(priv->self) ? STATE_LOGOUT : self_session_write(priv, "IDLE");
  }}
#line 1088 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 665 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_idle_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1094 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_idle_cb"
#line 665 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 665 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 665 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1103 "mn-imap-mailbox.c"
{
#line 669 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	if (response->continuation || response->tag)
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;

	priv->idle_state = IDLE_STATE_WAS_IDLING;

	if (IS_BYE(response))
	  return MN_CLIENT_SESSION_RESULT_END; /* we'll reconnect */
	else
	  /* any other response wakes us up */
	  return mn_client_session_write(session, "DONE");
      }
    else
      {
	if (response->continuation)
	  {
	    if (priv->idle_state == IDLE_STATE_WAS_IDLING)
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	    else
	      {
		/* we're now in the idle loop */
		priv->idle_state = IDLE_STATE_IDLING;
		priv->could_idle = TRUE;
		
		GDK_THREADS_ENTER();
		mn_mailbox_set_must_poll(priv->mailbox, FALSE);
		gdk_flush();
		GDK_THREADS_LEAVE();

		return MN_CLIENT_SESSION_RESULT_CONTINUE;
	      }
	  }
	else if (response->tag)
	  {
	    if (HAS_CURRENT_TAG(response, priv))
	      {
		if (IS_OK(response))
		  return REMOVED(priv->self) ? STATE_LOGOUT : STATE_SEARCH;
		else if (IS_NO(response) || IS_BAD(response))
		  /*
		   * The server advertised IDLE but does not actually
		   * support it.
		   *
		   * Although strictly speaking this can be considered
		   * a compliance fault, we'll be tolerant and just
		   * logout without setting an error.
		   */
		  return STATE_LOGOUT;
		else
		  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	      }
	  }
      }

    return RESULT_DEFAULT_HANDLER;
  }}
#line 1164 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 728 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_status_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1170 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_status_cb"
#line 728 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 728 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1177 "mn-imap-mailbox.c"
{
#line 731 "mn-imap-mailbox.gob"
	
#ifndef WITH_MIME
    char *quoted_mailbox;
    int result;

    quoted_mailbox = self_quote(priv->mailbox->uri->path);
    result = self_session_write(priv, "STATUS %s (UNSEEN)", quoted_mailbox);
    g_free(quoted_mailbox);

    return result;
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1194 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 746 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_status_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1200 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_status_cb"
#line 746 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 746 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 746 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1209 "mn-imap-mailbox.c"
{
#line 750 "mn-imap-mailbox.gob"
	
#ifndef WITH_MIME
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag)
      {
	if (HAS_CURRENT_TAG(response, priv))
	  {
	    if (IS_OK(response))
	      {
		if (priv->status_received)
		  return STATE_LOGOUT;
		else		/* compliance error */
		  return mn_client_session_error(session, _("server did not send status"));
	      }
	    else if (IS_NO(response) || IS_BAD(response))
	      return RESULT_ERROR_LOGOUT;
	    else
	      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	  }
      }
    else if (IS(response, "STATUS"))
      {
	int count;
	
	if (response->arguments && sscanf(response->arguments, "%*s (UNSEEN %i)", &count) == 1)
	  {
	    priv->status_received = TRUE;
	    
	    GDK_THREADS_ENTER();
	    mn_mailbox_set_has_new(priv->mailbox, count != 0);
	    gdk_flush();
	    GDK_THREADS_LEAVE();
	    
	    return MN_CLIENT_SESSION_RESULT_CONTINUE;
	  }
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    
    return RESULT_DEFAULT_HANDLER;
#else /* ! WITH_MIME */
    g_return_val_if_reached(0);
#endif
  }}
#line 1257 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 796 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_enter_logout_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1263 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::enter_logout_cb"
#line 796 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 796 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1270 "mn-imap-mailbox.c"
{
#line 799 "mn-imap-mailbox.gob"
	
    return self_session_write(priv, "LOGOUT");
  }}
#line 1276 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 803 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_handle_logout_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1282 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::handle_logout_cb"
#line 803 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 803 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 803 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1291 "mn-imap-mailbox.c"
{
#line 807 "mn-imap-mailbox.gob"
	
    if (response->continuation)
      return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
    else if (response->tag && HAS_CURRENT_TAG(response, priv))
      {
	if (IS_OK(response))
	  return MN_CLIENT_SESSION_RESULT_END;
	else if (IS_BAD(response))
	  return RESULT_ERROR_END;
	else
	  return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
    else
      return MN_CLIENT_SESSION_RESULT_CONTINUE;
  }}
#line 1309 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 823 "mn-imap-mailbox.gob"
static MNAuthenticatedMailboxResult 
___1a_mn_imap_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox G_GNUC_UNUSED, GError ** err)
#line 1315 "mn-imap-mailbox.c"
#define PARENT_HANDLER(___authenticated_mailbox,___err) \
	((MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)? \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)(___authenticated_mailbox,___err): \
		((MNAuthenticatedMailboxResult )0))
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::impl_authenticated_check"
#line 823 "mn-imap-mailbox.gob"
	g_return_val_if_fail (authenticated_mailbox != NULL, (MNAuthenticatedMailboxResult )0);
#line 823 "mn-imap-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (authenticated_mailbox), (MNAuthenticatedMailboxResult )0);
#line 1326 "mn-imap-mailbox.c"
{
#line 826 "mn-imap-mailbox.gob"
	
    MNMailbox *mailbox = MN_MAILBOX(authenticated_mailbox);
    Self *self = SELF(authenticated_mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,				self_handle_greeting_cb },
      { STATE_CAPABILITY,	self_enter_capability_cb,	self_handle_capability_cb },
#ifdef WITH_SSL
      { STATE_STARTTLS,		self_enter_starttls_cb,		self_handle_starttls_cb },
#endif
#ifdef WITH_SASL
      { STATE_AUTHENTICATE,	self_enter_authenticate_cb,	self_handle_authenticate_cb },
#endif
      { STATE_LOGIN,		self_enter_login_cb,		self_handle_login_cb },
      { STATE_EXAMINE,		self_enter_examine_cb,		self_handle_examine_cb },
      { STATE_SEARCH,		self_enter_search_cb,		self_handle_search_cb },
#ifdef WITH_MIME
      { STATE_FETCH,		self_enter_fetch_cb,		self_handle_fetch_cb },
#else
      { STATE_STATUS,		self_enter_status_cb,		self_handle_status_cb },
#endif
      { STATE_IDLE,		self_enter_idle_cb,		self_handle_idle_cb },
      { STATE_LOGOUT,		self_enter_logout_cb,		self_handle_logout_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_custom_handler_cb,
      self_pre_read_cb,
      self_post_read_cb
    };
    MNClientSessionPrivate priv;
    gboolean status;

    do
      {
	memset(&priv, 0, sizeof(priv));
	priv.mailbox = mailbox;
	priv.self = self;
    
	status = mn_client_session_run(states,
				       &callbacks,
#ifdef WITH_SSL
				       MN_URI_IS_SSL(mailbox->uri),
#endif
				       mailbox->uri->hostname,
				       mailbox->uri->port,
				       mailbox->uri->username,
				       MN_AUTHENTICATED_MAILBOX(self)->password,
				       &priv,
				       err);
    
	g_strfreev(priv.capabilities);
	eel_g_slist_free_deep(priv.auth_mechanisms);

	g_slist_free(priv.fetch_numbers);
	g_free(priv.fetch_set);

#ifdef WITH_MIME
	g_slist_free(priv.received_numbers);
	mn_g_object_slist_free(priv.messages);
#endif
      }
    while (status && priv.could_idle && ! REMOVED(self));

    GDK_THREADS_ENTER();
    mn_mailbox_set_must_poll(mailbox, TRUE);
    gdk_flush();
    GDK_THREADS_LEAVE();

    return status
      ? MN_AUTHENTICATED_MAILBOX_OK
      : (priv.authentication_failed
	 ? MN_AUTHENTICATED_MAILBOX_ERROR_AUTHENTICATION
	 : MN_AUTHENTICATED_MAILBOX_ERROR_OTHER);
  }}
#line 1407 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 905 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 1414 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::notice_cb"
#line 905 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 905 "mn-imap-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 905 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1423 "mn-imap-mailbox.c"
{
#line 909 "mn-imap-mailbox.gob"
	
    mn_mailbox_notice(priv->mailbox, "%s", str);
  }}
#line 1429 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 913 "mn-imap-mailbox.gob"
static MNClientSessionResponse * 
mn_imap_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 1435 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_new_cb"
#line 913 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (MNClientSessionResponse * )0);
#line 913 "mn-imap-mailbox.gob"
	g_return_val_if_fail (input != NULL, (MNClientSessionResponse * )0);
#line 913 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (MNClientSessionResponse * )0);
#line 1444 "mn-imap-mailbox.c"
{
#line 917 "mn-imap-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    if (g_str_has_prefix(input, "+ "))
      {
	response = g_new0(MNClientSessionResponse, 1);
	response->continuation = g_strdup(input + 2);
      }
    else
      {
	char **tokens;
	
	tokens = g_strsplit(input, " ", 3);
	if (tokens[0] && tokens[1])
	  {
	    if (tokens[2] && tokens[2][0] == '[')
	      {
		char *code_start;
		char *code_end;
		
		code_start = tokens[2] + 1;
		code_end = strchr(code_start, ']');
		if (code_end)
		  {
		    response = g_new0(MNClientSessionResponse, 1);
		    response->code = g_strndup(code_start, code_end - code_start);
		    response->arguments = code_end[1] ? g_strdup(code_end + 2) : NULL;
		  }
	      }
	    else
	      {
		response = g_new0(MNClientSessionResponse, 1);
		response->arguments = g_strdup(tokens[2]);
	      }
	    
	    if (response)
	      {
		response->tag = ! strcmp(tokens[0], "*") ? NULL : g_strdup(tokens[0]);
		response->response = g_strdup(tokens[1]);
	      }
	  }
	g_strfreev(tokens);
      }
    
    return response;
  }}
#line 1493 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 964 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1499 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::response_free_cb"
#line 964 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 964 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 964 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1508 "mn-imap-mailbox.c"
{
#line 968 "mn-imap-mailbox.gob"
	
    g_free(response->continuation);
    g_free(response->tag);
    g_free(response->response);
    g_free(response->code);
    g_free(response->arguments);
    g_free(response);
  }}
#line 1519 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 977 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv)
#line 1525 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::custom_handler_cb"
#line 977 "mn-imap-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 977 "mn-imap-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 977 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1534 "mn-imap-mailbox.c"
{
#line 982 "mn-imap-mailbox.gob"
	
    switch (result)
      {
      case RESULT_ERROR_LOGOUT:
	self_session_set_error_from_arguments(priv, response);
	return STATE_LOGOUT;

      case RESULT_ERROR_END:
	self_session_set_error_from_arguments(priv, response);
	return MN_CLIENT_SESSION_RESULT_END;

      case RESULT_DEFAULT_HANDLER:
	if (! response->tag && IS_BYE(response))
	  return RESULT_ERROR_END;
	else
	  return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	g_return_val_if_reached(0);
      }
  }}
#line 1558 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1004 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_pre_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1564 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::pre_read_cb"
#line 1004 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1004 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1571 "mn-imap-mailbox.c"
{
#line 1007 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	g_mutex_lock(priv->self->_priv->idle_session_mutex);
	priv->self->_priv->idle_session = priv;
	g_mutex_unlock(priv->self->_priv->idle_session_mutex);
      }
  }}
#line 1582 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1016 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_post_read_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 1588 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::post_read_cb"
#line 1016 "mn-imap-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 1016 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1595 "mn-imap-mailbox.c"
{
#line 1019 "mn-imap-mailbox.gob"
	
    if (priv->idle_state == IDLE_STATE_IDLING)
      {
	g_mutex_lock(priv->self->_priv->idle_session_mutex);
	priv->self->_priv->idle_session = NULL;
	g_mutex_unlock(priv->self->_priv->idle_session_mutex);
      }
  }}
#line 1606 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1028 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1612 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_set_error_from_arguments"
#line 1028 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1028 "mn-imap-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1619 "mn-imap-mailbox.c"
{
#line 1031 "mn-imap-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, _("unknown server error"));
  }}
#line 1628 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1038 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_write (MNClientSessionPrivate * priv, const char * format, ...)
#line 1634 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_write"
#line 1038 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1038 "mn-imap-mailbox.gob"
	g_return_val_if_fail (format != NULL, (int )0);
#line 1641 "mn-imap-mailbox.c"
{
#line 1042 "mn-imap-mailbox.gob"
	
    va_list args;
    char *command;
    int result;

    va_start(args, format);
    command = g_strdup_vprintf(format, args);
    va_end(args);
    
    if (priv->numeric_tag == 1000)
      priv->numeric_tag = 0;
    sprintf(priv->tag, "a%03i", priv->numeric_tag++);

    result = mn_client_session_write(priv->session, "%s %s", priv->tag, command);
    g_free(command);

    return result;
  }}
#line 1662 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1061 "mn-imap-mailbox.gob"
static void 
mn_imap_mailbox_session_parse_capabilities (MNClientSessionPrivate * priv, const char * capabilities)
#line 1668 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_parse_capabilities"
#line 1061 "mn-imap-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1673 "mn-imap-mailbox.c"
{
#line 1064 "mn-imap-mailbox.gob"
	
    if (capabilities)
      {
	int i;
	
	priv->capabilities = g_strsplit(capabilities, " ", 0);
	
	for (i = 0; priv->capabilities[i]; i++)
	  if (g_str_has_prefix(priv->capabilities[i], "AUTH="))
	    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(priv->capabilities[i] + 5));
      }
    else
      priv->capabilities = g_new0(char *, 1);
  }}
#line 1690 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1079 "mn-imap-mailbox.gob"
static gboolean 
mn_imap_mailbox_session_has_capability (MNClientSessionPrivate * priv, const char * capability)
#line 1696 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_has_capability"
#line 1079 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (gboolean )0);
#line 1079 "mn-imap-mailbox.gob"
	g_return_val_if_fail (capability != NULL, (gboolean )0);
#line 1703 "mn-imap-mailbox.c"
{
#line 1082 "mn-imap-mailbox.gob"
	
    int i;

    g_return_val_if_fail(priv->capabilities != NULL, FALSE);

    for (i = 0; priv->capabilities[i]; i++)
      if (! strcmp(priv->capabilities[i], capability))
	return TRUE;
    
    return FALSE;
  }}
#line 1717 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1094 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_after_capability (MNClientSessionPrivate * priv)
#line 1723 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_after_capability"
#line 1094 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1728 "mn-imap-mailbox.c"
{
#line 1096 "mn-imap-mailbox.gob"
	
#ifdef WITH_SSL
    if (MN_URI_IS_INBAND_SSL(priv->mailbox->uri)
	&& ! MN_URI_IS_SSL(priv->mailbox->uri)
	&& ! priv->starttls_completed)
      {
	if (self_session_has_capability(priv, "STARTTLS"))
	  return STATE_STARTTLS;
	else
	  {
	    mn_client_session_error(priv->session, _("server does not support in-band SSL/TLS"));
	    return STATE_LOGOUT;
	  }
      }
    else
#endif /* WITH_SSL */
      return self_session_authenticate(priv);
  }}
#line 1749 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1115 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1755 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate"
#line 1115 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1760 "mn-imap-mailbox.c"
{
#line 1117 "mn-imap-mailbox.gob"
	
    if (priv->mailbox->uri->authmech)
      {
	if (*priv->mailbox->uri->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTHENTICATE;
#else
	    return mn_client_session_error(priv->session, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->mailbox->uri->authmech, "+LOGIN"))
	      return STATE_LOGIN;
	    else
	      return mn_client_session_error(priv->session, _("unknown authentication mechanism \"%s\""), priv->mailbox->uri->authmech);
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->auth_mechanisms)
	  return STATE_AUTHENTICATE;
#endif /* WITH_SASL */
	return STATE_LOGIN;
      }
  }}
#line 1791 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1146 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv)
#line 1797 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_authenticate_fallback"
#line 1146 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1802 "mn-imap-mailbox.c"
{
#line 1148 "mn-imap-mailbox.gob"
	
    if (! priv->mailbox->uri->authmech)
      {
	mn_client_session_notice(priv->session, _("falling back to IMAP LOGIN authentication"));
	return STATE_LOGIN;
      }

    priv->authentication_failed = TRUE;
    return mn_client_session_error(priv->session, _("authentication failed"));
  }}
#line 1815 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

#line 1159 "mn-imap-mailbox.gob"
static int 
mn_imap_mailbox_session_check_mail (MNClientSessionPrivate * priv)
#line 1821 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::session_check_mail"
#line 1159 "mn-imap-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1826 "mn-imap-mailbox.c"
{
#line 1161 "mn-imap-mailbox.gob"
	
#ifdef WITH_MIME
    return STATE_EXAMINE;
#else
    return self_session_has_capability(priv, "IDLE")
      ? STATE_EXAMINE
      : STATE_STATUS;
#endif /* WITH_MIME */
  }}
#line 1838 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_imap_mailbox_quote:
 * @str: the string to quote
 *
 * Quotes a string using RFC 3501 BNF rules.
 *
 * Return value: the quoted string.
 **/
#line 1179 "mn-imap-mailbox.gob"
static char * 
mn_imap_mailbox_quote (const char * str)
#line 1852 "mn-imap-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:IMAP:Mailbox::quote"
#line 1179 "mn-imap-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 1857 "mn-imap-mailbox.c"
{
#line 1181 "mn-imap-mailbox.gob"
	
    GString *quoted;
    int i;

    quoted = g_string_new("\"");
    for (i = 0; str[i]; i++)
      if (str[i] == '"' || str[i] == '\\') /* quoted-specials in BNF */
	g_string_append_printf(quoted, "\\%c", str[i]);
      else
	g_string_append_c(quoted, str[i]);
    g_string_append_c(quoted, '"');

    return g_string_free(quoted, FALSE);
  }}
#line 1874 "mn-imap-mailbox.c"
#undef __GOB_FUNCTION__
