/* Generated by GOB (v2.0.11) on Sun Oct 31 18:41:22 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-message-box.h"

#include "mn-message-box-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-message-box.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-util.h"

#line 33 "mn-message-box.c"
/* self casting macros */
#define SELF(x) MN_MESSAGE_BOX(x)
#define SELF_CONST(x) MN_MESSAGE_BOX_CONST(x)
#define IS_SELF(x) MN_IS_MESSAGE_BOX(x)
#define TYPE_SELF MN_TYPE_MESSAGE_BOX
#define SELF_CLASS(x) MN_MESSAGE_BOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MESSAGE_BOX_GET_CLASS(x)

/* self typedefs */
typedef MNMessageBox Self;
typedef MNMessageBoxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_message_box_init (MNMessageBox * o) G_GNUC_UNUSED;
static void mn_message_box_class_init (MNMessageBoxClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_message_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___2_mn_message_box_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean mn_message_box_update_cb (gpointer data) G_GNUC_UNUSED;
static void mn_message_box_append_row (MNMessageBox * self, const char * name, const char * value, GtkWidget ** value_label) G_GNUC_UNUSED;
static char * mn_message_box_get_ago (MNMessageBox * self) G_GNUC_UNUSED;
static char * mn_message_box_format_delay (time_t delay) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_SIZE_GROUP,
	PROP_MESSAGE,
	PROP_SELECTABLE
};

/* pointer to the class of our parent */
static GtkVBoxClass *parent_class = NULL;

/* Short form macros */
#define self_update_cb mn_message_box_update_cb
#define self_append_row mn_message_box_append_row
#define self_get_ago mn_message_box_get_ago
#define self_format_delay mn_message_box_format_delay
#define self_new mn_message_box_new
GType
mn_message_box_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMessageBoxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_message_box_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMessageBox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_message_box_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_VBOX, "MNMessageBox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMessageBox *)g_object_new(mn_message_box_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMessageBox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMessageBox *
GET_NEW_VARG (const char *first, ...)
{
	MNMessageBox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMessageBox *)g_object_new_valist (mn_message_box_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message:Box::dispose"
	MNMessageBox *self G_GNUC_UNUSED = MN_MESSAGE_BOX (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 36 "mn-message-box.gob"
	if(self->_priv->size_group) { g_object_unref ((gpointer) self->_priv->size_group); self->_priv->size_group = NULL; }
#line 127 "mn-message-box.c"
#line 41 "mn-message-box.gob"
	if(self->_priv->message) { g_object_unref ((gpointer) self->_priv->message); self->_priv->message = NULL; }
#line 130 "mn-message-box.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message:Box::finalize"
	MNMessageBox *self G_GNUC_UNUSED = MN_MESSAGE_BOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 81 "mn-message-box.gob"
	___2_mn_message_box_finalize(obj_self);
#line 143 "mn-message-box.c"
}
#undef __GOB_FUNCTION__

static void 
mn_message_box_init (MNMessageBox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message:Box::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNMessageBoxPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_message_box_class_init (MNMessageBoxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message:Box::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMessageBoxPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_VBOX);

#line 49 "mn-message-box.gob"
	g_object_class->constructor = ___1_mn_message_box_constructor;
#line 81 "mn-message-box.gob"
	g_object_class->finalize = ___finalize;
#line 168 "mn-message-box.c"
	g_object_class->dispose = ___dispose;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("size_group" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 GTK_TYPE_SIZE_GROUP /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SIZE_GROUP,
		param_spec);
	param_spec = g_param_spec_object
		("message" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_MESSAGE /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGE,
		param_spec);
	param_spec = g_param_spec_boolean
		("selectable" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SELECTABLE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message:Box::set_property"
{
	MNMessageBox *self G_GNUC_UNUSED;

	self = MN_MESSAGE_BOX (object);

	switch (property_id) {
	case PROP_SIZE_GROUP:
		{
#line 37 "mn-message-box.gob"
{ GObject *___old = (GObject *)self->_priv->size_group; self->_priv->size_group = (GtkSizeGroup *)g_value_dup_object (VAL); if (___old != NULL) { g_object_unref (G_OBJECT (___old)); } }
#line 222 "mn-message-box.c"
		}
		break;
	case PROP_MESSAGE:
		{
#line 42 "mn-message-box.gob"
{ GObject *___old = (GObject *)self->_priv->message; self->_priv->message = (MNMessage *)g_value_dup_object (VAL); if (___old != NULL) { g_object_unref (G_OBJECT (___old)); } }
#line 229 "mn-message-box.c"
		}
		break;
	case PROP_SELECTABLE:
		{
#line 47 "mn-message-box.gob"
self->_priv->selectable = g_value_get_boolean (VAL);
#line 236 "mn-message-box.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message:Box::get_property"
{
	MNMessageBox *self G_GNUC_UNUSED;

	self = MN_MESSAGE_BOX (object);

	switch (property_id) {
	case PROP_SIZE_GROUP:
		{
#line 37 "mn-message-box.gob"
g_value_set_object (VAL, (gpointer)self->_priv->size_group);
#line 267 "mn-message-box.c"
		}
		break;
	case PROP_MESSAGE:
		{
#line 42 "mn-message-box.gob"
g_value_set_object (VAL, (gpointer)self->_priv->message);
#line 274 "mn-message-box.c"
		}
		break;
	case PROP_SELECTABLE:
		{
#line 47 "mn-message-box.gob"
g_value_set_boolean (VAL, self->_priv->selectable);
#line 281 "mn-message-box.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 49 "mn-message-box.gob"
static GObject * 
___1_mn_message_box_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 301 "mn-message-box.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Message:Box::constructor"
{
#line 51 "mn-message-box.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    self_append_row(self, _("Mailbox"), selfp->message->mailbox_uri->human_readable, NULL);

    if (selfp->message->error)
      self_append_row(self, _("Unreadable message"), selfp->message->error, NULL);
    else
      {
	char *ago;

	self_append_row(self, _("From"), selfp->message->from, NULL);
	self_append_row(self, _("Subject"), selfp->message->subject, NULL);

	ago = self_get_ago(self);
	if (ago)
	  {
	    self_append_row(self, _("Sent"), ago, &selfp->sent_label);
	    g_free(ago);
	    selfp->update_timeout_id = g_timeout_add(500, self_update_cb, self);
	  }
      }

    return object;
  }}
#line 339 "mn-message-box.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 81 "mn-message-box.gob"
static void 
___2_mn_message_box_finalize (GObject * object G_GNUC_UNUSED)
#line 346 "mn-message-box.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Message:Box::finalize"
#line 81 "mn-message-box.gob"
	g_return_if_fail (object != NULL);
#line 81 "mn-message-box.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 356 "mn-message-box.c"
{
#line 83 "mn-message-box.gob"
	
    Self *self = SELF(object);

    if (selfp->update_timeout_id)
      g_source_remove(selfp->update_timeout_id);

    PARENT_HANDLER(object);
  }}
#line 367 "mn-message-box.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 92 "mn-message-box.gob"
static gboolean 
mn_message_box_update_cb (gpointer data)
#line 374 "mn-message-box.c"
{
#define __GOB_FUNCTION__ "MN:Message:Box::update_cb"
#line 92 "mn-message-box.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 379 "mn-message-box.c"
{
#line 94 "mn-message-box.gob"
	
    Self *self = data;
    char *ago;

    ago = self_get_ago(self);

    GDK_THREADS_ENTER();
    gtk_label_set_text(GTK_LABEL(selfp->sent_label), ago);
    GDK_THREADS_LEAVE();

    g_free(ago);

    return TRUE;		/* continue */
  }}
#line 396 "mn-message-box.c"
#undef __GOB_FUNCTION__

#line 109 "mn-message-box.gob"
static void 
mn_message_box_append_row (MNMessageBox * self, const char * name, const char * value, GtkWidget ** value_label)
#line 402 "mn-message-box.c"
{
#define __GOB_FUNCTION__ "MN:Message:Box::append_row"
#line 109 "mn-message-box.gob"
	g_return_if_fail (self != NULL);
#line 109 "mn-message-box.gob"
	g_return_if_fail (MN_IS_MESSAGE_BOX (self));
#line 109 "mn-message-box.gob"
	g_return_if_fail (name != NULL);
#line 411 "mn-message-box.c"
{
#line 114 "mn-message-box.gob"
	
    GtkWidget *hbox;
    GtkWidget *label;
    char *markup;

    hbox = gtk_hbox_new(FALSE, 0);
    
    /* name */

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s:</span>", name);
    label = gtk_label_new(markup);
    g_free(markup);

    gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
    gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
    gtk_label_set_selectable(GTK_LABEL(label), selfp->selectable);

    gtk_size_group_add_widget(selfp->size_group, label);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    /* separator */

    label = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    /* value */

    label = gtk_label_new(value);

    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_label_set_selectable(GTK_LABEL(label), selfp->selectable);

    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);

    if (value_label)
      *value_label = label;

    gtk_box_pack_start(GTK_BOX(self), hbox, FALSE, FALSE, 0);
    gtk_widget_show_all(hbox);
  }}
#line 454 "mn-message-box.c"
#undef __GOB_FUNCTION__

#line 155 "mn-message-box.gob"
static char * 
mn_message_box_get_ago (MNMessageBox * self)
#line 460 "mn-message-box.c"
{
#define __GOB_FUNCTION__ "MN:Message:Box::get_ago"
#line 155 "mn-message-box.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 155 "mn-message-box.gob"
	g_return_val_if_fail (MN_IS_MESSAGE_BOX (self), (char * )0);
#line 467 "mn-message-box.c"
{
#line 157 "mn-message-box.gob"
	
    char *ago = NULL;

    if (selfp->message->sent_time)
      {
	time_t now;
	
	now = mn_time();
	if (now > 0)
	  {
	    time_t diff;
	    
	    diff = now - selfp->message->sent_time;
	    if (diff >= 0)
	      ago = self_format_delay(diff);
	  }
      }

    return ago;
  }}
#line 490 "mn-message-box.c"
#undef __GOB_FUNCTION__

#line 178 "mn-message-box.gob"
static char * 
mn_message_box_format_delay (time_t delay)
#line 496 "mn-message-box.c"
{
#define __GOB_FUNCTION__ "MN:Message:Box::format_delay"
{
#line 180 "mn-message-box.gob"
	
    char *str;

    if (delay < 60)
      str = g_strdup_printf(ngettext("%i second ago", "%i seconds ago", delay), delay);
    else if (delay < 60 * 60)
      {
	int minutes = delay / 60;
	str = g_strdup_printf(ngettext("%i minute ago", "%i minutes ago", minutes), minutes);
      }
    else if (delay < 60 * 60 * 24)
      {
	int hours = delay / (60 * 60);
	str = g_strdup_printf(ngettext("%i hour ago", "%i hours ago", hours), hours);
      }
    else if (delay < 60 * 60 * 24 * 7)
      {
	int days = delay / (60 * 60 * 24);
	str = g_strdup_printf(ngettext("%i day ago", "%i days ago", days), days);
      }
    else
      {
	int weeks = delay / (60 * 60 * 24 * 7);
	str = g_strdup_printf(ngettext("%i week ago", "%i weeks ago", weeks), weeks);
      }

    return str;
  }}
#line 529 "mn-message-box.c"
#undef __GOB_FUNCTION__

#line 209 "mn-message-box.gob"
GtkWidget * 
mn_message_box_new (GtkSizeGroup * size_group, MNMessage * message, gboolean selectable)
#line 535 "mn-message-box.c"
{
#define __GOB_FUNCTION__ "MN:Message:Box::new"
#line 209 "mn-message-box.gob"
	g_return_val_if_fail (size_group != NULL, (GtkWidget * )0);
#line 209 "mn-message-box.gob"
	g_return_val_if_fail (GTK_IS_SIZE_GROUP (size_group), (GtkWidget * )0);
#line 209 "mn-message-box.gob"
	g_return_val_if_fail (message != NULL, (GtkWidget * )0);
#line 209 "mn-message-box.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (message), (GtkWidget * )0);
#line 546 "mn-message-box.c"
{
#line 213 "mn-message-box.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(MN_MESSAGE_BOX_PROP_SIZE_GROUP(G_OBJECT(size_group)),
				   MN_MESSAGE_BOX_PROP_MESSAGE(G_OBJECT(message)),
				   MN_MESSAGE_BOX_PROP_SELECTABLE(selectable),
				   NULL));
  }}
#line 555 "mn-message-box.c"
#undef __GOB_FUNCTION__
