/* Generated by GOB (v2.0.10) on Mon Oct 25 15:24:34 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-message-label.h"

#include "mn-message-label-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-message-label.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-util.h"

#line 33 "mn-message-label.c"
/* self casting macros */
#define SELF(x) MN_MESSAGE_LABEL(x)
#define SELF_CONST(x) MN_MESSAGE_LABEL_CONST(x)
#define IS_SELF(x) MN_IS_MESSAGE_LABEL(x)
#define TYPE_SELF MN_TYPE_MESSAGE_LABEL
#define SELF_CLASS(x) MN_MESSAGE_LABEL_CLASS(x)

#define SELF_GET_CLASS(x) MN_MESSAGE_LABEL_GET_CLASS(x)

/* self typedefs */
typedef MNMessageLabel Self;
typedef MNMessageLabelClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_message_label_init (MNMessageLabel * o) G_GNUC_UNUSED;
static void mn_message_label_class_init (MNMessageLabelClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_message_label_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___2_mn_message_label_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_message_label_update (MNMessageLabel * self) G_GNUC_UNUSED;
static gboolean mn_message_label_update_cb (gpointer data) G_GNUC_UNUSED;
static void mn_message_label_append_row (GString * string, const char * label, const char * value, gboolean newline) G_GNUC_UNUSED;
static char * mn_message_label_format_delay (time_t delay) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_MESSAGE
};

/* pointer to the class of our parent */
static GtkLabelClass *parent_class = NULL;

/* Short form macros */
#define self_update mn_message_label_update
#define self_update_cb mn_message_label_update_cb
#define self_append_row mn_message_label_append_row
#define self_format_delay mn_message_label_format_delay
#define self_new mn_message_label_new
GType
mn_message_label_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMessageLabelClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_message_label_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMessageLabel),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_message_label_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_LABEL, "MNMessageLabel", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMessageLabel *)g_object_new(mn_message_label_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMessageLabel * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMessageLabel *
GET_NEW_VARG (const char *first, ...)
{
	MNMessageLabel *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMessageLabel *)g_object_new_valist (mn_message_label_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message:Label::dispose"
	MNMessageLabel *self G_GNUC_UNUSED = MN_MESSAGE_LABEL (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 35 "mn-message-label.gob"
	if(self->_priv->message) { g_object_unref ((gpointer) self->_priv->message); self->_priv->message = NULL; }
#line 125 "mn-message-label.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Message:Label::finalize"
	MNMessageLabel *self G_GNUC_UNUSED = MN_MESSAGE_LABEL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 56 "mn-message-label.gob"
	___2_mn_message_label_finalize(obj_self);
#line 138 "mn-message-label.c"
}
#undef __GOB_FUNCTION__

static void 
mn_message_label_init (MNMessageLabel * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message:Label::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNMessageLabelPrivate);
}
#undef __GOB_FUNCTION__
static void 
mn_message_label_class_init (MNMessageLabelClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Message:Label::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMessageLabelPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_LABEL);

#line 40 "mn-message-label.gob"
	g_object_class->constructor = ___1_mn_message_label_constructor;
#line 56 "mn-message-label.gob"
	g_object_class->finalize = ___finalize;
#line 163 "mn-message-label.c"
	g_object_class->dispose = ___dispose;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("message" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MN_TYPE_MESSAGE /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message:Label::set_property"
{
	MNMessageLabel *self G_GNUC_UNUSED;

	self = MN_MESSAGE_LABEL (object);

	switch (property_id) {
	case PROP_MESSAGE:
		{
#line 36 "mn-message-label.gob"
{ GObject *___old = (GObject *)self->_priv->message; self->_priv->message = (MNMessage *)g_value_dup_object (VAL); if (___old != NULL) { g_object_unref (G_OBJECT (___old)); } }
#line 199 "mn-message-label.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Message:Label::get_property"
{
	MNMessageLabel *self G_GNUC_UNUSED;

	self = MN_MESSAGE_LABEL (object);

	switch (property_id) {
	case PROP_MESSAGE:
		{
#line 36 "mn-message-label.gob"
g_value_set_object (VAL, (gpointer)self->_priv->message);
#line 230 "mn-message-label.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 40 "mn-message-label.gob"
static GObject * 
___1_mn_message_label_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 250 "mn-message-label.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Message:Label::constructor"
{
#line 42 "mn-message-label.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    self_update(self);
    if (selfp->message->sent_time)
      selfp->update_timeout_id = g_timeout_add(500, self_update_cb, self);

    return object;
  }}
#line 272 "mn-message-label.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 56 "mn-message-label.gob"
static void 
___2_mn_message_label_finalize (GObject * object G_GNUC_UNUSED)
#line 279 "mn-message-label.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Message:Label::finalize"
#line 56 "mn-message-label.gob"
	g_return_if_fail (object != NULL);
#line 56 "mn-message-label.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 289 "mn-message-label.c"
{
#line 58 "mn-message-label.gob"
	
    Self *self = SELF(object);

    if (selfp->update_timeout_id)
      g_source_remove(selfp->update_timeout_id);

    PARENT_HANDLER(object);
  }}
#line 300 "mn-message-label.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 67 "mn-message-label.gob"
static void 
mn_message_label_update (MNMessageLabel * self)
#line 307 "mn-message-label.c"
{
#define __GOB_FUNCTION__ "MN:Message:Label::update"
#line 67 "mn-message-label.gob"
	g_return_if_fail (self != NULL);
#line 67 "mn-message-label.gob"
	g_return_if_fail (MN_IS_MESSAGE_LABEL (self));
#line 314 "mn-message-label.c"
{
#line 69 "mn-message-label.gob"
	
    GString *string;
    const char *current_label;

    string = g_string_new(NULL);
    self_append_row(string, _("Mailbox"), selfp->message->mailbox_uri->human_readable, TRUE);

    if (selfp->message->error)
      self_append_row(string, _("Unreadable message"), selfp->message->error, FALSE);
    else
      {
	char *ago = NULL;

	if (selfp->message->sent_time)
	  {
	    time_t now;

	    now = mn_time();
	    if (now > 0)
	      {
		time_t diff;

		diff = now - selfp->message->sent_time;
		if (diff >= 0)
		  ago = self_format_delay(diff);
	      }
	  }
	    
	self_append_row(string, _("From"), selfp->message->from, TRUE);
	self_append_row(string, _("Subject"), selfp->message->subject, ago != NULL);

	if (ago)
	  {
	    self_append_row(string, _("Sent"), ago, FALSE);
	    g_free(ago);
	  }
      }

    current_label = gtk_label_get_label(GTK_LABEL(self));
    if (strcmp(current_label, string->str))
      gtk_label_set_markup(GTK_LABEL(self), string->str);
    g_string_free(string, TRUE);
  }}
#line 360 "mn-message-label.c"
#undef __GOB_FUNCTION__

#line 113 "mn-message-label.gob"
static gboolean 
mn_message_label_update_cb (gpointer data)
#line 366 "mn-message-label.c"
{
#define __GOB_FUNCTION__ "MN:Message:Label::update_cb"
#line 113 "mn-message-label.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 371 "mn-message-label.c"
{
#line 115 "mn-message-label.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();
    self_update(self);
    GDK_THREADS_LEAVE();

    return TRUE;		/* continue */
  }}
#line 383 "mn-message-label.c"
#undef __GOB_FUNCTION__

#line 125 "mn-message-label.gob"
static void 
mn_message_label_append_row (GString * string, const char * label, const char * value, gboolean newline)
#line 389 "mn-message-label.c"
{
#define __GOB_FUNCTION__ "MN:Message:Label::append_row"
#line 125 "mn-message-label.gob"
	g_return_if_fail (string != NULL);
#line 125 "mn-message-label.gob"
	g_return_if_fail (label != NULL);
#line 125 "mn-message-label.gob"
	g_return_if_fail (value != NULL);
#line 398 "mn-message-label.c"
{
#line 130 "mn-message-label.gob"
	
    char *markup;

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s:</span> ", label);
    g_string_append(string, markup);
    g_free(markup);
    
    markup = g_markup_escape_text(value, -1);
    g_string_append(string, markup);
    g_free(markup);

    if (newline)
      g_string_append_c(string, '\n');
  }}
#line 415 "mn-message-label.c"
#undef __GOB_FUNCTION__

#line 145 "mn-message-label.gob"
static char * 
mn_message_label_format_delay (time_t delay)
#line 421 "mn-message-label.c"
{
#define __GOB_FUNCTION__ "MN:Message:Label::format_delay"
{
#line 147 "mn-message-label.gob"
	
    char *str;

    if (delay < 60)
      str = g_strdup_printf(ngettext("%i second ago", "%i seconds ago", delay), delay);
    else if (delay < 60 * 60)
      {
	int minutes = delay / 60;
	str = g_strdup_printf(ngettext("%i minute ago", "%i minutes ago", minutes), minutes);
      }
    else if (delay < 60 * 60 * 24)
      {
	int hours = delay / (60 * 60);
	str = g_strdup_printf(ngettext("%i hour ago", "%i hours ago", hours), hours);
      }
    else if (delay < 60 * 60 * 24 * 7)
      {
	int days = delay / (60 * 60 * 24);
	str = g_strdup_printf(ngettext("%i day ago", "%i days ago", days), days);
      }
    else
      {
	int weeks = delay / (60 * 60 * 24 * 7);
	str = g_strdup_printf(ngettext("%i week ago", "%i weeks ago", weeks), weeks);
      }

    return str;
  }}
#line 454 "mn-message-label.c"
#undef __GOB_FUNCTION__

#line 176 "mn-message-label.gob"
GtkWidget * 
mn_message_label_new (MNMessage * message)
#line 460 "mn-message-label.c"
{
#define __GOB_FUNCTION__ "MN:Message:Label::new"
#line 176 "mn-message-label.gob"
	g_return_val_if_fail (message != NULL, (GtkWidget * )0);
#line 176 "mn-message-label.gob"
	g_return_val_if_fail (MN_IS_MESSAGE (message), (GtkWidget * )0);
#line 467 "mn-message-label.c"
{
#line 178 "mn-message-label.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(MN_MESSAGE_LABEL_PROP_MESSAGE(G_OBJECT(message)), NULL));
  }}
#line 473 "mn-message-label.c"
#undef __GOB_FUNCTION__
