/* Generated by GOB (v2.0.10) on Mon Oct 25 15:24:34 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailbox.h"

#include "mn-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 52 "mn-mailbox.gob"

#include "config.h"
#include <glib/gi18n.h>
#ifdef WITH_MBOX
#include "mn-mbox-mailbox.h"
#endif
#ifdef WITH_MH
#include "mn-mh-mailbox.h"
#endif
#ifdef WITH_MAILDIR
#include "mn-maildir-mailbox.h"
#endif
#ifdef WITH_POP3
#include "mn-pop3-mailbox.h"
#endif
#ifdef WITH_IMAP
#include "mn-imap-mailbox.h"
#endif
#ifdef WITH_SYLPHEED
#include "mn-sylpheed-mailbox.h"
#endif
#ifdef WITH_GMAIL
#include "mn-gmail-mailbox.h"
#endif
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-unsupported-mailbox.h"
#include "mn-conf.h"

typedef struct
{
  MNURI		*uri;
  void		(*callback)	(MNMailbox	*self,
				 gpointer	user_data);
  gpointer	user_data;
} NewInfo;

 GType mn_mailbox_types[MN_MAILBOX_N_TYPES + 1];

#line 67 "mn-mailbox.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX(x)
#define SELF_CONST(x) MN_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX(x)
#define TYPE_SELF MN_TYPE_MAILBOX
#define SELF_CLASS(x) MN_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNMailbox Self;
typedef MNMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void mn_mailbox_init (MNMailbox * o) G_GNUC_UNUSED;
static void mn_mailbox_class_init (MNMailboxClass * c) G_GNUC_UNUSED;
static void mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new) G_GNUC_UNUSED;
static void ___c_mn_mailbox_finalize (GObject * object) G_GNUC_UNUSED;
static gpointer mn_mailbox_new_async_thread (gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_mailbox_impl_is (MNMailbox * self, MNURI * uri) G_GNUC_UNUSED;
static void mn_mailbox_impl_check (MNMailbox * self) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__removed(object,func,data)	mn_mailbox_connect__removed((object),(func),(data))
#define self_connect_after__removed(object,func,data)	mn_mailbox_connect_after__removed((object),(func),(data))
#define self_connect_data__removed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailbox_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailbox_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailbox_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailbox *, gboolean , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailbox *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	REMOVED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_URI,
	PROP_NAME,
	PROP_AUTOMATIC,
	PROP_HAS_NEW,
	PROP_MESSAGES,
	PROP_ERROR
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_removed mn_mailbox_removed
#define self_get_name mn_mailbox_get_name
#define self_get_automatic mn_mailbox_get_automatic
#define self_set_automatic mn_mailbox_set_automatic
#define self_get_has_new mn_mailbox_get_has_new
#define self_set_has_new mn_mailbox_set_has_new
#define self_get_messages mn_mailbox_get_messages
#define self_set_messages mn_mailbox_set_messages
#define self_messages_changed mn_mailbox_messages_changed
#define self_set_error mn_mailbox_set_error
#define self_get_error mn_mailbox_get_error
#define self_init_types mn_mailbox_init_types
#define self_new_async mn_mailbox_new_async
#define self_new_async_thread mn_mailbox_new_async_thread
#define self_set_init_error mn_mailbox_set_init_error
#define self_monitor mn_mailbox_monitor
#define self_monitor_cb mn_mailbox_monitor_cb
#define self_impl_is mn_mailbox_impl_is
#define self_impl_check mn_mailbox_impl_check
#define self_check mn_mailbox_check
#define self_end_check mn_mailbox_end_check
#define self_notice mn_mailbox_notice
GType
mn_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailbox *)g_object_new(mn_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailbox *)g_object_new_valist (mn_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::dispose"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 129 "mn-mailbox.gob"
	if(self->uri) { g_object_unref ((gpointer) self->uri); self->uri = NULL; }
#line 231 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
	MNMailbox *self G_GNUC_UNUSED = MN_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 234 "mn-mailbox.gob"
	___c_mn_mailbox_finalize(obj_self);
#line 244 "mn-mailbox.c"
#line 140 "mn-mailbox.gob"
	if(self->_priv->name) { g_free ((gpointer) self->_priv->name); self->_priv->name = NULL; }
#line 247 "mn-mailbox.c"
#line 154 "mn-mailbox.gob"
	if(self->_priv->messages) { mn_g_object_slist_free ((gpointer) self->_priv->messages); self->_priv->messages = NULL; }
#line 250 "mn-mailbox.c"
#line 208 "mn-mailbox.gob"
	if(self->_priv->error) { g_free ((gpointer) self->_priv->error); self->_priv->error = NULL; }
#line 253 "mn-mailbox.c"
#line 229 "mn-mailbox.gob"
	if(self->_priv->monitor_uri) { g_free ((gpointer) self->_priv->monitor_uri); self->_priv->monitor_uri = NULL; }
#line 256 "mn-mailbox.c"
#line 363 "mn-mailbox.gob"
	if(self->_priv->init_error) { g_free ((gpointer) self->_priv->init_error); self->_priv->init_error = NULL; }
#line 259 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailbox_init (MNMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNMailboxPrivate);
#line 52 "mn-mailbox.gob"
	o->uri = NULL;
#line 270 "mn-mailbox.c"
}
#undef __GOB_FUNCTION__
static void 
mn_mailbox_class_init (MNMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[REMOVED_SIGNAL] =
		g_signal_new ("removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxClass, removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxClass, messages_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("mn-mailbox.gob line 205: Type mismatch of \"messages_changed\" signal signature");
	}

	c->removed = NULL;
	c->messages_changed = NULL;
#line 234 "mn-mailbox.gob"
	g_object_class->finalize = ___finalize;
#line 308 "mn-mailbox.c"
	c->impl_is = NULL;
	c->impl_check = NULL;
	g_object_class->dispose = ___dispose;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("uri" /* name */,
		 NULL /* nick */,
		 _("The mailbox URI") /* blurb */,
		 MN_TYPE_URI /* object_type */,
		 (GParamFlags)(G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_URI,
		param_spec);
	param_spec = g_param_spec_string
		("name" /* name */,
		 NULL /* nick */,
		 _("The mailbox human-readable name") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_boolean
		("automatic" /* name */,
		 NULL /* nick */,
		 _("Whether the mailbox has to be manually checked or not") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_AUTOMATIC,
		param_spec);
	param_spec = g_param_spec_boolean
		("has_new" /* name */,
		 NULL /* nick */,
		 _("Whether the mailbox has new mail or not") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HAS_NEW,
		param_spec);
	param_spec = g_param_spec_pointer
		("messages" /* name */,
		 NULL /* nick */,
		 _("The list of new and unread MNMessage objects") /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MESSAGES,
		param_spec);
	param_spec = g_param_spec_string
		("error" /* name */,
		 NULL /* nick */,
		 _("The mailbox error, if any") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ERROR,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::set_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_URI:
		{
#line 134 "mn-mailbox.gob"

      g_return_if_fail(self->uri == NULL);
      self->uri = MN_URI(g_value_dup_object(VAL));
      selfp->name = g_strdup(self->uri->human_readable);
    
#line 394 "mn-mailbox.c"
		}
		break;
	case PROP_NAME:
		{
#line 141 "mn-mailbox.gob"
{ char *old = self->_priv->name; self->_priv->name = g_value_dup_string (VAL); g_free (old); }
#line 401 "mn-mailbox.c"
		}
		break;
	case PROP_AUTOMATIC:
		{
#line 145 "mn-mailbox.gob"
self->_priv->automatic = g_value_get_boolean (VAL);
#line 408 "mn-mailbox.c"
		}
		break;
	case PROP_HAS_NEW:
		{
#line 150 "mn-mailbox.gob"
self->_priv->has_new = g_value_get_boolean (VAL);
#line 415 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 158 "mn-mailbox.gob"

      GSList *messages;
      GSList *l;
      gboolean changed = FALSE;
      gboolean has_new = FALSE;

      messages = g_value_get_pointer(VAL);
      
      MN_LIST_FOREACH(l, selfp->messages)
	if (! mn_message_slist_find_by_id(messages, l->data))
	  {
	    changed = TRUE;
	    break;
	  }
      
      MN_LIST_FOREACH(l, messages)
	if (! mn_message_slist_find_by_id(selfp->messages, l->data))
	  {
	    changed = TRUE;
	    has_new = TRUE;
	    break;
	  }

      mn_g_object_slist_free(selfp->messages);
      selfp->messages = mn_g_object_slist_copy(messages);

      if (changed)
	self_messages_changed(self, has_new);
    
#line 450 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 209 "mn-mailbox.gob"
{ char *old = self->_priv->error; self->_priv->error = g_value_dup_string (VAL); g_free (old); }
#line 457 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailbox::get_property"
{
	MNMailbox *self G_GNUC_UNUSED;

	self = MN_MAILBOX (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 141 "mn-mailbox.gob"
g_value_set_string (VAL, self->_priv->name);
#line 488 "mn-mailbox.c"
		}
		break;
	case PROP_AUTOMATIC:
		{
#line 145 "mn-mailbox.gob"
g_value_set_boolean (VAL, self->_priv->automatic);
#line 495 "mn-mailbox.c"
		}
		break;
	case PROP_HAS_NEW:
		{
#line 150 "mn-mailbox.gob"
g_value_set_boolean (VAL, self->_priv->has_new);
#line 502 "mn-mailbox.c"
		}
		break;
	case PROP_MESSAGES:
		{
#line 188 "mn-mailbox.gob"

      g_value_set_pointer(VAL, selfp->messages);
    
#line 511 "mn-mailbox.c"
		}
		break;
	case PROP_ERROR:
		{
#line 209 "mn-mailbox.gob"
g_value_set_string (VAL, self->_priv->error);
#line 518 "mn-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



/**
 * mn_mailbox_removed:
 * @self: the object which received the signal
 *
 * This signal gets emitted after the mailbox is removed from the
 * mailboxes list.
 **/
#line 126 "mn-mailbox.gob"
void 
mn_mailbox_removed (MNMailbox * self)
#line 545 "mn-mailbox.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 126 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 126 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 557 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 142 "mn-mailbox.gob"
const char * 
mn_mailbox_get_name (MNMailbox * self)
#line 574 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_name"
#line 142 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 142 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (const char * )0);
#line 581 "mn-mailbox.c"
{
#line 142 "mn-mailbox.gob"
	 return selfp->name; }}
#line 585 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 145 "mn-mailbox.gob"
gboolean 
mn_mailbox_get_automatic (MNMailbox * self)
#line 591 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_automatic"
{
#line 145 "mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "automatic", &val, NULL); return val;
}}
#line 598 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 145 "mn-mailbox.gob"
void 
mn_mailbox_set_automatic (MNMailbox * self, gboolean val)
#line 604 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_automatic"
{
#line 145 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "automatic", val, NULL);
}}
#line 611 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 150 "mn-mailbox.gob"
gboolean 
mn_mailbox_get_has_new (MNMailbox * self)
#line 617 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_has_new"
{
#line 150 "mn-mailbox.gob"
		gboolean val; g_object_get (G_OBJECT (self), "has_new", &val, NULL); return val;
}}
#line 624 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 150 "mn-mailbox.gob"
void 
mn_mailbox_set_has_new (MNMailbox * self, gboolean val)
#line 630 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_has_new"
{
#line 150 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "has_new", val, NULL);
}}
#line 637 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 188 "mn-mailbox.gob"
gpointer 
mn_mailbox_get_messages (MNMailbox * self)
#line 643 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_messages"
{
#line 155 "mn-mailbox.gob"
		gpointer val; g_object_get (G_OBJECT (self), "messages", &val, NULL); return val;
}}
#line 650 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 158 "mn-mailbox.gob"
void 
mn_mailbox_set_messages (MNMailbox * self, gpointer val)
#line 656 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_messages"
{
#line 155 "mn-mailbox.gob"
		g_object_set (G_OBJECT (self), "messages", val, NULL);
}}
#line 663 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 205 "mn-mailbox.gob"
static void 
mn_mailbox_messages_changed (MNMailbox * self, gboolean has_new)
#line 669 "mn-mailbox.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 205 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 205 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 681 "mn-mailbox.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 210 "mn-mailbox.gob"
void 
mn_mailbox_set_error (MNMailbox * self, const char * format, ...)
#line 703 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_error"
#line 210 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 210 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 710 "mn-mailbox.c"
{
#line 212 "mn-mailbox.gob"
	
    va_list args;
    char *error = NULL;

    if (format)
      {
	va_start(args, format);
	error = g_strdup_vprintf(format, args);
	va_end(args);
      }
    
    g_object_set(G_OBJECT(self), MN_MAILBOX_PROP_ERROR(error), NULL);
    g_free(error);
  }}
#line 727 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 226 "mn-mailbox.gob"
const char * 
mn_mailbox_get_error (MNMailbox * self)
#line 733 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::get_error"
#line 226 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (const char * )0);
#line 226 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (const char * )0);
#line 740 "mn-mailbox.c"
{
#line 226 "mn-mailbox.gob"
	 return selfp->error; }}
#line 744 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 234 "mn-mailbox.gob"
static void 
___c_mn_mailbox_finalize (GObject * object G_GNUC_UNUSED)
#line 750 "mn-mailbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Mailbox::finalize"
#line 234 "mn-mailbox.gob"
	g_return_if_fail (object != NULL);
#line 234 "mn-mailbox.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 760 "mn-mailbox.c"
{
#line 236 "mn-mailbox.gob"
	
    Self *self = SELF(object);

    if (selfp->monitor_handle)
      gnome_vfs_monitor_cancel(selfp->monitor_handle);

    PARENT_HANDLER(object);
  }}
#line 771 "mn-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 245 "mn-mailbox.gob"
void 
mn_mailbox_init_types (void)
#line 778 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::init_types"
{
#line 247 "mn-mailbox.gob"
	
    int i = 0;

#ifdef WITH_MBOX
    mn_mailbox_types[i++] = MN_TYPE_MBOX_MAILBOX;
#endif
#ifdef WITH_MH
    mn_mailbox_types[i++] = MN_TYPE_MH_MAILBOX;
#endif
#ifdef WITH_MAILDIR
    mn_mailbox_types[i++] = MN_TYPE_MAILDIR_MAILBOX;
#endif
#ifdef WITH_POP3
    mn_mailbox_types[i++] = MN_TYPE_POP3_MAILBOX;
#endif
#ifdef WITH_IMAP
    mn_mailbox_types[i++] = MN_TYPE_IMAP_MAILBOX;
#endif
#ifdef WITH_SYLPHEED
    mn_mailbox_types[i++] = MN_TYPE_SYLPHEED_MAILBOX;
#endif
#ifdef WITH_GMAIL
    mn_mailbox_types[i++] = MN_TYPE_GMAIL_MAILBOX;
#endif
    mn_mailbox_types[i] = 0;
  }}
#line 809 "mn-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_mailbox_new_async:
 * @uri: location of the mailbox
 * @callback: a function like
 *            "void (callback) (#MNMailbox *self, gpointer user_data)"
 * @user_data: data to pass to @callback
 *
 * Creates a new #MNMailbox asynchronously. The newly created
 * #MNMailbox will be passed to @callback.
 **/
#line 284 "mn-mailbox.gob"
void 
mn_mailbox_new_async (MNURI * uri, gpointer callback, gpointer user_data)
#line 825 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_async"
#line 284 "mn-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 284 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_URI (uri));
#line 284 "mn-mailbox.gob"
	g_return_if_fail (callback != NULL);
#line 834 "mn-mailbox.c"
{
#line 288 "mn-mailbox.gob"
	
    NewInfo *info;

    info = g_new(NewInfo, 1);
    info->uri = g_object_ref(uri);
    info->callback = callback;
    info->user_data = user_data;

    mn_thread_create(self_new_async_thread, info);
  }}
#line 847 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 299 "mn-mailbox.gob"
static gpointer 
mn_mailbox_new_async_thread (gpointer data)
#line 853 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::new_async_thread"
{
#line 301 "mn-mailbox.gob"
	
    NewInfo *info = data;
    Self *mailbox = NULL;

    if (info->uri->vfs)
      {
	if (! mn_vfs_test(info->uri->vfs, G_FILE_TEST_EXISTS))
	  mailbox = mn_unsupported_mailbox_new(info->uri, _("does not exist"));
      }

    if (! mailbox)
      {
	int i;
	
	for (i = 0; mn_mailbox_types[i]; i++)
	  {
	    SelfClass *class;

	    class = g_type_class_peek(mn_mailbox_types[i]);
	    g_return_val_if_fail(class != NULL, NULL);

	    if (class->impl_is(NULL, info->uri))
	      {
		mailbox = g_object_new(mn_mailbox_types[i], MN_MAILBOX_PROP_URI(G_OBJECT(info->uri)), NULL);
		if (mailbox->_priv->init_error)
		  {
		    MNMailbox *old_mailbox;
		  
		    old_mailbox = mailbox;
		    mailbox = mn_unsupported_mailbox_new(info->uri, old_mailbox->_priv->init_error);
		    g_object_unref(old_mailbox);
		  }
		
		break;
	      }
	  }
      }

    if (! mailbox)
      mailbox = mn_unsupported_mailbox_new(info->uri, _("unknown format"));

    GDK_THREADS_ENTER();

    info->callback(mailbox, info->user_data);

    /*
     * A note on gdk_flush(): as adviced in the GDK threads
     * documentation, we only call gdk_flush() from a thread other
     * than our main thread (so we do not call it in idle and timeout
     * callbacks).
     */
    gdk_flush();
    GDK_THREADS_LEAVE();

    /* mailbox is now owned by the callback, do not unref it */
    
    g_object_unref(info->uri);
    g_free(info);

    return NULL;
  }}
#line 919 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 364 "mn-mailbox.gob"
void 
mn_mailbox_set_init_error (MNMailbox * self, const char * format, ...)
#line 925 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::set_init_error"
#line 364 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 364 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 364 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 934 "mn-mailbox.c"
{
#line 366 "mn-mailbox.gob"
	
    va_list args;

    g_return_if_fail(selfp->init_error == NULL);

    va_start(args, format);
    selfp->init_error = g_strdup_vprintf(format, args);
    va_end(args);
  }}
#line 946 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 376 "mn-mailbox.gob"
void 
mn_mailbox_monitor (MNMailbox * self, const char * uri, GnomeVFSMonitorType monitor_type, MNMailboxMonitorEventType events)
#line 952 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::monitor"
#line 376 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 376 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 376 "mn-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 961 "mn-mailbox.c"
{
#line 381 "mn-mailbox.gob"
	
    GnomeVFSResult result;

    g_return_if_fail(MN_MAILBOX_CAN_CHECK(self));
    g_return_if_fail(selfp->monitor_handle == NULL);
    
    gdk_flush();
    GDK_THREADS_LEAVE();

    result = gnome_vfs_monitor_add(&selfp->monitor_handle,
				   uri,
				   monitor_type,
				   self_monitor_cb,
				   self);

    GDK_THREADS_ENTER();
    
    if (result == GNOME_VFS_OK)
      {
	selfp->monitor_uri = g_strdup(uri);
	selfp->monitor_events = events;
	self_set_automatic(self, TRUE);
      }
    else
      {
	g_warning(_("unable to enable immediate notification for %s: %s"), uri, gnome_vfs_result_to_string(result));

	if (! eel_gconf_get_boolean(MN_CONF_IMMEDIATE_NOTIFICATION_ERROR_DIALOG_DO_NOT_SHOW))
	  {
	    static gboolean first_time = TRUE;
	    
	    if (first_time)
	      {
		int minutes;
		int seconds;
		char *str;
	    
		first_time = FALSE;
	    
		minutes = eel_gconf_get_integer(MN_CONF_DELAY_MINUTES);
		seconds = eel_gconf_get_integer(MN_CONF_DELAY_SECONDS);
		
		if (minutes == 0)
		  str = g_strdup_printf(ngettext("As a fallback, they will be "
						 "checked every %i second (this "
						 "delay is configurable from the "
						 "Properties Dialog).",
						 "As a fallback, they will be "
						 "checked every %i seconds (this "
						 "delay is configurable from the "
						 "Properties Dialog).",
					     seconds),
					seconds);
		else if (seconds == 0)
		  str = g_strdup_printf(ngettext("As a fallback, they will be "
						 "checked every %i minute (this "
						 "delay is configurable from the "
						 "Properties Dialog).",
						 "As a fallback, they will be "
						 "checked every %i minutes (this "
						 "delay is configurable from the "
						 "Properties Dialog).",
						 minutes),
					minutes);
		else
		  str = g_strdup_printf(ngettext("As a fallback, they will be "
						 "checked approximately every %i "
						 "minute (this delay is "
						 "configurable from the "
						 "Properties Dialog).",
						 "As a fallback, they will be "
						 "checked approximately every %i "
						 "minutes (this delay is "
						 "configurable from the "
						 "Properties Dialog).",
						 minutes),
					minutes);
		
		mn_error_dialog(NULL,
				MN_CONF_IMMEDIATE_NOTIFICATION_ERROR_DIALOG_DO_NOT_SHOW,
				"immediate-notification",
				_("A monitoring error has occurred"),
				_("Mail Notification was unable to enable immediate "
				  "notification for one or more mailboxes. %s"), str);
		g_free(str);
	      }
	  }
      }
  }}
#line 1053 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 471 "mn-mailbox.gob"
static void 
mn_mailbox_monitor_cb (GnomeVFSMonitorHandle * handle, const char * monitor_uri, const char * info_uri, GnomeVFSMonitorEventType event_type, gpointer user_data)
#line 1059 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::monitor_cb"
#line 471 "mn-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 1064 "mn-mailbox.c"
{
#line 477 "mn-mailbox.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    if (selfp->monitor_events & (1 << event_type))
      self_check(self);
    GDK_THREADS_LEAVE();
  }}
#line 1075 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 486 "mn-mailbox.gob"
static gboolean 
mn_mailbox_impl_is (MNMailbox * self, MNURI * uri)
#line 1081 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 486 "mn-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 486 "mn-mailbox.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (self), (gboolean )0);
#line 1088 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->impl_is)
		return (*klass->impl_is)(self,uri);
	else
		return (gboolean )(0);
}

#line 488 "mn-mailbox.gob"
static void 
mn_mailbox_impl_check (MNMailbox * self)
#line 1100 "mn-mailbox.c"
{
	MNMailboxClass *klass;
#line 488 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 488 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1107 "mn-mailbox.c"
	klass = MN_MAILBOX_GET_CLASS(self);

	if(klass->impl_check)
		(*klass->impl_check)(self);
}

#line 491 "mn-mailbox.gob"
void 
mn_mailbox_check (MNMailbox * self)
#line 1117 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::check"
#line 491 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 491 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1124 "mn-mailbox.c"
{
#line 493 "mn-mailbox.gob"
	
    g_return_if_fail(MN_MAILBOX_CAN_CHECK(self));

    if (! selfp->checking)
      {
	g_object_ref(self);
	selfp->checking = TRUE;
	self_set_error(self, NULL);

	mn_thread_create((GThreadFunc) SELF_GET_CLASS(self)->impl_check, self);
      }
  }}
#line 1139 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 506 "mn-mailbox.gob"
void 
mn_mailbox_end_check (MNMailbox * self)
#line 1145 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::end_check"
#line 506 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 506 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 1152 "mn-mailbox.c"
{
#line 508 "mn-mailbox.gob"
	
    g_return_if_fail(selfp->checking == TRUE);

    selfp->checking = FALSE;
    g_object_unref(self);
  }}
#line 1161 "mn-mailbox.c"
#undef __GOB_FUNCTION__

#line 515 "mn-mailbox.gob"
void 
mn_mailbox_notice (MNMailbox * self, const char * format, ...)
#line 1167 "mn-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox::notice"
#line 515 "mn-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 515 "mn-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (self));
#line 515 "mn-mailbox.gob"
	g_return_if_fail (format != NULL);
#line 1176 "mn-mailbox.c"
{
#line 517 "mn-mailbox.gob"
	
    va_list args;
    char *notice;
    
    va_start(args, format);
    notice = g_strdup_vprintf(format, args);
    va_end(args);

    mn_info("%s: %s", self->uri->text, notice);
    g_free(notice);
  }}
#line 1190 "mn-mailbox.c"
#undef __GOB_FUNCTION__
