/* Generated by GOB (v2.0.10) on Mon Oct 25 15:24:33 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#define selfp (self->_priv)

#include "mn-gmail-mailbox.h"

#include "mn-gmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "mn-gmail-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <time.h>
#ifdef TM_IN_SYS_TIME
#include <sys/time.h>
#endif
#include <glib/gi18n.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#include "mn-stock.h"
#include "mn-sgml-ref.h"

#line 40 "mn-gmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_GMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_GMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_GMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_GMAIL_MAILBOX
#define SELF_CLASS(x) MN_GMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_GMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNGmailMailbox Self;
typedef MNGmailMailboxClass SelfClass;

/* here are local prototypes */
static void mn_gmail_mailbox_init (MNGmailMailbox * o) G_GNUC_UNUSED;
static void mn_gmail_mailbox_class_init (MNGmailMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_gmail_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_gmail_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static MNAuthenticatedMailboxResult ___4_mn_gmail_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox, GError ** err) G_GNUC_UNUSED;
static SoupUri * mn_gmail_mailbox_soup_uri_new (const char * text_uri, GError ** err) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_get (MNGmailMailbox * self, SoupSession * session, const char * text_uri, GError ** err) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_get_from_uri (MNGmailMailbox * self, SoupSession * session, SoupUri * uri, GError ** err) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_request (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_request_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_response (MNGmailMailbox * self, SoupMessage * message, const char * body) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_response_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_get_token (const char * str, const char * pre, const char * post, gboolean include_pre, gboolean include_post) G_GNUC_UNUSED;
static gboolean mn_gmail_mailbox_login (MNGmailMailbox * self, SoupSession * session, gboolean * authentication_failed, GError ** err) G_GNUC_UNUSED;
static void mn_gmail_mailbox_update_cookies (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_build_cookie (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_build_cookie_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_gmail_mailbox_check (MNGmailMailbox * self, SoupSession * session, GError ** err) G_GNUC_UNUSED;
static time_t mn_gmail_mailbox_parse_date (const char * date) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_soup_uri_new mn_gmail_mailbox_soup_uri_new
#define self_get mn_gmail_mailbox_get
#define self_get_from_uri mn_gmail_mailbox_get_from_uri
#define self_dump_request mn_gmail_mailbox_dump_request
#define self_dump_request_cb mn_gmail_mailbox_dump_request_cb
#define self_dump_response mn_gmail_mailbox_dump_response
#define self_dump_response_cb mn_gmail_mailbox_dump_response_cb
#define self_get_token mn_gmail_mailbox_get_token
#define self_login mn_gmail_mailbox_login
#define self_update_cookies mn_gmail_mailbox_update_cookies
#define self_build_cookie mn_gmail_mailbox_build_cookie
#define self_build_cookie_cb mn_gmail_mailbox_build_cookie_cb
#define self_check mn_gmail_mailbox_check
#define self_parse_date mn_gmail_mailbox_parse_date
GType
mn_gmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNGmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_gmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNGmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_gmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNGmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNGmailMailbox *)g_object_new(mn_gmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNGmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNGmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNGmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNGmailMailbox *)g_object_new_valist (mn_gmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::finalize"
	MNGmailMailbox *self G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 46 "mn-gmail-mailbox.gob"
	if(self->_priv->cookies) { g_hash_table_destroy ((gpointer) self->_priv->cookies); self->_priv->cookies = NULL; }
#line 146 "mn-gmail-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_gmail_mailbox_init (MNGmailMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNGmailMailboxPrivate);
}
#undef __GOB_FUNCTION__
#line 49 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_class_init (MNGmailMailboxClass * class G_GNUC_UNUSED)
#line 160 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(MNGmailMailboxPrivate));
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 55 "mn-gmail-mailbox.gob"
	g_object_class->constructor = ___2_mn_gmail_mailbox_constructor;
#line 68 "mn-gmail-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_gmail_mailbox_impl_is;
#line 74 "mn-gmail-mailbox.gob"
	mn_authenticated_mailbox_class->impl_authenticated_check = ___4_mn_gmail_mailbox_impl_authenticated_check;
#line 177 "mn-gmail-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 50 "mn-gmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->stock_id = MN_STOCK_GMAIL;
    MN_MAILBOX_CLASS(class)->format = "Gmail";
  
#line 185 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 55 "mn-gmail-mailbox.gob"
static GObject * 
___2_mn_gmail_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 195 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::constructor"
{
#line 57 "mn-gmail-mailbox.gob"
	
    GObject *object;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    
    if (! soup_ssl_supported)
      mn_mailbox_set_init_error(MN_MAILBOX(object), _("libsoup has not been compiled with SSL/TLS support"));

    return object;
  }}
#line 214 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 68 "mn-gmail-mailbox.gob"
static gboolean 
___3_mn_gmail_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 221 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::impl_is"
#line 68 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 68 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 232 "mn-gmail-mailbox.c"
{
#line 70 "mn-gmail-mailbox.gob"
	
    return MN_URI_IS_GMAIL(uri);
  }}
#line 238 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 74 "mn-gmail-mailbox.gob"
static MNAuthenticatedMailboxResult 
___4_mn_gmail_mailbox_impl_authenticated_check (MNAuthenticatedMailbox * authenticated_mailbox G_GNUC_UNUSED, GError ** err)
#line 245 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___authenticated_mailbox,___err) \
	((MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)? \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->impl_authenticated_check)(___authenticated_mailbox,___err): \
		((MNAuthenticatedMailboxResult )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::impl_authenticated_check"
#line 74 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (authenticated_mailbox != NULL, (MNAuthenticatedMailboxResult )0);
#line 74 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_AUTHENTICATED_MAILBOX (authenticated_mailbox), (MNAuthenticatedMailboxResult )0);
#line 256 "mn-gmail-mailbox.c"
{
#line 77 "mn-gmail-mailbox.gob"
	
    Self *self = SELF(authenticated_mailbox);
    SoupSession *session;
    gboolean authentication_failed;
    MNAuthenticatedMailboxResult result;

    session = mn_soup_session_sync_new();

    if (! selfp->logged_in)
      selfp->logged_in = self_login(self, session, &authentication_failed, err);

    if (selfp->logged_in)
      result = self_check(self, session, err) ? MN_AUTHENTICATED_MAILBOX_OK : MN_AUTHENTICATED_MAILBOX_ERROR_OTHER;
    else
      result = authentication_failed ? MN_AUTHENTICATED_MAILBOX_ERROR_AUTHENTICATION : MN_AUTHENTICATED_MAILBOX_ERROR_OTHER;
    
    g_object_unref(session);

    return result;
  }}
#line 279 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 98 "mn-gmail-mailbox.gob"
static SoupUri * 
mn_gmail_mailbox_soup_uri_new (const char * text_uri, GError ** err)
#line 286 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::soup_uri_new"
#line 98 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (text_uri != NULL, (SoupUri * )0);
#line 291 "mn-gmail-mailbox.c"
{
#line 100 "mn-gmail-mailbox.gob"
	
    SoupUri *uri;

    uri = soup_uri_new(text_uri);
    if (! uri)
      g_set_error(err, 0, 0, _("unable to parse URI \"%s\""), text_uri);

    return uri;
  }}
#line 303 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 110 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_get (MNGmailMailbox * self, SoupSession * session, const char * text_uri, GError ** err)
#line 309 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get"
#line 110 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 110 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (char * )0);
#line 110 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (session != NULL, (char * )0);
#line 110 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (SOUP_IS_SESSION (session), (char * )0);
#line 110 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (text_uri != NULL, (char * )0);
#line 322 "mn-gmail-mailbox.c"
{
#line 115 "mn-gmail-mailbox.gob"
	
    SoupUri *uri;
    char *body;

    uri = self_soup_uri_new(text_uri, err);
    if (! uri)
      return NULL;

    body = self_get_from_uri(self, session, uri, err);
    soup_uri_free(uri);

    return body;
  }}
#line 338 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 129 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_get_from_uri (MNGmailMailbox * self, SoupSession * session, SoupUri * uri, GError ** err)
#line 344 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_from_uri"
#line 129 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 129 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (char * )0);
#line 129 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (session != NULL, (char * )0);
#line 129 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (SOUP_IS_SESSION (session), (char * )0);
#line 129 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (char * )0);
#line 357 "mn-gmail-mailbox.c"
{
#line 134 "mn-gmail-mailbox.gob"
	
    SoupMessage *message;
    char *cookie;
    char *body = NULL;

    message = soup_message_new_from_uri(SOUP_METHOD_GET, uri);
    soup_message_add_header(message->request_headers, "User-Agent", "Mail Notification");

    cookie = self_build_cookie(self);
    if (cookie)
      {
	soup_message_add_header(message->request_headers, "Cookie", cookie);
	g_free(cookie);
      }
    
    self_dump_request(self, message);
    soup_session_send_message(session, message);

    if (SOUP_STATUS_IS_SUCCESSFUL(message->status_code))
      {
	body = g_strndup(message->response.body, message->response.length);
	self_dump_response(self, message, body);
	self_update_cookies(self, message);
      }
    else
      g_set_error(err, 0, 0, _("unable to transfer data: %s"), message->reason_phrase);

    g_object_unref(message);
    
    return body;
  }}
#line 391 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 166 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_request (MNGmailMailbox * self, SoupMessage * message)
#line 397 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_request"
#line 166 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 166 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 166 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 166 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 408 "mn-gmail-mailbox.c"
{
#line 168 "mn-gmail-mailbox.gob"
	
    const SoupUri *suri;
    char *uri;

    suri = soup_message_get_uri(message);
    uri = soup_uri_to_string(suri, FALSE);
    mn_mailbox_notice(MN_MAILBOX(self), "> GET %s", uri);
    g_free(uri);

    soup_message_foreach_header(message->request_headers, self_dump_request_cb, self);
  }}
#line 422 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 180 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_request_cb (gpointer key, gpointer value, gpointer user_data)
#line 428 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_request_cb"
#line 180 "mn-gmail-mailbox.gob"
	g_return_if_fail (key != NULL);
#line 180 "mn-gmail-mailbox.gob"
	g_return_if_fail (value != NULL);
#line 180 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 437 "mn-gmail-mailbox.c"
{
#line 184 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;
    const char *header_name = key;
    const char *header_value = value;

    mn_mailbox_notice(MN_MAILBOX(self), "> %s: %s", header_name, header_value);
  }}
#line 447 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 192 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_response (MNGmailMailbox * self, SoupMessage * message, const char * body)
#line 453 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_response"
#line 192 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 192 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 192 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 192 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 192 "mn-gmail-mailbox.gob"
	g_return_if_fail (body != NULL);
#line 466 "mn-gmail-mailbox.c"
{
#line 196 "mn-gmail-mailbox.gob"
	
    char **lines;
    int i;
    
    soup_message_foreach_header(message->response_headers, self_dump_response_cb, self);

    lines = g_strsplit(body, "\n", 0);
    for (i = 0; lines[i]; i++)
      mn_mailbox_notice(MN_MAILBOX(self), "< %s", lines[i]);
    g_strfreev(lines);
  }}
#line 480 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 208 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_response_cb (gpointer key, gpointer value, gpointer user_data)
#line 486 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_response_cb"
#line 208 "mn-gmail-mailbox.gob"
	g_return_if_fail (key != NULL);
#line 208 "mn-gmail-mailbox.gob"
	g_return_if_fail (value != NULL);
#line 208 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 495 "mn-gmail-mailbox.c"
{
#line 212 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;
    const char *header_name = key;
    const char *header_value = value;

    mn_mailbox_notice(MN_MAILBOX(self), "< %s: %s", header_name, header_value);
  }}
#line 505 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_gmail_mailbox_get_token:
 * @str: the string to search
 * @pre: the start of the token
 * @post: the end of the token
 * @include_pre: whether to include @pre in the result or not
 * @include_post: whether to include @post in the result or not
 *
 * Gets the first token of @str included between @pre and @post.
 *
 * Return value: a newly allocated string containing the token or
 *               %NULL if not found.
 **/
#line 233 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_get_token (const char * str, const char * pre, const char * post, gboolean include_pre, gboolean include_post)
#line 524 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_token"
#line 233 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 233 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (pre != NULL, (char * )0);
#line 233 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (post != NULL, (char * )0);
#line 533 "mn-gmail-mailbox.c"
{
#line 239 "mn-gmail-mailbox.gob"
	
    char *token = NULL;
    char *pre_loc;
    
    pre_loc = strstr(str, pre);
    if (pre_loc)
      {
	char *after_pre_loc;
	char *post_loc;
	
	after_pre_loc = pre_loc + strlen(pre);
	post_loc = strstr(after_pre_loc, post);
	if (post_loc)
	  {
	    char *start = include_pre ? pre_loc : after_pre_loc;
	    char *end = include_post ? post_loc + strlen(post) : post_loc;
	    
	    token = g_strndup(start, end - start);
	  }
      }
    
    return token;
  }}
#line 559 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 263 "mn-gmail-mailbox.gob"
static gboolean 
mn_gmail_mailbox_login (MNGmailMailbox * self, SoupSession * session, gboolean * authentication_failed, GError ** err)
#line 565 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login"
#line 263 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 263 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (gboolean )0);
#line 263 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (session != NULL, (gboolean )0);
#line 263 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (SOUP_IS_SESSION (session), (gboolean )0);
#line 263 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (authentication_failed != NULL, (gboolean )0);
#line 578 "mn-gmail-mailbox.c"
{
#line 268 "mn-gmail-mailbox.gob"
	
    char *text_uri;
    char *escaped_username;
    char *escaped_password;
    char *body;
    char *next_location;
    char *query;
    SoupUri *uri;
    gboolean success;

    g_return_val_if_fail(selfp->logged_in == FALSE, FALSE);
    
    mn_mailbox_notice(MN_MAILBOX(self), _("logging in"));
    *authentication_failed = FALSE;

    if (selfp->cookies)
      g_hash_table_destroy(selfp->cookies);
    selfp->cookies = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);

#define EXTRA_CHARS ";/?:@&=+$,"/* taken from RFC 2396 2.2 */
    escaped_username = soup_uri_encode(MN_MAILBOX(self)->uri->username, EXTRA_CHARS);
    escaped_password = soup_uri_encode(MN_AUTHENTICATED_MAILBOX(self)->password, EXTRA_CHARS);
    text_uri = g_strdup_printf("https://www.google.com/accounts/ServiceLoginBoxAuth?service=mail&continue=http://gmail.google.com/gmail&Email=%s&Passwd=%s", escaped_username, escaped_password);
    g_free(escaped_username);
    g_free(escaped_password);

    body = self_get(self, session, text_uri, err);
    g_free(text_uri);

    if (! body)
      return FALSE;

    next_location = self_get_token(body, "top.location = \"", "\"", FALSE, FALSE);
    g_free(body);

    if (! next_location)
      {
	*authentication_failed = TRUE;
	goto failed;
      }

    /*
     * The following kludges work around
     * http://bugzilla.ximian.com/show_bug.cgi?id=66516.
     *
     * FIXME: remove it and bump libsoup version requirement when the
     * bug is fixed.
     */

    query = strchr(next_location, '?');
    if (query)
      *query = 0;

    text_uri = g_strdup_printf("https://www.google.com/accounts/%s", next_location);
    g_free(next_location);

    uri = self_soup_uri_new(text_uri, err);
    g_free(text_uri);

    if (! uri)
      return FALSE;

    if (query)
      {
	uri->query = g_strdup(query + 1);
	uri->broken_encoding = TRUE;
      }

    body = self_get_from_uri(self, session, uri, err);
    soup_uri_free(uri);

    if (! body)
      return FALSE;

    next_location = self_get_token(body, "location.replace(\"", "\")", FALSE, FALSE);
    g_free(body);

    if (! next_location)
      goto failed;

    body = self_get(self, session, next_location, err);
    g_free(next_location);

    success = strstr(body, "frame name=js src=/gmail") != NULL;
    g_free(body);

    if (success)
      return TRUE;
    
  failed:
    g_set_error(err, 0, 0, _("login failed"));
    return FALSE;
  }}
#line 674 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 362 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_update_cookies (MNGmailMailbox * self, SoupMessage * message)
#line 680 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::update_cookies"
#line 362 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 362 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 362 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 362 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 691 "mn-gmail-mailbox.c"
{
#line 364 "mn-gmail-mailbox.gob"
	
    const GSList *set_cookie_headers;
    const GSList *l;
    
    set_cookie_headers = soup_message_get_header_list(message->response_headers, "Set-Cookie");
    MN_LIST_FOREACH(l, set_cookie_headers)
      {
	const char *value = l->data;
	char *equal;

	equal = strchr(value, '=');
	if (equal && equal - value > 0)
	  {
	    char *end;
	    char *cookie_name;
	    char *cookie_value;

	    end = strchr(equal, ';');

	    cookie_name = g_strndup(value, equal - value);
	    cookie_value = end
	      ? g_strndup(equal + 1, end - equal - 1)
	      : g_strdup(equal + 1);

	    g_hash_table_insert(selfp->cookies, cookie_name, cookie_value);
	  }
      }
  }}
#line 722 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 393 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_build_cookie (MNGmailMailbox * self)
#line 728 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_cookie"
#line 393 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 393 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (char * )0);
#line 735 "mn-gmail-mailbox.c"
{
#line 395 "mn-gmail-mailbox.gob"
	
    GString *cookie;
    char *str;

    cookie = g_string_new(NULL);
    g_hash_table_foreach(selfp->cookies, self_build_cookie_cb, cookie);

    if (*cookie->str)
      str = g_string_free(cookie, FALSE);
    else
      {
	str = NULL;
	g_string_free(cookie, TRUE);
      }

    return str;
  }}
#line 755 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 413 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_build_cookie_cb (gpointer key, gpointer value, gpointer user_data)
#line 761 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_cookie_cb"
{
#line 415 "mn-gmail-mailbox.gob"
	
    GString *cookie = user_data;

    if (*cookie->str)
      g_string_append(cookie, "; ");

    g_string_append_printf(cookie, "%s=%s", (const char *) key, (const char *) value);
  }}
#line 774 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 424 "mn-gmail-mailbox.gob"
static gboolean 
mn_gmail_mailbox_check (MNGmailMailbox * self, SoupSession * session, GError ** err)
#line 780 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::check"
#line 424 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 424 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (gboolean )0);
#line 424 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (session != NULL, (gboolean )0);
#line 424 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (SOUP_IS_SESSION (session), (gboolean )0);
#line 791 "mn-gmail-mailbox.c"
{
#line 426 "mn-gmail-mailbox.gob"
	
    char *body;
    char *results;
    gboolean status = FALSE;

    g_return_val_if_fail(selfp->logged_in == TRUE, FALSE);

    mn_mailbox_notice(MN_MAILBOX(self), _("searching for unread mail"));

    body = self_get(self, session, "https://gmail.google.com/gmail?search=adv&as_subset=unread&view=tl&start=0", err);
    if (! body)
      return FALSE;

    results = strstr(body, "Search results for: is:unread\",\"");
    if (results)
      {
	GSList *messages = NULL;
	char *p = strstr(results + 32, ",1,");

	while (p)
	  {
	    char *inbox_marker;
	    char *next_p;

	    /*
	     * FIXME: we should parse the list instead of using field
	     * separator matching (this breaks if a separator is
	     * present in a field value).
	     */

	    p += 3;		/* skip ,1, */
	    inbox_marker = strstr(p, ",[\"^i\"");
	    next_p = strstr(p, ",1,");

	    if (inbox_marker && (! next_p || inbox_marker < next_p)) /* msg from inbox */
	      {
		char *date;
		char *sender_email;
		char *sender_name;
		char *subject;

		time_t sent_time = 0;
		char *from = NULL;
		char *expanded_subject = NULL;

		date = self_get_token(p, "\\<b\\>", "\\</b\\>", FALSE, FALSE);
		sender_email = self_get_token(p, "<span id=\\'_user_", "\\'", FALSE, FALSE);
		sender_name = self_get_token(p, "\\'\\>\\<b\\>", "\\</b\\>", FALSE, FALSE);
		subject = self_get_token(p, ";\",\"\\<b\\>", "\\</b\\>", FALSE, FALSE);

		if (date)
		  {
		    sent_time = self_parse_date(date);
		    g_free(date);
		  }
		
		if (sender_name && sender_email)
		  {
		    char *tmp;
		    
		    tmp = g_strdup_printf("%s <%s>", sender_name, sender_email);
		    from = mn_sgml_ref_expand(tmp);
		    g_free(tmp);
		  }
		else if (sender_name)
		  from = mn_sgml_ref_expand(sender_name);
		else if (sender_email)
		  from = mn_sgml_ref_expand(sender_email);
		
		g_free(sender_email);
		g_free(sender_name);
		
		if (subject)
		  {
		    if (strcmp(subject, "(no subject)"))
		      expanded_subject = mn_sgml_ref_expand(subject);
		    g_free(subject);
		  }
	    
		messages = g_slist_append(messages, mn_message_new(MN_MAILBOX(self)->uri,
								   NULL,
								   sent_time,
								   NULL,
								   from,
								   expanded_subject));
		
		g_free(from);
		g_free(expanded_subject);
	      }
	    
	    p = next_p;
	  }

	GDK_THREADS_ENTER();
	mn_mailbox_set_has_new(MN_MAILBOX(self), messages != NULL);
	mn_mailbox_set_messages(MN_MAILBOX(self), messages);
	gdk_flush();
	GDK_THREADS_LEAVE();

	mn_g_object_slist_free(messages);
	status = TRUE;
      }
    else
      g_set_error(err, 0, 0, _("unable to parse Gmail data"));

    g_free(body);

    return status;
  }}
#line 903 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 536 "mn-gmail-mailbox.gob"
static time_t 
mn_gmail_mailbox_parse_date (const char * date)
#line 909 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_date"
#line 536 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (date != NULL, (time_t )0);
#line 914 "mn-gmail-mailbox.c"
{
#line 538 "mn-gmail-mailbox.gob"
	
    time_t t = 0;
#ifdef HAVE_TIMEGM
    time_t now;

    now = mn_time();
    if (now > 0)
      {
	int hours;
	int minutes;
	char ampm[3];
	char month_str[4];
	int day;
	struct tm *tm = NULL;
	
	/* convert now to UTC-7 (Gmail time) */
	now -= (7 * 3600);
	
	if (sscanf(date, "%d:%d%2s", &hours, &minutes, ampm) == 3)
	  {
	    tm = gmtime(&now);
	    tm->tm_hour = hours;
	    if (ampm[0] == 'p')
	      tm->tm_hour += 12;
	    tm->tm_min = minutes;
	    tm->tm_sec = 0;
	  }
	else if (sscanf(date, "%3s %d", month_str, &day) == 2)
	  {
	    const char *months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
	    int i;
	    
	    for (i = 0; i < G_N_ELEMENTS(months); i++)
	      if (! strcmp(month_str, months[i]))
		{
		  tm = gmtime(&now);
		  tm->tm_mon = i;
		  tm->tm_mday = day;
		  tm->tm_hour = 0;
		  tm->tm_min = 0;
		  tm->tm_sec = 0;
		  
		  break;
		}
	  }

	if (tm)
	  t = timegm(tm) + (7 * 3600); /* add 7 hours, because Gmail time is UTC-7 */
      }
#endif /* HAVE_TIMEGM */

    return t;
  }}
#line 970 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
