#!/bin/sh
#
# ent2h.sh - convert one or more SGML entity sets to a C header
# $Id: ent2h.sh,v 1.1 2004/09/20 02:02:54 jylefort Exp $
#
# Copyright (c) 2004 Jean-Yves Lefort <jylefort@brutele.be>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

cat <<EOF
/*
 * mn-sgml-entities.h - SGML entities table
 *
 * Generated automatically by ent2h.sh.
 * Do not edit this file directly.
 */

#ifndef _MN_SGML_ENTITIES_H
#define _MN_SGML_ENTITIES_H

static const struct
{
  const char		*name;
  unsigned long		character;
} entities[] = {
EOF

for f in $@; do
    echo ""
    echo "  /* $f */"
    grep '^<!ENTITY' $f \
	| sed -E 's/^<!ENTITY ([a-zA-Z]+).*"&#([0-9]+);.*$/  { "\1",	\2 },/'
done

cat <<EOF
};

#endif /* _MN_SGML_ENTITIES_H */
EOF
