/* Generated by GOB (v2.0.10) on Wed Oct  6 19:29:53 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#define selfp (self->_priv)

#include "mn-gmail-mailbox.h"

#include "mn-gmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "mn-gmail-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <glib/gi18n-lib.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#include "mn-stock.h"
#include "mn-sgml-ref.h"

#define MESSAGE_IS_ERROR(message) \
  (! SOUP_STATUS_IS_SUCCESSFUL((message)->status_code))

#line 41 "mn-gmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_GMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_GMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_GMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_GMAIL_MAILBOX
#define SELF_CLASS(x) MN_GMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_GMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNGmailMailbox Self;
typedef MNGmailMailboxClass SelfClass;

/* here are local prototypes */
static void mn_gmail_mailbox_init (MNGmailMailbox * o) G_GNUC_UNUSED;
static void mn_gmail_mailbox_class_init (MNGmailMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_gmail_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_gmail_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static void ___4_mn_gmail_mailbox_impl_check (MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_gmail_mailbox_end_check (MNGmailMailbox * self) G_GNUC_UNUSED;
static gboolean mn_gmail_mailbox_get (MNGmailMailbox * self, const char * uri_string, SoupMessageCallbackFn callback) G_GNUC_UNUSED;
static void mn_gmail_mailbox_get_from_uri (MNGmailMailbox * self, SoupUri * uri, SoupMessageCallbackFn callback) G_GNUC_UNUSED;
static void mn_gmail_mailbox_get_from_message (MNGmailMailbox * self, SoupMessage * message, SoupMessageCallbackFn callback) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_request (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_request_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_response (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_response_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_get_token (const char * str, const char * pre, const char * post, gboolean include_pre, gboolean include_post) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login_cb1 (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login_cb2 (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login_cb3 (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_update_cookies (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_build_cookie (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_build_cookie_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_check_internal (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_check_internal_cb (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_parse_unread (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static time_t mn_gmail_mailbox_parse_date (const char * date) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_end_check mn_gmail_mailbox_end_check
#define self_get mn_gmail_mailbox_get
#define self_get_from_uri mn_gmail_mailbox_get_from_uri
#define self_get_from_message mn_gmail_mailbox_get_from_message
#define self_dump_request mn_gmail_mailbox_dump_request
#define self_dump_request_cb mn_gmail_mailbox_dump_request_cb
#define self_dump_response mn_gmail_mailbox_dump_response
#define self_dump_response_cb mn_gmail_mailbox_dump_response_cb
#define self_get_token mn_gmail_mailbox_get_token
#define self_login mn_gmail_mailbox_login
#define self_login_cb1 mn_gmail_mailbox_login_cb1
#define self_login_cb2 mn_gmail_mailbox_login_cb2
#define self_login_cb3 mn_gmail_mailbox_login_cb3
#define self_update_cookies mn_gmail_mailbox_update_cookies
#define self_build_cookie mn_gmail_mailbox_build_cookie
#define self_build_cookie_cb mn_gmail_mailbox_build_cookie_cb
#define self_check_internal mn_gmail_mailbox_check_internal
#define self_check_internal_cb mn_gmail_mailbox_check_internal_cb
#define self_parse_unread mn_gmail_mailbox_parse_unread
#define self_parse_date mn_gmail_mailbox_parse_date
GType
mn_gmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNGmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_gmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNGmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_gmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MAILBOX, "MNGmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNGmailMailbox *)g_object_new(mn_gmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNGmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNGmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNGmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNGmailMailbox *)g_object_new_valist (mn_gmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::finalize"
	MNGmailMailbox *self G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 48 "mn-gmail-mailbox.gob"
	if(self->_priv->cookies) { g_hash_table_destroy ((gpointer) self->_priv->cookies); self->_priv->cookies = NULL; }
#line 159 "mn-gmail-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_gmail_mailbox_init (MNGmailMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,MNGmailMailboxPrivate);
}
#undef __GOB_FUNCTION__
#line 51 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_class_init (MNGmailMailboxClass * class G_GNUC_UNUSED)
#line 173 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(MNGmailMailboxPrivate));
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_MAILBOX);

#line 57 "mn-gmail-mailbox.gob"
	g_object_class->constructor = ___2_mn_gmail_mailbox_constructor;
#line 70 "mn-gmail-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_gmail_mailbox_impl_is;
#line 76 "mn-gmail-mailbox.gob"
	mn_mailbox_class->impl_check = ___4_mn_gmail_mailbox_impl_check;
#line 189 "mn-gmail-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 52 "mn-gmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->stock_id = MN_STOCK_GMAIL;
    MN_MAILBOX_CLASS(class)->format = "Gmail";
  
#line 197 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 57 "mn-gmail-mailbox.gob"
static GObject * 
___2_mn_gmail_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 207 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::constructor"
{
#line 59 "mn-gmail-mailbox.gob"
	
    GObject *object;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    
    if (! soup_ssl_supported)
      mn_mailbox_set_init_error(MN_MAILBOX(object), _("libsoup has not been compiled with SSL/TLS support"));

    return object;
  }}
#line 226 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 70 "mn-gmail-mailbox.gob"
static gboolean 
___3_mn_gmail_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 233 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::impl_is"
#line 70 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 70 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 244 "mn-gmail-mailbox.c"
{
#line 72 "mn-gmail-mailbox.gob"
	
    return MN_URI_IS_GMAIL(uri);
  }}
#line 250 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 76 "mn-gmail-mailbox.gob"
static void 
___4_mn_gmail_mailbox_impl_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 257 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::impl_check"
#line 76 "mn-gmail-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 76 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 267 "mn-gmail-mailbox.c"
{
#line 78 "mn-gmail-mailbox.gob"
	
    Self *self = SELF(mailbox);

    selfp->session = mn_soup_session_new();
    if (selfp->logged_in)
      self_check_internal(self);
    else
      self_login(self);
  }}
#line 279 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 88 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_end_check (MNGmailMailbox * self)
#line 286 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::end_check"
#line 88 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 88 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 293 "mn-gmail-mailbox.c"
{
#line 90 "mn-gmail-mailbox.gob"
	
    g_object_unref(selfp->session);
    mn_mailbox_end_check(MN_MAILBOX(self));
  }}
#line 300 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 95 "mn-gmail-mailbox.gob"
static gboolean 
mn_gmail_mailbox_get (MNGmailMailbox * self, const char * uri_string, SoupMessageCallbackFn callback)
#line 306 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get"
#line 95 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 95 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (gboolean )0);
#line 95 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (uri_string != NULL, (gboolean )0);
#line 95 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (callback != NULL, (gboolean )0);
#line 317 "mn-gmail-mailbox.c"
{
#line 99 "mn-gmail-mailbox.gob"
	
    SoupMessage *message;

    message = soup_message_new(SOUP_METHOD_GET, uri_string);
    if (message)
      {
	self_get_from_message(self, soup_message_new(SOUP_METHOD_GET, uri_string), callback);
	return TRUE;
      }
    else
      {
	mn_mailbox_notice(MN_MAILBOX(self), _("unable to parse URI \"%s\""), uri_string);
	return FALSE;
      }
  }}
#line 335 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 115 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_get_from_uri (MNGmailMailbox * self, SoupUri * uri, SoupMessageCallbackFn callback)
#line 341 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_from_uri"
#line 115 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 115 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 115 "mn-gmail-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 115 "mn-gmail-mailbox.gob"
	g_return_if_fail (callback != NULL);
#line 352 "mn-gmail-mailbox.c"
{
#line 119 "mn-gmail-mailbox.gob"
	
    self_get_from_message(self, soup_message_new_from_uri(SOUP_METHOD_GET, uri), callback);
  }}
#line 358 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 123 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_get_from_message (MNGmailMailbox * self, SoupMessage * message, SoupMessageCallbackFn callback)
#line 364 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_from_message"
#line 123 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 123 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 123 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 123 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 123 "mn-gmail-mailbox.gob"
	g_return_if_fail (callback != NULL);
#line 377 "mn-gmail-mailbox.c"
{
#line 127 "mn-gmail-mailbox.gob"
	
    char *cookie;

    soup_message_add_header(message->request_headers, "User-Agent", "Mail Notification");

    cookie = self_build_cookie(self);
    if (cookie)
      {
	soup_message_add_header(message->request_headers, "Cookie", cookie);
	g_free(cookie);
      }
    
    self_dump_request(self, message);
    soup_session_queue_message(selfp->session, message, callback, self);
    /* message will be unreffed by libsoup after invoking the callback */
  }}
#line 396 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 144 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_request (MNGmailMailbox * self, SoupMessage * message)
#line 402 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_request"
#line 144 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 144 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 144 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 144 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 413 "mn-gmail-mailbox.c"
{
#line 146 "mn-gmail-mailbox.gob"
	
    const SoupUri *suri;
    char *uri;

    suri = soup_message_get_uri(message);
    uri = soup_uri_to_string(suri, FALSE);
    mn_mailbox_notice(MN_MAILBOX(self), "> GET %s", uri);
    g_free(uri);

    soup_message_foreach_header(message->request_headers, self_dump_request_cb, self);
  }}
#line 427 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 158 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_request_cb (gpointer key, gpointer value, gpointer user_data)
#line 433 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_request_cb"
#line 158 "mn-gmail-mailbox.gob"
	g_return_if_fail (key != NULL);
#line 158 "mn-gmail-mailbox.gob"
	g_return_if_fail (value != NULL);
#line 158 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 442 "mn-gmail-mailbox.c"
{
#line 162 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;
    const char *header_name = key;
    const char *header_value = value;

    mn_mailbox_notice(MN_MAILBOX(self), "> %s: %s", header_name, header_value);
  }}
#line 452 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 170 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_response (MNGmailMailbox * self, SoupMessage * message)
#line 458 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_response"
#line 170 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 170 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 170 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 170 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 469 "mn-gmail-mailbox.c"
{
#line 172 "mn-gmail-mailbox.gob"
	
    char *body;
    char **lines;
    int i;
    
    soup_message_foreach_header(message->response_headers, self_dump_response_cb, self);

    body = g_strndup(message->response.body, message->response.length);
    lines = g_strsplit(body, "\n", 0);
    g_free(body);

    for (i = 0; lines[i]; i++)
      mn_mailbox_notice(MN_MAILBOX(self), "< %s", lines[i]);
    g_strfreev(lines);
  }}
#line 487 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 188 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_response_cb (gpointer key, gpointer value, gpointer user_data)
#line 493 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_response_cb"
#line 188 "mn-gmail-mailbox.gob"
	g_return_if_fail (key != NULL);
#line 188 "mn-gmail-mailbox.gob"
	g_return_if_fail (value != NULL);
#line 188 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 502 "mn-gmail-mailbox.c"
{
#line 192 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;
    const char *header_name = key;
    const char *header_value = value;

    mn_mailbox_notice(MN_MAILBOX(self), "< %s: %s", header_name, header_value);
  }}
#line 512 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_gmail_mailbox_get_token:
 * @str: the string to search
 * @pre: the start of the token
 * @post: the end of the token
 * @include_pre: whether to include @pre in the result or not
 * @include_post: whether to include @post in the result or not
 *
 * Gets the first token of @str included between @pre and @post.
 *
 * Return value: a newly allocated string containing the token or
 *               %NULL if not found.
 **/
#line 213 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_get_token (const char * str, const char * pre, const char * post, gboolean include_pre, gboolean include_post)
#line 531 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_token"
#line 213 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 213 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (pre != NULL, (char * )0);
#line 213 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (post != NULL, (char * )0);
#line 540 "mn-gmail-mailbox.c"
{
#line 219 "mn-gmail-mailbox.gob"
	
    char *token = NULL;
    char *pre_loc;
    
    pre_loc = strstr(str, pre);
    if (pre_loc)
      {
	char *after_pre_loc;
	char *post_loc;
	
	after_pre_loc = pre_loc + strlen(pre);
	post_loc = strstr(after_pre_loc, post);
	if (post_loc)
	  {
	    char *start = include_pre ? pre_loc : after_pre_loc;
	    char *end = include_post ? post_loc + strlen(post) : post_loc;
	    
	    token = g_strndup(start, end - start);
	  }
      }
    
    return token;
  }}
#line 566 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 243 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login (MNGmailMailbox * self)
#line 572 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login"
#line 243 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 243 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 579 "mn-gmail-mailbox.c"
{
#line 245 "mn-gmail-mailbox.gob"
	
    char *uri;
    char *escaped_username;
    char *escaped_password;
    gboolean status;

    g_return_if_fail(selfp->logged_in == FALSE);

    if (selfp->cookies)
      g_hash_table_destroy(selfp->cookies);
    selfp->cookies = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	
    mn_mailbox_notice(MN_MAILBOX(self), _("logging in"));

#define EXTRA_CHARS ";/?:@&=+$,"/* taken from RFC 2396 2.2 */
    escaped_username = soup_uri_encode(MN_MAILBOX(self)->uri->username, EXTRA_CHARS);
    escaped_password = soup_uri_encode(MN_MAILBOX(self)->uri->password, EXTRA_CHARS);
    uri = g_strdup_printf("https://www.google.com/accounts/ServiceLoginBoxAuth?service=mail&continue=http://gmail.google.com/gmail&Email=%s&Passwd=%s", escaped_username, escaped_password);
    g_free(escaped_username);
    g_free(escaped_password);

    status = self_get(self, uri, self_login_cb1);
    g_free(uri);

    if (! status)
      {
	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
	self_end_check(self);
      }
  }}
#line 612 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 276 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login_cb1 (SoupMessage * message, gpointer user_data)
#line 618 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login_cb1"
#line 276 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 276 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 276 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 627 "mn-gmail-mailbox.c"
{
#line 279 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->reason_phrase);
    else
      {
	char *body;
	char *next_location;

	self_dump_response(self, message);
	self_update_cookies(self, message);

	body = g_strndup(message->response.body, message->response.length);
 	next_location = self_get_token(body, "top.location = \"", "\"", FALSE, FALSE);
	g_free(body);

	if (next_location)
	  {
	    char *query;	/* pointer into next_location */
	    char *uri;
	    SoupUri *suri;
	    gboolean status;

	    /*
	     * The following kludges work around http://bugzilla.ximian.com/show_bug.cgi?id=66516.
	     * FIXME: remove it and bump libsoup version requirement
	     * when the bug is fixed.
	     */

	    query = strchr(next_location, '?');
	    if (query)
	      *query = 0;

	    uri = g_strdup_printf("https://www.google.com/accounts/%s", next_location);
	    suri = soup_uri_new(uri);

	    if (suri)
	      {
		if (query)
		  {
		    suri->query = g_strdup(query + 1);
		    suri->broken_encoding = TRUE;
		  }

		self_get_from_uri(self, suri, self_login_cb2);
		soup_uri_free(suri);
		
		status = TRUE;
	      }
	    else
	      {
		mn_mailbox_notice(MN_MAILBOX(self), _("unable to parse URI \"%s\""), uri);
		status = FALSE;
	      }

	    g_free(uri);
	    g_free(next_location);
	    
	    if (status)
	      return;
	  }

	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
      }
    
    /* if this point is reached, an error occurred */
    self_end_check(self);
  }}
#line 699 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 349 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login_cb2 (SoupMessage * message, gpointer user_data)
#line 705 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login_cb2"
#line 349 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 349 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 349 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 714 "mn-gmail-mailbox.c"
{
#line 352 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->reason_phrase);
    else
      {
	char *body;
	char *next_location;

	self_dump_response(self, message);
	self_update_cookies(self, message);
	
	body = g_strndup(message->response.body, message->response.length);
	next_location = self_get_token(body, "location.replace(\"", "\")", FALSE, FALSE);
	g_free(body);

	if (next_location)
	  {
	    gboolean status;

	    status = self_get(self, next_location, self_login_cb3);
	    g_free(next_location);

	    if (status)
	      return;
	  }

	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
      }

    /* if this point is reached, an error occurred */
    self_end_check(self);
  }}
#line 751 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 387 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login_cb3 (SoupMessage * message, gpointer user_data)
#line 757 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login_cb3"
#line 387 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 387 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 387 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 766 "mn-gmail-mailbox.c"
{
#line 390 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->reason_phrase);
    else
      {
	char *body;
	char *token;

	self_dump_response(self, message);
	self_update_cookies(self, message);

	body = g_strndup(message->response.body, message->response.length);
	token = strstr(body, "frame name=js src=/gmail");
	
	if (token)
	  {
	    selfp->logged_in = TRUE;
	    mn_mailbox_notice(MN_MAILBOX(self), _("successfully logged in"));
	    self_check_internal(self);
	    
	    return;
	  }

	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
      }

    /* if this point is reached, an error occurred */
    self_end_check(self);
  }}
#line 800 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 422 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_update_cookies (MNGmailMailbox * self, SoupMessage * message)
#line 806 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::update_cookies"
#line 422 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 422 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 422 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 422 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 817 "mn-gmail-mailbox.c"
{
#line 424 "mn-gmail-mailbox.gob"
	
    const GSList *set_cookie_headers;
    const GSList *l;
    
    set_cookie_headers = soup_message_get_header_list(message->response_headers, "Set-Cookie");
    MN_LIST_FOREACH(l, set_cookie_headers)
      {
	const char *value = l->data;
	char *equal;

	equal = strchr(value, '=');
	if (equal && equal - value > 0)
	  {
	    char *end;
	    char *cookie_name;
	    char *cookie_value;

	    end = strchr(equal, ';');

	    cookie_name = g_strndup(value, equal - value);
	    cookie_value = end
	      ? g_strndup(equal + 1, end - equal - 1)
	      : g_strdup(equal + 1);

	    g_hash_table_insert(selfp->cookies, cookie_name, cookie_value);
	  }
      }
  }}
#line 848 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 453 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_build_cookie (MNGmailMailbox * self)
#line 854 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_cookie"
#line 453 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 453 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (char * )0);
#line 861 "mn-gmail-mailbox.c"
{
#line 455 "mn-gmail-mailbox.gob"
	
    GString *cookie;
    char *str;

    cookie = g_string_new(NULL);
    g_hash_table_foreach(selfp->cookies, self_build_cookie_cb, cookie);

    if (*cookie->str)
      str = g_string_free(cookie, FALSE);
    else
      {
	str = NULL;
	g_string_free(cookie, TRUE);
      }

    return str;
  }}
#line 881 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 473 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_build_cookie_cb (gpointer key, gpointer value, gpointer user_data)
#line 887 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_cookie_cb"
{
#line 475 "mn-gmail-mailbox.gob"
	
    GString *cookie = user_data;

    if (*cookie->str)
      g_string_append(cookie, "; ");

    g_string_append_printf(cookie, "%s=%s", (const char *) key, (const char *) value);
  }}
#line 900 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 484 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_check_internal (MNGmailMailbox * self)
#line 906 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::check_internal"
#line 484 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 484 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 913 "mn-gmail-mailbox.c"
{
#line 486 "mn-gmail-mailbox.gob"
	
    mn_mailbox_notice(MN_MAILBOX(self), _("searching for unread mail"));

    if (! self_get(self, "https://gmail.google.com/gmail?search=adv&as_subset=unread&view=tl&start=0", self_check_internal_cb))
      {
	mn_mailbox_set_error(MN_MAILBOX(self), _("unable to search for unread mail"));
	self_end_check(self);
      }
  }}
#line 925 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 496 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_check_internal_cb (SoupMessage * message, gpointer user_data)
#line 931 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::check_internal_cb"
#line 496 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 496 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 938 "mn-gmail-mailbox.c"
{
#line 499 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->reason_phrase);
    else
      {
	self_dump_response(self, message);
	self_parse_unread(self, message);
      }

    self_end_check(self);
  }}
#line 954 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 513 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_parse_unread (MNGmailMailbox * self, SoupMessage * message)
#line 960 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_unread"
#line 513 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 513 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 513 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 513 "mn-gmail-mailbox.gob"
	g_return_if_fail (SOUP_IS_MESSAGE (message));
#line 971 "mn-gmail-mailbox.c"
{
#line 515 "mn-gmail-mailbox.gob"
	
    MNMailbox *mailbox = MN_MAILBOX(self);
    int count = -1;
    GSList *messages = NULL;
    char *body;
    char *results;
  
    body = g_strndup(message->response.body, message->response.length);

    results = strstr(body, "Search results for: is:unread\",\"");
    if (results)
      {
	char *count_str;
	
	count_str = self_get_token(results + 32, ",", ",", FALSE, FALSE);
	if (count_str)
	  {
	    if (mn_str_isnumeric(count_str))
	      count = atoi(count_str);
	    g_free(count_str);
	  }
      }

    if (count != -1)
      {
	char *p = results + 32;

	while (p && (p = strstr(p, ",1,0")))
	  {
	    char *date;
	    char *sender_email;
	    char *sender_name;
	    char *subject;

	    time_t sent_time = 0;
	    char *from = NULL;
	    char *expanded_subject = NULL;
	    
	    date = self_get_token(p, "\\<b\\>", "\\</b\\>", FALSE, FALSE);
	    sender_email = self_get_token(p, "<span id=\\'_user_", "\\'", FALSE, FALSE);
	    sender_name = self_get_token(p, "\\'\\>\\<b\\>", "\\</b\\>", FALSE, FALSE);
	    subject = self_get_token(p, ";\",\"\\<b\\>", "\\</b\\>", FALSE, FALSE);

	    if (date)
	      {
		sent_time = self_parse_date(date);
		g_free(date);
	      }
		
	    if (sender_name && sender_email)
	      {
		char *tmp;

		tmp = g_strdup_printf("%s <%s>", sender_name, sender_email);
		from = mn_sgml_ref_expand(tmp);
		g_free(tmp);
	      }
	    else if (sender_name)
	      from = mn_sgml_ref_expand(sender_name);
	    else if (sender_email)
	      from = mn_sgml_ref_expand(sender_email);

	    g_free(sender_email);
	    g_free(sender_name);

	    if (subject)
	      {
		if (strcmp(subject, "(no subject)"))
		  expanded_subject = mn_sgml_ref_expand(subject);
		g_free(subject);
	      }
	    
	    messages = g_slist_append(messages, mn_message_new(mailbox->uri,
							       NULL,
							       sent_time,
							       NULL,
							       from,
							       expanded_subject));

	    g_free(from);
	    g_free(expanded_subject);

	    p = strstr(p, "[\"^i\"]");
	  }
      }

    g_free(body);

    if (count == -1)
      mn_mailbox_set_error(mailbox, _("unable to parse Gmail data"));
    else
      {
	mn_mailbox_set_has_new(mailbox, count != 0);
	mn_mailbox_set_messages(mailbox, messages);
      }

    mn_g_object_slist_free(messages);
  }}
#line 1072 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 614 "mn-gmail-mailbox.gob"
static time_t 
mn_gmail_mailbox_parse_date (const char * date)
#line 1078 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::parse_date"
#line 614 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (date != NULL, (time_t )0);
#line 1083 "mn-gmail-mailbox.c"
{
#line 616 "mn-gmail-mailbox.gob"
	
    time_t t = 0;
#ifdef HAVE_TIMEGM
    time_t now;

    now = mn_time();
    if (now > 0)
      {
	int hours;
	int minutes;
	char ampm[3];
	char month_str[4];
	int day;
	struct tm *tm = NULL;
	
	/* convert now to UTC-7 (Gmail time) */
	now -= (7 * 3600);
	
	if (sscanf(date, "%d:%d%2s", &hours, &minutes, ampm) == 3)
	  {
	    tm = gmtime(&now);
	    tm->tm_hour = hours;
	    if (ampm[0] == 'p')
	      tm->tm_hour += 12;
	    tm->tm_min = minutes;
	    tm->tm_sec = 0;
	  }
	else if (sscanf(date, "%3s %d", month_str, &day) == 2)
	  {
	    const char *months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
	    int i;
	    
	    for (i = 0; i < G_N_ELEMENTS(months); i++)
	      if (! strcmp(month_str, months[i]))
		{
		  tm = gmtime(&now);
		  tm->tm_mon = i;
		  tm->tm_mday = day;
		  tm->tm_hour = 0;
		  tm->tm_min = 0;
		  tm->tm_sec = 0;
		  
		  break;
		}
	  }

	if (tm)
	  t = timegm(tm) + (7 * 3600); /* add 7 hours, because Gmail time is UTC-7 */
      }
#endif /* HAVE_TIMEGM */

    return t;
  }}
#line 1139 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
