/* Generated by GOB (v2.0.9) on Thu Sep  9 01:42:01 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailboxes.h"

#include "mn-mailboxes-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 22 "mn-mailboxes.gob"

#include "config.h"
#include <glib/gi18n-lib.h>
#include <eel/eel.h>
#include "mn-conf.h"
#include "mn-util.h"
#include "mn-pending-mailbox.h"
#include "mn-unsupported-mailbox.h"

#line 37 "mn-mailboxes.c"
/* self casting macros */
#define SELF(x) MN_MAILBOXES(x)
#define SELF_CONST(x) MN_MAILBOXES_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOXES(x)
#define TYPE_SELF MN_TYPE_MAILBOXES
#define SELF_CLASS(x) MN_MAILBOXES_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOXES_GET_CLASS(x)

/* self typedefs */
typedef MNMailboxes Self;
typedef MNMailboxesClass SelfClass;

/* here are local prototypes */
static void mn_mailboxes_class_init (MNMailboxesClass * c) G_GNUC_UNUSED;
static void mn_mailboxes_list_changed (MNMailboxes * self) G_GNUC_UNUSED;
static void mn_mailboxes_status_changed (MNMailboxes * self) G_GNUC_UNUSED;
static void mn_mailboxes_init (MNMailboxes * self) G_GNUC_UNUSED;
static void mn_mailboxes_notify_delay_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_notify_mailboxes_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_update_from_conf (MNMailboxes * self) G_GNUC_UNUSED;
static void mn_mailboxes_new_cb (MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_notify_has_new_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_notify_error_h (GObject * object, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailboxes_install_timeout (MNMailboxes * self) G_GNUC_UNUSED;
static gboolean mn_mailboxes_timeout_cb (gpointer data) G_GNUC_UNUSED;
static int mn_mailboxes_find_compare_func (gconstpointer a, gconstpointer b) G_GNUC_UNUSED;
static int mn_mailboxes_conf_find_compare_func (gconstpointer a, gconstpointer b) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__list_changed(object,func,data)	mn_mailboxes_connect__list_changed((object),(func),(data))
#define self_connect_after__list_changed(object,func,data)	mn_mailboxes_connect_after__list_changed((object),(func),(data))
#define self_connect_data__list_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__list_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__status_changed(object,func,data)	mn_mailboxes_connect__status_changed((object),(func),(data))
#define self_connect_after__status_changed(object,func,data)	mn_mailboxes_connect_after__status_changed((object),(func),(data))
#define self_connect_data__status_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__status_changed((object),(func),(data),(destroy_data),(flags))

enum {
	LIST_CHANGED_SIGNAL,
	STATUS_CHANGED_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_list_changed mn_mailboxes_list_changed
#define self_status_changed mn_mailboxes_status_changed
#define self_notify_delay_cb mn_mailboxes_notify_delay_cb
#define self_notify_mailboxes_cb mn_mailboxes_notify_mailboxes_cb
#define self_update_from_conf mn_mailboxes_update_from_conf
#define self_new_cb mn_mailboxes_new_cb
#define self_notify_has_new_h mn_mailboxes_notify_has_new_h
#define self_notify_error_h mn_mailboxes_notify_error_h
#define self_install_timeout mn_mailboxes_install_timeout
#define self_timeout_cb mn_mailboxes_timeout_cb
#define self_check mn_mailboxes_check
#define self_get mn_mailboxes_get
#define self_find mn_mailboxes_find
#define self_find_uri mn_mailboxes_find_uri
#define self_find_compare_func mn_mailboxes_find_compare_func
#define self_conf_find mn_mailboxes_conf_find
#define self_conf_find_uri mn_mailboxes_conf_find_uri
#define self_conf_find_compare_func mn_mailboxes_conf_find_compare_func
#define self_has_manual mn_mailboxes_has_manual
#define self_new mn_mailboxes_new
GType
mn_mailboxes_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxesClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailboxes_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailboxes),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailboxes_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailboxes", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailboxes *)g_object_new(mn_mailboxes_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailboxes * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailboxes *
GET_NEW_VARG (const char *first, ...)
{
	MNMailboxes *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailboxes *)g_object_new_valist (mn_mailboxes_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailboxes::finalize"
	MNMailboxes *self  G_GNUC_UNUSED = MN_MAILBOXES (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 34 "mn-mailboxes.gob"
	if(self->_priv->list) { ((*(void (*)(void *))mn_g_object_slist_free)) (self->_priv->list); self->_priv->list = NULL; }
#line 162 "mn-mailboxes.c"
#define timeout_id (self->_priv->timeout_id)
#define VAR timeout_id
	{
#line 36 "mn-mailboxes.gob"
	 if (VAR) g_source_remove(VAR); }
#line 168 "mn-mailboxes.c"
	memset(&timeout_id, 0, sizeof(timeout_id));
#undef VAR
#undef timeout_id
#define delay_notification_id (self->_priv->delay_notification_id)
#define VAR delay_notification_id
	{
#line 38 "mn-mailboxes.gob"
	 eel_gconf_notification_remove(VAR); }
#line 177 "mn-mailboxes.c"
	memset(&delay_notification_id, 0, sizeof(delay_notification_id));
#undef VAR
#undef delay_notification_id
#define mailboxes_notification_id (self->_priv->mailboxes_notification_id)
#define VAR mailboxes_notification_id
	{
#line 40 "mn-mailboxes.gob"
	 eel_gconf_notification_remove(VAR); }
#line 186 "mn-mailboxes.c"
	memset(&mailboxes_notification_id, 0, sizeof(mailboxes_notification_id));
#undef VAR
#undef mailboxes_notification_id
	g_free (priv);
}
#undef __GOB_FUNCTION__

static void 
mn_mailboxes_class_init (MNMailboxesClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailboxes::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[LIST_CHANGED_SIGNAL] =
		g_signal_new ("list_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxesClass, list_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[STATUS_CHANGED_SIGNAL] =
		g_signal_new ("status_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxesClass, status_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

	c->list_changed = NULL;
	c->status_changed = NULL;
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 47 "mn-mailboxes.gob"
static void 
mn_mailboxes_init (MNMailboxes * self G_GNUC_UNUSED)
#line 227 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::init"
	self->_priv = g_new0 (MNMailboxesPrivate, 1);
 {
#line 48 "mn-mailboxes.gob"

    self_update_from_conf(self);
    self_install_timeout(self);

    selfp->delay_notification_id = eel_gconf_notification_add(MN_CONF_DELAY_NAMESPACE, self_notify_delay_cb, self);
    selfp->mailboxes_notification_id = eel_gconf_notification_add(MN_CONF_MAILBOXES, self_notify_mailboxes_cb, self);
  
#line 240 "mn-mailboxes.c"
 }
}
#undef __GOB_FUNCTION__


#line 42 "mn-mailboxes.gob"
static void 
mn_mailboxes_list_changed (MNMailboxes * self)
#line 249 "mn-mailboxes.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 42 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 42 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 261 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[LIST_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 44 "mn-mailboxes.gob"
static void 
mn_mailboxes_status_changed (MNMailboxes * self)
#line 278 "mn-mailboxes.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 44 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 44 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 290 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[STATUS_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}


#line 56 "mn-mailboxes.gob"
static void 
mn_mailboxes_notify_delay_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data)
#line 308 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::notify_delay_cb"
#line 56 "mn-mailboxes.gob"
	g_return_if_fail (user_data != NULL);
#line 313 "mn-mailboxes.c"
{
#line 61 "mn-mailboxes.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_install_timeout(self);
    GDK_THREADS_LEAVE();
  }}
#line 323 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 69 "mn-mailboxes.gob"
static void 
mn_mailboxes_notify_mailboxes_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data)
#line 329 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::notify_mailboxes_cb"
#line 69 "mn-mailboxes.gob"
	g_return_if_fail (user_data != NULL);
#line 334 "mn-mailboxes.c"
{
#line 74 "mn-mailboxes.gob"
	
    Self *self = user_data;

    GDK_THREADS_ENTER();
    self_update_from_conf(self);
    GDK_THREADS_LEAVE();
  }}
#line 344 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 82 "mn-mailboxes.gob"
static void 
mn_mailboxes_update_from_conf (MNMailboxes * self)
#line 350 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::update_from_conf"
#line 82 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 82 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 357 "mn-mailboxes.c"
{
#line 84 "mn-mailboxes.gob"
	
    GSList *gconf_mailboxes;
    GSList *l;
    gboolean changed = FALSE;

    gconf_mailboxes = eel_gconf_get_string_list(MN_CONF_MAILBOXES);

    /* first step: remove old mailboxes */

  loop:
    MN_LIST_FOREACH(l, selfp->list)
      {
	MNMailbox *mailbox = l->data;

	if (! self_conf_find_uri(gconf_mailboxes, mailbox->uri))
	  {
	    selfp->list = mn_g_object_slist_delete_link(selfp->list, l);
	    changed = TRUE;
	    goto loop;
	  }
      }

    /* second step: add new mailboxes */

    MN_LIST_FOREACH(l, gconf_mailboxes)
      {
	const char *text_uri = l->data;
	MNURI *uri;
      
	uri = mn_uri_new(text_uri);
	if (! self_find_uri(self, uri))
	  {
	    MNMailbox *mailbox;

	    mailbox = mn_pending_mailbox_new(uri);
	    selfp->list = g_slist_append(selfp->list, mailbox);
	    changed = TRUE;
	    
	    mn_mailbox_new_async(uri, self_new_cb, self);
	  }
	g_object_unref(uri);
      }

    eel_g_slist_free_deep(gconf_mailboxes);
    if (changed)
      self_list_changed(self);
  }}
#line 407 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 132 "mn-mailboxes.gob"
static void 
mn_mailboxes_new_cb (MNMailbox * mailbox, gpointer user_data)
#line 413 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::new_cb"
#line 132 "mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 132 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 132 "mn-mailboxes.gob"
	g_return_if_fail (user_data != NULL);
#line 422 "mn-mailboxes.c"
{
#line 135 "mn-mailboxes.gob"
	
    Self *self = user_data;
    GSList *elem;

    elem = self_find_uri(self, mailbox->uri);
    if (elem)
      {
	if (MN_IS_UNSUPPORTED_MAILBOX(mailbox))
	  mn_info(_("%s is unsupported: %s"), mn_mailbox_get_name(mailbox), mn_unsupported_mailbox_get_reason(MN_UNSUPPORTED_MAILBOX(mailbox)));
	
	g_signal_connect(G_OBJECT(mailbox), "notify::has-new", G_CALLBACK(self_notify_has_new_h), self);
	g_signal_connect(G_OBJECT(mailbox), "notify::error", G_CALLBACK(self_notify_error_h), self);

	if (MN_MAILBOX_CAN_CHECK(mailbox))
	  mn_mailbox_check(mailbox);

	g_object_unref(elem->data);
	elem->data = mailbox;

	self_list_changed(self);
      }
    else
      g_object_unref(mailbox);
  }}
#line 449 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 160 "mn-mailboxes.gob"
static void 
mn_mailboxes_notify_has_new_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 455 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::notify_has_new_h"
#line 160 "mn-mailboxes.gob"
	g_return_if_fail (object != NULL);
#line 160 "mn-mailboxes.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 160 "mn-mailboxes.gob"
	g_return_if_fail (pspec != NULL);
#line 160 "mn-mailboxes.gob"
	g_return_if_fail (user_data != NULL);
#line 466 "mn-mailboxes.c"
{
#line 164 "mn-mailboxes.gob"
	
    Self *self = user_data;
    MNMailbox *mailbox = MN_MAILBOX(object);
    gboolean has_new;

    has_new = mn_mailbox_get_has_new(mailbox);
    mn_info(has_new ? _("%s has new mail") : _("%s has no new mail"), mn_mailbox_get_name(mailbox));

    self_status_changed(self);
  }}
#line 479 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 175 "mn-mailboxes.gob"
static void 
mn_mailboxes_notify_error_h (GObject * object, GParamSpec * pspec, gpointer user_data)
#line 485 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::notify_error_h"
#line 175 "mn-mailboxes.gob"
	g_return_if_fail (object != NULL);
#line 175 "mn-mailboxes.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 175 "mn-mailboxes.gob"
	g_return_if_fail (pspec != NULL);
#line 175 "mn-mailboxes.gob"
	g_return_if_fail (user_data != NULL);
#line 496 "mn-mailboxes.c"
{
#line 179 "mn-mailboxes.gob"
	
    Self *self = user_data;
    MNMailbox *mailbox = MN_MAILBOX(object);
    const char *error;

    error = mn_mailbox_get_error(mailbox);
    if (error)
      mn_info(_("%s reported an error: %s"), mn_mailbox_get_name(mailbox), error);

    self_status_changed(self);
  }}
#line 510 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 191 "mn-mailboxes.gob"
static void 
mn_mailboxes_install_timeout (MNMailboxes * self)
#line 516 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::install_timeout"
#line 191 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 191 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 523 "mn-mailboxes.c"
{
#line 193 "mn-mailboxes.gob"
	
    int minutes;
    int seconds;

    if (selfp->timeout_id)
      {
	g_source_remove(selfp->timeout_id);
	selfp->timeout_id = 0;
      }
    
    minutes = eel_gconf_get_integer(MN_CONF_DELAY_MINUTES);
    seconds = eel_gconf_get_integer(MN_CONF_DELAY_SECONDS);
    
    if (minutes != 0 || seconds != 0)
      selfp->timeout_id = g_timeout_add(((minutes * 60) + seconds) * 1000,
					self_timeout_cb,
					self);
  }}
#line 544 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 212 "mn-mailboxes.gob"
static gboolean 
mn_mailboxes_timeout_cb (gpointer data)
#line 550 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::timeout_cb"
#line 212 "mn-mailboxes.gob"
	g_return_val_if_fail (data != NULL, (gboolean )0);
#line 555 "mn-mailboxes.c"
{
#line 214 "mn-mailboxes.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();
    self_check(self);
    GDK_THREADS_LEAVE();
    
    return TRUE;		/* continue */
  }}
#line 567 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 224 "mn-mailboxes.gob"
void 
mn_mailboxes_check (MNMailboxes * self)
#line 573 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::check"
#line 224 "mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 224 "mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 580 "mn-mailboxes.c"
{
#line 226 "mn-mailboxes.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->list)
      {
	MNMailbox *mailbox = l->data;

	if (MN_MAILBOX_CAN_CHECK(mailbox) && ! mn_mailbox_get_automatic(mailbox))
	  mn_mailbox_check(mailbox);
      }
  }}
#line 594 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 238 "mn-mailboxes.gob"
GSList * 
mn_mailboxes_get (MNMailboxes * self)
#line 600 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::get"
#line 238 "mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (GSList * )0);
#line 238 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (GSList * )0);
#line 607 "mn-mailboxes.c"
{
#line 240 "mn-mailboxes.gob"
	
    return selfp->list;
  }}
#line 613 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 244 "mn-mailboxes.gob"
GSList * 
mn_mailboxes_find (MNMailboxes * self, const char * text_uri)
#line 619 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::find"
#line 244 "mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (GSList * )0);
#line 244 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (GSList * )0);
#line 244 "mn-mailboxes.gob"
	g_return_val_if_fail (text_uri != NULL, (GSList * )0);
#line 628 "mn-mailboxes.c"
{
#line 246 "mn-mailboxes.gob"
	
    MNURI *uri;
    GSList *elem;

    uri = mn_uri_new(text_uri);
    elem = self_find_uri(self, uri);
    g_object_unref(uri);

    return elem;
  }}
#line 641 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 257 "mn-mailboxes.gob"
GSList * 
mn_mailboxes_find_uri (MNMailboxes * self, MNURI * uri)
#line 647 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::find_uri"
#line 257 "mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (GSList * )0);
#line 257 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (GSList * )0);
#line 257 "mn-mailboxes.gob"
	g_return_val_if_fail (uri != NULL, (GSList * )0);
#line 257 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (GSList * )0);
#line 658 "mn-mailboxes.c"
{
#line 259 "mn-mailboxes.gob"
	
    return g_slist_find_custom(selfp->list, uri, self_find_compare_func);
  }}
#line 664 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 263 "mn-mailboxes.gob"
static int 
mn_mailboxes_find_compare_func (gconstpointer a, gconstpointer b)
#line 670 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::find_compare_func"
{
#line 265 "mn-mailboxes.gob"
	
    MNMailbox *mailbox = (MNMailbox *) a;
    MNURI *uri = (MNURI *) b;

    return strcmp(mailbox->uri->text, uri->text);
  }}
#line 681 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 272 "mn-mailboxes.gob"
GSList * 
mn_mailboxes_conf_find (GSList * gconf_mailboxes, const char * text_uri)
#line 687 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::conf_find"
#line 272 "mn-mailboxes.gob"
	g_return_val_if_fail (text_uri != NULL, (GSList * )0);
#line 692 "mn-mailboxes.c"
{
#line 274 "mn-mailboxes.gob"
	
    MNURI *uri;
    GSList *elem;

    uri = mn_uri_new(text_uri);
    elem = self_conf_find_uri(gconf_mailboxes, uri);
    g_object_unref(uri);

    return elem;
  }}
#line 705 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 285 "mn-mailboxes.gob"
GSList * 
mn_mailboxes_conf_find_uri (GSList * gconf_mailboxes, MNURI * uri)
#line 711 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::conf_find_uri"
#line 285 "mn-mailboxes.gob"
	g_return_val_if_fail (uri != NULL, (GSList * )0);
#line 285 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (GSList * )0);
#line 718 "mn-mailboxes.c"
{
#line 287 "mn-mailboxes.gob"
	
    return g_slist_find_custom(gconf_mailboxes, uri, self_conf_find_compare_func);
  }}
#line 724 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 291 "mn-mailboxes.gob"
static int 
mn_mailboxes_conf_find_compare_func (gconstpointer a, gconstpointer b)
#line 730 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::conf_find_compare_func"
{
#line 293 "mn-mailboxes.gob"
	
    MNURI *uri_a;
    MNURI *uri_b = (MNURI *) b;
    int cmp;

    uri_a = mn_uri_new(a);
    cmp = strcmp(uri_a->text, uri_b->text);
    g_object_unref(uri_a);

    return cmp;
  }}
#line 746 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 305 "mn-mailboxes.gob"
gboolean 
mn_mailboxes_has_manual (MNMailboxes * self)
#line 752 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::has_manual"
#line 305 "mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 305 "mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (gboolean )0);
#line 759 "mn-mailboxes.c"
{
#line 307 "mn-mailboxes.gob"
	
    gboolean has_manual = FALSE;
    GSList *l;
  
    MN_LIST_FOREACH(l, selfp->list)
      {
	MNMailbox *mailbox = l->data;
	
	if (MN_MAILBOX_CAN_CHECK(mailbox) && ! mn_mailbox_get_automatic(mailbox))
	  {
	    has_manual = TRUE;
	    break;
	  }
      }

    return has_manual;
  }}
#line 779 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 325 "mn-mailboxes.gob"
MNMailboxes * 
mn_mailboxes_new (void)
#line 785 "mn-mailboxes.c"
{
#define __GOB_FUNCTION__ "MN:Mailboxes::new"
{
#line 327 "mn-mailboxes.gob"
	
    return MN_MAILBOXES(GET_NEW);
  }}
#line 793 "mn-mailboxes.c"
#undef __GOB_FUNCTION__
