/* Generated by GOB (v2.0.9) on Thu Sep  9 01:42:01 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include "mn-gmail-mailbox.h"

#include "mn-gmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 22 "mn-gmail-mailbox.gob"

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <libsoup/soup.h>
#include "mn-mailbox-private.h"
#include "mn-util.h"
#include "mn-stock.h"
#include "mn-soup.h"

#line 38 "mn-gmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_GMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_GMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_GMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_GMAIL_MAILBOX
#define SELF_CLASS(x) MN_GMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_GMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNGmailMailbox Self;
typedef MNGmailMailboxClass SelfClass;

/* here are local prototypes */
static void mn_gmail_mailbox_init (MNGmailMailbox * o) G_GNUC_UNUSED;
static void mn_gmail_mailbox_class_init (MNGmailMailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_gmail_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___3_mn_gmail_mailbox_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean ___4_mn_gmail_mailbox_impl_is (MNMailbox * dummy, MNURI * uri) G_GNUC_UNUSED;
static void ___5_mn_gmail_mailbox_impl_check (MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_gmail_mailbox_get (MNGmailMailbox * self, const char * uri, SoupCallbackFn callback) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_request (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_request_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_response (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static void mn_gmail_mailbox_dump_response_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_get_token (const char * str, const char * pre, const char * post, gboolean include_pre, gboolean include_post) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login_cb1 (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login_cb2 (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_login_cb3 (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_update_cookies (MNGmailMailbox * self, SoupMessage * message) G_GNUC_UNUSED;
static char * mn_gmail_mailbox_build_cookie (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_build_cookie_cb (gpointer key, gpointer value, gpointer user_data) G_GNUC_UNUSED;
static void mn_gmail_mailbox_check_internal (MNGmailMailbox * self) G_GNUC_UNUSED;
static void mn_gmail_mailbox_check_internal_cb (SoupMessage * message, gpointer user_data) G_GNUC_UNUSED;
static int mn_gmail_mailbox_get_unread_count (SoupMessage * message) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_get mn_gmail_mailbox_get
#define self_dump_request mn_gmail_mailbox_dump_request
#define self_dump_request_cb mn_gmail_mailbox_dump_request_cb
#define self_dump_response mn_gmail_mailbox_dump_response
#define self_dump_response_cb mn_gmail_mailbox_dump_response_cb
#define self_get_token mn_gmail_mailbox_get_token
#define self_login mn_gmail_mailbox_login
#define self_login_cb1 mn_gmail_mailbox_login_cb1
#define self_login_cb2 mn_gmail_mailbox_login_cb2
#define self_login_cb3 mn_gmail_mailbox_login_cb3
#define self_update_cookies mn_gmail_mailbox_update_cookies
#define self_build_cookie mn_gmail_mailbox_build_cookie
#define self_build_cookie_cb mn_gmail_mailbox_build_cookie_cb
#define self_check_internal mn_gmail_mailbox_check_internal
#define self_check_internal_cb mn_gmail_mailbox_check_internal_cb
#define self_get_unread_count mn_gmail_mailbox_get_unread_count
GType
mn_gmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNGmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_gmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNGmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_gmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MAILBOX, "MNGmailMailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNGmailMailbox *)g_object_new(mn_gmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNGmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNGmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNGmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNGmailMailbox *)g_object_new_valist (mn_gmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::finalize"
	MNGmailMailbox *self  G_GNUC_UNUSED = MN_GMAIL_MAILBOX (obj_self);
	gpointer priv = self->_priv;
#line 58 "mn-gmail-mailbox.gob"
	___3_mn_gmail_mailbox_finalize(obj_self);
#line 147 "mn-gmail-mailbox.c"
#line 37 "mn-gmail-mailbox.gob"
	if(self->_priv->cookies) { ((*(void (*)(void *))g_hash_table_destroy)) (self->_priv->cookies); self->_priv->cookies = NULL; }
#line 150 "mn-gmail-mailbox.c"
	g_free (priv);
}
#undef __GOB_FUNCTION__

static void 
mn_gmail_mailbox_init (MNGmailMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::init"
	o->_priv = g_new0 (MNGmailMailboxPrivate, 1);
}
#undef __GOB_FUNCTION__
#line 40 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_class_init (MNGmailMailboxClass * class G_GNUC_UNUSED)
#line 165 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_MAILBOX);

#line 46 "mn-gmail-mailbox.gob"
	g_object_class->constructor = ___2_mn_gmail_mailbox_constructor;
#line 58 "mn-gmail-mailbox.gob"
	g_object_class->finalize = ___finalize;
#line 65 "mn-gmail-mailbox.gob"
	mn_mailbox_class->impl_is = ___4_mn_gmail_mailbox_impl_is;
#line 71 "mn-gmail-mailbox.gob"
	mn_mailbox_class->impl_check = ___5_mn_gmail_mailbox_impl_check;
#line 181 "mn-gmail-mailbox.c"
 {
#line 41 "mn-gmail-mailbox.gob"

    MN_MAILBOX_CLASS(class)->stock_id = MN_STOCK_GMAIL;
    MN_MAILBOX_CLASS(class)->format = "Gmail";
  
#line 188 "mn-gmail-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 46 "mn-gmail-mailbox.gob"
static GObject * 
___2_mn_gmail_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 198 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::constructor"
{
#line 48 "mn-gmail-mailbox.gob"
	
    GObject *object;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    
    mn_soup_use();

    return object;
  }}
#line 216 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 58 "mn-gmail-mailbox.gob"
static void 
___3_mn_gmail_mailbox_finalize (GObject * object G_GNUC_UNUSED)
#line 223 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::finalize"
{
#line 60 "mn-gmail-mailbox.gob"
	
    mn_soup_unuse();
    PARENT_HANDLER(object);
  }}
#line 235 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 65 "mn-gmail-mailbox.gob"
static gboolean 
___4_mn_gmail_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, MNURI * uri)
#line 242 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::impl_is"
#line 65 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 65 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_URI (uri), (gboolean )0);
#line 253 "mn-gmail-mailbox.c"
{
#line 67 "mn-gmail-mailbox.gob"
	
    return MN_URI_IS_GMAIL(uri);
  }}
#line 259 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 71 "mn-gmail-mailbox.gob"
static void 
___5_mn_gmail_mailbox_impl_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 266 "mn-gmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->impl_check) \
		(* MN_MAILBOX_CLASS(parent_class)->impl_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::impl_check"
#line 71 "mn-gmail-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 71 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 276 "mn-gmail-mailbox.c"
{
#line 73 "mn-gmail-mailbox.gob"
	
    Self *self = SELF(mailbox);

    if (selfp->logged_in)
      self_check_internal(self);
    else
      self_login(self);
  }}
#line 287 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 82 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_get (MNGmailMailbox * self, const char * uri, SoupCallbackFn callback)
#line 294 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get"
#line 82 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 82 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 82 "mn-gmail-mailbox.gob"
	g_return_if_fail (uri != NULL);
#line 82 "mn-gmail-mailbox.gob"
	g_return_if_fail (callback != NULL);
#line 305 "mn-gmail-mailbox.c"
{
#line 86 "mn-gmail-mailbox.gob"
	
    SoupContext *context;
    SoupMessage *message;
    char *cookie;

    context = soup_context_get(uri);
    message = soup_message_new(context, SOUP_METHOD_GET);
    soup_context_unref(context);

    soup_message_add_header(message->request_headers, "User-Agent", "Mail Notification");
    cookie = self_build_cookie(self);
    if (cookie)
      {
	soup_message_add_header(message->request_headers, "Cookie", cookie);
	g_free(cookie);
      }
    
    self_dump_request(self, message);
    soup_message_queue(message, callback, self);
    /* message will be freed by libsoup after invoking the callback */
  }}
#line 329 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 108 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_request (MNGmailMailbox * self, SoupMessage * message)
#line 335 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_request"
#line 108 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 108 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 108 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 344 "mn-gmail-mailbox.c"
{
#line 110 "mn-gmail-mailbox.gob"
	
    const SoupUri *suri;
    char *uri;

    suri = soup_context_get_uri(message->context);
    uri = soup_uri_to_string(suri, TRUE);
    mn_mailbox_notice(MN_MAILBOX(self), "> GET %s", uri);
    g_free(uri);

    soup_message_foreach_header(message->request_headers, self_dump_request_cb, self);
  }}
#line 358 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 122 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_request_cb (gpointer key, gpointer value, gpointer user_data)
#line 364 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_request_cb"
#line 122 "mn-gmail-mailbox.gob"
	g_return_if_fail (key != NULL);
#line 122 "mn-gmail-mailbox.gob"
	g_return_if_fail (value != NULL);
#line 122 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 373 "mn-gmail-mailbox.c"
{
#line 126 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;
    const char *header_name = key;
    const char *header_value = value;

    mn_mailbox_notice(MN_MAILBOX(self), "> %s: %s", header_name, header_value);
  }}
#line 383 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 134 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_response (MNGmailMailbox * self, SoupMessage * message)
#line 389 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_response"
#line 134 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 134 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 134 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 398 "mn-gmail-mailbox.c"
{
#line 136 "mn-gmail-mailbox.gob"
	
    char *body;
    char **lines;
    int i;
    
    soup_message_foreach_header(message->response_headers, self_dump_response_cb, self);

    body = g_strndup(message->response.body, message->response.length);
    lines = g_strsplit(body, "\n", 0);
    g_free(body);

    for (i = 0; lines[i]; i++)
      mn_mailbox_notice(MN_MAILBOX(self), "< %s", lines[i]);
    g_strfreev(lines);
  }}
#line 416 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 152 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_dump_response_cb (gpointer key, gpointer value, gpointer user_data)
#line 422 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::dump_response_cb"
#line 152 "mn-gmail-mailbox.gob"
	g_return_if_fail (key != NULL);
#line 152 "mn-gmail-mailbox.gob"
	g_return_if_fail (value != NULL);
#line 152 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 431 "mn-gmail-mailbox.c"
{
#line 156 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;
    const char *header_name = key;
    const char *header_value = value;

    mn_mailbox_notice(MN_MAILBOX(self), "< %s: %s", header_name, header_value);
  }}
#line 441 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

/**
 * mn_gmail_mailbox_get_token:
 * @str: the string to search
 * @pre: the start of the token
 * @post: the end of the token
 * @include_pre: whether to include @pre in the result or not
 * @include_post: whether to include @post in the result or not
 *
 * Gets the first token of @str included between @pre and @post.
 *
 * Return value: a newly allocated string containing the token or
 *               %NULL if not found.
 **/
#line 177 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_get_token (const char * str, const char * pre, const char * post, gboolean include_pre, gboolean include_post)
#line 460 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_token"
#line 177 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (str != NULL, (char * )0);
#line 177 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (pre != NULL, (char * )0);
#line 177 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (post != NULL, (char * )0);
#line 469 "mn-gmail-mailbox.c"
{
#line 183 "mn-gmail-mailbox.gob"
	
    char *token = NULL;
    char *pre_loc;
    
    pre_loc = strstr(str, pre);
    if (pre_loc)
      {
	char *after_pre_loc;
	char *post_loc;
	
	after_pre_loc = pre_loc + strlen(pre);
	post_loc = strstr(after_pre_loc, post);
	if (post_loc)
	  {
	    char *start = include_pre ? pre_loc : after_pre_loc;
	    char *end = include_post ? post_loc + strlen(post) : post_loc;
	    
	    token = g_strndup(start, end - start);
	  }
      }
    
    return token;
  }}
#line 495 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 207 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login (MNGmailMailbox * self)
#line 501 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login"
#line 207 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 207 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 508 "mn-gmail-mailbox.c"
{
#line 209 "mn-gmail-mailbox.gob"
	
    char *uri;
    char *escaped_username;
    char *escaped_password;

    g_return_if_fail(selfp->logged_in == FALSE);

    if (selfp->cookies)
      g_hash_table_destroy(selfp->cookies);
    selfp->cookies = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	
    mn_mailbox_notice(MN_MAILBOX(self), _("logging in"));

    escaped_username = gnome_vfs_escape_string(MN_MAILBOX(self)->uri->username);
    escaped_password = gnome_vfs_escape_string(MN_MAILBOX(self)->uri->password);
    uri = g_strdup_printf("https://www.google.com/accounts/ServiceLoginBoxAuth?service=mail&continue=http://gmail.google.com/gmail&Email=%s&Passwd=%s", escaped_username, escaped_password);
    g_free(escaped_username);
    g_free(escaped_password);

    self_get(self, uri, self_login_cb1);
    g_free(uri);
  }}
#line 533 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 232 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login_cb1 (SoupMessage * message, gpointer user_data)
#line 539 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login_cb1"
#line 232 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 232 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 546 "mn-gmail-mailbox.c"
{
#line 235 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (SOUP_MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->errorphrase);
    else
      {
	char *body;
	char *next_location;

	self_dump_response(self, message);
	self_update_cookies(self, message);

	body = g_strndup(message->response.body, message->response.length);
	next_location = self_get_token(body, "top.location = \"", "\"", FALSE, FALSE);
	g_free(body);

	if (next_location)
	  {
	    char *uri;

	    uri = g_strdup_printf("https://www.google.com/accounts/%s", next_location);
	    g_free(next_location);

	    self_get(self, uri, self_login_cb2);
	    g_free(uri);

	    return;
	  }

	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
      }
    
    /* if this point is reached, an error occurred */
    mn_mailbox_end_check(MN_MAILBOX(self));
  }}
#line 585 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 272 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login_cb2 (SoupMessage * message, gpointer user_data)
#line 591 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login_cb2"
#line 272 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 272 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 598 "mn-gmail-mailbox.c"
{
#line 275 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (SOUP_MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->errorphrase);
    else
      {
	char *body;
	char *next_location;

	self_dump_response(self, message);
	self_update_cookies(self, message);
	
	body = g_strndup(message->response.body, message->response.length);
	next_location = self_get_token(body, "location.replace(\"", "\")", FALSE, FALSE);
	g_free(body);

	if (next_location)
	  {
	    self_get(self, next_location, self_login_cb3);
	    g_free(next_location);
	    return;
	  }

	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
      }

    /* if this point is reached, an error occurred */
    mn_mailbox_end_check(MN_MAILBOX(self));
  }}
#line 631 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 306 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_login_cb3 (SoupMessage * message, gpointer user_data)
#line 637 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::login_cb3"
#line 306 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 306 "mn-gmail-mailbox.gob"
	g_return_if_fail (user_data != NULL);
#line 644 "mn-gmail-mailbox.c"
{
#line 309 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (SOUP_MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->errorphrase);
    else
      {
	char *body;
	char *token;

	self_dump_response(self, message);
	self_update_cookies(self, message);

	body = g_strndup(message->response.body, message->response.length);
	token = strstr(body, "frame name=js src=/gmail");
	
	if (token)
	  {
	    selfp->logged_in = TRUE;
	    mn_mailbox_notice(MN_MAILBOX(self), _("successfully logged in"));
	    self_check_internal(self);
	    
	    return;
	  }

	mn_mailbox_set_error(MN_MAILBOX(self), _("login failed"));
      }

    /* if this point is reached, an error occurred */
    mn_mailbox_end_check(MN_MAILBOX(self));
  }}
#line 678 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 341 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_update_cookies (MNGmailMailbox * self, SoupMessage * message)
#line 684 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::update_cookies"
#line 341 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 341 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 341 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 693 "mn-gmail-mailbox.c"
{
#line 343 "mn-gmail-mailbox.gob"
	
    const GSList *set_cookie_headers;
    const GSList *l;
    
    set_cookie_headers = soup_message_get_header_list(message->response_headers, "Set-Cookie");
    MN_LIST_FOREACH(l, set_cookie_headers)
      {
	const char *value = l->data;
	char *equal;

	equal = strchr(value, '=');
	if (equal && equal - value > 0)
	  {
	    char *end;
	    char *cookie_name;
	    char *cookie_value;

	    end = strchr(equal, ';');

	    cookie_name = g_strndup(value, equal - value);
	    cookie_value = end
	      ? g_strndup(equal + 1, end - equal - 1)
	      : g_strdup(equal + 1);

	    g_hash_table_insert(selfp->cookies, cookie_name, cookie_value);
	  }
      }
  }}
#line 724 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 372 "mn-gmail-mailbox.gob"
static char * 
mn_gmail_mailbox_build_cookie (MNGmailMailbox * self)
#line 730 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_cookie"
#line 372 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 372 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_GMAIL_MAILBOX (self), (char * )0);
#line 737 "mn-gmail-mailbox.c"
{
#line 374 "mn-gmail-mailbox.gob"
	
    GString *cookie;
    char *str;

    cookie = g_string_new(NULL);
    g_hash_table_foreach(selfp->cookies, self_build_cookie_cb, cookie);

    if (*cookie->str)
      str = g_string_free(cookie, FALSE);
    else
      {
	str = NULL;
	g_string_free(cookie, TRUE);
      }

    return str;
  }}
#line 757 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 392 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_build_cookie_cb (gpointer key, gpointer value, gpointer user_data)
#line 763 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::build_cookie_cb"
{
#line 394 "mn-gmail-mailbox.gob"
	
    GString *cookie = user_data;

    if (*cookie->str)
      g_string_append(cookie, "; ");

    g_string_append_printf(cookie, "%s=%s", (const char *) key, (const char *) value);
  }}
#line 776 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 403 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_check_internal (MNGmailMailbox * self)
#line 782 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::check_internal"
#line 403 "mn-gmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 403 "mn-gmail-mailbox.gob"
	g_return_if_fail (MN_IS_GMAIL_MAILBOX (self));
#line 789 "mn-gmail-mailbox.c"
{
#line 405 "mn-gmail-mailbox.gob"
	
    mn_mailbox_notice(MN_MAILBOX(self), _("searching for unread mail"));

    self_get(self, "https://gmail.google.com/gmail?search=adv&as_subset=unread&view=tl&start=0", self_check_internal_cb);
  }}
#line 797 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 411 "mn-gmail-mailbox.gob"
static void 
mn_gmail_mailbox_check_internal_cb (SoupMessage * message, gpointer user_data)
#line 803 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::check_internal_cb"
#line 411 "mn-gmail-mailbox.gob"
	g_return_if_fail (message != NULL);
#line 808 "mn-gmail-mailbox.c"
{
#line 414 "mn-gmail-mailbox.gob"
	
    Self *self = user_data;

    if (SOUP_MESSAGE_IS_ERROR(message))
      mn_mailbox_set_error(MN_MAILBOX(self), _("unable to transfer data: %s"), message->errorphrase);
    else
      {
	int count;
	
	self_dump_response(self, message);

	count = self_get_unread_count(message);
	if (count == -1)
	  mn_mailbox_set_error(MN_MAILBOX(self), _("unable to parse Gmail data"));
	else
	  mn_mailbox_set_has_new(MN_MAILBOX(self), count != 0);
    }

    mn_mailbox_end_check(MN_MAILBOX(self));
  }}
#line 831 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 435 "mn-gmail-mailbox.gob"
static int 
mn_gmail_mailbox_get_unread_count (SoupMessage * message)
#line 837 "mn-gmail-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:Gmail:Mailbox::get_unread_count"
#line 435 "mn-gmail-mailbox.gob"
	g_return_val_if_fail (message != NULL, (int )0);
#line 842 "mn-gmail-mailbox.c"
{
#line 437 "mn-gmail-mailbox.gob"
	
    int count = -1;
    char *body;
    char *results;
  
    body = g_strndup(message->response.body, message->response.length);
    
    results = strstr(body, "Search results for: is:unread\",\"");
    if (results)
      {
	char *count_str;
	
	count_str = self_get_token(results + 32, "\",", "]", FALSE, FALSE);
	if (count_str)
	  {
	    if (mn_str_isnumeric(count_str))
	      count = atoi(count_str);
	    g_free(count_str);
	  }
      }
  
    g_free(body);
    
    return count;
  }}
#line 870 "mn-gmail-mailbox.c"
#undef __GOB_FUNCTION__
