/* Generated by GOB (v2.0.9) on Mon Aug 16 18:13:52 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include "mn-pop3-mailbox.h"

#include "mn-pop3-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "mn-pop3-mailbox.gob"

#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <glib/gi18n-lib.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include "mn-mailbox-private.h"
#include "mn-client-session.h"
#include "mn-util.h"
#include "mn-uri.h"
#include "mn-md5.h"

  enum
  {
    STATE_GREETING = MN_CLIENT_SESSION_INITIAL_STATE,
    STATE_CAPA,
#ifdef WITH_SASL
    STATE_AUTH,
#endif /* WITH_SASL */
    STATE_APOP,
    STATE_USER,
    STATE_PASS,
    STATE_STAT,
    STATE_QUIT
  };

  enum
  {
    RESULT_ERROR_QUIT		= -1, /* server reported an error, quit normally */
    RESULT_ERROR_END		= -2  /* server reported an error, close the connection */
  };

  struct _MNClientSessionPrivate
  {
    MNPOP3Mailbox	*mailbox;
    MNClientSession	*session;
    gboolean		in_list;
    char		*apop_timestamp;
    GSList		*auth_mechanisms;
#ifdef WITH_SASL
    const char		*sasl_mechanism;
#endif /* WITH_SASL */
    gboolean		authenticated;
    gboolean		login_delay_user;
  };

  typedef enum
  {
    RESPONSE_OK,
    RESPONSE_ERR,
    RESPONSE_LIST_ITEM,
    RESPONSE_LIST_END,
    RESPONSE_CONTINUATION
  } ResponseType;

  struct _MNClientSessionResponse
  {
    ResponseType	type;
    char		*arguments;
  };

#line 90 "mn-pop3-mailbox.c"
/* self casting macros */
#define SELF(x) MN_POP3_MAILBOX(x)
#define SELF_CONST(x) MN_POP3_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_POP3_MAILBOX(x)
#define TYPE_SELF MN_TYPE_POP3_MAILBOX
#define SELF_CLASS(x) MN_POP3_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_POP3_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNPOP3Mailbox Self;
typedef MNPOP3MailboxClass SelfClass;

/* here are local prototypes */
static void mn_pop3_mailbox_init (MNPOP3Mailbox * o) G_GNUC_UNUSED;
static void mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_pop3_mailbox_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static gboolean ___3_mn_pop3_mailbox_impl_is (MNMailbox * dummy, const char * uri) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_stat_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_stat_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void ___13_mn_pop3_mailbox_impl_threaded_check (MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static MNClientSessionResponse * mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop) G_GNUC_UNUSED;
static int mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv) G_GNUC_UNUSED;
static void mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_handle_greeting_cb mn_pop3_mailbox_handle_greeting_cb
#define self_enter_capa_cb mn_pop3_mailbox_enter_capa_cb
#define self_handle_capa_cb mn_pop3_mailbox_handle_capa_cb
#define self_enter_auth_cb mn_pop3_mailbox_enter_auth_cb
#define self_handle_auth_cb mn_pop3_mailbox_handle_auth_cb
#define self_enter_apop_cb mn_pop3_mailbox_enter_apop_cb
#define self_handle_apop_cb mn_pop3_mailbox_handle_apop_cb
#define self_enter_user_cb mn_pop3_mailbox_enter_user_cb
#define self_handle_user_cb mn_pop3_mailbox_handle_user_cb
#define self_enter_pass_cb mn_pop3_mailbox_enter_pass_cb
#define self_handle_pass_cb mn_pop3_mailbox_handle_pass_cb
#define self_enter_stat_cb mn_pop3_mailbox_enter_stat_cb
#define self_handle_stat_cb mn_pop3_mailbox_handle_stat_cb
#define self_enter_quit_cb mn_pop3_mailbox_enter_quit_cb
#define self_handle_quit_cb mn_pop3_mailbox_handle_quit_cb
#define self_notice_cb mn_pop3_mailbox_notice_cb
#define self_response_new_cb mn_pop3_mailbox_response_new_cb
#define self_response_free_cb mn_pop3_mailbox_response_free_cb
#define self_custom_handler_cb mn_pop3_mailbox_custom_handler_cb
#define self_session_authenticate mn_pop3_mailbox_session_authenticate
#define self_session_authenticate_fallback mn_pop3_mailbox_session_authenticate_fallback
#define self_session_authenticated mn_pop3_mailbox_session_authenticated
#define self_session_set_error_from_arguments mn_pop3_mailbox_session_set_error_from_arguments
GType
mn_pop3_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNPOP3MailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_pop3_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNPOP3Mailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_pop3_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MAILBOX, "MNPOP3Mailbox", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNPOP3Mailbox *)g_object_new(mn_pop3_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNPOP3Mailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNPOP3Mailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNPOP3Mailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNPOP3Mailbox *)g_object_new_valist (mn_pop3_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::finalize"
	MNPOP3Mailbox *self  G_GNUC_UNUSED = MN_POP3_MAILBOX (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 97 "mn-pop3-mailbox.gob"
	if(self->_priv->hostname) { ((*(void (*)(void *))g_free)) (self->_priv->hostname); self->_priv->hostname = NULL; }
#line 214 "mn-pop3-mailbox.c"
#line 99 "mn-pop3-mailbox.gob"
	if(self->_priv->username) { ((*(void (*)(void *))g_free)) (self->_priv->username); self->_priv->username = NULL; }
#line 217 "mn-pop3-mailbox.c"
#line 100 "mn-pop3-mailbox.gob"
	if(self->_priv->password) { ((*(void (*)(void *))g_free)) (self->_priv->password); self->_priv->password = NULL; }
#line 220 "mn-pop3-mailbox.c"
#line 101 "mn-pop3-mailbox.gob"
	if(self->_priv->authmech) { ((*(void (*)(void *))g_free)) (self->_priv->authmech); self->_priv->authmech = NULL; }
#line 223 "mn-pop3-mailbox.c"
	g_free (priv);
}
#undef __GOB_FUNCTION__

static void 
mn_pop3_mailbox_init (MNPOP3Mailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::init"
	o->_priv = g_new0 (MNPOP3MailboxPrivate, 1);
}
#undef __GOB_FUNCTION__
#line 107 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_class_init (MNPOP3MailboxClass * class G_GNUC_UNUSED)
#line 238 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_MAILBOX);

#line 112 "mn-pop3-mailbox.gob"
	g_object_class->constructor = ___2_mn_pop3_mailbox_constructor;
#line 142 "mn-pop3-mailbox.gob"
	mn_mailbox_class->impl_is = ___3_mn_pop3_mailbox_impl_is;
#line 455 "mn-pop3-mailbox.gob"
	mn_mailbox_class->impl_threaded_check = ___13_mn_pop3_mailbox_impl_threaded_check;
#line 252 "mn-pop3-mailbox.c"
	g_object_class->finalize = ___finalize;
 {
#line 108 "mn-pop3-mailbox.gob"

    MN_MAILBOX_CLASS(class)->format = "POP3";
  
#line 259 "mn-pop3-mailbox.c"
 }
}
#undef __GOB_FUNCTION__



#line 112 "mn-pop3-mailbox.gob"
static GObject * 
___2_mn_pop3_mailbox_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 269 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::constructor"
{
#line 114 "mn-pop3-mailbox.gob"
	
    GObject *object;
    MNMailbox *mailbox;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    mailbox = MN_MAILBOX(object);
    self = SELF(object);

    if (mn_uri_parse_pop(mn_mailbox_get_uri(mailbox),
			 &selfp->ssl,
			 &selfp->username,
			 &selfp->password,
			 &selfp->authmech,
			 &selfp->hostname,
			 &selfp->port))
      {
#ifndef WITH_SSL
	if (selfp->ssl)
	  mn_mailbox_set_init_error(mailbox, _("SSL support has not been compiled in"));
#endif /* WITH_SSL */
      }
    else
      mn_mailbox_set_init_error(mailbox, _("unable to parse POP3 URI"));
  
    return object;
  }}
#line 305 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 142 "mn-pop3-mailbox.gob"
static gboolean 
___3_mn_pop3_mailbox_impl_is (MNMailbox * dummy G_GNUC_UNUSED, const char * uri)
#line 312 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___dummy,___uri) \
	((MN_MAILBOX_CLASS(parent_class)->impl_is)? \
		(* MN_MAILBOX_CLASS(parent_class)->impl_is)(___dummy,___uri): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_is"
#line 142 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 321 "mn-pop3-mailbox.c"
{
#line 144 "mn-pop3-mailbox.gob"
	
    char *scheme;
    gboolean is;

    scheme = gnome_vfs_get_uri_scheme(uri);
    is = scheme && (! strcmp(scheme, "pop") || ! strcmp(scheme, "pops"));
    g_free(scheme);

    return is;
  }}
#line 334 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 155 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_greeting_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 341 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_greeting_cb"
#line 155 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 155 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 155 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 350 "mn-pop3-mailbox.c"
{
#line 159 "mn-pop3-mailbox.gob"
	
    priv->session = session;
    
    switch (response->type)
      {
      case RESPONSE_OK:
	if (response->arguments)
	  {
	    char *timestamp;
	    
	    timestamp = strchr(response->arguments, '<');
	    if (timestamp)
	      {
		char *timestamp_end;
		
		timestamp_end = strchr(timestamp, '>');
		if (timestamp_end)
		  priv->apop_timestamp = g_strndup(timestamp, timestamp_end - timestamp + 1);
	      }
	  }
	return STATE_CAPA;
	
      case RESPONSE_ERR:	return RESULT_ERROR_END;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 379 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 186 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_capa_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 385 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_capa_cb"
#line 186 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 186 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 392 "mn-pop3-mailbox.c"
{
#line 189 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "CAPA");
  }}
#line 398 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 193 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_capa_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 404 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_capa_cb"
#line 193 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 193 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 193 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 413 "mn-pop3-mailbox.c"
{
#line 197 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	priv->in_list = TRUE;
      
	mn_pointers_free(priv->auth_mechanisms);
	priv->auth_mechanisms = NULL;
	priv->mailbox->_priv->login_delay = 0;
	priv->login_delay_user = FALSE;

	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      case RESPONSE_ERR:
      case RESPONSE_LIST_END:
	priv->in_list = FALSE;
	if (priv->authenticated)
	  return STATE_STAT;
	else
	  return self_session_authenticate(priv);
      
      case RESPONSE_LIST_ITEM:
	{
	  char **tokens;
	  gboolean login_delay_error = FALSE;
	  
	  tokens = g_strsplit(response->arguments, " ", 0);
	  if (tokens[0])
	    {
	      if (! strcmp(tokens[0], "SASL"))
		{
		  int i;
		  
		  for (i = 1; tokens[i]; i++)
		    priv->auth_mechanisms = g_slist_append(priv->auth_mechanisms, g_strdup(tokens[i]));
		}
	      else if (! strcmp(tokens[0], "LOGIN-DELAY"))
		{
		  if (tokens[1])
		    {
		      if (mn_str_isnumeric(tokens[1]))
			{
			  priv->mailbox->_priv->login_delay = atoi(tokens[1]);
			  if (tokens[2])
			    {
			      if (! priv->authenticated)
				{
				  if (! strcmp(tokens[2], "USER"))
				    {
				      priv->login_delay_user = TRUE;
				      if (tokens[3])
					login_delay_error = TRUE;
				    }
				  else
				    login_delay_error = TRUE;
				}
			      else
				login_delay_error = TRUE;
			    }
			}
		      else
			login_delay_error = TRUE;
		    }
		  else
		    login_delay_error = TRUE;
		}
	    }
	  g_strfreev(tokens);
	  
	  if (login_delay_error)
	    return mn_client_session_error(session, _("invalid arguments for the LOGIN-DELAY capability"));
	}
	return MN_CLIENT_SESSION_RESULT_CONTINUE;
	
      default:
	priv->in_list = FALSE;
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 495 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 277 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_auth_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 501 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_auth_cb"
#line 277 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 277 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 508 "mn-pop3-mailbox.c"
{
#line 280 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    if (mn_client_session_sasl_authentication_start(priv->session,
						    "pop",
						    priv->auth_mechanisms,
						    priv->mailbox->_priv->authmech,
						    &priv->sasl_mechanism))
      return mn_client_session_write(session, "AUTH %s", priv->sasl_mechanism);
    else
      return self_session_authenticate_fallback(priv, FALSE);
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 525 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 295 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_auth_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 531 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_auth_cb"
#line 295 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 295 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 295 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 540 "mn-pop3-mailbox.c"
{
#line 299 "mn-pop3-mailbox.gob"
	
#ifdef WITH_SASL
    switch (response->type)
      {
      case RESPONSE_OK:
	return mn_client_session_sasl_authentication_done(session)
	  ? self_session_authenticated(priv)
	  : MN_CLIENT_SESSION_RESULT_END;
	
      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, FALSE);
	
      case RESPONSE_CONTINUATION:
	return mn_client_session_sasl_authentication_step(session, response->arguments);
	
      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
#else
    g_return_val_if_reached(0);
#endif /* WITH_SASL */
  }}
#line 565 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 322 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_apop_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 571 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_apop_cb"
#line 322 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 322 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 578 "mn-pop3-mailbox.c"
{
#line 325 "mn-pop3-mailbox.gob"
	
    MNMD5Context context;
    char buf[33];
  
    g_return_val_if_fail(priv->apop_timestamp != NULL, 0);
    
    mn_md5_init(&context);
    mn_md5_update(&context, priv->apop_timestamp, strlen(priv->apop_timestamp));
    mn_md5_update(&context, priv->mailbox->_priv->password, strlen(priv->mailbox->_priv->password));
    mn_md5_end(&context, buf);

    return mn_client_session_write(session, "APOP %s %s", priv->mailbox->_priv->username, buf);
  }}
#line 594 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 339 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_apop_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 600 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_apop_cb"
#line 339 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 339 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 339 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 609 "mn-pop3-mailbox.c"
{
#line 343 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	return self_session_authenticated(priv);
	
      case RESPONSE_ERR:
	return self_session_authenticate_fallback(priv, TRUE);

      default:
	return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 625 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 357 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_user_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 631 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_user_cb"
#line 357 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 357 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 638 "mn-pop3-mailbox.c"
{
#line 360 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "USER %s", priv->mailbox->_priv->username);
  }}
#line 644 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 364 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_user_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 650 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_user_cb"
#line 364 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 364 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 364 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 659 "mn-pop3-mailbox.c"
{
#line 368 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:		return STATE_PASS;
      case RESPONSE_ERR:	return RESULT_ERROR_QUIT;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 670 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 377 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_pass_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 676 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_pass_cb"
#line 377 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 377 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 683 "mn-pop3-mailbox.c"
{
#line 380 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "PASS %s", priv->mailbox->_priv->password);
  }}
#line 689 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 384 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_pass_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 695 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_pass_cb"
#line 384 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 384 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 384 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 704 "mn-pop3-mailbox.c"
{
#line 388 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:		return self_session_authenticated(priv);
      case RESPONSE_ERR:	return RESULT_ERROR_QUIT;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 715 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 397 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_stat_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 721 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_stat_cb"
#line 397 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 397 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 728 "mn-pop3-mailbox.c"
{
#line 400 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "STAT");
  }}
#line 734 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 404 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_stat_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 740 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_stat_cb"
#line 404 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 404 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 404 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 749 "mn-pop3-mailbox.c"
{
#line 408 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:
	{
	  int count;
	  int size;
	  
	  if (response->arguments && sscanf(response->arguments, "%d %d", &count, &size) == 2)
	    {
	      GDK_THREADS_ENTER();
	      mn_mailbox_set_has_new(MN_MAILBOX(priv->mailbox), count != 0);
	      gdk_flush();
	      GDK_THREADS_LEAVE();
	      
	      return STATE_QUIT;
	    }
	  else			/* compliance error */
	    return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
	}
	break;
	
      case RESPONSE_ERR:	return RESULT_ERROR_QUIT;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 778 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 435 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_enter_quit_cb (MNClientSession * session, MNClientSessionPrivate * priv)
#line 784 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::enter_quit_cb"
#line 435 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 435 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 791 "mn-pop3-mailbox.c"
{
#line 438 "mn-pop3-mailbox.gob"
	
    return mn_client_session_write(session, "QUIT");
  }}
#line 797 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 442 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_handle_quit_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 803 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::handle_quit_cb"
#line 442 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 442 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 442 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 812 "mn-pop3-mailbox.c"
{
#line 446 "mn-pop3-mailbox.gob"
	
    switch (response->type)
      {
      case RESPONSE_OK:		return MN_CLIENT_SESSION_RESULT_END;
      case RESPONSE_ERR:	return RESULT_ERROR_END;
      default:			return MN_CLIENT_SESSION_RESULT_BAD_RESPONSE_FOR_CONTEXT;
      }
  }}
#line 823 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 455 "mn-pop3-mailbox.gob"
static void 
___13_mn_pop3_mailbox_impl_threaded_check (MNMailbox * mailbox G_GNUC_UNUSED)
#line 829 "mn-pop3-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->impl_threaded_check) \
		(* MN_MAILBOX_CLASS(parent_class)->impl_threaded_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::impl_threaded_check"
#line 455 "mn-pop3-mailbox.gob"
	g_return_if_fail (mailbox != NULL);
#line 455 "mn-pop3-mailbox.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 839 "mn-pop3-mailbox.c"
{
#line 457 "mn-pop3-mailbox.gob"
	
    Self *self = SELF(mailbox);
    MNClientSessionState states[] = {
      { STATE_GREETING,		NULL,			self_handle_greeting_cb },
      { STATE_CAPA,		self_enter_capa_cb,	self_handle_capa_cb },
#ifdef WITH_SASL
      { STATE_AUTH,		self_enter_auth_cb,	self_handle_auth_cb },
#endif /* WITH_SASL */
      { STATE_APOP,		self_enter_apop_cb,	self_handle_apop_cb },
      { STATE_USER,		self_enter_user_cb,	self_handle_user_cb },
      { STATE_PASS,		self_enter_pass_cb,	self_handle_pass_cb },
      { STATE_STAT,		self_enter_stat_cb,	self_handle_stat_cb },
      { STATE_QUIT,		self_enter_quit_cb,	self_handle_quit_cb },
      
      MN_CLIENT_SESSION_STATES_END
    };
    MNClientSessionCallbacks callbacks = {
      self_notice_cb,
      self_response_new_cb,
      self_response_free_cb,
      self_custom_handler_cb
    };
    MNClientSessionPrivate priv;
    GError *err = NULL;

    if (selfp->login_delay && selfp->authentication_timer)
      {
	double elapsed;

	g_timer_stop(selfp->authentication_timer);
	elapsed = g_timer_elapsed(selfp->authentication_timer, NULL);

	if (elapsed < selfp->login_delay)
	  {
	    int sleeptime;
	    
	    sleeptime = selfp->login_delay - elapsed;
	    mn_mailbox_notice(mailbox,
			      ngettext("honouring LOGIN-DELAY, sleeping for %i second",
				       "honouring LOGIN-DELAY, sleeping for %i seconds",
				       sleeptime),
			      sleeptime);
	    sleep(sleeptime);
	  }
      }
  
    memset(&priv, 0, sizeof(priv));
    priv.mailbox = self;

    if (! mn_client_session_run(states,
				&callbacks,
#ifdef WITH_SSL
				selfp->ssl,
#endif
				selfp->hostname,
				selfp->port,
				selfp->username,
				selfp->password,
				&priv,
				&err))
      {
	GDK_THREADS_ENTER();
	mn_mailbox_set_error(mailbox, "%s", err->message);
	gdk_flush();
	GDK_THREADS_LEAVE();
	g_error_free(err);
      }

    GDK_THREADS_ENTER();
    mn_mailbox_end_check(mailbox);
    gdk_flush();
    GDK_THREADS_LEAVE();

    g_free(priv.apop_timestamp);
    mn_pointers_free(priv.auth_mechanisms);
  }}
#line 918 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 534 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_notice_cb (MNClientSession * session, const char * str, MNClientSessionPrivate * priv)
#line 925 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::notice_cb"
#line 534 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 534 "mn-pop3-mailbox.gob"
	g_return_if_fail (str != NULL);
#line 534 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 934 "mn-pop3-mailbox.c"
{
#line 538 "mn-pop3-mailbox.gob"
	
    mn_mailbox_notice(MN_MAILBOX(priv->mailbox), "%s", str);
  }}
#line 940 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 542 "mn-pop3-mailbox.gob"
static MNClientSessionResponse * 
mn_pop3_mailbox_response_new_cb (MNClientSession * session, const char * input, MNClientSessionPrivate * priv)
#line 946 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_new_cb"
#line 542 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (MNClientSessionResponse * )0);
#line 542 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (input != NULL, (MNClientSessionResponse * )0);
#line 542 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (MNClientSessionResponse * )0);
#line 955 "mn-pop3-mailbox.c"
{
#line 546 "mn-pop3-mailbox.gob"
	
    MNClientSessionResponse *response = NULL;

    if (priv->in_list)
      {
	response = g_new0(MNClientSessionResponse, 1);
	if (! strcmp(input, "."))
	  response->type = RESPONSE_LIST_END;
	else if (! strncmp(input, "..", 2))
	  {
	    response->type = RESPONSE_LIST_ITEM;
	    response->arguments = g_strdup(input + 1); /* skip the initial dot */
	  }
	else
	  {
	    response->type = RESPONSE_LIST_ITEM;
	    response->arguments = g_strdup(input);
	  }
      }
    else
      {
	if (! strncmp(input, "+ ", 2))
	  {
	    response = g_new0(MNClientSessionResponse, 1);
	    response->type = RESPONSE_CONTINUATION;
	    response->arguments = g_strdup(input + 2);
	  }
	else
	  {
	    ResponseType type;
	    int after_status = 0;
	    
	    if (! strncmp(input, "+OK", 3))
	      {
		type = RESPONSE_OK;
		after_status = 3;
	      }
	    else if (! strncmp(input, "-ERR", 4))
	      {
		type = RESPONSE_ERR;
		after_status = 4;
	      }
	    
	    if (after_status)
	      {
		if (input[after_status] == 0 || input[after_status] == ' ')
		  {
		    response = g_new0(MNClientSessionResponse, 1);
		    response->type = type;
		    if (input[after_status] == ' ')
		      response->arguments = g_strdup(input + after_status + 1);
		  }
	      }
	  }
      }
    
    return response;
  }}
#line 1016 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 605 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_response_free_cb (MNClientSession * session, MNClientSessionResponse * response, MNClientSessionPrivate * priv)
#line 1022 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::response_free_cb"
#line 605 "mn-pop3-mailbox.gob"
	g_return_if_fail (session != NULL);
#line 605 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 605 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 1031 "mn-pop3-mailbox.c"
{
#line 609 "mn-pop3-mailbox.gob"
	
    g_free(response->arguments);
    g_free(response);
  }}
#line 1038 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 614 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_custom_handler_cb (MNClientSession * session, MNClientSessionResponse * response, int result, MNClientSessionPrivate * priv)
#line 1044 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::custom_handler_cb"
#line 614 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (session != NULL, (int )0);
#line 614 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (response != NULL, (int )0);
#line 614 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1053 "mn-pop3-mailbox.c"
{
#line 619 "mn-pop3-mailbox.gob"
	
    switch (result)
      {
      case RESULT_ERROR_QUIT:
	self_session_set_error_from_arguments(priv, response);
	return STATE_QUIT;

      case RESULT_ERROR_END:
	self_session_set_error_from_arguments(priv, response);
	return MN_CLIENT_SESSION_RESULT_END;
	
    default:
      g_return_val_if_reached(0);
      }
  }}
#line 1071 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 635 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate (MNClientSessionPrivate * priv)
#line 1077 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate"
#line 635 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1082 "mn-pop3-mailbox.c"
{
#line 637 "mn-pop3-mailbox.gob"
	
    if (priv->mailbox->_priv->authmech)
      {
	if (*priv->mailbox->_priv->authmech != '+')
	  {
#ifdef WITH_SASL
	    return STATE_AUTH;
#else
	    return mn_client_session_error(priv->session, _("a SASL authentication mechanism was selected but SASL support has not been compiled in"));
#endif /* WITH_SASL */
	  }
	else
	  {
	    if (! strcmp(priv->mailbox->_priv->authmech, "+APOP"))
	      return priv->apop_timestamp
		? STATE_APOP
		: mn_client_session_error(priv->session, _("server does not support APOP authentication"));
	    else if (! strcmp(priv->mailbox->_priv->authmech, "+USERPASS"))
	      return STATE_USER;
	    else
	      return mn_client_session_error(priv->session, _("unknown authentication mechanism \"%s\""), priv->mailbox->_priv->authmech);
	  }
      }
    else
      {
#ifdef WITH_SASL
	if (priv->auth_mechanisms)
	  return STATE_AUTH;
#endif /* WITH_SASL */
	if (priv->apop_timestamp)
	  return STATE_APOP;
	else
	  return STATE_USER;
      }
  }}
#line 1120 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 673 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticate_fallback (MNClientSessionPrivate * priv, gboolean tried_apop)
#line 1126 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticate_fallback"
#line 673 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1131 "mn-pop3-mailbox.c"
{
#line 676 "mn-pop3-mailbox.gob"
	
    if (! priv->mailbox->_priv->authmech)
      {
	if (! tried_apop && priv->apop_timestamp)
	  {
	    mn_client_session_notice(priv->session, _("falling back to APOP authentication"));
	    return STATE_APOP;
	  }
	else
	  {
	    mn_client_session_notice(priv->session, _("falling back to USER/PASS authentication"));
	    return STATE_USER;
	  }
      }

    return mn_client_session_error(priv->session, _("authentication failed"));
  }}
#line 1151 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 694 "mn-pop3-mailbox.gob"
static int 
mn_pop3_mailbox_session_authenticated (MNClientSessionPrivate * priv)
#line 1157 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_authenticated"
#line 694 "mn-pop3-mailbox.gob"
	g_return_val_if_fail (priv != NULL, (int )0);
#line 1162 "mn-pop3-mailbox.c"
{
#line 696 "mn-pop3-mailbox.gob"
	
    priv->authenticated = TRUE;
    if (priv->mailbox->_priv->login_delay)
      {
	if (priv->mailbox->_priv->authentication_timer)
	  g_timer_start(priv->mailbox->_priv->authentication_timer);
	else
	  priv->mailbox->_priv->authentication_timer = g_timer_new();
      }
    return priv->login_delay_user ? STATE_CAPA : STATE_STAT;
  }}
#line 1176 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__

#line 708 "mn-pop3-mailbox.gob"
static void 
mn_pop3_mailbox_session_set_error_from_arguments (MNClientSessionPrivate * priv, MNClientSessionResponse * response)
#line 1182 "mn-pop3-mailbox.c"
{
#define __GOB_FUNCTION__ "MN:POP3:Mailbox::session_set_error_from_arguments"
#line 708 "mn-pop3-mailbox.gob"
	g_return_if_fail (priv != NULL);
#line 708 "mn-pop3-mailbox.gob"
	g_return_if_fail (response != NULL);
#line 1189 "mn-pop3-mailbox.c"
{
#line 711 "mn-pop3-mailbox.gob"
	
    if (response->arguments)
      mn_client_session_error(priv->session, "\"%s\"", response->arguments);
    else
      mn_client_session_error(priv->session, _("unknown server error"));
  }}
#line 1198 "mn-pop3-mailbox.c"
#undef __GOB_FUNCTION__
