# Copyright (C) 2006 Jean-Yves Lefort.
#
# This file is part of aml.
# It may be distributed under the same terms as aml.

### command line arguments ####################################################

dnl AML_ARG_COMPILE_WARNINGS
dnl
AC_DEFUN([AML_ARG_COMPILE_WARNINGS],
[AC_ARG_ENABLE(compile-warnings,
AS_HELP_STRING([--enable-compile-warnings=no|yes|error],
[enable compiler warnings [[no]]]),
[case "$enableval" in
	yes|no|error) enable_compile_warnings=$enableval ;;
	*) AC_MSG_ERROR([bad value $enableval for --enable-compile-warnings]) ;;
esac], [enable_compile_warnings=no])

if test $enable_compile_warnings = no; then
	WARN_CFLAGS=
else
	# most flags are specific to GCC
	WARN_CFLAGS="-Wall \
-Wformat-y2k \
-Wformat-security \
-Wno-unused-parameter \
-Wfloat-equal \
-Wdeclaration-after-statement \
-Wendif-labels \
-Wpointer-arith \
-Wcast-align \
-Waggregate-return \
-Wmissing-noreturn \
-Wmissing-format-attribute \
-Wpacked \
-Wredundant-decls \
-Wnested-externs \
-Winline"
	test $enable_compile_warnings = error && WARN_CFLAGS="$WARN_CFLAGS -Werror"
fi

AC_SUBST(WARN_CFLAGS)])

### report ####################################################################

dnl AML_REPORT(NAME, VALUE)
dnl
AC_DEFUN([AML_REPORT], [  m4_format([%-30s %s], [$1], [$2])])

dnl AML_REPORT_ARG(NAME)
dnl
AC_DEFUN([AML_REPORT_ARG], [AML_REPORT([--[$1]], [$translit([$1], -, _)])])

dnl AML_REPORT_ARGS(NAMES)
dnl
AC_DEFUN([AML_REPORT_ARGS], [m4_foreach(name, [$1], [AML_REPORT_ARG(name)
])])
