#! /bin/sh
# check script for Tarlz - Archiver with multimember lzip compression
# Copyright (C) 2013-2018 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
TARLZ="${objdir}"/tarlz
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -f "${TARLZ}" ] || [ ! -x "${TARLZ}" ] ; then
	echo "${TARLZ}: cannot execute"
	exit 1
fi

[ -e "${TARLZ}" ] 2> /dev/null ||
	{
	echo "$0: a POSIX shell is required to run the tests"
	echo "Try bash -c \"$0 $1 $2\""
	exit 1
	}

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp || framework_failure

in="${testdir}"/test.txt
in_lz="${testdir}"/test.txt.lz
in_tar="${testdir}"/test.txt.tar
in_tar_lz="${testdir}"/test.txt.tar.lz
test3="${testdir}"/test3.tar
test3_lz="${testdir}"/test3.tar.lz
test3a_lz="${testdir}"/test3a.tar.lz
bad1="${testdir}"/test3_bad1.tar
bad2="${testdir}"/test3_bad2.tar
bad3="${testdir}"/test3_bad3.tar
bad4="${testdir}"/test3_bad4.tar
bad5="${testdir}"/test3_bad5.tar
bad0_lz="${testdir}"/test3_bad0.tar.lz
bad1_lz="${testdir}"/test3_bad1.tar.lz
bad2_lz="${testdir}"/test3_bad2.tar.lz
bad3_lz="${testdir}"/test3_bad3.tar.lz
bad4_lz="${testdir}"/test3_bad4.tar.lz
bad5_lz="${testdir}"/test3_bad5.tar.lz
eof_lz="${testdir}"/eof.tar.lz
fail=0
test_failed() { fail=1 ; printf " $1" ; [ -z "$2" ] || printf "($2)" ; }

# Description of test files for lziprecover:
# test3_bad1.tar:    byte at offset  259 changed from 't' to '0' (magic)
# test3_bad2.tar:    byte at offset 1283 changed from 't' to '0' (magic)
# test3_bad3.tar:    byte at offset 2559 changed from 0x00 to 0x20 (padding)
# test3_bad4.tar:    combined damage of test3_bad2.tar and test3_bad3.tar
# test3_bad5.tar:    510 zeros + "LZ" prepended to test3.tar (bogus lz header)
# test3_bad0.tar.lz: byte at offset    2 changed from 'I' to 'i' (magic)
# test3_bad1.tar.lz: byte at offset   49 changed from 0x49 to 0x69 (mid stream)
# test3_bad2.tar.lz: byte at offset  149 changed from 0x2D to 0x3D (mid stream)
# test3_bad3.tar.lz: [71-134] --> zeroed (first trailer + seconf header)
# test3_bad4.tar.lz: combined damage of test3_bad1.tar.lz and test3_bad2.tar.lz
# test3_bad5.tar.lz: 510 zeros prepended to test3.tar.lz (header in two blocks)

printf "testing tarlz-%s..." "$2"

"${TARLZ}" -qtf ${in}
[ $? = 2 ] || test_failed $LINENO
"${TARLZ}" -qtf ${in_lz}
[ $? = 2 ] || test_failed $LINENO
"${TARLZ}" -qtf nx_file
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -tf 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qcf out.tar.lz
{ [ $? = 1 ] && [ ! -e out.tar.lz ] ; } || test_failed $LINENO
"${TARLZ}" -rf out.tar.lz
{ [ $? = 0 ] && [ ! -e out.tar.lz ] ; } || test_failed $LINENO
"${TARLZ}" -qrf - ${in}
{ [ $? = 1 ] && [ ! -e - ] ; } || test_failed $LINENO
"${TARLZ}" -qr ${in}
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" --uncompressed -qrf out.tar ${in}
{ [ $? = 1 ] && [ ! -e out.tar ] ; } || test_failed $LINENO
cat ${test3_lz} > test.tar.lz || framework_failure
"${TARLZ}" --uncompressed -qrf test.tar.lz ${in}
{ [ $? = 1 ] && cmp ${test3_lz} test.tar.lz ; } || test_failed $LINENO
rm -f test.tar.lz
cat ${test3} > test.tar || framework_failure
"${TARLZ}" -qrf test.tar ${in}
{ [ $? = 2 ] && cmp ${test3} test.tar ; } || test_failed $LINENO
rm -f test.tar
"${TARLZ}" -qc ${in} nx_file > /dev/null
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qc -C nx_dir ${in}
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qx -C nx_dir ${test3_lz}
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qcr
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qct
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qcx
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qtx
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -qctx
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" --help > /dev/null || test_failed $LINENO
"${TARLZ}" -V > /dev/null || test_failed $LINENO
"${TARLZ}" --bad_option -tf ${test3_lz} 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" -tf 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" --owner=invalid_oner_name -tf ${test3_lz} 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${TARLZ}" --group=invalid_goup_name -tf ${test3_lz} 2> /dev/null
[ $? = 1 ] || test_failed $LINENO

"${TARLZ}" -tf ${eof_lz} || test_failed $LINENO
"${TARLZ}" -xf ${eof_lz} || test_failed $LINENO
"${TARLZ}" -tf ${in_tar_lz} > /dev/null || test_failed $LINENO
"${TARLZ}" -xf ${in_tar_lz} || test_failed $LINENO
cmp ${in} test.txt || test_failed $LINENO
rm -f test.txt
"${TARLZ}" -C nx_dir -tf ${in_tar} > /dev/null || test_failed $LINENO
"${TARLZ}" -xf ${in_tar} || test_failed $LINENO
cmp ${in} test.txt || test_failed $LINENO
rm -f test.txt

rm -f foo bar baz
"${TARLZ}" -xf ${test3_lz}
{ [ $? = 0 ] && [ -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -xf ${test3}
{ [ $? = 0 ] && [ -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${test3a_lz}
{ [ $? = 0 ] && [ -e dir/foo ] && [ -e dir/bar ] && [ -e dir/baz ] ; } ||
	test_failed $LINENO
rm -rf dir

cat ${in} > test.txt || framework_failure
"${TARLZ}" -0 -cf out.tar.lz test.txt || test_failed $LINENO
rm -f test.txt
"${TARLZ}" -xf out.tar.lz || test_failed $LINENO
cmp ${in} test.txt || test_failed $LINENO
cat ${in} > test.txt || framework_failure
"${TARLZ}" --uncompressed -cf out.tar test.txt || test_failed $LINENO
rm -f test.txt
"${TARLZ}" -xf out.tar || test_failed $LINENO
cmp ${in} test.txt || test_failed $LINENO
rm -f test.txt out.tar out.tar.lz

printf "foo" > foo || framework_failure
rm -f bar
printf "baz" > baz || framework_failure
"${TARLZ}" -qcf out.tar.lz foo bar baz
[ $? = 1 ] || test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -xf out.tar.lz || test_failed $LINENO
{ [ $? = 0 ] && [ -e foo ] && [ ! -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf out.tar.lz bar
{ [ $? = 1 ] && [ ! -e foo ] && [ ! -e bar ] && [ ! -e baz ] ; } ||
	test_failed $LINENO
rm -f out.tar.lz

printf "foo" > foo || framework_failure
printf "bar" > bar || framework_failure
printf "baz" > baz || framework_failure
"${TARLZ}" -0 -cf out.tar.lz foo bar baz || test_failed $LINENO
"${TARLZ}" --dsolid -0 -cf aout.tar.lz foo bar baz || test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
rm -f aout.tar.lz
"${TARLZ}" -0 -qcf aout.tar.lz foo/ ./bar ./baz/ || test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
rm -f aout.tar.lz
"${TARLZ}" -0 -cf aout.tar.lz foo || test_failed $LINENO
"${TARLZ}" -0 -rf aout.tar.lz bar baz || test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
rm -f aout.tar.lz
touch aout.tar.lz || framework_failure		# append to empty file
"${TARLZ}" -0 -rf aout.tar.lz foo bar baz || test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
"${TARLZ}" -0 -rf aout.tar.lz || test_failed $LINENO	# append nothing
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
"${TARLZ}" -0 -rf aout.tar.lz -C nx_dir || test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
"${TARLZ}" -0 -qrf aout.tar.lz nx_file
{ [ $? = 1 ] && cmp out.tar.lz aout.tar.lz ; } || test_failed $LINENO
cat ${eof_lz} > aout.tar.lz || framework_failure	# append to empty archive
"${TARLZ}" -0 -rf aout.tar.lz foo bar baz || test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
mv -f foo foo.orig || framework_failure
mv -f bar bar.orig || framework_failure
mv -f baz baz.orig || framework_failure
"${TARLZ}" -xf out.tar.lz foo/ bar// baz/// || test_failed $LINENO
cmp foo foo.orig || test_failed $LINENO
cmp bar bar.orig || test_failed $LINENO
cmp baz baz.orig || test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -xf out.tar.lz || test_failed $LINENO
cmp foo foo.orig || test_failed $LINENO
cmp bar bar.orig || test_failed $LINENO
cmp baz baz.orig || test_failed $LINENO
mkdir dir1 || framework_failure
"${TARLZ}" -C dir1 -xf out.tar.lz || test_failed $LINENO
cmp dir1/foo foo.orig || test_failed $LINENO
cmp dir1/bar bar.orig || test_failed $LINENO
cmp dir1/baz baz.orig || test_failed $LINENO
rm -f aout.tar.lz foo bar baz
"${TARLZ}" -C dir1 -0 -cf aout.tar.lz foo bar baz || test_failed $LINENO
"${TARLZ}" -xf aout.tar.lz || test_failed $LINENO
cmp foo foo.orig || test_failed $LINENO
cmp bar bar.orig || test_failed $LINENO
cmp baz baz.orig || test_failed $LINENO
rm -f aout.tar.lz foo bar baz
"${TARLZ}" -C dir1 -0 -c foo bar baz | "${TARLZ}" -x || test_failed $LINENO
cmp foo foo.orig || test_failed $LINENO
cmp bar bar.orig || test_failed $LINENO
cmp baz baz.orig || test_failed $LINENO
rm -f dir1/foo dir1/bar dir1/baz
"${TARLZ}" -0 -c foo bar baz | "${TARLZ}" -C dir1 -x || test_failed $LINENO
cmp dir1/foo foo.orig || test_failed $LINENO
cmp dir1/bar bar.orig || test_failed $LINENO
cmp dir1/baz baz.orig || test_failed $LINENO
rm -f dir1/foo dir1/bar dir1/baz
"${TARLZ}" -0 -c foo bar baz | "${TARLZ}" -x foo bar baz -C dir1 ||
	test_failed $LINENO
cmp dir1/foo foo.orig || test_failed $LINENO
cmp dir1/bar bar.orig || test_failed $LINENO
cmp dir1/baz baz.orig || test_failed $LINENO
rm -f foo dir1/bar baz
"${TARLZ}" -0 -cf aout.tar.lz -C dir1 foo -C .. bar -C dir1 baz ||
	test_failed $LINENO
cmp out.tar.lz aout.tar.lz || test_failed $LINENO
"${TARLZ}" -0 -cf aout.tar.lz dir1/foo dir1/baz || test_failed $LINENO
rm -rf dir1
"${TARLZ}" -xf aout.tar.lz dir1 || test_failed $LINENO
cmp dir1/foo foo.orig || test_failed $LINENO
cmp dir1/baz baz.orig || test_failed $LINENO
rm -rf dir1
rm -f out.tar.lz aout.tar.lz

# append to solid archive
printf "foo" > foo || framework_failure
printf "bar" > bar || framework_failure
printf "baz" > baz || framework_failure
"${TARLZ}" --solid -0 -cf out.tar.lz foo || test_failed $LINENO
for i in --asolid --dsolid --solid -0 ; do
	"${TARLZ}" $i -qrf out.tar.lz bar baz
	{ [ $? = 2 ] && [ -e out.tar.lz ] ; } || test_failed $LINENO $i
done
rm -f out.tar.lz
for i in --asolid --dsolid -0 ; do
	for j in --asolid --dsolid --solid -0 ; do
		"${TARLZ}" $i -0 -cf out.tar.lz foo ||
			test_failed $LINENO "$i $j"
		"${TARLZ}" $j -0 -rf out.tar.lz bar baz ||
			test_failed $LINENO "$i $j"
		rm -f foo bar baz
		"${TARLZ}" -xf out.tar.lz || test_failed $LINENO "$i $j"
		cmp foo foo.orig || test_failed $LINENO "$i $j"
		cmp bar bar.orig || test_failed $LINENO "$i $j"
		cmp baz baz.orig || test_failed $LINENO "$i $j"
		rm -f out.tar.lz
	done
done
rm -f foo foo.orig bar bar.orig baz baz.orig

mkdir dir1 || framework_failure
"${TARLZ}" -0 -cf out.tar dir1 || test_failed $LINENO
rmdir dir1 || framework_failure
"${TARLZ}" -xf out.tar || test_failed $LINENO
[ -d dir1 ] || test_failed $LINENO
rmdir dir1
mkdir dir1 || framework_failure
"${TARLZ}" --uncompressed -cf out.tar dir1 || test_failed $LINENO
rmdir dir1 || framework_failure
"${TARLZ}" -xf out.tar || test_failed $LINENO
[ -d dir1 ] || test_failed $LINENO
rmdir dir1
rm -f out.tar

name_100=name_100_bytes_long_nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn
path_100=dir1/dir2/dir3/path_100_bytes_long_nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn
path_106=dir1/dir2/dir3/path_longer_than_100_bytes_nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn
mkdir dir1 || framework_failure
mkdir dir1/dir2 || framework_failure
mkdir dir1/dir2/dir3 || framework_failure
cat ${in} > dir1/dir2/dir3/in || framework_failure
ln dir1/dir2/dir3/in dir1/dir2/dir3/${name_100} || framework_failure
ln dir1/dir2/dir3/in ${path_100} || framework_failure
ln dir1/dir2/dir3/in ${path_106} || framework_failure
ln -s in dir1/dir2/dir3/link || framework_failure
ln -s ${name_100} dir1/dir2/dir3/link_100 || framework_failure
"${TARLZ}" -0 -cf out.tar dir1 || test_failed $LINENO
rm -rf dir1
"${TARLZ}" -xf out.tar || test_failed $LINENO
cmp ${in} dir1/dir2/dir3/in || test_failed $LINENO
cmp ${in} dir1/dir2/dir3/${name_100} || test_failed $LINENO
cmp ${in} ${path_100} || test_failed $LINENO
cmp ${in} ${path_106} || test_failed $LINENO
cmp ${in} dir1/dir2/dir3/link || test_failed $LINENO
cmp ${in} dir1/dir2/dir3/link_100 || test_failed $LINENO
rm -f dir1/dir2/dir3/in
cmp ${in} dir1/dir2/dir3/link 2> /dev/null && test_failed $LINENO
cmp ${in} dir1/dir2/dir3/link_100 || test_failed $LINENO
"${TARLZ}" -xf out.tar || test_failed $LINENO
rm -f out.tar
cmp ${in} dir1/dir2/dir3/in || test_failed $LINENO
cmp ${in} dir1/dir2/dir3/link || test_failed $LINENO
"${TARLZ}" -0 -qc ../tmp/dir1 > /dev/null || test_failed $LINENO
rm -rf dir1

"${TARLZ}" -qxf "${testdir}"/dotdot1.tar.lz
{ [ $? = 0 ] && [ ! -e ../dir ] ; } || test_failed $LINENO
"${TARLZ}" -qxf "${testdir}"/dotdot2.tar.lz
{ [ $? = 0 ] && [ ! -e ../dir ] ; } || test_failed $LINENO
"${TARLZ}" -qxf "${testdir}"/dotdot3.tar.lz
{ [ $? = 0 ] && [ ! -e dir ] ; } || test_failed $LINENO
"${TARLZ}" -qxf "${testdir}"/dotdot4.tar.lz
{ [ $? = 0 ] && [ ! -e dir ] ; } || test_failed $LINENO
"${TARLZ}" -qxf "${testdir}"/dotdot5.tar.lz
{ [ $? = 0 ] && [ ! -e dir ] ; } || test_failed $LINENO

printf "\ntesting bad input..."

dd if=${in_tar} of=truncated.tar bs=1000 count=1 2> /dev/null
"${TARLZ}" -qtf truncated.tar > /dev/null
[ $? = 2 ] || test_failed $LINENO
"${TARLZ}" -qxf truncated.tar
{ [ $? = 2 ] && [ ! -e test.txt ] ; } || test_failed $LINENO

rm -f foo bar baz
"${TARLZ}" -qxf ${bad0_lz}
{ [ $? = 2 ] && [ ! -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad1_lz}
{ [ $? = 2 ] && [ ! -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad2_lz}
{ [ $? = 2 ] && [ -e foo ] && [ ! -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad3_lz}
{ [ $? = 2 ] && [ ! -e foo ] && [ ! -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad4_lz}
{ [ $? = 2 ] && [ ! -e foo ] && [ ! -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad5_lz}
{ [ $? = 2 ] && [ -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO

rm -f foo bar baz
"${TARLZ}" -qxf ${bad1}
{ [ $? = 2 ] && [ ! -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad2}
{ [ $? = 2 ] && [ -e foo ] && [ ! -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad3}
{ [ $? = 2 ] && [ -e foo ] && [ -e bar ] && [ ! -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad4}
{ [ $? = 2 ] && [ -e foo ] && [ ! -e bar ] && [ ! -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz
"${TARLZ}" -qxf ${bad5}
{ [ $? = 2 ] && [ -e foo ] && [ -e bar ] && [ -e baz ] ; } ||
	test_failed $LINENO
rm -f foo bar baz

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
