#! /usr/bin/env python
# -*- coding: utf-8 -*-
#######################  L Y X P R E S S O    ##########################
#   This program allows you to post to your WordPress blog right from  #
#   LyX. The input to this script is the LyXHTML output from LyX 2.0.  #
#   This script will connect using xml-rpc.                            #
#                                                                      #
#################     D O C U M E N T A T I O N       ##################
#                                                                      #
#   Please see README.html for LyXPresso documentation.                #
#   Alternatively, see the wiki page at                                #
#   http://wiki.lyx.org/Tools/LyXPresso                                #
#   Please submit any issues or suggestions to the author.             #
#                                                                      #
#####################       A U T H O R       ##########################
#                                                                      #
#   Copyright 2010 Jack Desert                                         #
#   <jackdesert556@gmail.com>                                          #
#   <http://www.LetsEATalready.com>                                    #
#                                                                      #
######################      L I C E N S E     ##########################
#                                                                      #
#   This file is part of LyxBlogger.                                   #
#                                                                      #
#   LyxBlogger is free software: you can redistribute it and/or modify #
#   it under the terms of the GNU General Public License as published  #
#   by the Free Software Foundation, either version 3 of the License,  #
#   or (at your option) any later version.                             #
#                                                                      #
#   LyxBlogger is distributed in the hope that it will be useful,      #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of     #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      #
#   GNU General Public License for more details.                       #
#                                                                      #
#   You should have received a copy of the GNU General Public License  #
#   along with LyxBlogger.  If not, see <http://www.gnu.org/licenses>. #
#                                                                      #
########################################################################

############   U S E R    D E F I N E D    V A R I A B L E S   #########

AUTO_URL = 'http://blogtest.letseatalready.com/xmlrpc.php'
AUTO_USER = 'test'
AUTO_PASSWORD = 'test'
AUTO_LOGIN = True


###########  T H E    R E S T    O F    T H E    C O D E ###############
import sys, os, re
import wordpresslib
from getpass import getpass

from Blog.image import up_images
from Blog.image import get_image_dir
from Blog.term import term_open
from Blog.misc import pr3
from Blog.misc import wait_for_consumer

error_msg = ''
input_file = sys.argv[1]    # Incoming file name
IMAGE_DIR = ''            # Empty until defined otherwise

# Open LyXPresso in a separate terminal
term_open(input_file)

pr3 ('LYXPRESSO')
pr3 ('Welcome to LyXPresso')
pr3 ('Author: Jack Desert')
pr3 ('Website: LetsEATalready.com\n')

IMAGE_DIR = get_image_dir(input_file)

# Define Which Format to Use
pr3 ("FORMAT")
if(input_file[-6:] == '.xhtml'):
    pr3 ("Input file ends in xhtml. Assuming this came from LyXHTML")
    ELYXER_ENGINE = False
elif(input_file[-5:] == '.html'):
    pr3 ("Input file ends in html. Assuming this came from eLyXer")
    ELYXER_ENGINE = True
else:
    error_msg += 'Error: Input file must be of type .xhtml or .html/n/n'
    raise Exception(error_msg)

# Read data from file
f = open(input_file, 'r')
html = f.read()
f.close()

# RECORD TITLE FROM HEADER TO USE AS POST
tit_exp = re.compile('''
    <title>         # Start of the <title> tag
    ..{1,}?         # Anything in the middle (non-greedy)
    </title>        # Closing </title> tag
    ''', re.VERBOSE)    # VERBOSE allows ''' '''
tit_obj = tit_exp.search(html)
# eLyXer uses 'Converted document' as the default title if there is none.
# This code prevents 'Converted document' from being posted in your blog.
TITLE_EXPECTED, TITLE_PROMPT = False, True
pr3 ("\nTITLE")
if(tit_obj):
    TITLE_EXPECTED = True
    full_title_tag = tit_obj.group()
    blog_title = full_title_tag[7:-8]   # Strip tags off
    if (blog_title != 'Converted document'):
        TITLE_PROMPT = False
if(TITLE_PROMPT):
    pr3 ('No title found in document.')
    pr3 ('Please enter a title now')
    blog_title = sys.stdin.readline().replace('\n', '')
pr3 ('Using title: ' + blog_title)


# REMOVING TITLE FROM BODY
# Typical body title using ENGINE_INTERNAL:
#   <h1 class="title"><a id='magicparlabel-309' />
#   Example Article Title</h1>
#   <h1 class="title">
# Typical body title using ELYXER_ENGINE using optional sizing:
#   <h1 class="title">
#   <span class="footnotesize">Hi Brian</span>
#
#   </h1>
exp = re.compile('''
    <h1\                   # Beginning of tag with space
    class="title">         # The rest of the tag
    ..{1,}?                # Anything (non-greedy)
    </h1>                  # Closing tag
    ''', re.VERBOSE | re.DOTALL)                 # .. can include linebreaks
bt_obj = exp.search(html)
if(bt_obj):
    entire_bt_tag = bt_obj.group()
    html = html.replace(entire_bt_tag, '')
elif (TITLE_EXPECTED):
    pr3 ('\nWARNING! The title of your entry may appear twice. Please notify the author at jackdesert556@gmail.com to have this bug squashed.\n\n Press Enter to continue uploading.')
    sys.stdin.readline()
    # What this really means is an opening title tag was found, but
    # no title tag was found in the body.

# Eliminate everything outside the <body></body> tags
START_TAG = '<body>'
END_TAG = '</body>'
if (START_TAG in html):
    html = html.partition(START_TAG)[2]
html = html.partition(END_TAG)[0]

# Reinvoke <code> and </code> tags from their escape sequence counterparts
html = html.replace('&lt;code&gt;', '<code>')
html = html.replace('&lt;/code&gt;', '</code>')

# Remove Arrows from footnotes and margin notes
html = html.replace('[→', '[')
html = html.replace('→]', ']')


# Strip off cut material using the flag '#! CUT MATERIAL'
CUT_FLAG = '#! CUT MATERIAL'
pr3 ("\nCUT_FLAG")
pr3 ("Anything placed after the CUT_FLAG in your document will not be uploaded.")
pr3 ("This is helpful for keeping notes that you might put back in a later draft.")
if(ELYXER_ENGINE):
    # ELYXER may put a <span> tag in if you change the size
    exp = re.compile('<div class="\D{1,}?">\n(<span class="\D{1,}?">){0,1}?' + CUT_FLAG)
else:
    # INTERNAL uses a magicparlabel-num
    exp = re.compile('<div class="\D{1,}?"><a id=\'magicparlabel-\d{1,}\' />\n' + CUT_FLAG)

srch_obj = exp.search(html)
if(srch_obj):
    start_index = srch_obj.start()
    # pr3('this expression found at location: ' + str(start_index))
    html = html[0:start_index]
    pr3 ('The Following String was found in your document and was ')
    pr3 ('successfully used as a CUT_FLAG: ')
    pr3 (CUT_FLAG + '\n')
else:
    pr3 ("Place the contents of the following line at the beginning of")
    pr3 (" a paragraph to use it as a CUT_FLAG: ")
    pr3 (CUT_FLAG + '\n')




if (AUTO_LOGIN == True):
    display_url = AUTO_URL[0:-11]
    pr3 ("Publish this document to " + display_url + "?   Y (N)")
    a = sys.stdin.readline()
    if (a == 'Y\n' or a == 'y\n'):
        wordpress_url = AUTO_URL
        user = AUTO_USER
        password = AUTO_PASSWORD
    else:
        AUTO_LOGIN = False

if (AUTO_LOGIN ==False):
    pr3 ("URL")
    pr3("Please enter your WordPress URL")
    pr3("Example: cool_site.wordpress.com")
    wordpress_url = sys.stdin.readline()
    wordpress_url = wordpress_url.replace('http://', '')
    wordpress_url = wordpress_url.replace('www.', '')
    wordpress_url = wordpress_url.replace('\n', '')
    wordpress_url = 'http://' + wordpress_url + '/xmlrpc.php'
    pr3 ("The page we'll be talking is " + wordpress_url)
    pr3 ("\nUSERNAME")
    pr3("Please enter your WordPress username")
    user = sys.stdin.readline().replace('\n', '')
    pr3("Username is " + user + '.')
    pr3 ("\nPASSWORD")
    pr3("Please enter your WordPress password")
    password = getpass()
    pr3 ("Thank you.")



# prepare client object
wp = wordpresslib.WordPressClient(wordpress_url, user, password)

# select blog id
wp.selectBlog(0)


pr3 ('\nCATEGORY')
pr3 ('Retrieving Categories From Server')
cat_list = wp.getCategoryList()
cat_counter = 1
for cat in cat_list:
    pr3 (str(cat_counter) + '.  ' + cat.name)
    cat_counter += 1
cat_id = None
while (1):
    try:
        pr3 ('Please enter the NUMBER next to the category for this post')
        cat_response = sys.stdin.readline().replace('\n', '')
        cat = int(cat_response)
        cat_id = cat_list[cat-1].id
        pr3 ('Category Selected: ' + cat_list[cat-1].name + '\n')
        break
    except:
        pr3 ("Category Response Not Understood.\n")



html = up_images(html, wp, ELYXER_ENGINE, IMAGE_DIR)

# create post object
post = wordpresslib.WordPressPost()
post.title = blog_title
post.description = html

# I have no idea why this takes a tuple (something, )
post.categories = (cat_id,)
# publish post
pr3 ('\nWORDS\nNow We\'ll Upload Your Thoughts')
filesize = str(os.path.getsize(input_file) / 1024) + ' kB'
pr3("Uploading xhtml: " + input_file + '.  Size: ' + filesize )
idNewPost = wp.newPost(post, True)


pr3 ('\nSUCCESS!')
pr3 ('You just published your document to ' + wordpress_url[7:-11])
pr3 ('Thank you for using LyXPresso.\n\n')
wait_for_consumer()


