/* Generated by GOB (v2.0.11)   (do not edit directly) */



/***************************************************************************
                         lum-engine.gob  -  Lumiere Engine 
                             -------------------
    begin                : Tue dec 2 02:08:47 BST 2003
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.20 $
 * $Date: 2005/04/13 01:26:42 $
 *
 */

#include <glib.h>
#include <glib-object.h>
#ifndef __LUM_ENGINE_H__
#define __LUM_ENGINE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



#include "lum-player-info.h"
#include "lum-toggle-action.h"
#include <gtk/gtk.h>


typedef enum {
	TARGET_STRING,
	TARGET_URL,
	TARGET_STRING_UTF8
} LumEngineTarget;
#define LUM_TYPE_ENGINE_TARGET lum_engine_target_get_type()
GType lum_engine_target_get_type (void);


typedef enum {
	PREV_NONE,
	PREV_VIDEO,
	PREV_VFX,
	PREV_AUDIO
} LumEnginePrev;
#define LUM_TYPE_ENGINE_PREV lum_engine_prev_get_type()
GType lum_engine_prev_get_type (void);


typedef enum {
	LUM_EVENT_STATUS_CHANGED,
	LUM_EVENT_PLAY_NOW,
	LUM_EVENT_PLAYLIST_END,
	LUM_EVENT_NEW_ENGINE,
	LUM_EVENT_CLOSE_ENGINE
} LumEngineEvent;
#define LUM_TYPE_ENGINE_EVENT lum_engine_event_get_type()
GType lum_engine_event_get_type (void);


/*
 * Type checking and casting macros
 */
#define LUM_TYPE_ENGINE	(lum_engine_get_type())
#define LUM_ENGINE(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_engine_get_type(), LumEngine)
#define LUM_ENGINE_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_engine_get_type(), LumEngine const)
#define LUM_ENGINE_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), lum_engine_get_type(), LumEngineClass)
#define LUM_IS_ENGINE(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), lum_engine_get_type ())

#define LUM_ENGINE_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), lum_engine_get_type(), LumEngineClass)

/* Private structure type */
typedef struct _LumEnginePrivate LumEnginePrivate;

/*
 * Main object structure
 */
#ifndef __TYPEDEF_LUM_ENGINE__
#define __TYPEDEF_LUM_ENGINE__
typedef struct _LumEngine LumEngine;
#endif
struct _LumEngine {
	GObject __parent__;
	/*< public >*/
	LumToggleAction * repeat_action;
	LumToggleAction * playlist_visible_action;
	LumToggleAction * vidwin_visible_action;
	LumToggleAction * skin_visible_action;
	/*< private >*/
	LumEnginePrivate *_priv;
};

/*
 * Class definition
 */
typedef struct _LumEngineClass LumEngineClass;
struct _LumEngineClass {
	GObjectClass __parent__;
};


/*
 * Public methods
 */
GType	lum_engine_get_type	(void);
GtkWindow * 	lum_engine_get_skin	(LumEngine * self);
void 	lum_engine_load_uri	(LumEngine * self,
					const gchar * uri);
void 	lum_engine_enqueue	(LumEngine * self,
					const gchar * uri);
void 	lum_engine_iconify	(LumEngine * self);
void 	lum_engine_set_volume	(LumEngine * self,
					gdouble volume);
void 	lum_engine_dec_vol	(LumEngine * self);
void 	lum_engine_inc_vol	(LumEngine * self);
void 	lum_engine_mute	(LumEngine * self);
void 	lum_engine_show_info	(LumEngine * self);
void 	lum_engine_do_popup	(LumEngine * self,
					GdkEventButton * event);
void 	lum_engine_switch_timer_mode	(LumEngine * self);
gboolean 	lum_engine_can_seek	(LumEngine * self);
void 	lum_engine_fwd10	(LumEngine * self);
void 	lum_engine_back10	(LumEngine * self);
void 	lum_engine_close	(LumEngine * self);
void 	lum_engine_prev	(LumEngine * self);
void 	lum_engine_next	(LumEngine * self);
void 	lum_engine_play	(LumEngine * self);
void 	lum_engine_pause	(LumEngine * self);
void 	lum_engine_stop	(LumEngine const * self);
gboolean 	lum_engine_get_shuffle	(LumEngine const * self);
void 	lum_engine_set_shuffle	(LumEngine const * self,
					gboolean shuffle);
GList * 	lum_engine_get_list	(LumEngine * self);
void 	lum_engine_play_now	(LumEngine * self,
					LumPlayerInfo * info,
					const gchar * uri);
void 	lum_engine_set_position	(LumEngine * self,
					gdouble position);
void 	lum_engine_show_fileselector	(LumEngine * self);
void 	lum_engine_show_directoryselector	(LumEngine * self);
void 	lum_engine_open_dvd	(LumEngine * self);
void 	lum_engine_open_cdda	(LumEngine * self);
void 	lum_engine_drag_received	(LumEngine * self,
					GdkDragContext * context,
					GtkSelectionData * data,
					guint time);
void 	lum_engine_opendir_activate_cb	(GtkMenuItem * button,
					LumEngine * self);
gboolean 	lum_engine_playlist_delete_cb	(GtkWidget * widget,
					GdkEvent * event,
					gpointer user_data);

/*
 * Argument wrapping macros
 */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define LUM_ENGINE_PROP_REPEAT(arg)    	"repeat", __extension__ ({gboolean z = (arg); z;})
#define LUM_ENGINE_GET_PROP_REPEAT(arg)	"repeat", __extension__ ({gboolean *z = (arg); z;})
#define LUM_ENGINE_PROP_PLAYLIST_VISIBLE(arg)    	"playlist_visible", __extension__ ({gboolean z = (arg); z;})
#define LUM_ENGINE_GET_PROP_PLAYLIST_VISIBLE(arg)	"playlist_visible", __extension__ ({gboolean *z = (arg); z;})
#define LUM_ENGINE_PROP_VIDWIN_VISIBLE(arg)    	"vidwin_visible", __extension__ ({gboolean z = (arg); z;})
#define LUM_ENGINE_GET_PROP_VIDWIN_VISIBLE(arg)	"vidwin_visible", __extension__ ({gboolean *z = (arg); z;})
#define LUM_ENGINE_PROP_SKIN_VISIBLE(arg)    	"skin_visible", __extension__ ({gboolean z = (arg); z;})
#define LUM_ENGINE_GET_PROP_SKIN_VISIBLE(arg)	"skin_visible", __extension__ ({gboolean *z = (arg); z;})
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define LUM_ENGINE_PROP_REPEAT(arg)    	"repeat",(gboolean )(arg)
#define LUM_ENGINE_GET_PROP_REPEAT(arg)	"repeat",(gboolean *)(arg)
#define LUM_ENGINE_PROP_PLAYLIST_VISIBLE(arg)    	"playlist_visible",(gboolean )(arg)
#define LUM_ENGINE_GET_PROP_PLAYLIST_VISIBLE(arg)	"playlist_visible",(gboolean *)(arg)
#define LUM_ENGINE_PROP_VIDWIN_VISIBLE(arg)    	"vidwin_visible",(gboolean )(arg)
#define LUM_ENGINE_GET_PROP_VIDWIN_VISIBLE(arg)	"vidwin_visible",(gboolean *)(arg)
#define LUM_ENGINE_PROP_SKIN_VISIBLE(arg)    	"skin_visible",(gboolean )(arg)
#define LUM_ENGINE_GET_PROP_SKIN_VISIBLE(arg)	"skin_visible",(gboolean *)(arg)
#endif /* __GNUC__ && !__STRICT_ANSI__ */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
