/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:21 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-control.gob"

/***************************************************************************
                          lum-control.gob  -  Lumiere Bonobo Control
                             -------------------
    begin                : jeu jun  6 02:08:47 BST 2002
    copyright            : (C) 2002 by Stphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#line 27 "lum-control.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-control.h"

#include "lum-control-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 58 "lum-control.gob"

/* debug printout macros */	
#ifndef NDEBUG
#define __d	g_message(__GOB_FUNCTION__);
#define __ds(s)	g_message(__GOB_FUNCTION__ s);
#else
#define __d
#define __ds(s)
#endif

#line 59 "lum-control.c"
/* self casting macros */
#define SELF(x) LUM_CONTROL(x)
#define SELF_CONST(x) LUM_CONTROL_CONST(x)
#define IS_SELF(x) LUM_IS_CONTROL(x)
#define TYPE_SELF LUM_TYPE_CONTROL
#define SELF_CLASS(x) LUM_CONTROL_CLASS(x)

#define SELF_GET_CLASS(x) LUM_CONTROL_GET_CLASS(x)

/* self typedefs */
typedef LumControl Self;
typedef LumControlClass SelfClass;

/* here are local prototypes */
static void lum_control_class_init (LumControlClass * c) G_GNUC_UNUSED;
static void lum_control_init (LumControl * self) G_GNUC_UNUSED;
static void ___3_lum_control_dispose (GObject * object) G_GNUC_UNUSED;
static void ___4_lum_control_activate (BonoboControl * control, gboolean arg) G_GNUC_UNUSED;
static void ___5_lum_control_disconnected (BonoboControl * control) G_GNUC_UNUSED;
static gint lum_control_load_from_file (BonoboPersistFile * pf, const CORBA_char * text_uri, CORBA_Environment * ev, Self * self) G_GNUC_UNUSED;
static void lum_control_load_from_stream (BonoboPersistStream * ps, const Bonobo_Stream stream, Bonobo_Persist_ContentType type, void * closure, CORBA_Environment * ev) G_GNUC_UNUSED;
static gpointer lum_control_play_start (gpointer data) G_GNUC_UNUSED;
static BonoboObject * lum_control_factory (BonoboGenericFactory * this, const char * oaf_iid, void * data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboControlClass *parent_class = NULL;

/* Short form macros */
#define self_get_type lum_control_get_type
#define self_factory_new lum_control_factory_new
#define self_load_from_file lum_control_load_from_file
#define self_load_from_stream lum_control_load_from_stream
#define self_play_start lum_control_play_start
#define self_factory lum_control_factory
/* a macro for creating a new object of our type */
#define GET_NEW ((LumControl *)g_object_new(lum_control_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumControl * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumControl *
GET_NEW_VARG (const char *first, ...)
{
	LumControl *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumControl *)g_object_new_valist (lum_control_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Control::dispose"
	LumControl *self G_GNUC_UNUSED = LUM_CONTROL (obj_self);
#line 148 "lum-control.gob"
	___3_lum_control_dispose(obj_self);
#line 119 "lum-control.c"
#line 73 "lum-control.gob"
	if(self->_priv->info) { g_object_unref ((gpointer) self->_priv->info); self->_priv->info = NULL; }
#line 122 "lum-control.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Control::finalize"
	LumControl *self G_GNUC_UNUSED = LUM_CONTROL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 72 "lum-control.gob"
	if(self->_priv->uri) { g_free ((gpointer) self->_priv->uri); self->_priv->uri = NULL; }
#line 137 "lum-control.c"
#line 75 "lum-control.gob"
	if(self->_priv->tmpfile) { g_free ((gpointer) self->_priv->tmpfile); self->_priv->tmpfile = NULL; }
#line 140 "lum-control.c"
}
#undef __GOB_FUNCTION__

static void 
lum_control_class_init (LumControlClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Control::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	BonoboControlClass *bonobo_control_class = (BonoboControlClass *)c;

	g_type_class_add_private(c,sizeof(LumControlPrivate));

	parent_class = g_type_class_ref (BONOBO_TYPE_CONTROL);

#line 148 "lum-control.gob"
	g_object_class->dispose = ___dispose;
#line 156 "lum-control.gob"
	bonobo_control_class->activate = ___4_lum_control_activate;
#line 166 "lum-control.gob"
	bonobo_control_class->disconnected = ___5_lum_control_disconnected;
#line 161 "lum-control.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 103 "lum-control.gob"
static void 
lum_control_init (LumControl * self G_GNUC_UNUSED)
#line 168 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumControlPrivate);
#line 58 "lum-control.gob"
	self->_priv->player = NULL;
#line 174 "lum-control.c"
#line 58 "lum-control.gob"
	self->_priv->player_type = PLAYER_XINE;
#line 177 "lum-control.c"
#line 58 "lum-control.gob"
	self->_priv->uri = NULL;
#line 180 "lum-control.c"
#line 58 "lum-control.gob"
	self->_priv->info = NULL;
#line 183 "lum-control.c"
#line 58 "lum-control.gob"
	self->_priv->tmpfile = NULL;
#line 186 "lum-control.c"
 {
#line 103 "lum-control.gob"

		BonoboPersistFile *pfile;
		BonoboPersistStream* pstream;
		if(lum_shell){
			g_object_ref(lum_shell);
			selfp->player_type = lum_shell_get_config(lum_shell)->backend;
			selfp->player = lum_player_factory(selfp->player_type,
					lum_shell_get_config(lum_shell));
			g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx", TRUE,
					"LumPlayer::repeat", TRUE,
					"LumPlayer::can_fullscreen", FALSE, NULL, NULL);
		}
		if(!selfp->player){
			g_error("lum_control_new() failed at lum_player_new()\n");
			exit(EXIT_FAILURE);
		}
		gtk_widget_show_all(GTK_WIDGET(selfp->player));

		pfile = bonobo_persist_file_new(
				(BonoboPersistFileIOFn) self_load_from_file,
				NULL,
				"OAFIID:GNOME_Lum_Control",
				self);
				
		pstream = bonobo_persist_stream_new(
				self_load_from_stream,
				NULL, NULL,
				"OAFIID:GNOME_Lum_Control",
				self);
		
		if (!pfile) {
			bonobo_object_unref (BONOBO_OBJECT (self));
			g_error("lum_control_new() failed at "
				    "bonobo_persist_file_new() \n");
			exit(EXIT_FAILURE);
		}

		bonobo_object_add_interface(BONOBO_OBJECT(self),
				BONOBO_OBJECT(pfile));
		bonobo_object_add_interface(BONOBO_OBJECT(self),
						BONOBO_OBJECT(pstream));
		bonobo_control_construct (BONOBO_CONTROL (self),
					GTK_WIDGET(selfp->player));
	
#line 233 "lum-control.c"
 }
}
#undef __GOB_FUNCTION__


#line 77 "lum-control.gob"
GType 
lum_control_get_type (void)
#line 242 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::get_type"
{
#line 77 "lum-control.gob"
	
		static GType type = 0;

		if ___GOB_UNLIKELY(type == 0) {
			static const GTypeInfo info = {
				sizeof (LumControlClass),
				(GBaseInitFunc) NULL,
				(GBaseFinalizeFunc) NULL,
				(GClassInitFunc) lum_control_class_init,
				NULL, /* class_finalize */
				NULL, /* class_data */
				sizeof (LumControl),
				0, /* n_preallocs */
				(GInstanceInitFunc)  lum_control_init,
				NULL
			};

			type = bonobo_type_unique (
				BONOBO_TYPE_CONTROL,
				POA_Bonobo_Control__init, NULL,
				G_STRUCT_OFFSET (LumControlClass, _epv),
				&info, "LumControl");
			}
		return type;
	}}
#line 272 "lum-control.c"
#undef __GOB_FUNCTION__


#line 148 "lum-control.gob"
static void 
___3_lum_control_dispose (GObject * object G_GNUC_UNUSED)
#line 279 "lum-control.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Control::dispose"
{
#line 148 "lum-control.gob"
	
		__d;
		g_return_if_fail(lum_shell != NULL);

		g_object_unref(lum_shell);
		PARENT_HANDLER(object);
	}}
#line 294 "lum-control.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 156 "lum-control.gob"
static void 
___4_lum_control_activate (BonoboControl * control G_GNUC_UNUSED, gboolean arg)
#line 301 "lum-control.c"
#define PARENT_HANDLER(___control,___arg) \
	{ if(BONOBO_CONTROL_CLASS(parent_class)->activate) \
		(* BONOBO_CONTROL_CLASS(parent_class)->activate)(___control,___arg); }
{
#define __GOB_FUNCTION__ "Lum:Control::activate"
{
#line 156 "lum-control.gob"
	
		__d;
		Self *self = SELF(control);
		if(arg)
			lum_player_play_pause(selfp->player);
		else
			lum_player_stop(selfp->player);
		PARENT_HANDLER(control, arg);
	}}
#line 318 "lum-control.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 166 "lum-control.gob"
static void 
___5_lum_control_disconnected (BonoboControl * control G_GNUC_UNUSED)
#line 325 "lum-control.c"
#define PARENT_HANDLER(___control) \
	{ if(BONOBO_CONTROL_CLASS(parent_class)->disconnected) \
		(* BONOBO_CONTROL_CLASS(parent_class)->disconnected)(___control); }
{
#define __GOB_FUNCTION__ "Lum:Control::disconnected"
{
#line 166 "lum-control.gob"
	
		__d;
		Self *self = SELF(control);
		lum_player_stop(selfp->player);
		PARENT_HANDLER(control);
	}}
#line 339 "lum-control.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 173 "lum-control.gob"
BonoboGenericFactory * 
lum_control_factory_new (void)
#line 346 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::factory_new"
{
#line 173 "lum-control.gob"
	
		return bonobo_generic_factory_new (
						 "OAFIID:GNOME_Lum_Control_Factory",
		 				 self_factory, NULL);
	}}
#line 356 "lum-control.c"
#undef __GOB_FUNCTION__

#line 182 "lum-control.gob"
static gint 
lum_control_load_from_file (BonoboPersistFile * pf, const CORBA_char * text_uri, CORBA_Environment * ev, Self * self)
#line 362 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::load_from_file"
#line 182 "lum-control.gob"
	g_return_val_if_fail (self != NULL, (gint )-1);
#line 182 "lum-control.gob"
	g_return_val_if_fail (IS_SELF (self), (gint )-1);
#line 369 "lum-control.c"
{
#line 185 "lum-control.gob"
	
		GnomeVFSURI *uri;
		GnomeVFSResult result;
		GnomeVFSHandle *handle;
		GError *error = NULL;
		if(selfp->info)
			g_object_unref(selfp->info);
		selfp->info = lum_player_info_factory(text_uri, &error);

		if(selfp->info == NULL){
			if(error){
				g_warning(__GOB_FUNCTION__ " - info == NULL for %s -> %s.",
						text_uri, error->message);
				g_error_free(error);
			}
			return -1;
		}
		
		if(selfp->info->has_video)
			g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx",
					FALSE, NULL, NULL);

		if(g_ascii_strncasecmp("dvd", text_uri, 3) == 0){
			if(!lum_player_open_file(selfp->player, text_uri, selfp->info))
				return -1;
			selfp->uri = g_strdup(text_uri);
			return 0;
		}
		
		uri = gnome_vfs_uri_new(text_uri);

		result = gnome_vfs_open_uri (&handle,
				uri, GNOME_VFS_OPEN_READ);
		if (result != GNOME_VFS_OK) {
			gnome_vfs_uri_unref (uri);
			return -1;
		}
		
		char *scheme;
		scheme = g_strdup(gnome_vfs_uri_get_scheme (uri));
		if(g_ascii_strcasecmp("http", scheme) == 0){
			selfp->uri = gnome_vfs_uri_to_string(uri,
					GNOME_VFS_URI_HIDE_NONE);
		} else {
			selfp->uri = gnome_vfs_uri_to_string(uri,
					GNOME_VFS_URI_HIDE_TOPLEVEL_METHOD);
		}
		g_free(scheme);
		gnome_vfs_uri_unref(uri);
		if(!lum_player_open_file(selfp->player, selfp->uri, selfp->info))
			return -1;
		return 0;
	}}
#line 425 "lum-control.c"
#undef __GOB_FUNCTION__

#line 245 "lum-control.gob"
static void 
lum_control_load_from_stream (BonoboPersistStream * ps, const Bonobo_Stream stream, Bonobo_Persist_ContentType type, void * closure, CORBA_Environment * ev)
#line 431 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::load_from_stream"
{
#line 249 "lum-control.gob"
	
		Self *self = SELF(closure);
		guint8 *buffer = NULL;
		CORBA_long length_read = 0;
		int fd;
		gchar tmp[64];
		__d;
		if(selfp->info)
			g_object_unref(selfp->info);

		selfp->info = g_object_new(LUM_TYPE_PLAYER_INFO, NULL, NULL);

		strcpy(tmp, "/tmp/lumiere-XXXXXX");
		if((fd = mkstemp(tmp)) < 0){
			perror(__FILE__ "Error creating temporary file");
			return;
		}
		
		selfp->tmpfile = g_strdup(tmp);

		{
			GError *err = NULL;
			selfp->fifo_thread = g_thread_create(
				self_play_start, (gpointer) self,
				TRUE, &err);
			if(err){
				fprintf(stderr, __FILE__
						": Unable to create thread: %s\n", err->message);
				g_error_free (err);
			}
		}

		fd = open(tmp, O_WRONLY);
		if(fd == -1){
			perror(__FILE__ ": open temp file");
			return;
		}

		while((buffer = bonobo_stream_client_read(stream,
					16 * 1024, &length_read, ev))){
			ssize_t i;
			if (ev->_major != CORBA_NO_EXCEPTION)
				break;
			__ds(": looping write");
			i = write(fd, buffer, length_read);
			if(i == -1)
				perror(__FILE__ ": write");
		}
	}}
#line 485 "lum-control.c"
#undef __GOB_FUNCTION__

#line 299 "lum-control.gob"
static gpointer 
lum_control_play_start (gpointer data)
#line 491 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::play_start"
{
#line 299 "lum-control.gob"
	
		__d;
		Self *self = SELF(data);

		if(!lum_player_open_file(selfp->player, selfp->tmpfile, 
					selfp->info))
			g_warning("lum_player_open_file failed");

		return NULL;
	}}
#line 506 "lum-control.c"
#undef __GOB_FUNCTION__

#line 310 "lum-control.gob"
static BonoboObject * 
lum_control_factory (BonoboGenericFactory * this, const char * oaf_iid, void * data)
#line 512 "lum-control.c"
{
#define __GOB_FUNCTION__ "Lum:Control::factory"
#line 310 "lum-control.gob"
	g_return_val_if_fail (this != NULL, (BonoboObject * )NULL);
#line 310 "lum-control.gob"
	g_return_val_if_fail (oaf_iid != NULL, (BonoboObject * )NULL);
#line 519 "lum-control.c"
{
#line 312 "lum-control.gob"
	
		return BONOBO_OBJECT (GET_NEW);
	}}
#line 525 "lum-control.c"
#undef __GOB_FUNCTION__
