/* Generated by GOB (v2.0.11) on Sat Apr 16 19:56:22 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-config-gconf.gob"

/***************************************************************************
                          lum-config-gconf.gob  -  Lumiere Configuration 
                             GConf based implementation
                             -------------------
    copyright            : (C) 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * LumConfigGConf:
 * Configuration class for lumiere
 * This implementation uses GConf but you can use your own, there are
 * no public functions, so you just need the fields and the constructor.
 *
 * The GConf database is queried and notifiers are registered,
 * the configuration is changed when something is modifyed in the
 * GConf database.
 */

#line 38 "lum-config-gconf.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-config-gconf.h"

#include "lum-config-gconf-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 48 "lum-config-gconf.gob"

#include <config.h>

#include "lum-shell.h"

#include <stdio.h>

#define LUM_DIR "/apps/lumiere"
#define LUM_BACKEND "/apps/lumiere/player/backend"
#define LUM_XV "/apps/lumiere/player/xv"
#define LUM_SLANG "/apps/lumiere/player/slang"
#define LUM_ALANG "/apps/lumiere/player/alang"
#define LUM_DVDDEV "/apps/lumiere/player/dvd_dev"
#define LUM_CDDEV "/apps/lumiere/player/cd_dev"
#define LUM_STOPSSAVER "/apps/lumiere/player/stop_ssaver"
#define LUM_OSD "/apps/lumiere/player/osd"

#define LUM_SERVER "/apps/lumiere/shell/server-mode"
#define LUM_TRAY "/apps/lumiere/shell/show-tray-icon"
#define LUM_AUTOSTART "/apps/lumiere/engine/autostart"
#define LUM_XOSD "/apps/lumiere/engine/x_osd"
#define LUM_SPEECH "/apps/lumiere/engine/speech"

extern LumShell *lum_shell;

#line 85 "lum-config-gconf.c"
/* self casting macros */
#define SELF(x) LUM_CONFIG_GCONF(x)
#define SELF_CONST(x) LUM_CONFIG_GCONF_CONST(x)
#define IS_SELF(x) LUM_IS_CONFIG_GCONF(x)
#define TYPE_SELF LUM_TYPE_CONFIG_GCONF
#define SELF_CLASS(x) LUM_CONFIG_GCONF_CLASS(x)

#define SELF_GET_CLASS(x) LUM_CONFIG_GCONF_GET_CLASS(x)

/* self typedefs */
typedef LumConfigGConf Self;
typedef LumConfigGConfClass SelfClass;

/* here are local prototypes */
static void lum_config_gconf_class_init (LumConfigGConfClass * c) G_GNUC_UNUSED;
static void lum_config_gconf_init (LumConfigGConf * self) G_GNUC_UNUSED;
static void ___2_lum_config_gconf_dispose (GObject * object) G_GNUC_UNUSED;
static void lum_config_gconf_notify_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void ___4_lum_config_gconf_set_server (LumConfig * config, bool mode) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static LumConfigClass *parent_class = NULL;

/* Short form macros */
#define self_notify_cb lum_config_gconf_notify_cb
GType
lum_config_gconf_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumConfigGConfClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_config_gconf_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumConfigGConf),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_config_gconf_init,
			NULL
		};

		type = g_type_register_static (LUM_TYPE_CONFIG, "LumConfigGConf", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumConfigGConf *)g_object_new(lum_config_gconf_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumConfigGConf * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumConfigGConf *
GET_NEW_VARG (const char *first, ...)
{
	LumConfigGConf *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumConfigGConf *)g_object_new_valist (lum_config_gconf_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::dispose"
	LumConfigGConf *self G_GNUC_UNUSED = LUM_CONFIG_GCONF (obj_self);
#line 230 "lum-config-gconf.gob"
	___2_lum_config_gconf_dispose(obj_self);
#line 161 "lum-config-gconf.c"
#line 75 "lum-config-gconf.gob"
	if(self->_priv->client) { g_object_unref ((gpointer) self->_priv->client); self->_priv->client = NULL; }
#line 164 "lum-config-gconf.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::finalize"
	LumConfigGConf *self G_GNUC_UNUSED = LUM_CONFIG_GCONF (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
lum_config_gconf_class_init (LumConfigGConfClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	LumConfigClass *lum_config_class = (LumConfigClass *)c;

	g_type_class_add_private(c,sizeof(LumConfigGConfPrivate));

	parent_class = g_type_class_ref (LUM_TYPE_CONFIG);

#line 230 "lum-config-gconf.gob"
	g_object_class->dispose = ___dispose;
#line 319 "lum-config-gconf.gob"
	lum_config_class->set_server = ___4_lum_config_gconf_set_server;
#line 195 "lum-config-gconf.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__
#line 98 "lum-config-gconf.gob"
static void 
lum_config_gconf_init (LumConfigGConf * self G_GNUC_UNUSED)
#line 202 "lum-config-gconf.c"
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumConfigGConfPrivate);
#line 48 "lum-config-gconf.gob"
	self->_priv->client = NULL;
#line 208 "lum-config-gconf.c"
 {
#line 98 "lum-config-gconf.gob"

		GError *error = NULL;
		
		if (!gconf_is_initialized ())
			gconf_init (0, NULL, NULL);

		selfp->client = gconf_client_get_default();
		gconf_client_add_dir(selfp->client,
				LUM_DIR,
				GCONF_CLIENT_PRELOAD_RECURSIVE,
				&error);
		if (error != NULL){
		 	fprintf(stderr, __FILE__ ": GConf client add lumiere dir: %s\n",
					error->message);
			g_error_free (error);
			return;
	   	} 	
		gconf_client_add_dir(selfp->client,
				"/desktop/gnome/sound",
				GCONF_CLIENT_PRELOAD_ONELEVEL,
				NULL);
		gconf_client_add_dir(selfp->client,
				"/system/http_proxy",
				GCONF_CLIENT_PRELOAD_ONELEVEL,
				NULL);

		LumConfig *config = LUM_CONFIG(self);
		char *type, *tmp;
		type = gconf_client_get_string(selfp->client, LUM_BACKEND, NULL);
		selfp->backend_id = gconf_client_notify_add (selfp->client,
							LUM_BACKEND, self_notify_cb, 
							self, NULL, NULL);

		if(!g_ascii_strcasecmp("glplay", type))
			config->backend = PLAYER_GL;
		else
			config->backend = PLAYER_XINE;
		g_free(type);
			
		config->esd_out = gconf_client_get_bool(selfp->client,
				"/desktop/gnome/sound/enable_esd", NULL);
		config->xv = gconf_client_get_bool(selfp->client, LUM_XV, NULL);
		if((tmp = gconf_client_get_string(selfp->client, LUM_SLANG, NULL)))
			config->slang = tmp;
		if((tmp = gconf_client_get_string(selfp->client, LUM_ALANG, NULL)))
			config->alang = tmp;
		if((tmp = gconf_client_get_string(selfp->client, LUM_DVDDEV, NULL)))
			config->dvd_dev = tmp;
		if((tmp = gconf_client_get_string(selfp->client, LUM_CDDEV, NULL)))
			config->cd_dev = tmp;
		config->stop_ssaver = gconf_client_get_bool(selfp->client,
					LUM_STOPSSAVER, NULL);
		config->osd = gconf_client_get_int(selfp->client, LUM_OSD, NULL);
		config->server_mode = gconf_client_get_bool(selfp->client,
					LUM_SERVER, NULL);
		config->tray_icon = gconf_client_get_bool(selfp->client,
					LUM_TRAY, NULL);
		config->autostart = gconf_client_get_bool(selfp->client,
					LUM_AUTOSTART, NULL);
		config->x_osd = gconf_client_get_bool(selfp->client,
					LUM_XOSD, NULL);
		config->speech = gconf_client_get_bool(selfp->client,
					LUM_SPEECH, NULL);
		config->use_proxy = gconf_client_get_bool(selfp->client,
				"/system/http_proxy/use_http_proxy", NULL);
		if(config->use_proxy) {
			selfp->use_proxy_id = gconf_client_notify_add (selfp->client,
				"/system/http_proxy/use_http_proxy",
			    self_notify_cb, self, NULL, NULL);
			config->proxy_host = gconf_client_get_string(selfp->client,
					"/system/http_proxy/host", NULL);
			selfp->proxy_host_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/host",
				    self_notify_cb, self, NULL, NULL);
			config->proxy_port = gconf_client_get_int(selfp->client,
					"/system/http_proxy/port", NULL);
			selfp->proxy_port_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/port",
				    self_notify_cb, self, NULL, NULL);
			config->proxy_auth = gconf_client_get_bool(selfp->client,
					"/system/http_proxy/use_authentication", NULL);
			selfp->proxy_auth_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/use_authentication",
				    self_notify_cb, self, NULL, NULL);
			config->proxy_user = gconf_client_get_string (selfp->client,
					"/system/http_proxy/authentication_user",
					NULL);
			selfp->proxy_user_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/authentication_user",
					self_notify_cb, self, NULL, NULL);
			config->proxy_password = gconf_client_get_string (selfp->client,
					"/system/http_proxy/authentication_password",
					NULL);
			selfp->proxy_password_id = gconf_client_notify_add (selfp->client,
					"/system/http_proxy/authentication_password",
				    self_notify_cb, self, NULL, NULL);
		}
		
		selfp->esd_out_id =  gconf_client_notify_add (selfp->client,
					 "/desktop/gnome/sound/enable_esd", 
					 self_notify_cb, self, NULL, NULL);
		selfp->xv_id = gconf_client_notify_add (selfp->client, 
					LUM_XV, self_notify_cb, self, NULL, NULL);
		selfp->slang_id = gconf_client_notify_add (selfp->client,
					 LUM_SLANG, self_notify_cb, self, NULL, NULL);
		selfp->alang_id = gconf_client_notify_add(selfp->client,
					 LUM_ALANG, self_notify_cb, self, NULL, NULL);
		selfp->dvd_dev_id = gconf_client_notify_add (selfp->client,
					 LUM_DVDDEV, self_notify_cb, self, NULL, NULL);
		selfp->cd_dev_id = gconf_client_notify_add (selfp->client,
					 LUM_CDDEV, self_notify_cb, self, NULL, NULL);
		selfp->stop_ssaver_id = gconf_client_notify_add (selfp->client,
					 LUM_STOPSSAVER, self_notify_cb, self, NULL, NULL);
		selfp->osd_id = gconf_client_notify_add (selfp->client,
					 LUM_OSD, self_notify_cb, self, NULL, NULL);
		selfp->tray_icon_id = gconf_client_notify_add (selfp->client,
					 LUM_TRAY, self_notify_cb, self, NULL, NULL);
		selfp->server_mode_id = gconf_client_notify_add (selfp->client,
					 LUM_SERVER, self_notify_cb, self, NULL, &error);
		selfp->autostart_id = gconf_client_notify_add (selfp->client,
					 LUM_AUTOSTART, self_notify_cb, self, NULL, &error);
		selfp->x_osd_id = gconf_client_notify_add (selfp->client,
					 LUM_XOSD, self_notify_cb, self, NULL, &error);
		selfp->speech_id = gconf_client_notify_add (selfp->client,
					 LUM_SPEECH, self_notify_cb, self, NULL, &error);

		if (error != NULL){
		 	printf(__FILE__ ": GConf client error: %s\n", error->message);
			g_error_free (error);
	   	}
	
#line 342 "lum-config-gconf.c"
 }
}
#undef __GOB_FUNCTION__



#line 230 "lum-config-gconf.gob"
static void 
___2_lum_config_gconf_dispose (GObject * object G_GNUC_UNUSED)
#line 352 "lum-config-gconf.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::dispose"
{
#line 230 "lum-config-gconf.gob"
	
		Self *self = SELF(object);
#ifndef NDEBUG
		printf(__FILE__ ": dispose\n");
#endif

		gconf_client_notify_remove (selfp->client,
					selfp->slang_id);
		gconf_client_notify_remove (selfp->client,
					selfp->alang_id);
		gconf_client_notify_remove (selfp->client,
					selfp->dvd_dev_id);
		gconf_client_notify_remove (selfp->client,
					selfp->cd_dev_id);
		gconf_client_notify_remove (selfp->client,
					selfp->osd_id);
		gconf_client_notify_remove (selfp->client,
					selfp->stop_ssaver_id);
		gconf_client_notify_remove (selfp->client,
					selfp->backend_id);
		gconf_client_notify_remove (selfp->client,
					selfp->server_mode_id);
		gconf_client_notify_remove (selfp->client,
					selfp->tray_icon_id);
		PARENT_HANDLER(object);
	}}
#line 386 "lum-config-gconf.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 257 "lum-config-gconf.gob"
static void 
lum_config_gconf_notify_cb (GConfClient * client, guint cnxn_id, GConfEntry * entry, gpointer user_data)
#line 393 "lum-config-gconf.c"
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::notify_cb"
#line 257 "lum-config-gconf.gob"
	g_return_if_fail (user_data != NULL);
#line 398 "lum-config-gconf.c"
{
#line 258 "lum-config-gconf.gob"
	
		Self *self = SELF(user_data);
		LumConfig *config = LUM_CONFIG(self);
#ifndef NDEBUG
		printf(__FILE__ ": notify_cb\n");
#endif
		if(cnxn_id == selfp->esd_out_id){
			config->esd_out = gconf_value_get_bool(entry->value);
			
		} else if(cnxn_id == selfp->xv_id){
			config->xv = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->slang_id){
			g_free(config->slang);
			config->slang = g_strdup(gconf_value_get_string (entry->value));
			
		} else if(cnxn_id == selfp->alang_id){
			g_free(config->alang);
			config->alang = g_strdup(gconf_value_get_string (entry->value));
			
		} else if(cnxn_id == selfp->dvd_dev_id){
			g_free(config->dvd_dev);
			config->dvd_dev = g_strdup(gconf_value_get_string (entry->value));
	
		} else if(cnxn_id == selfp->cd_dev_id){
			g_free(config->cd_dev);
			config->cd_dev = g_strdup(gconf_value_get_string (entry->value));		
		
		} else if(cnxn_id == selfp->stop_ssaver_id){
			config->stop_ssaver = gconf_value_get_bool (entry->value);
			
		} else if(cnxn_id == selfp->osd_id){
			config->osd = gconf_value_get_int(entry->value);
			
		} else if(cnxn_id == selfp->backend_id){
			gchar *type = gconf_client_get_string(selfp->client,
					LUM_BACKEND, NULL);
			if(!g_ascii_strcasecmp("glplay", type))
				config->backend = PLAYER_GL;
			else if(!g_ascii_strcasecmp("xine", type))
				config->backend = PLAYER_XINE;
			g_free(type);
		} else if(cnxn_id == selfp->server_mode_id){
			config->server_mode = gconf_value_get_bool(entry->value);
			if(lum_shell)
				lum_shell_set_server_mode(lum_shell, config->server_mode);

		} else if(cnxn_id == selfp->tray_icon_id){
			config->tray_icon = gconf_value_get_bool(entry->value);
			lum_shell_set_tray_icon(lum_shell, config->tray_icon);
		} else if(cnxn_id == selfp->autostart_id){
			config->autostart = gconf_value_get_bool(entry->value);
		} else if(cnxn_id == selfp->x_osd_id){
			config->x_osd = gconf_value_get_bool(entry->value);
		} else if(cnxn_id == selfp->speech_id){
			config->speech = gconf_value_get_bool(entry->value);
		}

		lum_config_changed(config);
	}}
#line 461 "lum-config-gconf.c"
#undef __GOB_FUNCTION__

#line 319 "lum-config-gconf.gob"
static void 
___4_lum_config_gconf_set_server (LumConfig * config G_GNUC_UNUSED, bool mode)
#line 467 "lum-config-gconf.c"
#define PARENT_HANDLER(___config,___mode) \
	{ if(LUM_CONFIG_CLASS(parent_class)->set_server) \
		(* LUM_CONFIG_CLASS(parent_class)->set_server)(___config,___mode); }
{
#define __GOB_FUNCTION__ "Lum:Config:GConf::set_server"
{
#line 319 "lum-config-gconf.gob"
	
		Self *self = SELF(config);
		gconf_client_set_bool(selfp->client,
			       LUM_SERVER, mode, NULL);
	}}
#line 480 "lum-config-gconf.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
