/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                   lum-playlist.gob  -  Lumiere Playlist Window 
                             -------------------
    copyright            : (C) 2003,2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * CVS block: cvs hosted at nongnu.org
 *
 * $Author: stephanek $
 * $Revision: 1.5 $
 * $Date: 2004/03/27 00:14:31 $
 *
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-playlist.h"

#include "lum-playlist-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */



static const GtkTargetEntry target_table [] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL }
};

enum
{
	TARGET_GTK_TREE_MODEL_ROW
};
static GtkTargetEntry tree_view_row_targets[] = {
	{ "GTK_TREE_MODEL_ROW", GTK_TARGET_SAME_APP, TARGET_GTK_TREE_MODEL_ROW }
};




static gboolean gtk_tree_model_iter_previous (GtkTreeModel *tree_model, GtkTreeIter *iter)
{
	GtkTreePath *path;
	gboolean ret;

	path = gtk_tree_model_get_path (tree_model, iter);
	ret = gtk_tree_path_prev (path);
	if (ret == TRUE)
		gtk_tree_model_get_iter (tree_model, iter, path);

	gtk_tree_path_free (path);
	return ret;
}


static const GEnumValue _lum_playlist_column_values[] = {
	{ COL_DISPLAY_URI, "COL_DISPLAY_URI", "display-uri" },
	{ COL_ACTUAL_URI, "COL_ACTUAL_URI", "actual-uri" },
	{ COL_INFO, "COL_INFO", "info" },
	{ COL_NR, "COL_NR", "nr" },
	{ 0, NULL, NULL }
};

GType
lum_playlist_column_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumPlaylistColumn", _lum_playlist_column_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_PLAYLIST(x)
#define SELF_CONST(x) LUM_PLAYLIST_CONST(x)
#define IS_SELF(x) LUM_IS_PLAYLIST(x)
#define TYPE_SELF LUM_TYPE_PLAYLIST
#define SELF_CLASS(x) LUM_PLAYLIST_CLASS(x)

#define SELF_GET_CLASS(x) LUM_PLAYLIST_GET_CLASS(x)

/* self typedefs */
typedef LumPlaylist Self;
typedef LumPlaylistClass SelfClass;

/* here are local prototypes */
static void lum_playlist_class_init (LumPlaylistClass * c) G_GNUC_UNUSED;
static void lum_playlist_init (LumPlaylist * self) G_GNUC_UNUSED;
static void ___3_lum_playlist_dispose (GObject * object) G_GNUC_UNUSED;
static gboolean ___4_lum_playlist_button_release_event (GtkWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static gboolean ___5_lum_playlist_key_release_event (GtkWidget * widget, GdkEventKey * event) G_GNUC_UNUSED;
static void ___6_lum_playlist_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time) G_GNUC_UNUSED;
static gboolean lum_playlist_update_current (LumPlaylist * self) G_GNUC_UNUSED;
static void lum_playlist_set_at_end (LumPlaylist * self) G_GNUC_UNUSED;
static void lum_playlist_delete (LumPlaylist * self, gboolean crop) G_GNUC_UNUSED;
static gint lum_playlist_compare_func (GtkTreeModel * model, GtkTreeIter * iter_a, GtkTreeIter * iter_b, gpointer data) G_GNUC_UNUSED;
static gboolean lum_playlist_crop (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void lum_playlist_selection_changed_cb (GtkTreeSelection * selection, Self * self) G_GNUC_UNUSED;
static void lum_playlist_activate_cb (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, Self * self) G_GNUC_UNUSED;
static void lum_playlist_delete_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_crop_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_clear_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_sort_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_properties_cb (GtkMenuItem * menuitem, Self * self) G_GNUC_UNUSED;
static void lum_playlist_delete_clicked_cb (GtkButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_playlist_add_clicked_cb (GtkButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_playlist_close_clicked_cb (GtkButton * button, gpointer data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkWindowClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new(args...) lum_playlist_new(args)
#define self_add_list(args...) lum_playlist_add_list(args)
#define self_add(args...) lum_playlist_add(args)
#define self_get_active_info(args...) lum_playlist_get_active_info(args)
#define self_get_active_uri(args...) lum_playlist_get_active_uri(args)
#define self_get_length(args...) lum_playlist_get_length(args)
#define self_get_list(args...) lum_playlist_get_list(args)
#define self_clear(args...) lum_playlist_clear(args)
#define self_has_next(args...) lum_playlist_has_next(args)
#define self_next(args...) lum_playlist_next(args)
#define self_has_prev(args...) lum_playlist_has_prev(args)
#define self_prev(args...) lum_playlist_prev(args)
#define self_update_current(args...) lum_playlist_update_current(args)
#define self_set_at_start(args...) lum_playlist_set_at_start(args)
#define self_set_at_end(args...) lum_playlist_set_at_end(args)
#define self_delete(args...) lum_playlist_delete(args)
#define self_compare_func(args...) lum_playlist_compare_func(args)
#define self_crop(args...) lum_playlist_crop(args)
#define self_selection_changed_cb(args...) lum_playlist_selection_changed_cb(args)
#define self_activate_cb(args...) lum_playlist_activate_cb(args)
#define self_delete_cb(args...) lum_playlist_delete_cb(args)
#define self_crop_cb(args...) lum_playlist_crop_cb(args)
#define self_clear_cb(args...) lum_playlist_clear_cb(args)
#define self_sort_cb(args...) lum_playlist_sort_cb(args)
#define self_properties_cb(args...) lum_playlist_properties_cb(args)
#define self_delete_clicked_cb(args...) lum_playlist_delete_clicked_cb(args)
#define self_add_clicked_cb(args...) lum_playlist_add_clicked_cb(args)
#define self_close_clicked_cb(args...) lum_playlist_close_clicked_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static LumPlaylist * (* const self_new) (LumEngine * engine) = lum_playlist_new;
static void (* const self_add_list) (LumPlaylist * self, GList * uris, GList * infos) = lum_playlist_add_list;
static void (* const self_add) (LumPlaylist * self, const gchar * uri, LumPlayerInfo * info) = lum_playlist_add;
static LumPlayerInfo * (* const self_get_active_info) (LumPlaylist * self) = lum_playlist_get_active_info;
static gchar * (* const self_get_active_uri) (LumPlaylist * self) = lum_playlist_get_active_uri;
static gint (* const self_get_length) (LumPlaylist * self) = lum_playlist_get_length;
static GList * (* const self_get_list) (LumPlaylist * self) = lum_playlist_get_list;
static void (* const self_clear) (LumPlaylist * self) = lum_playlist_clear;
static gboolean (* const self_has_next) (LumPlaylist * self) = lum_playlist_has_next;
static void (* const self_next) (LumPlaylist * self) = lum_playlist_next;
static gboolean (* const self_has_prev) (LumPlaylist * self) = lum_playlist_has_prev;
static void (* const self_prev) (LumPlaylist * self) = lum_playlist_prev;
static gboolean (* const self_update_current) (LumPlaylist * self) = lum_playlist_update_current;
static void (* const self_set_at_start) (LumPlaylist * self) = lum_playlist_set_at_start;
static void (* const self_set_at_end) (LumPlaylist * self) = lum_playlist_set_at_end;
static void (* const self_delete) (LumPlaylist * self, gboolean crop) = lum_playlist_delete;
static gint (* const self_compare_func) (GtkTreeModel * model, GtkTreeIter * iter_a, GtkTreeIter * iter_b, gpointer data) = lum_playlist_compare_func;
static gboolean (* const self_crop) (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) = lum_playlist_crop;
static void (* const self_selection_changed_cb) (GtkTreeSelection * selection, Self * self) = lum_playlist_selection_changed_cb;
static void (* const self_activate_cb) (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, Self * self) = lum_playlist_activate_cb;
static void (* const self_delete_cb) (GtkMenuItem * menuitem, Self * self) = lum_playlist_delete_cb;
static void (* const self_crop_cb) (GtkMenuItem * menuitem, Self * self) = lum_playlist_crop_cb;
static void (* const self_clear_cb) (GtkMenuItem * menuitem, Self * self) = lum_playlist_clear_cb;
static void (* const self_sort_cb) (GtkMenuItem * menuitem, Self * self) = lum_playlist_sort_cb;
static void (* const self_properties_cb) (GtkMenuItem * menuitem, Self * self) = lum_playlist_properties_cb;
static void (* const self_delete_clicked_cb) (GtkButton * button, gpointer data) = lum_playlist_delete_clicked_cb;
static void (* const self_add_clicked_cb) (GtkButton * button, gpointer data) = lum_playlist_add_clicked_cb;
static void (* const self_close_clicked_cb) (GtkButton * button, gpointer data) = lum_playlist_close_clicked_cb;

GType
lum_playlist_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumPlaylistClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_playlist_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumPlaylist),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_playlist_init,
		};

		type = g_type_register_static (GTK_TYPE_WINDOW, "LumPlaylist", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumPlaylist *)g_object_new(lum_playlist_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumPlaylist * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumPlaylist *
GET_NEW_VARG (const char *first, ...)
{
	LumPlaylist *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumPlaylist *)g_object_new_valist (lum_playlist_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::dispose"
	LumPlaylist *self = LUM_PLAYLIST (obj_self);
	___3_lum_playlist_dispose(obj_self);
	if(self->_priv->store) { ((*(void (*)(void *))g_object_unref)) (self->_priv->store); self->_priv->store = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::finalize"
	LumPlaylist *self = LUM_PLAYLIST (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	if(self->_priv->menu) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->menu); self->_priv->menu = NULL; }
	if(self->_priv->path) { ((*(void (*)(void *))gtk_tree_path_free)) (self->_priv->path); self->_priv->path = NULL; }
	if(self->_priv->active_uri) { ((*(void (*)(void *))g_free)) (self->_priv->active_uri); self->_priv->active_uri = NULL; }
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_playlist_class_init (LumPlaylistClass * c)
{
#define __GOB_FUNCTION__ "Lum:Playlist::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	parent_class = g_type_class_ref (GTK_TYPE_WINDOW);

	g_object_class->dispose = ___dispose;
	gtk_widget_class->button_release_event = ___4_lum_playlist_button_release_event;
	gtk_widget_class->key_release_event = ___5_lum_playlist_key_release_event;
	gtk_widget_class->drag_data_received = ___6_lum_playlist_drag_data_received;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_playlist_init (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::init"
	self->_priv = g_new0 (LumPlaylistPrivate, 1);
	self->_priv->menu = NULL;
	self->_priv->store = gtk_list_store_new(COL_NR, G_TYPE_STRING, G_TYPE_STRING, 
				LUM_TYPE_PLAYER_INFO);
	self->_priv->view = GTK_TREE_VIEW(
			gtk_tree_view_new_with_model(GTK_TREE_MODEL(selfp->store)));;
	self->_priv->renderer = gtk_cell_renderer_text_new();
	self->_priv->column = NULL;
	self->_priv->path = NULL;
	self->_priv->selected_uris = NULL;
	self->_priv->active_info = NULL;
	self->_priv->active_uri = NULL;
	self->_priv->manual = TRUE;
 {

		gtk_widget_add_events(GTK_WIDGET(self), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
		
		GtkTreeSelection *select;

		g_object_set (G_OBJECT (selfp->renderer),
			"editable", FALSE, NULL);
		selfp->column = gtk_tree_view_column_new_with_attributes(_("Media:"),
						selfp->renderer,
						"text", COL_DISPLAY_URI, NULL);
		gtk_tree_view_append_column(selfp->view, selfp->column);
		gtk_tree_view_set_headers_visible(selfp->view, FALSE);
		select = gtk_tree_view_get_selection(selfp->view);
		gtk_tree_selection_set_mode(select, GTK_SELECTION_MULTIPLE);
		g_signal_connect_after(G_OBJECT(selfp->view), "row_activated",
				G_CALLBACK(self_activate_cb), self);

		/* TODO implement all drag_received and drag_sent */
		gtk_tree_view_enable_model_drag_source (selfp->view, GDK_BUTTON1_MASK,
					tree_view_row_targets,
					G_N_ELEMENTS (tree_view_row_targets),
					GDK_ACTION_MOVE|GDK_ACTION_COPY);
		gtk_tree_view_enable_model_drag_dest (selfp->view,
				tree_view_row_targets,
				G_N_ELEMENTS (tree_view_row_targets),
				GDK_ACTION_MOVE|GDK_ACTION_COPY);
		
		gtk_drag_dest_set(GTK_WIDGET(self), GTK_DEST_DEFAULT_ALL,
			target_table, G_N_ELEMENTS (target_table), GDK_ACTION_COPY);

	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



LumPlaylist * 
lum_playlist_new (LumEngine * engine)
{
#define __GOB_FUNCTION__ "Lum:Playlist::new"
	g_return_val_if_fail (engine != NULL, (LumPlaylist * )NULL);
	g_return_val_if_fail (LUM_IS_ENGINE (engine), (LumPlaylist * )NULL);
{
	
		gchararray title = g_strdup_printf("%s -- Lumiere ", _("Playlist"));
		Self *self = GET_NEW_VARG("GtkWindow::type",
				GTK_WINDOW_TOPLEVEL, "GtkWindow::title", title,
				NULL, NULL);
		g_free(title);
		selfp->engine = engine;

		GladeXML *xml;
		GtkWidget *widget;

		xml = glade_xml_new(
				DATADIR"/lumiere/lumiere.glade",
				"playlist_box", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		widget = glade_xml_get_widget(xml, "scroll");
		gtk_container_add(GTK_CONTAINER(widget), GTK_WIDGET(selfp->view));
		widget = glade_xml_get_widget(xml, "playlist_box");
		glade_xml_signal_connect_data(xml, "add_clicked_cb",
				G_CALLBACK(self_add_clicked_cb), self);
		glade_xml_signal_connect_data(xml, "delete_clicked",
				G_CALLBACK(self_delete_clicked_cb), self);
		glade_xml_signal_connect_data(xml, "close_clicked",
				G_CALLBACK(self_close_clicked_cb), self);
		g_object_unref(G_OBJECT(xml));
		gtk_container_add(GTK_CONTAINER(self), GTK_WIDGET(widget));

		xml = glade_xml_new(
				DATADIR"/lumiere/lumiere.glade",
				"playlist_menu", GETTEXT_PACKAGE);
		g_assert(xml != NULL);
		g_signal_connect(glade_xml_get_widget(xml, "add"),
			    "activate", G_CALLBACK(lum_engine_open_activate_cb),
			    selfp->engine);
		g_signal_connect(glade_xml_get_widget(xml, "remove"),
			    "activate", G_CALLBACK(self_delete_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "crop"),
			    "activate", G_CALLBACK(self_crop_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "clear"),
			    "activate", G_CALLBACK(self_clear_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "sort"),
			    "activate", G_CALLBACK(self_sort_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "properties"),
			    "activate", G_CALLBACK(self_properties_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "dvd"),
			    "activate",
			    G_CALLBACK(lum_engine_open_dvd_activate_cb),
			    selfp->engine);
		g_signal_connect(glade_xml_get_widget(xml, "audio_cd"),
			    "activate",
			    G_CALLBACK(lum_engine_open_audio_cd_activate_cb),
			    selfp->engine);
		selfp->menu = GTK_MENU(glade_xml_get_widget(xml, "playlist_menu_menu"));
		g_object_unref(xml);
	
		return self;
	}}
#undef __GOB_FUNCTION__

static void 
___3_lum_playlist_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Playlist::dispose"
{
	
		Self *self = SELF(object);
		if(selfp->selected_uris){
			GList *list = selfp->selected_uris;
		   	for(; list != NULL; list = list->next)
		   		g_free(list->data);
			g_list_free(selfp->selected_uris);
		}
		PARENT_HANDLER(object);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___4_lum_playlist_button_release_event (GtkWidget * widget, GdkEventButton * event)
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->button_release_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->button_release_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Playlist::button_release_event"
{
	
		Self *self = SELF(widget);

		if(event->button == 3) {
			gtk_menu_popup(selfp->menu, NULL, NULL, NULL, self,
					event->button, event->time);
			return TRUE;
		}
		return PARENT_HANDLER(widget, event);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
___5_lum_playlist_key_release_event (GtkWidget * widget, GdkEventKey * event)
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->key_release_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->key_release_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Playlist::key_release_event"
{
	
		Self *self = SELF(widget);
		switch (event->keyval) {
			case GDK_Delete:
				self_delete(self, FALSE);
				break;
			default:
				return PARENT_HANDLER(widget, event);
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static void 
___6_lum_playlist_drag_data_received (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time)
#define PARENT_HANDLER(___widget,___context,___x,___y,___data,___info,___time) \
	{ if(GTK_WIDGET_CLASS(parent_class)->drag_data_received) \
		(* GTK_WIDGET_CLASS(parent_class)->drag_data_received)(___widget,___context,___x,___y,___data,___info,___time); }
{
#define __GOB_FUNCTION__ "Lum:Playlist::drag_data_received"
{
	
		Self *self = SELF(widget);
		lum_util_drag_received(selfp->engine, context, data, time);
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

void 
lum_playlist_add_list (LumPlaylist * self, GList * uris, GList * infos)
{
#define __GOB_FUNCTION__ "Lum:Playlist::add_list"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		for(; uris != NULL && infos != NULL;
				uris = uris->next, infos = infos->next)
			self_add(self, (gchar *) uris->data,
					LUM_PLAYER_INFO(infos->data));
	}}
#undef __GOB_FUNCTION__

void 
lum_playlist_add (LumPlaylist * self, const gchar * uri, LumPlayerInfo * info)
{
#define __GOB_FUNCTION__ "Lum:Playlist::add"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
	g_return_if_fail (uri != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (LUM_IS_PLAYER_INFO (info));
{
	
		GtkTreeIter iter;
		gchar *display_uri = NULL;
		gchar *unescaped = NULL;

		if(info->artist && info->title)
			display_uri = g_strdup_printf("%s - %s",
						g_locale_to_utf8(info->artist,
							-1, NULL, NULL, NULL),
						g_locale_to_utf8(info->title,
							-1, NULL, NULL, NULL));
		else{
			unescaped = gnome_vfs_unescape_string_for_display(
						g_path_get_basename (uri));
			display_uri = 	g_filename_to_utf8 (unescaped,
					-1, NULL, NULL, NULL);
			if (display_uri == NULL)
				display_uri = g_locale_to_utf8 (unescaped,
						-1, NULL, NULL, NULL);
			if (display_uri == NULL)
				display_uri = g_strdup(unescaped);
			g_free (unescaped);
		}
		gtk_list_store_append(selfp->store, &iter);
		gtk_list_store_set(selfp->store, &iter,
					COL_ACTUAL_URI, g_strdup(uri),
					COL_DISPLAY_URI, display_uri,
					COL_INFO, info,
					-1);
		g_object_unref(info);
	}}
#undef __GOB_FUNCTION__

LumPlayerInfo * 
lum_playlist_get_active_info (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_active_info"
	g_return_val_if_fail (self != NULL, (LumPlayerInfo * )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (LumPlayerInfo * )0);
{
	
		GtkTreeIter iter;
		if(!selfp->active_info && gtk_tree_model_get_iter_first(
							GTK_TREE_MODEL(selfp->store), &iter)){
			gpointer *tmp;
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_INFO, &tmp, -1);
			
			selfp->active_info = LUM_PLAYER_INFO(tmp);
		}
		return selfp->active_info;

	}}
#undef __GOB_FUNCTION__

gchar * 
lum_playlist_get_active_uri (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_active_uri"
	g_return_val_if_fail (self != NULL, (gchar * )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gchar * )0);
{
	
		GtkTreeIter iter;
		if(!selfp->active_uri && gtk_tree_model_get_iter_first(
							GTK_TREE_MODEL(selfp->store), &iter)){
			gchar *tmp;
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_ACTUAL_URI, &tmp, -1);
			
			selfp->active_uri = g_strdup(tmp);
		}
		return selfp->active_uri;
	}}
#undef __GOB_FUNCTION__

gint 
lum_playlist_get_length (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_length"
	g_return_val_if_fail (self != NULL, (gint )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gint )0);
{
	
		return gtk_tree_model_iter_n_children(
				GTK_TREE_MODEL(selfp->store), NULL);
	}}
#undef __GOB_FUNCTION__

GList * 
lum_playlist_get_list (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::get_list"
	g_return_val_if_fail (self != NULL, (GList * )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (GList * )0);
{
	
		GList *list = NULL;
		GtkTreeIter  iter;
	 	gboolean     valid;
		gchar *tmp;

		/* Get first row in list store */
	 	valid = gtk_tree_model_get_iter_first(
				GTK_TREE_MODEL(selfp->store), &iter);
	 	while (valid) {
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_ACTUAL_URI, &tmp, -1);
	   		list = g_list_append(list, g_strdup(tmp));
	       /* Make iter point to the next row in the list store */
	   		valid = gtk_tree_model_iter_next(
					GTK_TREE_MODEL(selfp->store), &iter);
	 	}
		return list;
	}}
#undef __GOB_FUNCTION__

void 
lum_playlist_clear (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::clear"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		gtk_list_store_clear(selfp->store);
		selfp->active_uri = NULL;
	}}
#undef __GOB_FUNCTION__

gboolean 
lum_playlist_has_next (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::has_next"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gboolean )0);
{
	
		GtkTreeIter iter;

		if (self_update_current(self) == FALSE)
			return FALSE;

		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);

		return gtk_tree_model_iter_next(GTK_TREE_MODEL(selfp->store),
				&iter);
	}}
#undef __GOB_FUNCTION__

void 
lum_playlist_next (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::next"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		GtkTreeIter iter;

		if (self_has_next(self) == FALSE) {
			self_set_at_start(self);
			return;
		}

		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);

		gtk_tree_model_iter_next(GTK_TREE_MODEL(selfp->store), &iter);
		if(selfp->path)
			gtk_tree_path_free (selfp->path);
		selfp->path = gtk_tree_model_get_path(
				GTK_TREE_MODEL(selfp->store), &iter);
		selfp->manual = FALSE;
		gtk_tree_view_row_activated(selfp->view,
				selfp->path,
				selfp->column);
		selfp->manual = TRUE;
	}}
#undef __GOB_FUNCTION__

gboolean 
lum_playlist_has_prev (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::has_prev"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gboolean )0);
{
	
		GtkTreeIter iter;

		if(self_update_current(self) == FALSE)
			return FALSE;
		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);

		return gtk_tree_model_iter_previous(
				GTK_TREE_MODEL(selfp->store), &iter);
	}}
#undef __GOB_FUNCTION__

void 
lum_playlist_prev (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::prev"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		GtkTreeIter iter;
		char *path;

		if (self_has_prev(self) == FALSE)
			return;

		path = gtk_tree_path_to_string(selfp->path);
		if (strcmp (path, "0") == 0){
			self_set_at_end(self);
			g_free (path);
			return;
		}

		g_free (path);

		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
				&iter, selfp->path);
		gtk_tree_model_iter_previous(GTK_TREE_MODEL(selfp->store), &iter);
		gtk_tree_path_free (selfp->path);
		selfp->path = gtk_tree_model_get_path(
				GTK_TREE_MODEL(selfp->store), &iter);
		selfp->manual = FALSE;
		gtk_tree_view_row_activated(selfp->view,
				selfp->path,
				selfp->column);
		selfp->manual = TRUE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_playlist_update_current (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::update_current"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_PLAYLIST (self), (gboolean )0);
{
	
		if (selfp->path != NULL)
			return TRUE;

		if (self_get_length(self) != 0)
			selfp->path = gtk_tree_path_new_from_indices(0, -1);
		else
			return FALSE;

		return TRUE;
	}}
#undef __GOB_FUNCTION__

void 
lum_playlist_set_at_start (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::set_at_start"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		GtkTreeIter iter;
		LumPlayerInfo *info;
		gchar *tmp;

		if (selfp->path != NULL){
			gtk_tree_path_free (selfp->path);
			selfp->path = NULL;
		}
		gtk_tree_model_get_iter_first(
				GTK_TREE_MODEL(selfp->store), &iter);
		gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
				&iter, COL_ACTUAL_URI, &tmp, COL_INFO, &info, -1);
		selfp->path = gtk_tree_model_get_path(GTK_TREE_MODEL(selfp->store),
				&iter);
		if(selfp->active_uri)
			g_free(selfp->active_uri);
		selfp->active_uri = g_strdup(tmp);
		selfp->active_info = LUM_PLAYER_INFO(info);
		gtk_tree_view_set_cursor(selfp->view, selfp->path, NULL, FALSE);
		gtk_tree_view_scroll_to_cell(selfp->view, selfp->path, NULL,
				FALSE, 0, 0);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_set_at_end (LumPlaylist * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::set_at_end"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		int index;
		GtkTreeIter iter;
		LumPlayerInfo *info;
		gchar *tmp;

		if (selfp->path != NULL){
			gtk_tree_path_free (selfp->path);
			selfp->path = NULL;
		}

		if (self_get_length(self)){
			index = self_get_length(self) - 1;
			selfp->path = gtk_tree_path_new_from_indices(index, -1);
			gtk_tree_model_get_iter(
				GTK_TREE_MODEL(selfp->store), &iter, selfp->path);
			gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
				&iter, COL_ACTUAL_URI, &tmp, COL_INFO, &info, -1);
			if(selfp->active_uri)
				g_free(selfp->active_uri);
			selfp->active_uri = g_strdup(tmp);
			selfp->active_info = LUM_PLAYER_INFO(info);
			gtk_tree_view_set_cursor(selfp->view, selfp->path, NULL, FALSE);
			gtk_tree_view_scroll_to_cell(selfp->view, selfp->path, NULL,
				FALSE, 0, 0);

		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_delete (LumPlaylist * self, gboolean crop)
{
#define __GOB_FUNCTION__ "Lum:Playlist::delete"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYLIST (self));
{
	
		GtkTreeSelection *selection;
		GtkTreeRowReference *ref;
		gboolean is_selected = FALSE;
		int next_pos;

		selection = gtk_tree_view_get_selection(selfp->view);
		if (selection == NULL)
			return;
		if(!crop)
			self_selection_changed_cb(selection, self);

		if(selfp->path != NULL){
			int *indices;

			ref = gtk_tree_row_reference_new (
					GTK_TREE_MODEL(selfp->store), selfp->path);
			is_selected = gtk_tree_selection_path_is_selected(selection,
					selfp->path);
			if(crop)
				is_selected = !is_selected;

			indices = gtk_tree_path_get_indices(selfp->path);
			next_pos = indices[0];

			gtk_tree_path_free (selfp->path);
		} else {
			ref = NULL;
			next_pos = -1;
		}
		if(crop){
			g_list_foreach(selfp->selected_uris,
					(GFunc)gtk_tree_row_reference_free, NULL);
			g_list_free(selfp->selected_uris);
			gtk_tree_model_foreach(GTK_TREE_MODEL(selfp->store),
					self_crop, self);
		}
		
		while (selfp->selected_uris != NULL){
			GtkTreePath *path;
			GtkTreeIter iter;
#ifdef DEBUG
			printf(__FILE__ ": deleting...\n");
#endif

			path = gtk_tree_row_reference_get_path
				((GtkTreeRowReference *)(selfp->selected_uris->data));
			gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
					&iter, path);
			gtk_tree_path_free (path);
			gtk_list_store_remove(selfp->store, &iter);

			gtk_tree_row_reference_free(
					(GtkTreeRowReference *)(selfp->selected_uris->data));
			selfp->selected_uris = selfp->selected_uris->next;
		}
		g_list_free(selfp->selected_uris);
		selfp->selected_uris = NULL;

		if (is_selected == TRUE){
			if(self_has_next(self))
				self_next(self);
			else
				lum_engine_stop(selfp->engine);
			/* The current item was removed from the playlist */
			if (next_pos != -1){
				char *str;
				GtkTreeIter iter;
				GtkTreePath *cur;

				str = g_strdup_printf ("%d", next_pos);
				cur = gtk_tree_path_new_from_string (str);

				if (gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
							&iter, cur) == FALSE){
					selfp->path = NULL;
					gtk_tree_path_free (cur);
				} else {
					selfp->path = cur;
				}
			} else {
				selfp->path = NULL;
			}

		} else {
			if (ref != NULL) {
			/* The path to the current item changed */
				selfp->path =
					gtk_tree_row_reference_get_path(ref);
				gtk_tree_row_reference_free (ref);
			}
		}
	}}
#undef __GOB_FUNCTION__

static gint 
lum_playlist_compare_func (GtkTreeModel * model, GtkTreeIter * iter_a, GtkTreeIter * iter_b, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Playlist::compare_func"
{
	
		gchar *a, *b;
		gtk_tree_model_get(model, iter_a, COL_ACTUAL_URI, &a, -1);
		gtk_tree_model_get(model, iter_b, COL_ACTUAL_URI, &b, -1);
		return g_ascii_strcasecmp(a, b);
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_playlist_crop (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Playlist::crop"
{
	
		Self *self = SELF(data);
		GtkTreeSelection *selection;
		GtkTreeRowReference *ref;
		selection = gtk_tree_view_get_selection(selfp->view);
		if(!gtk_tree_selection_path_is_selected(selection, path)){
#ifdef DEBUG
			printf(__FILE__ ": appending selected...\n");
#endif
			ref = gtk_tree_row_reference_new(model, path);
			selfp->selected_uris = g_list_append(
					selfp->selected_uris, (gpointer) ref);
		}
		return FALSE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_selection_changed_cb (GtkTreeSelection * selection, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::selection_changed_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		GtkTreeModel *model;
		GList *list;
		GtkTreeRowReference *ref;

		if ((list = gtk_tree_selection_get_selected_rows (
						selection, &model))) {
			g_list_foreach(selfp->selected_uris,
					(GFunc) gtk_tree_row_reference_free, NULL);
			g_list_free(selfp->selected_uris);
			for(; list != NULL; list = list->next){
#ifdef DEBUG
				printf(__FILE__ ": appending selected...\n");
#endif

				ref = gtk_tree_row_reference_new(model,
						(GtkTreePath *) list->data);
				selfp->selected_uris = g_list_append(
						selfp->selected_uris, (gpointer) ref);
			}
		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_activate_cb (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::activate_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		gchar *tmp = NULL;
		gpointer *info = NULL;
		GtkTreeIter iter;
		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store), &iter, path);
		gtk_tree_model_get(GTK_TREE_MODEL(selfp->store), &iter, COL_ACTUAL_URI, &tmp, COL_INFO, &info, -1);
		if(selfp->active_uri)
			g_free(selfp->active_uri);
		selfp->active_uri = g_strdup(tmp);
		selfp->active_info = LUM_PLAYER_INFO(info);
		if(selfp->manual){
			if(selfp->path)
				gtk_tree_path_free(selfp->path);
			selfp->path = gtk_tree_model_get_path(
					GTK_TREE_MODEL(selfp->store), &iter);
		}
		gtk_tree_view_set_cursor(selfp->view, selfp->path, NULL, FALSE);
		gtk_tree_view_scroll_to_cell(selfp->view, selfp->path, NULL,
				FALSE, 0, 0);
		lum_engine_play_now(selfp->engine, selfp->active_info, selfp->active_uri);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_delete_cb (GtkMenuItem * menuitem, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::delete_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_delete(self, FALSE);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_crop_cb (GtkMenuItem * menuitem, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::crop_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_delete(self, TRUE);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_clear_cb (GtkMenuItem * menuitem, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::clear_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		self_clear(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_sort_cb (GtkMenuItem * menuitem, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::sort_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
/*TODO
 		gtk_tree_sortable_set_sort_func (GTK_TREE_SORTABLE(selfp->store),
				COL_ACTUAL_URI, self_compare_func, self, NULL);
		gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(selfp->store),
				COL_ACTUAL_URI ,GTK_SORT_ASCENDING);
		gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(selfp->store),
						NULL, NULL, NULL);
		gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(selfp->store),
				GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,
				GTK_SORT_ASCENDING);
		gtk_tree_sortable_sort_column_changed(GTK_TREE_SORTABLE(selfp->store));
		gtk_tree_view_set_reorderable(selfp->view, TRUE);
*/
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_properties_cb (GtkMenuItem * menuitem, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Playlist::properties_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		GtkTreeSelection *sel;
		LumPlayerInfo *info;
		GList *l;
		GtkTreeIter iter;
		sel = gtk_tree_view_get_selection(selfp->view);
		if(!sel) return;

		l = gtk_tree_selection_get_selected_rows(sel, NULL);
		gtk_tree_model_get_iter(GTK_TREE_MODEL(selfp->store),
					&iter, (GtkTreePath *) l->data);
		gtk_tree_model_get(GTK_TREE_MODEL(selfp->store),
					&iter, COL_INFO, &info, -1);
		lum_util_show_props_window(info);
		g_list_foreach (l, (GFunc)gtk_tree_path_free, NULL);
		g_list_free (l);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_delete_clicked_cb (GtkButton * button, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Playlist::delete_clicked_cb"
{
	
		Self *self = SELF(data);
		self_delete(self, FALSE);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_add_clicked_cb (GtkButton * button, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Playlist::add_clicked_cb"
{
	
		Self *self = SELF(data);
		lum_engine_show_fileselector(selfp->engine);
	}}
#undef __GOB_FUNCTION__

static void 
lum_playlist_close_clicked_cb (GtkButton * button, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Playlist::close_clicked_cb"
{
	
		Self *self = SELF(data);
		lum_engine_playlist_delete_cb(NULL, NULL, selfp->engine);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_playlist_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_add_list)();
	((void (*)(void))self_add)();
	((void (*)(void))self_get_active_info)();
	((void (*)(void))self_get_active_uri)();
	((void (*)(void))self_get_length)();
	((void (*)(void))self_get_list)();
	((void (*)(void))self_clear)();
	((void (*)(void))self_has_next)();
	((void (*)(void))self_next)();
	((void (*)(void))self_has_prev)();
	((void (*)(void))self_prev)();
	((void (*)(void))self_update_current)();
	((void (*)(void))self_set_at_start)();
	((void (*)(void))self_set_at_end)();
	((void (*)(void))self_delete)();
	((void (*)(void))self_compare_func)();
	((void (*)(void))self_crop)();
	((void (*)(void))self_selection_changed_cb)();
	((void (*)(void))self_activate_cb)();
	((void (*)(void))self_delete_cb)();
	((void (*)(void))self_crop_cb)();
	((void (*)(void))self_clear_cb)();
	((void (*)(void))self_sort_cb)();
	((void (*)(void))self_properties_cb)();
	((void (*)(void))self_delete_clicked_cb)();
	((void (*)(void))self_add_clicked_cb)();
	((void (*)(void))self_close_clicked_cb)();
	___lum_playlist_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

