/* Generated by GOB (v2.0.5)   (do not edit directly) */



/***************************************************************************
                    lum-player.gob  -  Lumiere Player Widget (abstract)
                             -------------------
    begin                : dim jan  26 02:08:47 BST 2002
    copyright            : (C) 2003, 2004 by Stphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <glib.h>
#include <glib-object.h>
#ifndef __LUM_PLAYER_H__
#define __LUM_PLAYER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



#include "lum-config.h"
#include "lum-player-info.h"

#include <gtk/gtk.h>


typedef enum {
	PLAYER_NONE,
	PLAYER_PLAYING,
	PLAYER_PAUSED,
	PLAYER_STOPPED
} LumPlayerStatus;
#define LUM_TYPE_PLAYER_STATUS lum_player_status_get_type()
GType lum_player_status_get_type (void);


/*
 * Type checking and casting macros
 */
#define LUM_TYPE_PLAYER	(lum_player_get_type())
#define LUM_PLAYER(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_player_get_type(), LumPlayer)
#define LUM_PLAYER_CONST(obj)	G_TYPE_CHECK_INSTANCE_CAST((obj), lum_player_get_type(), LumPlayer const)
#define LUM_PLAYER_CLASS(klass)	G_TYPE_CHECK_CLASS_CAST((klass), lum_player_get_type(), LumPlayerClass)
#define LUM_IS_PLAYER(obj)	G_TYPE_CHECK_INSTANCE_TYPE((obj), lum_player_get_type ())

#define LUM_PLAYER_GET_CLASS(obj)	G_TYPE_INSTANCE_GET_CLASS((obj), lum_player_get_type(), LumPlayerClass)

/* Private structure type */
typedef struct _LumPlayerPrivate LumPlayerPrivate;

/*
 * Main object structure
 */
#ifndef __TYPEDEF_LUM_PLAYER__
#define __TYPEDEF_LUM_PLAYER__
typedef struct _LumPlayer LumPlayer;
#endif
struct _LumPlayer {
	GtkVBox __parent__;
	/*< private >*/
	LumConfig * config; /* protected */
	LumPlayerStatus status; /* protected */
	gdouble position; /* protected */
	gint time; /* protected */
	gboolean repeat; /* protected */
	LumPlayerPrivate *_priv;
};

/*
 * Class definition
 */
typedef struct _LumPlayerClass LumPlayerClass;
struct _LumPlayerClass {
	GtkVBoxClass __parent__;
	gboolean (* open_file) (LumPlayer * self, const char * uri, LumPlayerInfo * info);
	void (* play_pause) (LumPlayer * self);
	void (* stop) (LumPlayer * self);
	gint (* get_stream_length) (LumPlayer * self);
	void (* set_position) (LumPlayer * self, gdouble pos);
	void (* set_contrast) (LumPlayer * self, gdouble pos);
	void (* set_brightness) (LumPlayer * self, gdouble pos);
	void (* set_hue) (LumPlayer * self, gdouble pos);
	void (* set_saturation) (LumPlayer * self, gdouble pos);
	void (* set_eq) (LumPlayer * self, gint hz, gdouble pos);
	void (* set_volume) (LumPlayer * self, gdouble vol);
	gdouble (* get_volume) (LumPlayer * self);
	void (* set_mute) (LumPlayer * self);
	gboolean (* get_position_time) (LumPlayer * self, gdouble * position, gint * time);
	gboolean (* is_seekable) (LumPlayer * self);
	gboolean (* is_running) (LumPlayer * self);
	gboolean (* can_play) (LumPlayer * self);
	/*signal*/void (* playbackfinished) (LumPlayer * self);
	/*signal*/void (* volume_changed) (LumPlayer * self, double volume);
	/*signal*/void (* status_changed) (LumPlayer * self);
	/*signal*/gboolean (* update_timer) (LumPlayer * self);
	/*signal*/gboolean (* update_position) (LumPlayer * self);
};


/*
 * Public methods
 */
GType	lum_player_get_type	(void);
gboolean 	lum_player_open_file	(LumPlayer * self,
					const char * uri,
					LumPlayerInfo * info);
void 	lum_player_play_pause	(LumPlayer * self);
void 	lum_player_stop	(LumPlayer * self);
gint 	lum_player_get_stream_length	(LumPlayer * self);
void 	lum_player_set_position	(LumPlayer * self,
					gdouble pos);
void 	lum_player_set_contrast	(LumPlayer * self,
					gdouble pos);
void 	lum_player_set_brightness	(LumPlayer * self,
					gdouble pos);
void 	lum_player_set_hue	(LumPlayer * self,
					gdouble pos);
void 	lum_player_set_saturation	(LumPlayer * self,
					gdouble pos);
void 	lum_player_set_eq	(LumPlayer * self,
					gint hz,
					gdouble pos);
void 	lum_player_set_volume	(LumPlayer * self,
					gdouble vol);
gdouble 	lum_player_get_volume	(LumPlayer * self);
gboolean 	lum_player_get_position_time	(LumPlayer * self,
					gdouble * position,
					gint * time);
gboolean 	lum_player_is_seekable	(LumPlayer * self);
gboolean 	lum_player_is_running	(LumPlayer * self);
gboolean 	lum_player_can_play	(LumPlayer * self);
void 	lum_player_playbackfinished	(LumPlayer * self);
void 	lum_player_volume_changed	(LumPlayer * self,
					double volume);
void 	lum_player_status_changed	(LumPlayer * self);
gboolean 	lum_player_update_timer	(LumPlayer * self);
gboolean 	lum_player_update_position	(LumPlayer * self);
const gchar * 	lum_player_get_uri	(LumPlayer * self);
LumPlayerInfo * 	lum_player_get_info	(LumPlayer * self);
void 	lum_player_show_runtime	(LumPlayer * self);
void 	lum_player_set_popup_menu	(LumPlayer * self,
					GtkMenu * menu);

/*
 * Signal connection wrapper macros
 */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define lum_player_connect__playbackfinished(object,func,data)	g_signal_connect(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"playbackfinished",(GCallback)({void (* ___playbackfinished) (LumPlayer * self, gpointer ___data ) = (func); ___playbackfinished; }), (data))
#define lum_player_connect_after__playbackfinished(object,func,data)	g_signal_connect_after(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"playbackfinished",(GCallback)({void (* ___playbackfinished) (LumPlayer * self, gpointer ___data ) = (func); ___playbackfinished; }), (data))
#define lum_player_connect_data__playbackfinished(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"playbackfinished",(GCallback)({void (* ___playbackfinished) (LumPlayer * self, gpointer ___data ) = (func); ___playbackfinished; }), (data), (destroy_data), (GConnectFlags)(flags))
#define lum_player_connect__volume_changed(object,func,data)	g_signal_connect(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"volume_changed",(GCallback)({void (* ___volume_changed) (LumPlayer * self, double volume, gpointer ___data ) = (func); ___volume_changed; }), (data))
#define lum_player_connect_after__volume_changed(object,func,data)	g_signal_connect_after(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"volume_changed",(GCallback)({void (* ___volume_changed) (LumPlayer * self, double volume, gpointer ___data ) = (func); ___volume_changed; }), (data))
#define lum_player_connect_data__volume_changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"volume_changed",(GCallback)({void (* ___volume_changed) (LumPlayer * self, double volume, gpointer ___data ) = (func); ___volume_changed; }), (data), (destroy_data), (GConnectFlags)(flags))
#define lum_player_connect__status_changed(object,func,data)	g_signal_connect(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"status_changed",(GCallback)({void (* ___status_changed) (LumPlayer * self, gpointer ___data ) = (func); ___status_changed; }), (data))
#define lum_player_connect_after__status_changed(object,func,data)	g_signal_connect_after(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"status_changed",(GCallback)({void (* ___status_changed) (LumPlayer * self, gpointer ___data ) = (func); ___status_changed; }), (data))
#define lum_player_connect_data__status_changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"status_changed",(GCallback)({void (* ___status_changed) (LumPlayer * self, gpointer ___data ) = (func); ___status_changed; }), (data), (destroy_data), (GConnectFlags)(flags))
#define lum_player_connect__update_timer(object,func,data)	g_signal_connect(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"update_timer",(GCallback)({gboolean (* ___update_timer) (LumPlayer * self, gpointer ___data ) = (func); ___update_timer; }), (data))
#define lum_player_connect_after__update_timer(object,func,data)	g_signal_connect_after(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"update_timer",(GCallback)({gboolean (* ___update_timer) (LumPlayer * self, gpointer ___data ) = (func); ___update_timer; }), (data))
#define lum_player_connect_data__update_timer(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"update_timer",(GCallback)({gboolean (* ___update_timer) (LumPlayer * self, gpointer ___data ) = (func); ___update_timer; }), (data), (destroy_data), (GConnectFlags)(flags))
#define lum_player_connect__update_position(object,func,data)	g_signal_connect(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"update_position",(GCallback)({gboolean (* ___update_position) (LumPlayer * self, gpointer ___data ) = (func); ___update_position; }), (data))
#define lum_player_connect_after__update_position(object,func,data)	g_signal_connect_after(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"update_position",(GCallback)({gboolean (* ___update_position) (LumPlayer * self, gpointer ___data ) = (func); ___update_position; }), (data))
#define lum_player_connect_data__update_position(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(({LumPlayer *___object = (object); ___object; })),"update_position",(GCallback)({gboolean (* ___update_position) (LumPlayer * self, gpointer ___data ) = (func); ___update_position; }), (data), (destroy_data), (GConnectFlags)(flags))
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define lum_player_connect__playbackfinished(object,func,data)	g_signal_connect(LUM_PLAYER(object),"playbackfinished",(GCallback)(func),(data))
#define lum_player_connect_after__playbackfinished(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"playbackfinished",(GCallback)(func),(data))
#define lum_player_connect_data__playbackfinished(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"playbackfinished",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#define lum_player_connect__volume_changed(object,func,data)	g_signal_connect(LUM_PLAYER(object),"volume_changed",(GCallback)(func),(data))
#define lum_player_connect_after__volume_changed(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"volume_changed",(GCallback)(func),(data))
#define lum_player_connect_data__volume_changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"volume_changed",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#define lum_player_connect__status_changed(object,func,data)	g_signal_connect(LUM_PLAYER(object),"status_changed",(GCallback)(func),(data))
#define lum_player_connect_after__status_changed(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"status_changed",(GCallback)(func),(data))
#define lum_player_connect_data__status_changed(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"status_changed",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#define lum_player_connect__update_timer(object,func,data)	g_signal_connect(LUM_PLAYER(object),"update_timer",(GCallback)(func),(data))
#define lum_player_connect_after__update_timer(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"update_timer",(GCallback)(func),(data))
#define lum_player_connect_data__update_timer(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"update_timer",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#define lum_player_connect__update_position(object,func,data)	g_signal_connect(LUM_PLAYER(object),"update_position",(GCallback)(func),(data))
#define lum_player_connect_after__update_position(object,func,data)	g_signal_connect_after(LUM_PLAYER(object),"update_position",(GCallback)(func),(data))
#define lum_player_connect_data__update_position(object,func,data,destroy_data,flags)	g_signal_connect_data(LUM_PLAYER(object),"update_position",(GCallback)(func),(data),(destroy_data),(GConnectFlags)(flags))
#endif /* __GNUC__ && !__STRICT_ANSI__ */


/*
 * Argument wrapping macros
 */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define LUM_PLAYER_PROP_CAN_FULLSCREEN(arg)    	"can_fullscreen",({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_CAN_FULLSCREEN(arg)	"can_fullscreen",({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_FULLSCREEN(arg)    	"fullscreen",({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_FULLSCREEN(arg)	"fullscreen",({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_CAN_HIDE_BARS(arg)    	"can_hide_bars",({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_CAN_HIDE_BARS(arg)	"can_hide_bars",({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_MUTE(arg)    	"mute",({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_MUTE(arg)	"mute",({gboolean *z = (arg); z;})
#define LUM_PLAYER_PROP_REPEAT(arg)    	"repeat",({gboolean z = (arg); z;})
#define LUM_PLAYER_GET_PROP_REPEAT(arg)	"repeat",({gboolean *z = (arg); z;})
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define LUM_PLAYER_PROP_CAN_FULLSCREEN(arg)    	"can_fullscreen",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_CAN_FULLSCREEN(arg)	"can_fullscreen",(gboolean *)(arg)
#define LUM_PLAYER_PROP_FULLSCREEN(arg)    	"fullscreen",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_FULLSCREEN(arg)	"fullscreen",(gboolean *)(arg)
#define LUM_PLAYER_PROP_CAN_HIDE_BARS(arg)    	"can_hide_bars",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_CAN_HIDE_BARS(arg)	"can_hide_bars",(gboolean *)(arg)
#define LUM_PLAYER_PROP_MUTE(arg)    	"mute",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_MUTE(arg)	"mute",(gboolean *)(arg)
#define LUM_PLAYER_PROP_REPEAT(arg)    	"repeat",(gboolean )(arg)
#define LUM_PLAYER_GET_PROP_REPEAT(arg)	"repeat",(gboolean *)(arg)
#endif /* __GNUC__ && !__STRICT_ANSI__ */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
