/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-player-info.h"

#include "lum-player-info-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) LUM_PLAYER_INFO(x)
#define SELF_CONST(x) LUM_PLAYER_INFO_CONST(x)
#define IS_SELF(x) LUM_IS_PLAYER_INFO(x)
#define TYPE_SELF LUM_TYPE_PLAYER_INFO
#define SELF_CLASS(x) LUM_PLAYER_INFO_CLASS(x)

#define SELF_GET_CLASS(x) LUM_PLAYER_INFO_GET_CLASS(x)

/* self typedefs */
typedef LumPlayerInfo Self;
typedef LumPlayerInfoClass SelfClass;

/* here are local prototypes */
static void lum_player_info_init (LumPlayerInfo * o) G_GNUC_UNUSED;
static void lum_player_info_class_init (LumPlayerInfoClass * c) G_GNUC_UNUSED;
static void lum_player_info_ref_cb (GtkWidget * widget, gpointer unused) G_GNUC_UNUSED;
static void lum_player_info_unref_cb (GtkWidget * widget, gpointer unused) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_get_widget(args...) lum_player_info_get_widget(args)
#define self_load_widget_data(args...) lum_player_info_load_widget_data(args)
#define self_ref_cb(args...) lum_player_info_ref_cb(args)
#define self_unref_cb(args...) lum_player_info_unref_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const self_get_widget) (LumPlayerInfo * self) = lum_player_info_get_widget;
static void (* const self_load_widget_data) (LumPlayerInfo * self) = lum_player_info_load_widget_data;
static void (* const self_ref_cb) (GtkWidget * widget, gpointer unused) = lum_player_info_ref_cb;
static void (* const self_unref_cb) (GtkWidget * widget, gpointer unused) = lum_player_info_unref_cb;

GType
lum_player_info_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumPlayerInfoClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_player_info_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumPlayerInfo),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_player_info_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumPlayerInfo", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumPlayerInfo *)g_object_new(lum_player_info_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumPlayerInfo * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumPlayerInfo *
GET_NEW_VARG (const char *first, ...)
{
	LumPlayerInfo *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumPlayerInfo *)g_object_new_valist (lum_player_info_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::dispose"
	LumPlayerInfo *self = LUM_PLAYER_INFO (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
	if(self->_priv->xml) { ((*(void (*)(void *))g_object_unref)) (self->_priv->xml); self->_priv->xml = NULL; }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::finalize"
	LumPlayerInfo *self = LUM_PLAYER_INFO (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	if(self->uri) { ((*(void (*)(void *))g_free)) (self->uri); self->uri = NULL; }
	if(self->title) { ((*(void (*)(void *))g_free)) (self->title); self->title = NULL; }
	if(self->comment) { ((*(void (*)(void *))g_free)) (self->comment); self->comment = NULL; }
	if(self->artist) { ((*(void (*)(void *))g_free)) (self->artist); self->artist = NULL; }
	if(self->genre) { ((*(void (*)(void *))g_free)) (self->genre); self->genre = NULL; }
	if(self->year) { ((*(void (*)(void *))g_free)) (self->year); self->year = NULL; }
	if(self->album) { ((*(void (*)(void *))g_free)) (self->album); self->album = NULL; }
	if(self->video_codec) { ((*(void (*)(void *))g_free)) (self->video_codec); self->video_codec = NULL; }
	if(self->audio_codec) { ((*(void (*)(void *))g_free)) (self->audio_codec); self->audio_codec = NULL; }
	if(self->_priv->widget) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->widget); self->_priv->widget = NULL; }
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_player_info_init (LumPlayerInfo * o)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::init"
	o->_priv = g_new0 (LumPlayerInfoPrivate, 1);
	o->uri = NULL;
	o->length = -1;
	o->title = NULL;
	o->comment = NULL;
	o->artist = NULL;
	o->genre = NULL;
	o->year = NULL;
	o->album = NULL;
	o->video_codec = NULL;
	o->audio_codec = NULL;
	o->is_seekable = FALSE;
	o->video_width = -1;
	o->video_height = -1;
	o->video_ratio = -1;
	o->video_channels = -1;
	o->video_streams = -1;
	o->video_bitrate = -1;
	o->video_framerate = -1;
	o->video_handled = FALSE;
	o->has_video = FALSE;
	o->has_chapters = FALSE;
	o->ignore_video = FALSE;
	o->has_audio = FALSE;
	o->audio_channels = -1;
	o->audio_bits = -1;
	o->audio_samplerate = -1;
	o->audio_bitrate = -1;
	o->max_audio_channel = -1;
	o->ignore_audio = FALSE;
	o->ignore_spu = FALSE;
	o->max_spu_channel = -1;
	o->_priv->widget = NULL;
	o->_priv->xml = NULL;
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_player_info_class_init (LumPlayerInfoClass * c)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__



GtkWidget * 
lum_player_info_get_widget (LumPlayerInfo * self)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::get_widget"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
	g_return_val_if_fail (LUM_IS_PLAYER_INFO (self), (GtkWidget * )0);
{
	
		if(!selfp->widget){
			if(selfp->xml)
				g_object_unref(selfp->xml);
			selfp->xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"properties_box", GETTEXT_PACKAGE);
			selfp->widget = glade_xml_get_widget(selfp->xml, "properties_box");
			self_load_widget_data(self);
			g_signal_connect(G_OBJECT(selfp->widget), "destroy",
					G_CALLBACK(gtk_widget_destroyed), &selfp->widget);

		}
		return selfp->widget;
	}}
#undef __GOB_FUNCTION__

void 
lum_player_info_load_widget_data (LumPlayerInfo * self)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::load_widget_data"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_PLAYER_INFO (self));
{
	
		GtkWidget *widget;
		char *img_name, *icon_path;
		int tmp;
	
		if(self->uri){
			widget = glade_xml_get_widget(selfp->xml, "uri_label");
			gtk_label_set_text(GTK_LABEL(widget), self->uri);
		}
		GnomeIconTheme *icon_theme = gnome_icon_theme_new();
		img_name = gnome_icon_lookup_sync(icon_theme, NULL, self->uri,
					NULL, GNOME_ICON_LOOKUP_FLAGS_NONE, NULL);
		icon_path = gnome_icon_theme_lookup_icon(
						icon_theme, img_name, 48, NULL, &tmp);
#ifdef DEBUG
		printf(__FILE__ ": img_name: %s\n", img_name);
		printf(__FILE__ ": icon_path: %s\n", icon_path);
#endif
		widget = glade_xml_get_widget(selfp->xml, "mime_image");
		gtk_image_set_from_file(GTK_IMAGE(widget), icon_path);
		g_object_unref(icon_theme);
		if(self->title){
			widget = glade_xml_get_widget(selfp->xml, "title_label");
			gtk_label_set_text(GTK_LABEL(widget), self->title);
		}
		if(self->artist){
			widget = glade_xml_get_widget(selfp->xml, "artist_label");
			gtk_label_set_text(GTK_LABEL(widget), self->artist);
		}
		if(self->year){
			widget = glade_xml_get_widget(selfp->xml, "year_label");
			gtk_label_set_text(GTK_LABEL(widget), self->year);
		}
		if(self->album){
			widget = glade_xml_get_widget(selfp->xml, "album_label");
			gtk_label_set_text(GTK_LABEL(widget), self->album);
		}
		if(self->genre){
			widget = glade_xml_get_widget(selfp->xml, "genre_label");
			gtk_label_set_text(GTK_LABEL(widget), self->genre);
		}
		if(self->has_video){
			if(self->video_width != -1 &&
					self->video_height != -1){
				char *label = g_strdup_printf("%d x %d",
						self->video_width, self->video_height);
				widget = glade_xml_get_widget(selfp->xml, "dimension_label");
				gtk_label_set_text(GTK_LABEL(widget), label);
				g_free(label);
			}
			if(self->video_codec){
				widget = glade_xml_get_widget(selfp->xml, "vc_label");
				gtk_label_set_text(GTK_LABEL(widget), self->video_codec);
			}
			if(self->video_framerate != -1){
				char *label = g_strdup_printf("%d fps",
						self->audio_bitrate);
				widget = glade_xml_get_widget(selfp->xml, "framerate_label");
				gtk_label_set_text(GTK_LABEL(widget), label);
				g_free(label);
			}
		}
		if(self->has_audio){
			if(self->audio_codec){
				widget = glade_xml_get_widget(selfp->xml, "ac_label");
				gtk_label_set_text(GTK_LABEL(widget), self->audio_codec);
			}
			if(self->audio_bitrate != -1){
				char *label = g_strdup_printf("%d kbps",
						self->audio_bitrate / 1000);
				widget = glade_xml_get_widget(selfp->xml, "bitrate_label");
				gtk_label_set_text(GTK_LABEL(widget), label);
				g_free(label);
			}
		}
		if(self->length != -1){
			gint mins = self->length / 60000;
			gint secs = (self->length / 1000) - (mins * 60);
			char *label = g_strdup_printf("%.2d:%.2d", mins, secs);
			widget = glade_xml_get_widget(selfp->xml, "duration_label");
			gtk_label_set_text(GTK_LABEL(widget), label);
			g_free(label);
		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_info_ref_cb (GtkWidget * widget, gpointer unused)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::ref_cb"
{
	
		g_object_ref(G_OBJECT(widget));
		gtk_object_sink(GTK_OBJECT(widget));
		if(GTK_IS_CONTAINER(widget))
			gtk_container_forall(GTK_CONTAINER(widget), self_ref_cb, NULL);
	}}
#undef __GOB_FUNCTION__

static void 
lum_player_info_unref_cb (GtkWidget * widget, gpointer unused)
{
#define __GOB_FUNCTION__ "Lum:Player:Info::unref_cb"
{
	
		g_object_unref(G_OBJECT(widget));
		if(GTK_IS_CONTAINER(widget))
			gtk_container_forall(GTK_CONTAINER(widget), self_unref_cb, NULL);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_player_info_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_get_widget)();
	((void (*)(void))self_load_widget_data)();
	((void (*)(void))self_ref_cb)();
	((void (*)(void))self_unref_cb)();
	___lum_player_info_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

