/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          lum-glplay.gob  -  OpenGL Player Widget
                             -------------------
    begin                : vendredi 07 fvrier 2003
    copyright            : (C) 2002 by Stphane Konstantaropoulos
    email                : ssk01@aber.ac.uk | stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * LumGlplay extends GtkXine:
 * emebds xine in an OpenGL display, playing the video on a cube,
 * sphere or cylinder, with environment mapping or not.
 * The coolest thing.
 * Features slicing to a supported texture size (my poor Voodoo...)
 * Slicing code taken from vo_gl2.c from the mplayer project.
 * All the playing stuff is taken care of by GtkXine.
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-glplay.h"

#include "lum-glplay-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


#include <stdio.h>
#include "rgb2rgb.h"
/* Private functions for snap shot.
 * These codes are mostly taken from xine-ui.
 */

/* internal function use to scale yuv data */
typedef void (*scale_line_func_t) (uint8_t * source, uint8_t * dest,
		int width, int step);

#define PIXSZ 3
/* Holdall structure */
struct prvt_image_s
{
    int     width;
    int     height;
    int     ratio_code;
    int     format;
    uint8_t *y, *u, *v, *yuy2;
    uint8_t *img;

    int     u_width, v_width;
    int     u_height, v_height;

    scale_line_func_t scale_line;
    unsigned long scale_factor;
};

static void
yuy2toyv12 (struct prvt_image_s *image)
{
    gint    i, j, w2;

    /*
     * I420 
     */
    guchar *y = image->y;
    guchar *u = image->u;
    guchar *v = image->v;

    guchar *input = image->yuy2;

    gint    width = image->width;
    gint    height = image->height;

    w2 = width / 2;

    for (i = 0; i < height; i += 2)
    {
	for (j = 0; j < w2; j++)
	{
	    /*
	     * packed YUV 422 is: Y[i] U[i] Y[i+1] V[i] 
	     */
	    *(y++) = *(input++);
	    *(u++) = *(input++);
	    *(y++) = *(input++);
	    *(v++) = *(input++);
	}

	/*
	 * down sampling 
	 */

	for (j = 0; j < w2; j++)
	{
	    /*
	     * skip every second line for U and V 
	     */
	    *(y++) = *(input++);
	    input++;
	    *(y++) = *(input++);
	    input++;
	}
    }
}

/* the texture structure */
struct TexSquare{
	GLubyte *texture;
	GLuint texobj;
	int isTexture;
	GLfloat fx1, fy1, fx2, fy2, fx3, fy3, fx4, fy4;
	GLfloat xcov, ycov;
	int isDirty;
	int dirtyXoff, dirtyYoff, dirtyWidth, dirtyHeight;
};


/* self casting macros */
#define SELF(x) LUM_GLPLAY(x)
#define SELF_CONST(x) LUM_GLPLAY_CONST(x)
#define IS_SELF(x) LUM_IS_GLPLAY(x)
#define TYPE_SELF LUM_TYPE_GLPLAY
#define SELF_CLASS(x) LUM_GLPLAY_CLASS(x)

#define SELF_GET_CLASS(x) LUM_GLPLAY_GET_CLASS(x)

/* self typedefs */
typedef LumGlplay Self;
typedef LumGlplayClass SelfClass;

/* here are local prototypes */
static void lum_glplay_init (LumGlplay * o) G_GNUC_UNUSED;
static void lum_glplay_class_init (LumGlplayClass * c) G_GNUC_UNUSED;
static gboolean ___2_lum_glplay_key_press (LumPlayer * player, GdkEventKey * event) G_GNUC_UNUSED;
static gboolean lum_glplay_initgl (GtkWidget * widget, LumGlplay * self) G_GNUC_UNUSED;
static gboolean lum_glplay_resize (GtkWidget * widget, GtkAllocation * allocation, gpointer data) G_GNUC_UNUSED;
static void lum_glplay_backList (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_cubeList (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_sphereList (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_cylList (LumGlplay * self) G_GNUC_UNUSED;
static gint lum_glplay_draw (gpointer data) G_GNUC_UNUSED;
static void lum_glplay_get_frame (LumGlplay * self) G_GNUC_UNUSED;
static gboolean lum_glplay_get_current_frame_rgb (LumGlplay * self, gint * width_ret, gint * height_ret) G_GNUC_UNUSED;
static void lum_glplay_initTextures (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_resetTexturePointers (LumGlplay * self, guchar * imageSource) G_GNUC_UNUSED;
static void lum_glplay_CalcFlatPoint (LumGlplay * self, int x, int y, GLfloat * px, GLfloat * py) G_GNUC_UNUSED;
static void lum_glplay_setupTextureDirtyArea (LumGlplay * self, int x, int y, int w, int h) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkXineClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new(args...) lum_glplay_new(args)
#define self_initgl(args...) lum_glplay_initgl(args)
#define self_resize(args...) lum_glplay_resize(args)
#define self_backList(args...) lum_glplay_backList(args)
#define self_cubeList(args...) lum_glplay_cubeList(args)
#define self_sphereList(args...) lum_glplay_sphereList(args)
#define self_cylList(args...) lum_glplay_cylList(args)
#define self_draw(args...) lum_glplay_draw(args)
#define self_get_frame(args...) lum_glplay_get_frame(args)
#define self_get_current_frame_rgb(args...) lum_glplay_get_current_frame_rgb(args)
#define self_initTextures(args...) lum_glplay_initTextures(args)
#define self_resetTexturePointers(args...) lum_glplay_resetTexturePointers(args)
#define self_CalcFlatPoint(args...) lum_glplay_CalcFlatPoint(args)
#define self_setupTextureDirtyArea(args...) lum_glplay_setupTextureDirtyArea(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const self_new) (LumConfig * config) = lum_glplay_new;
static gboolean (* const self_initgl) (GtkWidget * widget, LumGlplay * self) = lum_glplay_initgl;
static gboolean (* const self_resize) (GtkWidget * widget, GtkAllocation * allocation, gpointer data) = lum_glplay_resize;
static void (* const self_backList) (LumGlplay * self) = lum_glplay_backList;
static void (* const self_cubeList) (LumGlplay * self) = lum_glplay_cubeList;
static void (* const self_sphereList) (LumGlplay * self) = lum_glplay_sphereList;
static void (* const self_cylList) (LumGlplay * self) = lum_glplay_cylList;
static gint (* const self_draw) (gpointer data) = lum_glplay_draw;
static void (* const self_get_frame) (LumGlplay * self) = lum_glplay_get_frame;
static gboolean (* const self_get_current_frame_rgb) (LumGlplay * self, gint * width_ret, gint * height_ret) = lum_glplay_get_current_frame_rgb;
static void (* const self_initTextures) (LumGlplay * self) = lum_glplay_initTextures;
static void (* const self_resetTexturePointers) (LumGlplay * self, guchar * imageSource) = lum_glplay_resetTexturePointers;
static void (* const self_CalcFlatPoint) (LumGlplay * self, int x, int y, GLfloat * px, GLfloat * py) = lum_glplay_CalcFlatPoint;
static void (* const self_setupTextureDirtyArea) (LumGlplay * self, int x, int y, int w, int h) = lum_glplay_setupTextureDirtyArea;

GType
lum_glplay_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumGlplayClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_glplay_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumGlplay),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_glplay_init,
		};

		type = g_type_register_static (GTK_TYPE_XINE, "LumGlplay", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumGlplay *)g_object_new(lum_glplay_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumGlplay * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumGlplay *
GET_NEW_VARG (const char *first, ...)
{
	LumGlplay *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumGlplay *)g_object_new_valist (lum_glplay_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::finalize"
	LumGlplay *self = LUM_GLPLAY (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	if(self->_priv->area) { ((*(void (*)(void *))gtk_widget_destroy)) (self->_priv->area); self->_priv->area = NULL; }
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_glplay_init (LumGlplay * o)
{
#define __GOB_FUNCTION__ "Lum:Glplay::init"
	o->_priv = g_new0 (LumGlplayPrivate, 1);
	o->_priv->tex_width = 0;
	o->_priv->tex_height = 0;
	o->_priv->image_bytes = 2;
	o->_priv->gl_internal_format = GL_RGB5;
	o->_priv->gl_bitmap_format = GL_RGB;
	o->_priv->gl_bitmap_type = GL_UNSIGNED_SHORT_5_6_5;
	o->_priv->texnumx = 0;
	o->_priv->texnumy = 0;
	o->_priv->memory_x_len = 0;
	o->_priv->memory_x_start_offset = 0;
	o->_priv->raw_line_len = 0;
	o->_priv->texpercx = 0;
	o->_priv->texpercy = 0;
	o->_priv->data = NULL;
	o->_priv->data_local = NULL;
	o->_priv->angle = 0.0;
	o->_priv->ready = TRUE;
	o->_priv->env = TRUE;
	o->_priv->back = TRUE;
	o->_priv->shape = 0;
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_glplay_class_init (LumGlplayClass * c)
{
#define __GOB_FUNCTION__ "Lum:Glplay::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;
	LumPlayerClass *lum_player_class = (LumPlayerClass *)c;

	parent_class = g_type_class_ref (GTK_TYPE_XINE);

	lum_player_class->key_press = ___2_lum_glplay_key_press;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__



GtkWidget * 
lum_glplay_new (LumConfig * config)
{
#define __GOB_FUNCTION__ "Lum:Glplay::new"
	g_return_val_if_fail (config != NULL, (GtkWidget * )0);
	g_return_val_if_fail (LUM_IS_CONFIG (config), (GtkWidget * )0);
{
	
		LumGlplay *self = GET_NEW;

		gint attrlist[] = {
			GDK_GL_RGBA,
			GDK_GL_DOUBLEBUFFER,
			GDK_GL_RED_SIZE, 4,
			GDK_GL_GREEN_SIZE, 4,
			GDK_GL_BLUE_SIZE, 4,
			GDK_GL_DEPTH_SIZE, 16,
			GDK_GL_NONE
			};
		gint attrlist2[] = {
			GDK_GL_RGBA,
			GDK_GL_RED_SIZE, 4,
			GDK_GL_GREEN_SIZE, 4,
			GDK_GL_BLUE_SIZE, 4,
			GDK_GL_DEPTH_SIZE, 16,
			GDK_GL_NONE
			};
	
		if(gdk_gl_query() == FALSE) {
			g_print("OpenGL not supported!\n");
			return NULL;
		}


		if((selfp->area = GTK_GL_AREA(gtk_gl_area_new(attrlist))) == NULL){
			g_print("Error creating GtkGLArea doublebuffered!\n");
			if((selfp->area = 
					GTK_GL_AREA(gtk_gl_area_new(attrlist2))) == NULL){
				g_print("Error creating GtkGLArea singlebuffered!\n");
				return NULL;
			}
		}
		
		gtk_widget_set_events(GTK_WIDGET(selfp->area),
				GDK_EXPOSURE_MASK|
				GDK_KEY_PRESS_MASK|
				GDK_KEY_RELEASE_MASK|
				GDK_BUTTON_PRESS_MASK|
				GDK_BUTTON_RELEASE_MASK|
				GDK_POINTER_MOTION_MASK|
				GDK_POINTER_MOTION_HINT_MASK);

		g_signal_connect(G_OBJECT(self), "size_allocate",
				G_CALLBACK(lum_glplay_resize), NULL);

		g_signal_connect (G_OBJECT(selfp->area), "realize",
                      G_CALLBACK(lum_glplay_initgl), self);

		g_signal_connect(G_OBJECT(self), "delete_event",
				G_CALLBACK(gtk_widget_destroy), self);

		LUM_PLAYER(self)->config = config;
		gtk_xine_load_audio_out_driver(GTK_XINE(self));
		GTK_XINE(self)->_priv->vo_driver =
				xine_open_video_driver (
					GTK_XINE_GET_CLASS(GTK_XINE(self))->xine,
					"none", XINE_VISUAL_TYPE_NONE, NULL);

		GTK_XINE(self)->_priv->stream = xine_stream_new (
				GTK_XINE_GET_CLASS(GTK_XINE(self))->xine,
				GTK_XINE(self)->_priv->ao_driver,
				GTK_XINE(self)->_priv->vo_driver);
		GTK_XINE(self)->_priv->ev_queue =
				xine_event_new_queue (GTK_XINE(self)->_priv->stream);

		gtk_box_pack_start(GTK_BOX(self),
				GTK_WIDGET(selfp->area),
				TRUE, TRUE, 0);

		gtk_widget_show_all(GTK_WIDGET(self));
		return GTK_WIDGET(self);
	}}
#undef __GOB_FUNCTION__

static gboolean 
___2_lum_glplay_key_press (LumPlayer * player, GdkEventKey * event)
#define PARENT_HANDLER(___player,___event) \
	((LUM_PLAYER_CLASS(parent_class)->key_press)? \
		(* LUM_PLAYER_CLASS(parent_class)->key_press)(___player,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Glplay::key_press"
{
	
		LumGlplay *self = LUM_GLPLAY(player);

		switch(event->keyval) {
			case GDK_e:
				selfp->env = !selfp->env;
				break;
			case GDK_b:
				selfp->back = !selfp->back;
				break;
			case GDK_s:
				selfp->shape++ ;
				if(selfp->shape > 3)
					selfp->shape = 0;
				break;
			default:
				return FALSE;
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

static gboolean 
lum_glplay_initgl (GtkWidget * widget, LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::initgl"
{
	
		GtkAllocation alloc = {0, 0, 
				GTK_XINE(self)->_priv->video_width,
				GTK_XINE(self)->_priv->video_height};
		gtk_widget_size_allocate(GTK_WIDGET(self), &alloc);
		lum_glplay_resize(GTK_WIDGET(self), &alloc, NULL);
		alloc = GTK_WIDGET(self)->allocation;
		gtk_widget_size_allocate(GTK_WIDGET(selfp->area), &alloc);
		
		if(gtk_gl_area_make_current(selfp->area) == FALSE)
			return TRUE;

		selfp->data_local = malloc(selfp->image_bytes *
				GTK_XINE(self)->_priv->video_width *	
				GTK_XINE(self)->_priv->video_height);
		memset(selfp->data_local, 128, selfp->image_bytes *
				GTK_XINE(self)->_priv->video_width *	
				GTK_XINE(self)->_priv->video_height);
		selfp->data = selfp->data_local;
		
		selfp->tex_width = GTK_XINE(self)->_priv->video_width;
		selfp->tex_height = GTK_XINE(self)->_priv->video_height;

		lum_glplay_initTextures(self);
		yuv2rgb_init(16, MODE_RGB);
		
		glPixelStorei (GL_UNPACK_ROW_LENGTH, selfp->memory_x_len);

		selfp->list[0] = glGenLists(5);
		selfp->list[1] = selfp->list[0] + 1;
		selfp->list[2] = selfp->list[1] + 1;
		selfp->list[3] = selfp->list[2] + 1;

		selfp->quadratic = gluNewQuadric();
		gluQuadricNormals(selfp->quadratic, GLU_SMOOTH);
		gluQuadricTexture(selfp->quadratic, GL_TRUE);
		glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
		glClearDepth(1.0f);
		glDepthFunc(GL_LEQUAL);
		glEnable(GL_DEPTH_TEST);
		glShadeModel(GL_SMOOTH);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		glEnable(GL_TEXTURE_2D);

		glNewList(selfp->list[BACK], GL_COMPILE);
			lum_glplay_backList(self);
		glEndList();
		glNewList(selfp->list[CUBE], GL_COMPILE);
			lum_glplay_cubeList(self);
		glEndList();
		glNewList(selfp->list[SPHERE], GL_COMPILE);
			lum_glplay_sphereList(self);
		glEndList();
		glNewList(selfp->list[CYL], GL_COMPILE);
			lum_glplay_cylList(self);
		glEndList();

		glFlush();
		
		/* draw every 50 ms, if you can...
		 * We could actually use gtk_idle_add to let the
		 * system set its own speed?
		 */
		gtk_timeout_add(50, lum_glplay_draw, self);

		return TRUE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_glplay_resize (GtkWidget * widget, GtkAllocation * allocation, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Glplay::resize"
	g_return_val_if_fail (widget != NULL, (gboolean )0);
{
	
		LumGlplay *self = LUM_GLPLAY(widget);
		gfloat ratio;
		int w = widget->allocation.width;
		int h = widget->allocation.height;
	
		selfp->ready = FALSE;
		
		gtk_widget_size_allocate(GTK_WIDGET(selfp->area), allocation);
		gtk_widget_size_allocate(GTK_WIDGET(self), allocation);
		gtk_widget_grab_focus(GTK_WIDGET(self));

		if (h == 0)
			h = 1;

		ratio = (gfloat) w / (gfloat) h;

		if (!gtk_gl_area_make_current (selfp->area))
			return TRUE;
		
		glViewport(0, 0, (gint) w, (gint) h);

		/* change to the projection matrix and set our viewing volume. */
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(90.0f, ratio, 0.1f, 100.0f);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glFlush();
		
		selfp->ready = TRUE;
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_backList (LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::backList"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		struct TexSquare *square;
		int i, j;
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho (0, 1, 1, 0, -1.0, 20.0);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
			
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,-20);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,-20);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,-20);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,-20);
				glEnd();
			}
		}
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(90.0f, 
			((float)GTK_XINE(self)->_priv->video_width) /
			((float)GTK_XINE(self)->_priv->video_height), 0.1f, 100.0f);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_cubeList (LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::cubeList"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		struct TexSquare *square;
		int i, j;

		glRotatef (selfp->angle*1.3f, 1.0f, 0.0f, 0.0f);
		glRotatef (selfp->angle*1.1f, 0.0f, 1.0f, 0.0f);
		glRotatef (selfp->angle*1.2f, 0.0f, 0.0f, 1.0f);
		glScalef(15, 15, 15);
		/*front face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,0);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,0);
				glEnd();
			}
		}
		/*back face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
				glEnd();
			}
		}
		/*top face*/
		if(selfp->texnumx == 1 && selfp->texnumy == 1){
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx2,  square->fy2,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx2,  square->fy2,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx1,  square->fy1,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		/*bottom face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx4,  square->fy4,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx3,  square->fy3,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx4,  square->fy4,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		/*left face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx4,  square->fy4,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx1,  square->fy1,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		/*right face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx2,  square->fy2,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx3,  square->fy3,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_sphereList (LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::sphereList"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		glTexParameteri(GL_TEXTURE_2D,
					GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,
					GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

		glBindTexture(GL_TEXTURE_2D, selfp->texgrid->texobj);
		glRotatef (selfp->angle*1.3f, 1.0f, 0.0f, 0.0f);
		glRotatef (selfp->angle*1.1f, 0.0f, 1.0f, 0.0f);
		glRotatef (selfp->angle*1.2f, 0.0f, 0.0f, 1.0f);
		gluSphere(selfp->quadratic,5.0f,20,20);
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_cylList (LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::cylList"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		glBindTexture(GL_TEXTURE_2D, selfp->texgrid->texobj);
		glRotatef (selfp->angle*1.3f, 1.0f, 0.0f, 0.0f);
		glRotatef (selfp->angle*1.1f, 0.0f, 1.0f, 0.0f);
		glRotatef (selfp->angle*1.2f, 0.0f, 0.0f, 1.0f);
		glTranslatef(0.0f,0.0f,-1.5f);
		gluCylinder(selfp->quadratic,2.5f,2.5f,5.0f,32,32);
	}}
#undef __GOB_FUNCTION__

static gint 
lum_glplay_draw (gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Glplay::draw"
{
	
		LumGlplay *self = LUM_GLPLAY(data);
	
		if(!selfp->ready)
			return TRUE;

		if(!gtk_gl_area_make_current(selfp->area))
			return TRUE;

		glEnable(GL_TEXTURE_2D);
		
		lum_glplay_get_frame(self);

		glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		if(selfp->back)
			glCallList(selfp->list[BACK]);

		glLoadIdentity ();
		glTranslatef (0.0f, 0.0f, -10);

		if(selfp->env){
			glEnable(GL_TEXTURE_GEN_S);
			glEnable(GL_TEXTURE_GEN_T);
		}

		glRotatef(selfp->angle*2.3f,1.0f,0.0f,0.0f);
		glRotatef(selfp->angle*1.8f,0.0f,1.0f,0.0f);
		glTranslatef(0.0f,0.0f,10.0f);

		switch(selfp->shape) {
			case 0:
			glCallList(selfp->list[CUBE]);
				break;
			case 1:
				glCallList(selfp->list[SPHERE]);
				break;
			case 2:
				glCallList(selfp->list[CYL]);
				break;
			case 3:
			default:
				break;
		}
		if(selfp->env){
			glDisable(GL_TEXTURE_GEN_S);
			glDisable(GL_TEXTURE_GEN_T);
		}
			
		glFlush ();
		/* swap */
		gtk_gl_area_swap_buffers(selfp->area);

		selfp->angle = selfp->angle + 1.0f;
		if(selfp->angle > 20000.0f)
			selfp->angle = 0.0f;
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_get_frame (LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::get_frame"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		int w = 0, h = 0;
		static int i = 0;
		
		/* Update The Texture */
		if(LUM_PLAYER(self)->status == PLAYER_PLAYING && (++i % 2 == 0)){
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
			glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			
			if(!lum_glplay_get_current_frame_rgb(self, &w, &h))
				return;
			lum_glplay_resetTexturePointers(self, selfp->data);
			lum_glplay_setupTextureDirtyArea(self, 0, 0,
				GTK_XINE(self)->_priv->video_width,
				GTK_XINE(self)->_priv->video_height);
			if(selfp->data){
				int i, j;
				struct TexSquare *square;
				for (i = 0; i < selfp->texnumy; i++){
					for (j = 0; j < selfp->texnumx; j++){
						square = selfp->texgrid + i * selfp->texnumx + j;
						glBindTexture(GL_TEXTURE_2D, square->texobj);
						glTexSubImage2D (GL_TEXTURE_2D, 0, 0, 0,
							square->dirtyWidth,
							square->dirtyHeight, GL_RGB,
							selfp->gl_bitmap_type, square->texture);
					}
				}
			}
		}
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_glplay_get_current_frame_rgb (LumGlplay * self, gint * width_ret, gint * height_ret)
{
#define __GOB_FUNCTION__ "Lum:Glplay::get_current_frame_rgb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_GLPLAY (self), (gboolean )0);
{
	
		GtkXine *gtx = GTK_XINE(self);
		gint    err = 0;
		struct prvt_image_s *image;
		gint    width, height;

	    g_return_val_if_fail (GTK_XINE_GET_CLASS(gtx)->xine, FALSE);
	    g_return_val_if_fail (gtx->_priv->stream != FALSE, 0);

	    image = g_new0 (struct prvt_image_s, 1);
	    if (!image){
		    *width_ret = 0;
		    *height_ret = 0;
		    return FALSE;
		}

	    image->y = image->u = image->v = image->yuy2 = image->img = NULL;

	    width = xine_get_stream_info (gtx->_priv->stream,
		    XINE_STREAM_INFO_VIDEO_WIDTH);
	    height = xine_get_stream_info (gtx->_priv->stream,
		    XINE_STREAM_INFO_VIDEO_HEIGHT);

	    image->img = g_malloc (width * height * 2);

		if (!image->img){
		    *width_ret = 0;
		    *height_ret = 0;

			g_free (image);
			return FALSE;
		}

		err = xine_get_current_frame (gtx->_priv->stream,
				  &image->width, &image->height,
				  &image->ratio_code,
				  &image->format, image->img);

		switch (image->format){
			case XINE_IMGFMT_YV12:
				image->y = image->img;
				image->u = image->img + (image->width * image->height);
				image->v =
					image->img + (image->width * image->height) +
					(image->width * image->height) / 4;
				image->u_width = ((image->width + 1) / 2);
				image->v_width = ((image->width + 1) / 2);
				image->u_height = ((image->height + 1) / 2);
				image->v_height = ((image->height + 1) / 2);
				break;
			case XINE_IMGFMT_YUY2:
				image->yuy2 = image->img;
				image->u_width = ((image->width + 1) / 2);
				image->v_width = ((image->width + 1) / 2);
				image->u_height = ((image->height + 1) / 2);
				image->v_height = ((image->height + 1) / 2);
				break;
		}
		if(image->format == XINE_IMGFMT_YUY2){
			yuy2toyv12(image);
		}
			
		if (!image->img){
			*width_ret = 0;
			*height_ret = 0;

			g_free (image->img);
			g_free (image);

			return FALSE;
	    }

		yuv2rgb (selfp->data, image->y, image->u,
				image->v, image->width, image->height,
				image->width * selfp->image_bytes,
				image->width, image->width / 2);
		
		*width_ret = image->width;
		*height_ret = image->height;

		g_free (image->img);
		g_free (image);

		return TRUE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_initTextures (LumGlplay * self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::initTextures"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		unsigned char *line_1=0, *line_2=0, *mem_start=0;
		struct TexSquare *tsq=0;
		int e_x=0, e_y, s=1, i=0;
		int x=0, y=0;
		GLint format=0;
		GLenum err;
		guint32 image_width = GTK_XINE(self)->_priv->video_width;
		guint32 image_height = GTK_XINE(self)->_priv->video_height;
		/* achieve the 2**e_x:=texture_width, 2**e_y:=texture_height */
		while (s < selfp->tex_width){ s*=2; e_x++; }
		
		selfp->tex_width = s;
		e_y=0; s=1;
		while ( s< selfp->tex_height){ s*=2; e_y++; }
		selfp->tex_height=s;

		/* Test the max texture size */
		do {
			glTexImage2D (GL_PROXY_TEXTURE_2D, 0,
					selfp->gl_internal_format,
					selfp->tex_width, selfp->tex_height,
					0, selfp->gl_bitmap_format,
					selfp->gl_bitmap_type, NULL); 

			glGetTexLevelParameteriv(GL_PROXY_TEXTURE_2D, 0,
					GL_TEXTURE_INTERNAL_FORMAT, &format);

			if (format != selfp->gl_internal_format){
				fprintf (stderr,
					"[gl] Needed texture [%dx%d] too big, trying ",
					selfp->tex_height, selfp->tex_width);

				if (selfp->tex_width > selfp->tex_height){
					e_x--;
					selfp->tex_width = 1;
					for (i = e_x; i > 0; i--)
						selfp->tex_width *= 2;
				} else {
					e_y--;
					selfp->tex_height = 1;
					for (i = e_y; i > 0; i--)
						selfp->tex_height *= 2;
				}
				fprintf (stderr, "[%dx%d] !\n",
					selfp->tex_height, selfp->tex_width);

				if(selfp->tex_width < 64 || selfp->tex_height < 64) {
					fprintf (stderr,
					"GLERROR: Give up .. usable texture size not avaiable,"
					"or texture config error !\n");
					exit(1);
				}
			}
		} while (format != selfp->gl_internal_format &&
					selfp->tex_width > 1 && selfp->tex_height > 1);

		selfp->texnumx = image_width / selfp->tex_width;
		if ((image_width % selfp->tex_width) > 0)
			selfp->texnumx++;

		selfp->texnumy = image_height / selfp->tex_height;
		if ((image_height % selfp->tex_height) > 0)
			selfp->texnumy++;

		printf("[gl2] Creating %dx%d textures of size %dx%d ...\n",
				selfp->texnumx, selfp->texnumy,
				selfp->tex_width,selfp->tex_height);

		/* Allocate the texture memory */
		selfp->texpercx = (float) selfp->tex_width / (float) image_width;
		if (selfp->texpercx > 1.0)
			selfp->texpercx = 1.0;

		selfp->texpercy = (float) selfp->tex_height / (float) image_height;
		if (selfp->texpercy > 1.0)
			selfp->texpercy = 1.0;

		selfp->texgrid = (struct TexSquare *)
			calloc (selfp->texnumx * selfp->texnumy,
					sizeof (struct TexSquare));

		line_1 = selfp->data_local;
		line_2 = (guchar *) selfp->data_local +
				(image_width * selfp->image_bytes);
		mem_start = (guchar *) selfp->data_local;

		selfp->raw_line_len = line_2 - line_1;

		selfp->memory_x_len = selfp->raw_line_len / selfp->image_bytes;

		for (y = 0; y < selfp->texnumy; y++){
			for (x = 0; x < selfp->texnumx; x++){
				tsq = selfp->texgrid + y * selfp->texnumx + x;

				if (x == selfp->texnumx - 1 &&
						image_width % selfp->tex_width)
					tsq->xcov = (float) (image_width %
						selfp->tex_width) / (float) selfp->tex_width;
				else
					tsq->xcov = 1.0;

				if (y == selfp->texnumy - 1 &&
						image_height % selfp->tex_height)
					tsq->ycov = (float) (image_height %
						selfp->tex_height) / (float) selfp->tex_height;
				else
					tsq->ycov = 1.0;

				lum_glplay_CalcFlatPoint(self,x, y,
						&(tsq->fx1), &(tsq->fy1));
				lum_glplay_CalcFlatPoint (self, x + 1, y,
						&(tsq->fx2), &(tsq->fy2));
				lum_glplay_CalcFlatPoint (self, x + 1, y + 1,
						&(tsq->fx3), &(tsq->fy3));
				lum_glplay_CalcFlatPoint (self, x, y + 1,
						&(tsq->fx4), &(tsq->fy4));

	      /* calculate the pixel store data,
     	    to use the machine-bitmap for our texture 
	      */
	 			selfp->memory_x_start_offset = 0 * selfp->image_bytes + 
                              x * selfp->tex_width * selfp->image_bytes;
				tsq->texture = line_1 +
					y * selfp->tex_height * selfp->raw_line_len +  
					selfp->memory_x_start_offset;
					
				tsq->isDirty = TRUE;
				tsq->isTexture= FALSE;
				tsq->texobj=0;
				tsq->dirtyXoff=0; tsq->dirtyYoff=0;
				tsq->dirtyWidth=-1; tsq->dirtyHeight=-1;

				glGenTextures (1, &(tsq->texobj));
				glBindTexture (GL_TEXTURE_2D, tsq->texobj);
				err = glGetError ();
				if(err==GL_INVALID_ENUM){ 
					fprintf (stderr, "GLERROR glBindTexture (glGenText)"
					":= GL_INVALID_ENUM, texnum x=%d, y=%d, texture=%d\n",
					x, y, tsq->texobj);
				} 

				if(glIsTexture(tsq->texobj) == FALSE){
					fprintf (stderr, "GLERROR ain't a texture (glGenText)"
					": texnum x=%d, y=%d, texture=%d\n",
					x, y, tsq->texobj);
				} else {
					tsq->isTexture=TRUE;
				}

				glTexImage2D (GL_TEXTURE_2D, 0,
					selfp->gl_internal_format,
					selfp->tex_width, selfp->tex_height,
					0, selfp->gl_bitmap_format,
					selfp->gl_bitmap_type, NULL); 

				glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_PRIORITY, 1.0);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
			}	/* for all texnumx */
		}  /* for all texnumy */
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_resetTexturePointers (LumGlplay * self, guchar * imageSource)
{
#define __GOB_FUNCTION__ "Lum:Glplay::resetTexturePointers"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		guchar *line_1=0, *line_2=0, *mem_start=0;
		struct TexSquare *tsq=0;
		int x=0, y=0;

		line_1 = imageSource;
		line_2 = (guchar *) imageSource+(
					GTK_XINE(self)->_priv->video_width *
					selfp->image_bytes);

		mem_start = (guchar *) imageSource;

		for (y = 0; y < selfp->texnumy; y++){
			for (x = 0; x < selfp->texnumx; x++){
				tsq = selfp->texgrid + y * selfp->texnumx + x;

	      /* calculate the pixel store data,
	         to use the machine-bitmap for our texture 
	      */
		 	selfp->memory_x_start_offset = 0 * selfp->image_bytes + 
					x * selfp->tex_width * selfp->image_bytes;

			tsq->texture = line_1 +
				y * selfp->tex_height * selfp->raw_line_len +  
				selfp->memory_x_start_offset;
			}	/* for all texnumx */
		}  /* for all texnumy */
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_CalcFlatPoint (LumGlplay * self, int x, int y, GLfloat * px, GLfloat * py)
{
#define __GOB_FUNCTION__ "Lum:Glplay::CalcFlatPoint"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		*px=(float)x*selfp->texpercx;
		if(*px>1.0) *px=1.0;
		*py=(float)y*selfp->texpercy;
		if(*py>1.0) *py=1.0;
	}}
#undef __GOB_FUNCTION__

static void 
lum_glplay_setupTextureDirtyArea (LumGlplay * self, int x, int y, int w, int h)
{
#define __GOB_FUNCTION__ "Lum:Glplay::setupTextureDirtyArea"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_GLPLAY (self));
{
	
		struct TexSquare *square;
		int xi, yi, wd, ht, wh, hh;
		int wdecr, hdecr, xh, yh;
		int image_height = GTK_XINE(self)->_priv->video_height;
		int image_width = GTK_XINE(self)->_priv->video_width;

		wdecr=w; hdecr=h; xh=x; yh=y;

		for (yi = 0; hdecr>0 && yi < selfp->texnumy; yi++){
			if (yi < selfp->texnumy - 1)
				ht = selfp->tex_height;
			else
				ht = image_height - selfp->tex_height * yi;
			xh =x;
			wdecr =w;

			for (xi = 0; wdecr>0 && xi < selfp->texnumx; xi++){
				square = selfp->texgrid + yi * selfp->texnumx + xi;
				
				if (xi < selfp->texnumx - 1)
					wd = selfp->tex_width;
				else
					wd = image_width - selfp->tex_width * xi;

				if( 0 <= xh && xh < wd && 0 <= yh && yh < ht){
					square->isDirty=GL_TRUE;
					wh=(wdecr<wd)?wdecr:wd-xh;
					if(wh<0) wh=0;
						hh=(hdecr<ht)?hdecr:ht-yh;
						if(hh<0) hh=0;

					if(xh<square->dirtyXoff)
						square->dirtyXoff=xh;

					if(yh<square->dirtyYoff)
						square->dirtyYoff=yh;

					square->dirtyWidth = wd-square->dirtyXoff;
					square->dirtyHeight = ht-square->dirtyYoff;
			
					wdecr-=wh;

					if ( xi == selfp->texnumx - 1 )
						hdecr-=hh;
        			}

				xh-=wd;
				if(xh<0) xh=0;
			}
			yh-=ht;
			if(yh<0) yh=0;
		}
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_glplay_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_initgl)();
	((void (*)(void))self_resize)();
	((void (*)(void))self_backList)();
	((void (*)(void))self_cubeList)();
	((void (*)(void))self_sphereList)();
	((void (*)(void))self_cylList)();
	((void (*)(void))self_draw)();
	((void (*)(void))self_get_frame)();
	((void (*)(void))self_get_current_frame_rgb)();
	((void (*)(void))self_initTextures)();
	((void (*)(void))self_resetTexturePointers)();
	((void (*)(void))self_CalcFlatPoint)();
	((void (*)(void))self_setupTextureDirtyArea)();
	___lum_glplay_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

