/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                         lum-engine.gob  -  Lumiere Engine 
                             -------------------
    begin                : Tue dec 2 02:08:47 BST 2003
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.7 $
 * $Date: 2004/03/27 00:14:31 $
 *
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "lum-engine.h"

#include "lum-engine-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


/* Drag'n Drop target table for the video window */
static const GtkTargetEntry target_table [] =
{
	{ "STRING",        0, TARGET_STRING },
	{ "text/plain",    0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
	{ "GTK_TREE_MODEL_ROW", GTK_TARGET_SAME_WIDGET, 0 }
};


static const GEnumValue _lum_engine_target_values[] = {
	{ TARGET_STRING, "TARGET_STRING", "string" },
	{ TARGET_URL, "TARGET_URL", "url" },
	{ 0, NULL, NULL }
};

GType
lum_engine_target_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumEngineTarget", _lum_engine_target_values);
	return type;
}

static const GEnumValue _lum_engine_prev_values[] = {
	{ PREV_NONE, "PREV_NONE", "none" },
	{ PREV_VIDEO, "PREV_VIDEO", "video" },
	{ PREV_VFX, "PREV_VFX", "vfx" },
	{ PREV_AUDIO, "PREV_AUDIO", "audio" },
	{ 0, NULL, NULL }
};

GType
lum_engine_prev_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumEnginePrev", _lum_engine_prev_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_ENGINE(x)
#define SELF_CONST(x) LUM_ENGINE_CONST(x)
#define IS_SELF(x) LUM_IS_ENGINE(x)
#define TYPE_SELF LUM_TYPE_ENGINE
#define SELF_CLASS(x) LUM_ENGINE_CLASS(x)

#define SELF_GET_CLASS(x) LUM_ENGINE_GET_CLASS(x)

/* self typedefs */
typedef LumEngine Self;
typedef LumEngineClass SelfClass;

/* here are local prototypes */
static void lum_engine_class_init (LumEngineClass * c) G_GNUC_UNUSED;
static void lum_engine_init (LumEngine * self) G_GNUC_UNUSED;
static void ___3_lum_engine_dispose (GObject * object) G_GNUC_UNUSED;
static GList * lum_engine_check_dir (const gchar * uri) G_GNUC_UNUSED;
static gboolean lum_engine_video_window_delete_cb (GtkWidget * widget, GdkEvent * event, gpointer user_data) G_GNUC_UNUSED;
static void lum_engine_playback_finished_cb (LumPlayer * player, gpointer data) G_GNUC_UNUSED;
static void lum_engine_player_status_changed_cb (LumPlayer * player, gpointer data) G_GNUC_UNUSED;
static gboolean lum_engine_update_timer_cb (LumPlayer * player, gpointer data) G_GNUC_UNUSED;
static gboolean lum_engine_update_position_cb (LumPlayer * player, gpointer data) G_GNUC_UNUSED;
static void lum_engine_volume_changed_cb (LumPlayer * player, double volume, Self * self) G_GNUC_UNUSED;
static void lum_engine_new_activate_cb (GtkMenuItem * button, Self * self) G_GNUC_UNUSED;
static void lum_engine_vfx_activate_cb (GtkCheckMenuItem * button, Self * self) G_GNUC_UNUSED;
static void lum_engine_controls_activate_cb (GtkMenuItem * button, Self * self) G_GNUC_UNUSED;
static void lum_engine_properties_activate_cb (GtkMenuItem * button, Self * self) G_GNUC_UNUSED;
static void lum_engine_close_activate_cb (GtkMenuItem * button, Self * self) G_GNUC_UNUSED;
static void lum_engine_play_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_engine_stop_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_engine_next_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_engine_prev_activate_cb (GtkMenuItem * menuitem, gpointer data) G_GNUC_UNUSED;
static void lum_engine_player_drag_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, Self * self) G_GNUC_UNUSED;
static gboolean lum_engine_key_press_cb (GtkWidget * widget, GdkEventKey * event, Self * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new() lum_engine_new()
#define self_get_skin(args...) lum_engine_get_skin(args)
#define self_load_uri(args...) lum_engine_load_uri(args)
#define self_enqueue(args...) lum_engine_enqueue(args)
#define self_iconify(args...) lum_engine_iconify(args)
#define self_set_volume(args...) lum_engine_set_volume(args)
#define self_dec_vol(args...) lum_engine_dec_vol(args)
#define self_inc_vol(args...) lum_engine_inc_vol(args)
#define self_mute(args...) lum_engine_mute(args)
#define self_show_info(args...) lum_engine_show_info(args)
#define self_do_popup(args...) lum_engine_do_popup(args)
#define self_switch_timer_mode(args...) lum_engine_switch_timer_mode(args)
#define self_can_seek(args...) lum_engine_can_seek(args)
#define self_fwd10(args...) lum_engine_fwd10(args)
#define self_back10(args...) lum_engine_back10(args)
#define self_close(args...) lum_engine_close(args)
#define self_prev(args...) lum_engine_prev(args)
#define self_next(args...) lum_engine_next(args)
#define self_play(args...) lum_engine_play(args)
#define self_pause(args...) lum_engine_pause(args)
#define self_stop(args...) lum_engine_stop(args)
#define self_get_shuffle(args...) lum_engine_get_shuffle(args)
#define self_set_shuffle(args...) lum_engine_set_shuffle(args)
#define self_get_repeat(args...) lum_engine_get_repeat(args)
#define self_set_repeat(args...) lum_engine_set_repeat(args)
#define self_get_playlist_visible(args...) lum_engine_get_playlist_visible(args)
#define self_set_playlist_visible(args...) lum_engine_set_playlist_visible(args)
#define self_get_video_window_visible(args...) lum_engine_get_video_window_visible(args)
#define self_set_video_window_visible(args...) lum_engine_set_video_window_visible(args)
#define self_get_list(args...) lum_engine_get_list(args)
#define self_play_now(args...) lum_engine_play_now(args)
#define self_set_position(args...) lum_engine_set_position(args)
#define self_show_fileselector(args...) lum_engine_show_fileselector(args)
#define self_open_dvd(args...) lum_engine_open_dvd(args)
#define self_open_cdda(args...) lum_engine_open_cdda(args)
#define self_check_dir(args...) lum_engine_check_dir(args)
#define self_open_activate_cb(args...) lum_engine_open_activate_cb(args)
#define self_open_audio_cd_activate_cb(args...) lum_engine_open_audio_cd_activate_cb(args)
#define self_open_dvd_activate_cb(args...) lum_engine_open_dvd_activate_cb(args)
#define self_video_window_delete_cb(args...) lum_engine_video_window_delete_cb(args)
#define self_playlist_delete_cb(args...) lum_engine_playlist_delete_cb(args)
#define self_playback_finished_cb(args...) lum_engine_playback_finished_cb(args)
#define self_player_status_changed_cb(args...) lum_engine_player_status_changed_cb(args)
#define self_update_timer_cb(args...) lum_engine_update_timer_cb(args)
#define self_update_position_cb(args...) lum_engine_update_position_cb(args)
#define self_volume_changed_cb(args...) lum_engine_volume_changed_cb(args)
#define self_new_activate_cb(args...) lum_engine_new_activate_cb(args)
#define self_vfx_activate_cb(args...) lum_engine_vfx_activate_cb(args)
#define self_controls_activate_cb(args...) lum_engine_controls_activate_cb(args)
#define self_properties_activate_cb(args...) lum_engine_properties_activate_cb(args)
#define self_close_activate_cb(args...) lum_engine_close_activate_cb(args)
#define self_play_activate_cb(args...) lum_engine_play_activate_cb(args)
#define self_stop_activate_cb(args...) lum_engine_stop_activate_cb(args)
#define self_next_activate_cb(args...) lum_engine_next_activate_cb(args)
#define self_prev_activate_cb(args...) lum_engine_prev_activate_cb(args)
#define self_player_drag_received_cb(args...) lum_engine_player_drag_received_cb(args)
#define self_key_press_cb(args...) lum_engine_key_press_cb(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static LumEngine * (* const self_new) (void) = lum_engine_new;
static GtkWindow * (* const self_get_skin) (LumEngine * self) = lum_engine_get_skin;
static void (* const self_load_uri) (LumEngine * self, const gchar * uri) = lum_engine_load_uri;
static void (* const self_enqueue) (LumEngine * self, const gchar * uri) = lum_engine_enqueue;
static void (* const self_iconify) (LumEngine * self) = lum_engine_iconify;
static void (* const self_set_volume) (LumEngine * self, gdouble volume) = lum_engine_set_volume;
static void (* const self_dec_vol) (LumEngine * self) = lum_engine_dec_vol;
static void (* const self_inc_vol) (LumEngine * self) = lum_engine_inc_vol;
static void (* const self_mute) (LumEngine * self) = lum_engine_mute;
static void (* const self_show_info) (LumEngine * self) = lum_engine_show_info;
static void (* const self_do_popup) (LumEngine * self, GdkEventButton * event) = lum_engine_do_popup;
static void (* const self_switch_timer_mode) (LumEngine * self) = lum_engine_switch_timer_mode;
static gboolean (* const self_can_seek) (LumEngine * self) = lum_engine_can_seek;
static void (* const self_fwd10) (LumEngine * self) = lum_engine_fwd10;
static void (* const self_back10) (LumEngine * self) = lum_engine_back10;
static void (* const self_close) (LumEngine * self) = lum_engine_close;
static void (* const self_prev) (LumEngine * self) = lum_engine_prev;
static void (* const self_next) (LumEngine * self) = lum_engine_next;
static void (* const self_play) (LumEngine * self) = lum_engine_play;
static void (* const self_pause) (LumEngine * self) = lum_engine_pause;
static void (* const self_stop) (LumEngine const * self) = lum_engine_stop;
static gboolean (* const self_get_shuffle) (LumEngine const * self) = lum_engine_get_shuffle;
static void (* const self_set_shuffle) (LumEngine const * self, gboolean shuffle) = lum_engine_set_shuffle;
static gboolean (* const self_get_repeat) (LumEngine const * self) = lum_engine_get_repeat;
static void (* const self_set_repeat) (LumEngine const * self, gboolean repeat) = lum_engine_set_repeat;
static gboolean (* const self_get_playlist_visible) (LumEngine const * self) = lum_engine_get_playlist_visible;
static void (* const self_set_playlist_visible) (LumEngine const * self, gboolean visible) = lum_engine_set_playlist_visible;
static gboolean (* const self_get_video_window_visible) (LumEngine * self) = lum_engine_get_video_window_visible;
static void (* const self_set_video_window_visible) (LumEngine const * self, gboolean visible) = lum_engine_set_video_window_visible;
static GList * (* const self_get_list) (LumEngine * self) = lum_engine_get_list;
static void (* const self_play_now) (LumEngine * self, LumPlayerInfo * info, const gchar * uri) = lum_engine_play_now;
static void (* const self_set_position) (LumEngine * self, gdouble position) = lum_engine_set_position;
static void (* const self_show_fileselector) (LumEngine * self) = lum_engine_show_fileselector;
static void (* const self_open_dvd) (LumEngine * self) = lum_engine_open_dvd;
static void (* const self_open_cdda) (LumEngine * self) = lum_engine_open_cdda;
static GList * (* const self_check_dir) (const gchar * uri) = lum_engine_check_dir;
static void (* const self_open_activate_cb) (GtkMenuItem * button, LumEngine * self) = lum_engine_open_activate_cb;
static void (* const self_open_audio_cd_activate_cb) (GtkMenuItem * button, LumEngine * self) = lum_engine_open_audio_cd_activate_cb;
static void (* const self_open_dvd_activate_cb) (GtkMenuItem * button, LumEngine * self) = lum_engine_open_dvd_activate_cb;
static gboolean (* const self_video_window_delete_cb) (GtkWidget * widget, GdkEvent * event, gpointer user_data) = lum_engine_video_window_delete_cb;
static gboolean (* const self_playlist_delete_cb) (GtkWidget * widget, GdkEvent * event, gpointer user_data) = lum_engine_playlist_delete_cb;
static void (* const self_playback_finished_cb) (LumPlayer * player, gpointer data) = lum_engine_playback_finished_cb;
static void (* const self_player_status_changed_cb) (LumPlayer * player, gpointer data) = lum_engine_player_status_changed_cb;
static gboolean (* const self_update_timer_cb) (LumPlayer * player, gpointer data) = lum_engine_update_timer_cb;
static gboolean (* const self_update_position_cb) (LumPlayer * player, gpointer data) = lum_engine_update_position_cb;
static void (* const self_volume_changed_cb) (LumPlayer * player, double volume, Self * self) = lum_engine_volume_changed_cb;
static void (* const self_new_activate_cb) (GtkMenuItem * button, Self * self) = lum_engine_new_activate_cb;
static void (* const self_vfx_activate_cb) (GtkCheckMenuItem * button, Self * self) = lum_engine_vfx_activate_cb;
static void (* const self_controls_activate_cb) (GtkMenuItem * button, Self * self) = lum_engine_controls_activate_cb;
static void (* const self_properties_activate_cb) (GtkMenuItem * button, Self * self) = lum_engine_properties_activate_cb;
static void (* const self_close_activate_cb) (GtkMenuItem * button, Self * self) = lum_engine_close_activate_cb;
static void (* const self_play_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_engine_play_activate_cb;
static void (* const self_stop_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_engine_stop_activate_cb;
static void (* const self_next_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_engine_next_activate_cb;
static void (* const self_prev_activate_cb) (GtkMenuItem * menuitem, gpointer data) = lum_engine_prev_activate_cb;
static void (* const self_player_drag_received_cb) (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, Self * self) = lum_engine_player_drag_received_cb;
static gboolean (* const self_key_press_cb) (GtkWidget * widget, GdkEventKey * event, Self * self) = lum_engine_key_press_cb;

GType
lum_engine_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumEngineClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_engine_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumEngine),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_engine_init,
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumEngine", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumEngine *)g_object_new(lum_engine_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumEngine * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumEngine *
GET_NEW_VARG (const char *first, ...)
{
	LumEngine *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumEngine *)g_object_new_valist (lum_engine_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Engine::finalize"
	LumEngine *self = LUM_ENGINE (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_engine_class_init (LumEngineClass * c)
{
#define __GOB_FUNCTION__ "Lum:Engine::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->dispose = ___3_lum_engine_dispose;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_engine_init (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::init"
	self->_priv = g_new0 (LumEnginePrivate, 1);
	self->_priv->skin = lum_skin_new(self);
	self->_priv->playlist = lum_playlist_new(self);
	self->_priv->video_window = GTK_WINDOW(gtk_window_new(GTK_WINDOW_TOPLEVEL));
	self->_priv->popup_menu = NULL;
	self->_priv->player = NULL;
	self->_priv->player_type = PLAYER_XINE;
	self->_priv->prev = PREV_NONE;
	self->_priv->repeat = FALSE;
 {

		/* TODO allow type changes when other backends are ready
		
		selfp->player_type = lum_shell_get_config(lum_shell)->backend;
		switch(selfp->player_type){
			case PLAYER_GL:
#ifdef ENABLE_GLPLAY
				selfp->player = LUM_PLAYER(lum_glplay_new(lum_config_new()));
				break;
#endif
			case PLAYER_MPLAYER:
#ifdef ENABLE_MPLAYER
				selfp->player = LUM_PLAYER(gtk_player_new(lum_config_new(), FALSE));
				break;
#endif
			case PLAYER_XINE:
			default:
#ifdef ENABLE_XINE
				selfp->player = LUM_PLAYER(gtk_xine_new(lum_config_new(), TRUE));
				g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx", FALSE,
						"LumPlayer::repeat", FALSE,
						"LumPlayer::can_fullscreen", TRUE, NULL, NULL);
				break;
#endif
		}
		*/
		selfp->player = LUM_PLAYER(gtk_xine_new(
					lum_shell_get_config(lum_shell)));
		g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx", FALSE,
			"LumPlayer::repeat", FALSE, "LumPlayer::can_fullscreen", TRUE,
			"LumPlayer::can_hide_bars", FALSE,
			NULL, NULL);
		gtk_container_add(GTK_CONTAINER(selfp->video_window),
				GTK_WIDGET(selfp->player));
		g_object_set(G_OBJECT(selfp->video_window),
				"GtkWindow::window_position", GTK_WIN_POS_CENTER,
				NULL, NULL);
		g_object_set(G_OBJECT(selfp->playlist),
				"GtkWindow::window_position", GTK_WIN_POS_MOUSE,
				NULL, NULL);
		gtk_widget_show_all(GTK_WIDGET(selfp->video_window));
		gtk_widget_hide(GTK_WIDGET(selfp->video_window));
		gtk_window_set_resizable(selfp->video_window, FALSE);
		gtk_drag_dest_set(GTK_WIDGET(selfp->video_window),
				GTK_DEST_DEFAULT_ALL, target_table,
				G_N_ELEMENTS (target_table), GDK_ACTION_COPY);
		g_signal_connect(G_OBJECT(selfp->video_window), "drag-data-received",
				G_CALLBACK(self_player_drag_received_cb), self);
		g_signal_connect(G_OBJECT(selfp->video_window), "delete-event",
				G_CALLBACK(self_video_window_delete_cb), self);
		g_signal_connect(G_OBJECT(selfp->video_window), "key-press-event",
				G_CALLBACK(self_key_press_cb), self);
		gtk_widget_show(GTK_WIDGET(selfp->skin));
		g_signal_connect(G_OBJECT(selfp->skin), "key-press-event",
				G_CALLBACK(self_key_press_cb), self);
		gtk_widget_show_all(GTK_WIDGET(selfp->playlist));
		gtk_window_resize(GTK_WINDOW(selfp->playlist), 200, 300);
		gtk_widget_hide(GTK_WIDGET(selfp->playlist));
		g_signal_connect(G_OBJECT(selfp->playlist), "delete-event",
				G_CALLBACK(self_playlist_delete_cb), self);
		g_signal_connect(G_OBJECT(selfp->playlist), "key-press-event",
				G_CALLBACK(self_key_press_cb), self);
		/* Popup menu */
		GladeXML *xml;
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"engine_menu", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		selfp->popup_menu = glade_xml_get_widget(xml, "engine_menu_menu");
		g_signal_connect(glade_xml_get_widget(xml, "prefs"),
		    "activate", G_CALLBACK(lum_shell_prefs_activate_cb), lum_shell);
		g_signal_connect(glade_xml_get_widget(xml, "properties"),
		    "activate", G_CALLBACK(self_properties_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "about"),
		    "activate", G_CALLBACK(lum_shell_about_activate_cb), lum_shell);
		g_signal_connect(glade_xml_get_widget(xml, "quit"),
		    "activate", G_CALLBACK(lum_shell_quit_activate_cb), lum_shell);
		g_signal_connect(glade_xml_get_widget(xml, "help"),
		    "activate", G_CALLBACK(lum_shell_help_activate_cb), lum_shell);
		g_signal_connect(glade_xml_get_widget(xml, "open"),
			    "activate", G_CALLBACK(self_open_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "open_dvd"),
			    "activate", G_CALLBACK(self_open_dvd_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "open_audio_cd"),
			    "activate", G_CALLBACK(self_open_audio_cd_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "new_engine"),
			    "activate", G_CALLBACK(self_new_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "vfx"),
			    "activate", G_CALLBACK(self_vfx_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "controls"),
			    "activate", G_CALLBACK(self_controls_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "window_close"),
			    "activate", G_CALLBACK(self_close_activate_cb), self);

		g_object_unref(G_OBJECT(xml));

		/* video window popup menu */
		xml = glade_xml_new(DATADIR"/lumiere/lumiere.glade",
				"player_menu", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		lum_player_set_popup_menu(selfp->player,
				GTK_MENU(glade_xml_get_widget(xml, "player_menu_menu")));
		g_signal_connect(glade_xml_get_widget(xml, "play_pause"),
			    "activate", G_CALLBACK(self_play_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "stop"),
			    "activate", G_CALLBACK(self_stop_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "next"),
			    "activate", G_CALLBACK(self_next_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "previous"),
			    "activate", G_CALLBACK(self_prev_activate_cb), self);
		g_signal_connect(glade_xml_get_widget(xml, "properties"),
			    "activate", G_CALLBACK(self_properties_activate_cb), self);
		g_object_unref(G_OBJECT(xml));

		g_object_ref(lum_shell);
		lum_session_add_engine(lum_shell_get_session(lum_shell), self);
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



LumEngine * 
lum_engine_new (void)
{
#define __GOB_FUNCTION__ "Lum:Engine::new"
{
	
		Self *self = GET_NEW;
		g_signal_connect(G_OBJECT(selfp->player),"playbackfinished",
				G_CALLBACK(self_playback_finished_cb), self);
		g_signal_connect_after(G_OBJECT(selfp->player),"update_timer",
				G_CALLBACK(self_update_timer_cb), self);
		g_signal_connect(G_OBJECT(selfp->player),"update_position",
				G_CALLBACK(self_update_position_cb), self);
		g_signal_connect(G_OBJECT(selfp->player),"status_changed",
				G_CALLBACK(self_player_status_changed_cb), self);
		g_signal_connect(G_OBJECT(selfp->player),"volume_changed",
				G_CALLBACK(self_volume_changed_cb), self);
		return self;
	}}
#undef __GOB_FUNCTION__

static void 
___3_lum_engine_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Engine::dispose"
{
	
#ifdef DEBUG
		printf(__FILE__ ": dispose\n");
#endif
		g_return_if_fail(lum_shell != NULL);
		
		Self *self = SELF(object);
		lum_session_remove_engine(lum_shell_get_session(lum_shell), self);
		lum_player_stop(selfp->player);

		if(selfp->skin){
			gtk_widget_hide(GTK_WIDGET(selfp->skin));
			gtk_widget_destroy(GTK_WIDGET(selfp->skin));
			selfp->skin = NULL;
		}
		if(selfp->playlist){
			gtk_widget_hide(GTK_WIDGET(selfp->playlist));
			gtk_widget_destroy(GTK_WIDGET(selfp->playlist));
			selfp->playlist = NULL;
		}
		if(selfp->video_window){
			gtk_widget_hide(GTK_WIDGET(selfp->video_window));
			gtk_widget_destroy(GTK_WIDGET(selfp->video_window));
			selfp->video_window = NULL;
		}
		if(selfp->popup_menu){
			gtk_widget_hide(GTK_WIDGET(selfp->popup_menu));
			gtk_widget_destroy(GTK_WIDGET(selfp->popup_menu));
			selfp->popup_menu = NULL;
		}
		lum_shell_set_tip(lum_shell, NULL);
		g_object_unref(lum_shell);
		PARENT_HANDLER(object);
#ifdef DEBUG
		printf(__FILE__ ": disposed\n");
#endif
	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

GtkWindow * 
lum_engine_get_skin (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::get_skin"
	g_return_val_if_fail (self != NULL, (GtkWindow * )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (GtkWindow * )0);
{
		return GTK_WINDOW(selfp->skin); }}
#undef __GOB_FUNCTION__

/**
 * lum_engine_load_uri:
 * clear the playlist and load this uri
 **/
void 
lum_engine_load_uri (LumEngine * self, const gchar * uri)
{
#define __GOB_FUNCTION__ "Lum:Engine::load_uri"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
	g_return_if_fail (uri != NULL);
{
	
		lum_playlist_clear(selfp->playlist);
		self_enqueue(self, uri);
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_enqueue (LumEngine * self, const gchar * uri)
{
#define __GOB_FUNCTION__ "Lum:Engine::enqueue"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
	g_return_if_fail (uri != NULL);
{
	
		GList *tmp;
		LumPlayerInfo *info = NULL;

		if((tmp = self_check_dir(uri))){
			GList *list;			
			for(list = tmp; list != NULL; list = list->next){
				if((info = LUM_PLAYER_INFO(gtk_xine_get_info(
						(gchar*)list->data))))
					lum_playlist_add(selfp->playlist,
							(gchar*)list->data, info);
				g_free(list->data);
			}
			g_list_free(tmp);
		} else {
			if((info = LUM_PLAYER_INFO(gtk_xine_get_info(uri))))
				lum_playlist_add(selfp->playlist, uri, info);
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_iconify (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::iconify"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(gdk_window_get_state(GTK_WIDGET(selfp->skin)->window)
					== GDK_WINDOW_STATE_ICONIFIED){
			gtk_window_present(GTK_WINDOW(selfp->skin));
			gtk_window_deiconify(GTK_WINDOW(selfp->skin));
			if(gdk_window_get_state(GTK_WIDGET(selfp->video_window)->window)
						== GDK_WINDOW_STATE_ICONIFIED)
				gtk_window_present(selfp->video_window);
				gtk_window_deiconify(selfp->video_window);
			if(gdk_window_get_state(GTK_WIDGET(selfp->playlist)->window)
						== GDK_WINDOW_STATE_ICONIFIED)
				gtk_window_present(GTK_WINDOW(selfp->playlist));
				gtk_window_deiconify(GTK_WINDOW(selfp->playlist));
		} else {
			gtk_window_iconify(GTK_WINDOW(selfp->skin));
			gtk_window_iconify(selfp->video_window);
			gtk_window_iconify(GTK_WINDOW(selfp->playlist));
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_set_volume (LumEngine * self, gdouble volume)
{
#define __GOB_FUNCTION__ "Lum:Engine::set_volume"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(volume > 100)
			volume = 100;
		else if(volume < 0)
			volume = 0;
		lum_player_set_volume(selfp->player, volume);
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_dec_vol (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::dec_vol"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		self_set_volume(self, lum_player_get_volume(selfp->player) - 10); }}
#undef __GOB_FUNCTION__

void 
lum_engine_inc_vol (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::inc_vol"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		self_set_volume(self, lum_player_get_volume(selfp->player) + 10); }}
#undef __GOB_FUNCTION__

void 
lum_engine_mute (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::mute"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		gboolean tmp;
		g_object_get(G_OBJECT(selfp->player), "LumPlayer::mute",
				&tmp, NULL, NULL);
		g_object_set(G_OBJECT(selfp->player), "LumPlayer::mute",
				!tmp, NULL, NULL);
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_show_info (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::show_info"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		lum_util_show_props_window(
				lum_playlist_get_active_info(selfp->playlist));
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_do_popup (LumEngine * self, GdkEventButton * event)
{
#define __GOB_FUNCTION__ "Lum:Engine::do_popup"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(event)
			gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, event->button, event->time);
		else
			gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, 1, gtk_get_current_event_time());
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_switch_timer_mode (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::switch_timer_mode"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
}
#undef __GOB_FUNCTION__

gboolean 
lum_engine_can_seek (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::can_seek"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
{
		return lum_player_is_seekable(selfp->player); }}
#undef __GOB_FUNCTION__

void 
lum_engine_fwd10 (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::fwd10"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
}
#undef __GOB_FUNCTION__

void 
lum_engine_back10 (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::back10"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
}
#undef __GOB_FUNCTION__

void 
lum_engine_close (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::close"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		g_object_unref(G_OBJECT(self)); }}
#undef __GOB_FUNCTION__

void 
lum_engine_prev (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::prev"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(lum_playlist_has_prev(selfp->playlist))
			lum_playlist_prev(selfp->playlist);
		else {
			lum_playlist_prev(selfp->playlist);
			self_play(self);
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_next (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::next"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(lum_playlist_has_next(selfp->playlist))
			lum_playlist_next(selfp->playlist);
		else {
			lum_playlist_next(selfp->playlist);
			self_play(self);
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_play (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::play"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		self_play_now(self,lum_playlist_get_active_info(selfp->playlist),
				lum_playlist_get_active_uri(selfp->playlist));
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_pause (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::pause"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(selfp->player->status == PLAYER_PLAYING ||
				selfp->player->status == PLAYER_PAUSED){
			lum_player_play_pause(selfp->player);	
		}
		else if(selfp->player->status == PLAYER_STOPPED){
			self_play_now(self,lum_playlist_get_active_info(selfp->playlist),
				lum_playlist_get_active_uri(selfp->playlist));
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_stop (LumEngine const * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::stop"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		lum_player_stop(selfp->player); }}
#undef __GOB_FUNCTION__

gboolean 
lum_engine_get_shuffle (LumEngine const * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::get_shuffle"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
{
		return FALSE; }}
#undef __GOB_FUNCTION__

void 
lum_engine_set_shuffle (LumEngine const * self, gboolean shuffle)
{
#define __GOB_FUNCTION__ "Lum:Engine::set_shuffle"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
}
#undef __GOB_FUNCTION__

gboolean 
lum_engine_get_repeat (LumEngine const * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::get_repeat"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
{
		return selfp->repeat; }}
#undef __GOB_FUNCTION__

void 
lum_engine_set_repeat (LumEngine const * self, gboolean repeat)
{
#define __GOB_FUNCTION__ "Lum:Engine::set_repeat"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		selfp->repeat = repeat; }}
#undef __GOB_FUNCTION__

gboolean 
lum_engine_get_playlist_visible (LumEngine const * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::get_playlist_visible"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
{
		return GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->playlist)); }}
#undef __GOB_FUNCTION__

void 
lum_engine_set_playlist_visible (LumEngine const * self, gboolean visible)
{
#define __GOB_FUNCTION__ "Lum:Engine::set_playlist_visible"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(visible)
			gtk_widget_show(GTK_WIDGET(selfp->playlist));
		else
			gtk_widget_hide(GTK_WIDGET(selfp->playlist));
	}}
#undef __GOB_FUNCTION__

gboolean 
lum_engine_get_video_window_visible (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::get_video_window_visible"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (gboolean )0);
{
		return GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window)); }}
#undef __GOB_FUNCTION__

void 
lum_engine_set_video_window_visible (LumEngine const * self, gboolean visible)
{
#define __GOB_FUNCTION__ "Lum:Engine::set_video_window_visible"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(visible)
			gtk_widget_show_all(GTK_WIDGET(selfp->video_window));
		else
			gtk_widget_hide(GTK_WIDGET(selfp->video_window));
	}}
#undef __GOB_FUNCTION__

GList * 
lum_engine_get_list (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::get_list"
	g_return_val_if_fail (self != NULL, (GList * )0);
	g_return_val_if_fail (LUM_IS_ENGINE (self), (GList * )0);
{
		return lum_playlist_get_list(selfp->playlist); }}
#undef __GOB_FUNCTION__

void 
lum_engine_play_now (LumEngine * self, LumPlayerInfo * info, const gchar * uri)
{
#define __GOB_FUNCTION__ "Lum:Engine::play_now"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
	g_return_if_fail (info != NULL);
	g_return_if_fail (LUM_IS_PLAYER_INFO (info));
	g_return_if_fail (uri != NULL);
{
	
		char *info_text = NULL;
		char *unescaped = NULL;
#ifdef DEBUG
		printf(__FILE__ ": play now\n");
#endif
		lum_player_open_file(selfp->player, uri, info);
		if(info->title && info->artist){
			info_text = g_strdup_printf("%s - %s",
						g_locale_to_utf8(info->artist,
							-1, NULL, NULL, NULL),
						g_locale_to_utf8(info->title,
							-1, NULL, NULL, NULL));
		} else {
			unescaped = gnome_vfs_unescape_string_for_display(
						g_path_get_basename (uri));
			info_text = g_filename_to_utf8 (unescaped,
					-1, NULL, NULL, NULL);
			if (info_text == NULL)
				info_text = g_locale_to_utf8 (unescaped,
						-1, NULL, NULL, NULL);
			if (info_text == NULL)
				info_text = g_strdup(unescaped);
			g_free (unescaped);
		}

		lum_skin_set_info_text(selfp->skin, info_text);
		lum_shell_set_tip(lum_shell, info_text);

		g_free(info_text);
		
		if(info->audio_bitrate != -1){
			info_text = g_strdup_printf("%d", info->audio_bitrate);
			lum_skin_set_rate_text(selfp->skin, info_text);
			g_free(info_text);
		}
		else
			lum_skin_set_rate_text(selfp->skin, "?");
		
		if(info->audio_samplerate != -1){
			info_text = g_strdup_printf("%d", info->audio_samplerate);
			lum_skin_set_freq_text(selfp->skin, info_text);
			g_free(info_text);
		}
		else
			lum_skin_set_rate_text(selfp->skin, "?");
		lum_skin_set_channels(selfp->skin, info->audio_channels);

		gtk_xine_set_reparent(GTK_XINE(selfp->player),
				GTK_WIDGET(selfp->skin)->window);
//		g_object_set(G_OBJECT(selfp->player), 
//				"GtkXine::show_vfx_embed", TRUE, NULL, NULL);
			
		gboolean vfx = FALSE;
		g_object_get(G_OBJECT(selfp->player), "GtkXine::show_vfx", &vfx, NULL, NULL);
		if(info->has_video){
			g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", TRUE, NULL, NULL);
			if(selfp->prev == PREV_NONE || selfp->prev == PREV_AUDIO){
				gtk_window_set_resizable(selfp->video_window, TRUE);
				gtk_window_resize(selfp->video_window, info->video_width,
						info->video_height + 65);
			}
			if(!GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window)))
				self_set_video_window_visible(self, TRUE);
			lum_skin_set_vid_button(selfp->skin, TRUE);	
			selfp->prev = PREV_VIDEO;
		} else if(vfx){
			g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", TRUE, NULL, NULL);
			if(selfp->prev == PREV_NONE || selfp->prev == PREV_AUDIO){
				gtk_window_set_resizable(selfp->video_window, TRUE);
				gtk_window_resize(selfp->video_window, 300, 300);
			}
			if(!GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window)))
				self_set_video_window_visible(self, TRUE);
			lum_skin_set_vid_button(selfp->skin, TRUE);
			selfp->prev = PREV_VFX;
		} else {
			gtk_window_resize(selfp->video_window, 368, 85);
			gtk_window_set_resizable(selfp->video_window, FALSE);
			g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", FALSE, NULL, NULL);
			self_set_video_window_visible(self, FALSE);
			lum_skin_set_vid_button(selfp->skin, FALSE);
			selfp->prev = PREV_AUDIO;
		}	
		lum_player_play_pause(selfp->player);
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_set_position (LumEngine * self, gdouble position)
{
#define __GOB_FUNCTION__ "Lum:Engine::set_position"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		if(selfp->player->status != PLAYER_STOPPED)
			lum_player_set_position(selfp->player, position);
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_show_fileselector (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::show_fileselector"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		char **uris;

		lum_skin_set_info_text_temp(selfp->skin, _("Open Files"));
		uris = bonobo_file_selector_open_multi(NULL , TRUE,
				_("Open File(s)"), NULL,
				NULL);
		if(uris != NULL){
			int i;
			for(i = 0; uris[i] != NULL; i++){
				self_enqueue(self, uris[i]);
				g_free(uris[i]);
			}
		}

/* How abut this??
		Nautilus_View view = bonobo_activation_activate_from_id(
				"OAFIID:Nautilus_Tree_View",
				0, NULL, &corba_env);
		Bonobo_Control control = bonobo_object_query_remote(
				view, "IDL:Bonobo/Control:1.0", &corba_env);
		GtkWindow *window = g_object_new(GTK_TYPE_WINDOW, NULL, NULL);
		gtk_container_add(GTK_CONTAINER(window),
				bonobo_widget_new_control_from_objref(control,
					CORBA_OBJECT_NIL)); 
		gtk_widget_show_all(GTK_WIDGET(window));
		Nautilus_View_load_location(view, "/var/mp3",&corba_env);
*/
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_open_dvd (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::open_dvd"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		char **list;
		int i, num = 0;

		lum_skin_set_info_text_temp(selfp->skin, _("Open DVD"));
		list = gtk_xine_get_dvd_list(&num);
		for(i = 0; i < num; i++){
			self_enqueue(self, list[i]);
			free(list[i]);
		}
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_open_cdda (LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::open_cdda"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
	
		char **list;
		int i, num = 0;

		lum_skin_set_info_text_temp(selfp->skin, _("Open Audio CD"));
		list = gtk_xine_get_cdda_list(&num);
		for(i = 0; i < num; i++){
			self_enqueue(self, list[i]);
			free(list[i]);
		}
	}}
#undef __GOB_FUNCTION__

static GList * 
lum_engine_check_dir (const gchar * uri)
{
#define __GOB_FUNCTION__ "Lum:Engine::check_dir"
	g_return_val_if_fail (uri != NULL, (GList * )NULL);
{
	
		DIR *dir;
	 	struct dirent *dirent;
	 	struct stat statbuf;
		char *temp;
		char *path;
	 	GList *list = NULL;

		if (g_ascii_strncasecmp ("file:", uri, 5) == 0) 		
			path = g_strdup ((uri+5));
		else
			path = g_strdup (uri);

	 	if (stat(path, &statbuf) < 0){
			g_free(path);
			return NULL;
		}

	 	if (!S_ISDIR(statbuf.st_mode)){
			g_free(path);	
			return NULL;
		}

		if (path[strlen(path) - 1] != '/')
			temp = g_strconcat(path, "/", NULL);
	 	else
			temp = g_strdup(path);

		if ((dir = opendir(path)) == NULL) {
			g_free(temp);
			g_free(path);
			return NULL;
		}

		while ((dirent = readdir(dir)) != NULL) {
			char *filename;
			if (dirent->d_name[0] == '.')
				continue;
			filename = g_strconcat(temp, dirent->d_name, NULL);

			if (stat(filename, &statbuf) < 0) {
		 		g_free(filename);
		 		continue;
			}

			if (S_ISDIR(statbuf.st_mode)) {
		 		GList *sub;
		 		sub = self_check_dir(filename);
		 		g_free(filename);
		 		list = g_list_concat(list, sub);
			} else { 
		 		list = g_list_append(list, filename);
			}

		}
	 	closedir(dir);
	 	g_free(temp);
	 	g_free(path);
	 	return list;
	}}
#undef __GOB_FUNCTION__

void 
lum_engine_open_activate_cb (GtkMenuItem * button, LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::open_activate_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		self_show_fileselector(self);	}}
#undef __GOB_FUNCTION__

void 
lum_engine_open_audio_cd_activate_cb (GtkMenuItem * button, LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::open_audio_cd_activate_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		self_open_cdda(self); }}
#undef __GOB_FUNCTION__

void 
lum_engine_open_dvd_activate_cb (GtkMenuItem * button, LumEngine * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::open_dvd_activate_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_ENGINE (self));
{
		self_open_dvd(self); }}
#undef __GOB_FUNCTION__

static gboolean 
lum_engine_video_window_delete_cb (GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
#define __GOB_FUNCTION__ "Lum:Engine::video_window_delete_cb"
{
	
		Self *self = SELF(user_data);
		self_set_video_window_visible(self, FALSE);
		lum_skin_set_vid_button(selfp->skin, FALSE);	
		return TRUE;
	}}
#undef __GOB_FUNCTION__

gboolean 
lum_engine_playlist_delete_cb (GtkWidget * widget, GdkEvent * event, gpointer user_data)
{
#define __GOB_FUNCTION__ "Lum:Engine::playlist_delete_cb"
{
	
		Self *self = SELF(user_data);
		self_set_playlist_visible(self, FALSE);
		lum_skin_set_pl_button(selfp->skin, FALSE);	
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_playback_finished_cb (LumPlayer * player, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::playback_finished_cb"
{
	
		Self *self = SELF(data);
		if(lum_playlist_has_next(selfp->playlist))
			lum_playlist_next(selfp->playlist);
		else if(selfp->repeat){
			lum_playlist_next(selfp->playlist);
			self_play(self);
		}
		else {
			lum_player_stop(player);
			lum_playlist_set_at_start(selfp->playlist);
		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_player_status_changed_cb (LumPlayer * player, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::player_status_changed_cb"
{
	
#ifdef DEBUG
		printf(__FILE__ ": status changed\n");
#endif
		Self *self = SELF(data);
		switch(player->status){
			case PLAYER_PAUSED:
				lum_skin_set_playstatus(selfp->skin, STATUS_PAUSE);
				lum_skin_set_info_text_temp(selfp->skin, _("--- PAUSE ---"));
				break;
			case PLAYER_PLAYING:
				lum_skin_set_playstatus(selfp->skin, STATUS_PLAY);
				lum_skin_set_info_text_temp(selfp->skin, _("--- PLAY ---"));
				break;
			case PLAYER_NONE:
			case PLAYER_STOPPED:
				lum_skin_set_playstatus(selfp->skin, STATUS_STOP);
				lum_skin_set_info_text(selfp->skin, "Lumiere");
				lum_skin_set_info_text_temp(selfp->skin, _("--- STOP ---"));
				lum_skin_set_rate_text(selfp->skin, "0");
				lum_skin_set_freq_text(selfp->skin, "0");
				lum_skin_set_channels(selfp->skin, 0);
				lum_skin_set_time(selfp->skin, 0, 0);
				lum_skin_set_position(selfp->skin, -1);
				lum_shell_set_tip(lum_shell, NULL);
				if(GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window)))
					self_video_window_delete_cb(
						GTK_WIDGET(selfp->video_window), NULL, self);
				break;
		}
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_engine_update_timer_cb (LumPlayer * player, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::update_timer_cb"
{
	
		Self *self = SELF(data);

		if(player->status == PLAYER_STOPPED)
			return FALSE;
		
		if(lum_player_is_seekable(player)){
			gint min = player->time / 60000;
			gint secs = (player->time / 1000) - (min * 60);
			lum_skin_set_time(selfp->skin, min, secs);
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_engine_update_position_cb (LumPlayer * player, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::update_position_cb"
{
	
		Self *self = SELF(data);

		if(player->status == PLAYER_STOPPED)
			return FALSE;

		if(lum_player_is_seekable(player))
			lum_skin_set_position(selfp->skin, player->position);
		else
			lum_skin_set_position(selfp->skin, -1);

		return TRUE;
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_volume_changed_cb (LumPlayer * player, double volume, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::volume_changed_cb"
{
		lum_skin_set_volume(selfp->skin, volume); }}
#undef __GOB_FUNCTION__

static void 
lum_engine_new_activate_cb (GtkMenuItem * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::new_activate_cb"
{
		self_new(); }}
#undef __GOB_FUNCTION__

static void 
lum_engine_vfx_activate_cb (GtkCheckMenuItem * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::vfx_activate_cb"
{
	
		gboolean active = gtk_check_menu_item_get_active(button);
		if(GTK_IS_XINE(selfp->player)){
			g_object_set(G_OBJECT(selfp->player),"GtkXine::show_vfx",
					active, NULL, NULL);
			if(active){
				if(selfp->prev == PREV_VIDEO)
					return;
				else {
					gtk_window_set_resizable(selfp->video_window, TRUE);
					gtk_window_resize(selfp->video_window, 300, 300);
				}
				if(!GTK_WIDGET_VISIBLE(GTK_WIDGET(selfp->video_window))){
					if(selfp->player->status != PLAYER_STOPPED){
						self_set_video_window_visible(self, TRUE);
						lum_skin_set_vid_button(selfp->skin, TRUE);
						selfp->prev = PREV_VFX;
					}
				}
				g_object_set(G_OBJECT(selfp->player), 
					"LumPlayer::can_fullscreen", TRUE, NULL, NULL);
			} else if(selfp->prev == PREV_NONE || selfp->prev == PREV_VFX
					|| selfp->prev == PREV_AUDIO){
				gtk_window_resize(selfp->video_window, 368, 65);
				gtk_window_set_resizable(selfp->video_window, FALSE);
				g_object_set(G_OBJECT(selfp->player), 
						"LumPlayer::can_fullscreen", FALSE, NULL, NULL);
				self_set_video_window_visible(self, FALSE);
				lum_skin_set_vid_button(selfp->skin, FALSE);	
				selfp->prev = PREV_AUDIO;
			}
		}
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_controls_activate_cb (GtkMenuItem * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::controls_activate_cb"
{
	
		if(selfp->player->status != PLAYER_STOPPED)
			lum_player_show_runtime(selfp->player);
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_properties_activate_cb (GtkMenuItem * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::properties_activate_cb"
{
	
		self_show_info(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_close_activate_cb (GtkMenuItem * button, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::close_activate_cb"
{
		self_close(self); }}
#undef __GOB_FUNCTION__

static void 
lum_engine_play_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::play_activate_cb"
{
	
		Self *self = SELF(data);
		lum_engine_pause(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_stop_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::stop_activate_cb"
{
	
		Self *self = SELF(data);
		lum_engine_stop(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_next_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::next_activate_cb"
{
	
		Self *self = SELF(data);
		lum_engine_next(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_prev_activate_cb (GtkMenuItem * menuitem, gpointer data)
{
#define __GOB_FUNCTION__ "Lum:Engine::prev_activate_cb"
{
	
		Self *self = SELF(data);
		lum_engine_prev(self);
	}}
#undef __GOB_FUNCTION__

static void 
lum_engine_player_drag_received_cb (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::player_drag_received_cb"
	g_return_if_fail (self != NULL);
	g_return_if_fail (IS_SELF (self));
{
	
		lum_util_drag_received(self, context, data, time);
	}}
#undef __GOB_FUNCTION__

static gboolean 
lum_engine_key_press_cb (GtkWidget * widget, GdkEventKey * event, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Engine::key_press_cb"
	g_return_val_if_fail (self != NULL, (gboolean )0);
	g_return_val_if_fail (IS_SELF (self), (gboolean )0);
{
	

		switch (event->keyval) {
			case GDK_E:
			case GDK_e:
				if (event->state & GDK_CONTROL_MASK)
					gnome_url_show("mailto:your_recipient", NULL);
				else return FALSE;
				break;
			case GDK_N:
			case GDK_n:
				if (event->state & GDK_CONTROL_MASK)
					self_new();
				else return FALSE;
				break;
			case GDK_O:
			case GDK_o:
				if (event->state & GDK_CONTROL_MASK)
					self_show_fileselector(self);
				else return FALSE;
				break;
			case XF86XK_AudioPlay:
			case XF86XK_AudioPause:
			case GDK_p:
			case GDK_P:
				self_pause(self);
				break;
			case GDK_q:
			case GDK_Q:
				if(event->state & GDK_CONTROL_MASK)
					lum_shell_quit_activate_cb(NULL, lum_shell);
				else return FALSE;
				break;
			case GDK_R:
			case GDK_r:
				if(event->state & GDK_CONTROL_MASK)
					self_set_position(self, 0);
				else return FALSE;
				break;
			case GDK_W:
			case GDK_w:
				if (event->state & GDK_CONTROL_MASK)
					self_close(self);
				else return FALSE;
				break;
			case XF86XK_AudioPrev:
			case GDK_Left:
			case GDK_KP_Left:
				if(event->state & GDK_MOD1_MASK)
					self_prev(self);
				else return FALSE;
				break;
			case XF86XK_AudioNext:
			case GDK_KP_Right:
			case GDK_Right:
				if(event->state & GDK_MOD1_MASK)
					self_next(self);
				else return FALSE;
				break;
			case GDK_plus:
			case GDK_KP_Add:
				self_inc_vol(self);
				break;
			case GDK_minus:
			case GDK_KP_Subtract:
				self_dec_vol(self);
				break;
			case GDK_KP_Home:
			case GDK_Home:
				if(event->state & GDK_MOD1_MASK){
//					self_stop(self);
					lum_playlist_set_at_start(selfp->playlist);
					self_play(self);
				}
				else return FALSE;
				break;	
			case GDK_F1:
				lum_shell_help_activate_cb(NULL, lum_shell);
				break;
			default:
				return FALSE;
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_engine_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_get_skin)();
	((void (*)(void))self_load_uri)();
	((void (*)(void))self_enqueue)();
	((void (*)(void))self_iconify)();
	((void (*)(void))self_set_volume)();
	((void (*)(void))self_dec_vol)();
	((void (*)(void))self_inc_vol)();
	((void (*)(void))self_mute)();
	((void (*)(void))self_show_info)();
	((void (*)(void))self_do_popup)();
	((void (*)(void))self_switch_timer_mode)();
	((void (*)(void))self_can_seek)();
	((void (*)(void))self_fwd10)();
	((void (*)(void))self_back10)();
	((void (*)(void))self_close)();
	((void (*)(void))self_prev)();
	((void (*)(void))self_next)();
	((void (*)(void))self_play)();
	((void (*)(void))self_pause)();
	((void (*)(void))self_stop)();
	((void (*)(void))self_get_shuffle)();
	((void (*)(void))self_set_shuffle)();
	((void (*)(void))self_get_repeat)();
	((void (*)(void))self_set_repeat)();
	((void (*)(void))self_get_playlist_visible)();
	((void (*)(void))self_set_playlist_visible)();
	((void (*)(void))self_get_video_window_visible)();
	((void (*)(void))self_set_video_window_visible)();
	((void (*)(void))self_get_list)();
	((void (*)(void))self_play_now)();
	((void (*)(void))self_set_position)();
	((void (*)(void))self_show_fileselector)();
	((void (*)(void))self_open_dvd)();
	((void (*)(void))self_open_cdda)();
	((void (*)(void))self_check_dir)();
	((void (*)(void))self_open_activate_cb)();
	((void (*)(void))self_open_audio_cd_activate_cb)();
	((void (*)(void))self_open_dvd_activate_cb)();
	((void (*)(void))self_video_window_delete_cb)();
	((void (*)(void))self_playlist_delete_cb)();
	((void (*)(void))self_playback_finished_cb)();
	((void (*)(void))self_player_status_changed_cb)();
	((void (*)(void))self_update_timer_cb)();
	((void (*)(void))self_update_position_cb)();
	((void (*)(void))self_volume_changed_cb)();
	((void (*)(void))self_new_activate_cb)();
	((void (*)(void))self_vfx_activate_cb)();
	((void (*)(void))self_controls_activate_cb)();
	((void (*)(void))self_properties_activate_cb)();
	((void (*)(void))self_close_activate_cb)();
	((void (*)(void))self_play_activate_cb)();
	((void (*)(void))self_stop_activate_cb)();
	((void (*)(void))self_next_activate_cb)();
	((void (*)(void))self_prev_activate_cb)();
	((void (*)(void))self_player_drag_received_cb)();
	((void (*)(void))self_key_press_cb)();
	___lum_engine_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

