/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          lum-control.gob  -  Lumiere Main Window
                             -------------------
    begin                : jeu jun  6 02:08:47 BST 2002
    copyright            : (C) 2002 by Stphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "lum-control.h"

#include "lum-control-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) LUM_CONTROL(x)
#define SELF_CONST(x) LUM_CONTROL_CONST(x)
#define IS_SELF(x) LUM_IS_CONTROL(x)
#define TYPE_SELF LUM_TYPE_CONTROL
#define SELF_CLASS(x) LUM_CONTROL_CLASS(x)

#define SELF_GET_CLASS(x) LUM_CONTROL_GET_CLASS(x)

/* self typedefs */
typedef LumControl Self;
typedef LumControlClass SelfClass;

/* here are local prototypes */
static void lum_control_class_init (LumControlClass * c) G_GNUC_UNUSED;
static void lum_control_init (LumControl * self) G_GNUC_UNUSED;
static void ___3_lum_control_dispose (GObject * object) G_GNUC_UNUSED;
static gint lum_control_load_from_file (BonoboPersistFile * pf, const CORBA_char * text_uri, CORBA_Environment * ev, Self * self) G_GNUC_UNUSED;
static void lum_control_load_from_stream (BonoboPersistStream * ps, const Bonobo_Stream stream, Bonobo_Persist_ContentType type, void * closure, CORBA_Environment * ev) G_GNUC_UNUSED;
static gint lum_control_time (LumControl * self) G_GNUC_UNUSED;
static BonoboObject * lum_control_factory (BonoboGenericFactory * this, const char * oaf_iid, void * data) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboControlClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_get_type() lum_control_get_type()
#define self_factory_new() lum_control_factory_new()
#define self_load_from_file(args...) lum_control_load_from_file(args)
#define self_load_from_stream(args...) lum_control_load_from_stream(args)
#define self_time(args...) lum_control_time(args)
#define self_factory(args...) lum_control_factory(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GType (* const self_get_type) (void) = lum_control_get_type;
static BonoboGenericFactory * (* const self_factory_new) (void) = lum_control_factory_new;
static gint (* const self_load_from_file) (BonoboPersistFile * pf, const CORBA_char * text_uri, CORBA_Environment * ev, Self * self) = lum_control_load_from_file;
static void (* const self_load_from_stream) (BonoboPersistStream * ps, const Bonobo_Stream stream, Bonobo_Persist_ContentType type, void * closure, CORBA_Environment * ev) = lum_control_load_from_stream;
static gint (* const self_time) (LumControl * self) = lum_control_time;
static BonoboObject * (* const self_factory) (BonoboGenericFactory * this, const char * oaf_iid, void * data) = lum_control_factory;

/* a macro for creating a new object of our type */
#define GET_NEW ((LumControl *)g_object_new(lum_control_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumControl * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumControl *
GET_NEW_VARG (const char *first, ...)
{
	LumControl *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumControl *)g_object_new_valist (lum_control_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Control::finalize"
	LumControl *self = LUM_CONTROL (obj_self);
	gpointer priv = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
	g_free (priv);
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void 
lum_control_class_init (LumControlClass * c)
{
#define __GOB_FUNCTION__ "Lum:Control::class_init"
	GObjectClass *g_object_class = (GObjectClass*) c;

	parent_class = g_type_class_ref (BONOBO_TYPE_CONTROL);

	g_object_class->dispose = ___3_lum_control_dispose;
	g_object_class->finalize = ___finalize;
	return;
	c = NULL;
	g_object_class = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_control_init (LumControl * self)
{
#define __GOB_FUNCTION__ "Lum:Control::init"
	self->_priv = g_new0 (LumControlPrivate, 1);
	self->_priv->player = NULL;
	self->_priv->player_type = PLAYER_XINE;
	self->_priv->uri = NULL;
 {

		BonoboPersistFile *pfile;
//		BonoboPersistStream* pstream;
	
		g_object_ref(lum_shell);
		
		selfp->player_type = lum_shell_get_config(lum_shell)->backend;

		switch(selfp->player_type){
			case PLAYER_GL:
#ifdef ENABLE_GLPLAY
				selfp->player = LUM_PLAYER(lum_glplay_new(lum_config_new()));
				break;
#endif
			case PLAYER_MPLAYER:
#ifdef ENABLE_MPLAYER
				selfp->player = LUM_PLAYER(gtk_player_new(lum_config_new(), FALSE));
				break;
#endif
			case PLAYER_XINE:
			default:
#ifdef ENABLE_XINE
				selfp->player = LUM_PLAYER(gtk_xine_new(
							lum_shell_get_config(lum_shell)));
				g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx", TRUE,
						"LumPlayer::repeat", TRUE,
						"LumPlayer::can_fullscreen", FALSE, NULL, NULL);
				break;
#endif
		}

		if(!selfp->player){
			g_error("lum_control_new() failed at lum_player_new()\n");
			exit(EXIT_FAILURE);
		}
		gtk_widget_show_all(GTK_WIDGET(selfp->player));

		pfile = bonobo_persist_file_new(
				(BonoboPersistFileIOFn) self_load_from_file,
				NULL,
				"OAFIID:GNOME_Lum_Control",
				self);
/*		
		pstream = bonobo_persist_stream_new(
				self_load_from_stream,
				NULL, NULL,
				"OAFIID:GNOME_Lum_Control",
				self);
*/
		
		if (!pfile) {
			bonobo_object_unref (BONOBO_OBJECT (self));
			g_error("lum_control_new() failed at "
				    "bonobo_persist_file_new() \n");
			exit(EXIT_FAILURE);
		}

		bonobo_object_add_interface(BONOBO_OBJECT(self),
				BONOBO_OBJECT(pfile));
//		bonobo_object_add_interface(BONOBO_OBJECT(self),
//				BONOBO_OBJECT(pstream));

		bonobo_control_construct (BONOBO_CONTROL (self),
					GTK_WIDGET(selfp->player));
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



GType 
lum_control_get_type (void)
{
#define __GOB_FUNCTION__ "Lum:Control::get_type"
{
	
		static GType type = 0;

		if (type == 0) {
			static const GTypeInfo info = {
				sizeof (LumControlClass),
				(GBaseInitFunc) NULL,
				(GBaseFinalizeFunc) NULL,
				(GClassInitFunc) lum_control_class_init,
				NULL, NULL,
				sizeof (LumControl),
				0,
				(GInstanceInitFunc) lum_control_init
				};
				
				type = bonobo_type_unique (
					BONOBO_TYPE_CONTROL,
					NULL, NULL, 0,
					&info, "LumControl");
		}
		return type;
	}}
#undef __GOB_FUNCTION__

static void 
___3_lum_control_dispose (GObject * object)
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Control::dispose"
{
	
#ifdef DEBUG
		printf(__FILE__ ": dispose\n");
#endif
		g_return_if_fail(lum_shell != NULL);

		PARENT_HANDLER(object);
		g_object_unref(lum_shell);
#ifdef DEBUG
		printf(__FILE__ ": disposed\n");
#endif

	}}
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

BonoboGenericFactory * 
lum_control_factory_new (void)
{
#define __GOB_FUNCTION__ "Lum:Control::factory_new"
{
	
		return bonobo_generic_factory_new (
						 "OAFIID:GNOME_Lum_Control_Factory",
		 				 self_factory, NULL);
	}}
#undef __GOB_FUNCTION__

static gint 
lum_control_load_from_file (BonoboPersistFile * pf, const CORBA_char * text_uri, CORBA_Environment * ev, Self * self)
{
#define __GOB_FUNCTION__ "Lum:Control::load_from_file"
	g_return_val_if_fail (self != NULL, (gint )-1);
	g_return_val_if_fail (IS_SELF (self), (gint )-1);
{
	
		GnomeVFSURI *uri;
		GnomeVFSResult result;
		GnomeVFSHandle *handle;
		LumPlayerInfo *info;
#ifdef DEBUG
		printf(__FILE__ ": load from file,\n"
				"  load %s\n", text_uri);
#endif
		info = LUM_PLAYER_INFO(gtk_xine_get_info(text_uri));

		if(info == NULL)
			return -1;
		
		if(info->has_video)
			g_object_set(G_OBJECT(selfp->player), "GtkXine::show_vfx",
					FALSE, NULL, NULL);

		if(g_ascii_strncasecmp("dvd", text_uri, 3) == 0){
			if(!lum_player_open_file(selfp->player, text_uri, info))
				return -1;
			selfp->uri = g_strdup(text_uri);
			g_object_unref(info);
			return 0;
		}
		
		uri = gnome_vfs_uri_new(text_uri);

		result = gnome_vfs_open_uri (&handle,
				uri, GNOME_VFS_OPEN_READ);
		if (result != GNOME_VFS_OK) {
			gnome_vfs_uri_unref (uri);
			return -1;
		}
		
		char *scheme;
		scheme = g_strdup(gnome_vfs_uri_get_scheme (uri));
		if(g_ascii_strcasecmp("http", scheme) == 0){
			selfp->uri = gnome_vfs_uri_to_string(uri,
					GNOME_VFS_URI_HIDE_NONE);
		} else {
			selfp->uri = gnome_vfs_uri_to_string(uri,
					GNOME_VFS_URI_HIDE_TOPLEVEL_METHOD);
		}
		g_free(scheme);
		gnome_vfs_uri_unref(uri);
		if(!lum_player_open_file(selfp->player, selfp->uri, info))
			return -1;
		g_object_unref(info);
		gtk_timeout_add(50,(GtkFunction) self_time, (gpointer)self);
		return 0;
	}}
#undef __GOB_FUNCTION__

static void 
lum_control_load_from_stream (BonoboPersistStream * ps, const Bonobo_Stream stream, Bonobo_Persist_ContentType type, void * closure, CORBA_Environment * ev)
{
#define __GOB_FUNCTION__ "Lum:Control::load_from_stream"
{
	
		Self *self = SELF(closure);
		guint8 *buffer = NULL;
		CORBA_long length_read = 0;
		FILE *file;

		LumPlayerInfo *info = g_object_new(
						LUM_TYPE_PLAYER_INFO, NULL, NULL);
		if(mkfifo("/tmp/lumiere_fifo", 0600) == -1){
			printf(__FILE__": mkfifo error: %s\n", strerror(errno));
			return;
		}
		file = fopen("/tmp/lumiere_fifo", "w");
			
		if(!lum_player_open_file(selfp->player, "fifo://tmp/lumiere_fifo", info))
			return;
		g_object_unref(info);
		gtk_timeout_add(50,(GtkFunction) self_time, (gpointer)self);
		while((buffer = bonobo_stream_client_read(stream,
					1024, &length_read, ev))){
			fwrite(buffer, sizeof(guint8),  length_read, file);
		}
	}}
#undef __GOB_FUNCTION__

static gint 
lum_control_time (LumControl * self)
{
#define __GOB_FUNCTION__ "Lum:Control::time"
	g_return_val_if_fail (self != NULL, (gint )0);
	g_return_val_if_fail (LUM_IS_CONTROL (self), (gint )0);
{
	
		if(lum_player_can_play(selfp->player)) {
			lum_player_play_pause(selfp->player);
			return FALSE;
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static BonoboObject * 
lum_control_factory (BonoboGenericFactory * this, const char * oaf_iid, void * data)
{
#define __GOB_FUNCTION__ "Lum:Control::factory"
	g_return_val_if_fail (this != NULL, (BonoboObject * )NULL);
	g_return_val_if_fail (oaf_iid != NULL, (BonoboObject * )NULL);
{
	
		return BONOBO_OBJECT (GET_NEW);
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_control_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_get_type)();
	((void (*)(void))self_factory_new)();
	((void (*)(void))self_load_from_file)();
	((void (*)(void))self_load_from_stream)();
	((void (*)(void))self_time)();
	((void (*)(void))self_factory)();
	___lum_control_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

