/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                 lum-context.gob  -  Lumiere Nautilus Context menu 
                             -------------------
    copyright            : (C) 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.3 $
 * $Date: 2004/03/22 21:47:39 $
 *
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "lum-context.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


#include <stdlib.h>
#include <string.h>

/* self casting macros */
#define SELF(x) LUM_CONTEXT(x)
#define SELF_CONST(x) LUM_CONTEXT_CONST(x)
#define IS_SELF(x) LUM_IS_CONTEXT(x)
#define TYPE_SELF LUM_TYPE_CONTEXT
#define SELF_CLASS(x) LUM_CONTEXT_CLASS(x)

#define SELF_GET_CLASS(x) LUM_CONTEXT_GET_CLASS(x)

/* self typedefs */
typedef LumContext Self;
typedef LumContextClass SelfClass;

/* here are local prototypes */
static void lum_context_init (LumContext * o) G_GNUC_UNUSED;
static void lum_context_class_init (LumContextClass * c) G_GNUC_UNUSED;
static BonoboObject * lum_context_factory (BonoboGenericFactory * this, const char * oaf_iid, void * data) G_GNUC_UNUSED;
static void lum_context_event (PortableServer_Servant servant, const CORBA_char * event_name, const CORBA_any * args, CORBA_Environment * ev) G_GNUC_UNUSED;
static gchar ** lum_context_translate_uri_arguments (gchar ** list, gint num) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboListenerClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_factory_new() lum_context_factory_new()
#define self_factory(args...) lum_context_factory(args)
#define self_event(args...) lum_context_event(args)
#define self_translate_uri_arguments(args...) lum_context_translate_uri_arguments(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static BonoboGenericFactory * (* const self_factory_new) (void) = lum_context_factory_new;
static BonoboObject * (* const self_factory) (BonoboGenericFactory * this, const char * oaf_iid, void * data) = lum_context_factory;
static void (* const self_event) (PortableServer_Servant servant, const CORBA_char * event_name, const CORBA_any * args, CORBA_Environment * ev) = lum_context_event;
static gchar ** (* const self_translate_uri_arguments) (gchar ** list, gint num) = lum_context_translate_uri_arguments;

GType
lum_context_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumContextClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_context_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (LumContext),
			0, /* n_preallocs */
			(GInstanceInitFunc)  lum_context_init,
			NULL
		};

		type = bonobo_type_unique (
			BONOBO_OBJECT_TYPE,
			POA_Bonobo_Listener__init, NULL,
			G_STRUCT_OFFSET (LumContextClass, _epv),
			&info, "LumContext");
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumContext *)g_object_new(lum_context_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumContext * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumContext *
GET_NEW_VARG (const char *first, ...)
{
	LumContext *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumContext *)g_object_new_valist (lum_context_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
lum_context_init (LumContext * o)
{
#define __GOB_FUNCTION__ "Lum:Context::init"
	return;
	o = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_context_class_init (LumContextClass * c)
{
#define __GOB_FUNCTION__ "Lum:Context::class_init"

	parent_class = g_type_class_ref (BONOBO_TYPE_LISTENER);

	c->_epv.event = self_event;
	return;
	c = NULL;
}
#undef __GOB_FUNCTION__



BonoboGenericFactory * 
lum_context_factory_new (void)
{
#define __GOB_FUNCTION__ "Lum:Context::factory_new"
{
	
		return bonobo_generic_factory_new (
						 "OAFIID:GNOME_Lum_Contextmenu_Factory",
		 				 self_factory, NULL);
	}}
#undef __GOB_FUNCTION__

static BonoboObject * 
lum_context_factory (BonoboGenericFactory * this, const char * oaf_iid, void * data)
{
#define __GOB_FUNCTION__ "Lum:Context::factory"
	g_return_val_if_fail (this != NULL, (BonoboObject * )NULL);
	g_return_val_if_fail (oaf_iid != NULL, (BonoboObject * )NULL);
{
	
		return BONOBO_OBJECT (GET_NEW);
	}}
#undef __GOB_FUNCTION__

static void 
lum_context_event (PortableServer_Servant servant, const CORBA_char * event_name, const CORBA_any * args, CORBA_Environment * ev)
{
#define __GOB_FUNCTION__ "Lum:Context::event"
{
	
		const CORBA_sequence_CORBA_string *list;
		gint i, n_uris = 0;
		gboolean enqueue = FALSE;
		gchar **uri;

		if (!CORBA_TypeCode_equivalent (
					args->_type, TC_CORBA_sequence_CORBA_string, ev))
			return;

		list = (CORBA_sequence_CORBA_string *)args->_value;

		g_return_if_fail (list != NULL);

		if (strcmp (event_name, "EnqueueMedia") == 0)
			enqueue = TRUE;

		else if (strcmp (event_name, "PlayMedia") != 0)
			return;

		GNOME_Lum_Automation lumserver = NULL;
		lumserver = bonobo_activation_activate_from_id (
				"OAFIID:GNOME_Lum_Automation",
				0, NULL, ev);

		uri = self_translate_uri_arguments(list->_buffer, list->_length);
		n_uris = list->_length;

		if (!enqueue)
			for (i = n_uris -1; i >= 0; i--) {
				if(i == n_uris -1)
					GNOME_Lum_Automation_loaduri(lumserver,
							g_strdup(uri[i]),
							FALSE, TRUE, enqueue, ev);
				else
					GNOME_Lum_Automation_loaduri(lumserver,
							g_strdup(uri[i]),
							FALSE, FALSE, !enqueue, ev);
			}
		else
			for (i = n_uris - 1; i >= 0 ; i--) {
				GNOME_Lum_Automation_loaduri (lumserver,
						g_strdup(uri[i]),
						FALSE, FALSE, enqueue, ev);
			}

		for (i = 0; i < n_uris; i++)
			g_free (uri[i]);
	}}
#undef __GOB_FUNCTION__

static gchar ** 
lum_context_translate_uri_arguments (gchar ** list, gint num)
{
#define __GOB_FUNCTION__ "Lum:Context::translate_uri_arguments"
{
	
		gchar buffer[PATH_MAX];
		gint i;
		gchar **uris;

		uris = (gchar **) g_new0 (gchar *, num + 1);

		for (i = 0; i < num; i++){
			if (realpath (list[i], buffer) != NULL)
				uris[i] = g_strconcat ("file://", buffer, NULL);
			else
				uris[i] = g_strdup (list[i]);
		}
		uris[i] = NULL;

		return uris;
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_context_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_factory_new)();
	((void (*)(void))self_factory)();
	((void (*)(void))self_event)();
	((void (*)(void))self_translate_uri_arguments)();
	___lum_context_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

