/* Generated by GOB (v2.0.5) on Sat Mar 27 00:44:16 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */



/***************************************************************************
                          lum-automation.gob  -  Lumiere Corba Implementation 
                             -------------------
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * CVS block
 *
 * $Author: stephanek $
 * $Revision: 1.5 $
 * $Date: 2004/03/27 00:14:31 $
 *
 */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 5

#define selfp (self->_priv)

#include "lum-automation.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */


#include <config.h>

#define LUM_FACTORY_OAFIID "OAFIID:GNOME_Lum_Automation_Factory"

typedef struct {
	char *uri;
	gboolean open_in_existing_window : TRUE;
	gboolean open_in_new_window : TRUE;
	gboolean enqueue : TRUE;
} LumAutomationData;

extern LumShell *lum_shell;

/* self casting macros */
#define SELF(x) LUM_AUTOMATION(x)
#define SELF_CONST(x) LUM_AUTOMATION_CONST(x)
#define IS_SELF(x) LUM_IS_AUTOMATION(x)
#define TYPE_SELF LUM_TYPE_AUTOMATION
#define SELF_CLASS(x) LUM_AUTOMATION_CLASS(x)

#define SELF_GET_CLASS(x) LUM_AUTOMATION_GET_CLASS(x)

/* self typedefs */
typedef LumAutomation Self;
typedef LumAutomationClass SelfClass;

/* here are local prototypes */
static void lum_automation_class_init (LumAutomationClass * c) G_GNUC_UNUSED;
static void lum_automation_init (LumAutomation * self) G_GNUC_UNUSED;
static BonoboObject * lum_automation_factory (BonoboGenericFactory * this_factory, const char * iid, gpointer user_data) G_GNUC_UNUSED;
static void lum_automation_load_uri (const char * uri, gboolean open_in_existing_window, gboolean open_in_new_window, gboolean enqueue) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_loaduri (PortableServer_Servant servant, const CORBA_char * uri, const CORBA_boolean open_in_existing_window, const CORBA_boolean open_in_new_window, const CORBA_boolean enqueue, CORBA_Environment * ev) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_loadsession (PortableServer_Servant servant, const CORBA_char * session_filename, CORBA_Environment * ev) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_quit (PortableServer_Servant _servant, const CORBA_boolean disableServer, CORBA_Environment * ev) G_GNUC_UNUSED;
static CORBA_boolean lum_automation_setServerMode (PortableServer_Servant servant, const CORBA_boolean mode, CORBA_Environment * ev) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboObjectClass *parent_class = NULL;

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define self_new() lum_automation_new()
#define self_complete_initialization(args...) lum_automation_complete_initialization(args)
#define self_factory_new() lum_automation_factory_new()
#define self_factory(args...) lum_automation_factory(args)
#define self_load_uri(args...) lum_automation_load_uri(args)
#define self_loaduri(args...) lum_automation_loaduri(args)
#define self_loadsession(args...) lum_automation_loadsession(args)
#define self_quit(args...) lum_automation_quit(args)
#define self_setServerMode(args...) lum_automation_setServerMode(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static LumAutomation * (* const self_new) (void) = lum_automation_new;
static void (* const self_complete_initialization) (LumAutomation * self, gboolean load_session) = lum_automation_complete_initialization;
static BonoboGenericFactory * (* const self_factory_new) (void) = lum_automation_factory_new;
static BonoboObject * (* const self_factory) (BonoboGenericFactory * this_factory, const char * iid, gpointer user_data) = lum_automation_factory;
static void (* const self_load_uri) (const char * uri, gboolean open_in_existing_window, gboolean open_in_new_window, gboolean enqueue) = lum_automation_load_uri;
static CORBA_boolean (* const self_loaduri) (PortableServer_Servant servant, const CORBA_char * uri, const CORBA_boolean open_in_existing_window, const CORBA_boolean open_in_new_window, const CORBA_boolean enqueue, CORBA_Environment * ev) = lum_automation_loaduri;
static CORBA_boolean (* const self_loadsession) (PortableServer_Servant servant, const CORBA_char * session_filename, CORBA_Environment * ev) = lum_automation_loadsession;
static CORBA_boolean (* const self_quit) (PortableServer_Servant _servant, const CORBA_boolean disableServer, CORBA_Environment * ev) = lum_automation_quit;
static CORBA_boolean (* const self_setServerMode) (PortableServer_Servant servant, const CORBA_boolean mode, CORBA_Environment * ev) = lum_automation_setServerMode;

GType
lum_automation_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumAutomationClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_automation_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (LumAutomation),
			0, /* n_preallocs */
			(GInstanceInitFunc)  lum_automation_init,
			NULL
		};

		type = bonobo_type_unique (
			BONOBO_OBJECT_TYPE,
			POA_GNOME_Lum_Automation__init, NULL,
			G_STRUCT_OFFSET (LumAutomationClass, _epv),
			&info, "LumAutomation");
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumAutomation *)g_object_new(lum_automation_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumAutomation * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumAutomation *
GET_NEW_VARG (const char *first, ...)
{
	LumAutomation *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumAutomation *)g_object_new_valist (lum_automation_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
lum_automation_class_init (LumAutomationClass * c)
{
#define __GOB_FUNCTION__ "Lum:Automation::class_init"
	c->initialized = FALSE;
	c->postponed_loaduris = NULL;

	parent_class = g_type_class_ref (BONOBO_TYPE_OBJECT);

	c->_epv.loaduri = self_loaduri;
	c->_epv.loadsession = self_loadsession;
	c->_epv.quit = self_quit;
	c->_epv.setServerMode = self_setServerMode;
	return;
	c = NULL;
}
#undef __GOB_FUNCTION__
static void 
lum_automation_init (LumAutomation * self)
{
#define __GOB_FUNCTION__ "Lum:Automation::init"
 {

#ifdef DEBUG
		printf(__FILE__ ": init\n");
#endif
	
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__



LumAutomation * 
lum_automation_new (void)
{
#define __GOB_FUNCTION__ "Lum:Automation::new"
{
		return GET_NEW; }}
#undef __GOB_FUNCTION__

void 
lum_automation_complete_initialization (LumAutomation * self, gboolean load_session)
{
#define __GOB_FUNCTION__ "Lum:Automation::complete_initialization"
	g_return_if_fail (self != NULL);
	g_return_if_fail (LUM_IS_AUTOMATION (self));
{
	
		LumSession *session = NULL;

		if(load_session){
			session = lum_shell_get_session (lum_shell);

			if (lum_session_get_engines (session) == NULL) {
				LumSessionResumeType res;
				res = lum_session_autoresume (session);
				/* TODO not used */
				if ( res == SESSION_ABORT ) {
					GSList * iterator;
					for( iterator =
							SELF_GET_CLASS(self)->postponed_loaduris ;
							iterator ; iterator = iterator->next) {
						LumAutomationData *data = iterator->data;
						g_free (data->uri);
						g_free (data);
					}
					g_slist_free (SELF_GET_CLASS(self)->postponed_loaduris);
					lum_shell_set_server_mode (lum_shell, FALSE);
					return;
				}
				
				if (res == SESSION_RESUMED &&
						SELF_GET_CLASS(self)->postponed_loaduris) {
					GSList *last = g_slist_last (
							SELF_GET_CLASS(self)->postponed_loaduris);
					LumAutomationData *data = last->data;
					if (data->uri == NULL || *data->uri == 0) {
						SELF_GET_CLASS(self)->postponed_loaduris =
							g_slist_delete_link (
									SELF_GET_CLASS(self)->postponed_loaduris,
									last);
						g_free (data->uri);
						g_free (data);
					}
				}
			}
		}
		while (SELF_GET_CLASS(self)->postponed_loaduris) {
			GSList *internal_postponed, *iterator;

			internal_postponed = g_slist_reverse (
					SELF_GET_CLASS(self)->postponed_loaduris);
			SELF_GET_CLASS(self)->postponed_loaduris = NULL;

			for (iterator = internal_postponed; iterator; iterator = iterator->next) {
				LumAutomationData *data = iterator->data;
				self_load_uri (data->uri,
						   data->open_in_existing_window,
						   data->open_in_new_window,
						   data->enqueue);
				g_free (data->uri);
				g_free (data);
			}
			g_slist_free (internal_postponed);
		}
		SELF_GET_CLASS(self)->initialized = TRUE;
	}}
#undef __GOB_FUNCTION__

BonoboGenericFactory * 
lum_automation_factory_new (void)
{
#define __GOB_FUNCTION__ "Lum:Automation::factory_new"
{
	
		return bonobo_generic_factory_new (LUM_FACTORY_OAFIID,
					self_factory, NULL);
	}}
#undef __GOB_FUNCTION__

static BonoboObject * 
lum_automation_factory (BonoboGenericFactory * this_factory, const char * iid, gpointer user_data)
{
#define __GOB_FUNCTION__ "Lum:Automation::factory"
{
	
		return BONOBO_OBJECT(self_new());
	}}
#undef __GOB_FUNCTION__

static void 
lum_automation_load_uri (const char * uri, gboolean open_in_existing_window, gboolean open_in_new_window, gboolean enqueue)
{
#define __GOB_FUNCTION__ "Lum:Automation::load_uri"
{
	
		LumEngine *engine = lum_shell_get_active_engine(lum_shell);
	
		if (open_in_existing_window && engine != NULL) {
			lum_engine_load_uri(engine, uri);
			return;

		} else if (enqueue && engine != NULL) {
			lum_engine_enqueue(engine, uri);
			return;

		} else if (open_in_new_window){
			lum_shell_new_engine(lum_shell, uri);
			return;
		} else {
			lum_shell_new_engine(lum_shell, uri);
			return;
		}
	}}
#undef __GOB_FUNCTION__

static CORBA_boolean 
lum_automation_loaduri (PortableServer_Servant servant, const CORBA_char * uri, const CORBA_boolean open_in_existing_window, const CORBA_boolean open_in_new_window, const CORBA_boolean enqueue, CORBA_Environment * ev)
{
#define __GOB_FUNCTION__ "Lum:Automation::loaduri"
{
	
		Self *self = SELF(bonobo_object_from_servant(servant));
		if (SELF_GET_CLASS(self)->initialized) {
			self_load_uri (uri, open_in_existing_window,
					open_in_new_window,
					enqueue );
		} else {
			LumAutomationData *data = g_new (LumAutomationData, 1);

			data->uri = g_strdup (uri);
			data->open_in_existing_window = open_in_existing_window;
			data->open_in_new_window = open_in_new_window;
			data->enqueue = enqueue;

			SELF_GET_CLASS(self)->postponed_loaduris = g_slist_prepend (
					SELF_GET_CLASS(self)->postponed_loaduris, data);
		}
		return TRUE;
	}}
#undef __GOB_FUNCTION__

static CORBA_boolean 
lum_automation_loadsession (PortableServer_Servant servant, const CORBA_char * session_filename, CORBA_Environment * ev)
{
#define __GOB_FUNCTION__ "Lum:Automation::loadsession"
{
	
		CORBA_boolean retval = TRUE;
		LumSession *session  = lum_shell_get_session (lum_shell);
		lum_session_load(session, session_filename);
		return retval;
	}}
#undef __GOB_FUNCTION__

static CORBA_boolean 
lum_automation_quit (PortableServer_Servant _servant, const CORBA_boolean disableServer, CORBA_Environment * ev)
{
#define __GOB_FUNCTION__ "Lum:Automation::quit"
{
	
		CORBA_boolean retval = TRUE;

		g_object_ref (lum_shell);

		lum_session_close (lum_shell_get_session (lum_shell));
		if (disableServer)
			lum_shell_set_server_mode (lum_shell, FALSE);

		g_object_unref (lum_shell);

		return retval;
	}}
#undef __GOB_FUNCTION__

static CORBA_boolean 
lum_automation_setServerMode (PortableServer_Servant servant, const CORBA_boolean mode, CORBA_Environment * ev)
{
#define __GOB_FUNCTION__ "Lum:Automation::setServerMode"
{
	
		CORBA_boolean retval = TRUE;

		lum_config_set_server(lum_shell_get_config(lum_shell),
				mode ? TRUE : FALSE);

		return retval;
	}}
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___lum_automation_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))GET_NEW_VARG)();
	((void (*)(void))self_new)();
	((void (*)(void))self_complete_initialization)();
	((void (*)(void))self_factory_new)();
	((void (*)(void))self_factory)();
	((void (*)(void))self_load_uri)();
	((void (*)(void))self_loaduri)();
	((void (*)(void))self_loadsession)();
	((void (*)(void))self_quit)();
	((void (*)(void))self_setServerMode)();
	___lum_automation_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */

