/* Generated by GOB (v2.0.11) on Thu Apr 14 15:07:42 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-util.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 7 "lum-util.gob"

#include <config.h>
#include "lum-player-info.h"
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <glib/gi18n.h>


#line 36 "lum-util.c"

#line 18 "lum-util.gob"

#define HEX_ESCAPE '%'

static int
hex_to_int (gchar c)
{
	return  c >= '0' && c <= '9' ? c - '0'
		: c >= 'A' && c <= 'F' ? c - 'A' + 10
		: c >= 'a' && c <= 'f' ? c - 'a' + 10
		: -1;
}


static char *str_to_utf8_fallback(const char * str)
{
	char *out_str, *convert_str, *chr;

    /* NULL in NULL out */
    if (!str)
        return NULL;

	convert_str = g_strdup(str);
    for (chr = convert_str; *chr; chr++) {
        if (*chr & 0x80)
            *chr = '?';
    }

    out_str = g_strconcat(convert_str, _("  (invalid UTF-8)"), NULL);
    g_free(convert_str);

    return out_str;
}


#line 73 "lum-util.c"
/* self casting macros */
#define SELF(x) LUM_UTIL(x)
#define SELF_CONST(x) LUM_UTIL_CONST(x)
#define IS_SELF(x) LUM_IS_UTIL(x)
#define TYPE_SELF LUM_TYPE_UTIL
#define SELF_CLASS(x) LUM_UTIL_CLASS(x)

#define SELF_GET_CLASS(x) LUM_UTIL_GET_CLASS(x)

/* self typedefs */
typedef LumUtil Self;
typedef LumUtilClass SelfClass;

/* here are local prototypes */
static void lum_util_init (LumUtil * o) G_GNUC_UNUSED;
static void lum_util_class_init (LumUtilClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_general_tmp_filename lum_util_general_tmp_filename
#define self_xmlGetIntProp lum_util_xmlGetIntProp
#define self_convert lum_util_convert
#define self_unescape_string_for_display lum_util_unescape_string_for_display
GType
lum_util_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumUtilClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_util_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumUtil),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_util_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LumUtil", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumUtil *)g_object_new(lum_util_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumUtil * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumUtil *
GET_NEW_VARG (const char *first, ...)
{
	LumUtil *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumUtil *)g_object_new_valist (lum_util_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
lum_util_init (LumUtil * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Util::init"
}
#undef __GOB_FUNCTION__
static void 
lum_util_class_init (LumUtilClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Util::class_init"

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

}
#undef __GOB_FUNCTION__



#line 55 "lum-util.gob"
char * 
lum_util_general_tmp_filename (const char * base, const char * extension)
#line 162 "lum-util.c"
{
#define __GOB_FUNCTION__ "Lum:Util::general_tmp_filename"
{
#line 55 "lum-util.gob"
	
		int fd;
		char *name = g_strdup (base);
		fd = mkstemp (name);

		if (fd != -1) {
			unlink (name);
			close (fd);
		} else {
			return NULL;
		}
		if (extension) {
			char *tmp;
			tmp = g_strconcat (name, ".", 
  					extension, NULL);
			g_free (name);
			name = tmp;
		}
		return name;
	}}
#line 187 "lum-util.c"
#undef __GOB_FUNCTION__

/**
 * lum_util_xmlGetIntProp:
 *
 * get the integer value of the attribute
 *
 * Returns: the integer
 **/
#line 83 "lum-util.gob"
gint 
lum_util_xmlGetIntProp (xmlNodePtr node, const gchar * attribute)
#line 200 "lum-util.c"
{
#define __GOB_FUNCTION__ "Lum:Util::xmlGetIntProp"
{
#line 83 "lum-util.gob"
	
		char *string_value;
		int value = -1;

		/* get the attribute as a string */
		string_value = xmlGetProp (node, attribute);
	
		if (string_value){
		/* convert to integer */
			value = strtol (string_value, NULL, 10);

			/* free allocated string */
			xmlFree (string_value);
		}
		/* return discovered value */
		return value;
	}}
#line 222 "lum-util.c"
#undef __GOB_FUNCTION__

#line 101 "lum-util.gob"
gchar * 
lum_util_convert (const gchar * orig)
#line 228 "lum-util.c"
{
#define __GOB_FUNCTION__ "Lum:Util::convert"
#line 101 "lum-util.gob"
	g_return_val_if_fail (orig != NULL, (gchar * )NULL);
#line 233 "lum-util.c"
{
#line 101 "lum-util.gob"
	
		char *ustring;
		if(!g_utf8_validate(orig, -1, NULL)){
			const char **charset = NULL;
#ifndef NDEBUG
			printf(__FILE__ ": not valid unicode\n");
#endif
			if(!g_get_charset(charset)){
#ifndef NDEBUG
				printf(__FILE__ ": non UTF locale\n"
						"locale charset = %s\n", *charset);
#endif
				if(!(ustring = g_locale_to_utf8(orig,
						-1, NULL, NULL, NULL)))
					ustring = str_to_utf8_fallback(orig);
			} else { //in UTF-8 and string in other locale!
#ifndef NDEBUG
				printf(__FILE__ ": UTF locale!\n");
#endif
				/* guessing... the user is using latin1 encoding
				 * pfff a bit simple! */
				ustring = g_convert(orig, strlen(orig),
							"UTF-8", "l1", NULL, NULL, NULL);
				if(!g_utf8_validate(ustring, -1, NULL))
					ustring = str_to_utf8_fallback(orig);	
			}
		} else { // string OK in UTF-8 
#ifndef NDEBUG
			printf(__FILE__ ": valid unicode\n");
#endif
			ustring = g_strdup(orig);
		}
		return ustring;
	}}
#line 270 "lum-util.c"
#undef __GOB_FUNCTION__

#line 137 "lum-util.gob"
char * 
lum_util_unescape_string_for_display (const char * escaped)
#line 276 "lum-util.c"
{
#define __GOB_FUNCTION__ "Lum:Util::unescape_string_for_display"
#line 137 "lum-util.gob"
	g_return_val_if_fail (escaped != NULL, (char * )NULL);
#line 281 "lum-util.c"
{
#line 137 "lum-util.gob"
	
		const gchar *in, *start_escape;
		char *out, *result;
		int i,j;
		char c;
		int invalid_escape;
	
		result = g_malloc (strlen (escaped) + 1);
		out = result;
		for (in = escaped; *in != '\0'; ) {
			start_escape = in;
			c = *in++;
			invalid_escape = 0;
		
			if (c == HEX_ESCAPE) {
				/* Get the first hex digit. */
				i = hex_to_int (*in++);
				if (i < 0) {
					invalid_escape = 1;
					in--;
				}
				c = i << 4;
	
				if (invalid_escape == 0) {
					/* Get the second hex digit. */
					i = hex_to_int (*in++);
					if (i < 0) {
						invalid_escape = 2;
						in--;
					}
					c |= i;
				}
				if (invalid_escape == 0) {
					/* Check for an illegal character. */
					if (c == '\0') {
						invalid_escape = 3;
					}
				}
			}
			if (invalid_escape != 0) {
				for (j = 0; j < invalid_escape; j++) {
					*out++ = *start_escape++;
				}
			} else {
				*out++ = c;
			}
		}
		
		*out = '\0';
		g_assert (out - result <= strlen (escaped));
		return result;
	}}
#line 336 "lum-util.c"
#undef __GOB_FUNCTION__
