/* Generated by GOB (v2.0.11) on Thu Apr 14 15:07:42 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-player.gob"

/***************************************************************************
                    lum-player.gob  -  Lumiere Player Widget (abstract)
                             -------------------
    begin                : dim jan  26 02:08:47 BST 2002
    copyright            : (C) 2003, 2004 by Stéphane Konstantaropoulos
    email                : stephanek@brutele.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#line 27 "lum-player.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-player.h"

#include "lum-player-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 48 "lum-player.gob"

#ifdef ENABLE_GLPLAY
#include "lum-glplay.h"
#endif

#include "gtk-xine.h"

#include <stdlib.h>
	
/* debug printout macros */	
#ifndef NDEBUG
#define __d	g_message(__GOB_FUNCTION__);
#define __ds(s)	g_message(__GOB_FUNCTION__ s);
#else
#define __d
#define __ds(s)
#endif	

#line 67 "lum-player.c"
static const GEnumValue _lum_player_status_values[] = {
	{ PLAYER_NONE, (char *)"PLAYER_NONE", (char *)"none" },
	{ PLAYER_PLAYING, (char *)"PLAYER_PLAYING", (char *)"playing" },
	{ PLAYER_PAUSED, (char *)"PLAYER_PAUSED", (char *)"paused" },
	{ PLAYER_STOPPED, (char *)"PLAYER_STOPPED", (char *)"stopped" },
	{ 0, NULL, NULL }
};

GType
lum_player_status_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("LumPlayerStatus", _lum_player_status_values);
	return type;
}

/* self casting macros */
#define SELF(x) LUM_PLAYER(x)
#define SELF_CONST(x) LUM_PLAYER_CONST(x)
#define IS_SELF(x) LUM_IS_PLAYER(x)
#define TYPE_SELF LUM_TYPE_PLAYER
#define SELF_CLASS(x) LUM_PLAYER_CLASS(x)

#define SELF_GET_CLASS(x) LUM_PLAYER_GET_CLASS(x)

/* self typedefs */
typedef LumPlayer Self;
typedef LumPlayerClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lum_player_class_init (LumPlayerClass * c) G_GNUC_UNUSED;
static void lum_player_init (LumPlayer * self) G_GNUC_UNUSED;
static bool ___real_lum_player_open_file (LumPlayer * self, const char * uri, LumPlayerInfo * info);
static void ___real_lum_player_stop (LumPlayer * self);
static void ___real_lum_player_set_volume (LumPlayer * self, double vol);
static gboolean lum_player_update_timer (LumPlayer * self) G_GNUC_UNUSED;
static void ___2b_lum_player_dispose (GObject * object) G_GNUC_UNUSED;
static void ___2c_lum_player_finalize (GObject * object) G_GNUC_UNUSED;
static gboolean ___2d_lum_player_motion_notify_event (GtkWidget * widget, GdkEventMotion * event) G_GNUC_UNUSED;
static gboolean ___2e_lum_player_button_press_event (GtkWidget * widget, GdkEventButton * event) G_GNUC_UNUSED;
static gboolean ___2f_lum_player_popup_menu (GtkWidget * widget) G_GNUC_UNUSED;
static gboolean ___30_lum_player_key_release_event (GtkWidget * widget, GdkEventKey * event) G_GNUC_UNUSED;
static bool lum_player_hide_bars (LumPlayer * self) G_GNUC_UNUSED;
static void lum_player_do_popup (LumPlayer const * self, gint button, gint time) G_GNUC_UNUSED;
static void lum_player_fullscreen_cb (GtkToggleButton * button, Self * self) G_GNUC_UNUSED;
static void lum_player_video_activate_cb (GtkToggleButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_player_eq_activate_cb (GtkToggleButton * button, gpointer data) G_GNUC_UNUSED;
static void lum_player_position_value_changed_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_volume_value_changed_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static bool lum_player_position_button_press_cb (GtkWidget * widget, GdkEventButton * event, gpointer data) G_GNUC_UNUSED;
static bool lum_player_position_button_release_cb (GtkWidget * widget, GdkEventButton * event, gpointer data) G_GNUC_UNUSED;
static void lum_player_cont_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_bright_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_hue_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_sat_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_mute_cb (GtkToggleButton * button, Self * self) G_GNUC_UNUSED;
static void lum_player_eq30_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq60_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq125_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq250_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq500_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq1000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq2000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq4000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq8000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;
static void lum_player_eq16000_cb (GtkRange * range, Self * self) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__playbackfinished(object,func,data)	lum_player_connect__playbackfinished((object),(func),(data))
#define self_connect_after__playbackfinished(object,func,data)	lum_player_connect_after__playbackfinished((object),(func),(data))
#define self_connect_data__playbackfinished(object,func,data,destroy_data,flags)	lum_player_connect_data__playbackfinished((object),(func),(data),(destroy_data),(flags))
#define self_connect__volume_changed(object,func,data)	lum_player_connect__volume_changed((object),(func),(data))
#define self_connect_after__volume_changed(object,func,data)	lum_player_connect_after__volume_changed((object),(func),(data))
#define self_connect_data__volume_changed(object,func,data,destroy_data,flags)	lum_player_connect_data__volume_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (LumPlayer *, gdouble , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((LumPlayer *)data1,
		(gdouble ) g_value_get_double (param_values + 1),
		data2);
}


enum {
	PLAYBACKFINISHED_SIGNAL,
	VOLUME_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_CONFIG,
	PROP_STATUS,
	PROP_POSITION,
	PROP_TIME,
	PROP_IS_SEEKABLE,
	PROP_CAN_FULLSCREEN,
	PROP_FULLSCREEN,
	PROP_CAN_HIDE_BARS,
	PROP_MUTE,
	PROP_REPEAT
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkVBoxClass *parent_class = NULL;

/* Short form macros */
#define self_get_config lum_player_get_config
#define self_set_config lum_player_set_config
#define self_get_status lum_player_get_status
#define self_set_status lum_player_set_status
#define self_get_position lum_player_get_position
#define self_set_position lum_player_set_position
#define self_get_time lum_player_get_time
#define self_set_time lum_player_set_time
#define self_get_is_seekable lum_player_get_is_seekable
#define self_set_is_seekable lum_player_set_is_seekable
#define self_get_can_fullscreen lum_player_get_can_fullscreen
#define self_set_can_fullscreen lum_player_set_can_fullscreen
#define self_get_fullscreen lum_player_get_fullscreen
#define self_set_fullscreen lum_player_set_fullscreen
#define self_get_can_hide_bars lum_player_get_can_hide_bars
#define self_set_can_hide_bars lum_player_set_can_hide_bars
#define self_get_mute lum_player_get_mute
#define self_set_mute lum_player_set_mute
#define self_get_repeat lum_player_get_repeat
#define self_set_repeat lum_player_set_repeat
#define self_open_file lum_player_open_file
#define self_play_pause lum_player_play_pause
#define self_stop lum_player_stop
#define self_get_stream_length lum_player_get_stream_length
#define self_set_contrast lum_player_set_contrast
#define self_set_brightness lum_player_set_brightness
#define self_set_hue lum_player_set_hue
#define self_set_saturation lum_player_set_saturation
#define self_set_eq lum_player_set_eq
#define self_set_volume lum_player_set_volume
#define self_get_volume lum_player_get_volume
#define self_next lum_player_next
#define self_prev lum_player_prev
#define self_is_running lum_player_is_running
#define self_can_play lum_player_can_play
#define self_get_mime_types lum_player_get_mime_types
#define self_get_cdda_list lum_player_get_cdda_list
#define self_get_dvd_list lum_player_get_dvd_list
#define self_playbackfinished lum_player_playbackfinished
#define self_volume_changed lum_player_volume_changed
#define self_update_timer lum_player_update_timer
#define self_show_runtime lum_player_show_runtime
#define self_set_popup_menu lum_player_set_popup_menu
#define self_show_props_window lum_player_show_props_window
#define self_hide_bars lum_player_hide_bars
#define self_do_popup lum_player_do_popup
#define self_fullscreen_cb lum_player_fullscreen_cb
#define self_properties_cb lum_player_properties_cb
#define self_video_activate_cb lum_player_video_activate_cb
#define self_eq_activate_cb lum_player_eq_activate_cb
#define self_position_value_changed_cb lum_player_position_value_changed_cb
#define self_volume_value_changed_cb lum_player_volume_value_changed_cb
#define self_position_button_press_cb lum_player_position_button_press_cb
#define self_position_button_release_cb lum_player_position_button_release_cb
#define self_cont_cb lum_player_cont_cb
#define self_bright_cb lum_player_bright_cb
#define self_hue_cb lum_player_hue_cb
#define self_sat_cb lum_player_sat_cb
#define self_mute_cb lum_player_mute_cb
#define self_eq30_cb lum_player_eq30_cb
#define self_eq60_cb lum_player_eq60_cb
#define self_eq125_cb lum_player_eq125_cb
#define self_eq250_cb lum_player_eq250_cb
#define self_eq500_cb lum_player_eq500_cb
#define self_eq1000_cb lum_player_eq1000_cb
#define self_eq2000_cb lum_player_eq2000_cb
#define self_eq4000_cb lum_player_eq4000_cb
#define self_eq8000_cb lum_player_eq8000_cb
#define self_eq16000_cb lum_player_eq16000_cb
#define self_factory lum_player_factory
GType
lum_player_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumPlayerClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_player_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumPlayer),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_player_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_VBOX, "LumPlayer", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumPlayer *)g_object_new(lum_player_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumPlayer * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumPlayer *
GET_NEW_VARG (const char *first, ...)
{
	LumPlayer *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumPlayer *)g_object_new_valist (lum_player_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Player::dispose"
	LumPlayer *self G_GNUC_UNUSED = LUM_PLAYER (obj_self);
#line 480 "lum-player.gob"
	___2b_lum_player_dispose(obj_self);
#line 326 "lum-player.c"
#line 81 "lum-player.gob"
	if(self->_priv->config) { g_object_unref ((gpointer) self->_priv->config); self->_priv->config = NULL; }
#line 329 "lum-player.c"
#line 200 "lum-player.gob"
	if(self->_priv->popup_menu) { gtk_widget_destroy ((gpointer) self->_priv->popup_menu); self->_priv->popup_menu = NULL; }
#line 332 "lum-player.c"
#line 207 "lum-player.gob"
	if(self->_priv->pause_image) { g_object_unref ((gpointer) self->_priv->pause_image); self->_priv->pause_image = NULL; }
#line 335 "lum-player.c"
#line 209 "lum-player.gob"
	if(self->_priv->play_image) { g_object_unref ((gpointer) self->_priv->play_image); self->_priv->play_image = NULL; }
#line 338 "lum-player.c"
#line 211 "lum-player.gob"
	if(self->_priv->runtime) { gtk_widget_destroy ((gpointer) self->_priv->runtime); self->_priv->runtime = NULL; }
#line 341 "lum-player.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Player::finalize"
	LumPlayer *self G_GNUC_UNUSED = LUM_PLAYER (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 493 "lum-player.gob"
	___2c_lum_player_finalize(obj_self);
#line 354 "lum-player.c"
#line 182 "lum-player.gob"
	if(self->_priv->uri) { g_free ((gpointer) self->_priv->uri); self->_priv->uri = NULL; }
#line 357 "lum-player.c"
#line 213 "lum-player.gob"
	if(self->_priv->scrsaver) { scrsaver_free ((gpointer) self->_priv->scrsaver); self->_priv->scrsaver = NULL; }
#line 360 "lum-player.c"
#line 259 "lum-player.gob"
	if(self->_priv->gtimer) { g_timer_destroy ((gpointer) self->_priv->gtimer); self->_priv->gtimer = NULL; }
#line 363 "lum-player.c"
}
#undef __GOB_FUNCTION__

static void 
lum_player_class_init (LumPlayerClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Player::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;

	g_type_class_add_private(c,sizeof(LumPlayerPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_VBOX);

	object_signals[PLAYBACKFINISHED_SIGNAL] =
		g_signal_new ("playbackfinished",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, playbackfinished),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[VOLUME_CHANGED_SIGNAL] =
		g_signal_new ("volume_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LumPlayerClass, volume_changed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_DOUBLE);
	if ___GOB_UNLIKELY(sizeof(double ) != sizeof(gdouble ) || parent_class == NULL /* avoid warning */) {
		g_error("lum-player.gob line 438: Type mismatch of \"volume_changed\" signal signature");
	}

#line 369 "lum-player.gob"
	c->open_file = ___real_lum_player_open_file;
#line 401 "lum-player.c"
	c->play_pause = NULL;
#line 392 "lum-player.gob"
	c->stop = ___real_lum_player_stop;
#line 405 "lum-player.c"
	c->get_stream_length = NULL;
	c->set_contrast = NULL;
	c->set_brightness = NULL;
	c->set_hue = NULL;
	c->set_saturation = NULL;
	c->set_eq = NULL;
#line 414 "lum-player.gob"
	c->set_volume = ___real_lum_player_set_volume;
#line 414 "lum-player.c"
	c->get_volume = NULL;
	c->next = NULL;
	c->prev = NULL;
	c->is_running = NULL;
	c->can_play = NULL;
	c->get_mime_types = NULL;
	c->get_cdda_list = NULL;
	c->get_dvd_list = NULL;
	c->playbackfinished = NULL;
	c->volume_changed = NULL;
#line 480 "lum-player.gob"
	g_object_class->dispose = ___dispose;
#line 493 "lum-player.gob"
	g_object_class->finalize = ___finalize;
#line 518 "lum-player.gob"
	gtk_widget_class->motion_notify_event = ___2d_lum_player_motion_notify_event;
#line 547 "lum-player.gob"
	gtk_widget_class->button_press_event = ___2e_lum_player_button_press_event;
#line 570 "lum-player.gob"
	gtk_widget_class->popup_menu = ___2f_lum_player_popup_menu;
#line 577 "lum-player.gob"
	gtk_widget_class->key_release_event = ___30_lum_player_key_release_event;
#line 437 "lum-player.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_object
		("config" /* name */,
		 _("configuration") /* nick */,
		 _("Configuration data structure") /* blurb */,
		 LUM_TYPE_CONFIG /* object_type */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CONFIG,
		param_spec);
	param_spec = g_param_spec_enum
		("status" /* name */,
		 _("status") /* nick */,
		 _("Status of the playout") /* blurb */,
		 LUM_TYPE_PLAYER_STATUS /* enum_type */,
		 PLAYER_STOPPED /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_STATUS,
		param_spec);
	param_spec = g_param_spec_double
		("position" /* name */,
		 "position" /* nick */,
		 "position in the stream, in percent" /* blurb */,
		 0.0 /* minimum */,
		 G_MAXDOUBLE /* maximum */,
		 0.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_POSITION,
		param_spec);
	param_spec = g_param_spec_int
		("time" /* name */,
		 "time" /* nick */,
		 "position in the stream, in milliseconds" /* blurb */,
		 0 /* minimum */,
		 G_MAXINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_TIME,
		param_spec);
	param_spec = g_param_spec_boolean
		("is_seekable" /* name */,
		 "is seekable" /* nick */,
		 "whether the stream is seekable" /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_IS_SEEKABLE,
		param_spec);
	param_spec = g_param_spec_boolean
		("can_fullscreen" /* name */,
		 _("Can fullscreen") /* nick */,
		 _("Fullscreen allowed?") /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CAN_FULLSCREEN,
		param_spec);
	param_spec = g_param_spec_boolean
		("fullscreen" /* name */,
		 _("fullscreen") /* nick */,
		 _("Fullscreen Mode") /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_FULLSCREEN,
		param_spec);
	param_spec = g_param_spec_boolean
		("can_hide_bars" /* name */,
		 _("Can hide the bars") /* nick */,
		 _("Allow to hide the bars in window mode") /* blurb */,
		 true /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CAN_HIDE_BARS,
		param_spec);
	param_spec = g_param_spec_boolean
		("mute" /* name */,
		 _("mute") /* nick */,
		 _("Mute Sound") /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_MUTE,
		param_spec);
	param_spec = g_param_spec_boolean
		("repeat" /* name */,
		 _("Repeat") /* nick */,
		 _("Restart when file finished") /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_REPEAT,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 285 "lum-player.gob"
static void 
lum_player_init (LumPlayer * self G_GNUC_UNUSED)
#line 544 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,LumPlayerPrivate);
#line 48 "lum-player.gob"
	self->_priv->config = NULL;
#line 550 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->uri = NULL;
#line 553 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->info = NULL;
#line 556 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->timer = NULL;
#line 559 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->timerid = false;
#line 562 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->position_range = NULL;
#line 565 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->position_pressed = false;
#line 568 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->in_pos_timer = false;
#line 571 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->volume_range = NULL;
#line 574 "lum-player.c"
#line 156 "lum-player.gob"
	self->_priv->volume_moving = false;
#line 577 "lum-player.c"
#line 200 "lum-player.gob"
	self->_priv->popup_menu = gtk_menu_new();
#line 580 "lum-player.c"
#line 200 "lum-player.gob"
	self->_priv->play_pause_btn = NULL;
#line 583 "lum-player.c"
#line 200 "lum-player.gob"
	self->_priv->play_pause_id = false;
#line 586 "lum-player.c"
#line 205 "lum-player.gob"
	self->_priv->pause_image = g_object_ref(gtk_image_new_from_stock(GTK_STOCK_MEDIA_PAUSE,
						GTK_ICON_SIZE_BUTTON));
#line 590 "lum-player.c"
#line 205 "lum-player.gob"
	self->_priv->play_image = NULL;
#line 593 "lum-player.c"
#line 205 "lum-player.gob"
	self->_priv->runtime = NULL;
#line 596 "lum-player.c"
#line 213 "lum-player.gob"
	self->_priv->scrsaver = scrsaver_new();
#line 599 "lum-player.c"
#line 213 "lum-player.gob"
	self->_priv->fullscreen_btn = NULL;
#line 602 "lum-player.c"
#line 224 "lum-player.gob"
	self->_priv->fullscreen = false;
#line 605 "lum-player.c"
#line 251 "lum-player.gob"
	self->_priv->top = NULL;
#line 608 "lum-player.c"
#line 251 "lum-player.gob"
	self->_priv->bottom = NULL;
#line 611 "lum-player.c"
#line 251 "lum-player.gob"
	self->_priv->hideid = false;
#line 614 "lum-player.c"
#line 259 "lum-player.gob"
	self->_priv->gtimer = g_timer_new();
#line 617 "lum-player.c"
#line 259 "lum-player.gob"
	self->_priv->mute = false;
#line 620 "lum-player.c"
 {
#line 285 "lum-player.gob"

		GladeXML *xml;

		xml = glade_xml_new(PACKAGE_DATA_DIR"/liblumiere/liblumiere.glade",
				"lum_player_tb_top", GETTEXT_PACKAGE);
		if(xml == NULL){
			GtkWidget *dialog;
			dialog = gtk_message_dialog_new (NULL,
					GTK_DIALOG_MODAL, 
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK,
					_("liblumiere cannot find %s."),
					PACKAGE_DATA_DIR"/lumiere/liblumiere.glade");
			gtk_message_dialog_format_secondary_text(
					GTK_MESSAGE_DIALOG(dialog),
					"Make sure liblumiere was completely installed,"
					" or run the install again.\n\n"
					"Aborting...");
			g_signal_connect (G_OBJECT (dialog), "response",
				  G_CALLBACK (gtk_widget_destroy), NULL);
			gtk_widget_show (dialog);
			exit(EXIT_FAILURE);
		}
		g_assert(xml != NULL);

		selfp->top = glade_xml_get_widget(xml, "lum_player_tb_top");
		selfp->timer = GTK_LABEL(glade_xml_get_widget(xml, "timer"));
		
		gtk_box_pack_start(GTK_BOX(self), selfp->top, false, false, 0);
		selfp->fullscreen_btn = GTK_TOGGLE_BUTTON(
				glade_xml_get_widget(xml, "fullscreen"));
		g_signal_connect(G_OBJECT(selfp->fullscreen_btn),
			"toggled", G_CALLBACK(self_fullscreen_cb), self);
		glade_xml_signal_connect_data(xml, "properties_cb",
				G_CALLBACK(self_properties_cb), self);
		g_object_unref(G_OBJECT(xml));
		
		xml = glade_xml_new(PACKAGE_DATA_DIR"/liblumiere/liblumiere.glade",
				"lum_player_tb_bottom", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		selfp->bottom = glade_xml_get_widget(xml, "lum_player_tb_bottom");
		selfp->play_pause_btn = glade_xml_get_widget(xml, "play_pause");
		selfp->position_range = GTK_RANGE(glade_xml_get_widget(xml, "position"));
		gtk_range_set_update_policy(selfp->position_range, GTK_UPDATE_DISCONTINUOUS);
		selfp->volume_range = GTK_RANGE(glade_xml_get_widget(xml, "volume"));
		gtk_box_pack_end(GTK_BOX(self), selfp->bottom, false, false, 0);
		gtk_widget_set_sensitive(selfp->play_pause_btn, false);
		
		selfp->play_pause_id = g_signal_connect_swapped(
				G_OBJECT(selfp->play_pause_btn), "toggled",
				G_CALLBACK(self_play_pause), self);

		selfp->play_image = g_object_ref(
				gtk_bin_get_child(GTK_BIN(selfp->play_pause_btn)));
		gtk_widget_show(selfp->pause_image);
		
		glade_xml_signal_connect_data(xml, "position_value_changed_cb",
					G_CALLBACK(self_position_value_changed_cb), self);
		glade_xml_signal_connect_data(xml, "position_button_press_cb",
					G_CALLBACK(self_position_button_press_cb), self);
		glade_xml_signal_connect_data(xml, "position_button_release_cb",
					G_CALLBACK(self_position_button_release_cb), self);
		glade_xml_signal_connect_data(xml, "volume_value_changed_cb",
					G_CALLBACK(self_volume_value_changed_cb), self);
		
		g_object_unref(G_OBJECT(xml));
		g_timer_start(selfp->gtimer);

		gtk_container_set_resize_mode((GtkContainer *) self, GTK_RESIZE_QUEUE);
		if(selfp->can_hide_bars)
			selfp->hideid = g_timeout_add(
					5000, (GSourceFunc) self_hide_bars, self);
	
#line 697 "lum-player.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Lum:Player::set_property"
{
	LumPlayer *self G_GNUC_UNUSED;

	self = LUM_PLAYER (object);

	switch (property_id) {
	case PROP_CONFIG:
		{
#line 82 "lum-player.gob"
{ GObject *___old = (GObject *)self->_priv->config; self->_priv->config = (LumConfig *)g_value_dup_object (VAL); if (___old != NULL) { g_object_unref (G_OBJECT (___old)); } }
#line 718 "lum-player.c"
		}
		break;
	case PROP_STATUS:
		{
#line 97 "lum-player.gob"

			selfp->status = g_value_get_enum(VAL);
			if(selfp->play_pause_btn){
				g_signal_handler_disconnect(selfp->play_pause_btn,
						selfp->play_pause_id);
				switch(selfp->status){
				case PLAYER_STOPPED:
					if(gtk_toggle_button_get_active(
						GTK_TOGGLE_BUTTON(selfp->play_pause_btn))){
						gtk_container_remove(
								GTK_CONTAINER(selfp->play_pause_btn),
								selfp->pause_image);
						gtk_container_add(
								GTK_CONTAINER(selfp->play_pause_btn),
								selfp->play_image);
					}
					gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(selfp->play_pause_btn), false);
					if(selfp->timerid){
						g_source_remove(selfp->timerid);
						selfp->timerid = false;
					}
					break;
				case PLAYER_PLAYING:
					gtk_container_remove(
							GTK_CONTAINER(selfp->play_pause_btn),
							selfp->play_image);
					gtk_container_add(
							GTK_CONTAINER(selfp->play_pause_btn),
							selfp->pause_image);
					gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(selfp->play_pause_btn), true);
					selfp->timerid = g_timeout_add(1000,
						(GtkFunction) self_update_timer, self);
					self_get_is_seekable(self);
					break;
				case PLAYER_PAUSED:
					gtk_toggle_button_set_active(
						GTK_TOGGLE_BUTTON(selfp->play_pause_btn), false);
					if(selfp->timerid){
						g_source_remove(selfp->timerid);
						selfp->timerid = false;
					}
					gtk_container_remove(
							GTK_CONTAINER(selfp->play_pause_btn),
							selfp->pause_image);
					gtk_container_add(
							GTK_CONTAINER(selfp->play_pause_btn),
							selfp->play_image);
					break;
				default:
					break;
				}
				selfp->play_pause_id = g_signal_connect_swapped(G_OBJECT(
						selfp->play_pause_btn),
						"toggled",
						G_CALLBACK(self_play_pause), self);
			}
		
#line 783 "lum-player.c"
		}
		break;
	case PROP_POSITION:
		{
#line 160 "lum-player.gob"
self->_priv->position = g_value_get_double (VAL);
#line 790 "lum-player.c"
		}
		break;
	case PROP_TIME:
		{
#line 168 "lum-player.gob"
self->_priv->time = g_value_get_int (VAL);
#line 797 "lum-player.c"
		}
		break;
	case PROP_IS_SEEKABLE:
		{
#line 176 "lum-player.gob"
self->_priv->is_seekable = g_value_get_boolean (VAL);
#line 804 "lum-player.c"
		}
		break;
	case PROP_CAN_FULLSCREEN:
		{
#line 221 "lum-player.gob"
 selfp->can_fullscreen = g_value_get_boolean(VAL);
			g_object_set(G_OBJECT(selfp->fullscreen_btn), "sensitive", 
					selfp->can_fullscreen, NULL);
#line 813 "lum-player.c"
		}
		break;
	case PROP_FULLSCREEN:
		{
#line 231 "lum-player.gob"
 selfp->fullscreen = g_value_get_boolean(VAL);
		gtk_toggle_button_set_active(selfp->fullscreen_btn, selfp->fullscreen);
		GtkWidget *toplevel = gtk_widget_get_toplevel(GTK_WIDGET(self));
		if (GTK_WIDGET_TOPLEVEL(toplevel)) {
			if(selfp->fullscreen) {
				gtk_window_set_decorated(GTK_WINDOW(toplevel), false);
				gdk_window_fullscreen(toplevel->window);
				if(selfp->config->stop_ssaver)
					scrsaver_disable(selfp->scrsaver);
				if(selfp->hideid)
					g_source_remove(selfp->hideid);
				selfp->hideid = g_timeout_add(5000, (GSourceFunc) self_hide_bars, self);
			} else {
				gtk_window_set_decorated(GTK_WINDOW(toplevel), true);
				gdk_window_unfullscreen(toplevel->window);
				if(selfp->config->stop_ssaver)
					scrsaver_enable(selfp->scrsaver);
			}
		}
		
#line 839 "lum-player.c"
		}
		break;
	case PROP_CAN_HIDE_BARS:
		{
#line 261 "lum-player.gob"
self->_priv->can_hide_bars = g_value_get_boolean (VAL);
#line 846 "lum-player.c"
		}
		break;
	case PROP_MUTE:
		{
#line 268 "lum-player.gob"
self->_priv->mute = g_value_get_boolean (VAL);
#line 853 "lum-player.c"
		}
		break;
	case PROP_REPEAT:
		{
#line 275 "lum-player.gob"
self->repeat = g_value_get_boolean (VAL);
#line 860 "lum-player.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Lum:Player::get_property"
{
	LumPlayer *self G_GNUC_UNUSED;

	self = LUM_PLAYER (object);

	switch (property_id) {
	case PROP_CONFIG:
		{
#line 82 "lum-player.gob"
g_value_set_object (VAL, (gpointer)self->_priv->config);
#line 891 "lum-player.c"
		}
		break;
	case PROP_STATUS:
		{
#line 156 "lum-player.gob"
 g_value_set_enum(VAL, selfp->status); 
#line 898 "lum-player.c"
		}
		break;
	case PROP_POSITION:
		{
#line 160 "lum-player.gob"
g_value_set_double (VAL, self->_priv->position);
#line 905 "lum-player.c"
		}
		break;
	case PROP_TIME:
		{
#line 168 "lum-player.gob"
g_value_set_int (VAL, self->_priv->time);
#line 912 "lum-player.c"
		}
		break;
	case PROP_IS_SEEKABLE:
		{
#line 176 "lum-player.gob"
g_value_set_boolean (VAL, self->_priv->is_seekable);
#line 919 "lum-player.c"
		}
		break;
	case PROP_CAN_FULLSCREEN:
		{
#line 224 "lum-player.gob"
 g_value_set_boolean(VAL, selfp->can_fullscreen); 
#line 926 "lum-player.c"
		}
		break;
	case PROP_FULLSCREEN:
		{
#line 251 "lum-player.gob"
 g_value_set_boolean(VAL, selfp->can_fullscreen); 
#line 933 "lum-player.c"
		}
		break;
	case PROP_CAN_HIDE_BARS:
		{
#line 261 "lum-player.gob"
g_value_set_boolean (VAL, self->_priv->can_hide_bars);
#line 940 "lum-player.c"
		}
		break;
	case PROP_MUTE:
		{
#line 268 "lum-player.gob"
g_value_set_boolean (VAL, self->_priv->mute);
#line 947 "lum-player.c"
		}
		break;
	case PROP_REPEAT:
		{
#line 275 "lum-player.gob"
g_value_set_boolean (VAL, self->repeat);
#line 954 "lum-player.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 82 "lum-player.gob"
LumConfig * 
lum_player_get_config (LumPlayer * self)
#line 973 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_config"
{
#line 82 "lum-player.gob"
		LumConfig* val; g_object_get (G_OBJECT (self), "config", &val, NULL); return val;
}}
#line 980 "lum-player.c"
#undef __GOB_FUNCTION__

#line 82 "lum-player.gob"
void 
lum_player_set_config (LumPlayer * self, LumConfig * val)
#line 986 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_config"
{
#line 82 "lum-player.gob"
		g_object_set (G_OBJECT (self), "config", val, NULL);
}}
#line 993 "lum-player.c"
#undef __GOB_FUNCTION__

#line 156 "lum-player.gob"
LumPlayerStatus 
lum_player_get_status (LumPlayer * self)
#line 999 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_status"
{
#line 90 "lum-player.gob"
		LumPlayerStatus val; g_object_get (G_OBJECT (self), "status", &val, NULL); return val;
}}
#line 1006 "lum-player.c"
#undef __GOB_FUNCTION__

#line 97 "lum-player.gob"
void 
lum_player_set_status (LumPlayer * self, LumPlayerStatus val)
#line 1012 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_status"
{
#line 90 "lum-player.gob"
		g_object_set (G_OBJECT (self), "status", val, NULL);
}}
#line 1019 "lum-player.c"
#undef __GOB_FUNCTION__

#line 160 "lum-player.gob"
gdouble 
lum_player_get_position (LumPlayer * self)
#line 1025 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_position"
{
#line 160 "lum-player.gob"
		gdouble val; g_object_get (G_OBJECT (self), "position", &val, NULL); return val;
}}
#line 1032 "lum-player.c"
#undef __GOB_FUNCTION__

#line 160 "lum-player.gob"
void 
lum_player_set_position (LumPlayer * self, gdouble val)
#line 1038 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_position"
{
#line 160 "lum-player.gob"
		g_object_set (G_OBJECT (self), "position", val, NULL);
}}
#line 1045 "lum-player.c"
#undef __GOB_FUNCTION__

#line 168 "lum-player.gob"
gint 
lum_player_get_time (LumPlayer * self)
#line 1051 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_time"
{
#line 168 "lum-player.gob"
		gint val; g_object_get (G_OBJECT (self), "time", &val, NULL); return val;
}}
#line 1058 "lum-player.c"
#undef __GOB_FUNCTION__

#line 168 "lum-player.gob"
void 
lum_player_set_time (LumPlayer * self, gint val)
#line 1064 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_time"
{
#line 168 "lum-player.gob"
		g_object_set (G_OBJECT (self), "time", val, NULL);
}}
#line 1071 "lum-player.c"
#undef __GOB_FUNCTION__

#line 176 "lum-player.gob"
gboolean 
lum_player_get_is_seekable (LumPlayer * self)
#line 1077 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_is_seekable"
{
#line 176 "lum-player.gob"
		gboolean val; g_object_get (G_OBJECT (self), "is_seekable", &val, NULL); return val;
}}
#line 1084 "lum-player.c"
#undef __GOB_FUNCTION__

#line 176 "lum-player.gob"
void 
lum_player_set_is_seekable (LumPlayer * self, gboolean val)
#line 1090 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_is_seekable"
{
#line 176 "lum-player.gob"
		g_object_set (G_OBJECT (self), "is_seekable", val, NULL);
}}
#line 1097 "lum-player.c"
#undef __GOB_FUNCTION__

#line 224 "lum-player.gob"
gboolean 
lum_player_get_can_fullscreen (LumPlayer * self)
#line 1103 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_can_fullscreen"
{
#line 216 "lum-player.gob"
		gboolean val; g_object_get (G_OBJECT (self), "can_fullscreen", &val, NULL); return val;
}}
#line 1110 "lum-player.c"
#undef __GOB_FUNCTION__

#line 221 "lum-player.gob"
void 
lum_player_set_can_fullscreen (LumPlayer * self, gboolean val)
#line 1116 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_can_fullscreen"
{
#line 216 "lum-player.gob"
		g_object_set (G_OBJECT (self), "can_fullscreen", val, NULL);
}}
#line 1123 "lum-player.c"
#undef __GOB_FUNCTION__

#line 251 "lum-player.gob"
gboolean 
lum_player_get_fullscreen (LumPlayer * self)
#line 1129 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_fullscreen"
{
#line 226 "lum-player.gob"
		gboolean val; g_object_get (G_OBJECT (self), "fullscreen", &val, NULL); return val;
}}
#line 1136 "lum-player.c"
#undef __GOB_FUNCTION__

#line 231 "lum-player.gob"
void 
lum_player_set_fullscreen (LumPlayer * self, gboolean val)
#line 1142 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_fullscreen"
{
#line 226 "lum-player.gob"
		g_object_set (G_OBJECT (self), "fullscreen", val, NULL);
}}
#line 1149 "lum-player.c"
#undef __GOB_FUNCTION__

#line 261 "lum-player.gob"
gboolean 
lum_player_get_can_hide_bars (LumPlayer * self)
#line 1155 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_can_hide_bars"
{
#line 261 "lum-player.gob"
		gboolean val; g_object_get (G_OBJECT (self), "can_hide_bars", &val, NULL); return val;
}}
#line 1162 "lum-player.c"
#undef __GOB_FUNCTION__

#line 261 "lum-player.gob"
void 
lum_player_set_can_hide_bars (LumPlayer * self, gboolean val)
#line 1168 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_can_hide_bars"
{
#line 261 "lum-player.gob"
		g_object_set (G_OBJECT (self), "can_hide_bars", val, NULL);
}}
#line 1175 "lum-player.c"
#undef __GOB_FUNCTION__

#line 268 "lum-player.gob"
gboolean 
lum_player_get_mute (LumPlayer * self)
#line 1181 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_mute"
{
#line 268 "lum-player.gob"
		gboolean val; g_object_get (G_OBJECT (self), "mute", &val, NULL); return val;
}}
#line 1188 "lum-player.c"
#undef __GOB_FUNCTION__

#line 268 "lum-player.gob"
void 
lum_player_set_mute (LumPlayer * self, gboolean val)
#line 1194 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_mute"
{
#line 268 "lum-player.gob"
		g_object_set (G_OBJECT (self), "mute", val, NULL);
}}
#line 1201 "lum-player.c"
#undef __GOB_FUNCTION__

#line 275 "lum-player.gob"
gboolean 
lum_player_get_repeat (LumPlayer * self)
#line 1207 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::get_repeat"
{
#line 275 "lum-player.gob"
		gboolean val; g_object_get (G_OBJECT (self), "repeat", &val, NULL); return val;
}}
#line 1214 "lum-player.c"
#undef __GOB_FUNCTION__

#line 275 "lum-player.gob"
void 
lum_player_set_repeat (LumPlayer * self, gboolean val)
#line 1220 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_repeat"
{
#line 275 "lum-player.gob"
		g_object_set (G_OBJECT (self), "repeat", val, NULL);
}}
#line 1227 "lum-player.c"
#undef __GOB_FUNCTION__


/**
 * lum_player_open_file:
 * @self: your player instance
 * @uri: the URI cannot be NULL
 *
 * implementations can add check here
 *
 * Returns: whether it can open it or not
 **/
#line 369 "lum-player.gob"
bool 
lum_player_open_file (LumPlayer * self, const char * uri, LumPlayerInfo * info)
#line 1243 "lum-player.c"
{
	LumPlayerClass *klass;
#line 369 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 369 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (bool )false);
#line 369 "lum-player.gob"
	g_return_val_if_fail (uri != NULL, (bool )false);
#line 369 "lum-player.gob"
	g_return_val_if_fail (info != NULL, (bool )false);
#line 369 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER_INFO (info), (bool )false);
#line 1256 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->open_file)
		return (*klass->open_file)(self,uri,info);
	else
		return (bool )(false);
}
#line 369 "lum-player.gob"
static bool 
___real_lum_player_open_file (LumPlayer * self G_GNUC_UNUSED, const char * uri, LumPlayerInfo * info)
#line 1267 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::open_file"
{
#line 371 "lum-player.gob"
	
		if(selfp->uri)
			g_free(selfp->uri);
		selfp->uri = g_strdup(uri);
		
		if(selfp->info)
			g_object_remove_weak_pointer(G_OBJECT(selfp->info),
					(gpointer *) &selfp->info);
		g_object_add_weak_pointer(G_OBJECT(info),
				(gpointer *)&selfp->info);
		selfp->info = info;

		gtk_widget_set_sensitive(selfp->play_pause_btn, true);
		self_set_status(self, PLAYER_STOPPED);
		return true;
	}}
#line 1288 "lum-player.c"
#undef __GOB_FUNCTION__

#line 389 "lum-player.gob"
void 
lum_player_play_pause (LumPlayer * self)
#line 1294 "lum-player.c"
{
	LumPlayerClass *klass;
#line 389 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 389 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1301 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->play_pause)
		(*klass->play_pause)(self);
}

#line 392 "lum-player.gob"
void 
lum_player_stop (LumPlayer * self)
#line 1311 "lum-player.c"
{
	LumPlayerClass *klass;
#line 392 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 392 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1318 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->stop)
		(*klass->stop)(self);
}
#line 392 "lum-player.gob"
static void 
___real_lum_player_stop (LumPlayer * self G_GNUC_UNUSED)
#line 1327 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::stop"
{
#line 392 "lum-player.gob"
	
		if(selfp->uri){
			g_free(selfp->uri);
			selfp->uri = NULL;
		}
		if(selfp->info){
			g_object_unref(selfp->info);
			selfp->info = NULL;
		}
		gtk_widget_set_sensitive(selfp->play_pause_btn, false);
		self_set_status(self, PLAYER_STOPPED);
	}}
#line 1344 "lum-player.c"
#undef __GOB_FUNCTION__

#line 406 "lum-player.gob"
int 
lum_player_get_stream_length (LumPlayer * self)
#line 1350 "lum-player.c"
{
	LumPlayerClass *klass;
#line 406 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 406 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (int )0);
#line 1357 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_stream_length)
		return (*klass->get_stream_length)(self);
	else
		return (int )(0);
}

#line 409 "lum-player.gob"
void 
lum_player_set_contrast (LumPlayer * self, double pos)
#line 1369 "lum-player.c"
{
	LumPlayerClass *klass;
#line 409 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 409 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1376 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_contrast)
		(*klass->set_contrast)(self,pos);
}

#line 410 "lum-player.gob"
void 
lum_player_set_brightness (LumPlayer * self, double pos)
#line 1386 "lum-player.c"
{
	LumPlayerClass *klass;
#line 410 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 410 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1393 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_brightness)
		(*klass->set_brightness)(self,pos);
}

#line 411 "lum-player.gob"
void 
lum_player_set_hue (LumPlayer * self, double pos)
#line 1403 "lum-player.c"
{
	LumPlayerClass *klass;
#line 411 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 411 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1410 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_hue)
		(*klass->set_hue)(self,pos);
}

#line 412 "lum-player.gob"
void 
lum_player_set_saturation (LumPlayer * self, double pos)
#line 1420 "lum-player.c"
{
	LumPlayerClass *klass;
#line 412 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 412 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1427 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_saturation)
		(*klass->set_saturation)(self,pos);
}

#line 413 "lum-player.gob"
void 
lum_player_set_eq (LumPlayer * self, int hz, double pos)
#line 1437 "lum-player.c"
{
	LumPlayerClass *klass;
#line 413 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 413 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1444 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_eq)
		(*klass->set_eq)(self,hz,pos);
}

#line 414 "lum-player.gob"
void 
lum_player_set_volume (LumPlayer * self, double vol)
#line 1454 "lum-player.c"
{
	LumPlayerClass *klass;
#line 414 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 414 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1461 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->set_volume)
		(*klass->set_volume)(self,vol);
}
#line 414 "lum-player.gob"
static void 
___real_lum_player_set_volume (LumPlayer * self G_GNUC_UNUSED, double vol)
#line 1470 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_volume"
{
#line 414 "lum-player.gob"
	
		selfp->volume_moving = true;
		gtk_range_set_value(selfp->volume_range, vol);
		self_volume_changed(self, vol);
		selfp->volume_moving = false;
	}}
#line 1481 "lum-player.c"
#undef __GOB_FUNCTION__

#line 420 "lum-player.gob"
double 
lum_player_get_volume (LumPlayer * self)
#line 1487 "lum-player.c"
{
	LumPlayerClass *klass;
#line 420 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (double )0);
#line 420 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (double )0);
#line 1494 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_volume)
		return (*klass->get_volume)(self);
	else
		return (double )(0);
}

#line 421 "lum-player.gob"
bool 
lum_player_next (LumPlayer * self)
#line 1506 "lum-player.c"
{
	LumPlayerClass *klass;
#line 421 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 421 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (bool )0);
#line 1513 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->next)
		return (*klass->next)(self);
	else
		return (bool )(0);
}

#line 422 "lum-player.gob"
bool 
lum_player_prev (LumPlayer * self)
#line 1525 "lum-player.c"
{
	LumPlayerClass *klass;
#line 422 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 422 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (bool )0);
#line 1532 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->prev)
		return (*klass->prev)(self);
	else
		return (bool )(0);
}

#line 425 "lum-player.gob"
bool 
lum_player_is_running (LumPlayer * self)
#line 1544 "lum-player.c"
{
	LumPlayerClass *klass;
#line 425 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 425 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (bool )0);
#line 1551 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->is_running)
		return (*klass->is_running)(self);
	else
		return (bool )(false);
}

#line 426 "lum-player.gob"
bool 
lum_player_can_play (LumPlayer * self)
#line 1563 "lum-player.c"
{
	LumPlayerClass *klass;
#line 426 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 426 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (bool )false);
#line 1570 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->can_play)
		return (*klass->can_play)(self);
	else
		return (bool )(true);
}

#line 428 "lum-player.gob"
char ** 
lum_player_get_mime_types (LumPlayer * self)
#line 1582 "lum-player.c"
{
	LumPlayerClass *klass;
#line 428 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (char ** )0);
#line 428 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (char ** )0);
#line 1589 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_mime_types)
		return (*klass->get_mime_types)(self);
	else
		return (char ** )(0);
}

#line 429 "lum-player.gob"
char ** 
lum_player_get_cdda_list (LumPlayer * self, int * num)
#line 1601 "lum-player.c"
{
	LumPlayerClass *klass;
#line 429 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (char ** )0);
#line 429 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (char ** )0);
#line 1608 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_cdda_list)
		return (*klass->get_cdda_list)(self,num);
	else
		return (char ** )(0);
}

#line 430 "lum-player.gob"
char ** 
lum_player_get_dvd_list (LumPlayer * self, int * num)
#line 1620 "lum-player.c"
{
	LumPlayerClass *klass;
#line 430 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (char ** )0);
#line 430 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (char ** )0);
#line 1627 "lum-player.c"
	klass = LUM_PLAYER_GET_CLASS(self);

	if(klass->get_dvd_list)
		return (*klass->get_dvd_list)(self,num);
	else
		return (char ** )(0);
}

#line 435 "lum-player.gob"
void 
lum_player_playbackfinished (LumPlayer * self)
#line 1639 "lum-player.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 435 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 435 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1651 "lum-player.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[PLAYBACKFINISHED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 438 "lum-player.gob"
void 
lum_player_volume_changed (LumPlayer * self, double volume)
#line 1668 "lum-player.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 438 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 438 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1680 "lum-player.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_DOUBLE);
	g_value_set_double (&___param_values[1], (gdouble ) volume);

	g_signal_emitv (___param_values,
		object_signals[VOLUME_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

#line 445 "lum-player.gob"
static gboolean 
lum_player_update_timer (LumPlayer * self)
#line 1702 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::update_timer"
#line 445 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 445 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (gboolean )0);
#line 1709 "lum-player.c"
{
#line 445 "lum-player.gob"
	
		if(selfp->status == PLAYER_STOPPED){
			selfp->timerid = false;
			return false;
		}

		bool is_seekable = self_get_is_seekable(self);
	
		gtk_widget_set_sensitive(
				GTK_WIDGET(selfp->position_range), is_seekable);
	
		if(is_seekable){
			char text[6];
			double position;
			int time;
			position = self_get_position(self);
			time = self_get_time(self);

			int min = time / 60000;
			int secs = (time / 1000) - (min * 60);
			snprintf(text, sizeof(text), "%.2d:%.2d", min, secs);
			gtk_label_set_text(selfp->timer, text);
			g_object_notify(G_OBJECT(self), "position");
			g_object_notify(G_OBJECT(self), "time");
			
			if(!selfp->position_pressed){
				selfp->in_pos_timer = true;
				gtk_range_set_value(
						selfp->position_range, selfp->position);
				selfp->in_pos_timer = false;
			}
		}
		return true;
	}}
#line 1746 "lum-player.c"
#undef __GOB_FUNCTION__

#line 480 "lum-player.gob"
static void 
___2b_lum_player_dispose (GObject * object G_GNUC_UNUSED)
#line 1752 "lum-player.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Player::dispose"
#line 480 "lum-player.gob"
	g_return_if_fail (object != NULL);
#line 480 "lum-player.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 1762 "lum-player.c"
{
#line 480 "lum-player.gob"
	
		Self *self = SELF(object);
		if(selfp->info){
			g_object_remove_weak_pointer(G_OBJECT(selfp->info),
				    (gpointer *)&selfp->info);
			selfp->info = NULL;
		}
		PARENT_HANDLER(object);
	}}
#line 1774 "lum-player.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 493 "lum-player.gob"
static void 
___2c_lum_player_finalize (GObject * object G_GNUC_UNUSED)
#line 1781 "lum-player.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Lum:Player::finalize"
#line 493 "lum-player.gob"
	g_return_if_fail (object != NULL);
#line 493 "lum-player.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 1791 "lum-player.c"
{
#line 493 "lum-player.gob"
	
		__d;
		Self *self = SELF(object);
		if(selfp->timerid){
			g_source_remove(selfp->timerid);
			selfp->timerid = false;
		}
		if(selfp->hideid){
			g_source_remove(selfp->hideid);
			selfp->hideid = false;
		}

		if(selfp->popup_menu){
			gtk_widget_hide(selfp->popup_menu);
			gtk_widget_destroy(selfp->popup_menu);
			selfp->popup_menu = NULL;
		}
		PARENT_HANDLER(object);
	}}
#line 1813 "lum-player.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 518 "lum-player.gob"
static gboolean 
___2d_lum_player_motion_notify_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventMotion * event)
#line 1820 "lum-player.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->motion_notify_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->motion_notify_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::motion_notify_event"
{
#line 519 "lum-player.gob"
	
		static gdouble old_ticks = 0;
		gdouble new_ticks;
		gulong unused;
		Self *self = SELF(widget);
		if(!GTK_WIDGET_VISIBLE(selfp->top)){
			gtk_widget_show(selfp->top);
		}
		if(!GTK_WIDGET_VISIBLE(selfp->bottom)){
			gtk_widget_show(selfp->bottom);
		}
		new_ticks = g_timer_elapsed(selfp->gtimer, &unused);
		if((new_ticks - old_ticks) <= 5 &&
				(selfp->fullscreen || selfp->can_hide_bars)){
			g_source_remove(selfp->hideid);
			selfp->hideid = false;
		}
		if(selfp->hideid)
			g_source_remove(selfp->hideid);
		selfp->hideid = g_timeout_add(5000, (GSourceFunc) self_hide_bars, self);
		old_ticks = new_ticks;		
		return false;
	}}
#line 1852 "lum-player.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 547 "lum-player.gob"
static gboolean 
___2e_lum_player_button_press_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventButton * event)
#line 1859 "lum-player.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->button_press_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->button_press_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::button_press_event"
{
#line 548 "lum-player.gob"
	
		Self *self = SELF(widget);
		if ((event->button == 4 || event->button == 5) &&
					event->type == GDK_BUTTON_PRESS) {
			int volume = self_get_volume(self);
			if (event->button == 5){
				volume = volume <= 9 ? 0 : volume - 10;
				self_set_volume(self, volume);
			} else if (event->button == 4) {
				volume = volume >= 91 ? 100 : volume + 10;
				self_set_volume(self, volume);
			}
			return true;
		}

		if (event->button == 3) {
			self_do_popup(self, event->button, event->time);
			return true;
		}
		return false;
	}}
#line 1889 "lum-player.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 570 "lum-player.gob"
static gboolean 
___2f_lum_player_popup_menu (GtkWidget * widget G_GNUC_UNUSED)
#line 1896 "lum-player.c"
#define PARENT_HANDLER(___widget) \
	((GTK_WIDGET_CLASS(parent_class)->popup_menu)? \
		(* GTK_WIDGET_CLASS(parent_class)->popup_menu)(___widget): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::popup_menu"
{
#line 570 "lum-player.gob"
	
		Self *self = SELF(widget);

		self_do_popup(self, 0, gtk_get_current_event_time());
		return true;
	}}
#line 1911 "lum-player.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 577 "lum-player.gob"
static gboolean 
___30_lum_player_key_release_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventKey * event)
#line 1918 "lum-player.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->key_release_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->key_release_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Player::key_release_event"
{
#line 578 "lum-player.gob"
	
		Self *self = SELF(widget);
		switch (event->keyval) {
			case GDK_F11:
				if (event->state & GDK_CONTROL_MASK)
					g_object_set(self, "fullscreen", !selfp->fullscreen,
							NULL, NULL);
				break;
			default:
				return PARENT_HANDLER(widget, event);
		}
		return true;
	}}
#line 1940 "lum-player.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 595 "lum-player.gob"
void 
lum_player_show_runtime (LumPlayer * self)
#line 1947 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::show_runtime"
#line 595 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 595 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 1954 "lum-player.c"
{
#line 595 "lum-player.gob"
	
		GladeXML *xml;
		GtkWidget *widget;
		if(selfp->runtime){
			g_object_unref(selfp->runtime);
		}

		xml = glade_xml_new(
				PACKAGE_DATA_DIR"/liblumiere/liblumiere.glade",
				"runtime", GETTEXT_PACKAGE);
		g_assert(xml != NULL);

		if(selfp->info){
			/*TODO remove this hack */
			bool vfx = false;
			g_object_get(self, "GtkXine::show_vfx", &vfx, NULL, NULL);
			selfp->runtime = glade_xml_get_widget(xml, "runtime");
			g_object_ref(selfp->runtime);
			gtk_object_sink(GTK_OBJECT(selfp->runtime));
			widget = glade_xml_get_widget(xml, "close");
			g_signal_connect_swapped(widget, "clicked", G_CALLBACK(gtk_widget_destroy), selfp->runtime);
			g_signal_connect(selfp->runtime, "destroy", G_CALLBACK(gtk_widget_destroyed), &selfp->runtime);
			if(selfp->info->has_video || vfx){
				widget = glade_xml_get_widget(xml, "video");
				gtk_widget_set_sensitive(widget, true);
				widget = glade_xml_get_widget(xml, "video_table");
				glade_xml_signal_connect_data(xml, "video_activate",
					G_CALLBACK(self_video_activate_cb), widget);
				glade_xml_signal_connect_data(xml, "cont_cb",
					G_CALLBACK(self_cont_cb), self);
				glade_xml_signal_connect_data(xml, "bright_cb",
					G_CALLBACK(self_bright_cb), self);
				glade_xml_signal_connect_data(xml, "hue_cb",
					G_CALLBACK(self_hue_cb), self);
				glade_xml_signal_connect_data(xml, "sat_cb",
					G_CALLBACK(self_sat_cb), self);
			}
			if(selfp->info->has_audio){
				widget = glade_xml_get_widget(xml, "equalizer");
				gtk_widget_set_sensitive(widget, true);
				widget = glade_xml_get_widget(xml, "mute");
				gtk_widget_set_sensitive(widget, true);
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(widget), selfp->mute);
				widget = glade_xml_get_widget(xml, "eq_table");
				glade_xml_signal_connect_data(xml, "equalizer_activate",
					G_CALLBACK(self_eq_activate_cb), widget);
				glade_xml_signal_connect_data(xml, "mute_cb",
					G_CALLBACK(self_mute_cb), self);
				glade_xml_signal_connect_data(xml, "eq30_cb",
					G_CALLBACK(self_eq30_cb), self);
				glade_xml_signal_connect_data(xml, "eq60_cb",
					G_CALLBACK(self_eq60_cb), self);
				glade_xml_signal_connect_data(xml, "eq125_cb",
					G_CALLBACK(self_eq125_cb), self);
				glade_xml_signal_connect_data(xml, "eq250_cb",
					G_CALLBACK(self_eq250_cb), self);
				glade_xml_signal_connect_data(xml, "eq500_cb",
					G_CALLBACK(self_eq500_cb), self);
				glade_xml_signal_connect_data(xml, "eq1000_cb",
					G_CALLBACK(self_eq1000_cb), self);
				glade_xml_signal_connect_data(xml, "eq2000_cb",
					G_CALLBACK(self_eq2000_cb), self);
				glade_xml_signal_connect_data(xml, "eq4000_cb",
					G_CALLBACK(self_eq4000_cb), self);
				glade_xml_signal_connect_data(xml, "eq8000_cb",
					G_CALLBACK(self_eq8000_cb), self);
				glade_xml_signal_connect_data(xml, "eq16000_cb",
					G_CALLBACK(self_eq16000_cb), self);
			}
		}
		g_object_unref(xml);
	}}
#line 2030 "lum-player.c"
#undef __GOB_FUNCTION__

#line 669 "lum-player.gob"
void 
lum_player_set_popup_menu (LumPlayer * self, GtkMenu * menu)
#line 2036 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::set_popup_menu"
#line 669 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 669 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 669 "lum-player.gob"
	g_return_if_fail (menu != NULL);
#line 669 "lum-player.gob"
	g_return_if_fail (GTK_IS_MENU (menu));
#line 2047 "lum-player.c"
{
#line 669 "lum-player.gob"
	
		gtk_widget_destroy(selfp->popup_menu);
		selfp->popup_menu = (GtkWidget *) menu;
	}}
#line 2054 "lum-player.c"
#undef __GOB_FUNCTION__

#line 674 "lum-player.gob"
void 
lum_player_show_props_window (const LumPlayerInfo * info)
#line 2060 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::show_props_window"
#line 674 "lum-player.gob"
	g_return_if_fail (info != NULL);
#line 674 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER_INFO (info));
#line 2067 "lum-player.c"
{
#line 674 "lum-player.gob"
	
		GtkWidget *window, *widget, *box;
		GladeXML *xml;
			
		widget = lum_player_info_get_widget(info);
		if(GTK_WIDGET_REALIZED(widget)){
			gtk_window_present(GTK_WINDOW(gtk_widget_get_toplevel(widget)));
			gtk_window_deiconify(GTK_WINDOW(gtk_widget_get_toplevel(widget)));
			return;
		}

		xml = glade_xml_new(PACKAGE_DATA_DIR"/liblumiere/liblumiere.glade",
					"property_window", GETTEXT_PACKAGE);
		g_assert(xml != NULL);
		window = glade_xml_get_widget(xml, "property_window");
		g_assert(GTK_IS_WIDGET(widget));
		box = glade_xml_get_widget(xml, "prop_vbox");
		gtk_container_add(GTK_CONTAINER(box), widget);
		widget = glade_xml_get_widget(xml, "close_button");
		g_signal_connect_swapped(G_OBJECT(widget), "clicked",
				G_CALLBACK(gtk_widget_destroy), window);
		gtk_widget_show_all(window);
		g_object_unref(xml);
	}}
#line 2094 "lum-player.c"
#undef __GOB_FUNCTION__

#line 699 "lum-player.gob"
static bool 
lum_player_hide_bars (LumPlayer * self)
#line 2100 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::hide_bars"
#line 699 "lum-player.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 699 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (self), (bool )false);
#line 2107 "lum-player.c"
{
#line 699 "lum-player.gob"
	
		if(selfp->fullscreen || !selfp->can_fullscreen || selfp->can_hide_bars){
			if(GTK_WIDGET_VISIBLE(selfp->top))
				gtk_widget_hide(selfp->top);
			if(GTK_WIDGET_VISIBLE(selfp->bottom))
				gtk_widget_hide(selfp->bottom);
		}
		return false;
	}}
#line 2119 "lum-player.c"
#undef __GOB_FUNCTION__

#line 709 "lum-player.gob"
static void 
lum_player_do_popup (LumPlayer const * self, gint button, gint time)
#line 2125 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::do_popup"
#line 709 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 709 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 2132 "lum-player.c"
{
#line 709 "lum-player.gob"
	
		gtk_menu_popup (GTK_MENU(selfp->popup_menu),
					NULL, NULL, NULL,
					NULL, button, time);	
	}}
#line 2140 "lum-player.c"
#undef __GOB_FUNCTION__

#line 718 "lum-player.gob"
static void 
lum_player_fullscreen_cb (GtkToggleButton * button, Self * self)
#line 2146 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::fullscreen_cb"
#line 718 "lum-player.gob"
	g_return_if_fail (button != NULL);
#line 718 "lum-player.gob"
	g_return_if_fail (GTK_IS_TOGGLE_BUTTON (button));
#line 718 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 718 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2157 "lum-player.c"
{
#line 719 "lum-player.gob"
	
		if(selfp->fullscreen != gtk_toggle_button_get_active(button))
			g_object_set(G_OBJECT(self), "LumPlayer::fullscreen", !selfp->fullscreen, NULL, NULL);
	}}
#line 2164 "lum-player.c"
#undef __GOB_FUNCTION__

#line 724 "lum-player.gob"
void 
lum_player_properties_cb (GtkButton * button, LumPlayer * self)
#line 2170 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::properties_cb"
#line 724 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 724 "lum-player.gob"
	g_return_if_fail (LUM_IS_PLAYER (self));
#line 2177 "lum-player.c"
{
#line 724 "lum-player.gob"
	
		if(selfp->info)
			self_show_props_window(selfp->info);
	}}
#line 2184 "lum-player.c"
#undef __GOB_FUNCTION__

#line 729 "lum-player.gob"
static void 
lum_player_video_activate_cb (GtkToggleButton * button, gpointer data)
#line 2190 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::video_activate_cb"
{
#line 729 "lum-player.gob"
	
		if(gtk_toggle_button_get_active(button))
			gtk_widget_show_all(GTK_WIDGET(data));
		else
			gtk_widget_hide(GTK_WIDGET(data));
	}}
#line 2201 "lum-player.c"
#undef __GOB_FUNCTION__

#line 736 "lum-player.gob"
static void 
lum_player_eq_activate_cb (GtkToggleButton * button, gpointer data)
#line 2207 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq_activate_cb"
{
#line 736 "lum-player.gob"
	
		if(gtk_toggle_button_get_active(button))
			gtk_widget_show_all(GTK_WIDGET(data));
		else
			gtk_widget_hide(GTK_WIDGET(data));
	}}
#line 2218 "lum-player.c"
#undef __GOB_FUNCTION__

#line 743 "lum-player.gob"
static void 
lum_player_position_value_changed_cb (GtkRange * range, Self * self)
#line 2224 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::position_value_changed_cb"
#line 743 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 743 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 743 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 743 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2235 "lum-player.c"
{
#line 743 "lum-player.gob"
	
		if(!selfp->in_pos_timer)
			if(self_get_is_seekable(self))
				self_set_position(self, gtk_range_get_value(range));
	}}
#line 2243 "lum-player.c"
#undef __GOB_FUNCTION__

#line 749 "lum-player.gob"
static void 
lum_player_volume_value_changed_cb (GtkRange * range, Self * self)
#line 2249 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::volume_value_changed_cb"
#line 749 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 749 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 749 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 749 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2260 "lum-player.c"
{
#line 749 "lum-player.gob"
	
		if(!selfp->volume_moving){
			self_set_volume(self, gtk_range_get_value(range));
		}
	}}
#line 2268 "lum-player.c"
#undef __GOB_FUNCTION__

#line 755 "lum-player.gob"
static bool 
lum_player_position_button_press_cb (GtkWidget * widget, GdkEventButton * event, gpointer data)
#line 2274 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::position_button_press_cb"
#line 755 "lum-player.gob"
	g_return_val_if_fail (widget != NULL, (bool )0);
#line 2279 "lum-player.c"
{
#line 756 "lum-player.gob"
	
		Self *self = SELF(data);

		if(event->button == 1 && event->type == GDK_BUTTON_PRESS)
			selfp->position_pressed = true;
		return false;
	}}
#line 2289 "lum-player.c"
#undef __GOB_FUNCTION__

#line 764 "lum-player.gob"
static bool 
lum_player_position_button_release_cb (GtkWidget * widget, GdkEventButton * event, gpointer data)
#line 2295 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::position_button_release_cb"
#line 764 "lum-player.gob"
	g_return_val_if_fail (widget != NULL, (bool )0);
#line 2300 "lum-player.c"
{
#line 765 "lum-player.gob"
	
		Self *self = SELF(data);
		if(event->button == 1)
			selfp->position_pressed = false;
		return false;
	}}
#line 2309 "lum-player.c"
#undef __GOB_FUNCTION__

#line 772 "lum-player.gob"
static void 
lum_player_cont_cb (GtkRange * range, Self * self)
#line 2315 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::cont_cb"
#line 772 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 772 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 772 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 772 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2326 "lum-player.c"
{
#line 772 "lum-player.gob"
	
		self_set_contrast(self, gtk_range_get_value(range));
	}}
#line 2332 "lum-player.c"
#undef __GOB_FUNCTION__

#line 776 "lum-player.gob"
static void 
lum_player_bright_cb (GtkRange * range, Self * self)
#line 2338 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::bright_cb"
#line 776 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 776 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 776 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 776 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2349 "lum-player.c"
{
#line 776 "lum-player.gob"
	
		self_set_brightness(self, gtk_range_get_value(range));
	}}
#line 2355 "lum-player.c"
#undef __GOB_FUNCTION__

#line 780 "lum-player.gob"
static void 
lum_player_hue_cb (GtkRange * range, Self * self)
#line 2361 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::hue_cb"
#line 780 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 780 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 780 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 780 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2372 "lum-player.c"
{
#line 780 "lum-player.gob"
	
		self_set_hue(self, gtk_range_get_value(range));
	}}
#line 2378 "lum-player.c"
#undef __GOB_FUNCTION__

#line 784 "lum-player.gob"
static void 
lum_player_sat_cb (GtkRange * range, Self * self)
#line 2384 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::sat_cb"
#line 784 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 784 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 784 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 784 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2395 "lum-player.c"
{
#line 784 "lum-player.gob"
	
		self_set_saturation(self, gtk_range_get_value(range));
	}}
#line 2401 "lum-player.c"
#undef __GOB_FUNCTION__

#line 788 "lum-player.gob"
static void 
lum_player_mute_cb (GtkToggleButton * button, Self * self)
#line 2407 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::mute_cb"
#line 788 "lum-player.gob"
	g_return_if_fail (button != NULL);
#line 788 "lum-player.gob"
	g_return_if_fail (GTK_IS_TOGGLE_BUTTON (button));
#line 788 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 788 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2418 "lum-player.c"
{
#line 788 "lum-player.gob"
	
		g_object_set(G_OBJECT(self), "LumPlayer::mute",
				gtk_toggle_button_get_active(button), NULL, NULL);
	}}
#line 2425 "lum-player.c"
#undef __GOB_FUNCTION__

#line 793 "lum-player.gob"
static void 
lum_player_eq30_cb (GtkRange * range, Self * self)
#line 2431 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq30_cb"
#line 793 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 793 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 793 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 793 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2442 "lum-player.c"
{
#line 793 "lum-player.gob"
	
		self_set_eq(self, 30, gtk_range_get_value(range));
	}}
#line 2448 "lum-player.c"
#undef __GOB_FUNCTION__

#line 797 "lum-player.gob"
static void 
lum_player_eq60_cb (GtkRange * range, Self * self)
#line 2454 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq60_cb"
#line 797 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 797 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 797 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 797 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2465 "lum-player.c"
{
#line 797 "lum-player.gob"
	
		self_set_eq(self, 60, gtk_range_get_value(range));
	}}
#line 2471 "lum-player.c"
#undef __GOB_FUNCTION__

#line 800 "lum-player.gob"
static void 
lum_player_eq125_cb (GtkRange * range, Self * self)
#line 2477 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq125_cb"
#line 800 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 800 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 800 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 800 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2488 "lum-player.c"
{
#line 800 "lum-player.gob"
	
		self_set_eq(self, 125, gtk_range_get_value(range));
	}}
#line 2494 "lum-player.c"
#undef __GOB_FUNCTION__

#line 804 "lum-player.gob"
static void 
lum_player_eq250_cb (GtkRange * range, Self * self)
#line 2500 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq250_cb"
#line 804 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 804 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 804 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 804 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2511 "lum-player.c"
{
#line 804 "lum-player.gob"
	
		self_set_eq(self, 250, gtk_range_get_value(range));
	}}
#line 2517 "lum-player.c"
#undef __GOB_FUNCTION__

#line 808 "lum-player.gob"
static void 
lum_player_eq500_cb (GtkRange * range, Self * self)
#line 2523 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq500_cb"
#line 808 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 808 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 808 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 808 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2534 "lum-player.c"
{
#line 808 "lum-player.gob"
	
		self_set_eq(self, 500, gtk_range_get_value(range));
	}}
#line 2540 "lum-player.c"
#undef __GOB_FUNCTION__

#line 812 "lum-player.gob"
static void 
lum_player_eq1000_cb (GtkRange * range, Self * self)
#line 2546 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq1000_cb"
#line 812 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 812 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 812 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 812 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2557 "lum-player.c"
{
#line 812 "lum-player.gob"
	
		self_set_eq(self, 1000, gtk_range_get_value(range));
	}}
#line 2563 "lum-player.c"
#undef __GOB_FUNCTION__

#line 816 "lum-player.gob"
static void 
lum_player_eq2000_cb (GtkRange * range, Self * self)
#line 2569 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq2000_cb"
#line 816 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 816 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 816 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 816 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2580 "lum-player.c"
{
#line 816 "lum-player.gob"
	
		self_set_eq(self, 2000, gtk_range_get_value(range));
	}}
#line 2586 "lum-player.c"
#undef __GOB_FUNCTION__

#line 820 "lum-player.gob"
static void 
lum_player_eq4000_cb (GtkRange * range, Self * self)
#line 2592 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq4000_cb"
#line 820 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 820 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 820 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 820 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2603 "lum-player.c"
{
#line 820 "lum-player.gob"
	
		self_set_eq(self, 4000, gtk_range_get_value(range));
	}}
#line 2609 "lum-player.c"
#undef __GOB_FUNCTION__

#line 824 "lum-player.gob"
static void 
lum_player_eq8000_cb (GtkRange * range, Self * self)
#line 2615 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq8000_cb"
#line 824 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 824 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 824 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 824 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2626 "lum-player.c"
{
#line 824 "lum-player.gob"
	
		self_set_eq(self, 8000, gtk_range_get_value(range));
	}}
#line 2632 "lum-player.c"
#undef __GOB_FUNCTION__

#line 828 "lum-player.gob"
static void 
lum_player_eq16000_cb (GtkRange * range, Self * self)
#line 2638 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::eq16000_cb"
#line 828 "lum-player.gob"
	g_return_if_fail (range != NULL);
#line 828 "lum-player.gob"
	g_return_if_fail (GTK_IS_RANGE (range));
#line 828 "lum-player.gob"
	g_return_if_fail (self != NULL);
#line 828 "lum-player.gob"
	g_return_if_fail (IS_SELF (self));
#line 2649 "lum-player.c"
{
#line 828 "lum-player.gob"
	
		self_set_eq(self, 16000, gtk_range_get_value(range));
	}}
#line 2655 "lum-player.c"
#undef __GOB_FUNCTION__

#line 833 "lum-player.gob"
LumPlayer * 
lum_player_factory (LumConfigBackend player_type, LumConfig * config)
#line 2661 "lum-player.c"
{
#define __GOB_FUNCTION__ "Lum:Player::factory"
#line 833 "lum-player.gob"
	g_return_val_if_fail (config != NULL, (LumPlayer * )NULL);
#line 833 "lum-player.gob"
	g_return_val_if_fail (LUM_IS_CONFIG (config), (LumPlayer * )NULL);
#line 2668 "lum-player.c"
{
#line 834 "lum-player.gob"
	
		GObjectClass *klass;
		switch(player_type) {
		case PLAYER_GL:
#ifdef ENABLE_GLPLAY
			klass = (GObjectClass *)
				g_type_class_peek(lum_glplay_get_type());
			if(klass == NULL)
			klass = (GObjectClass *)
			g_type_class_ref(lum_glplay_get_type());
			g_assert(klass != NULL);
			return LUM_PLAYER(lum_glplay_new(config));
			break;
#endif
		case PLAYER_XINE:
		default:
			klass = g_type_class_peek(gtk_xine_get_type());
			if(klass == NULL)
				klass = (GObjectClass *)
				g_type_class_ref(gtk_xine_get_type());
			g_assert(klass != NULL);
			return LUM_PLAYER(gtk_xine_new(config));
			break;
		}
	}}
#line 2696 "lum-player.c"
#undef __GOB_FUNCTION__
