/* Generated by GOB (v2.0.11) on Thu Apr 14 17:19:43 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "lum-glplay.gob"

/***************************************************************************
                          lum-glplay.gob  -  OpenGL Player Widget
                             -------------------
    begin                : vendredi 07 fvrier 2003
    copyright            : (C) 2002, 2005 by Stphane Konstantaropoulos
    email                : stephane@cs.york.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * LumGlplay extends GtkXine:
 * emebds xine in an OpenGL display, playing the video on a cube,
 * sphere or cylinder, with environment mapping or not.
 * The coolest thing.
 * Features slicing to a supported texture size (my poor Voodoo...)
 * Slicing code taken from vo_gl2.c from the mplayer project.
 * All the playing stuff is taken care of by GtkXine.
 */

#line 37 "lum-glplay.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lum-glplay.h"

#include "lum-glplay-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 56 "lum-glplay.gob"

#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>
#include "rgb2rgb.h"
/* Private functions for snap shot.
 * These codes are mostly taken from xine-ui.
 */

/* internal function use to scale yuv data */
typedef void (*scale_line_func_t) (uint8_t * source, uint8_t * dest,
		int width, int step);

#define PIXSZ 3
/* Holdall structure */
struct prvt_image_s {
 	int     width;
 	int     height;
 	int     ratio_code;
 	int     format;
 	uint8_t *y, *u, *v, *yuy2;
 	uint8_t *img;
	int     u_width, v_width;
 	int     u_height, v_height;
	scale_line_func_t scale_line;
 	unsigned long scale_factor;
};

static void yuy2toyv12 (struct prvt_image_s *image)
{
 	gint    i, j, w2;
 	/*
     * I420 
     */
 	guchar *y = image->y;
 	guchar *u = image->u;
 	guchar *v = image->v;
	guchar *input = image->yuy2;
 	gint    width = image->width;
 	gint    height = image->height;
 
	w2 = width / 2;
	for (i = 0; i < height; i += 2)
 	{
		for (j = 0; j < w2; j++)
		{
	 	/*
	     * packed YUV 422 is: Y[i] U[i] Y[i+1] V[i] 
	     */
	 		*(y++) = *(input++);
	 		*(u++) = *(input++);
	 		*(y++) = *(input++);
	 		*(v++) = *(input++);
		}
		
	/*
	 * down sampling 
	 */

	for (j = 0; j < w2; j++)
	{
	    /*
	     * skip every second line for U and V 
	     */
	    *(y++) = *(input++);
	    input++;
	    *(y++) = *(input++);
	    input++;
	}
    }
}

/* the texture structure */
struct TexSquare{
	GLubyte *texture;
	GLuint texobj;
	int isTexture;
	GLfloat fx1, fy1, fx2, fy2, fx3, fy3, fx4, fy4;
	GLfloat xcov, ycov;
	int isDirty;
	int dirtyXoff, dirtyYoff, dirtyWidth, dirtyHeight;
};


#line 144 "lum-glplay.c"
/* self casting macros */
#define SELF(x) LUM_GLPLAY(x)
#define SELF_CONST(x) LUM_GLPLAY_CONST(x)
#define IS_SELF(x) LUM_IS_GLPLAY(x)
#define TYPE_SELF LUM_TYPE_GLPLAY
#define SELF_CLASS(x) LUM_GLPLAY_CLASS(x)

#define SELF_GET_CLASS(x) LUM_GLPLAY_GET_CLASS(x)

/* self typedefs */
typedef LumGlplay Self;
typedef LumGlplayClass SelfClass;

/* here are local prototypes */
static void lum_glplay_init (LumGlplay * o) G_GNUC_UNUSED;
static void lum_glplay_class_init (LumGlplayClass * c) G_GNUC_UNUSED;
static gboolean ___2_lum_glplay_key_press_event (GtkWidget * widget, GdkEventKey * event) G_GNUC_UNUSED;
static void ___3_lum_glplay_load_video_out_driver (GtkXine * parent) G_GNUC_UNUSED;
static bool ___4_lum_glplay_play (GtkXine * parent) G_GNUC_UNUSED;
static void ___5_lum_glplay_stop (LumPlayer * player) G_GNUC_UNUSED;
static bool lum_glplay_initgl (GtkWidget * widget, LumGlplay * self) G_GNUC_UNUSED;
static bool lum_glplay_resize (GtkWidget * widget, GtkAllocation * allocation, gpointer data) G_GNUC_UNUSED;
static void lum_glplay_backList (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_cubeList (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_sphereList (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_cylList (LumGlplay * self) G_GNUC_UNUSED;
static bool lum_glplay_draw (gpointer data) G_GNUC_UNUSED;
static void lum_glplay_get_frame (LumGlplay * self) G_GNUC_UNUSED;
static bool lum_glplay_get_current_frame_rgb (LumGlplay * self, int * width_ret, int * height_ret) G_GNUC_UNUSED;
static void lum_glplay_initTextures (LumGlplay * self) G_GNUC_UNUSED;
static void lum_glplay_resetTexturePointers (LumGlplay * self, guchar * imageSource) G_GNUC_UNUSED;
static void lum_glplay_CalcFlatPoint (LumGlplay * self, int x, int y, GLfloat * px, GLfloat * py) G_GNUC_UNUSED;
static void lum_glplay_setupTextureDirtyArea (LumGlplay * self, int x, int y, int w, int h) G_GNUC_UNUSED;
static void lum_glplay_cleanup (LumGlplay * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkXineClass *parent_class = NULL;

/* Short form macros */
#define self_new lum_glplay_new
#define self_initgl lum_glplay_initgl
#define self_resize lum_glplay_resize
#define self_backList lum_glplay_backList
#define self_cubeList lum_glplay_cubeList
#define self_sphereList lum_glplay_sphereList
#define self_cylList lum_glplay_cylList
#define self_draw lum_glplay_draw
#define self_get_frame lum_glplay_get_frame
#define self_get_current_frame_rgb lum_glplay_get_current_frame_rgb
#define self_initTextures lum_glplay_initTextures
#define self_resetTexturePointers lum_glplay_resetTexturePointers
#define self_CalcFlatPoint lum_glplay_CalcFlatPoint
#define self_setupTextureDirtyArea lum_glplay_setupTextureDirtyArea
#define self_cleanup lum_glplay_cleanup
GType
lum_glplay_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LumGlplayClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lum_glplay_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LumGlplay),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lum_glplay_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_XINE, "LumGlplay", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LumGlplay *)g_object_new(lum_glplay_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LumGlplay * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LumGlplay *
GET_NEW_VARG (const char *first, ...)
{
	LumGlplay *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LumGlplay *)g_object_new_valist (lum_glplay_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::dispose"
	LumGlplay *self G_GNUC_UNUSED = LUM_GLPLAY (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 143 "lum-glplay.gob"
	if(self->_priv->area) { g_object_unref ((gpointer) self->_priv->area); self->_priv->area = NULL; }
#line 251 "lum-glplay.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Lum:Glplay::finalize"
	LumGlplay *self G_GNUC_UNUSED = LUM_GLPLAY (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 162 "lum-glplay.gob"
	if(self->_priv->data_local) { free ((gpointer) self->_priv->data_local); self->_priv->data_local = NULL; }
#line 266 "lum-glplay.c"
#line 164 "lum-glplay.gob"
	if(self->_priv->quadratic) { gluDeleteQuadric ((gpointer) self->_priv->quadratic); self->_priv->quadratic = NULL; }
#line 269 "lum-glplay.c"
}
#undef __GOB_FUNCTION__

static void 
lum_glplay_init (LumGlplay * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Glplay::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,TYPE_SELF,LumGlplayPrivate);
#line 56 "lum-glplay.gob"
	o->_priv->initialized = true;
#line 280 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->timeout = true;
#line 283 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->tex_width = 0;
#line 286 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->tex_height = 0;
#line 289 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->image_bytes = 2;
#line 292 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->gl_internal_format = GL_RGB5;
#line 295 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->gl_bitmap_format = GL_RGB;
#line 298 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->gl_bitmap_type = GL_UNSIGNED_SHORT_5_6_5;
#line 301 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->texnumx = 0;
#line 304 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->texnumy = 0;
#line 307 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->memory_x_len = 0;
#line 310 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->memory_x_start_offset = 0;
#line 313 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->raw_line_len = 0;
#line 316 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->texpercx = 0;
#line 319 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->texpercy = 0;
#line 322 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->data_local = NULL;
#line 325 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->angle = 0.0;
#line 328 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->quadratic = NULL;
#line 331 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->ready = true;
#line 334 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->env = true;
#line 337 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->back = true;
#line 340 "lum-glplay.c"
#line 56 "lum-glplay.gob"
	o->_priv->shape = 0;
#line 343 "lum-glplay.c"
}
#undef __GOB_FUNCTION__
static void 
lum_glplay_class_init (LumGlplayClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Lum:Glplay::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;
	GtkXineClass *gtk_xine_class = (GtkXineClass *)c;
	LumPlayerClass *lum_player_class = (LumPlayerClass *)c;

	g_type_class_add_private(c,sizeof(LumGlplayPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_XINE);

#line 245 "lum-glplay.gob"
	gtk_widget_class->key_press_event = ___2_lum_glplay_key_press_event;
#line 267 "lum-glplay.gob"
	gtk_xine_class->load_video_out_driver = ___3_lum_glplay_load_video_out_driver;
#line 274 "lum-glplay.gob"
	gtk_xine_class->play = ___4_lum_glplay_play;
#line 341 "lum-glplay.gob"
	lum_player_class->stop = ___5_lum_glplay_stop;
#line 367 "lum-glplay.c"
	g_object_class->dispose = ___dispose;
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 174 "lum-glplay.gob"
GtkWidget * 
lum_glplay_new (LumConfig * config)
#line 378 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::new"
#line 174 "lum-glplay.gob"
	g_return_val_if_fail (config != NULL, (GtkWidget * )0);
#line 174 "lum-glplay.gob"
	g_return_val_if_fail (LUM_IS_CONFIG (config), (GtkWidget * )0);
#line 385 "lum-glplay.c"
{
#line 174 "lum-glplay.gob"
	
		Self *self = GET_NEW_VARG("LumPlayer::config", config,
				"GtkWidget::can-focus", true,
				"GtkBox::homogeneous", false,
				"GtkBox::spacing", 0,
			    	NULL, NULL);
#ifndef NDEBUG
		printf(__FILE__ ": new\n");
#endif

		int attrlist[] = {
			GDK_GL_RGBA,
			GDK_GL_DOUBLEBUFFER,
			GDK_GL_RED_SIZE, 4,
			GDK_GL_GREEN_SIZE, 4,
			GDK_GL_BLUE_SIZE, 4,
			GDK_GL_DEPTH_SIZE, 16,
			GDK_GL_NONE
			};
		int attrlist2[] = {
			GDK_GL_RGBA,
			GDK_GL_RED_SIZE, 4,
			GDK_GL_GREEN_SIZE, 4,
			GDK_GL_BLUE_SIZE, 4,
			GDK_GL_DEPTH_SIZE, 16,
			GDK_GL_NONE
			};
	
		if(gdk_gl_query() == false) {
			g_message("OpenGL not supported!\n");
			g_object_unref(self);
			return NULL;
		}


		if((selfp->area = GTK_GL_AREA(gtk_gl_area_new(attrlist))) == NULL){
			g_message("Error creating GtkGLArea doublebuffered!\n");
			if((selfp->area = 
					GTK_GL_AREA(gtk_gl_area_new(attrlist2))) == NULL){
				g_message("Error creating GtkGLArea singlebuffered!\n");
				g_object_unref(self);
				return NULL;
			}
		}
		
		g_object_ref(selfp->area);
		
		gtk_widget_set_events(GTK_WIDGET(selfp->area),
				GDK_EXPOSURE_MASK|
				GDK_KEY_PRESS_MASK|
				GDK_KEY_RELEASE_MASK|
				GDK_BUTTON_PRESS_MASK|
				GDK_BUTTON_RELEASE_MASK|
				GDK_POINTER_MOTION_MASK|
				GDK_POINTER_MOTION_HINT_MASK);

		g_signal_connect(G_OBJECT(selfp->area), "size_allocate",
				G_CALLBACK(self_resize), self);

//		g_signal_connect (G_OBJECT(selfp->area), "realize",
//                    G_CALLBACK(self_initgl), self);

		gtk_box_pack_start(GTK_BOX(self),
				GTK_WIDGET(selfp->area),
				true, true, 0);

		gtk_widget_show_all(GTK_WIDGET(self));
		return GTK_WIDGET(self);
	}}
#line 457 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 245 "lum-glplay.gob"
static gboolean 
___2_lum_glplay_key_press_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventKey * event)
#line 463 "lum-glplay.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->key_press_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->key_press_event)(___widget,___event): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "Lum:Glplay::key_press_event"
{
#line 246 "lum-glplay.gob"
	
		Self *self = SELF(widget);

		switch(event->keyval) {
			case GDK_e:
				selfp->env = !selfp->env;
				break;
			case GDK_b:
				selfp->back = !selfp->back;
				break;
			case GDK_s:
				selfp->shape++ ;
				if(selfp->shape > 3)
					selfp->shape = 0;
				break;
			default:
				return false;
		}
		return true;
	}}
#line 492 "lum-glplay.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 267 "lum-glplay.gob"
static void 
___3_lum_glplay_load_video_out_driver (GtkXine * parent G_GNUC_UNUSED)
#line 499 "lum-glplay.c"
#define PARENT_HANDLER(___parent) \
	{ if(GTK_XINE_CLASS(parent_class)->load_video_out_driver) \
		(* GTK_XINE_CLASS(parent_class)->load_video_out_driver)(___parent); }
{
#define __GOB_FUNCTION__ "Lum:Glplay::load_video_out_driver"
#line 267 "lum-glplay.gob"
	g_return_if_fail (parent != NULL);
#line 267 "lum-glplay.gob"
	g_return_if_fail (GTK_IS_XINE (parent));
#line 509 "lum-glplay.c"
{
#line 267 "lum-glplay.gob"
	
		parent->_priv->vo_driver =
				xine_open_video_driver (
					GTK_XINE_GET_CLASS(parent)->xine,
					"none", XINE_VISUAL_TYPE_NONE, NULL);
	}}
#line 518 "lum-glplay.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 274 "lum-glplay.gob"
static bool 
___4_lum_glplay_play (GtkXine * parent G_GNUC_UNUSED)
#line 525 "lum-glplay.c"
#define PARENT_HANDLER(___parent) \
	((GTK_XINE_CLASS(parent_class)->play)? \
		(* GTK_XINE_CLASS(parent_class)->play)(___parent): \
		((bool )0))
{
#define __GOB_FUNCTION__ "Lum:Glplay::play"
#line 274 "lum-glplay.gob"
	g_return_val_if_fail (parent != NULL, (bool )0);
#line 274 "lum-glplay.gob"
	g_return_val_if_fail (GTK_IS_XINE (parent), (bool )0);
#line 536 "lum-glplay.c"
{
#line 274 "lum-glplay.gob"
	
		Self *self = SELF(parent);
#ifndef NDEBUG
		printf(__FILE__ ": play\n");
#endif
		int error;
		LumPlayerInfo *info = ((LumPlayer *) self)->_priv->info;
		if(info == NULL)
			return false;

		if(selfp->timeout){
			g_source_remove(selfp->timeout);
			selfp->timeout = false;
		}
		if(selfp->initialized)
				self_cleanup(self);

		if(GTK_XINE(self)->_priv->stream == NULL) {
			gtk_xine_load_video_out_driver(GTK_XINE(self));
			gtk_xine_load_audio_out_driver(GTK_XINE(self));
			GTK_XINE(self)->_priv->stream = xine_stream_new (GTK_XINE_GET_CLASS(GTK_XINE(self))->xine,
						GTK_XINE(self)->_priv->ao_driver, GTK_XINE(self)->_priv->vo_driver);
			GTK_XINE(self)->_priv->ev_queue = xine_event_new_queue (GTK_XINE(self)->_priv->stream);
			xine_event_create_listener_thread (GTK_XINE(self)->_priv->ev_queue,
					gtk_xine_event, (gpointer) self);
		}
		self_initgl(GTK_WIDGET(selfp->area), self);
		if(info->has_video || GTK_XINE(self)->_priv->show_vfx)
			selfp->timeout = g_timeout_add(50, (GSourceFunc) self_draw, self);

		if(xine_get_status (GTK_XINE(self)->_priv->stream) == XINE_STATUS_PLAY)
			xine_stop(GTK_XINE(self)->_priv->stream);
		error = xine_open (GTK_XINE(self)->_priv->stream,
				((LumPlayer *) self)->_priv->uri);
		if (error == 0) {
			lum_player_stop (LUM_PLAYER(self));
			printf("xine error\n");
			return false;
		}

		if (xine_get_stream_info (GTK_XINE(self)->_priv->stream,
				XINE_STREAM_INFO_VIDEO_HANDLED) == false
				&& xine_get_stream_info (GTK_XINE(self)->_priv->stream,
				XINE_STREAM_INFO_AUDIO_HANDLED) == false) {
			char *name = g_strdup (xine_get_meta_info (GTK_XINE(self)->_priv->stream,
					XINE_META_INFO_VIDEOCODEC));
			lum_player_stop (LUM_PLAYER(self));
			
			g_error("Xine error.\nReason: Video type '%s' is not handled.", name);
			g_free (name);
			return false;
		}

		error = xine_play (GTK_XINE(self)->_priv->stream, 0, 0);

		if (error == 0){
			lum_player_stop (LUM_PLAYER(self));
			//self_xine_error (self);
			return false;
		}
	
#ifndef NDEBUG
		printf(__FILE__ ": out play\n");
#endif
		return true;
	}}
#line 605 "lum-glplay.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 341 "lum-glplay.gob"
static void 
___5_lum_glplay_stop (LumPlayer * player G_GNUC_UNUSED)
#line 612 "lum-glplay.c"
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->stop) \
		(* LUM_PLAYER_CLASS(parent_class)->stop)(___player); }
{
#define __GOB_FUNCTION__ "Lum:Glplay::stop"
{
#line 341 "lum-glplay.gob"
	
#ifndef NDEBUG
		printf(__FILE__ ": stop\n");
#endif
		Self *self = SELF(player);
		if(selfp->timeout){
			g_source_remove(selfp->timeout);
			selfp->timeout = false;
		}
		if(selfp->initialized)
				self_cleanup(self);

		PARENT_HANDLER(player);
#ifndef NDEBUG
		printf(__FILE__ ": stopped\n");
#endif
	}}
#line 637 "lum-glplay.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 364 "lum-glplay.gob"
static bool 
lum_glplay_initgl (GtkWidget * widget, LumGlplay * self)
#line 644 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::initgl"
{
#line 364 "lum-glplay.gob"
	
		int width, height;
#ifndef NDEBUG
		printf(__FILE__ ": initgl (realizing glarea)\n");
#endif
		if(LUM_PLAYER(self)->_priv->info){
			width = LUM_PLAYER(self)->_priv->info->video_width;
			height = LUM_PLAYER(self)->_priv->info->video_height;
			if(width == -1 || height == -1){
				width = 320;
				height = 240;
			}
		} else
			return true;

		GtkAllocation alloc = {0, 0, width, height};
		self_resize(GTK_WIDGET(selfp->area), &alloc, self);
		gtk_widget_size_allocate(GTK_WIDGET(selfp->area), &alloc);
		
		if(!GTK_WIDGET_REALIZED(selfp->area))
			return true;
		else if(gtk_gl_area_make_current(selfp->area) == false)
			return true;

		selfp->data_local = malloc(selfp->image_bytes *
				width * height);
		memset(selfp->data_local, 128, selfp->image_bytes *
				width * height);
		
		selfp->tex_width = width;
		selfp->tex_height = height;

		self_initTextures(self);
		yuv2rgb_init(16, MODE_RGB);
		
		glPixelStorei (GL_UNPACK_ROW_LENGTH, selfp->memory_x_len);

		selfp->list[0] = glGenLists(5);
		selfp->list[1] = selfp->list[0] + 1;
		selfp->list[2] = selfp->list[1] + 1;
		selfp->list[3] = selfp->list[2] + 1;

		selfp->quadratic = gluNewQuadric();
		gluQuadricNormals(selfp->quadratic, GLU_SMOOTH);
		gluQuadricTexture(selfp->quadratic, GL_TRUE);
		glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
		glClearDepth(1.0f);
		glDepthFunc(GL_LEQUAL);
		glEnable(GL_DEPTH_TEST);
		glShadeModel(GL_SMOOTH);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		glEnable(GL_TEXTURE_2D);

		glNewList(selfp->list[BACK], GL_COMPILE);
			lum_glplay_backList(self);
		glEndList();
		glNewList(selfp->list[CUBE], GL_COMPILE);
			lum_glplay_cubeList(self);
		glEndList();
		glNewList(selfp->list[SPHERE], GL_COMPILE);
			lum_glplay_sphereList(self);
		glEndList();
		glNewList(selfp->list[CYL], GL_COMPILE);
			lum_glplay_cylList(self);
		glEndList();

		glFlush();

#ifndef NDEBUG
		printf(__FILE__ ": initgl (realized glarea)\n");
#endif
		selfp->initialized = true;

		return true;
	}}
#line 724 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 441 "lum-glplay.gob"
static bool 
lum_glplay_resize (GtkWidget * widget, GtkAllocation * allocation, gpointer data)
#line 730 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::resize"
#line 441 "lum-glplay.gob"
	g_return_val_if_fail (widget != NULL, (bool )0);
#line 735 "lum-glplay.c"
{
#line 443 "lum-glplay.gob"
	
		Self *self = SELF(data);
		gfloat ratio;
		int w = widget->allocation.width;
		int h = widget->allocation.height;
	
		selfp->ready = false;
		
		gtk_widget_size_allocate(GTK_WIDGET(selfp->area), allocation);
		gtk_widget_grab_focus(GTK_WIDGET(self));

		if (h == 0)
			h = 1;

		ratio = (float) w / (float) h;

		if(!GTK_WIDGET_REALIZED(selfp->area))
			return true;

		if (!gtk_gl_area_make_current (selfp->area))
			return true;
		
		glViewport(0, 0, (int) w, (int) h);

		/* change to the projection matrix and set our viewing volume. */
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(90.0f, ratio, 0.1f, 100.0f);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glFlush();
		
		selfp->ready = true;
		return true;
	}}
#line 774 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 485 "lum-glplay.gob"
static void 
lum_glplay_backList (LumGlplay * self)
#line 780 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::backList"
#line 485 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 485 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 787 "lum-glplay.c"
{
#line 485 "lum-glplay.gob"
	
		struct TexSquare *square;
		int i, j;
		int width, height;

		if(LUM_PLAYER(self)->_priv->info){
			width = LUM_PLAYER(self)->_priv->info->video_width;
			height = LUM_PLAYER(self)->_priv->info->video_height;
			if(width == -1 || height == -1){
				width = 320;
				height = 240;
			}
		} else
			return;

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho (0, 1, 1, 0, -1.0, 20.0);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
			
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,-20);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,-20);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,-20);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,-20);
				glEnd();
			}
		}
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(90.0f, 
			((float)width) / ((float)height), 0.1f, 100.0f);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	}}
#line 836 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 538 "lum-glplay.gob"
static void 
lum_glplay_cubeList (LumGlplay * self)
#line 842 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::cubeList"
#line 538 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 538 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 849 "lum-glplay.c"
{
#line 538 "lum-glplay.gob"
	
		struct TexSquare *square;
		int i, j;

		glRotatef (selfp->angle*1.3f, 1.0f, 0.0f, 0.0f);
		glRotatef (selfp->angle*1.1f, 0.0f, 1.0f, 0.0f);
		glRotatef (selfp->angle*1.2f, 0.0f, 0.0f, 1.0f);
		glScalef(15, 15, 15);
		/*front face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,0);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,0);
				glEnd();
			}
		}
		/*back face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,
							selfp->texgrid->fy1 - selfp->texgrid->fy4);
				glEnd();
			}
		}
		/*top face*/
		if(selfp->texnumx == 1 && selfp->texnumy == 1){
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx2,  square->fy2,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx2,  square->fy2,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx1,  square->fy1,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		/*bottom face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx4,  square->fy4,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx3,  square->fy3,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx4,  square->fy4,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		/*left face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx1,  square->fy1,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx4,  square->fy4,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx4,  square->fy4,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx1,  square->fy1,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		/*right face*/
		for (i = 0; i < selfp->texnumy; i++){
			for (j = 0; j < selfp->texnumx; j++){
				square = selfp->texgrid + i * selfp->texnumx + j;
			
				glBindTexture(GL_TEXTURE_2D, square->texobj);
				glBegin(GL_QUADS);
					glTexCoord2f(0,0);
					glVertex3f(square->fx2,  square->fy2,0);
					glTexCoord2f(0,square->ycov);
					glVertex3f(square->fx3,  square->fy3,0);
					glTexCoord2f(square->xcov, square->ycov);
					glVertex3f(square->fx3,  square->fy3,
								square->fy1 - square->fy4);
					glTexCoord2f(square->xcov, 0);
					glVertex3f(square->fx2,  square->fy2,
								square->fy1 - square->fy4);
				glEnd();
			}
		}
		}
	}}
#line 983 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 671 "lum-glplay.gob"
static void 
lum_glplay_sphereList (LumGlplay * self)
#line 989 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::sphereList"
#line 671 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 671 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 996 "lum-glplay.c"
{
#line 671 "lum-glplay.gob"
	
		glTexParameteri(GL_TEXTURE_2D,
					GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,
					GL_TEXTURE_MIN_FILTER,GL_NEAREST);
		glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
		glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

		glBindTexture(GL_TEXTURE_2D, selfp->texgrid->texobj);
		glRotatef (selfp->angle*1.3f, 1.0f, 0.0f, 0.0f);
		glRotatef (selfp->angle*1.1f, 0.0f, 1.0f, 0.0f);
		glRotatef (selfp->angle*1.2f, 0.0f, 0.0f, 1.0f);
		gluSphere(selfp->quadratic,5.0f,20,20);
	}}
#line 1013 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 687 "lum-glplay.gob"
static void 
lum_glplay_cylList (LumGlplay * self)
#line 1019 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::cylList"
#line 687 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 687 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1026 "lum-glplay.c"
{
#line 687 "lum-glplay.gob"
	
		glBindTexture(GL_TEXTURE_2D, selfp->texgrid->texobj);
		glRotatef (selfp->angle*1.3f, 1.0f, 0.0f, 0.0f);
		glRotatef (selfp->angle*1.1f, 0.0f, 1.0f, 0.0f);
		glRotatef (selfp->angle*1.2f, 0.0f, 0.0f, 1.0f);
		glTranslatef(0.0f,0.0f,-1.5f);
		gluCylinder(selfp->quadratic,2.5f,2.5f,5.0f,32,32);
	}}
#line 1037 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 699 "lum-glplay.gob"
static bool 
lum_glplay_draw (gpointer data)
#line 1043 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::draw"
{
#line 699 "lum-glplay.gob"
	
		Self *self = SELF(data);
#ifndef NDEBUG
		printf(__FILE__ ": draw\n");	
#endif
		if(!selfp->ready)
			return true;

		if(!GTK_WIDGET_REALIZED(selfp->area))
			return true;

		if(!gtk_gl_area_make_current(selfp->area))
			return true;

		glEnable(GL_TEXTURE_2D);
		
		self_get_frame(self);

		glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		if(selfp->back)
			glCallList(selfp->list[BACK]);

		glLoadIdentity ();
		glTranslatef (0.0f, 0.0f, -10);

		if(selfp->env){
			glEnable(GL_TEXTURE_GEN_S);
			glEnable(GL_TEXTURE_GEN_T);
		}

		glRotatef(selfp->angle*2.3f,1.0f,0.0f,0.0f);
		glRotatef(selfp->angle*1.8f,0.0f,1.0f,0.0f);
		glTranslatef(0.0f,0.0f,10.0f);

		switch(selfp->shape) {
			case 0:
			glCallList(selfp->list[CUBE]);
				break;
			case 1:
				glCallList(selfp->list[SPHERE]);
				break;
			case 2:
				glCallList(selfp->list[CYL]);
				break;
			case 3:
			default:
				break;
		}
		if(selfp->env){
			glDisable(GL_TEXTURE_GEN_S);
			glDisable(GL_TEXTURE_GEN_T);
		}
			
		glFlush ();
		/* swap */
		gtk_gl_area_swap_buffers(selfp->area);

		selfp->angle = selfp->angle + 1.0f;
		if(selfp->angle > 20000.0f)
			selfp->angle = 0.0f;
		return true;
	}}
#line 1110 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 763 "lum-glplay.gob"
static void 
lum_glplay_get_frame (LumGlplay * self)
#line 1116 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::get_frame"
#line 763 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 763 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1123 "lum-glplay.c"
{
#line 763 "lum-glplay.gob"
	
		int w = 0, h = 0;
		static int i = 0;
		int width, height;
		if(LUM_PLAYER(self)->_priv->info){
			width = LUM_PLAYER(self)->_priv->info->video_width;
			height = LUM_PLAYER(self)->_priv->info->video_height;
			if(width == -1 || height == -1){
				width = 320;
				height = 240;
			}
		} else
			return;

		/* Update The Texture */
		if(LUM_PLAYER(self)->_priv->status == PLAYER_PLAYING && (++i % 2 == 0)){
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
			glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
			
			if(!self_get_current_frame_rgb(self, &w, &h))
				return;
			self_resetTexturePointers(self, selfp->data_local);
			lum_glplay_setupTextureDirtyArea(self, 0, 0, width, height);
			if(selfp->data_local){
				int i, j;
				struct TexSquare *square;
				for (i = 0; i < selfp->texnumy; i++){
					for (j = 0; j < selfp->texnumx; j++){
						square = selfp->texgrid + i * selfp->texnumx + j;
						glBindTexture(GL_TEXTURE_2D, square->texobj);
						glTexSubImage2D (GL_TEXTURE_2D, 0, 0, 0,
							square->dirtyWidth,
							square->dirtyHeight, GL_RGB,
							selfp->gl_bitmap_type, square->texture);
					}
				}
			}
		}
	}}
#line 1167 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 808 "lum-glplay.gob"
static bool 
lum_glplay_get_current_frame_rgb (LumGlplay * self, int * width_ret, int * height_ret)
#line 1173 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::get_current_frame_rgb"
#line 808 "lum-glplay.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 808 "lum-glplay.gob"
	g_return_val_if_fail (LUM_IS_GLPLAY (self), (bool )false);
#line 1180 "lum-glplay.c"
{
#line 810 "lum-glplay.gob"
	
		GtkXine *gtx = GTK_XINE(self);
		int    err = 0;
		struct prvt_image_s *image;
		int    width, height;

	    g_return_val_if_fail (GTK_XINE_GET_CLASS(gtx)->xine, false);
	    g_return_val_if_fail (gtx->_priv->stream != false, 0);

	    image = g_new0 (struct prvt_image_s, 1);
	    if (!image){
		    *width_ret = 0;
		    *height_ret = 0;
		    return false;
		}

	    image->y = image->u = image->v = image->yuy2 = image->img = NULL;

	    width = xine_get_stream_info (gtx->_priv->stream,
		    XINE_STREAM_INFO_VIDEO_WIDTH);
	    height = xine_get_stream_info (gtx->_priv->stream,
		    XINE_STREAM_INFO_VIDEO_HEIGHT);

	    image->img = g_malloc (width * height * 2);

		err = xine_get_current_frame (gtx->_priv->stream,
				  &image->width, &image->height,
				  &image->ratio_code,
				  &image->format, image->img);

		switch (image->format){
			case XINE_IMGFMT_YV12:
				image->y = image->img;
				image->u = image->img + (image->width * image->height);
				image->v =
					image->img + (image->width * image->height) +
					(image->width * image->height) / 4;
				image->u_width = ((image->width + 1) / 2);
				image->v_width = ((image->width + 1) / 2);
				image->u_height = ((image->height + 1) / 2);
				image->v_height = ((image->height + 1) / 2);
				break;
			case XINE_IMGFMT_YUY2:
				image->yuy2 = image->img;
				image->u_width = ((image->width + 1) / 2);
				image->v_width = ((image->width + 1) / 2);
				image->u_height = ((image->height + 1) / 2);
				image->v_height = ((image->height + 1) / 2);
				break;
		}
		if(image->format == XINE_IMGFMT_YUY2){
			yuy2toyv12(image);
		}
			
		if (!image->img){
			*width_ret = 0;
			*height_ret = 0;

			g_free (image->img);
			g_free (image);

			return false;
	    }

		yuv2rgb (selfp->data_local, image->y, image->u,
				image->v, image->width, image->height,
				image->width * selfp->image_bytes,
				image->width, image->width / 2);
		
		*width_ret = image->width;
		*height_ret = image->height;

		g_free (image->img);
		g_free (image);

		return true;
	}}
#line 1260 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 891 "lum-glplay.gob"
static void 
lum_glplay_initTextures (LumGlplay * self)
#line 1266 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::initTextures"
#line 891 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 891 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1273 "lum-glplay.c"
{
#line 891 "lum-glplay.gob"
	
		unsigned char *line_1=0, *line_2=0, *mem_start=0;
		struct TexSquare *tsq=0;
		int e_x=0, e_y, s=1, i=0;
		int x=0, y=0;
		GLint format=0;
		GLenum err;
		int32_t image_width, image_height;
		if(LUM_PLAYER(self)->_priv->info){
			image_width = LUM_PLAYER(self)->_priv->info->video_width;
			image_height = LUM_PLAYER(self)->_priv->info->video_height;
			if(image_width == -1 || image_height == -1){
				image_width = 320;
				image_height = 240;
			}
		} else
			return;

		/* achieve the 2**e_x:=texture_width, 2**e_y:=texture_height */
		while (s < selfp->tex_width){ s*=2; e_x++; }
		
		selfp->tex_width = s;
		e_y=0; s=1;
		while ( s< selfp->tex_height){ s*=2; e_y++; }
		selfp->tex_height=s;

		/* Test the max texture size */
		do {
			glTexImage2D (GL_PROXY_TEXTURE_2D, 0,
					selfp->gl_internal_format,
					selfp->tex_width, selfp->tex_height,
					0, selfp->gl_bitmap_format,
					selfp->gl_bitmap_type, NULL); 

			glGetTexLevelParameteriv(GL_PROXY_TEXTURE_2D, 0,
					GL_TEXTURE_INTERNAL_FORMAT, &format);

			if (format != selfp->gl_internal_format){
				fprintf (stderr,
					"[gl] Needed texture [%dx%d] too big, trying ",
					selfp->tex_height, selfp->tex_width);

				if (selfp->tex_width > selfp->tex_height){
					e_x--;
					selfp->tex_width = 1;
					for (i = e_x; i > 0; i--)
						selfp->tex_width *= 2;
				} else {
					e_y--;
					selfp->tex_height = 1;
					for (i = e_y; i > 0; i--)
						selfp->tex_height *= 2;
				}
				fprintf (stderr, "[%dx%d] !\n",
					selfp->tex_height, selfp->tex_width);

				if(selfp->tex_width < 64 || selfp->tex_height < 64) {
					fprintf (stderr,
					"GLERROR: Give up .. usable texture size not avaiable,"
					"or texture config error !\n");
					exit(1);
				}
			}
		} while (format != selfp->gl_internal_format &&
					selfp->tex_width > 1 && selfp->tex_height > 1);

		selfp->texnumx = image_width / selfp->tex_width;
		if ((image_width % selfp->tex_width) > 0)
			selfp->texnumx++;

		selfp->texnumy = image_height / selfp->tex_height;
		if ((image_height % selfp->tex_height) > 0)
			selfp->texnumy++;

		printf("[gl2] Creating %dx%d textures of size %dx%d ...\n",
				selfp->texnumx, selfp->texnumy,
				selfp->tex_width,selfp->tex_height);

		/* Allocate the texture memory */
		selfp->texpercx = (float) selfp->tex_width / (float) image_width;
		if (selfp->texpercx > 1.0)
			selfp->texpercx = 1.0;

		selfp->texpercy = (float) selfp->tex_height / (float) image_height;
		if (selfp->texpercy > 1.0)
			selfp->texpercy = 1.0;

		selfp->texgrid = (struct TexSquare *)
			calloc (selfp->texnumx * selfp->texnumy,
					sizeof (struct TexSquare));

		line_1 = selfp->data_local;
		line_2 = (guchar *) selfp->data_local +
				(image_width * selfp->image_bytes);
		mem_start = (guchar *) selfp->data_local;

		selfp->raw_line_len = line_2 - line_1;

		selfp->memory_x_len = selfp->raw_line_len / selfp->image_bytes;

		for (y = 0; y < selfp->texnumy; y++){
			for (x = 0; x < selfp->texnumx; x++){
				tsq = selfp->texgrid + y * selfp->texnumx + x;

				if (x == selfp->texnumx - 1 &&
						image_width % selfp->tex_width)
					tsq->xcov = (float) (image_width %
						selfp->tex_width) / (float) selfp->tex_width;
				else
					tsq->xcov = 1.0;

				if (y == selfp->texnumy - 1 &&
						image_height % selfp->tex_height)
					tsq->ycov = (float) (image_height %
						selfp->tex_height) / (float) selfp->tex_height;
				else
					tsq->ycov = 1.0;

				self_CalcFlatPoint(self,x, y,
						&(tsq->fx1), &(tsq->fy1));
				self_CalcFlatPoint (self, x + 1, y,
						&(tsq->fx2), &(tsq->fy2));
				self_CalcFlatPoint (self, x + 1, y + 1,
						&(tsq->fx3), &(tsq->fy3));
				self_CalcFlatPoint (self, x, y + 1,
						&(tsq->fx4), &(tsq->fy4));

	      /* calculate the pixel store data,
     	    to use the machine-bitmap for our texture 
	      */
	 			selfp->memory_x_start_offset = 0 * selfp->image_bytes + 
                              x * selfp->tex_width * selfp->image_bytes;
				tsq->texture = line_1 +
					y * selfp->tex_height * selfp->raw_line_len +  
					selfp->memory_x_start_offset;
					
				tsq->isDirty = true;
				tsq->isTexture= false;
				tsq->texobj=0;
				tsq->dirtyXoff=0; tsq->dirtyYoff=0;
				tsq->dirtyWidth=-1; tsq->dirtyHeight=-1;

				glGenTextures (1, &(tsq->texobj));
				glBindTexture (GL_TEXTURE_2D, tsq->texobj);
				err = glGetError ();
				if(err==GL_INVALID_ENUM){ 
					fprintf (stderr, "GLERROR glBindTexture (glGenText)"
					":= GL_INVALID_ENUM, texnum x=%d, y=%d, texture=%d\n",
					x, y, tsq->texobj);
				} 

				if(glIsTexture(tsq->texobj) == false){
					fprintf (stderr, "GLERROR ain't a texture (glGenText)"
					": texnum x=%d, y=%d, texture=%d\n",
					x, y, tsq->texobj);
				} else {
					tsq->isTexture=true;
				}

				glTexImage2D (GL_TEXTURE_2D, 0,
					selfp->gl_internal_format,
					selfp->tex_width, selfp->tex_height,
					0, selfp->gl_bitmap_format,
					selfp->gl_bitmap_type, NULL); 

				glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_PRIORITY, 1.0);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
			}	/* for all texnumx */
		}  /* for all texnumy */
	}}
#line 1450 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 1071 "lum-glplay.gob"
static void 
lum_glplay_resetTexturePointers (LumGlplay * self, guchar * imageSource)
#line 1456 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::resetTexturePointers"
#line 1071 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 1071 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1463 "lum-glplay.c"
{
#line 1071 "lum-glplay.gob"
	
		guchar *line_1=0, *line_2=0, *mem_start=0;
		struct TexSquare *tsq=0;
		int x=0, y=0;
		int32_t image_width;
		if(LUM_PLAYER(self)->_priv->info){
			image_width = LUM_PLAYER(self)->_priv->info->video_width;
			if(image_width == -1)
				image_width = 320;
		} else
			return;

		line_1 = imageSource;
		line_2 = (guchar *) imageSource+(
				image_width * selfp->image_bytes);

		mem_start = (guchar *) imageSource;

		for (y = 0; y < selfp->texnumy; y++){
			for (x = 0; x < selfp->texnumx; x++){
				tsq = selfp->texgrid + y * selfp->texnumx + x;

	      /* calculate the pixel store data,
	         to use the machine-bitmap for our texture 
	      */
		 	selfp->memory_x_start_offset = 0 * selfp->image_bytes + 
					x * selfp->tex_width * selfp->image_bytes;

			tsq->texture = line_1 +
				y * selfp->tex_height * selfp->raw_line_len +  
				selfp->memory_x_start_offset;
			}	/* for all texnumx */
		}  /* for all texnumy */
	}}
#line 1500 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 1106 "lum-glplay.gob"
static void 
lum_glplay_CalcFlatPoint (LumGlplay * self, int x, int y, GLfloat * px, GLfloat * py)
#line 1506 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::CalcFlatPoint"
#line 1106 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 1106 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1513 "lum-glplay.c"
{
#line 1106 "lum-glplay.gob"
	
		*px=(float)x*selfp->texpercx;
		if(*px>1.0) *px=1.0;
		*py=(float)y*selfp->texpercy;
		if(*py>1.0) *py=1.0;
	}}
#line 1522 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 1113 "lum-glplay.gob"
static void 
lum_glplay_setupTextureDirtyArea (LumGlplay * self, int x, int y, int w, int h)
#line 1528 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::setupTextureDirtyArea"
#line 1113 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 1113 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1535 "lum-glplay.c"
{
#line 1113 "lum-glplay.gob"
	
		struct TexSquare *square;
		int xi, yi, wd, ht, wh, hh;
		int wdecr, hdecr, xh, yh;
		int32_t image_width, image_height;
		if(LUM_PLAYER(self)->_priv->info){
			image_width = LUM_PLAYER(self)->_priv->info->video_width;
			image_height = LUM_PLAYER(self)->_priv->info->video_height;
			if(image_width == -1 || image_height == -1){
				image_width = 320;
				image_height = 240;
			}
		} else
			return;

		wdecr=w; hdecr=h; xh=x; yh=y;

		for (yi = 0; hdecr>0 && yi < selfp->texnumy; yi++){
			if (yi < selfp->texnumy - 1)
				ht = selfp->tex_height;
			else
				ht = image_height - selfp->tex_height * yi;
			xh =x;
			wdecr =w;

			for (xi = 0; wdecr>0 && xi < selfp->texnumx; xi++){
				square = selfp->texgrid + yi * selfp->texnumx + xi;
				
				if (xi < selfp->texnumx - 1)
					wd = selfp->tex_width;
				else
					wd = image_width - selfp->tex_width * xi;

				if( 0 <= xh && xh < wd && 0 <= yh && yh < ht){
					square->isDirty=GL_TRUE;
					wh=(wdecr<wd)?wdecr:wd-xh;
					if(wh<0) wh=0;
						hh=(hdecr<ht)?hdecr:ht-yh;
						if(hh<0) hh=0;

					if(xh<square->dirtyXoff)
						square->dirtyXoff=xh;

					if(yh<square->dirtyYoff)
						square->dirtyYoff=yh;

					square->dirtyWidth = wd-square->dirtyXoff;
					square->dirtyHeight = ht-square->dirtyYoff;
			
					wdecr-=wh;

					if ( xi == selfp->texnumx - 1 )
						hdecr-=hh;
        			}

				xh-=wd;
				if(xh<0) xh=0;
			}
			yh-=ht;
			if(yh<0) yh=0;
		}
	}}
#line 1600 "lum-glplay.c"
#undef __GOB_FUNCTION__

#line 1176 "lum-glplay.gob"
static void 
lum_glplay_cleanup (LumGlplay * self)
#line 1606 "lum-glplay.c"
{
#define __GOB_FUNCTION__ "Lum:Glplay::cleanup"
#line 1176 "lum-glplay.gob"
	g_return_if_fail (self != NULL);
#line 1176 "lum-glplay.gob"
	g_return_if_fail (LUM_IS_GLPLAY (self));
#line 1613 "lum-glplay.c"
{
#line 1176 "lum-glplay.gob"
	
		if(selfp->quadratic){
			gluDeleteQuadric(selfp->quadratic);
			selfp->quadratic = NULL;
		}
		if(selfp->data_local){
			free(selfp->data_local);
			selfp->data_local = NULL;
		}
	}}
#line 1626 "lum-glplay.c"
#undef __GOB_FUNCTION__
