/* Generated by GOB (v2.0.11) on Thu Apr 14 15:07:42 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "gtk-xine.gob"

/***************************************************************************
                          gtk-xine.gob  -  Xine Gtk Widget
                             -------------------
    begin                : dim jan  26 02:08:47 BST 2002
    copyright            : (C) 2002, 2004, 2005 by Stéphane Konstantaropoulos
    email                : stephane@cs.york.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * Code taken / inspired from gtk-xine.c from the totem project by Hadess
 * 
 * Thanks go to him for his nice implementation
 * 	Copyright (C) 2001-2002 the xine project
 * 	Heavily modified by Bastien Nocera <hadess@hadess.net>
 * 
 * My modifications:
 * Use gob for easier syntax, remove signals and a few properties,
 * remove fullscreen code. Implement fully LumPlayer.
 *
 * #TODO apply LumConfig fully. Remove unnecessary things.
 */

#line 40 "gtk-xine.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gtk-xine.h"

#include "gtk-xine-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 58 "gtk-xine.gob"

#include <math.h>
#include <gdk/gdkx.h>
#include <stdlib.h>
#include <unistd.h>

#define LUM_DIR ".lumiere/"
#ifdef OS_WIN32
extern HINSTANCE instance;
#endif

/* debug printout macros */	
#ifndef NDEBUG
#define __d	g_message(__GOB_FUNCTION__);
#define __ds(s)	g_message(__GOB_FUNCTION__ s);
#else
#define __d
#define __ds(s)
#endif

#line 82 "gtk-xine.c"
static const GEnumValue _gtk_xine_speed_values[] = {
	{ SPEED_PAUSE, (char *)"SPEED_PAUSE", (char *)"pause" },
	{ SPEED_NORMAL, (char *)"SPEED_NORMAL", (char *)"normal" },
	{ 0, NULL, NULL }
};

GType
gtk_xine_speed_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("GtkXineSpeed", _gtk_xine_speed_values);
	return type;
}

static const GEnumValue _gtk_xine_error_values[] = {
	{ GTK_XINE_ERROR_NONE, (char *)"GTK_XINE_ERROR_NONE", (char *)"none" },
	{ GTK_XINE_ERROR_NO_INPUT_PLUGIN, (char *)"GTK_XINE_ERROR_NO_INPUT_PLUGIN", (char *)"no-input-plugin" },
	{ GTK_XINE_ERROR_NO_DEMUX_PLUGIN, (char *)"GTK_XINE_ERROR_NO_DEMUX_PLUGIN", (char *)"no-demux-plugin" },
	{ GTK_XINE_ERROR_DEMUX_FAILED, (char *)"GTK_XINE_ERROR_DEMUX_FAILED", (char *)"demux-failed" },
	{ GTK_XINE_ERROR_MALFORMED_MRL, (char *)"GTK_XINE_ERROR_MALFORMED_MRL", (char *)"malformed-mrl" },
	{ GTK_XINE_ERROR_INPUT_FAILED, (char *)"GTK_XINE_ERROR_INPUT_FAILED", (char *)"input-failed" },
	{ 0, NULL, NULL }
};

GType
gtk_xine_error_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("GtkXineError", _gtk_xine_error_values);
	return type;
}

GQuark
gtk_xine_error_quark (void)
{
	static GQuark q = 0;
	if (q == 0)
		q = g_quark_from_static_string ("gtk-xine-error");
	return q;
}

/* self casting macros */
#define SELF(x) GTK_XINE(x)
#define SELF_CONST(x) GTK_XINE_CONST(x)
#define IS_SELF(x) GTK_IS_XINE(x)
#define TYPE_SELF GTK_TYPE_XINE
#define SELF_CLASS(x) GTK_XINE_CLASS(x)

#define SELF_GET_CLASS(x) GTK_XINE_GET_CLASS(x)

/* self typedefs */
typedef GtkXine Self;
typedef GtkXineClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gtk_xine_class_init (GtkXineClass * class) G_GNUC_UNUSED;
static void gtk_xine_init (GtkXine * self) G_GNUC_UNUSED;
static void ___4_gtk_xine_finalize (GObject * object) G_GNUC_UNUSED;
static void ___5_gtk_xine_play_pause (LumPlayer * player) G_GNUC_UNUSED;
static void ___6_gtk_xine_stop (LumPlayer * player) G_GNUC_UNUSED;
static gint ___7_gtk_xine_get_stream_length (LumPlayer * player) G_GNUC_UNUSED;
static void ___8_gtk_xine_set_contrast (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___9_gtk_xine_set_brightness (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___a_gtk_xine_set_hue (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___b_gtk_xine_set_saturation (LumPlayer * player, gdouble value) G_GNUC_UNUSED;
static void ___c_gtk_xine_set_eq (LumPlayer * player, gint hz, gdouble value) G_GNUC_UNUSED;
static void ___d_gtk_xine_set_volume (LumPlayer * player, double volume) G_GNUC_UNUSED;
static double ___e_gtk_xine_get_volume (LumPlayer * player) G_GNUC_UNUSED;
static void gtk_xine_set_mute (GtkXine * self, bool val) G_GNUC_UNUSED;
static bool gtk_xine_get_position_time (GtkXine * self, double * position, int * time) G_GNUC_UNUSED;
static bool ___11_gtk_xine_is_running (LumPlayer * player) G_GNUC_UNUSED;
static bool ___12_gtk_xine_can_play (LumPlayer * player) G_GNUC_UNUSED;
static bool ___13_gtk_xine_next (LumPlayer * player) G_GNUC_UNUSED;
static bool ___14_gtk_xine_prev (LumPlayer * player) G_GNUC_UNUSED;
static char ** ___15_gtk_xine_get_mime_types (LumPlayer * player) G_GNUC_UNUSED;
static char ** ___17_gtk_xine_get_cdda_list (LumPlayer * player, int * num) G_GNUC_UNUSED;
static char ** ___18_gtk_xine_get_dvd_list (LumPlayer * player, int * num) G_GNUC_UNUSED;
static bool ___real_gtk_xine_play (GtkXine * self);
static bool gtk_xine_play (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_pause (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_dest_size_cb (void * data, int video_width, int video_height, double video_pixel_aspect, int * dest_width, int * dest_height, double * dest_pixel_aspect) G_GNUC_UNUSED;
static void gtk_xine_frame_output_cb (void * gtx_gen, int video_width, int video_height, double video_pixel_aspect, int * dest_x, int * dest_y, int * dest_width, int * dest_height, double * dest_pixel_aspect, int * win_x, int * win_y) G_GNUC_UNUSED;
static bool gtk_xine_idle_resize (GtkXine * self) G_GNUC_UNUSED;
static void ___real_gtk_xine_load_video_out_driver (GtkXine * self);
static bool gtk_xine_video_window_translate_point (GtkXine * self, int gui_x, int gui_y, int * video_x, int * video_y) G_GNUC_UNUSED;
static bool gtk_xine_generate_mouse_event (GtkXine * self, GdkEvent * event, bool is_motion) G_GNUC_UNUSED;
static void gtk_xine_xine_error (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_set_vis (GtkXine * self) G_GNUC_UNUSED;
static void gtk_xine_set_vis_embed (GtkXine * self) G_GNUC_UNUSED;
static bool gtk_xine_idle (GtkXine * self) G_GNUC_UNUSED;
static bool gtk_xine_xine_timeout_cb (GtkXine * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_SHOW_VFX,
	PROP_SHOW_VFX_EMBED,
	PROP_POSITION,
	PROP_TIME,
	PROP_IS_SEEKABLE,
	PROP_MUTE
};

/* pointer to the class of our parent */
static LumPlayerClass *parent_class = NULL;

/* Short form macros */
#define self_new gtk_xine_new
#define self_set_mute gtk_xine_set_mute
#define self_get_position_time gtk_xine_get_position_time
#define self_set_reparent gtk_xine_set_reparent
#define self_play gtk_xine_play
#define self_pause gtk_xine_pause
#define self_dest_size_cb gtk_xine_dest_size_cb
#define self_frame_output_cb gtk_xine_frame_output_cb
#define self_idle_resize gtk_xine_idle_resize
#define self_load_video_out_driver gtk_xine_load_video_out_driver
#define self_load_audio_out_driver gtk_xine_load_audio_out_driver
#define self_video_window_translate_point gtk_xine_video_window_translate_point
#define self_generate_mouse_event gtk_xine_generate_mouse_event
#define self_event gtk_xine_event
#define self_xine_error gtk_xine_xine_error
#define self_stream_clean gtk_xine_stream_clean
#define self_set_vis gtk_xine_set_vis
#define self_set_vis_embed gtk_xine_set_vis_embed
#define self_idle gtk_xine_idle
#define self_xine_timeout_cb gtk_xine_xine_timeout_cb
GType
gtk_xine_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GtkXineClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gtk_xine_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GtkXine),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gtk_xine_init,
			NULL
		};

		type = g_type_register_static (LUM_TYPE_PLAYER, "GtkXine", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GtkXine *)g_object_new(gtk_xine_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GtkXine * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GtkXine *
GET_NEW_VARG (const char *first, ...)
{
	GtkXine *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GtkXine *)g_object_new_valist (gtk_xine_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::dispose"
	GtkXine *self G_GNUC_UNUSED = GTK_XINE (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 108 "gtk-xine.gob"
	if(self->_priv->queue) { g_async_queue_unref ((gpointer) self->_priv->queue); self->_priv->queue = NULL; }
#line 265 "gtk-xine.c"
#line 115 "gtk-xine.gob"
	if(self->_priv->video_widget) { g_object_unref ((gpointer) self->_priv->video_widget); self->_priv->video_widget = NULL; }
#line 268 "gtk-xine.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gtk:Xine::finalize"
	GtkXine *self G_GNUC_UNUSED = GTK_XINE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 477 "gtk-xine.gob"
	___4_gtk_xine_finalize(obj_self);
#line 281 "gtk-xine.c"
#line 120 "gtk-xine.gob"
	if(self->_priv->mime_types) { g_strfreev ((gpointer) self->_priv->mime_types); self->_priv->mime_types = NULL; }
#line 284 "gtk-xine.c"
}
#undef __GOB_FUNCTION__

#line 227 "gtk-xine.gob"
static void 
gtk_xine_class_init (GtkXineClass * class G_GNUC_UNUSED)
#line 291 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	LumPlayerClass *lum_player_class = (LumPlayerClass *)class;

	g_type_class_add_private(class,sizeof(GtkXinePrivate));
#line 100 "gtk-xine.gob"
	class->xine = xine_new();
#line 300 "gtk-xine.c"
#line 100 "gtk-xine.gob"
	class->ref = -1;
#line 303 "gtk-xine.c"

	parent_class = g_type_class_ref (LUM_TYPE_PLAYER);

#line 477 "gtk-xine.gob"
	g_object_class->finalize = ___finalize;
#line 486 "gtk-xine.gob"
	lum_player_class->play_pause = ___5_gtk_xine_play_pause;
#line 512 "gtk-xine.gob"
	lum_player_class->stop = ___6_gtk_xine_stop;
#line 527 "gtk-xine.gob"
	lum_player_class->get_stream_length = ___7_gtk_xine_get_stream_length;
#line 545 "gtk-xine.gob"
	lum_player_class->set_contrast = ___8_gtk_xine_set_contrast;
#line 555 "gtk-xine.gob"
	lum_player_class->set_brightness = ___9_gtk_xine_set_brightness;
#line 565 "gtk-xine.gob"
	lum_player_class->set_hue = ___a_gtk_xine_set_hue;
#line 574 "gtk-xine.gob"
	lum_player_class->set_saturation = ___b_gtk_xine_set_saturation;
#line 584 "gtk-xine.gob"
	lum_player_class->set_eq = ___c_gtk_xine_set_eq;
#line 634 "gtk-xine.gob"
	lum_player_class->set_volume = ___d_gtk_xine_set_volume;
#line 646 "gtk-xine.gob"
	lum_player_class->get_volume = ___e_gtk_xine_get_volume;
#line 696 "gtk-xine.gob"
	lum_player_class->is_running = ___11_gtk_xine_is_running;
#line 706 "gtk-xine.gob"
	lum_player_class->can_play = ___12_gtk_xine_can_play;
#line 715 "gtk-xine.gob"
	lum_player_class->next = ___13_gtk_xine_next;
#line 737 "gtk-xine.gob"
	lum_player_class->prev = ___14_gtk_xine_prev;
#line 759 "gtk-xine.gob"
	lum_player_class->get_mime_types = ___15_gtk_xine_get_mime_types;
#line 774 "gtk-xine.gob"
	lum_player_class->get_cdda_list = ___17_gtk_xine_get_cdda_list;
#line 783 "gtk-xine.gob"
	lum_player_class->get_dvd_list = ___18_gtk_xine_get_dvd_list;
#line 792 "gtk-xine.gob"
	class->play = ___real_gtk_xine_play;
#line 979 "gtk-xine.gob"
	class->load_video_out_driver = ___real_gtk_xine_load_video_out_driver;
#line 347 "gtk-xine.c"
	g_object_class->dispose = ___dispose;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("show_vfx" /* name */,
		 _("Show video effect") /* nick */,
		 _("If no video, show animation") /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SHOW_VFX,
		param_spec);
	param_spec = g_param_spec_boolean
		("show_vfx_embed" /* name */,
		 _("Show embedded video effect") /* nick */,
		 _("embed visualization") /* blurb */,
		 false /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SHOW_VFX_EMBED,
		param_spec);
	g_object_class_override_property (g_object_class,
		PROP_POSITION,
		"position");
	g_object_class_override_property (g_object_class,
		PROP_TIME,
		"time");
	g_object_class_override_property (g_object_class,
		PROP_IS_SEEKABLE,
		"is_seekable");
	g_object_class_override_property (g_object_class,
		PROP_MUTE,
		"mute");
    }
 {
#line 227 "gtk-xine.gob"

		__d;
		char *xine_config = g_build_filename (g_get_home_dir(), LUM_DIR,
				"xine-config", NULL);
		if(g_file_test(xine_config, G_FILE_TEST_EXISTS)){
			xine_config_load (class->xine, xine_config);
			xine_init(class->xine);
		} else {
			GtkWidget *dialog = gtk_message_dialog_new (NULL,
					GTK_DIALOG_MODAL,
					GTK_MESSAGE_INFO,
					GTK_BUTTONS_OK,
					_("Initializing lumiere and xine."));
			gtk_message_dialog_format_secondary_text (
				GTK_MESSAGE_DIALOG(dialog),
				_("It looks like it is the first time "
				"you run lumiere. It will now do some "
				"autoconfiguration of the xine library.\n"
				"This step occurs only once."));
			g_signal_connect_swapped(dialog, "response", 
				G_CALLBACK (gtk_widget_destroy), dialog);
			gtk_widget_show_all(dialog);
			xine_init(class->xine);
			xine_config_save(class->xine, xine_config);
		}
#ifndef NDEBUG
		xine_engine_set_param(class->xine, 1, 1);
#else
		xine_engine_set_param(class->xine, 1, 0);
#endif
		g_free(xine_config);
	
#line 419 "gtk-xine.c"
 }
}
#undef __GOB_FUNCTION__
#line 262 "gtk-xine.gob"
static void 
gtk_xine_init (GtkXine * self G_GNUC_UNUSED)
#line 426 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,GtkXinePrivate);
#line 100 "gtk-xine.gob"
	self->_priv->stream = NULL;
#line 432 "gtk-xine.c"
#line 100 "gtk-xine.gob"
	self->_priv->vo_driver = NULL;
#line 435 "gtk-xine.c"
#line 100 "gtk-xine.gob"
	self->_priv->ao_driver = NULL;
#line 438 "gtk-xine.c"
#line 100 "gtk-xine.gob"
	self->_priv->ev_queue = NULL;
#line 441 "gtk-xine.c"
#line 107 "gtk-xine.gob"
	self->_priv->queue = g_async_queue_new();
#line 444 "gtk-xine.c"
#line 111 "gtk-xine.gob"
	self->_priv->video_widget = 
			gtk_xine_widget_new(self);
			g_object_ref(selfp->video_widget);
			gtk_object_sink(GTK_OBJECT(selfp->video_widget))
			;
#line 451 "gtk-xine.c"
#line 111 "gtk-xine.gob"
	self->_priv->timeout = false;
#line 454 "gtk-xine.c"
#line 111 "gtk-xine.gob"
	self->_priv->mime_types = NULL;
#line 457 "gtk-xine.c"
#line 111 "gtk-xine.gob"
	self->_priv->buffering = 100;
#line 460 "gtk-xine.c"
#line 111 "gtk-xine.gob"
	self->_priv->buffering_desc = NULL;
#line 463 "gtk-xine.c"
#line 154 "gtk-xine.gob"
	self->_priv->vis = NULL;
#line 466 "gtk-xine.c"
#line 154 "gtk-xine.gob"
	self->_priv->parent = NULL;
#line 469 "gtk-xine.c"
#line 154 "gtk-xine.gob"
	self->_priv->prev_parent = NULL;
#line 472 "gtk-xine.c"
#line 154 "gtk-xine.gob"
	self->_priv->prev_video = false;
#line 475 "gtk-xine.c"
 {
#line 262 "gtk-xine.gob"

		__d;
		if(SELF_GET_CLASS(self)->ref == -1)
			SELF_GET_CLASS(self)->ref = 1;
		else
			SELF_GET_CLASS(self)->ref += 1;
	
#line 485 "gtk-xine.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gtk:Xine::set_property"
{
	GtkXine *self G_GNUC_UNUSED;

	self = GTK_XINE (object);

	switch (property_id) {
	case PROP_SHOW_VFX:
		{
#line 135 "gtk-xine.gob"
 selfp->show_vfx = g_value_get_boolean(VAL);
			if(selfp->show_vfx){
				selfp->show_vfx_embed = false;
				self_set_vis_embed(self);
			}
			self_set_vis(self); 
#line 511 "gtk-xine.c"
		}
		break;
	case PROP_SHOW_VFX_EMBED:
		{
#line 148 "gtk-xine.gob"
 selfp->show_vfx_embed = g_value_get_boolean(VAL);
			if(selfp->show_vfx_embed){
			    selfp->show_vfx = false;
				self_set_vis(self);
			}
			self_set_vis_embed(self); 
#line 523 "gtk-xine.c"
		}
		break;
	case PROP_POSITION:
		{
#line 170 "gtk-xine.gob"
 double position = g_value_get_double (VAL);
			gint length, absolute_position;
			length = lum_player_get_stream_length((LumPlayer *) self);
			absolute_position = ((gdouble) length / 100.0) * position;
			if(selfp->stream){
				xine_play(selfp->stream, 0, absolute_position);
				((LumPlayer *) self)->_priv->position = position;
			}
		
#line 538 "gtk-xine.c"
		}
		break;
	case PROP_TIME:
		{
#line 182 "gtk-xine.gob"
 ((LumPlayer *) self)->_priv->time = g_value_get_int (VAL);
#line 545 "gtk-xine.c"
		}
		break;
	case PROP_MUTE:
		{
#line 216 "gtk-xine.gob"
 bool val = g_value_get_boolean(VAL);
			if(val != ((LumPlayer *) self)->_priv->mute){
				self_set_mute(self, val);
				((LumPlayer *) self)->_priv->mute = val;
			}
		
#line 557 "gtk-xine.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gtk:Xine::get_property"
{
	GtkXine *self G_GNUC_UNUSED;

	self = GTK_XINE (object);

	switch (property_id) {
	case PROP_SHOW_VFX:
		{
#line 141 "gtk-xine.gob"
 g_value_set_boolean(VAL, selfp->show_vfx); 
#line 588 "gtk-xine.c"
		}
		break;
	case PROP_SHOW_VFX_EMBED:
		{
#line 154 "gtk-xine.gob"
 g_value_set_boolean(VAL, selfp->show_vfx_embed); 
#line 595 "gtk-xine.c"
		}
		break;
	case PROP_POSITION:
		{
#line 163 "gtk-xine.gob"

			double position;
			int time;
			self_get_position_time(self, &position, &time);
			((LumPlayer *) self)->_priv->position = position;
			g_value_set_double(VAL, position);
		
#line 608 "gtk-xine.c"
		}
		break;
	case PROP_TIME:
		{
#line 183 "gtk-xine.gob"

			double position;
			int time;
			self_get_position_time(self, &position, &time);
			((LumPlayer *) self)->_priv->time = time;
			g_value_set_int(VAL, time);
		
#line 621 "gtk-xine.c"
		}
		break;
	case PROP_IS_SEEKABLE:
		{
#line 193 "gtk-xine.gob"
	if (lum_player_get_stream_length ((LumPlayer *) self) == 0){
					g_value_set_boolean(VAL, false);
					((LumPlayer *) self)->_priv->is_seekable = false;
				}
				if(!selfp->stream){
					g_value_set_boolean(VAL, false);
					((LumPlayer *) self)->_priv->is_seekable = false;
					return;
				}
				if(selfp->buffering < 100){
					g_value_set_boolean(VAL, false);
					((LumPlayer *) self)->_priv->is_seekable = false;
					return;
				}
				((LumPlayer *) self)->_priv->is_seekable = 
					xine_get_stream_info (selfp->stream,
							XINE_STREAM_INFO_SEEKABLE);
				g_value_set_boolean(VAL, ((LumPlayer *) self)->_priv->is_seekable);
		
#line 646 "gtk-xine.c"
		}
		break;
	case PROP_MUTE:
		{
#line 215 "gtk-xine.gob"
 g_value_set_boolean(VAL, ((LumPlayer *) self)->_priv->mute); 
#line 653 "gtk-xine.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 275 "gtk-xine.gob"
GtkXine * 
gtk_xine_new (LumConfig * config)
#line 673 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::new"
#line 275 "gtk-xine.gob"
	g_return_val_if_fail (!(config) || LUM_IS_CONFIG (config), (GtkXine * )NULL);
#line 275 "gtk-xine.gob"
	g_return_val_if_fail (config != NULL, (GtkXine * )NULL);
#line 680 "gtk-xine.c"
{
#line 275 "gtk-xine.gob"
	
		__d;
		xine_cfg_entry_t entry;
		Self *self = GET_NEW_VARG("LumPlayer::config", config,
				"GtkWidget::can-focus", true,
				"GtkBox::homogeneous", false,
				"GtkBox::spacing", 0,
			    	NULL, NULL);
		gtk_widget_show(GTK_WIDGET(selfp->video_widget));
		gtk_box_pack_start(GTK_BOX(self),
				GTK_WIDGET(selfp->video_widget),
				true, true, 0);
		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_device", &entry)){
			xine_config_register_string(SELF_GET_CLASS(self)->xine,
					"input.dvd_device",
					config->dvd_dev, "", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_device", &entry);
		}
		entry.str_value = g_strdup(config->dvd_dev);
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);

		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_language", &entry)){
			xine_config_register_string(SELF_GET_CLASS(self)->xine,
					"input.dvd_language",
					config->alang, "", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_language", &entry);
		}
		entry.str_value = g_strdup(config->alang);
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		/* TODO in LumConfig
		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.cdda_device", &entry)){
			xine_config_register_string(SELF_GET_CLASS(self)->xine,
					"input.cdda_device",
					config->cdda_dev, "", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.cdda_dev", &entry);
		}
		entry.str_value = g_strdup(config->cdda_dev);
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		*/
		memset (&entry, 0, sizeof (&entry));
		if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_skip_behaviour", &entry)){
			char *skip[3];
			skip[1] = g_strdup("skip program");
			skip[2] = g_strdup("skip part");
			skip[3] = g_strdup("skip title");
			xine_config_register_enum(SELF_GET_CLASS(self)->xine,
					"input.dvd_skip_behaviour", 1, skip,
					"DVD skip behaviour", NULL, 10,
					NULL, NULL);
			xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
					"input.dvd_skip_behaviour", &entry);
		}
		entry.num_value = 1;
		xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);

		const char *demux_strategies[] = {"default", "reverse", "content",
			"extension", NULL};

		/* default demux strategy */
		xine_config_register_enum (SELF_GET_CLASS(self)->xine,
				"misc.demux_strategy", 0,
				(char **) demux_strategies,
				 "media format detection strategy",
				 NULL, 10, NULL, NULL);
		xine_config_lookup_entry (SELF_GET_CLASS(self)->xine,
				"misc.demux_strategy", &entry);
		entry.num_value = 0;
		xine_config_update_entry (SELF_GET_CLASS(self)->xine, &entry);

		/* Proxy configuration */

		if (config->use_proxy == false){
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						&entry)){
				xine_config_register_string(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host", &entry);
			}
			entry.str_value = "";
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		} else {
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						&entry)){
				xine_config_register_string(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_host", &entry);
			}

			entry.str_value = g_strdup(config->proxy_host);
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_port",
						&entry)){
				xine_config_register_num(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_port",
						8080, "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(SELF_GET_CLASS(self)->xine,
						"input.http_proxy_port", &entry);
			}
			entry.num_value = config->proxy_port;
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		}
		if (config->proxy_auth == false){
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_user",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user", &entry);
			}
			entry.str_value = "";
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_password",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password", &entry);
			}
			entry.str_value = "";
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		} else {
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_user",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_user", &entry);
			}
			entry.str_value = g_strdup(config->proxy_user);
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
			memset (&entry, 0, sizeof (&entry));
			if (!xine_config_lookup_entry(
					SELF_GET_CLASS(self)->xine,
					"input.http_proxy_password",
					&entry)){
				xine_config_register_string(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password",
						"", "", NULL, 10, NULL, NULL);
				xine_config_lookup_entry(
						SELF_GET_CLASS(self)->xine,
						"input.http_proxy_password", &entry);
			}
			entry.str_value = g_strdup(config->proxy_password);
			xine_config_update_entry(SELF_GET_CLASS(self)->xine, &entry);
		}
/*
		self_load_video_out_driver(self);
		selfp->ao_driver = xine_open_audio_driver(SELF_GET_CLASS(self)->xine,
				"none", NULL);

		selfp->stream = xine_stream_new (SELF_GET_CLASS(self)->xine,
				selfp->ao_driver, selfp->vo_driver);
		selfp->ev_queue = xine_event_new_queue(selfp->stream);
*/
		return self;
	}}
#line 881 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 477 "gtk-xine.gob"
static void 
___4_gtk_xine_finalize (GObject * object G_GNUC_UNUSED)
#line 887 "gtk-xine.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::finalize"
#line 477 "gtk-xine.gob"
	g_return_if_fail (object != NULL);
#line 477 "gtk-xine.gob"
	g_return_if_fail (G_IS_OBJECT (object));
#line 897 "gtk-xine.c"
{
#line 477 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(object);
		self_stream_clean(self);
	
		PARENT_HANDLER(object);
		SELF_GET_CLASS(self)->ref -= 1;
	}}
#line 908 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 486 "gtk-xine.gob"
static void 
___5_gtk_xine_play_pause (LumPlayer * player G_GNUC_UNUSED)
#line 915 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->play_pause) \
		(* LUM_PLAYER_CLASS(parent_class)->play_pause)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::play_pause"
#line 486 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 486 "gtk-xine.gob"
	g_return_if_fail (LUM_IS_PLAYER (player));
#line 925 "gtk-xine.c"
{
#line 487 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		LumPlayerStatus status;
		switch(player->_priv->status) {
			case PLAYER_STOPPED:
				self_play(self);
 				self_set_vis(self);
				status = PLAYER_PLAYING;
				break;
			case PLAYER_PLAYING:
				self_pause(self);
				status = PLAYER_PAUSED;
				break;
			case PLAYER_PAUSED:
				self_pause(self);
				status = PLAYER_PLAYING;
				break;
			default:
				status = PLAYER_NONE;
				break;
		}
		lum_player_set_status((LumPlayer *) self, status);
	}}
#line 952 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 512 "gtk-xine.gob"
static void 
___6_gtk_xine_stop (LumPlayer * player G_GNUC_UNUSED)
#line 959 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	{ if(LUM_PLAYER_CLASS(parent_class)->stop) \
		(* LUM_PLAYER_CLASS(parent_class)->stop)(___player); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::stop"
{
#line 512 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		g_return_if_fail (SELF_GET_CLASS(self)->xine != NULL);
		
		if(player->_priv->status == PLAYER_STOPPED)
			return;

		if(selfp->stream){
			self_stream_clean(self);
		}

		PARENT_HANDLER(player);
	}}
#line 981 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 527 "gtk-xine.gob"
static gint 
___7_gtk_xine_get_stream_length (LumPlayer * player G_GNUC_UNUSED)
#line 988 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->get_stream_length)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_stream_length)(___player): \
		((gint )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_stream_length"
#line 527 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (gint )0);
#line 527 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (gint )0);
#line 999 "gtk-xine.c"
{
#line 528 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		int length_time = 0;
		int pos_stream, pos_time;

		if (player->_priv->uri == NULL)
			return 0;
		if(!selfp->stream)
			return 0;

		xine_get_pos_length (selfp->stream, &pos_stream,
				&pos_time, &length_time);

		return length_time;
	}}
#line 1018 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 545 "gtk-xine.gob"
static void 
___8_gtk_xine_set_contrast (LumPlayer * player G_GNUC_UNUSED, gdouble value)
#line 1025 "gtk-xine.c"
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_contrast) \
		(* LUM_PLAYER_CLASS(parent_class)->set_contrast)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_contrast"
#line 545 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 1033 "gtk-xine.c"
{
#line 546 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_CONTRAST,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#line 1044 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 555 "gtk-xine.gob"
static void 
___9_gtk_xine_set_brightness (LumPlayer * player G_GNUC_UNUSED, gdouble value)
#line 1051 "gtk-xine.c"
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_brightness) \
		(* LUM_PLAYER_CLASS(parent_class)->set_brightness)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_brightness"
#line 555 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 1059 "gtk-xine.c"
{
#line 556 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_BRIGHTNESS,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#line 1070 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 565 "gtk-xine.gob"
static void 
___a_gtk_xine_set_hue (LumPlayer * player G_GNUC_UNUSED, gdouble value)
#line 1077 "gtk-xine.c"
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_hue) \
		(* LUM_PLAYER_CLASS(parent_class)->set_hue)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_hue"
#line 565 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 1085 "gtk-xine.c"
{
#line 566 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_HUE,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#line 1096 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 574 "gtk-xine.gob"
static void 
___b_gtk_xine_set_saturation (LumPlayer * player G_GNUC_UNUSED, gdouble value)
#line 1103 "gtk-xine.c"
#define PARENT_HANDLER(___player,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_saturation) \
		(* LUM_PLAYER_CLASS(parent_class)->set_saturation)(___player,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_saturation"
#line 574 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 1111 "gtk-xine.c"
{
#line 575 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			xine_set_param(selfp->stream,XINE_PARAM_VO_SATURATION,
					(gint) (value* 65535.0 / 100.0));
		}
	}}
#line 1122 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 584 "gtk-xine.gob"
static void 
___c_gtk_xine_set_eq (LumPlayer * player G_GNUC_UNUSED, gint hz, gdouble value)
#line 1129 "gtk-xine.c"
#define PARENT_HANDLER(___player,___hz,___value) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_eq) \
		(* LUM_PLAYER_CLASS(parent_class)->set_eq)(___player,___hz,___value); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_eq"
#line 584 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 1137 "gtk-xine.c"
{
#line 585 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(selfp->stream != NULL){
			switch(hz){
				case 30:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_30HZ, (gint) value);
					break;
				case 60:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_60HZ, (gint) value);
					break;
				case 125:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_125HZ, (gint) value);
					break;
				case 250:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_250HZ, (gint) value);
					break;
				case 500:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_500HZ, (gint) value);
					break;
				case 1000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_1000HZ, (gint) value);
					break;
				case 2000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_2000HZ, (gint) value);
					break;
				case 4000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_4000HZ, (gint) value);
					break;
				case 8000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_8000HZ, (gint) value);
					break;
				case 16000:
					xine_set_param(selfp->stream,
						XINE_PARAM_EQ_16000HZ, (gint) value);
					break;
			}
		}
	}}
#line 1188 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 634 "gtk-xine.gob"
static void 
___d_gtk_xine_set_volume (LumPlayer * player G_GNUC_UNUSED, double volume)
#line 1195 "gtk-xine.c"
#define PARENT_HANDLER(___player,___volume) \
	{ if(LUM_PLAYER_CLASS(parent_class)->set_volume) \
		(* LUM_PLAYER_CLASS(parent_class)->set_volume)(___player,___volume); }
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_volume"
#line 634 "gtk-xine.gob"
	g_return_if_fail (player != NULL);
#line 634 "gtk-xine.gob"
	g_return_if_fail (LUM_IS_PLAYER (player));
#line 1205 "gtk-xine.c"
{
#line 635 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(!selfp->stream)
			return;

		xine_set_param(selfp->stream, XINE_PARAM_AUDIO_VOLUME, (int) volume);

		PARENT_HANDLER(player, volume);
	}}
#line 1218 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 646 "gtk-xine.gob"
static double 
___e_gtk_xine_get_volume (LumPlayer * player G_GNUC_UNUSED)
#line 1225 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->get_volume)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_volume)(___player): \
		((double )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_volume"
#line 646 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (double )0);
#line 646 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (double )0);
#line 1236 "gtk-xine.c"
{
#line 647 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(!selfp->stream)
			return 0;
		return (double)
			xine_get_param(selfp->stream, XINE_PARAM_AUDIO_VOLUME);
	}}
#line 1247 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 656 "gtk-xine.gob"
static void 
gtk_xine_set_mute (GtkXine * self, bool val)
#line 1254 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_mute"
#line 656 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 656 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 1261 "gtk-xine.c"
{
#line 656 "gtk-xine.gob"
	
		__d;
		if(selfp->stream != NULL)
			xine_set_param(selfp->stream, XINE_PARAM_AUDIO_MUTE, val);
	}}
#line 1269 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 662 "gtk-xine.gob"
static bool 
gtk_xine_get_position_time (GtkXine * self, double * position, int * time)
#line 1275 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_position_time"
#line 662 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 662 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )false);
#line 1282 "gtk-xine.c"
{
#line 662 "gtk-xine.gob"
	
		__d;
		LumPlayer *player = (LumPlayer *) self;
		int pos_stream = 0, i = 0;
		int pos_time, length_time;
		bool ret;

		if (player->_priv->uri == NULL)
			return false;

		if (lum_player_is_running(player) == false)
			return false;

		if(!selfp->stream)
			return false;

		ret = xine_get_pos_length (selfp->stream, &pos_stream,
				&pos_time, &length_time);

		while (ret == false && i < 10){
			usleep (100000);
			ret = xine_get_pos_length (selfp->stream, &pos_stream,
				&pos_time, &length_time);
			i++;
		}

		if (ret == false)
			return false;

		*position = ((gdouble)(pos_stream * 100) / 65535.0);
		*time = pos_time;
		return true;
	}}
#line 1318 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 696 "gtk-xine.gob"
static bool 
___11_gtk_xine_is_running (LumPlayer * player G_GNUC_UNUSED)
#line 1324 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->is_running)? \
		(* LUM_PLAYER_CLASS(parent_class)->is_running)(___player): \
		((bool )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::is_running"
{
#line 696 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);

		if (selfp->stream == NULL)
			return false;

		return xine_get_status (selfp->stream) == XINE_STATUS_PLAY;
	}}
#line 1342 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 706 "gtk-xine.gob"
static bool 
___12_gtk_xine_can_play (LumPlayer * player G_GNUC_UNUSED)
#line 1349 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->can_play)? \
		(* LUM_PLAYER_CLASS(parent_class)->can_play)(___player): \
		((bool )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::can_play"
#line 706 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (bool )0);
#line 706 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (bool )0);
#line 1360 "gtk-xine.c"
{
#line 707 "gtk-xine.gob"
	
		__d;
		if(GTK_WIDGET_REALIZED(GTK_WIDGET(player)))
			return true;
		else
			return false;
	}}
#line 1370 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 715 "gtk-xine.gob"
static bool 
___13_gtk_xine_next (LumPlayer * player G_GNUC_UNUSED)
#line 1377 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->next)? \
		(* LUM_PLAYER_CLASS(parent_class)->next)(___player): \
		((bool )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::next"
#line 715 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (bool )0);
#line 715 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (bool )0);
#line 1388 "gtk-xine.c"
{
#line 716 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(player->_priv->info){
			if(player->_priv->info->has_chapters){
				xine_event_t event;
				xine_input_data_t data;
				data.button = 1;
				data.x = 0;
				data.y = 0;
				event.type = XINE_EVENT_INPUT_NEXT;
				event.stream = selfp->stream;
				event.data = &data;
				event.data_length = sizeof(data);
				xine_event_send (selfp->stream, (xine_event_t *) &event);
				return true;
			}
		}
		return false;
	}}
#line 1411 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 737 "gtk-xine.gob"
static bool 
___14_gtk_xine_prev (LumPlayer * player G_GNUC_UNUSED)
#line 1418 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->prev)? \
		(* LUM_PLAYER_CLASS(parent_class)->prev)(___player): \
		((bool )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::prev"
#line 737 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (bool )0);
#line 737 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (bool )0);
#line 1429 "gtk-xine.c"
{
#line 738 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(player->_priv->info){
			if(player->_priv->info->has_chapters){
				xine_event_t event;
				xine_input_data_t data;
				data.button = 1;
				data.x = 0;
				data.y = 0;
				event.type = XINE_EVENT_INPUT_PREVIOUS;
				event.stream = selfp->stream;
				event.data = &data;
				event.data_length = sizeof(data);
				xine_event_send (selfp->stream, (xine_event_t *) &event);
				return true;
			}
		}
		return false;
	}}
#line 1452 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 759 "gtk-xine.gob"
static char ** 
___15_gtk_xine_get_mime_types (LumPlayer * player G_GNUC_UNUSED)
#line 1459 "gtk-xine.c"
#define PARENT_HANDLER(___player) \
	((LUM_PLAYER_CLASS(parent_class)->get_mime_types)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_mime_types)(___player): \
		((char ** )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_mime_types"
#line 759 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (char ** )0);
#line 759 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (char ** )0);
#line 1470 "gtk-xine.c"
{
#line 759 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);
		if(selfp->mime_types == NULL){
			char *xine_types = xine_get_mime_types(SELF_GET_CLASS(self)->xine);
			selfp->mime_types = g_strsplit_set(xine_types,
					":;", -1);
			free(xine_types);
		}
		return selfp->mime_types;
	}}
#line 1484 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 771 "gtk-xine.gob"
void 
gtk_xine_set_reparent (GtkXine * self, GdkWindow * parent)
#line 1491 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_reparent"
#line 771 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 771 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 771 "gtk-xine.gob"
	g_return_if_fail (parent != NULL);
#line 771 "gtk-xine.gob"
	g_return_if_fail (GDK_IS_WINDOW (parent));
#line 1502 "gtk-xine.c"
{
#line 772 "gtk-xine.gob"
		selfp->parent = parent; }}
#line 1506 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 774 "gtk-xine.gob"
static char ** 
___17_gtk_xine_get_cdda_list (LumPlayer * player G_GNUC_UNUSED, int * num)
#line 1512 "gtk-xine.c"
#define PARENT_HANDLER(___player,___num) \
	((LUM_PLAYER_CLASS(parent_class)->get_cdda_list)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_cdda_list)(___player,___num): \
		((char ** )NULL))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_cdda_list"
#line 774 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (char ** )NULL);
#line 774 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (char ** )NULL);
#line 1523 "gtk-xine.c"
{
#line 775 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);

		return xine_get_autoplay_mrls
			(SELF_GET_CLASS(self)->xine, "CD", num);
	}}
#line 1533 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 783 "gtk-xine.gob"
static char ** 
___18_gtk_xine_get_dvd_list (LumPlayer * player G_GNUC_UNUSED, int * num)
#line 1540 "gtk-xine.c"
#define PARENT_HANDLER(___player,___num) \
	((LUM_PLAYER_CLASS(parent_class)->get_dvd_list)? \
		(* LUM_PLAYER_CLASS(parent_class)->get_dvd_list)(___player,___num): \
		((char ** )0))
{
#define __GOB_FUNCTION__ "Gtk:Xine::get_dvd_list"
#line 783 "gtk-xine.gob"
	g_return_val_if_fail (player != NULL, (char ** )0);
#line 783 "gtk-xine.gob"
	g_return_val_if_fail (LUM_IS_PLAYER (player), (char ** )0);
#line 1551 "gtk-xine.c"
{
#line 784 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(player);

		return xine_get_autoplay_mrls
			(SELF_GET_CLASS(self)->xine, "DVD", num);
	}}
#line 1561 "gtk-xine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 792 "gtk-xine.gob"
static bool 
gtk_xine_play (GtkXine * self)
#line 1568 "gtk-xine.c"
{
	GtkXineClass *klass;
#line 792 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 792 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )0);
#line 1575 "gtk-xine.c"
	klass = GTK_XINE_GET_CLASS(self);

	if(klass->play)
		return (*klass->play)(self);
	else
		return (bool )(0);
}
#line 792 "gtk-xine.gob"
static bool 
___real_gtk_xine_play (GtkXine * self G_GNUC_UNUSED)
#line 1586 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::play"
{
#line 792 "gtk-xine.gob"
	
		__d;
		int error;
		LumPlayerInfo *info = ((LumPlayer *) self)->_priv->info;
		if(info == NULL)
			return false;

		if((info->has_video || selfp->show_vfx 
				|| selfp->show_vfx_embed) &&
				(!selfp->prev_video || selfp->stream == NULL)){
			if(selfp->stream != NULL)
				self_stream_clean(self);
			self_load_video_out_driver(self);
			self_load_audio_out_driver(self);
			selfp->stream = xine_stream_new (SELF_GET_CLASS(self)->xine,
					selfp->ao_driver, selfp->vo_driver);
			selfp->ev_queue = xine_event_new_queue (selfp->stream);
			xine_event_create_listener_thread (selfp->ev_queue,
					self_event, (gpointer) self);
			selfp->prev_video = true;
		} else if(selfp->stream == NULL) {
			self_load_video_out_driver(self);
			self_load_audio_out_driver(self);
			selfp->stream = xine_stream_new (SELF_GET_CLASS(self)->xine,
						selfp->ao_driver, selfp->vo_driver);
			selfp->ev_queue = xine_event_new_queue (selfp->stream);
			xine_event_create_listener_thread (selfp->ev_queue,
					self_event, (gpointer) self);
			selfp->prev_video = false;
		} else if(info->has_video || selfp->show_vfx 
				|| selfp->show_vfx_embed){
			selfp->prev_video = true;
		} else {
			selfp->prev_video = false;
		}

		if(info->has_video){
			GtkRequisition req;
			gtk_widget_size_request((GtkWidget *)selfp->video_widget, &req);
			gtk_widget_queue_resize((GtkWidget *) selfp->video_widget);
			g_idle_add ((GSourceFunc) self_idle_resize, self);
		}
		if(selfp->show_vfx_embed){
			gdk_window_resize(GTK_WIDGET(selfp->video_widget)->window,
					76, 16);
			gtk_widget_queue_resize((GtkWidget *) selfp->video_widget);
		}

		if(selfp->timeout)
			g_source_remove(selfp->timeout);
		selfp->timeout = g_timeout_add(
				4000, (GtkFunction) self_xine_timeout_cb, self);
		if(xine_get_status (selfp->stream) == XINE_STATUS_PLAY)
			xine_stop(selfp->stream);
		error = xine_open (selfp->stream, ((LumPlayer *) self)->_priv->uri);
		if (error == 0) {
			lum_player_stop ((LumPlayer *) self);
			printf("xine error\n");
			return false;
		}

		if (xine_get_stream_info (selfp->stream,
				XINE_STREAM_INFO_VIDEO_HANDLED) == false
				&& xine_get_stream_info (selfp->stream,
				XINE_STREAM_INFO_AUDIO_HANDLED) == false) {
			char *name = g_strdup (xine_get_meta_info (selfp->stream,
					XINE_META_INFO_VIDEOCODEC));
			lum_player_stop ((LumPlayer *) self);
			
			g_warning("Xine error.\nReason: Video type '%s' is not handled.", name);
			g_free (name);
			return false;
		}

		error = xine_play (selfp->stream, 0, 0);

		if (error == 0){
			lum_player_stop ((LumPlayer *) self);
			self_xine_error (self);
			return false;
		}
		lum_player_set_volume((LumPlayer *)self,
				lum_player_get_volume((LumPlayer *)self));
		return true;
	}}
#line 1676 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 878 "gtk-xine.gob"
static void 
gtk_xine_pause (GtkXine * self)
#line 1682 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::pause"
#line 878 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 878 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 1689 "gtk-xine.c"
{
#line 878 "gtk-xine.gob"
	
		__d;
		if (lum_player_is_running((LumPlayer *) self) == false)
			return;
		if(((LumPlayer *) self)->_priv->status == PLAYER_PAUSED)
			xine_set_param(selfp->stream,
				XINE_PARAM_SPEED,
				XINE_SPEED_NORMAL);
		else if(((LumPlayer *) self)->_priv->status == PLAYER_PLAYING)
			xine_set_param(selfp->stream,
				XINE_PARAM_SPEED,
				XINE_SPEED_PAUSE);
	}}
#line 1705 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 893 "gtk-xine.gob"
static void 
gtk_xine_dest_size_cb (void * data, int video_width, int video_height, double video_pixel_aspect, int * dest_width, int * dest_height, double * dest_pixel_aspect)
#line 1711 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::dest_size_cb"
{
#line 897 "gtk-xine.gob"
	
		Self *self = SELF(data);

		if (self == NULL || selfp == NULL)
			return;

		if (video_pixel_aspect >= selfp->display_ratio)
			video_width  = video_width * video_pixel_aspect
					/ selfp->display_ratio + .5;
		else
			video_height = video_height * selfp->display_ratio
					/ video_pixel_aspect + .5;

		if(selfp->show_vfx_embed){
			*dest_width = 76;
			*dest_height = 16;
			*dest_pixel_aspect = ((double)video_width /
					(double)video_height) /
					((double) 76 / (double) 16);
		} else {
			*dest_width = GTK_WIDGET(selfp->video_widget)->allocation.width;
			*dest_height = GTK_WIDGET(selfp->video_widget)->allocation.height;
			*dest_pixel_aspect = selfp->display_ratio;
		}
	}}
#line 1741 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 924 "gtk-xine.gob"
static void 
gtk_xine_frame_output_cb (void * gtx_gen, int video_width, int video_height, double video_pixel_aspect, int * dest_x, int * dest_y, int * dest_width, int * dest_height, double * dest_pixel_aspect, int * win_x, int * win_y)
#line 1747 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::frame_output_cb"
{
#line 930 "gtk-xine.gob"
	
		Self *self = SELF(gtx_gen);

		if (self == NULL || selfp == NULL)
			return;

		/* correct size with video_pixel_aspect */
		if (video_pixel_aspect >= selfp->display_ratio)
			video_width = video_width * video_pixel_aspect
					/ selfp->display_ratio + .5;
		else
			video_height = video_height * selfp->display_ratio
					/ video_pixel_aspect + .5;

		*dest_x = 0;
		*dest_y = 0;
		*win_x = selfp->xpos;
		*win_y = selfp->ypos;

		if(selfp->show_vfx_embed){
			*dest_width = 76;
			*dest_height = 16;
			*dest_pixel_aspect =
				((double)video_width / (double)video_height) /
				((double) 76 / (double) 16);
		} else {
			*dest_width = GTK_WIDGET(selfp->video_widget)->allocation.width;
			*dest_height = GTK_WIDGET(selfp->video_widget)->allocation.height;
			*dest_pixel_aspect = selfp->display_ratio;
		}

		/* Size changed */
		if (((LumPlayer *) self)->_priv->info->video_width != video_width
				|| ((LumPlayer *) self)->_priv->info->video_height != video_height) {
			((LumPlayer *) self)->_priv->info->video_width = video_width;
			((LumPlayer *) self)->_priv->info->video_height = video_height;
			if(!selfp->show_vfx_embed)
				g_idle_add ((GSourceFunc) self_idle_resize, self);
		}
	}}
#line 1792 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 971 "gtk-xine.gob"
static bool 
gtk_xine_idle_resize (GtkXine * self)
#line 1798 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::idle_resize"
#line 971 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 971 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )0);
#line 1805 "gtk-xine.c"
{
#line 971 "gtk-xine.gob"
	
		__d;
		GtkRequisition req;
		gtk_widget_size_request((GtkWidget *) selfp->video_widget, &req);
		gtk_widget_queue_resize((GtkWidget *) selfp->video_widget);
		return false;
	}}
#line 1815 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 979 "gtk-xine.gob"
void 
gtk_xine_load_video_out_driver (GtkXine * self)
#line 1821 "gtk-xine.c"
{
	GtkXineClass *klass;
#line 979 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 979 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 1828 "gtk-xine.c"
	klass = GTK_XINE_GET_CLASS(self);

	if(klass->load_video_out_driver)
		(*klass->load_video_out_driver)(self);
}
#line 979 "gtk-xine.gob"
static void 
___real_gtk_xine_load_video_out_driver (GtkXine * self G_GNUC_UNUSED)
#line 1837 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::load_video_out_driver"
{
#line 979 "gtk-xine.gob"
	
		__d;
		bool has_video = false;
		if(((LumPlayer *) self)->_priv->info)
			has_video = ((LumPlayer *) self)->_priv->info->has_video;
		if(!selfp->show_vfx  && !selfp->show_vfx_embed &&
				!has_video){
			selfp->vo_driver = xine_open_video_driver (
					GTK_XINE_GET_CLASS(self)->xine,
					"none", XINE_VISUAL_TYPE_NONE, NULL);
			return;
		}

		if(!GTK_WIDGET_REALIZED(GTK_WIDGET(selfp->video_widget))){
			selfp->vo_driver = xine_open_video_driver (
					GTK_XINE_GET_CLASS(self)->xine,
					"none", XINE_VISUAL_TYPE_NONE, NULL);
			return;
		}

#ifndef OS_WIN32
		x11_visual_t vis;
		double res_h, res_v;
		GdkDisplay *gdkdisplay =
			gtk_widget_get_display(GTK_WIDGET(selfp->video_widget));
		GdkScreen *gdkscreen =
			gtk_widget_get_screen(GTK_WIDGET(selfp->video_widget));
		Display *display = GDK_DISPLAY_XDISPLAY(gdkdisplay);
		int *screen = (int *) GDK_SCREEN_XSCREEN(gdkscreen);
		
		const char *video_driver_id = selfp->show_vfx_embed ||
			!((LumPlayer *) self)->_priv->config->xv ? "Xshm" : "Xv";

		vis.display = display;
		vis.screen = *screen;
		vis.d = GDK_WINDOW_XID(GTK_WIDGET(selfp->video_widget)->window);
		res_h =
		    (gdk_screen_width()  * 1000 /
		     gdk_screen_width_mm());
		res_v =
		    (gdk_screen_height()  * 1000 /
		     gdk_screen_height_mm());
		selfp->display_ratio = res_v / res_h;

		if (fabs(selfp->display_ratio - 1.0) < 0.01)
			selfp->display_ratio = 1.0;

		vis.dest_size_cb = self_dest_size_cb;
		vis.frame_output_cb = self_frame_output_cb;
		vis.user_data = self;

		selfp->vo_driver = xine_open_video_driver (
						GTK_XINE_GET_CLASS(self)->xine,
						video_driver_id,
						XINE_VISUAL_TYPE_X11,
						(void *) &vis);
#else
		win32_visual_t vis;
		vis.WndHnd = GDK_WINDOW_HWND(GTK_WIDGET(
					selfp->video_widget)->window);
		vis.Hinst = instance;
		GetWindowRect(vis.WndHnd, &vis.WndRect);
		vis.Fullscreen = false;
		{
			WNDCLASSEX wc;
			HDC hdc = GetDC(GetDesktopWindow());
			for(vis.ColorKey = 5; vis.ColorKey < 0xFF;
					vis.ColorKey++ ){
		 		if(vis.ColorKey == GetNearestColor(hdc, vis.ColorKey))
					break;
		 	}
			ReleaseDC(desktop, hdc);
		}
		vis.Brush = CreateSolidBrush(colorkey);
		selfp->vo_driver = xine_open_video_driver (
				GTK_XINE_GET_CLASS(self)->xine, "directx",
				XINE_VISUAL_TYPE_DIRECTX, (void *) &vis);
#endif
		if (!selfp->vo_driver){
			selfp->vo_driver = xine_open_video_driver (
					GTK_XINE_GET_CLASS(self)->xine, "auto",
					XINE_VISUAL_TYPE_X11, (void *) &vis);
		}

	}}
#line 1927 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1065 "gtk-xine.gob"
void 
gtk_xine_load_audio_out_driver (GtkXine * self)
#line 1933 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::load_audio_out_driver"
#line 1065 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 1065 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 1940 "gtk-xine.c"
{
#line 1065 "gtk-xine.gob"
	
		__d;
		if(LUM_IS_PLAYER(self) &&
				((LumPlayer *) self)->_priv->config != NULL)
			selfp->ao_driver = xine_open_audio_driver (
					SELF_GET_CLASS(self)->xine,
					((LumPlayer *) self)->_priv->config->esd_out ?
					"esd" : "alsa", NULL);
		if (selfp->ao_driver == NULL){
			selfp->ao_driver = xine_open_audio_driver(
						SELF_GET_CLASS(self)->xine,
						NULL, NULL);
		}
	}}
#line 1957 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1080 "gtk-xine.gob"
static bool 
gtk_xine_video_window_translate_point (GtkXine * self, int gui_x, int gui_y, int * video_x, int * video_y)
#line 1963 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::video_window_translate_point"
#line 1080 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 1080 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )0);
#line 1970 "gtk-xine.c"
{
#line 1082 "gtk-xine.gob"
	
		__d;
		x11_rectangle_t rect;

		rect.x = gui_x;
		rect.y = gui_y;
		rect.w = 0;
		rect.h = 0;

		if (xine_port_send_gui_data (selfp->vo_driver,
				XINE_GUI_SEND_TRANSLATE_GUI_TO_VIDEO,
				(void*)&rect) != -1) {
		/* the driver implements gui->video coordinate space translation
		 * so we use it */
			*video_x = rect.x;
			*video_y = rect.y;
			return true;
		}

		return false;
	}}
#line 1994 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1104 "gtk-xine.gob"
static bool 
gtk_xine_generate_mouse_event (GtkXine * self, GdkEvent * event, bool is_motion)
#line 2000 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::generate_mouse_event"
#line 1104 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 1104 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )0);
#line 2007 "gtk-xine.c"
{
#line 1105 "gtk-xine.gob"
	
		__d;
		GdkEventMotion *mevent = (GdkEventMotion *) event;
		GdkEventButton *bevent = (GdkEventButton *) event;
		int x, y;
		bool retval;

		if (is_motion == false && bevent->button != 1)
			return false;

		if (is_motion == true)
			retval = self_video_window_translate_point (self,
					mevent->x, mevent->y, &x, &y);
		else
			retval = self_video_window_translate_point (self,
					bevent->x, bevent->y, &x, &y);
	
		if (retval == true)	{
			xine_event_t event;
			xine_input_data_t input;

			if (is_motion == true){
				event.type = XINE_EVENT_INPUT_MOUSE_MOVE;
				input.button = 0; /* Just motion. */
			} else {
				event.type = XINE_EVENT_INPUT_MOUSE_BUTTON;
				input.button = 1;
			}

			input.x = x;
			input.y = y;
			event.stream = selfp->stream;
			event.data = &input;
			event.data_length = sizeof(input);

			xine_event_send (selfp->stream,
					(xine_event_t *) (&event));

			return true;
		}

		return false;
	}}
#line 2053 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1150 "gtk-xine.gob"
void 
gtk_xine_event (gpointer user_data, const xine_event_t * event)
#line 2059 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::event"
{
#line 1150 "gtk-xine.gob"
	
		__d;
		Self *self = SELF(user_data);
		xine_ui_data_t *ui_data;

		switch (event->type) {
		case XINE_EVENT_UI_PLAYBACK_FINISHED:
			g_async_queue_push(selfp->queue,
					GINT_TO_POINTER(XINE_EVENT_UI_PLAYBACK_FINISHED));
			g_idle_add((GSourceFunc)self_idle, self);
			__ds(": received finished event");
			break;
		case XINE_EVENT_PROGRESS:
			selfp->buffering = ((xine_progress_data_t*)event->data)->percent;
			selfp->buffering_desc = g_strdup(
				((xine_progress_data_t*)event->data)->description);
			__ds("received progress event");
			g_async_queue_push(selfp->queue,
					GINT_TO_POINTER(XINE_EVENT_PROGRESS));
			g_idle_add((GSourceFunc)self_idle, self);
			break;
		case XINE_EVENT_UI_SET_TITLE:
			__ds(": received set title event");
			ui_data = event->data;
			g_async_queue_push(selfp->queue,
					GINT_TO_POINTER(XINE_EVENT_UI_SET_TITLE));
			g_idle_add((GSourceFunc)self_idle, self);
			break;

			break;
		case XINE_EVENT_UI_CHANNELS_CHANGED:
			__ds(": received channels changed event");
			break;
		case XINE_EVENT_UI_MESSAGE:
			__ds("received message event");
			break;
		case XINE_EVENT_AUDIO_LEVEL:
			__ds("received audio level event");
			break;
		case XINE_EVENT_MRL_REFERENCE:
			__ds("received mrl reference event");
			break;
		case XINE_EVENT_QUIT:
			__ds("received quit event");
			break;
		case XINE_EVENT_UI_NUM_BUTTONS:
			__ds("received num buttons event");
			break;
		case XINE_EVENT_SPU_BUTTON:
			__ds("received spu button event");
			break;
		case XINE_EVENT_DROPPED_FRAMES:
			__ds("received dropped frames event");
			break;

		default:
			break;
		}
	}}
#line 2123 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1210 "gtk-xine.gob"
static void 
gtk_xine_xine_error (GtkXine * self)
#line 2129 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_error"
#line 1210 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 1210 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 2136 "gtk-xine.c"
{
#line 1210 "gtk-xine.gob"
	
		__d;
		int error;

		error = xine_get_error (selfp->stream);
		if (error == XINE_ERROR_NONE)
			return;

		switch (error)	{
			case XINE_ERROR_NO_INPUT_PLUGIN:
				g_warning("Xine error: No input plugin found");
			break;
		case XINE_ERROR_NO_DEMUX_PLUGIN:
				g_warning("Xine error: No demux plugin found");
			break;
		case XINE_ERROR_DEMUX_FAILED:
				g_warning("Xine error: Demux failed");
			break;
		case XINE_ERROR_MALFORMED_MRL:
				g_warning("Xine error: Malformed URL");
			break;
		default:
			break;
		}
	}}
#line 2164 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1236 "gtk-xine.gob"
void 
gtk_xine_stream_clean (GtkXine * self)
#line 2170 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::stream_clean"
#line 1236 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 1236 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 2177 "gtk-xine.c"
{
#line 1236 "gtk-xine.gob"
	
		__d;
		if(selfp->timeout){
			g_source_remove(selfp->timeout);
			selfp->timeout = false;
		}
		if(selfp->stream){
			xine_close (selfp->stream);
			if(selfp->ev_queue){
				xine_event_dispose_queue (selfp->ev_queue);
				selfp->ev_queue = NULL;
			}
			xine_dispose (selfp->stream);
			selfp->stream = NULL;
		}
		if(selfp->vis){
			xine_post_dispose(SELF_GET_CLASS(self)->xine, selfp->vis);
			selfp->vis = NULL;
		}
		if(selfp->vo_driver){
			xine_close_video_driver(SELF_GET_CLASS(self)->xine, selfp->vo_driver);
			selfp->vo_driver = NULL;
		}
		if(selfp->ao_driver){
			xine_close_audio_driver(SELF_GET_CLASS(self)->xine, selfp->ao_driver);
			selfp->ao_driver = NULL;
		}
	}}
#line 2208 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1265 "gtk-xine.gob"
static void 
gtk_xine_set_vis (GtkXine * self)
#line 2214 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_vis"
#line 1265 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 1265 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 2221 "gtk-xine.c"
{
#line 1265 "gtk-xine.gob"
	
		__d;
		if(selfp->stream) {
			if(xine_get_status(selfp->stream) == XINE_STATUS_PLAY) {
				if(selfp->vis) {
					xine_post_out_t *pp;
					pp = xine_get_audio_source(selfp->stream);
					xine_post_wire_audio_port(pp, selfp->ao_driver);
					xine_post_dispose(SELF_GET_CLASS(self)->xine,
							selfp->vis);
					selfp->vis = NULL;
	    		}
    			if(selfp->show_vfx) {
					const xine_post_out_t *audio_source;
					const xine_post_in_t *input;
					if(!selfp->vis){
						if(((LumPlayer *) self)->_priv->status == PLAYER_PLAYING ||
							((LumPlayer *) self)->_priv->status == PLAYER_PAUSED){
							double pos;
							gint time;
							self_get_position_time(self, &pos, &time);
							self_stream_clean(self);
							self_play(self);
							xine_play(selfp->stream, 0, time);	
					}
						selfp->vis = xine_post_init(
								SELF_GET_CLASS(self)->xine,
								"goom", 0, 
		   						&selfp->ao_driver, 
		   						&selfp->vo_driver);
					}
					audio_source = xine_get_audio_source(selfp->stream);
					input = xine_post_input(selfp->vis, g_strdup("audio in"));
					xine_post_wire(audio_source, input);
	    		}
		 	}
	   	}
	}}
#line 2262 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1304 "gtk-xine.gob"
static void 
gtk_xine_set_vis_embed (GtkXine * self)
#line 2268 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::set_vis_embed"
#line 1304 "gtk-xine.gob"
	g_return_if_fail (self != NULL);
#line 1304 "gtk-xine.gob"
	g_return_if_fail (GTK_IS_XINE (self));
#line 2275 "gtk-xine.c"
{
#line 1304 "gtk-xine.gob"
	
		__d;
		if(selfp->show_vfx_embed){
			selfp->prev_parent = gtk_widget_get_parent_window(
					GTK_WIDGET(selfp->video_widget));
			gdk_window_resize(GTK_WIDGET(selfp->video_widget)->window,
					76, 16);
			gdk_window_reparent(GTK_WIDGET(selfp->video_widget)->window,
					selfp->parent, 24, 43);
			if(selfp->stream) {
				xine_post_out_t *audio_source;
				const xine_post_in_t *input;
				if(!selfp->vis){
					if(((LumPlayer *) self)->_priv->status == PLAYER_PLAYING ||
							((LumPlayer *) self)->_priv->status == PLAYER_PAUSED){
						double pos;
						gint time;
						self_get_position_time(self, &pos, &time);
						self_play(self);
						xine_play(selfp->stream, 0, time);
					}
					selfp->vis = xine_post_init(
								SELF_GET_CLASS(self)->xine,
								"fftscope", 0, 
		   						&selfp->ao_driver, 
		   						&selfp->vo_driver);
				}
				audio_source = xine_get_audio_source(selfp->stream);
				input = xine_post_input(selfp->vis, g_strdup("audio in"));
				xine_post_wire(audio_source, input);
			}
		} else {
			if(selfp->stream) {
				if(xine_get_status(selfp->stream) == XINE_STATUS_PLAY) {
					if(selfp->vis) {
						xine_post_out_t *pp;
						pp = xine_get_audio_source(selfp->stream);
						xine_post_wire_audio_port(pp, selfp->ao_driver);
						xine_post_dispose(SELF_GET_CLASS(self)->xine,
								selfp->vis);
						selfp->vis = NULL;
			    		}
				}
			}
			if(selfp->prev_parent){
				gdk_window_reparent(
						GTK_WIDGET(selfp->video_widget)->window,
						selfp->prev_parent, 24, 43);
				selfp->prev_parent = NULL;
			}
		}
	}}
#line 2330 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1357 "gtk-xine.gob"
static bool 
gtk_xine_idle (GtkXine * self)
#line 2336 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::idle"
#line 1357 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )0);
#line 1357 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )0);
#line 2343 "gtk-xine.c"
{
#line 1357 "gtk-xine.gob"
	
		__d;
		int event, queue_length;
		event = GPOINTER_TO_INT(g_async_queue_try_pop (selfp->queue));
		switch(event){
			case XINE_EVENT_UI_PLAYBACK_FINISHED:
				if(((LumPlayer *) self)->repeat)
					lum_player_set_position((LumPlayer *) self, 0.0);
				lum_player_playbackfinished((LumPlayer *) self);
				break;
			case XINE_EVENT_PROGRESS:
				printf("buffering: %s, percent: %d\n",
						selfp->buffering_desc,
						selfp->buffering);
				break;
			default:
				break;
		}
		queue_length = g_async_queue_length(selfp->queue);

		return (queue_length > 0);
	}}
#line 2368 "gtk-xine.c"
#undef __GOB_FUNCTION__

#line 1380 "gtk-xine.gob"
static bool 
gtk_xine_xine_timeout_cb (GtkXine * self)
#line 2374 "gtk-xine.c"
{
#define __GOB_FUNCTION__ "Gtk:Xine::xine_timeout_cb"
#line 1380 "gtk-xine.gob"
	g_return_val_if_fail (self != NULL, (bool )false);
#line 1380 "gtk-xine.gob"
	g_return_val_if_fail (GTK_IS_XINE (self), (bool )false);
#line 2381 "gtk-xine.c"
{
#line 1380 "gtk-xine.gob"
	
		__d;
		if(((LumPlayer *) self)->_priv->fullscreen
				&& selfp->video_widget->cursor_visible) {
			gdk_window_set_cursor(GTK_WIDGET(selfp->video_widget)->window, 
		  			selfp->video_widget->no_cursor);
		 	selfp->video_widget->cursor_visible = false;
	 	}

		return true;
	}}
#line 2395 "gtk-xine.c"
#undef __GOB_FUNCTION__
