%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Qtopia
Name            : qtopia
Version         : 4.3.0
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : John Rigby, John Faith
Group           : System Environment/Graphics
Source          : %{name}-opensource-src-%{version}.tar.gz
#Source1			: helix-20070404cvs.tar.bz2

# These patches can be platform specific but must be safe for application
# on all platforms
Patch1		: qtopia-opensource-4.3.0-qconfig-cursor-mouse-01.patch
#Patch2		: qtopia-opensource-4.3.0-rgb555-and-swapped-byte-video-01.patch
#Patch3		: qtopia-opensource-4.3.0-mpc5200-nogetospace-01.patch
Patch4		: qtopia-opensource-4.3.0-native-endian-audio-01.patch
Patch5		: qtopia-opensource-4.3.0-standard-touchscreen-01.patch
#Patch6		: qtopia-opensource-4.3.0-mpc5200-touchscreen-01.patch
Patch7		: qtopia-opensource-4.3.0-imx21-touchscreen-01.patch
Patch9		: qtopia-opensource-4.3.0-mx21-buttons-01.patch
Patch10		: qtopia-opensource-4.3.0-screensaver-01.patch
Patch11		: qtopia-opensource-4.3.0-mxc-platform-01.patch
#Patch12		: qtopia-opensource-4.3.0-mpc5200-platform-01.patch
Patch13		: qtopia-opensource-4.3.0-imx21-platform-01.patch
#Patch15		: qtopia-opensource-4.3.0-helix-build-01.patch
Patch16		: qtopia-opensource-4.3.0-gstreamer-01.patch
Patch17		: qtopia-opensource-4.3.0-usbkeyboard.patch
Patch18     : qtopia-opensource-4.3.0-video-playback-01.patch

BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup -n %{name}-opensource-%{version}
%patch1 -p1
#%patch2 -p1
#%patch3 -p1
%patch4 -p1
%patch5 -p1
#%patch6 -p1
%patch7 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
#%patch12 -p1
%patch13 -p1
#%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1


if [ -n $PKG_QTOPIA_WANT_MEDIA_NONE ]; then
	Q_MEDIA_CONFIG="-no-qtopiamedia"
elif [ -n PKG_QTOPIA_WANT_MEDIA_GSTREAMER ]; then
	Q_MEDIA_CONFIG="-mediaengines gstreamer"
fi

if [ -n $PKG_QTOPIA_WANT_SOUND_ALSA ]; then
	Q_SOUND_CONFIG="-sound-system alsa"
elif [ -n $PKG_QTOPIA_WANT_SOUND_OSS ]; then
	Q_SOUND_CONFIG="-sound-system oss"
fi

if [ -z $PKG_QTOPIA_WANT_IRDA ]; then
	Q_IRDA_CONFIG="-no-infrared"
fi

# Define QWS_PLATFORM and specifiy extra qte and qpe configure options
export QWS_PLATFORM=$PLATFORM
case "$PLATFORM" in
	imx27ads | imx31ads | imx32ads)
	export QWS_PLATFORM=mxc
	# kbd-usb is used for the keypad too.
	export EXTRA_QTE_CONFIG=" -qt-mouse-tslib -qt-kbd-usb"
	#export EXTRA_QPE_CONFIG_HELIX=" -helix -helix-system-id linux-2.2-libc6-arm9-cross-gcc4 "
	export EXTRA_QPE_CONFIG=" -displaysize 240x320 $Q_SOUND_CONFIG $Q_MEDIA_CONFIG $Q_IRDA_CONFIG -no-drm -no-bluetooth -no-modem -no-sxe -no-voip -no-vpn"
	export QWS_KEYBOARD=USB:/dev/input/event0
	#export QWS_MOUSE_PROTO=Tslib:/dev/ts
	export QWS_MOUSE_PROTO=Tslib:/dev/input/event1
	export QWS_DISPLAY=LinuxFb:mmWidth=54:mmHeight=72
	export QWS_SIZE="240x320"
	;;
	imx21ads)
	export EXTRA_QTE_CONFIG=
	#export EXTRA_QPE_CONFIG_HELIX=" -helix -helix-system-id linux-2.2-libc6-arm9-cross-gcc4 "
	export EXTRA_QPE_CONFIG=" -displaysize 240x320 $Q_SOUND_CONFIG $Q_MEDIA_CONFIG -no-drm -no-bluetooth -no-modem -no-sxe -no-voip -no-vpn"
	export QWS_KEYBOARD=imx21adskbdhandler
	export QWS_MOUSE_PROTO=imx21adsmousehandler
	export QWS_DISPLAY=LinuxFb:mmWidth=54:mmHeight=72
	export QWS_SIZE="240x320"
	;;
	mpc5200)
	export EXTRA_QTE_CONFIG="-rgb555 -swapbytes_video "
	export EXTRA_QPE_CONFIG="-rgb555 -swapbytes-video -displaysize 1024x768"
	export QWS_KEYBOARD=TTY
	export QWS_DISPLAY=LinuxFb:mmWidth=170:mmHeight=125
	export QWS_SIZE="1024x768"
	;;
	mpc5121ads)
	# USB keyboard and mouse
	export EXTRA_QTE_CONFIG=" -qt-mouse-pc -qt-kbd-usb"
	export EXTRA_QPE_CONFIG=" -displaysize 1024x768 $Q_SOUND_CONFIG $Q_MEDIA_CONFIG -no-drm -no-bluetooth -no-modem -no-sxe -no-voip -no-vpn"
	export QWS_KEYBOARD=USB:/dev/input/event1
	export QWS_MOUSE_PROTO="IntelliMouse:/dev/input/mice"
	export QWS_DISPLAY=LinuxFb:mmWidth=170:mmHeight=125
	export QWS_SIZE="1024x768"
	;;
esac
export UC_QWS_PLATFORM=`perl -e "print uc $QWS_PLATFORM"`

# Create qtopia4 device config files
mkdir -p devices/$QWS_PLATFORM
CONFIG_PRI=devices/$QWS_PLATFORM/config.pri
if [ -f $CONFIG_PRI ]; then
	mv -f $CONFIG_PRI $CONFIG_PRI.bak
fi
echo "DEFINES+=QT_QWS_$UC_QWS_PLATFORM" > $CONFIG_PRI
echo "#DEFINES+=DEBUG" >> $CONFIG_PRI

# Use the target project file to disable applications.
# See src/general.pri for examples.
mkdir -p devices/$QWS_PLATFORM/src
PROJECTS_PRI=devices/$QWS_PLATFORM/projects.pri
if [ -z $PKG_QTOPIA_WANT_APP_CALCULATOR ]; then
	echo 'PROJECTS-=applications/calculator' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_CALENDAR ]; then
	echo 'PROJECTS-=applications/datebook' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_CAMERA ]; then
	echo 'PROJECTS-=applications/camera' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_CLOCK ]; then
	echo 'PROJECTS-=applications/clock' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_CONTACTS ]; then
	echo 'PROJECTS-=applications/addressbook' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_GAMES ]; then
	echo 'PROJECTS-=games/qasteroids games/fifteen games/minesweep games/snake' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_HELP ]; then
	echo 'PROJECTS-=applications/helpbrowser' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_MAIL ]; then
	echo 'PROJECTS-=applications/qtmail libraries/qtopiamail plugins/composers/email plugins/composers/generic plugins/composers/mms plugins/viewers/generic' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_MEDIAPLAYER ]; then
	echo 'PROJECTS-=applications/mediaplayer' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_MEDIARECORDER ]; then
	echo 'PROJECTS-=applications/mediarecorder' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_NOTES ]; then
	echo 'PROJECTS-=applications/textedit' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_PACKAGEMANAGER ]; then
	echo 'PROJECTS-=settings/packagemanager' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_PHOTOEDIT ]; then
	echo 'PROJECTS-=applications/photoedit' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_SYNC ]; then
	echo 'PROJECTS-=tools/qdsync/common tools/qdsync/app tools/qdsync/base tools/qdsync/pim' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_TODO ]; then
	echo 'PROJECTS-=applications/todo' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_APP_WORLDTIME ]; then
	echo 'PROJECTS-=settings/worldtime' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_APPEARANCE ]; then
	echo 'PROJECTS-=settings/appearance' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_CALIBRATE ]; then
	echo 'PROJECTS-=settings/calibrate' >> $PROJECTS_PRI
fi
#if [ -z $PKG_QTOPIA_WANT_IRDA ]; then
#	echo 'PROJECTS-=settings/beaming' >> $PROJECTS_PRI
#fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_DATETIME ]; then
	echo 'PROJECTS-=settings/systemtime' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_HANDWRITING ]; then
	echo 'PROJECTS-=settings/handwriting libraries/handwriting 3rdparty/plugins/inputmethods/pkim' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_HOMESCREEN ]; then
	echo 'PROJECTS-=settings/homescreen' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_NETWORK ]; then
	echo 'PROJECTS-=settings/network' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_LANGUAGE ]; then
	echo 'PROJECTS-=settings/language' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_LOGGING ]; then
	echo 'PROJECTS-=settings/logging' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_POWER ]; then
	echo 'PROJECTS-=settings/light-and-power' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_SECURITY ]; then
	echo 'PROJECTS-=settings/security' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_SERVERWIDGETS ]; then
	echo 'PROJECTS-=settings/serverwidgets' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_SPEEDDIAL ]; then
	echo 'PROJECTS-=settings/speeddial' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_SETTINGS_WORDS ]; then
	echo 'PROJECTS-=settings/words' >> $PROJECTS_PRI
fi
if [ -z $PKG_QTOPIA_WANT_HOST_GUI_TOOLS ]; then
	# Skip unneeded host tools
	echo 'PROJECTS-=tools/qt/designer tools/qt/designer/src/uitools tools/qt/designer/src/lib tools/qt/designer/src/components tools/qt/assistant tools/qt/linguist' >> $PROJECTS_PRI
fi


DEVICE_CONFIGURE=devices/$QWS_PLATFORM/configure
echo "-arch $GNUTARCH -xplatform $QWS_PLATFORM -prefix /opt/Qtopia" > $DEVICE_CONFIGURE
#echo '-debug' >> $DEVICE_CONFIGURE
echo $EXTRA_QPE_CONFIG >> $DEVICE_CONFIGURE

# Define qt options in device qconfig.h (see main configure script).
if [ "$PKG_QTOPIA_WANT_MOUSE" = "y" ]; then
	cat > devices/$QWS_PLATFORM/qconfig.h << EOF
	#include "../../qtopiacore/qconfig-qpe.h"

	#ifdef QT_NO_CURSOR
	#undef QT_NO_CURSOR
	#endif
	#ifdef QT_NO_QWS_ALPHA_CURSOR
	#undef QT_NO_QWS_ALPHA_CURSOR
	#endif
	#ifdef QT_NO_QWS_CURSOR
	#undef QT_NO_QWS_CURSOR
	#endif

	#ifdef QT_NO_QWS_MOUSE
	#undef QT_NO_QWS_MOUSE
	#endif
	#ifdef QT_NO_QWS_MOUSE_AUTO
	#undef QT_NO_QWS_MOUSE_AUTO
	#endif
	#ifdef QT_NO_QWS_MOUSE_MANUAL
	#undef QT_NO_QWS_MOUSE_MANUAL
	#endif
EOF
fi

# Make platformdefs header
if [ ! -e devices/$QWS_PLATFORM/mkspecs/qws/linux-"$QWS_PLATFORM"-g++/qplatformdefs.h ]; then
	mkdir -p devices/$QWS_PLATFORM/mkspecs/qws/linux-"$QWS_PLATFORM"-g++
	cp -f devices/gcc411/mkspecs/linux-g++/qplatformdefs.h devices/$QWS_PLATFORM/mkspecs/qws/linux-"$QWS_PLATFORM"-g++/qplatformdefs.h
fi

echo export EXTRA_QPE_CONFIG=\"$EXTRA_QPE_CONFIG\" > ltibqtopiaconfig
echo export EXTRA_QTE_CONFIG=\"$EXTRA_QTE_CONFIG\" >> ltibqtopiaconfig
echo export PKG_QTOPIA_WANT_MOUSE=\"$PKG_QTOPIA_WANT_MOUSE\" >> ltibqtopiaconfig
echo export QWS_PLATFORM=$QWS_PLATFORM >> ltibqtopiaconfig
echo export QWS_KEYBOARD=\"$QWS_KEYBOARD\" >> ltibqtopiaconfig
echo export QWS_DISPLAY=\"$QWS_DISPLAY\" >> ltibqtopiaconfig
echo export QWS_SIZE=\"$QWS_SIZE\" >> ltibqtopiaconfig
echo export QWS_MOUSE_PROTO=\"$QWS_MOUSE_PROTO\" >> ltibqtopiaconfig

echo Note that e2fsprogs-devel, libjpeg/libjpeg-devel, uuid-dev/libuuid,
echo gettext \(msgfmt\), and libxtst-dev packages are required on the host.

# qmake config
# Use linux-arm-g++ configuration as a starting point, then substitute TOOLCHAIN_PREFIX
# and add target include, library paths.
cp -r qtopiacore/qt/mkspecs/qws/linux-arm-g++ qtopiacore/qt/mkspecs/qws/linux-$QWS_PLATFORM-g++
perl -p -i -e 's,arm-linux-,$ENV{TOOLCHAIN_PREFIX},;
               s,^((?:QMAKE|TMAKE)_CFLAGS\s+).*,$1 = -pipe -I. -I $ENV{DEV_IMAGE}/usr/include $ENV{EXTRA_CFLAGS},;
               s,^((?:QMAKE|TMAKE)_LFLAGS\s+).*,$1 = -L $ENV{DEV_IMAGE}/usr/lib $ENV{EXTRA_LDFLAGS},;
               s,^((?:QMAKE|TMAKE)_CXXFLAGS\s+.*),$1 $ENV{EXTRA_CFLAGS},;
              ' qtopiacore/qt/mkspecs/qws/linux-$QWS_PLATFORM-g++/qmake.conf

# Device qmake.conf
if [ ! -e devices/$QWS_PLATFORMmkspecs/qws/linux-$QWS_PLATFORM-g++/qmake.conf ]; then
	cp devices/imx21ads/mkspecs/qws/linux-imx21ads-g++/qmake.conf devices/$QWS_PLATFORM/mkspecs/qws/linux-$QWS_PLATFORM-g++
	perl -p -i -e 's,arm-linux-,$ENV{TOOLCHAIN_PREFIX},;
               s,^((?:QMAKE|TMAKE)_CFLAGS\s+).*,$1 = -pipe -I. -I $ENV{DEV_IMAGE}/usr/include $ENV{EXTRA_CFLAGS},;
               s,^((?:QMAKE|TMAKE)_LFLAGS\s+).*,$1 = -L $ENV{DEV_IMAGE}/usr/lib $ENV{EXTRA_LDFLAGS},;
               s,^((?:QMAKE|TMAKE)_CXXFLAGS\s+.*),$1 $ENV{EXTRA_CFLAGS},;
               s,IMX21ADS,$ENV{UC_QWS_PLATFORM},g;
              ' devices/$QWS_PLATFORM/mkspecs/qws/linux-$QWS_PLATFORM-g++/qmake.conf
fi

# Create generic q/s/l/q/custom-linux-$QWS_PLATFORM-g++.* files if not created by a patch
export QT_BASE=src/libraries/qtopiabase
test -e $QT_BASE/custom-linux-$QWS_PLATFORM-g++.h \
	|| cp $QT_BASE/custom-linux-generic-g++.h $QT_BASE/custom-linux-$QWS_PLATFORM-g++.h
test -e $QT_BASE/custom-linux-$QWS_PLATFORM-g++.cpp \
	|| cp $QT_BASE/custom-linux-generic-g++.cpp $QT_BASE/custom-linux-$QWS_PLATFORM-g++.cpp

# Symlink to helix source
#cd src/3rdparty/libraries/helix
#ln -s ../../../../../helix-20070404cvs src

exit 0


%Build
source ./ltibqtopiaconfig

export PATH=$UNSPOOF_PATH
# Unset compiler to prevent gcc being used when the cross
# tools should be used. (Trolltech issue# 138807)
unset CC CXX
if [ "$EXTRA_QTE_CONFIG" = "" ] ; then
	echo yes | ./configure -device $QWS_PLATFORM -verbose
else
	echo yes | ./configure -device $QWS_PLATFORM -verbose -extra-qtopiacore-config "${EXTRA_QTE_CONFIG} -I ${DEV_IMAGE}/usr/include -L ${DEV_IMAGE}/usr/lib"
fi

# For debugging
export VERBOSE_SHELL=1

# Build root env var required by helix
#export BUILD_ROOT=$RPM_BUILD_DIR/$RPM_PACKAGE_NAME-$RPM_PACKAGE_VERSION/src/3rdparty/libraries/helix/helixbuild/build
make

exit 0


%Install
source ./ltibqtopiaconfig
export PATH=$UNSPOOF_PATH
echo creating qtopia install image
make install > /dev/null
rm -rf $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT/%{pfx}/opt/Qtopia
cp -a image/* $RPM_BUILD_ROOT/%{pfx}/opt/Qtopia
install -d $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d

initscript=$RPM_BUILD_ROOT/%{pfx}/etc/rc.d/init.d/qtopia
cat > $initscript << EOF
#!/bin/sh
#
# Copyright 2006, 2007, Freescale Semiconductor Inc.
#
if [ "\$1" = "stop" -o "\$1" = "restart" ]
then
    echo "Stopping qtopia: "
    killall qpe 2>/dev/null
    killall quicklauncher 2>/dev/null
    killall mediaserver 2>/dev/null
    killall mediaplayer 2>/dev/null
    killall sipagent 2>/dev/null
    killall sxemonitor 2>/dev/null
fi
if [ "\$1" = "stop" ]; then
	exit 0
fi
HOME=/root
# Set QPE_USE_MOUSE to "y" to use mouse 
# otherwise touchscreen will be used
QPE_USE_MOUSE="$PKG_QTOPIA_WANT_MOUSE"
export HOME QPE_USE_MOUSE
# Make sure usb input, mouse, and ts nodes exist
mkdir -p /dev/input
test -c /dev/input/event1 || mknod /dev/input/event1 c 13 65
test -c /dev/input/mice || mknod /dev/input/mice c 13 63
test -c /dev/ts || mknod /dev/ts c 11 0
# Disable screen blanking
if [ -c /dev/vc/0 ]; then
	echo -e -n '\033[9]' > /dev/vc/0
fi
QTDIR=/opt/Qtopia
QPEDIR=/opt/Qtopia
LD_LIBRARY_PATH=/opt/Qtopia/lib
PATH=/opt/Qtopia/bin:\$PATH
QWS_SIZE="$QWS_SIZE"
export QTDIR QPEDIR LD_LIBRARY_PATH PATH QWS_SIZE
QWS_KEYBOARD="$QWS_KEYBOARD"
export QWS_KEYBOARD
if [ _\$QPE_USE_MOUSE = "_y" ]
then
QWS_MOUSE_PROTO="USB:/dev/input/mice"
export QWS_MOUSE_PROTO
# Override pointer calibration when using mouse
touch /etc/pointercal 
else
QWS_MOUSE_PROTO="$QWS_MOUSE_PROTO"
# Hide cursor when using touchscreen
QWS_HIDE_CURSOR="Yes"
export QWS_MOUSE_PROTO QWS_HIDE_CURSOR
# Hide cursor
if [ -c /dev/vc/0 ]; then
	echo -e -n '\033[?25l' > /dev/vc/0
fi
# Remove pointercal if it is empty
[ -f /etc/pointercal -a ! -s /etc/pointercal ] && rm -f /etc/pointercal
fi
QWS_DISPLAY="$QWS_DISPLAY"
export QWS_DISPLAY

#export QT_DEBUG_PLUGINS=1

cd /opt/Qtopia/bin
./qpe > /dev/null 2>&1 &
#./qpe &

# Calibration
if [ ! -f /etc/pointercal ]; then
	# qpe4 does not auto start calibration, so wait for qpe to start
	# then launch calibration.
	maxTries=6
	success=`expr \$maxTries + 4`
	try=1
	while [ \$try -lt \$maxTries ]
	do
		echo " Waiting for qcop (try \$try)..."
		# See if qcop is runnable
		qcop list >/dev/null 2>&1
		if [ "\$?" -eq 0 ]; then
			try=\$success
			break
		else
			try=\`expr \$try + 1\`
			sleep 1
		fi
	done
	# Request calibration
	if [ "\$try" -eq \$success ]; then
		echo " Requesting calibration"
		qcop service send Launcher "execute(QString)" "calibrate"
		#ln -s $HOME/Settings/pointercal /etc/pointercal
	else
		echo Failed to run touchscreen calibration since qcop could not run.
	fi
fi
EOF

chmod 744 $initscript
echo '1' > $RPM_BUILD_ROOT/%{pfx}/etc/firstuse
# setup Storage.conf
install -d $RPM_BUILD_ROOT/%{pfx}/root/Settings
cat > $RPM_BUILD_ROOT/%{pfx}/root/Settings/Storage.conf << EOF
[rootfs]
Name = Internal Storage
Removeable = 0
[/dev/sda1]
Name = USB Flash Drive
Removable = 1
EOF

# Make sure the strip scripts are run cross
export PATH=$SPOOF_PATH

%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


