%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Tools for managing kernel packet filtering capabilities
Name            : iptables
Version         : 1.3.8
Release         : 0
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes, Emil Medve
Group           : System Environment/Base
URL             : http://www.netfilter.org/projects/iptables
Source          : %{name}-%{version}.tar.bz2
Patch0          : iptables-for-kernel-2.6.20forward-layer7-2.13.patch
Patch1          : iptables-fsl-8572-pme.patch 
Patch2          : iptables-1.3.8-u32.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

iptables is the userspace command line program used to configure the Linux 2.4.x and 2.6.x IPv4
packet filtering ruleset. It is targeted towards system administrators

Since Network Address Translation is also configured from the packet filter ruleset, iptables is
used for this, too

The iptables package also includes ip6tables. ip6tables is used for configuring the IPv6 packet
filter

iptables requires a kernel that features the ip_tables packet filter. This includes all 2.4.x and
2.6.x kernel releases

Main Features
        * listing the contents of the packet filter ruleset
        * adding/removing/modifying rules in the packet filter ruleset
        * listing/zeroing per-rule counters of the packet filter ruleset

%Prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1

%Build
chmod +x extensions/.layer7-test extensions/.l7pm-test
make KERNEL_DIR=$DEV_IMAGE/%{_prefix}/src/linux PREFIX=%{_prefix}

%Install
rm -rf $RPM_BUILD_ROOT
make install KERNEL_DIR=$DEV_IMAGE/%{_prefix}/src/linux DESTDIR=$RPM_BUILD_ROOT/%{pfx} PREFIX=%{_prefix}

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
