%define pfx /opt/freescale/rootfs/%{_target_cpu}
%define pkg_name gdb-stable
%define cs_version 4.1-78

Summary         : Gdb - GNU Source level debugger for C, C++
Name            : gdb
Version         : 6.6cs
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes/Steve Papacharalambous
Group           : Development/Debuggers
Source          : %{name}-%{cs_version}.tar.bz2
Patch0          : gdb-6.0-tcsetpgrp.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

Notes:

This gcc package is built using the %{cs_version} sources from CodeSourcery.

The source can be obtained by downloading the source rpm:
freescale-powerpc-linux-gnu-%{cs_version}.src.rpm from:
http://www.codesourcery.com/gnu_toolchains/power/download.html and then
extracting the gdb source archive from this source rpm.

requires: libtermcap and ncurses


%Prep
%setup -n %{pkg_name}
%patch0 -p1

# Temporary hack.  Stevep
# This is to prevent the following error occuring on some build systems:
# [snip]
# Doing pdf in readline
# make[3]: Entering directory `/home/stevep/work/ltib/rpm/BUILD/gdb-stable/readline'
# ( cd doc && make -w pdf )
# make[4]: Entering directory `/home/stevep/work/ltib/rpm/BUILD/gdb-stable/readline/doc'
# TEXINPUTS=.:../.././readline/doc:$TEXINPUTS ../.././readline/doc/texi2dvi ../.././readline/doc/rlman.texi
# This is TeX, Version 3.14159 (Web2C 7.3.1)
# (/home/stevep/work/ltib/rpm/BUILD/gdb-stable/readline/doc/rlman.texi
# (/usr/share/texmf/tex/texinfo/texinfo.tex
# Loading texinfo [version 1999-09-25.10]: Basics, pdf, fonts, page headings,
# tables, conditionals, indexing, sectioning, toc, environments, defuns, macros,
# cross references, (/usr/share/texmf/tex/plain/dvips/epsf.tex) localization,
# and turning on texinfo input format.) (rlman.aux) (version.texi)
# ! Undefined control sequence.
# l.11 @copying
#              
# ? 
# [/snip]
perl -pi.orig -e 's,^\@copying,\@comment \@copying,;
                  s,^\@end\s+copying,\@comment \@end copying,;
                  s,^\@insertcopying,\@comment \@insertcopying,;' readline/doc/rlman.texi

perl -pi.orig -e 's,^\@copying,\@comment \@copying,;
                  s,^\@end\s+copying,\@comment \@end copying,;
                  s,^\@insertcopying,\@comment \@insertcopying,;' readline/doc/history.texi

perl -pi.orig -e 's,^\@copying,\@comment \@copying,;
                  s,^\@end\s+copying,\@comment \@end copying,;
                  s,^\@insertcopying,\@comment \@insertcopying,;' readline/doc/rluserman.texi


%Build
ORIG_PATH=$PATH
# This is the optimised host type.  Needed to prevent infering a native build
OPT_CFGHOST=`echo ${TOOLCHAIN_PREFIX} | perl -n -e 's,-$,,;print'`

# do something (the least costly)
if [ -z "$PKG_GDB_CROSS_WANT_ED$PKG_GDB_SERVER_WANT_ED$PKG_GDB_NATIVE_WANT_ED" ]
then
    PKG_GDB_SERVER_WANT_ED=y
fi

# cross gdb to run on the build machine
if [ -n "$PKG_GDB_CROSS_WANT_ED" ]
then
    BD=cross-gdb
    rm -rf $BD
    mkdir -p $BD
    cd $BD
    export PATH=$UNSPOOF_PATH
    export ac_cv_header_stdc=yes bash_cv_have_mbstate_t=yes \
           ac_cv_header_nlist_h=no ac_cv_libexpat=no
    ../configure --prefix=%{_prefix} --target=$CFGHOST --mandir=%{_mandir}
    make
    cp gdb/gdb $TOP/bin/gdb
    cd -
fi

# from now build stuff to go into the rpm package
export PATH=$ORIG_PATH

# gdbserver to run on the target
if [ -n "$PKG_GDB_SERVER_WANT_ED" ]
then
    cd gdb/gdbserver
    ./configure --prefix=%{_prefix} --host=$CFGHOST --mandir=%{_mandir}
    make
    cd -
fi

# full gdb to run on the target
if [ -n "$PKG_GDB_NATIVE_WANT_ED" ]
then
    export CPP="$BUILDCPP"
    export CC_FOR_BUILD="$BUILDCC"
    export ac_cv_header_stdc=yes bash_cv_have_mbstate_t=yes \
           ac_cv_header_nlist_h=no
    CC=gcc AR=ar \
    ./configure --prefix=%{_prefix} --host=$OPT_CFGHOST --build=%{_build} --mandir=%{_mandir}
    # don't build gdbserver
    perl -pi.orig -e 's,(x\$build_gdbserver),$1_no_thanks,' gdb/configure
    make
fi

%Install
if [ -z "$PKG_GDB_CROSS_WANT_ED$PKG_GDB_SERVER_WANT_ED$PKG_GDB_NATIVE_WANT_ED" ]
then
    PKG_GDB_SERVER_WANT_ED=y
fi

rm -rf $RPM_BUILD_ROOT
if [ -n "$PKG_GDB_SERVER_WANT_ED" ]
then
    cd gdb/gdbserver
    make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
    cd -
fi
if [ -n "$PKG_GDB_NATIVE_WANT_ED" ]
then
    make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
    # remove standards.info which conflicts with autoconf
    rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/info/standards.info
fi
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/*.la

%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


