%define base %(echo %{_prefix} | sed -e s,/usr.*$,,)
%define pfx /opt/freescale/rootfs/%{_target_cpu}
%define __os_install_post %{nil}
%define ppc_axe_driver ppc-axe-driver-20071127

Summary         : AXE driver for mpc5121
Name            : axe
Version         : 1.0
Release         : 1
License         : GPL/MIT
Vendor          : Freescale
Packager        : John Rigby
Group           : Drivers/Sound
Source          : %{name}-%{version}.tar.gz
Source1		: %{ppc_axe_driver}.zip
Patch1		: %{ppc_axe_driver}-fixes.patch
Patch2		: %{ppc_axe_driver}-Task-Context-Fixes.patch
Patch3		: axe-1.0-allocation-debug.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup
unzip ${RPM_SOURCE_DIR}/%{ppc_axe_driver}.zip
%patch1 -p1
%patch2 -p1
%patch3 -p1
cd axe_lib/osindlib
ln -sf ../../%{ppc_axe_driver} ppc-axe-driver

%Build
KSRC_DIR=${PKG_KERNEL_PATH_PRECONFIG:-$RPM_BUILD_DIR/linux}
if [ ! -f $KSRC_DIR/Makefile ]
then
    cat <<TXT
You need a built unpacked kernel source tree in:
$KSRC_DIR/Makefile
to build kernel modules
TXT
    exit 1
fi
make KERNELDIR=$KSRC_DIR clean
make -j1 KERNELDIR=$KSRC_DIR

%Install
KSRC_DIR=${PKG_KERNEL_PATH_PRECONFIG:-$RPM_BUILD_DIR/linux}
rm -rf $RPM_BUILD_ROOT
KVER="`perl -e '$/ = ""; $_ = <>; m,VERSION\s*=\s*(\d)\s*PATCHLEVEL\s*=\s*(\d+)\s*SUBLEVEL\s*=\s*(\d+)\s*EXTRAVERSION[ \t]*=[ \t]*(\S*),m; print  "$1.$2.$3$4"' $KSRC_DIR/Makefile`"
DESTDIR=$RPM_BUILD_ROOT/%{pfx}/%{base}
MODDESTDIR=$DESTDIR/lib/modules/$KVER/misc/
mkdir -p $MODDESTDIR
make install  DESTDIR=$DESTDIR MODDESTDIR=$MODDESTDIR

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*

