%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : System configuration package
Name            : sysconfig
Version         : 1.0
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Stuart Hughes/Alan Tull
Group           : System Environment/Base
#Source          : %{name}-%{version}.tar.bz2
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
#%setup 

%Build

%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{pfx}/etc/rc.d
if [ -n "$SYSCFG_DHCPC" ]
then
    SYSCFG_IPADDR="dhcp"
fi

if [ "$SYSCFG_START_SYSLOG" = "y" ]
then
    syslog=syslog
fi
if [ "$SYSCFG_START_NETWORK" = "y" ]
then
    network=network
fi
if [ "$SYSCFG_START_INETD" = "y" ]
then
    inetd=inetd
fi
if [ "$SYSCFG_START_PORTMAP" = "y" ]
then
    portmap=portmap
fi
if [ "$SYSCFG_START_DROPBEAR_SSH" = "y" ]
then
    dropbear=dropbear
fi
if [ "$SYSCFG_START_BOA" = "y" ]
then
    boa=boa
fi
if [ "$SYSCFG_SETTIME" = "y" ]
then
    settime=settime
fi

cat <<EOF > $RPM_BUILD_ROOT/%{pfx}/etc/rc.d/rc.conf
export HOSTNAME=${SYSCFG_HOSTNAME:-ltib}
export INTERFACE=${SYSCFG_NET_INTERFACE:-eth0}
export IPADDR=${SYSCFG_IPADDR:-192.168.0.253}
export NETMASK=${SYSCFG_NET_MASK:-255.255.255.0}
export BROADCAST=${SYSCFG_NET_BROADCAST:-192.168.0.255}
export GATEWAY=${SYSCFG_NET_GATEWAY:-192.168.0.1}
export NAMESERVER=${SYSCFG_NAMESERVER:-192.168.0.1}
export NTP_SERVER=${SYSCFG_NTP_SERVER:-ntp.cs.strath.ac.uk}
export MODLIST="$SYSCFG_MODLIST"
export RAMDIRS="$SYSCFG_RAM_DIRS"
export READONLY_FS="$SYSCFG_READONLY_FS"
export SYSLOG_SOCKET_FILE="$SYSCFG_SYSLOG_SOCKET_FILE"
export INETD_ARGS="${SYSCFG_INETD_ARGS}"
export BOA_ARGS="${SYSCFG_BOA_ARGS}"

all_services="hostname filesystems syslog depmod modules network settime inetd portmap dropbear boa"
all_services_r="boa dropbear portmap inetd settime network modules depmod syslog filesystems hostname"

cfg_services="hostname filesystems $syslog depmod modules $network $settime $inetd $portmap $dropbear $boa"

cfg_services_r="$boa $dropbear $portmap $inetd $settime $network modules depmod $syslog filesystems hostname"

EOF


if [ "$SYSCFG_WANT_LOGIN_TTY" = "y" ]
then
    sys_login="$SYSCFG_LOGING_TTY"
else
    sys_login="T0:23:respawn:/sbin/getty -L tts0 115200 vt100"
fi
cat <<EOF > $RPM_BUILD_ROOT/%{pfx}/etc/inittab
# The default runlevel is runlevel 2.
id:2:initdefault:

# Boot-time system configuration/initialization script.
# This is run first except when booting in emergency (-b) mode.
si::sysinit:/etc/init.d/rcS

# What to do in single-user mode.
~~:S:wait:/sbin/sulogin

# /etc/init.d executes the S and K scripts upon change
# of runlevel.
#
# Runlevel 0 is halt.
# Runlevel 1 is single-user.
# Runlevels 2-5 are multi-user.
# Runlevel 6 is reboot.

l0:0:wait:/etc/init.d/rc 0
l1:1:wait:/etc/init.d/rc 1
l2:2:wait:/etc/init.d/rc 2
l6:6:wait:/etc/init.d/rc 6
# Normally not reached, but fallthrough in case of emergency.
z6:6:respawn:/bin/sh

# What to do when the power fails/returns.
pf::powerwait:/etc/init.d/powerfail start
pn::powerfailnow:/etc/init.d/powerfail now
po::powerokwait:/etc/init.d/powerfail stop

# serial port logins
$sys_login

# Video/frame buffer console, vt logins
#
#T2:2345:respawn:/sbin/getty -L tty1 38400 vt100
#T3:2345:respawn:/sbin/getty -L tty2 38400 vt100
EOF

# generate modules.conf
KERNEL_VER=`perl -e '
    foreach  ( glob("$ENV{DEV_IMAGE}/lib/modules/*") ) {
        next unless -d $_;
        if( m,/lib/modules/(\d\.\d[\S]+), ) {
            print $1;
            last;
        }
    } '`
if [ -n "$KERNEL_VER" ]
then
    mkdir -p $RPM_BUILD_ROOT/%{pfx}/lib/modules/$KERNEL_VER
    depmod.pl -b $DEV_IMAGE/lib/modules/$KERNEL_VER  -F $DEV_IMAGE/boot/System.map --stdout > $RPM_BUILD_ROOT/%{pfx}/lib/modules/$KERNEL_VER/modules.dep
fi

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
