%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Skeleton files for using SysVInit
Name            : skell-mxc
Version         : 0.4
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Steve Papacharalambous/Stuart Hughes/Alan Tull
Group           : System Environment/Utilities
Source          : %{name}-%{version}.tar.gz
Patch1          : skell-mxc-0.3-udev-0.6.patch
Patch2          : skell-mxc-0.4-1.patch
Patch3          : skell-mxc-0.4-2.patch
Patch4          : skell-mxc-0.4-3.patch
Patch5          : skell-mxc-0.4-4.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%Build
BUILD_DATE=$(date -R)
GCC_VERSION=$( gcc --version | grep 'gcc')
echo $BUILD_DATE
echo $GCC_VERSION
perl -pi -e "s,\@GCC_VERSION@,$GCC_VERSION,g" ./etc/issue
perl -pi -e "s;\@BUILD_DATE@;$BUILD_DATE;g"   ./etc/issue


%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{pfx}
cp -a * $RPM_BUILD_ROOT/%{pfx}
if [ -z "$PKG_SKELL_WANT_TERMINFO" ]
then
    rm -rf $RPM_BUILD_ROOT/%{pfx}/usr/share/terminfo
fi

ln -s /proc/mounts         $RPM_BUILD_ROOT/%{pfx}/dev/mtab

# Create links for Qt
mkdir -p $RPM_BUILD_ROOT/usr/share
ln -sfn /opt/Qtopia/etc/zoneinfo $RPM_BUILD_ROOT/usr/share/zoneinfo
ln -s /root/Settings/pointercal  $RPM_BUILD_ROOT/%{pfx}/etc/pointercal

#
# Links for the runlevels:
#
ln -s /etc/init.d/mount    $RPM_BUILD_ROOT/%{pfx}/etc/rcS.d/S30mount
ln -s /etc/init.d/udev     $RPM_BUILD_ROOT/%{pfx}/etc/rcS.d/S35udev
ln -s /etc/init.d/devlinks $RPM_BUILD_ROOT/%{pfx}/etc/rcS.d/S45devlinks
ln -s /etc/init.d/telnetd  $RPM_BUILD_ROOT/%{pfx}/etc/rcS.d/S80telnetd
ln -s /etc/init.d/localnet $RPM_BUILD_ROOT/%{pfx}/etc/rcS.d/S90localnet

ln -s /etc/init.d/halt     $RPM_BUILD_ROOT/%{pfx}/etc/rc0.d/K90halt
ln -s /etc/init.d/reboot   $RPM_BUILD_ROOT/%{pfx}/etc/rc6.d/K90reboot

#
# To boot Qt by default, uncomment this:
#
#ln -s /etc/init.d/qt       $RPM_BUILD_ROOT/%{pfx}/etc/rc2.d/S10qt


%Clean
rm -rf $RPM_BUILD_ROOT


%Files

%defattr(-,root,root)
%attr(2755,root,ftp)  %{pfx}/var/ftp/pub
%attr(1777,root,root) %{pfx}/tmp
%attr(777,root,root)  %{pfx}/var/tmp
%attr(755,root,root)  %{pfx}/etc/init.d
%{pfx}/*
