%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : qtopia palmtop environment
Name            : qtopia-free
Version         : 2.1.1
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : John Rigby
Group           : System Environment/Graphics
Source          : %{name}-source-%{version}.tar.gz
Patch0          : qtopia-free-2.1.1-mxc.patch
Patch1          : qtopia-free-2.1.1-mxc_mvtools.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup
%patch0 -p1
if [ $TOOLCHAIN_PREFIX = "arm_v6_vfp_le-" ]
then
%patch1 -p1
fi

%Build
export PLATFORM=linux-mxc-g++
export PATH=$UNSPOOF_PATH
export QTDIR=$DEV_IMAGE/opt/qt
export QPEDIR=$(pwd)
export TMAKEPATH=$TOP/bin/lib/linux-g++
export LD_LIBRARY_PATH=$DEV_IMAGE/usr/lib:$QPEDIR/lib:$LD_LIBRARY_PATH
./configure -release -xplatform linux-mxc-g++ -shared -no-qvfb -edition pda -no-qtopiadesktop -L$DEV_IMAGE/usr/lib
make


%Install
rm -rf $RPM_BUILD_ROOT
if [ ! $QPE_INSTALL_DIR ]
then
QPE_INSTALL_DIR=opt/Qtopia
fi
export QPEDIR=$(pwd)
export BUILD_DIR=$(pwd)
export QTDIR=$DEV_IMAGE/opt/qt
make install
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/apps
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/pics
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/plugins
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/docs
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/library
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/include
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/etc
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/services/qpe
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/help
install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/i18n
#install -d $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/zone
install -d $RPM_BUILD_ROOT/%{pfx}/var/lock/subsys
install -d $RPM_BUILD_ROOT/%{pfx}/home
cp -rf $BUILD_DIR/image/. $RPM_BUILD_ROOT/%{pfx}/
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher showimg)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher clock)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher todolist)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher calculator)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher addressbook)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher textedit)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher mpegplayer)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher datebook)
(cd $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/bin && ln -sf quicklauncher today)
cp -rf $BUILD_DIR/etc/zoneinfo $RPM_BUILD_ROOT/%{pfx}/$QPE_INSTALL_DIR/etc
install -d $RPM_BUILD_ROOT/%{pfx}/usr/share
ln -fs /$QPE_INSTALL_DIR/etc/zoneinfo $RPM_BUILD_ROOT/%{pfx}/usr/share/zoneinfo
#echo '1' > $RPM_BUILD_ROOT/%{pfx}/etc/firstuse


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


