%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : qt-embedded library for qtopia
Name            : qt-embedded
Version         : 2.3.10
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : John Rigby
Group           : System Environment/Libraries
Source          : %{name}-%{version}-free.tar.gz
Patch0          : qt-2.3.4-uic-binary.patch
Patch1          : qt-embedded-2.3.10-mxc.patch
Patch2          : qt-embedded-2.3.10-mxc_mvtools.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup -n qt-2.3.10
%patch0 -p0
%patch1 -p1
if [ $TOOLCHAIN_PREFIX = "arm_v6_vfp_le-" ]
then
%patch2 -p1
fi


%Build
export PATH=$UNSPOOF_PATH
touch LICENSE.GPL
export QTDIR=$(pwd)
echo yes | ./configure -I$DEV_IMAGE/usr/include -L$DEV_IMAGE/usr/lib -qconfig qpe -system-jpeg \
 -no-xft -no-opengl -no-qvfb -depths 16,24,32 -platform linux-x86-g++ -xplatform linux-mxc-g++
chmod +x bin/uic
make src-moc
export TWTOOLS_EXTRA_CFLAGS="$OPT_FLAGS -I $LINUX_HDR_DIR"
make symlinks src-mt sub-src sub-tools $EXAMPLE_OPT


%Install
rm -rf $RPM_BUILD_ROOT
if [ $EXAMPLE_OPT ]
then
	install -d $RPM_BUILD_ROOT/usr/local/qte/examples
	cp -fa examples $RPM_BUILD_ROOT/usr/local/qte/examples
fi
install -d $RPM_BUILD_ROOT/%{pfx}/dev
install -d $RPM_BUILD_ROOT/%{pfx}/usr/lib
install -d $RPM_BUILD_ROOT/%{pfx}/usr/bin
install -d $RPM_BUILD_ROOT/%{pfx}/usr/include
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/fonts
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc/sounds
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/bin
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/include
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/freetype
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/zlib
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/libpng
cp -fa lib/* $RPM_BUILD_ROOT/%{pfx}/usr/lib/
cp -fa lib/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/
cp -fa .buildopts $RPM_BUILD_ROOT/%{pfx}/opt/qt/
cp -fa bin/* $TOP/bin/
cp -f include/* $RPM_BUILD_ROOT/%{pfx}/usr/include/
cp -f include/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/include/
cp -fa lib/fonts/*  $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/fonts/
cp -fa examples/sound/sounds/*  $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc/sounds/
cp -fa src/3rdparty/freetype/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/freetype/
cp -fa src/3rdparty/zlib/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/zlib/
cp -fa src/3rdparty/libpng/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/libpng/
ln -s /opt/qt/lib/fonts $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/fonts


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(755,root,root)
%{pfx}/*


