%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : qt-embedded library for qtopia
Name            : qt-embedded
Version         : 2.3.7
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : John Rigby
Group           : System Environment/Libraries
Source          : %{name}-%{version}.tar.gz
Patch0          : qt-2.3.4-linux-native-configs.patch
Patch1          : qt-2.3.4-configure.patch
Patch2          : qt-2.3.4-qconfig-qpe.patch
Patch3          : qt-2.3.4-uic-binary.patch
Patch4          : qt-2.3.7-ppc.patch
Patch5          : qt-2.3.7-total5200ts.patch
Patch6          : qt-2.3.7-hidecursor.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup -n qt-2.3.7
%patch0 -p0
%patch1 -p1
%patch2 -p0
%patch3 -p0
%patch4 -p1
%patch5 -p1
%patch6 -p1

%Build
export PATH=$UNSPOOF_PATH
touch LICENSE.GPL
export QTDIR=$(pwd)
./configure -I$DEV_IMAGE/usr/include -L$DEV_IMAGE/usr/lib -no-thread -qconfig qpe -no-opengl -no-qvfb -depths ,16 -rgb555 -swapbytes_video -swapbytes_audio -platform linux-x86-g++ -xplatform linux-powerpc-g++
chmod +x bin/uic
make src-moc
export TWTOOLS_EXTRA_CFLAGS="$OPT_FLAGS -I $LINUX_HDR_DIR"
make symlinks src-mt sub-src sub-tools $EXAMPLE_OPT


%Install
rm -rf $RPM_BUILD_ROOT
if [ $EXAMPLE_OPT ]
then
	install -d $RPM_BUILD_ROOT/usr/local/qte/examples
	cp -fa examples $RPM_BUILD_ROOT/usr/local/qte/examples
fi
install -d $RPM_BUILD_ROOT/%{pfx}/dev
install -d $RPM_BUILD_ROOT/%{pfx}/usr/lib
install -d $RPM_BUILD_ROOT/%{pfx}/usr/bin
install -d $RPM_BUILD_ROOT/%{pfx}/usr/include
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/fonts
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc/sounds
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/bin
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/include
install -d $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/freetype
cp -fa lib/* $RPM_BUILD_ROOT/%{pfx}/usr/lib/
cp -fa lib/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/
cp -fa bin/* $TOP/bin/
cp -f include/* $RPM_BUILD_ROOT/%{pfx}/usr/include/
cp -f include/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/include/
cp -fa lib/fonts/*  $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/fonts/
cp -fa examples/sound/sounds/*  $RPM_BUILD_ROOT/%{pfx}/opt/qt/etc/sounds/
cp -fa src/3rdparty/freetype/* $RPM_BUILD_ROOT/%{pfx}/opt/qt/src/3rdparty/freetype/
ln -s /opt/qt/lib/fonts $RPM_BUILD_ROOT/%{pfx}/opt/qt/lib/fonts


%Clean
rm -rf $RPM_BUILD_ROOT


%Files
%defattr(-,root,root)
%{pfx}/*


