%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : MBX 3D driver and app
Name            : mbx-src
Version         : r1p0.00bet0
Release         : 1
License         : GPL
Vendor          : Freescale
Packager        : Yi Li
Group           : System/Servers
Source          : %{name}-%{version}.tar.gz
Patch1          : mbx-src-r1p0.00bet0-1144705227.patch
Patch2          : mbx-src-r1p0.00bet0-modpath.patch
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
This package provides proprietary kernel modules, libraries, and
test code source from the MBX OpenGL ES (GX200) DDK. The Linux OpenGL ES
DDK implements OpenGL-ES for MBX and variants along with 2D acceleration
via MBX within the Linux operating system. The target kernel version for
the DDK is Linux 2.6. The OpenGL-ES driver is ported from the reference
OpenGL-ES for MBX and variants. Hardware 2D acceleration is achieved
implementing the freedesktop.org KDrive X server in terms of the PVR2D
loadable module for MBX.

%{summary}

%Prep
%setup 
%patch1 -p1
%patch2 -p1

%Build
export MBX_HOME=$PWD
export DISCIMAGE=$PWD
if [ -z "$PKG_KERNEL_KBUILD_PRECONFIG" ]
then
      export MBXKBUILDOUTPUT=$PWD/../linux-2.6.10
      export KERNELDIR=$PWD/../linux-2.6.10
      export KERNELINCDIR=$DEV_IMAGE/usr/src/linux
else
      export KERNELDIR=$PKG_KERNEL_PATH_PRECONFIG
      MBXKBUILDOUTPUT="$(eval echo ${PKG_KERNEL_KBUILD_PRECONFIG})"
      export MBXKBUILDOUTPUT=${MBXKBUILDOUTPUT}
      export KERNELINCDIR=$DEV_IMAGE/usr/src/linux
fi

export PVR_CONSUMER_ROOT=${MBX_HOME}/GX200-BU-98000-r1p0-00bet0/Software/OpenGLES/Linux/embedded

# build the libraries, kernel modules and tests

cd ${PVR_CONSUMER_ROOT}/build/arm_mbxlite_linux
make 

# change directory to the release folder
cd ${PVR_CONSUMER_ROOT}/binary_arm_mbxlite_linux_release/

# call a script to install the libraries, modules and tests in the 
# correct location in the filesystem
mkdir -p $DISCIMAGE/lib/modules/2.6.10_dev
./install.sh -v --no-x

%Install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{pfx}
cp -a usr etc lib $RPM_BUILD_ROOT/%{pfx}

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(755,root,root)
%{pfx}/*
