%define pfx /opt/freescale/rootfs/%{_target_cpu}

Summary         : Userspace IPsec tools for the Linux IPsec implementation
Name            : ipsec-tools
Version         : 0.6.4
Release         : 1
License         : BSD
Vendor          : Freescale
Packager        : Stuart Hughes
Group           : System Environment/Base
Source          : %{name}-%{version}.tar.bz2
BuildRoot       : %{_tmppath}/%{name}
Prefix          : %{pfx}

%Description
%{summary}

%Prep
%setup 

%Build
export X_DIR=`echo $TOOLCHAIN_PREFIX | sed -e 's,-$,,'`
export TC_PREFIX="`which ${TOOLCHAIN_PREFIX}gcc | perl -p -e 's,/bin/'${TOOLCHAIN_PREFIX}'gcc,,'`"
LIN_SERIES=`perl -e '
    foreach $path ("$ENV{TC_PREFIX}/$ENV{X_DIR}/include/linux/version.h",
                   "$ENV{TC_PREFIX}/include/linux/version.h") {
        if(-f $path) {
            warn "found $path";
            @ARGV = ($path);
            last;
        }
    }
    warn("Cannot find version.h\n"), exit(1) unless @ARGV;
    while(<>) {
        m,UTS_RELEASE\s+"2\.(\d), && do { print $1; exit(0) };
    }'`
if [ "$LIN_SERIES" = "4" ]
then
    KHDR=$DEV_IMAGE/usr/src/linux/include
else
    KHDR=${TC_PREFIX}/${X_DIR}/include
fi

CFLAGS="-isystem ${TC_PREFIX}/${X_DIR}/include" \
./configure --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} \
            --host=$CFGHOST --build=%{_build} \
            --with-kernel-headers=$KHDR \
            --mandir=%{_mandir}
make

%Install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT/%{pfx}
rm -f $RPM_BUILD_ROOT/%{pfx}/%{_prefix}/lib/*.la

%Clean
rm -rf $RPM_BUILD_ROOT

%Files
%defattr(-,root,root)
%{pfx}/*
